unit openssl3.provider.common.provider_err;

interface
uses OpenSSL.Api;

function ossl_err_load_PROV_strings:integer;

var
  PROV_str_reasons: array of TERR_STRING_DATA;

implementation
uses OpenSSL3.Err;


function ossl_err_load_PROV_strings:integer;
begin
{$IFNDEF OPENSSL_NO_ERR}
    if ERR_reason_error_string(PROV_str_reasons[0].error) = nil  then
        ERR_load_strings_const(@PROV_str_reasons);
{$ENDIF}
    Result := 1;
end;

initialization
   PROV_str_reasons := [
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_ADDITIONAL_INPUT_TOO_LONG),
    'additional input too long'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_ALGORITHM_MISMATCH),
    'algorithm mismatch'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_ALREADY_INSTANTIATED),
    'already instantiated'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_BAD_DECRYPT), 'bad decrypt'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_BAD_ENCODING), 'bad encoding'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_BAD_LENGTH), 'bad length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_BAD_TLS_CLIENT_VERSION),
    'bad tls client version'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_BN_ERROR), 'bn error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_CIPHER_OPERATION_FAILED),
    'cipher operation failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_DERIVATION_FUNCTION_INIT_FAILED),
    'derivation function init failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_DIGEST_NOT_ALLOWED),
    'digest not allowed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_ENTROPY_SOURCE_STRENGTH_TOO_WEAK),
    'entropy source strength too weak'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_ERROR_INSTANTIATING_DRBG),
    'error instantiating drbg'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_ERROR_RETRIEVING_ENTROPY),
    'error retrieving entropy'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_ERROR_RETRIEVING_NONCE),
    'error retrieving nonce'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FAILED_DURING_DERIVATION),
    'failed during derivation'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FAILED_TO_CREATE_LOCK),
    'failed to create lock'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FAILED_TO_DECRYPT), 'failed to decrypt'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FAILED_TO_GENERATE_KEY),
    'failed to generate key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FAILED_TO_GET_PARAMETER),
    'failed to get parameter'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FAILED_TO_SET_PARAMETER),
    'failed to set parameter'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FAILED_TO_SIGN), 'failed to sign'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FIPS_MODULE_CONDITIONAL_ERROR),
    'fips module conditional error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FIPS_MODULE_ENTERING_ERROR_STATE),
    'fips module entering error state'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_FIPS_MODULE_IN_ERROR_STATE),
    'fips module in error state'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_GENERATE_ERROR), 'generate error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_ILLEGAL_OR_UNSUPPORTED_PADDING_MODE),
    'illegal or unsupported padding mode'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INDICATOR_INTEGRITY_FAILURE),
    'indicator integrity failure'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INSUFFICIENT_DRBG_STRENGTH),
    'insufficient drbg strength'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_AAD), 'invalid aad'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_CONFIG_DATA),
    'invalid config data'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_CONSTANT_LENGTH),
    'invalid constant length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_CURVE), 'invalid curve'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_CUSTOM_LENGTH),
    'invalid custom length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_DATA), 'invalid data'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_DIGEST), 'invalid digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_DIGEST_LENGTH),
    'invalid digest length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_DIGEST_SIZE),
    'invalid digest size'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_INPUT_LENGTH),
    'invalid input length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_ITERATION_COUNT),
    'invalid iteration count'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_IV_LENGTH), 'invalid iv length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_KEY), 'invalid key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_KEY_LENGTH),
    'invalid key length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_MAC), 'invalid mac'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_MGF1_MD), 'invalid mgf1 md'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_MODE), 'invalid mode'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_OUTPUT_LENGTH),
    'invalid output length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_PADDING_MODE),
    'invalid padding mode'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_PUBINFO), 'invalid pubinfo'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_SALT_LENGTH),
    'invalid salt length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_SEED_LENGTH),
    'invalid seed length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_SIGNATURE_SIZE),
    'invalid signature size'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_STATE), 'invalid state'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_TAG), 'invalid tag'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_TAG_LENGTH),
    'invalid tag length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_UKM_LENGTH),
    'invalid ukm length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_INVALID_X931_DIGEST),
    'invalid x931 digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_IN_ERROR_STATE), 'in error state'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_KEY_SETUP_FAILED), 'key setup failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_KEY_SIZE_TOO_SMALL),
    'key size too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_LENGTH_TOO_LARGE), 'length too large'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISMATCHING_DOMAIN_PARAMETERS),
    'mismatching domain parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_CEK_ALG), 'missing cek alg'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_CIPHER), 'missing cipher'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_CONFIG_DATA),
    'missing config data'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_CONSTANT), 'missing constant'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_KEY), 'missing key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_MAC), 'missing mac'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_MESSAGE_DIGEST),
    'missing message digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_OID), 'missing OID'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_PASS), 'missing pass'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_SALT), 'missing salt'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_SECRET), 'missing secret'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_SEED), 'missing seed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_SESSION_ID),
    'missing session id'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_TYPE), 'missing type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MISSING_XCGHASH), 'missing xcghash'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_MODULE_INTEGRITY_FAILURE),
    'module integrity failure'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_NOT_A_PRIVATE_KEY), 'not a private key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_NOT_A_PUBLIC_KEY), 'not a public key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_NOT_INSTANTIATED), 'not instantiated'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_NOT_PARAMETERS), 'not parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_NOT_SUPPORTED), 'not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_NOT_XOF_OR_INVALID_LENGTH),
    'not xof or invalid length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_NO_KEY_SET), 'no key set'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_NO_PARAMETERS_SET), 'no parameters set'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE),
    'operation not supported for this keytype'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_OUTPUT_BUFFER_TOO_SMALL),
    'output buffer too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_PARENT_CANNOT_GENERATE_RANDOM_NUMBERS),
    'parent cannot generate random numbers'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_PARENT_CANNOT_SUPPLY_ENTROPY_SEED),
    'parent cannot supply entropy seed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_PARENT_LOCKING_NOT_ENABLED),
    'parent locking not enabled'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_PARENT_STRENGTH_TOO_WEAK),
    'parent strength too weak'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_PATH_MUST_BE_ABSOLUTE),
    'path must be absolute'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_PERSONALISATION_STRING_TOO_LONG),
    'personalisation string too long'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_PSS_SALTLEN_TOO_SMALL),
    'pss saltlen too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_REQUEST_TOO_LARGE_FOR_DRBG),
    'request too large for drbg'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_REQUIRE_CTR_MODE_CIPHER),
    'require ctr mode cipher'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_RESEED_ERROR), 'reseed error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_SEARCH_ONLY_SUPPORTED_FOR_DIRECTORIES),
    'search only supported for directories'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_SEED_SOURCES_MUST_NOT_HAVE_A_PARENT),
    'seed sources must not have a parent'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_SELF_TEST_KAT_FAILURE),
    'self test kat failure'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_SELF_TEST_POST_FAILURE),
    'self test post failure'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_TAG_NOT_NEEDED), 'tag not needed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_TAG_NOT_SET), 'tag not set'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_TOO_MANY_RECORDS), 'too many records'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNABLE_TO_FIND_CIPHERS),
    'unable to find ciphers'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNABLE_TO_GET_PARENT_STRENGTH),
    'unable to get parent strength'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNABLE_TO_GET_PASSPHRASE),
    'unable to get passphrase'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNABLE_TO_INITIALISE_CIPHERS),
    'unable to initialise ciphers'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNABLE_TO_LOAD_SHA256),
    'unable to load sha256'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNABLE_TO_LOCK_PARENT),
    'unable to lock parent'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNABLE_TO_RESEED), 'unable to reseed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNSUPPORTED_CEK_ALG),
    'unsupported cek alg'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNSUPPORTED_KEY_SIZE),
    'unsupported key size'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNSUPPORTED_MAC_TYPE),
    'unsupported mac type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_UNSUPPORTED_NUMBER_OF_ROUNDS),
    'unsupported number of rounds'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_URI_AUTHORITY_UNSUPPORTED),
    'uri authority unsupported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_VALUE_ERROR), 'value error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_WRONG_FINAL_BLOCK_LENGTH),
    'wrong final block length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_WRONG_OUTPUT_BUFFER_SIZE),
    'wrong output buffer size'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_XOF_DIGESTS_NOT_ALLOWED),
    'xof digests not allowed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_XTS_DATA_UNIT_IS_TOO_LARGE),
    'xts data unit is too large'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_PROV, 0, PROV_R_XTS_DUPLICATED_KEYS),
    'xts duplicated keys'),
    get_ERR_STRING_DATA(0, nil)
];


end.
