unit openssl3.crypto.x509.v3err;

interface
uses OpenSSL.Api;

 function ossl_err_load_X509V3_strings:integer;
 var
    X509V3_str_reasons: array of TERR_STRING_DATA;

implementation
uses OpenSSL3.Err;

function ossl_err_load_X509V3_strings:integer;
begin
{$IFNDEF OPENSSL_NO_ERR}
    if ERR_reason_error_string(X509V3_str_reasons[0].error ) = nil then
        ERR_load_strings_const(@X509V3_str_reasons);
{$ENDIF}
    Result := 1;
end;

initialization
  X509V3_str_reasons := [
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BAD_IP_ADDRESS), 'bad ip address'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BAD_OBJECT), 'bad object'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BAD_OPTION), 'bad option'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BAD_VALUE), 'bad value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BN_DEC2BN_ERROR), 'bn dec2bn error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BN_TO_ASN1_INTEGER_ERROR),
    'bn to asn1 integer error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_DIRNAME_ERROR), 'dirname error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_DISTPOINT_ALREADY_SET),
    'distpoint already set'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_DUPLICATE_ZONE_ID),
    'duplicate zone id'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EMPTY_KEY_USAGE), 'empty key usage'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ERROR_CONVERTING_ZONE),
    'error converting zone'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ERROR_CREATING_EXTENSION),
    'error creating extension'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ERROR_IN_EXTENSION),
    'error in extension'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXPECTED_A_SECTION_NAME),
    'expected a section name'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_EXISTS),
    'extension exists'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_NAME_ERROR),
    'extension name error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_NOT_FOUND),
    'extension not found'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_SETTING_NOT_SUPPORTED),
    'extension setting not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_VALUE_ERROR),
    'extension value error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ILLEGAL_EMPTY_EXTENSION),
    'illegal empty extension'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INCORRECT_POLICY_SYNTAX_TAG),
    'incorrect policy syntax tag'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_ASNUMBER),
    'invalid asnumber'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_ASRANGE), 'invalid asrange'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_BOOLEAN_STRING),
    'invalid boolean string'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_CERTIFICATE),
    'invalid certificate'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_EMPTY_NAME),
    'invalid empty name'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_EXTENSION_STRING),
    'invalid extension string'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_INHERITANCE),
    'invalid inheritance'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_IPADDRESS),
    'invalid ipaddress'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_MULTIPLE_RDNS),
    'invalid multiple rdns'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NAME), 'invalid name'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NULL_ARGUMENT),
    'invalid null argument'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NULL_VALUE),
    'invalid null value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NUMBER), 'invalid number'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NUMBERS), 'invalid numbers'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_OBJECT_IDENTIFIER),
    'invalid object identifier'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_OPTION), 'invalid option'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_POLICY_IDENTIFIER),
    'invalid policy identifier'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_PROXY_POLICY_SETTING),
    'invalid proxy policy setting'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_PURPOSE), 'invalid purpose'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_SAFI), 'invalid safi'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_SECTION), 'invalid section'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_SYNTAX), 'invalid syntax'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ISSUER_DECODE_ERROR),
    'issuer decode error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_MISSING_VALUE), 'missing value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NEED_ORGANIZATION_AND_NUMBERS),
    'need organization and numbers'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NEGATIVE_PATHLEN),
    'negative pathlen'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_CONFIG_DATABASE),
    'no config database'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_ISSUER_CERTIFICATE),
    'no issuer certificate'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_ISSUER_DETAILS),
    'no issuer details'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_POLICY_IDENTIFIER),
    'no policy identifier'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED),
    'no proxy cert policy language defined'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_PUBLIC_KEY), 'no public key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_SUBJECT_DETAILS),
    'no subject details'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_OPERATION_NOT_DEFINED),
    'operation not defined'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_OTHERNAME_ERROR), 'othername error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_POLICY_LANGUAGE_ALREADY_DEFINED),
    'policy language already defined'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_POLICY_PATH_LENGTH),
    'policy path length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_POLICY_PATH_LENGTH_ALREADY_DEFINED),
    'policy path length already defined'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY),
    'policy when proxy language requires no policy'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_SECTION_NOT_FOUND),
    'section not found'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNABLE_TO_GET_ISSUER_DETAILS),
    'unable to get issuer details'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNABLE_TO_GET_ISSUER_KEYID),
    'unable to get issuer keyid'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNKNOWN_BIT_STRING_ARGUMENT),
    'unknown bit string argument'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNKNOWN_EXTENSION),
    'unknown extension'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNKNOWN_EXTENSION_NAME),
    'unknown extension name'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNKNOWN_OPTION), 'unknown option'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNKNOWN_VALUE), 'unknown value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNSUPPORTED_OPTION),
    'unsupported option'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNSUPPORTED_TYPE),
    'unsupported type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_USER_TOO_LONG), 'user too long'),
    get_ERR_STRING_DATA(0, nil)
];
end.
