unit openssl3.crypto.rsa.rsa_err;

interface
uses OpenSSL.Api;

function ossl_err_load_RSA_strings:integer;

var
   RSA_str_reasons: array of TERR_STRING_DATA;

implementation
uses OpenSSL3.Err;

function ossl_err_load_RSA_strings:integer;
begin
{$IFNDEF OPENSSL_NO_ERR}
    if ERR_reason_error_string(RSA_str_reasons[0].error ) = nil then
        ERR_load_strings_const(@RSA_str_reasons);
{$ENDIF}
    Result := 1;
end;

initialization
  RSA_str_reasons := [
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_ALGORITHM_MISMATCH), 'algorithm mismatch'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_BAD_E_VALUE), 'bad e value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_BAD_FIXED_HEADER_DECRYPT),
    'bad fixed header decrypt'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_BAD_PAD_BYTE_COUNT), 'bad pad byte count'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_BAD_SIGNATURE), 'bad signature'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_BLOCK_TYPE_IS_NOT_01), 'block type is not 01'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_BLOCK_TYPE_IS_NOT_02), 'block type is not 02'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DATA_GREATER_THAN_MOD_LEN), 'data greater than mod len'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DATA_TOO_LARGE), 'data too large'),
  	get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE), 'data too large for key size'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DATA_TOO_LARGE_FOR_MODULUS), 'data too large for modulus'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DATA_TOO_SMALL), 'data too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DATA_TOO_SMALL_FOR_KEY_SIZE), 'data too small for key size'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DIGEST_DOES_NOT_MATCH), 'digest does not match'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DIGEST_NOT_ALLOWED), 'digest not allowed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY), 'digest too big for rsa key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DMP1_NOT_CONGRUENT_TO_D), 'dmp1 not congruent to d'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_DMQ1_NOT_CONGRUENT_TO_D), 'dmq1 not congruent to d'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_D_E_NOT_CONGRUENT_TO_1), 'd e not congruent to 1'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_FIRST_OCTET_INVALID), 'first octet invalid'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_ILLEGAL_OR_UNSUPPORTED_PADDING_MODE), 'illegal or unsupported padding mode'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_DIGEST), 'invalid digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_DIGEST_LENGTH), 'invalid digest length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_HEADER), 'invalid header'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_KEYPAIR), 'invalid keypair'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_KEY_LENGTH), 'invalid key length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_LABEL), 'invalid label'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_LENGTH), 'invalid length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_MESSAGE_LENGTH), 'invalid message length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_MGF1_MD), 'invalid mgf1 md'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_MODULUS), 'invalid modulus'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_MULTI_PRIME_KEY), 'invalid multi prime key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_OAEP_PARAMETERS),
    'invalid oaep parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_PADDING), 'invalid padding'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_PADDING_MODE),
    'invalid padding mode'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_PSS_PARAMETERS),
    'invalid pss parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_PSS_SALTLEN),
    'invalid pss saltlen'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_REQUEST), 'invalid request'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_SALT_LENGTH),
    'invalid salt length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_STRENGTH), 'invalid strength'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_TRAILER), 'invalid trailer'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_INVALID_X931_DIGEST),
    'invalid x931 digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_IQMP_NOT_INVERSE_OF_Q),
    'iqmp not inverse of q'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_KEY_PRIME_NUM_INVALID),
    'key prime num invalid'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_KEY_SIZE_TOO_SMALL), 'key size too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_LAST_OCTET_INVALID), 'last octet invalid'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_MGF1_DIGEST_NOT_ALLOWED),
    'mgf1 digest not allowed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_MISSING_PRIVATE_KEY),
    'missing private key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_MODULUS_TOO_LARGE), 'modulus too large'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_MP_COEFFICIENT_NOT_INVERSE_OF_R),
    'mp coefficient not inverse of r'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_MP_EXPONENT_NOT_CONGRUENT_TO_D),
    'mp exponent not congruent to d'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_MP_R_NOT_PRIME), 'mp r not prime'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_NO_PUBLIC_EXPONENT), 'no public exponent'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_NULL_BEFORE_BLOCK_MISSING),
    'null before block missing'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_N_DOES_NOT_EQUAL_PRODUCT_OF_PRIMES),
    'n does not equal product of primes'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_N_DOES_NOT_EQUAL_P_Q),
    'n does not equal p q'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_OAEP_DECODING_ERROR),
    'oaep decoding error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE),
    'operation not supported for this keytype'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_PADDING_CHECK_FAILED),
    'padding check failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_PAIRWISE_TEST_FAILURE),
    'pairwise test failure'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_PKCS_DECODING_ERROR),
    'pkcs decoding error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_PSS_SALTLEN_TOO_SMALL),
    'pss saltlen too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_PUB_EXPONENT_OUT_OF_RANGE),
    'pub exponent out of range'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_P_NOT_PRIME), 'p not prime'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_Q_NOT_PRIME), 'q not prime'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_RANDOMNESS_SOURCE_STRENGTH_INSUFFICIENT),
    'randomness source strength insufficient'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_RSA_OPERATIONS_NOT_SUPPORTED),
    'rsa operations not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_SLEN_CHECK_FAILED),
    'salt length check failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_SLEN_RECOVERY_FAILED),
    'salt length recovery failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_SSLV3_ROLLBACK_ATTACK),
    'sslv3 rollback attack'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD),
    'the asn1 object identifier is not known for this md'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_UNKNOWN_ALGORITHM_TYPE),
    'unknown algorithm type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_UNKNOWN_DIGEST), 'unknown digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_UNKNOWN_MASK_DIGEST),
    'unknown mask digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_UNKNOWN_PADDING_TYPE),
    'unknown padding type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_UNSUPPORTED_ENCRYPTION_TYPE),
    'unsupported encryption type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_UNSUPPORTED_LABEL_SOURCE),
    'unsupported label source'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_UNSUPPORTED_MASK_ALGORITHM),
    'unsupported mask algorithm'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_UNSUPPORTED_MASK_PARAMETER),
    'unsupported mask parameter'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_UNSUPPORTED_SIGNATURE_TYPE),
    'unsupported signature type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_VALUE_MISSING), 'value missing'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_RSA, 0, RSA_R_WRONG_SIGNATURE_LENGTH),
    'wrong signature length'),
    get_ERR_STRING_DATA(0, nil)
];
end.
