unit openssl3.crypto.evp.evp_err;

interface
uses OpenSSL.Api;

function ossl_err_load_EVP_strings:integer;

var
  EVP_str_reasons:  array of TERR_STRING_DATA;

implementation
uses OpenSSL3.Err;

function ossl_err_load_EVP_strings:integer;
begin
{$IFNDEF OPENSSL_NO_ERR}
    if ERR_reason_error_string(EVP_str_reasons[0].error) = nil  then
        ERR_load_strings_const(@EVP_str_reasons);
{$ENDIF}
    Result := 1;
end;

initialization
  EVP_str_reasons := [
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_AES_KEY_SETUP_FAILED),
    'aes key setup failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_ARIA_KEY_SETUP_FAILED),
    'aria key setup failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_BAD_ALGORITHM_NAME), 'bad algorithm name'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_BAD_DECRYPT), 'bad decrypt'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_BAD_KEY_LENGTH), 'bad key length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_BUFFER_TOO_SMALL), 'buffer too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_CACHE_CONSTANTS_FAILED),
    'cache constants failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_CAMELLIA_KEY_SETUP_FAILED),
    'camellia key setup failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_CANNOT_GET_PARAMETERS),
    'cannot get parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_CANNOT_SET_PARAMETERS),
    'cannot set parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_CIPHER_NOT_GCM_MODE),
    'cipher not gcm mode'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_CIPHER_PARAMETER_ERROR),
    'cipher parameter error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_COMMAND_NOT_SUPPORTED),
    'command not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_CONFLICTING_ALGORITHM_NAME),
    'conflicting algorithm name'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_COPY_ERROR), 'copy error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_CTRL_NOT_IMPLEMENTED),
    'ctrl not implemented'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED),
    'ctrl operation not implemented'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH),
    'data not multiple of block length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_DECODE_ERROR), 'decode error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_DEFAULT_QUERY_PARSE_ERROR),
    'default query parse error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_DIFFERENT_KEY_TYPES),
    'different key types'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_DIFFERENT_PARAMETERS),
    'different parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_ERROR_LOADING_SECTION),
    'error loading section'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_EXPECTING_AN_HMAC_KEY),
    'expecting an hmac key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_EXPECTING_AN_RSA_KEY),
    'expecting an rsa key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_EXPECTING_A_DH_KEY), 'expecting a dh key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_EXPECTING_A_DSA_KEY),
    'expecting a dsa key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_EXPECTING_A_ECX_KEY),
    'expecting an ecx key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_EXPECTING_A_EC_KEY), 'expecting an ec key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_EXPECTING_A_POLY1305_KEY),
    'expecting a poly1305 key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_EXPECTING_A_SIPHASH_KEY),
    'expecting a siphash key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_FINAL_ERROR), 'final error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_GENERATE_ERROR), 'generate error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_GET_RAW_KEY_FAILED), 'get raw key failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_ILLEGAL_SCRYPT_PARAMETERS),
    'illegal scrypt parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INACCESSIBLE_DOMAIN_PARAMETERS),
    'inaccessible domain parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INACCESSIBLE_KEY), 'inaccessible key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INITIALIZATION_ERROR),
    'initialization error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INPUT_NOT_INITIALIZED),
    'input not initialized'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_CUSTOM_LENGTH),
    'invalid custom length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_DIGEST), 'invalid digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_IV_LENGTH), 'invalid iv length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_KEY), 'invalid key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_KEY_LENGTH), 'invalid key length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_LENGTH), 'invalid length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_NULL_ALGORITHM),
    'invalid null algorithm'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_OPERATION), 'invalid operation'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_PROVIDER_FUNCTIONS),
    'invalid provider functions'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_SALT_LENGTH),
    'invalid salt length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_SECRET_LENGTH),
    'invalid secret length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_SEED_LENGTH),
    'invalid seed length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_INVALID_VALUE), 'invalid value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_KEYMGMT_EXPORT_FAILURE),
    'keymgmt export failure'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_KEY_SETUP_FAILED), 'key setup failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_LOCKING_NOT_SUPPORTED),
    'locking not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_MEMORY_LIMIT_EXCEEDED),
    'memory limit exceeded'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_MESSAGE_DIGEST_IS_NULL),
    'message digest is null'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_METHOD_NOT_SUPPORTED),
    'method not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_MISSING_PARAMETERS), 'missing parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NOT_ABLE_TO_COPY_CTX),
    'not able to copy ctx'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NOT_XOF_OR_INVALID_LENGTH),
    'not XOF or invalid length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NO_CIPHER_SET), 'no cipher set'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NO_DEFAULT_DIGEST), 'no default digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NO_DIGEST_SET), 'no digest set'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NO_IMPORT_FUNCTION), 'no import function'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NO_KEYMGMT_AVAILABLE),
    'no keymgmt available'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NO_KEYMGMT_PRESENT), 'no keymgmt present'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NO_KEY_SET), 'no key set'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NO_OPERATION_SET), 'no operation set'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_NULL_MAC_PKEY_CTX), 'null mac pkey ctx'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_ONLY_ONESHOT_SUPPORTED),
    'only oneshot supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_OPERATION_NOT_INITIALIZED),
    'operation not initialized'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE),
    'operation not supported for this keytype'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_OUTPUT_WOULD_OVERFLOW),
    'output would overflow'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_PARAMETER_TOO_LARGE),
    'parameter too large'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_PARTIALLY_OVERLAPPING),
    'partially overlapping buffers'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_PBKDF2_ERROR), 'pbkdf2 error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_PKEY_APPLICATION_ASN1_METHOD_ALREADY_REGISTERED),
    'pkey application asn1 method already registered'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_PRIVATE_KEY_DECODE_ERROR),
    'private key decode error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_PRIVATE_KEY_ENCODE_ERROR),
    'private key encode error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_PUBLIC_KEY_NOT_RSA), 'public key not rsa'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_SETTING_XOF_FAILED), 'setting xof failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_SET_DEFAULT_PROPERTY_FAILURE),
    'set default property failure'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_TOO_MANY_RECORDS), 'too many records'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNABLE_TO_ENABLE_LOCKING),
    'unable to enable locking'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNABLE_TO_GET_MAXIMUM_REQUEST_SIZE),
    'unable to get maximum request size'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNABLE_TO_GET_RANDOM_STRENGTH),
    'unable to get random strength'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNABLE_TO_LOCK_CONTEXT),
    'unable to lock context'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNABLE_TO_SET_CALLBACKS),
    'unable to set callbacks'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNKNOWN_CIPHER), 'unknown cipher'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNKNOWN_DIGEST), 'unknown digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNKNOWN_KEY_TYPE), 'unknown key type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNKNOWN_OPTION), 'unknown option'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNKNOWN_PBE_ALGORITHM),
    'unknown pbe algorithm'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_ALGORITHM),
    'unsupported algorithm'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_CIPHER), 'unsupported cipher'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_KEYLENGTH),
    'unsupported keylength'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION),
    'unsupported key derivation function'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_KEY_SIZE),
    'unsupported key size'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_KEY_TYPE),
    'unsupported key type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_NUMBER_OF_ROUNDS),
    'unsupported number of rounds'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_PRF), 'unsupported prf'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM),
    'unsupported private key algorithm'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UNSUPPORTED_SALT_TYPE),
    'unsupported salt type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_UPDATE_ERROR), 'update error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_WRAP_MODE_NOT_ALLOWED),
    'wrap mode not allowed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_WRONG_FINAL_BLOCK_LENGTH),
    'wrong final block length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_XTS_DATA_UNIT_IS_TOO_LARGE),
    'xts data unit is too large'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_EVP, 0, EVP_R_XTS_DUPLICATED_KEYS),
    'xts duplicated keys'),
    get_ERR_STRING_DATA(0, nil)
];

end.
