unit openssl3.crypto.des.des_local;

interface
uses OpenSSL.Api, {$IFDEF MSWINDOWS}libc.win,{$ENDIF} Types;

const
   DES_SPtrans: array[0..7, 0..63] of DES_LONG = (
    (
        (* nibble 0 *)
        $02080800, $00080000, $02000002, $02080802,
        $02000000, $00080802, $00080002, $02000002,
        $00080802, $02080800, $02080000, $00000802,
        $02000802, $02000000, $00000000, $00080002,
        $00080000, $00000002, $02000800, $00080800,
        $02080802, $02080000, $00000802, $02000800,
        $00000002, $00000800, $00080800, $02080002,
        $00000800, $02000802, $02080002, $00000000,
        $00000000, $02080802, $02000800, $00080002,
        $02080800, $00080000, $00000802, $02000800,
        $02080002, $00000800, $00080800, $02000002,
        $00080802, $00000002, $02000002, $02080000,
        $02080802, $00080800, $02080000, $02000802,
        $02000000, $00000802, $00080002, $00000000,
        $00080000, $02000000, $02000802, $02080800,
        $00000002, $02080002, $00000800, $00080802)
    ,
    (
        (* nibble 1 *)
        $40108010, $00000000, $00108000, $40100000,
        $40000010, $00008010, $40008000, $00108000,
        $00008000, $40100010, $00000010, $40008000,
        $00100010, $40108000, $40100000, $00000010,
        $00100000, $40008010, $40100010, $00008000,
        $00108010, $40000000, $00000000, $00100010,
        $40008010, $00108010, $40108000, $40000010,
        $40000000, $00100000, $00008010, $40108010,
        $00100010, $40108000, $40008000, $00108010,
        $40108010, $00100010, $40000010, $00000000,
        $40000000, $00008010, $00100000, $40100010,
        $00008000, $40000000, $00108010, $40008010,
        $40108000, $00008000, $00000000, $40000010,
        $00000010, $40108010, $00108000, $40100000,
        $40100010, $00100000, $00008010, $40008000,
        $40008010, $00000010, $40100000, $00108000)
    ,
    (
        (* nibble 2 *)
        $04000001, $04040100, $00000100, $04000101,
        $00040001, $04000000, $04000101, $00040100,
        $04000100, $00040000, $04040000, $00000001,
        $04040101, $00000101, $00000001, $04040001,
        $00000000, $00040001, $04040100, $00000100,
        $00000101, $04040101, $00040000, $04000001,
        $04040001, $04000100, $00040101, $04040000,
        $00040100, $00000000, $04000000, $00040101,
        $04040100, $00000100, $00000001, $00040000,
        $00000101, $00040001, $04040000, $04000101,
        $00000000, $04040100, $00040100, $04040001,
        $00040001, $04000000, $04040101, $00000001,
        $00040101, $04000001, $04000000, $04040101,
        $00040000, $04000100, $04000101, $00040100,
        $04000100, $00000000, $04040001, $00000101,
        $04000001, $00040101, $00000100, $04040000)
    ,
    (
        (* nibble 3 *)
        $00401008, $10001000, $00000008, $10401008,
        $00000000, $10400000, $10001008, $00400008,
        $10401000, $10000008, $10000000, $00001008,
        $10000008, $00401008, $00400000, $10000000,
        $10400008, $00401000, $00001000, $00000008,
        $00401000, $10001008, $10400000, $00001000,
        $00001008, $00000000, $00400008, $10401000,
        $10001000, $10400008, $10401008, $00400000,
        $10400008, $00001008, $00400000, $10000008,
        $00401000, $10001000, $00000008, $10400000,
        $10001008, $00000000, $00001000, $00400008,
        $00000000, $10400008, $10401000, $00001000,
        $10000000, $10401008, $00401008, $00400000,
        $10401008, $00000008, $10001000, $00401008,
        $00400008, $00401000, $10400000, $10001008,
        $00001008, $10000000, $10000008, $10401000)
    ,
    (
        (* nibble 4 *)
        $08000000, $00010000, $00000400, $08010420,
        $08010020, $08000400, $00010420, $08010000,
        $00010000, $00000020, $08000020, $00010400,
        $08000420, $08010020, $08010400, $00000000,
        $00010400, $08000000, $00010020, $00000420,
        $08000400, $00010420, $00000000, $08000020,
        $00000020, $08000420, $08010420, $00010020,
        $08010000, $00000400, $00000420, $08010400,
        $08010400, $08000420, $00010020, $08010000,
        $00010000, $00000020, $08000020, $08000400,
        $08000000, $00010400, $08010420, $00000000,
        $00010420, $08000000, $00000400, $00010020,
        $08000420, $00000400, $00000000, $08010420,
        $08010020, $08010400, $00000420, $00010000,
        $00010400, $08010020, $08000400, $00000420,
        $00000020, $00010420, $08010000, $08000020)
    ,
    (
        (* nibble 5 *)
        $80000040, $00200040, $00000000, $80202000,
        $00200040, $00002000, $80002040, $00200000,
        $00002040, $80202040, $00202000, $80000000,
        $80002000, $80000040, $80200000, $00202040,
        $00200000, $80002040, $80200040, $00000000,
        $00002000, $00000040, $80202000, $80200040,
        $80202040, $80200000, $80000000, $00002040,
        $00000040, $00202000, $00202040, $80002000,
        $00002040, $80000000, $80002000, $00202040,
        $80202000, $00200040, $00000000, $80002000,
        $80000000, $00002000, $80200040, $00200000,
        $00200040, $80202040, $00202000, $00000040,
        $80202040, $00202000, $00200000, $80002040,
        $80000040, $80200000, $00202040, $00000000,
        $00002000, $80000040, $80002040, $80202000,
        $80200000, $00002040, $00000040, $80200040)
    ,
    (
        (* nibble 6 *)
        $00004000, $00000200, $01000200, $01000004,
        $01004204, $00004004, $00004200, $00000000,
        $01000000, $01000204, $00000204, $01004000,
        $00000004, $01004200, $01004000, $00000204,
        $01000204, $00004000, $00004004, $01004204,
        $00000000, $01000200, $01000004, $00004200,
        $01004004, $00004204, $01004200, $00000004,
        $00004204, $01004004, $00000200, $01000000,
        $00004204, $01004000, $01004004, $00000204,
        $00004000, $00000200, $01000000, $01004004,
        $01000204, $00004204, $00004200, $00000000,
        $00000200, $01000004, $00000004, $01000200,
        $00000000, $01000204, $01000200, $00004200,
        $00000204, $00004000, $01004204, $01000000,
        $01004200, $00000004, $00004004, $01004204,
        $01000004, $01004200, $01004000, $00004004)
    ,
    (
        (* nibble 7 *)
        $20800080, $20820000, $00020080, $00000000,
        $20020000, $00800080, $20800000, $20820080,
        $00000080, $20000000, $00820000, $00020080,
        $00820080, $20020080, $20000080, $20800000,
        $00020000, $00820080, $00800080, $20020000,
        $20820080, $20000080, $00000000, $00820000,
        $20000000, $00800000, $20020080, $20800080,
        $00800000, $00020000, $20820000, $00000080,
        $00800000, $00020000, $20000080, $20820080,
        $00020080, $20000000, $00000000, $00820000,
        $20800080, $20020080, $20020000, $00800080,
        $20820000, $00000080, $00800080, $20020000,
        $20820080, $00800000, $20800000, $20000080,
        $00820000, $00020080, $20020080, $20800000,
        $00000080, $20820000, $00820080, $00000000,
        $20000000, $20800080, $00020000, $00820080)

);
 procedure c2l(c: PByte;var l: DES_LONG);
 procedure PERM_OP(var a,b,t: DES_LONG; n,m: int);
 procedure HPERM_OP(var a,t: DES_LONG; n,m: int);
 function ROTATE(_para1:dword; _para2:dword):dword;
 procedure IP(var l, r: DES_LONG);
 procedure FP(var l, r: DES_LONG);
 procedure l2c(var l: DES_LONG; c: PByte);
 procedure c2ln(c: Pbyte; var l1,l2: DES_LONG; n: int);
 procedure l2cn(var l1,l2: DES_LONG; c: PByte; n: int);

implementation

procedure l2cn(var l1,l2: DES_LONG; c: PByte; n: int);
begin
  c := c + n;
  case n of
  8:
    PreDec(c)^ := Byte(((l2) shr 24) and $ff);
  { fall thru }
  7:
    PreDec(c)^ := Byte(((l2) shr 16) and $ff);
  { fall thru }
  6:
    PreDec(c)^ := Byte(((l2) shr  8) and $ff);
  { fall thru }
  5:
    PreDec(c)^ := Byte(((l2)     ) and $ff);
  { fall thru }
  4:
    PreDec(c)^ := Byte(((l1) shr 24) and $ff);
  { fall thru }
  3:
    PreDec(c)^ := Byte(((l1) shr 16) and $ff);
  { fall thru }
  2:
    PreDec(c)^ := Byte(((l1) shr  8) and $ff);
  { fall thru }
  1:
    PreDec(c)^ := Byte(((l1)     ) and $ff);
      end;
end;


procedure c2ln(c: Pbyte; var l1,l2: DES_LONG; n: int);
begin
      c := c + n;
      l1 := 0; l2 :=0;
      case n of
          8:
          l2 := (DES_LONG( (PreDec(c)^))) shl 24;
          { fall thru }
          7:
          l2 := l2 or ((DES_LONG( (PreDec(c)^))) shl 16);
          { fall thru }
          6:
          l2 := l2 or ((DES_LONG( (PreDec(c)^))) shl  8);
          { fall thru }
          5:
          l2 := l2 or ((DES_LONG( (PreDec(c)^))));
          { fall thru }
          4:
          l1 := (DES_LONG( (PreDec(c)^))) shl 24;
          { fall thru }
          3:
          l1 := l1 or ((DES_LONG( (PreDec(c)^))) shl 16);
          { fall thru }
          2:
          l1 := l1 or ((DES_LONG( (PreDec(c)^))) shl  8);
          { fall thru }
          1:
          l1 := l1 or ((DES_LONG( (PreDec(c)^))));
      end;
end;

procedure FP(var l, r: DES_LONG);
var
  tt : DES_LONG;
begin
    PERM_OP(l,r,tt, 1,$55555555);
    PERM_OP(r,l,tt, 8,$00ff00ff);
    PERM_OP(l,r,tt, 2,$33333333);
    PERM_OP(r,l,tt,16,$0000ffff);
    PERM_OP(l,r,tt, 4,$0f0f0f0f);
end;

procedure IP(var l, r: DES_LONG);
var
  tt : DES_LONG;
begin
  PERM_OP(r,l,tt, 4,Long($0f0f0f0f));
  PERM_OP(l,r,tt,16,Long($0000ffff));
  PERM_OP(r,l,tt, 2,Long($33333333));
  PERM_OP(l,r,tt, 8,Long($00ff00ff));
  PERM_OP(r,l,tt, 1,Long($55555555));
end;

procedure HPERM_OP(var a,t: DES_LONG; n,m: int);
begin
    t := ((a shl (16-n)) xor a) and (m);
    a := a xor t xor (t shr (16-n));
end;

function ROTATE(_para1:dword; _para2:dword):dword;
begin
   Result := _lrotr(_para1, _para2);
end;

procedure PERM_OP(var a,b,t: DES_LONG; n,m: int);
begin
   t := ((a shr n) xor b) and m;
   b := b xor (t);
   a := a xor (t shl n);
end;

procedure l2c(var l: DES_LONG; c: PByte);
begin
  PostInc(c)^ := Byte(((l)     ) and $ff);
  PostInc(c)^ := Byte(((l) shr  8) and $ff);
  PostInc(c)^ := Byte(((l) shr 16) and $ff);
  PostInc(c)^ := Byte(((l) shr 24) and $ff);
end;


procedure c2l(c: PByte;var l: DES_LONG);
begin
   l := DES_LONG(PostInc(c)^);
   l:= l or ((DES_LONG(PostInc(c)^)) shl  8);
   l:= l or ((DES_LONG(PostInc(c)^)) shl 16);
   l:= l or ((DES_LONG(PostInc(c)^)) shl 24);
end;

end.
