unit openssl3.crypto.cmp.cmp_err;

interface
uses OpenSSL.Api;

function ossl_err_load_CMP_strings:integer;

var
  CMP_str_reasons: array of TERR_STRING_DATA;

implementation
uses OpenSSL3.Err;


function ossl_err_load_CMP_strings:integer;
begin
{$IFNDEF OPENSSL_NO_ERR}
    if ERR_reason_error_string(CMP_str_reasons[0].error)= nil  then
        ERR_load_strings_const(@CMP_str_reasons);
{$ENDIF}
    Result := 1;
end;

initialization
  CMP_str_reasons := [
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ALGORITHM_NOT_SUPPORTED),
    'algorithm not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_BAD_CHECKAFTER_IN_POLLREP),
    'bad checkafter in pollrep'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_BAD_REQUEST_ID), 'bad request id'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_CERTHASH_UNMATCHED), 'certhash unmatched'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_CERTID_NOT_FOUND), 'certid not found'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_CERTIFICATE_NOT_ACCEPTED),
    'certificate not accepted'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_CERTIFICATE_NOT_FOUND),
    'certificate not found'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_CERTREQMSG_NOT_FOUND),
    'certreqmsg not found'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_CERTRESPONSE_NOT_FOUND),
    'certresponse not found'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_CERT_AND_KEY_DO_NOT_MATCH),
    'cert and key do not match'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_CHECKAFTER_OUT_OF_RANGE),
    'checkafter out of range'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ENCOUNTERED_KEYUPDATEWARNING),
    'encountered keyupdatewarning'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ENCOUNTERED_WAITING),
    'encountered waiting'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CALCULATING_PROTECTION),
    'error calculating protection'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_CERTCONF),
    'error creating certconf'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_CERTREP),
    'error creating certrep'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_CERTREQ),
    'error creating certreq'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_ERROR),
    'error creating error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_GENM),
    'error creating genm'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_GENP),
    'error creating genp'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_PKICONF),
    'error creating pkiconf'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_POLLREP),
    'error creating pollrep'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_POLLREQ),
    'error creating pollreq'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_RP), 'error creating rp'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_CREATING_RR), 'error creating rr'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_PARSING_PKISTATUS),
    'error parsing pkistatus'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_PROCESSING_MESSAGE),
    'error processing message'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_PROTECTING_MESSAGE),
    'error protecting message'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_SETTING_CERTHASH),
    'error setting certhash'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_UNEXPECTED_CERTCONF),
    'error unexpected certconf'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_VALIDATING_PROTECTION),
    'error validating protection'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_ERROR_VALIDATING_SIGNATURE),
    'error validating signature'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_FAILED_BUILDING_OWN_CHAIN),
    'failed building own chain'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_FAILED_EXTRACTING_PUBKEY),
    'failed extracting pubkey'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_FAILURE_OBTAINING_RANDOM),
    'failure obtaining random'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_FAIL_INFO_OUT_OF_RANGE),
    'fail info out of range'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_INVALID_ARGS), 'invalid args'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_INVALID_OPTION), 'invalid option'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_CERTID), 'missing certid'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_KEY_INPUT_FOR_CREATING_PROTECTION),
    'missing key input for creating protection'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_KEY_USAGE_DIGITALSIGNATURE),
    'missing key usage digitalsignature'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_P10CSR), 'missing p10csr'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_PBM_SECRET), 'missing pbm secret'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_PRIVATE_KEY),
    'missing private key'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_PROTECTION), 'missing protection'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_REFERENCE_CERT),
    'missing reference cert'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_SENDER_IDENTIFICATION),
    'missing sender identification'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MISSING_TRUST_STORE),
    'missing trust store'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MULTIPLE_REQUESTS_NOT_SUPPORTED),
    'multiple requests not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MULTIPLE_RESPONSES_NOT_SUPPORTED),
    'multiple responses not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_MULTIPLE_SAN_SOURCES),
    'multiple san sources'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_NO_STDIO), 'no stdio'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_NO_SUITABLE_SENDER_CERT),
    'no suitable sender cert'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_NULL_ARGUMENT), 'null argument'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_PKIBODY_ERROR), 'pkibody error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_PKISTATUSINFO_NOT_FOUND),
    'pkistatusinfo not found'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_POLLING_FAILED), 'polling failed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_POTENTIALLY_INVALID_CERTIFICATE),
    'potentially invalid certificate'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_RECEIVED_ERROR), 'received error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_RECIPNONCE_UNMATCHED),
    'recipnonce unmatched'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_REQUEST_NOT_ACCEPTED),
    'request not accepted'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_REQUEST_REJECTED_BY_SERVER),
    'request rejected by server'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_SENDER_GENERALNAME_TYPE_NOT_SUPPORTED),
    'sender generalname type not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_SRVCERT_DOES_NOT_VALIDATE_MSG),
    'srvcert does not validate msg'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_TOTAL_TIMEOUT), 'total timeout'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_TRANSACTIONID_UNMATCHED),
    'transactionid unmatched'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_TRANSFER_ERROR), 'transfer error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_UNEXPECTED_PKIBODY), 'unexpected pkibody'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_UNEXPECTED_PKISTATUS),
    'unexpected pkistatus'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_UNEXPECTED_PVNO), 'unexpected pvno'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_UNKNOWN_ALGORITHM_ID),
    'unknown algorithm id'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_UNKNOWN_CERT_TYPE), 'unknown cert type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_UNKNOWN_PKISTATUS), 'unknown pkistatus'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_UNSUPPORTED_ALGORITHM),
    'unsupported algorithm'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_UNSUPPORTED_KEY_TYPE),
    'unsupported key type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_UNSUPPORTED_PROTECTION_ALG_DHBASEDMAC),
    'unsupported protection alg dhbasedmac'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_VALUE_TOO_LARGE), 'value too large'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_VALUE_TOO_SMALL), 'value too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_WRONG_ALGORITHM_OID),
    'wrong algorithm oid'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_WRONG_CERTID), 'wrong certid'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_WRONG_CERTID_IN_RP), 'wrong certid in rp'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_WRONG_PBM_VALUE), 'wrong pbm value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_WRONG_RP_COMPONENT_COUNT),
    'wrong rp component count'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_CMP, 0, CMP_R_WRONG_SERIAL_IN_RP), 'wrong serial in rp'),
    get_ERR_STRING_DATA(0, nil)
];


end.
