unit openssl3.crypto.asn1.asn1_err;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface
uses OpenSSL.Api;

function ossl_err_load_ASN1_strings:integer;

var
  ASN1_str_reasons: array of TERR_STRING_DATA;

implementation
uses OpenSSL3.Err;

function ossl_err_load_ASN1_strings:integer;
begin
{$IFNDEF OPENSSL_NO_ERR}
    if ERR_reason_error_string(ASN1_str_reasons[0].error) = nil  then
        ERR_load_strings_const(@ASN1_str_reasons[0]);
{$ENDIF}
    Result := 1;
end;

initialization
  ASN1_str_reasons := [
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ADDING_OBJECT), 'adding object'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ASN1_PARSE_ERROR), 'asn1 parse error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ASN1_SIG_PARSE_ERROR),
    'asn1 sig parse error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_AUX_ERROR), 'aux error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_BAD_OBJECT_HEADER), 'bad object header'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_BAD_TEMPLATE), 'bad template'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_BMPSTRING_IS_WRONG_LENGTH),
    'bmpstring is wrong length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_BN_LIB), 'bn lib'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_BOOLEAN_IS_WRONG_LENGTH),
    'boolean is wrong length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_BUFFER_TOO_SMALL), 'buffer too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER),
    'cipher has no object identifier'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_CONTEXT_NOT_INITIALISED),
    'context not initialised'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_DATA_IS_WRONG), 'data is wrong'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_DECODE_ERROR), 'decode error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_DEPTH_EXCEEDED), 'depth exceeded'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_DIGEST_AND_KEY_TYPE_NOT_SUPPORTED),
    'digest and key type not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ENCODE_ERROR), 'encode error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ERROR_GETTING_TIME),
    'error getting time'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ERROR_LOADING_SECTION),
    'error loading section'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ERROR_SETTING_CIPHER_PARAMS),
    'error setting cipher params'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_EXPECTING_AN_INTEGER),
    'expecting an integer'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_EXPECTING_AN_OBJECT),
    'expecting an object'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_EXPLICIT_LENGTH_MISMATCH),
    'explicit length mismatch'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_EXPLICIT_TAG_NOT_CONSTRUCTED),
    'explicit tag not constructed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_FIELD_MISSING), 'field missing'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_FIRST_NUM_TOO_LARGE),
    'first num too large'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_HEADER_TOO_LONG), 'header too long'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_BITSTRING_FORMAT),
    'illegal bitstring format'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_BOOLEAN), 'illegal boolean'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_CHARACTERS),
    'illegal characters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_FORMAT), 'illegal format'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_HEX), 'illegal hex'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_IMPLICIT_TAG),
    'illegal implicit tag'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_INTEGER), 'illegal integer'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_NEGATIVE_VALUE),
    'illegal negative value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_NESTED_TAGGING),
    'illegal nested tagging'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_NULL), 'illegal null'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_NULL_VALUE),
    'illegal null value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_OBJECT), 'illegal object'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_OPTIONAL_ANY),
    'illegal optional any'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE),
    'illegal options on item template'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_PADDING), 'illegal padding'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_TAGGED_ANY),
    'illegal tagged any'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_TIME_VALUE),
    'illegal time value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ILLEGAL_ZERO_CONTENT),
    'illegal zero content'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INTEGER_NOT_ASCII_FORMAT),
    'integer not ascii format'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INTEGER_TOO_LARGE_FOR_LONG),
    'integer too large for long'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_BIT_STRING_BITS_LEFT),
    'invalid bit string bits left'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_BMPSTRING_LENGTH),
    'invalid bmpstring length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_DIGIT), 'invalid digit'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_MIME_TYPE), 'invalid mime type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_MODIFIER), 'invalid modifier'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_NUMBER), 'invalid number'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_OBJECT_ENCODING),
    'invalid object encoding'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_SCRYPT_PARAMETERS),
    'invalid scrypt parameters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_SEPARATOR), 'invalid separator'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_STRING_TABLE_VALUE),
    'invalid string table value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_UNIVERSALSTRING_LENGTH),
    'invalid universalstring length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_UTF8STRING),
    'invalid utf8string'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_INVALID_VALUE), 'invalid value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_LENGTH_TOO_LONG), 'length too long'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_LIST_ERROR), 'list error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_MIME_NO_CONTENT_TYPE),
    'mime no content type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_MIME_PARSE_ERROR), 'mime parse error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_MIME_SIG_PARSE_ERROR),
    'mime sig parse error'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_MISSING_EOC), 'missing eoc'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_MISSING_SECOND_NUMBER),
    'missing second number'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_MISSING_VALUE), 'missing value'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_MSTRING_NOT_UNIVERSAL),
    'mstring not universal'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_MSTRING_WRONG_TAG), 'mstring wrong tag'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NESTED_ASN1_STRING),
    'nested asn1 string'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NESTED_TOO_DEEP), 'nested too deep'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NON_HEX_CHARACTERS),
    'non hex characters'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NOT_ASCII_FORMAT), 'not ascii format'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NOT_ENOUGH_DATA), 'not enough data'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NO_CONTENT_TYPE), 'no content type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NO_MATCHING_CHOICE_TYPE),
    'no matching choice type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NO_MULTIPART_BODY_FAILURE),
    'no multipart body failure'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NO_MULTIPART_BOUNDARY),
    'no multipart boundary'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NO_SIG_CONTENT_TYPE),
    'no sig content type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_NULL_IS_WRONG_LENGTH),
    'null is wrong length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_OBJECT_NOT_ASCII_FORMAT),
    'object not ascii format'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_ODD_NUMBER_OF_CHARS),
    'odd number of UTF8Chars'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_SECOND_NUMBER_TOO_LARGE),
    'second number too large'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_SEQUENCE_LENGTH_MISMATCH),
    'sequence length mismatch'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_SEQUENCE_NOT_CONSTRUCTED),
    'sequence not constructed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_SEQUENCE_OR_SET_NEEDS_CONFIG),
    'sequence or set needs config'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_SHORT_LINE), 'short line'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_SIG_INVALID_MIME_TYPE),
    'sig invalid mime type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_STREAMING_NOT_SUPPORTED),
    'streaming not supported'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_STRING_TOO_LONG), 'string too long'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_STRING_TOO_SHORT), 'string too short'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD),
    'the asn1 object identifier is not known for this md'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_TIME_NOT_ASCII_FORMAT),
    'time not ascii format'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_TOO_LARGE), 'too large'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_TOO_LONG), 'too long'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_TOO_SMALL), 'too small'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_TYPE_NOT_CONSTRUCTED),
    'type not constructed'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_TYPE_NOT_PRIMITIVE),
    'type not primitive'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNEXPECTED_EOC), 'unexpected eoc'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNIVERSALSTRING_IS_WRONG_LENGTH),
    'universalstring is wrong length'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNKNOWN_DIGEST), 'unknown digest'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNKNOWN_FORMAT), 'unknown format'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM),
    'unknown message digest algorithm'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNKNOWN_OBJECT_TYPE),
    'unknown object type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE),
    'unknown public key type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNKNOWN_SIGNATURE_ALGORITHM),
    'unknown signature algorithm'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNKNOWN_TAG), 'unknown tag'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE),
    'unsupported any defined by type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNSUPPORTED_CIPHER),
    'unsupported cipher'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE),
    'unsupported public key type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_UNSUPPORTED_TYPE), 'unsupported type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_WRONG_INTEGER_TYPE),
    'wrong integer type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_WRONG_PUBLIC_KEY_TYPE),
    'wrong public key type'),
    get_ERR_STRING_DATA(ERR_PACK(ERR_LIB_ASN1, 0, ASN1_R_WRONG_TAG), 'wrong tag'),
    get_ERR_STRING_DATA(0, nil)
];
end.
