
unit OpenSSL.api ;
//const
//  AliasToUpperCase: function(const S: AnsiString): AnsiString = System.AnsiStrings.UpperCase;
{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

//Case IndexStr('somename', ['bobby', 'tommy', 'somename', 'george']) of

{$MINENUMSIZE 4}
interface
uses
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  types, TypInfo, Classes,SysUtils,
  DateUtils;

{$I config.inc}

(*
 * 64-bit processor other than LP64 ABI
 *)

{$ifdef SIXTY_FOUR_BIT}
type
  BN_ULONG  = UInt64;
  PBN_ULONG = ^BN_ULONG;
const
  BN_BYTES  =  8;
{$endif}

{$ifdef SIXTY_FOUR_BIT}
  BN_BITS4 = 32;
  BN_MASK2    = uint64($ffffffffffffffff);
  BN_MASK2l   = uint32($ffffffff);
  BN_MASK2h   = uint64($ffffffff00000000);
  BN_MASK2h1  = uint64($ffffffff80000000);
  BN_DEC_CONV = uint64(10000000000000000000);
  BN_DEC_NUM = 19;
  BN_DEC_FMT1 = '%llu';
  BN_DEC_FMT2 = '%019llu';
  BN_FLG_FIXED_TOP = 0;
{$endif}
   (*
 * 64-bit processor with LP64 ABI
 *)
{$ifdef SIXTY_FOUR_BIT_LONG}
type
 BN_ULONG  =      unsigned long;
const
 BN_BYTES  =      8;
{$endif}

{$ifdef THIRTY_TWO_BIT}
type
   BN_ULONG  = uint32;
   BN_ULLONG = UInt64;
   PBN_ULONG = ^BN_ULONG;
const
   BN_BYTES  =      4;
{$endif}

BN_BITS2 = (BN_BYTES*8);
BN_BITS = (BN_BITS2*2);
BN_TBIT = (BN_ULONG(1) shl (BN_BITS2 - 1));

 const
     B_FORMAT_TEXT  =$8000;
     FORMAT_UNDEF   =0;
     FORMAT_TEXT    =(1 or B_FORMAT_TEXT);     (* Generic text *)
     FORMAT_BINARY  =2;                      (* Generic binary *)
     FORMAT_BASE64  =(3 or B_FORMAT_TEXT);     (* Base64 *)
     FORMAT_ASN1    =4;                      (* ASN.1/DER *)
     FORMAT_PEM     =(5 or B_FORMAT_TEXT);
     FORMAT_PKCS12  =6;
     FORMAT_SMIME   =(7 or B_FORMAT_TEXT);
     FORMAT_ENGINE  = 8;                      (* Not really a file format *)
     FORMAT_PEMRSA  =(9 or B_FORMAT_TEXT);     (* PEM RSAPublicKey format *)
     FORMAT_ASN1RSA = 10;                     (* DER RSAPublicKey format *)
     FORMAT_MSBLOB  = 11;                     (* MS Key blob format *)
     FORMAT_PVK     = 12;                     (* MS PVK file format *)
     FORMAT_HTTP    = 13;                     (* Download using HTTP *)
     FORMAT_NSS     = 14;                     (* NSS keylog format *)

     TEST_SKIP_CODE = 123;
    
    
    OPENSSL_CONFIGURED_API = 30100;
    ARCH_WORD_BITS = 32;
    C448_WORD_BITS = 32;
    SHA_LBLOCK     = 16;
    SHA_CBLOCK     = (SHA_LBLOCK*4);
    HASH_CBLOCK    =  SHA_CBLOCK;
    BUFSIZ         = 512;
    TABLE_BITS = 4;
    char_type: array[0..127] of UInt16 = (
    1026,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
       2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
       2,    2,    2,    2,    2,    2,    2,    2,  120,    0,    1,   40,
       0,    0,    0,   16, 1040, 1040, 33792,   25,   25, 16400, 8208,   16,
    4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112,   16,    9,
       9,   16,    9,   16,    0, 4112, 4112, 4112, 4112, 4112, 4112, 4112,
    4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112,
    4112, 4112, 4112, 4112, 4112, 4112, 4112,    0, 1025,    0,    0,    0,
       0, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112,
    4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112, 4112,
    4112, 4112, 4112,    0,    0,    0,    0,    2
);

type
  {$IF  ARCH_WORD_BITS = 64}
  word_t = UInt64;
  mask_t = UInt64;
  dword_t = uint128_t;
  hsword_t = Int32;
  sword_t = Int64;
  dsword_t = int128_t;
{$ELSEIF ARCH_WORD_BITS = 32}
  word_t = UInt32;
  mask_t = UInt32;
  dword_t = uint64;
  hsword_t = Int16;
  sword_t = Int32;
  dsword_t = int64;
{$IFEND}

{$ifndef FPC}
    qword = int64;  // Keep h2pas "uses ctypes" headers working with delphi.
    PtrUInt = NativeUInt;
    PPtrUInt = ^PtrUInt;
{$endif}

{$if C448_WORD_BITS = 64}
{$elseif C448_WORD_BITS = 32}
  c448_word_t = UInt32;
  Pc448_word_t = ^c448_word_t;
  c448_sword_t = Int32;
  c448_bool_t = UInt32;
  c448_dword_t = UInt64;

  c448_dsword_t = Int64;
{$IFEND}
   SHA_LONG = uint32;
   sig_atomic_t = Integer;
   PSHA_LONG = ^SHA_LONG;
   TOSSL_thread_stop_handler_fn = procedure(arg: Pointer);
   Pstack_st_EVP_PKEY_METHOD = Pointer;
   ASN1_ANY = Pointer;
   { Internal Aliases }
   (* VC output
      Size of UTF8Char : 1
      Size of int : 4
      Size of short int : 2
      Size of long int : 4

      Size of float : 4
      Size of double : 8
      Size of wchar_t : 2
      Size of unsigned int: 4
      Size of unsigned long: 4
      Size of unsigned long int: 4
   *)
   (*
      $g++ -o main *.cpp
      $main
      Size of UTF8Char : 1
      Size of int : 4
      Size of short int : 2
      Size of long int : 8
      Size of unsigned long int: 8
      Size of float : 4
      Size of double : 8
      Size of wchar_t : 4
      Size of unsigned int: 4
      Size of unsigned long: 8
      Size of unsigned long int: 8
   *)

   PVOID = Pointer;
   int32_t = Int32;
   uint32_t = UInt32;
   unsigned = UInt32;
   Puint32_t = ^uint32_t;
   Pint32_t = ^int32_t;

   int64_t = Int64;
   Pint64_t = ^int64_t;

   uint64_t = UInt64;

   Puint64_t = ^uint64_t;
   SHA_LONG64 = uint64;
   PSHA_LONG64 = ^SHA_LONG64;
   SM3_WORD = UInt32;
   longint = integer;
   long = LongInt;
   __time32_t = long;
   __time64_t = int64;
   {$IFNDEF  MSWINDOWS}
   time_t = __time64_t;
   ossl_ssize_t = int64;
   uint = uint64;
   int = Int64;
   {$ELSE}
   time_t = int64;
   ossl_ssize_t = int32;

   UInt         = UInt32;
   ULongInt     = UInt32;
   ULong        = UInt32;
   Pulong       = ^ulong;
   short_int    = Int16;
   ushort_int   = UInt16;
   LongLong    = Int64;
   ULongLong   = uint64;

   {$ENDIF}
   ULONG_PTR = ulonglong;
   HCRYPTPROV = ULONG_PTR ;
   int = Int32;
   Pint = ^longint;
   Pint8 = ^int8;
   PPint8 = ^Pint8;
   PUint16 = ^UInt16;

   Possl_ssize_t = ^ossl_ssize_t;
   Pulong_int = ^ulongint;
   Pulong_long = ^ULongLong;
   Puint = ^uint;
   OSSL_PROPERTY_IDX = int;
   POSSL_PROPERTY_IDX = ^OSSL_PROPERTY_IDX;
   Ptime_t = ^time_t;
   PLong = ^Long;
   size_t = NativeUInt;    { as definied in the C standard }
   SizeInt = NativeInt;
   Psize_t = ^size_t;

   size_t_aX = size_t ;
   Psize_t_aX = ^size_t_aX;
   ssize_t = longint;    { used by function for returning number of bytes }
   uid_t = longint;      { used for user ID type        }
   //time_t = cardinal;    { used for returning the time  }
  {$IFDEF NEXTGEN}
  _ShortStr = _ShortString;
  _AnsiStr = _AnsiString;
  _AnsiChr = _AnsiChar;
  _WideStr = _WideString;
  _PAnsiChr = _PAnsiChar;
  UTF8Char = _AnsiChar;
  PUTF8Char = _PAnsiChar;
  {$ELSE}
  _ShortStr = ShortString;
  _AnsiStr = AnsiString;
  _AnsiChr = AnsiChar;
  _WideStr = WideString;
  _PAnsiChr = PAnsiChar;
  UTF8Char = AnsiChar;
  PUTF8Char = PAnsiChar;
  TBytes = TArray<Byte>;
  {$ENDIF}

  RIPEMD160_LONG = UInt32;
  BF_LONG = uint32;
  PBF_LONG = ^BF_LONG;
  RC4_INT = uint32;
  RC2_INT = UInt32;
  PRC2_INT = ^RC2_INT;
  PRC4_INT = ^RC4_INT;
  IDEA_INT = uint32;
  PIDEA_INT = ^IDEA_INT;
  {
 * If OPENSSL_API_COMPAT wasn't given, we use default numbers to set
 * the API compatibility level.
 }
{$IFNDEF OPENSSL_API_LEVEL}
   {$IF OPENSSL_CONFIGURED_API > 0}
    const OPENSSL_API_LEVEL = (OPENSSL_CONFIGURED_API);
   {$ELSE}
    const OPENSSL_API_LEVEL = (OPENSSL_VERSION_MAJOR * 10000 + OPENSSL_VERSION_MINOR * 100);
  {$IFEND}
{$ENDIF}
const
{$ifndef SIZE_MAX }
    // SIZE_MAX definition must match exactly with stdint.h for modules support.
    {$ifdef SIXTY_FOUR_BIT}
        SIZE_MAX = 18446744073709551615;//$ffffffffffffffff;//ui64
    {$else}
        SIZE_MAX = $ffffffff;//ui32
    {$endif}
{$endif}
  EVP_RC4_KEY_SIZE = 16;
  Char_Size = SizeOf(UTF8Char);
  ASN1_DTFLGS_TYPE_MASK = ulong($0F);
  ASN1_DTFLGS_RFC822    = ulong($00);
  ASN1_DTFLGS_ISO8601   = ulong($01);

  BN_MULL_SIZE_NORMAL = (16);
  BN_MUL_RECURSIVE_SIZE_NORMAL = (16);
  BN_SQR_RECURSIVE_SIZE_NORMAL = (16);
  BN_MUL_LOW_RECURSIVE_SIZE_NORMAL = (32);
  BN_MONT_CTX_SET_SIZE_WORD = (64);

  HTTP_R_ASN1_LEN_EXCEEDS_MAX_RESP_LEN = 108;
  HTTP_R_CONNECT_FAILURE = 100;
  HTTP_R_ERROR_PARSING_ASN1_LENGTH = 109;
  HTTP_R_ERROR_PARSING_CONTENT_LENGTH = 119;
  HTTP_R_ERROR_PARSING_URL = 101;
  HTTP_R_ERROR_RECEIVING = 103;
  HTTP_R_ERROR_SENDING = 102;
  HTTP_R_FAILED_READING_DATA = 128;
  HTTP_R_HEADER_PARSE_ERROR = 126;
  HTTP_R_INCONSISTENT_CONTENT_LENGTH = 120;
  HTTP_R_INVALID_PORT_NUMBER = 123;
  HTTP_R_INVALID_URL_PATH = 125;
  HTTP_R_INVALID_URL_SCHEME = 124;
  HTTP_R_MAX_RESP_LEN_EXCEEDED = 117;
  HTTP_R_MISSING_ASN1_ENCODING = 110;
  HTTP_R_MISSING_CONTENT_TYPE = 121;
  HTTP_R_MISSING_REDIRECT_LOCATION = 111;
  HTTP_R_RECEIVED_ERROR = 105;
  HTTP_R_RECEIVED_WRONG_HTTP_VERSION = 106;
  HTTP_R_REDIRECTION_FROM_HTTPS_TO_HTTP = 112;
  HTTP_R_REDIRECTION_NOT_ENABLED = 116;
  HTTP_R_RESPONSE_LINE_TOO_LONG = 113;
  HTTP_R_RESPONSE_PARSE_ERROR = 104;
  HTTP_R_RETRY_TIMEOUT = 129;
  HTTP_R_SERVER_CANCELED_CONNECTION = 127;
  HTTP_R_SOCK_NOT_SUPPORTED = 122;
  HTTP_R_STATUS_CODE_UNSUPPORTED = 114;
  HTTP_R_TLS_NOT_ENABLED = 107;
  HTTP_R_TOO_MANY_REDIRECTIONS = 115;
  HTTP_R_UNEXPECTED_CONTENT_TYPE = 118;

   ENGINE_METHOD_RSA               = uint32($0001);
   ENGINE_METHOD_DSA               = uint32($0002);
   ENGINE_METHOD_DH                = uint32($0004);
   ENGINE_METHOD_RAND              = uint32($0008);
   ENGINE_METHOD_CIPHERS           = uint32($0040);
   ENGINE_METHOD_DIGESTS           = uint32($0080);
   ENGINE_METHOD_PKEY_METHS        = uint32($0200);
   ENGINE_METHOD_PKEY_ASN1_METHS   = uint32($0400);
   ENGINE_METHOD_EC                = uint32($0800);
  (* Obvious all-or-nothing cases. *)
   ENGINE_METHOD_ALL               = uint32($FFFF);
   ENGINE_METHOD_NONE              = uint32($0000);

   OSSL_DYNAMIC_VERSION            = UInt32($00030000);
   OSSL_DYNAMIC_OLDEST             = UInt32($00030000);

  CRMF_R_BAD_PBM_ITERATIONCOUNT = 100;
  CRMF_R_CRMFERROR = 102;
  CRMF_R_ERROR = 103;
  CRMF_R_ERROR_DECODING_CERTIFICATE = 104;
  CRMF_R_ERROR_DECRYPTING_CERTIFICATE = 105;
  CRMF_R_ERROR_DECRYPTING_SYMMETRIC_KEY = 106;
  CRMF_R_FAILURE_OBTAINING_RANDOM = 107;
  CRMF_R_ITERATIONCOUNT_BELOW_100 = 108;
  CRMF_R_MALFORMED_IV = 101;
  CRMF_R_NULL_ARGUMENT = 109;
  CRMF_R_POPOSKINPUT_NOT_SUPPORTED = 113;
  CRMF_R_POPO_INCONSISTENT_PUBLIC_KEY = 117;
  CRMF_R_POPO_MISSING = 121;
  CRMF_R_POPO_MISSING_PUBLIC_KEY = 118;
  CRMF_R_POPO_MISSING_SUBJECT = 119;
  CRMF_R_POPO_RAVERIFIED_NOT_ACCEPTED = 120;
  CRMF_R_SETTING_MAC_ALGOR_FAILURE = 110;
  CRMF_R_SETTING_OWF_ALGOR_FAILURE = 111;
  CRMF_R_UNSUPPORTED_ALGORITHM = 112;
  CRMF_R_UNSUPPORTED_CIPHER = 114;
  CRMF_R_UNSUPPORTED_METHOD_FOR_CREATING_POPO = 115;
  CRMF_R_UNSUPPORTED_POPO_METHOD = 116;

  CMP_R_ALGORITHM_NOT_SUPPORTED = 139;
  CMP_R_BAD_CHECKAFTER_IN_POLLREP = 167;
  CMP_R_BAD_REQUEST_ID = 108;
  CMP_R_CERTHASH_UNMATCHED = 156;
  CMP_R_CERTID_NOT_FOUND = 109;
  CMP_R_CERTIFICATE_NOT_ACCEPTED = 169;
  CMP_R_CERTIFICATE_NOT_FOUND = 112;
  CMP_R_CERTREQMSG_NOT_FOUND = 157;
  CMP_R_CERTRESPONSE_NOT_FOUND = 113;
  CMP_R_CERT_AND_KEY_DO_NOT_MATCH = 114;
  CMP_R_CHECKAFTER_OUT_OF_RANGE = 181;
  CMP_R_ENCOUNTERED_KEYUPDATEWARNING = 176;
  CMP_R_ENCOUNTERED_WAITING = 162;
  CMP_R_ERROR_CALCULATING_PROTECTION = 115;
  CMP_R_ERROR_CREATING_CERTCONF = 116;
  CMP_R_ERROR_CREATING_CERTREP = 117;
  CMP_R_ERROR_CREATING_CERTREQ = 163;
  CMP_R_ERROR_CREATING_ERROR = 118;
  CMP_R_ERROR_CREATING_GENM = 119;
  CMP_R_ERROR_CREATING_GENP = 120;
  CMP_R_ERROR_CREATING_PKICONF = 122;
  CMP_R_ERROR_CREATING_POLLREP = 123;
  CMP_R_ERROR_CREATING_POLLREQ = 124;
  CMP_R_ERROR_CREATING_RP = 125;
  CMP_R_ERROR_CREATING_RR = 126;
  CMP_R_ERROR_PARSING_PKISTATUS = 107;
  CMP_R_ERROR_PROCESSING_MESSAGE = 158;
  CMP_R_ERROR_PROTECTING_MESSAGE = 127;
  CMP_R_ERROR_SETTING_CERTHASH = 128;
  CMP_R_ERROR_UNEXPECTED_CERTCONF = 160;
  CMP_R_ERROR_VALIDATING_PROTECTION = 140;
  CMP_R_ERROR_VALIDATING_SIGNATURE = 171;
  CMP_R_FAILED_BUILDING_OWN_CHAIN = 164;
  CMP_R_FAILED_EXTRACTING_PUBKEY = 141;
  CMP_R_FAILURE_OBTAINING_RANDOM = 110;
  CMP_R_FAIL_INFO_OUT_OF_RANGE = 129;
  CMP_R_INVALID_ARGS = 100;
  CMP_R_INVALID_OPTION = 174;
  CMP_R_MISSING_CERTID = 165;
  CMP_R_MISSING_KEY_INPUT_FOR_CREATING_PROTECTION = 130;
  CMP_R_MISSING_KEY_USAGE_DIGITALSIGNATURE = 142;
  CMP_R_MISSING_P10CSR = 121;
  CMP_R_MISSING_PBM_SECRET = 166;
  CMP_R_MISSING_PRIVATE_KEY = 131;
  CMP_R_MISSING_PROTECTION = 143;
  CMP_R_MISSING_REFERENCE_CERT = 168;
  CMP_R_MISSING_SENDER_IDENTIFICATION = 111;
  CMP_R_MISSING_TRUST_STORE = 144;
  CMP_R_MULTIPLE_REQUESTS_NOT_SUPPORTED = 161;
  CMP_R_MULTIPLE_RESPONSES_NOT_SUPPORTED = 170;
  CMP_R_MULTIPLE_SAN_SOURCES = 102;
  CMP_R_NO_STDIO = 194;
  CMP_R_NO_SUITABLE_SENDER_CERT = 145;
  CMP_R_NULL_ARGUMENT = 103;
  CMP_R_PKIBODY_ERROR = 146;
  CMP_R_PKISTATUSINFO_NOT_FOUND = 132;
  CMP_R_POLLING_FAILED = 172;
  CMP_R_POTENTIALLY_INVALID_CERTIFICATE = 147;
  CMP_R_RECEIVED_ERROR = 180;
  CMP_R_RECIPNONCE_UNMATCHED = 148;
  CMP_R_REQUEST_NOT_ACCEPTED = 149;
  CMP_R_REQUEST_REJECTED_BY_SERVER = 182;
  CMP_R_SENDER_GENERALNAME_TYPE_NOT_SUPPORTED = 150;
  CMP_R_SRVCERT_DOES_NOT_VALIDATE_MSG = 151;
  CMP_R_TOTAL_TIMEOUT = 184;
  CMP_R_TRANSACTIONID_UNMATCHED = 152;
  CMP_R_TRANSFER_ERROR = 159;
  CMP_R_UNEXPECTED_PKIBODY = 133;
  CMP_R_UNEXPECTED_PKISTATUS = 185;
  CMP_R_UNEXPECTED_PVNO = 153;
  CMP_R_UNKNOWN_ALGORITHM_ID = 134;
  CMP_R_UNKNOWN_CERT_TYPE = 135;
  CMP_R_UNKNOWN_PKISTATUS = 186;
  CMP_R_UNSUPPORTED_ALGORITHM = 136;
  CMP_R_UNSUPPORTED_KEY_TYPE = 137;
  CMP_R_UNSUPPORTED_PROTECTION_ALG_DHBASEDMAC = 154;
  CMP_R_VALUE_TOO_LARGE = 175;
  CMP_R_VALUE_TOO_SMALL = 177;
  CMP_R_WRONG_ALGORITHM_OID = 138;
  CMP_R_WRONG_CERTID = 189;
  CMP_R_WRONG_CERTID_IN_RP = 187;
  CMP_R_WRONG_PBM_VALUE = 155;
  CMP_R_WRONG_RP_COMPONENT_COUNT = 188;
  CMP_R_WRONG_SERIAL_IN_RP = 173;

  ESS_R_EMPTY_ESS_CERT_ID_LIST                    = 107;
  ESS_R_ESS_CERT_DIGEST_ERROR                     = 103;
  ESS_R_ESS_CERT_ID_NOT_FOUND                     = 104;
  ESS_R_ESS_CERT_ID_WRONG_ORDER                   = 105;
  ESS_R_ESS_DIGEST_ALG_UNKNOWN                    = 106;
  ESS_R_ESS_SIGNING_CERTIFICATE_ERROR             = 102;
  ESS_R_ESS_SIGNING_CERT_ADD_ERROR                = 100;
  ESS_R_ESS_SIGNING_CERT_V2_ADD_ERROR             = 101;
  ESS_R_MISSING_SIGNING_CERTIFICATE_ATTRIBUTE     = 108;

  OSSL_TRACE_CATEGORY_ALL = 0;
  OSSL_TRACE_CATEGORY_TRACE = 1;
  OSSL_TRACE_CATEGORY_INIT = 2;
  OSSL_TRACE_CATEGORY_TLS = 3;
  OSSL_TRACE_CATEGORY_TLS_CIPHER = 4;
  OSSL_TRACE_CATEGORY_CONF = 5;
  OSSL_TRACE_CATEGORY_ENGINE_TABLE = 6;
  OSSL_TRACE_CATEGORY_ENGINE_REF_COUNT = 7;
  OSSL_TRACE_CATEGORY_PKCS5V2 = 8;
  OSSL_TRACE_CATEGORY_PKCS12_KEYGEN = 9;
  OSSL_TRACE_CATEGORY_PKCS12_DECRYPT = 10;
  OSSL_TRACE_CATEGORY_X509V3_POLICY = 11;
  OSSL_TRACE_CATEGORY_BN_CTX = 12;
  OSSL_TRACE_CATEGORY_CMP = 13;
  OSSL_TRACE_CATEGORY_STORE = 14;
  OSSL_TRACE_CATEGORY_DECODER = 15;
  OSSL_TRACE_CATEGORY_ENCODER = 16;
  OSSL_TRACE_CATEGORY_REF_COUNT = 17;
  OSSL_TRACE_CATEGORY_NUM = 18;

  BIO_CTRL_PENDING     = 10;(* opt - is their more data buffered *)
  BIO_CTRL_WPENDING    = 13;(* opt - number of bytes still to write *)
  BIO_CTRL_SET_PREFIX  = 79;
  BIO_CTRL_SET_INDENT  = 80;
  BIO_CTRL_GET_INDENT  = 81;

  MAX_SCT_SIZE         = 65535;
  MAX_SCT_LIST_SIZE    = MAX_SCT_SIZE;
  OPENSSLDIR           = 'c:\openssl\ssl';
  ENGINESDIR           = 'c:\openssl\lib\engines';
  MODULESDIR           = 'c:\openssl\module';
  CTLOG_FILE_EVP       = 'CTLOG_FILE';
  CTLOG_FILE           = OPENSSLDIR + '/ct_log_list.cnf';

  X509_CERT_AREA       =   OPENSSLDIR;
  X509_CERT_DIR        =   OPENSSLDIR + '/certs';
  X509_CERT_FILE       =   OPENSSLDIR + '/cert.pem';
  X509_PRIVATE_DIR     =   OPENSSLDIR + '/private';
  X509_CERT_DIR_EVP    =  'SSL_CERT_DIR';
  X509_CERT_FILE_EVP   =  'SSL_CERT_FILE';
  OPENSSL_CONF         =  'openssl.cnf';

  const
     S_IFMT = $F000;
  { first-in/first-out (FIFO/pipe)            }
     S_IFIFO = $1000;
  { character-special file (tty/console)      }
     S_IFCHR = $2000;
  { directory                                 }
     S_IFDIR = $4000;
  { blocking device (unused)                  }
     S_IFBLK = $6000;
  { regular                                   }
     S_IFREG = $8000;
  { symbolic link (unused)                    }
     S_IFLNK = $A000;
  { Berkeley socket                           }
     S_IFSOCK = $C000;
     S_IRWXU = $01C0;
     S_IRUSR = $0100;
     S_IWUSR = $0080;
     S_IXUSR = $0040;
     S_IREAD = S_IRUSR;
     S_IWRITE = S_IWUSR;
     S_IEXEC = S_IXUSR;
  { POSIX file modes: group permission...  }
     S_IRWXG = $0038;
     S_IRGRP = $0020;
     S_IWGRP = $0010;
     S_IXGRP = $0008;
  { POSIX file modes: other permission...  }
     S_IRWXO = $0007;
     S_IROTH = $0004;
     S_IWOTH = $0002;
     S_IXOTH = $0001;
  { POSIX setuid(), setgid(), and sticky...  }
     S_ISUID = $0800;
     S_ISGID = $0400;
     S_ISVTX = $0200;

  POLICY_DATA_FLAG_MAPPED = $1;
  POLICY_DATA_FLAG_MAPPED_ANY = $2;
  POLICY_DATA_FLAG_MAP_MASK = $3;
  POLICY_DATA_FLAG_SHARED_QUALIFIERS = $4;
  POLICY_DATA_FLAG_EXTRA_NODE = $8;
  POLICY_DATA_FLAG_CRITICAL = $10;
  POLICY_FLAG_ANY_POLICY = $2;

  OSSL_FUNC_STORE_OPEN = 1;
  OSSL_FUNC_STORE_ATTACH = 2;
  OSSL_FUNC_STORE_SETTABLE_CTX_PARAMS = 3;
  OSSL_FUNC_STORE_SET_CTX_PARAMS = 4;
  OSSL_FUNC_STORE_LOAD = 5;
  OSSL_FUNC_STORE_EOF = 6;
  OSSL_FUNC_STORE_CLOSE = 7;
  OSSL_FUNC_STORE_EXPORT_OBJECT = 8;
  OSSL_FUNC_SELF_TEST_CB        =       100;

  ossl_aes_xts_allow_insecure_decrypt = 1;
  XTS_MAX_BLOCKS_PER_DATA_UNIT = (1 shl 20);
  EVP_MD_CTX_FLAG_KEEP_PKEY_CTX = $0400;
  ENGINE_FLAGS_BY_ID_COPY = int($0004);
  ENGINE_FLAGS_MANUAL_CMD_CTRL =  int($0002);
  ENGINE_FLAGS_NO_REGISTER_ALL =  int($0008);
  ENGINE_CMD_FLAG_NO_INPUT     = UInt32($0004);
  ENGINE_CMD_FLAG_NUMERIC      = UInt32($0001);
  ENGINE_CMD_FLAG_STRING       = UInt32($0002);

  OSSL_FUNC_CRYPTO_MALLOC = 20;
  OSSL_FUNC_CRYPTO_ZALLOC = 21;
  OSSL_FUNC_CRYPTO_FREE = 22;
  OSSL_FUNC_CRYPTO_CLEAR_FREE = 23;
  OSSL_FUNC_CRYPTO_REALLOC = 24;
  OSSL_FUNC_CRYPTO_CLEAR_REALLOC = 25;
  OSSL_FUNC_CRYPTO_SECURE_MALLOC = 26;
  OSSL_FUNC_CRYPTO_SECURE_ZALLOC = 27;
  OSSL_FUNC_CRYPTO_SECURE_FREE = 28;
  OSSL_FUNC_CRYPTO_SECURE_CLEAR_FREE = 29;
  OSSL_FUNC_CRYPTO_SECURE_ALLOCATED = 30;
  OSSL_FUNC_OPENSSL_CLEANSE = 31;

  OSSL_FUNC_PROVIDER_REGISTER_CHILD_CB = 105;
  OSSL_FUNC_PROVIDER_DEREGISTER_CHILD_CB = 106;
  OSSL_FUNC_PROVIDER_NAME = 107;
  OSSL_FUNC_PROVIDER_GET0_PROVIDER_CTX = 108;
  OSSL_FUNC_PROVIDER_GET0_DISPATCH = 109;
  OSSL_FUNC_PROVIDER_UP_REF = 110;
  OSSL_FUNC_PROVIDER_FREE = 111;
  OSSL_FUNC_PROVIDER_TEARDOWN = 1024;
  OSSL_FUNC_PROVIDER_GETTABLE_PARAMS = 1025;
  OSSL_FUNC_PROVIDER_GET_PARAMS = 1026;
  OSSL_FUNC_PROVIDER_QUERY_OPERATION = 1027;
  OSSL_FUNC_PROVIDER_UNQUERY_OPERATION = 1028;
  OSSL_FUNC_PROVIDER_GET_REASON_STRINGS = 1029;
  OSSL_FUNC_PROVIDER_GET_CAPABILITIES = 1030;
  OSSL_FUNC_PROVIDER_SELF_TEST = 1031;

  DSO_FLAG_NO_NAME_TRANSLATION = $01;
  DSO_FLAG_NAME_TRANSLATION_EXT_ONLY = $02;
  SM4_BLOCK_SIZE    = 16;
  SM4_KEY_SCHEDULE  = 32;

  CAMELLIA_TABLE_BYTE_LEN = 272;
  CAMELLIA_TABLE_WORD_LEN = (CAMELLIA_TABLE_BYTE_LEN div 4);

  GCM_IV_DEFAULT_SIZE = 12; (* IV's for AES_GCM should normally be 12 bytes *)
  GCM_IV_MAX_SIZE     = (1024 div 8);
  GCM_TAG_MAX_SIZE    = 16;

  UNINITIALISED_SIZET = size_t(-1);
  BLOB_MAX_LENGTH       = 102400;
  DH_MODULUS_TOO_SMALL  = $80;
  DH_MODULUS_TOO_LARGE  = $100;
  OSSL_OBJECT_UNKNOWN = 0;
  OSSL_OBJECT_NAME =  1;
  OSSL_OBJECT_PKEY =  2 ;
  OSSL_OBJECT_CERT = 3;
   OSSL_OBJECT_CRL = 4;
  LONG_MIN  =  long(-2147483647) - 1;
  LONG_MAX  =  Long(2147483647);
  CHAR_BIT  =    8;
  NAME_MAX  = 255;
  RSA_MAX_PRIME_NUM =      5;
  OBJ_R_UNKNOWN_OBJECT_NAME = 103;
  BIO_FLAGS_UPLINK_INTERNAL = 0;

  OSSL_ENCODER_R_ENCODER_NOT_FOUND        = 101;
  OSSL_ENCODER_R_INCORRECT_PROPERTY_QUERY = 100;
  OSSL_ENCODER_R_MISSING_GET_PARAMS       = 102;

  OSSL_FUNC_ENCODER_NEWCTX = 1;
  OSSL_FUNC_ENCODER_FREECTX = 2;
  OSSL_FUNC_ENCODER_GET_PARAMS = 3;
  OSSL_FUNC_ENCODER_GETTABLE_PARAMS = 4;
  OSSL_FUNC_ENCODER_SET_CTX_PARAMS = 5;
  OSSL_FUNC_ENCODER_SETTABLE_CTX_PARAMS = 6;
  OSSL_FUNC_ENCODER_DOES_SELECTION = 10;
  OSSL_FUNC_ENCODER_ENCODE = 11;
  OSSL_FUNC_ENCODER_IMPORT_OBJECT = 20;
  OSSL_FUNC_ENCODER_FREE_OBJECT = 21;

  OSSL_FUNC_DECODER_NEWCTX = 1;
  OSSL_FUNC_DECODER_FREECTX = 2;
  OSSL_FUNC_DECODER_GET_PARAMS = 3;
  OSSL_FUNC_DECODER_GETTABLE_PARAMS = 4;
  OSSL_FUNC_DECODER_SET_CTX_PARAMS = 5;
  OSSL_FUNC_DECODER_SETTABLE_CTX_PARAMS = 6;
  OSSL_FUNC_DECODER_DOES_SELECTION = 10;
  OSSL_FUNC_DECODER_DECODE = 11;
  OSSL_FUNC_DECODER_EXPORT_OBJECT = 20;
  OSSL_DECODER_R_DECODER_NOT_FOUND = 102;
  ENGINE_TABLE_FLAG_NOINIT = UInt32($0001);
  DH_R_BAD_FFC_PARAMETERS = 127;
  DH_R_BAD_GENERATOR = 101;
  DH_R_BN_DECODE_ERROR = 109;
  DH_R_BN_ERROR = 106;
  DH_R_CHECK_INVALID_J_VALUE = 115;
  DH_R_CHECK_INVALID_Q_VALUE = 116;
  DH_R_CHECK_PUBKEY_INVALID = 122;
  DH_R_CHECK_PUBKEY_TOO_LARGE = 123;
  DH_R_CHECK_PUBKEY_TOO_SMALL = 124;
  DH_R_CHECK_P_NOT_PRIME = 117;
  DH_R_CHECK_P_NOT_SAFE_PRIME = 118;
  DH_R_CHECK_Q_NOT_PRIME = 119;
  DH_R_DECODE_ERROR = 104;
  DH_R_INVALID_PARAMETER_NAME = 110;
  DH_R_INVALID_PARAMETER_NID = 114;
  DH_R_INVALID_PUBKEY = 102;
  DH_R_INVALID_SECRET = 128;
  DH_R_KDF_PARAMETER_ERROR = 112;
  DH_R_KEYS_NOT_SET = 108;
  DH_R_MISSING_PUBKEY = 125;
  DH_R_MODULUS_TOO_LARGE = 103;
  DH_R_MODULUS_TOO_SMALL = 126;
  DH_R_NOT_SUITABLE_GENERATOR = 120;
  DH_R_NO_PARAMETERS_SET = 107;
  DH_R_NO_PRIVATE_VALUE = 100;
  DH_R_PARAMETER_ENCODING_ERROR = 105;
  DH_R_PEER_KEY_ERROR = 111;
  DH_R_SHARED_INFO_ERROR = 113;
  DH_R_UNABLE_TO_CHECK_GENERATOR = 121;
  DH_MIN_MODULUS_BITS  =   512;
  IV_STATE_UNINITIALISED = 0;
  IV_STATE_BUFFERED = 1;
  IV_STATE_COPIED = 2;
  IV_STATE_FINISHED = 3;
  NID_magma_ctr_acpkm = 1174;
  NID_magma_ctr_acpkm_omac = 1175;
  NID_kuznyechik_ctr_acpkm = 1177;
  NID_kuznyechik_ctr_acpkm_omac = 1178;
  NID_magma_kexp15 = 1181;
  NID_kuznyechik_kexp15 = 1183;
  NID_gmac = 1195;
  NID_kmac128 = 1196;
  NID_kmac256 = 1197;
  SN_aes_128_siv = 'AES-128-SIV';
  LN_aes_128_siv = 'aes-128-siv';
  NID_aes_128_siv = 1198;
  SN_aes_192_siv = 'AES-192-SIV';
  LN_aes_192_siv = 'aes-192-siv';
  NID_aes_192_siv = 1199;
  SN_aes_256_siv = 'AES-256-SIV';
  LN_aes_256_siv = 'aes-256-siv';
  NID_aes_256_siv = 1200;
  SN_blake2bmac = 'BLAKE2BMAC';
  LN_blake2bmac = 'blake2bmac';
  NID_blake2bmac = 1201;
  SN_blake2smac = 'BLAKE2SMAC';
  LN_blake2smac = 'blake2smac';
  NID_blake2smac = 1202;
  SN_sshkdf = 'SSHKDF';
  LN_sshkdf = 'sshkdf';
  NID_sshkdf = 1203;
  SN_SM2_with_SM3 = 'SM2-SM3';
  LN_SM2_with_SM3 = 'SM2-with-SM3';
  NID_SM2_with_SM3 = 1204;
  SN_sskdf = 'SSKDF';
  LN_sskdf = 'sskdf';
  NID_sskdf = 1205;
  SN_x963kdf = 'X963KDF';
  LN_x963kdf = 'x963kdf';
  NID_x963kdf = 1206;
  SN_x942kdf = 'X942KDF';
  LN_x942kdf = 'x942kdf';
  NID_x942kdf = 1207;
  SN_id_on_SmtpUTF8Mailbox = 'id-on-SmtpUTF8Mailbox';
  LN_id_on_SmtpUTF8Mailbox = 'Smtp UTF8 Mailbox';
  NID_id_on_SmtpUTF8Mailbox = 1208;
  SN_XmppAddr = 'id-on-xmppAddr';
  LN_XmppAddr = 'XmppAddr';
  NID_XmppAddr = 1209;
  SN_SRVName = 'id-on-dnsSRV';
  LN_SRVName = 'SRVName';
  NID_SRVName = 1210;
  SN_NAIRealm = 'id-on-NAIRealm';
  LN_NAIRealm = 'NAIRealm';
  NID_NAIRealm = 1211;
  SN_kx_gost18 = 'KxGOST18';
  LN_kx_gost18 = 'kx-gost18';
  NID_kx_gost18 = 1218;
  SN_cmcArchive = 'cmcArchive';
  LN_cmcArchive = 'CMC Archive Server';
  NID_cmcArchive = 1219;
  SN_id_kp_bgpsec_router = 'id-kp-bgpsec-router';
  LN_id_kp_bgpsec_router = 'BGPsec Router';
  NID_id_kp_bgpsec_router = 1220;
  SN_id_kp_BrandIndicatorforMessageIdentification = 'id-kp-BrandIndicatorforMessageIdentification';
  LN_id_kp_BrandIndicatorforMessageIdentification = 'Brand Indicator for Message Identification';
  NID_id_kp_BrandIndicatorforMessageIdentification = 1221;
  SN_cmKGA = 'cmKGA';
  LN_cmKGA = 'Certificate Management Key Generation Authority';
  NID_cmKGA = 1222;
  SN_id_it_caCerts = 'id-it-caCerts';
  NID_id_it_caCerts = 1223;
  SN_id_it_rootCaKeyUpdate = 'id-it-rootCaKeyUpdate';
  NID_id_it_rootCaKeyUpdate = 1224;
  SN_OGRNIP = 'OGRNIP';
  LN_OGRNIP = 'OGRNIP';
  NID_OGRNIP = 1226;
  SN_classSignTool = 'classSignTool';
  LN_classSignTool = 'Class of Signing Tool';
  NID_classSignTool = 1227;
  SN_classSignToolKC1 = 'classSignToolKC1';
  LN_classSignToolKC1 = 'Class of Signing Tool KC1';
  NID_classSignToolKC1 = 1228;
  { TODO : Macro uses commented-out symbol "OBJ_member_body": }
  (* OBJ_classSignToolKC1 OBJ_member_body , 643L , 100L , 113L , 1L *)
  SN_classSignToolKC2 = 'classSignToolKC2';
  LN_classSignToolKC2 = 'Class of Signing Tool KC2';
  NID_classSignToolKC2 = 1229;
  { TODO : Macro uses commented-out symbol "OBJ_member_body": }
  (* OBJ_classSignToolKC2 OBJ_member_body , 643L , 100L , 113L , 2L *)
  SN_classSignToolKC3 = 'classSignToolKC3';
  LN_classSignToolKC3 = 'Class of Signing Tool KC3';
  NID_classSignToolKC3 = 1230;

  SN_classSignToolKB1 = 'classSignToolKB1';
  LN_classSignToolKB1 = 'Class of Signing Tool KB1';
  NID_classSignToolKB1 = 1231;

  SN_classSignToolKB2 = 'classSignToolKB2';
  LN_classSignToolKB2 = 'Class of Signing Tool KB2';
  NID_classSignToolKB2 = 1232;

  SN_id_ct_routeOriginAuthz = 'id-ct-routeOriginAuthz';
  NID_id_ct_routeOriginAuthz = 1234;
  SN_id_ct_rpkiGhostbusters = 'id-ct-rpkiGhostbusters';
  NID_id_ct_rpkiGhostbusters = 1236;
  SN_id_cp = 'id-cp';
  NID_id_cp = 1238;
  SN_sbgp_ipAddrBlockv2 = 'sbgp-ipAddrBlockv2';
  NID_sbgp_ipAddrBlockv2 = 1239;
  SN_ipAddr_asNumber = 'ipAddr-asNumber';
  NID_ipAddr_asNumber = 1241;
  SN_rpkiManifest = 'rpkiManifest';
  LN_rpkiManifest = 'RPKI Manifest';
  NID_rpkiManifest = 1243;
  SN_rpkiNotify = 'rpkiNotify';
  LN_rpkiNotify = 'RPKI Notify';
  NID_rpkiNotify = 1245;
  SN_id_ct_geofeedCSVwithCRLF = 'id-ct-geofeedCSVwithCRLF';
  NID_id_ct_geofeedCSVwithCRLF = 1246;
   SN_sm4_gcm = 'SM4-GCM';
  LN_sm4_gcm = 'sm4-gcm';
  NID_sm4_gcm = 1248;
  SN_id_ct_ASPA = 'id-ct-ASPA';
  NID_id_ct_ASPA = 1250;
  SN_sm4_ccm = 'SM4-CCM';
  LN_sm4_ccm = 'sm4-ccm';
  NID_sm4_ccm = 1249;
  SN_id_ct_signedChecklist = 'id-ct-signedChecklist';
  NID_id_ct_signedChecklist = 1247;
  SN_signedObject = 'signedObject';
  LN_signedObject = 'Signed Object';
  NID_signedObject = 1244;
  SN_ipAddr_asNumberv2 = 'ipAddr-asNumberv2';
  NID_ipAddr_asNumberv2 = 1242;
  SN_sbgp_autonomousSysNumv2 = 'sbgp-autonomousSysNumv2';
  NID_sbgp_autonomousSysNumv2 = 1240;
  SN_id_ct_resourceTaggedAttest = 'id-ct-resourceTaggedAttest';
  NID_id_ct_resourceTaggedAttest = 1237;
  SN_id_ct_rpkiManifest = 'id-ct-rpkiManifest';
  NID_id_ct_rpkiManifest = 1235;
  SN_classSignToolKA1 = 'classSignToolKA1';
  LN_classSignToolKA1 = 'Class of Signing Tool KA1';
  NID_classSignToolKA1 = 1233;
  SN_id_it_certReqTemplate = 'id-it-certReqTemplate';
  NID_id_it_certReqTemplate = 1225;
  SN_kuznyechik_ecb = 'kuznyechik-ecb';
  NID_kuznyechik_ecb = 1012;
  SN_kuznyechik_ctr = 'kuznyechik-ctr';
  NID_kuznyechik_ctr = 1013;
  SN_kuznyechik_ofb = 'kuznyechik-ofb';
  NID_kuznyechik_ofb = 1014;
  SN_kuznyechik_cbc = 'kuznyechik-cbc';
  NID_kuznyechik_cbc = 1015;
  SN_kuznyechik_cfb = 'kuznyechik-cfb';
  NID_kuznyechik_cfb = 1016;
  SN_kuznyechik_mac = 'kuznyechik-mac';
  NID_kuznyechik_mac = 1017;

  SIV_LEN = 16;
  ASN1_R_ADDING_OBJECT = 171;
  ASN1_R_ASN1_PARSE_ERROR = 203;
  ASN1_R_ASN1_SIG_PARSE_ERROR = 204;
  ASN1_R_AUX_ERROR = 100;
  ASN1_R_BAD_OBJECT_HEADER = 102;
  ASN1_R_BAD_TEMPLATE = 230;
  ASN1_R_BMPSTRING_IS_WRONG_LENGTH = 214;
  ASN1_R_BN_LIB = 105;
  ASN1_R_BOOLEAN_IS_WRONG_LENGTH = 106;
  ASN1_R_BUFFER_TOO_SMALL = 107;
  ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER = 108;
  ASN1_R_CONTEXT_NOT_INITIALISED = 217;
  ASN1_R_DATA_IS_WRONG = 109;
  ASN1_R_DECODE_ERROR = 110;
  ASN1_R_DEPTH_EXCEEDED = 174;
  ASN1_R_DIGEST_AND_KEY_TYPE_NOT_SUPPORTED = 198;
  ASN1_R_ENCODE_ERROR = 112;
  ASN1_R_ERROR_GETTING_TIME = 173;
  ASN1_R_ERROR_LOADING_SECTION = 172;
  ASN1_R_ERROR_SETTING_CIPHER_PARAMS = 114;
  ASN1_R_EXPECTING_AN_INTEGER = 115;
  ASN1_R_EXPECTING_AN_OBJECT = 116;
  ASN1_R_EXPLICIT_LENGTH_MISMATCH = 119;
  ASN1_R_EXPLICIT_TAG_NOT_CONSTRUCTED = 120;
  ASN1_R_FIELD_MISSING = 121;
  ASN1_R_FIRST_NUM_TOO_LARGE = 122;
  ASN1_R_HEADER_TOO_LONG = 123;
  ASN1_R_ILLEGAL_BITSTRING_FORMAT = 175;
  ASN1_R_ILLEGAL_BOOLEAN = 176;
  ASN1_R_ILLEGAL_CHARACTERS = 124;
  ASN1_R_ILLEGAL_FORMAT = 177;
  ASN1_R_ILLEGAL_HEX = 178;
  ASN1_R_ILLEGAL_IMPLICIT_TAG = 179;
  ASN1_R_ILLEGAL_INTEGER = 180;
  ASN1_R_ILLEGAL_NEGATIVE_VALUE = 226;
  ASN1_R_ILLEGAL_NESTED_TAGGING = 181;
  ASN1_R_ILLEGAL_NULL = 125;
  ASN1_R_ILLEGAL_NULL_VALUE = 182;
  ASN1_R_ILLEGAL_OBJECT = 183;
  ASN1_R_ILLEGAL_OPTIONAL_ANY = 126;
  ASN1_R_ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE = 170;
  ASN1_R_ILLEGAL_PADDING = 221;
  ASN1_R_ILLEGAL_TAGGED_ANY = 127;
  ASN1_R_ILLEGAL_TIME_VALUE = 184;
  ASN1_R_ILLEGAL_ZERO_CONTENT = 222;
  ASN1_R_INTEGER_NOT_ASCII_FORMAT = 185;
  ASN1_R_INTEGER_TOO_LARGE_FOR_LONG = 128;
  ASN1_R_INVALID_BIT_STRING_BITS_LEFT = 220;
  ASN1_R_INVALID_BMPSTRING_LENGTH = 129;
  ASN1_R_INVALID_DIGIT = 130;
  ASN1_R_INVALID_MIME_TYPE = 205;
  ASN1_R_INVALID_MODIFIER = 186;
  ASN1_R_INVALID_NUMBER = 187;
  ASN1_R_INVALID_OBJECT_ENCODING = 216;
  ASN1_R_INVALID_SCRYPT_PARAMETERS = 227;
  ASN1_R_INVALID_SEPARATOR = 131;
  ASN1_R_INVALID_STRING_TABLE_VALUE = 218;
  ASN1_R_INVALID_UNIVERSALSTRING_LENGTH = 133;
  ASN1_R_INVALID_UTF8STRING = 134;
  ASN1_R_INVALID_VALUE = 219;
  ASN1_R_LENGTH_TOO_LONG = 231;
  ASN1_R_LIST_ERROR = 188;
  ASN1_R_MIME_NO_CONTENT_TYPE = 206;
  ASN1_R_MIME_PARSE_ERROR = 207;
  ASN1_R_MIME_SIG_PARSE_ERROR = 208;
  ASN1_R_MISSING_EOC = 137;
  ASN1_R_MISSING_SECOND_NUMBER = 138;
  ASN1_R_MISSING_VALUE = 189;
  ASN1_R_MSTRING_NOT_UNIVERSAL = 139;
  ASN1_R_MSTRING_WRONG_TAG = 140;
  ASN1_R_NESTED_ASN1_STRING = 197;
  ASN1_R_NESTED_TOO_DEEP = 201;
  ASN1_R_NON_HEX_CHARACTERS = 141;
  ASN1_R_NOT_ASCII_FORMAT = 190;
  ASN1_R_NOT_ENOUGH_DATA = 142;
  ASN1_R_NO_CONTENT_TYPE = 209;
  ASN1_R_NO_MATCHING_CHOICE_TYPE = 143;
  ASN1_R_NO_MULTIPART_BODY_FAILURE = 210;
  ASN1_R_NO_MULTIPART_BOUNDARY = 211;
  ASN1_R_NO_SIG_CONTENT_TYPE = 212;
  ASN1_R_NULL_IS_WRONG_LENGTH = 144;
  ASN1_R_OBJECT_NOT_ASCII_FORMAT = 191;
  ASN1_R_ODD_NUMBER_OF_CHARS = 145;
  ASN1_R_SECOND_NUMBER_TOO_LARGE = 147;
  ASN1_R_SEQUENCE_LENGTH_MISMATCH = 148;
  ASN1_R_SEQUENCE_NOT_CONSTRUCTED = 149;
  ASN1_R_SEQUENCE_OR_SET_NEEDS_CONFIG = 192;
  ASN1_R_SHORT_LINE = 150;
  ASN1_R_SIG_INVALID_MIME_TYPE = 213;
  ASN1_R_STREAMING_NOT_SUPPORTED = 202;
  ASN1_R_STRING_TOO_LONG = 151;
  ASN1_R_STRING_TOO_SHORT = 152;
  ASN1_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD = 154;
  ASN1_R_TIME_NOT_ASCII_FORMAT = 193;
  ASN1_R_TOO_LARGE = 223;
  ASN1_R_TOO_LONG = 155;
  ASN1_R_TOO_SMALL = 224;
  ASN1_R_TYPE_NOT_CONSTRUCTED = 156;
  ASN1_R_TYPE_NOT_PRIMITIVE = 195;
  ASN1_R_UNEXPECTED_EOC = 159;
  ASN1_R_UNIVERSALSTRING_IS_WRONG_LENGTH = 215;
  ASN1_R_UNKNOWN_DIGEST = 229;
  ASN1_R_UNKNOWN_FORMAT = 160;
  ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM = 161;
  ASN1_R_UNKNOWN_OBJECT_TYPE = 162;
  ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE = 163;
  ASN1_R_UNKNOWN_SIGNATURE_ALGORITHM = 199;
  ASN1_R_UNKNOWN_TAG = 194;
  ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE = 164;
  ASN1_R_UNSUPPORTED_CIPHER = 228;
  ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE = 167;
  ASN1_R_UNSUPPORTED_TYPE = 196;
  ASN1_R_WRONG_INTEGER_TYPE = 225;
  ASN1_R_WRONG_PUBLIC_KEY_TYPE = 200;
  ASN1_R_WRONG_TAG = 168;

  OPENSSL_VERSION_STR = '3.1.0';
  OPENSSL_FULL_VERSION_STR = '3.1.0-dev';
  PROV_NAMES_AES_256_ECB = 'AES-256-ECB:2.16.840.1.101.3.4.1.41';
  PROV_NAMES_AES_192_ECB = 'AES-192-ECB:2.16.840.1.101.3.4.1.21';
  PROV_NAMES_AES_128_ECB = 'AES-128-ECB:2.16.840.1.101.3.4.1.1';
  PROV_NAMES_AES_256_CBC = 'AES-256-CBC:AES256:2.16.840.1.101.3.4.1.42';
  PROV_NAMES_AES_192_CBC = 'AES-192-CBC:AES192:2.16.840.1.101.3.4.1.22';
  PROV_NAMES_AES_128_CBC = 'AES-128-CBC:AES128:2.16.840.1.101.3.4.1.2';
  PROV_NAMES_AES_256_CBC_CTS = 'AES-256-CBC-CTS';
  PROV_NAMES_AES_192_CBC_CTS = 'AES-192-CBC-CTS';
  PROV_NAMES_AES_128_CBC_CTS = 'AES-128-CBC-CTS';
  PROV_NAMES_AES_256_OFB = 'AES-256-OFB:2.16.840.1.101.3.4.1.43';
  PROV_NAMES_AES_192_OFB = 'AES-192-OFB:2.16.840.1.101.3.4.1.23';
  PROV_NAMES_AES_128_OFB = 'AES-128-OFB:2.16.840.1.101.3.4.1.3';
  PROV_NAMES_AES_256_CFB = 'AES-256-CFB:2.16.840.1.101.3.4.1.44';
  PROV_NAMES_AES_192_CFB = 'AES-192-CFB:2.16.840.1.101.3.4.1.24';
  PROV_NAMES_AES_128_CFB = 'AES-128-CFB:2.16.840.1.101.3.4.1.4';
  PROV_NAMES_AES_256_CFB1 = 'AES-256-CFB1';
  PROV_NAMES_AES_192_CFB1 = 'AES-192-CFB1';
  PROV_NAMES_AES_128_CFB1 = 'AES-128-CFB1';
  PROV_NAMES_AES_256_CFB8 = 'AES-256-CFB8';
  PROV_NAMES_AES_192_CFB8 = 'AES-192-CFB8';
  PROV_NAMES_AES_128_CFB8 = 'AES-128-CFB8';
  PROV_NAMES_AES_256_CTR = 'AES-256-CTR';
  PROV_NAMES_AES_192_CTR = 'AES-192-CTR';
  PROV_NAMES_AES_128_CTR = 'AES-128-CTR';
  PROV_NAMES_AES_256_XTS = 'AES-256-XTS:1.3.111.2.1619.0.1.2';
  PROV_NAMES_AES_128_XTS = 'AES-128-XTS:1.3.111.2.1619.0.1.1';
  PROV_NAMES_AES_256_GCM = 'AES-256-GCM:id-aes256-GCM:2.16.840.1.101.3.4.1.46';
  PROV_NAMES_AES_192_GCM = 'AES-192-GCM:id-aes192-GCM:2.16.840.1.101.3.4.1.26';
  PROV_NAMES_AES_128_GCM = 'AES-128-GCM:id-aes128-GCM:2.16.840.1.101.3.4.1.6';
  PROV_NAMES_AES_256_CCM = 'AES-256-CCM:id-aes256-CCM:2.16.840.1.101.3.4.1.47';
  PROV_NAMES_AES_192_CCM = 'AES-192-CCM:id-aes192-CCM:2.16.840.1.101.3.4.1.27';
  PROV_NAMES_AES_128_CCM = 'AES-128-CCM:id-aes128-CCM:2.16.840.1.101.3.4.1.7';
  PROV_NAMES_AES_256_WRAP = 'AES-256-WRAP:id-aes256-wrap:AES256-WRAP:2.16.840.1.101.3.4.1.45';
  PROV_NAMES_AES_192_WRAP = 'AES-192-WRAP:id-aes192-wrap:AES192-WRAP:2.16.840.1.101.3.4.1.25';
  PROV_NAMES_AES_128_WRAP = 'AES-128-WRAP:id-aes128-wrap:AES128-WRAP:2.16.840.1.101.3.4.1.5';
  PROV_NAMES_AES_256_WRAP_PAD = 'AES-256-WRAP-PAD:id-aes256-wrap-pad:AES256-WRAP-PAD:2.16.840.1.101.3.4.1.48';
  PROV_NAMES_AES_192_WRAP_PAD = 'AES-192-WRAP-PAD:id-aes192-wrap-pad:AES192-WRAP-PAD:2.16.840.1.101.3.4.1.28';
  PROV_NAMES_AES_128_WRAP_PAD = 'AES-128-WRAP-PAD:id-aes128-wrap-pad:AES128-WRAP-PAD:2.16.840.1.101.3.4.1.8';
  PROV_NAMES_AES_256_WRAP_INV = 'AES-256-WRAP-INV:AES256-WRAP-INV';
  PROV_NAMES_AES_192_WRAP_INV = 'AES-192-WRAP-INV:AES192-WRAP-INV';
  PROV_NAMES_AES_128_WRAP_INV = 'AES-128-WRAP-INV:AES128-WRAP-INV';
  PROV_NAMES_AES_256_WRAP_PAD_INV = 'AES-256-WRAP-PAD-INV:AES256-WRAP-PAD-INV';
  PROV_NAMES_AES_192_WRAP_PAD_INV = 'AES-192-WRAP-PAD-INV:AES192-WRAP-PAD-INV';
  PROV_NAMES_AES_128_WRAP_PAD_INV = 'AES-128-WRAP-PAD-INV:AES128-WRAP-PAD-INV';
  PROV_NAMES_AES_128_CBC_HMAC_SHA1 = 'AES-128-CBC-HMAC-SHA1';
  PROV_NAMES_AES_256_CBC_HMAC_SHA1 = 'AES-256-CBC-HMAC-SHA1';
  PROV_NAMES_AES_128_CBC_HMAC_SHA256 = 'AES-128-CBC-HMAC-SHA256';
  PROV_NAMES_AES_256_CBC_HMAC_SHA256 = 'AES-256-CBC-HMAC-SHA256';
  PROV_NAMES_DES_EDE3_ECB = 'DES-EDE3-ECB:DES-EDE3';
  PROV_NAMES_DES_EDE3_CBC = 'DES-EDE3-CBC:DES3:1.2.840.113549.3.7';
  PROV_NAMES_NULL = 'NULL';
  PROV_NAMES_AES_256_OCB = 'AES-256-OCB';
  PROV_NAMES_AES_192_OCB = 'AES-192-OCB';
  PROV_NAMES_AES_128_OCB = 'AES-128-OCB';
  PROV_NAMES_AES_128_SIV = 'AES-128-SIV';
  PROV_NAMES_AES_192_SIV = 'AES-192-SIV';
  PROV_NAMES_AES_256_SIV = 'AES-256-SIV';
  PROV_NAMES_ARIA_256_GCM = 'ARIA-256-GCM:1.2.410.200046.1.1.36';
  PROV_NAMES_ARIA_192_GCM = 'ARIA-192-GCM:1.2.410.200046.1.1.35';
  PROV_NAMES_ARIA_128_GCM = 'ARIA-128-GCM:1.2.410.200046.1.1.34';
  PROV_NAMES_ARIA_256_CCM = 'ARIA-256-CCM:1.2.410.200046.1.1.39';
  PROV_NAMES_ARIA_192_CCM = 'ARIA-192-CCM:1.2.410.200046.1.1.38';
  PROV_NAMES_ARIA_128_CCM = 'ARIA-128-CCM:1.2.410.200046.1.1.37';
  PROV_NAMES_ARIA_256_ECB = 'ARIA-256-ECB:1.2.410.200046.1.1.11';
  PROV_NAMES_ARIA_192_ECB = 'ARIA-192-ECB:1.2.410.200046.1.1.6';
  PROV_NAMES_ARIA_128_ECB = 'ARIA-128-ECB:1.2.410.200046.1.1.1';
  PROV_NAMES_ARIA_256_CBC = 'ARIA-256-CBC:ARIA256:1.2.410.200046.1.1.12';
  PROV_NAMES_ARIA_192_CBC = 'ARIA-192-CBC:ARIA192:1.2.410.200046.1.1.7';
  PROV_NAMES_ARIA_128_CBC = 'ARIA-128-CBC:ARIA128:1.2.410.200046.1.1.2';
  PROV_NAMES_ARIA_256_OFB = 'ARIA-256-OFB:1.2.410.200046.1.1.14';
  PROV_NAMES_ARIA_192_OFB = 'ARIA-192-OFB:1.2.410.200046.1.1.9';
  PROV_NAMES_ARIA_128_OFB = 'ARIA-128-OFB:1.2.410.200046.1.1.4';
  PROV_NAMES_ARIA_256_CFB = 'ARIA-256-CFB:1.2.410.200046.1.1.13';
  PROV_NAMES_ARIA_192_CFB = 'ARIA-192-CFB:1.2.410.200046.1.1.8';
  PROV_NAMES_ARIA_128_CFB = 'ARIA-128-CFB:1.2.410.200046.1.1.3';
  PROV_NAMES_ARIA_256_CFB1 = 'ARIA-256-CFB1';
  PROV_NAMES_ARIA_192_CFB1 = 'ARIA-192-CFB1';
  PROV_NAMES_ARIA_128_CFB1 = 'ARIA-128-CFB1';
  PROV_NAMES_ARIA_256_CFB8 = 'ARIA-256-CFB8';
  PROV_NAMES_ARIA_192_CFB8 = 'ARIA-192-CFB8';
  PROV_NAMES_ARIA_128_CFB8 = 'ARIA-128-CFB8';
  PROV_NAMES_ARIA_256_CTR = 'ARIA-256-CTR:1.2.410.200046.1.1.15';
  PROV_NAMES_ARIA_192_CTR = 'ARIA-192-CTR:1.2.410.200046.1.1.10';
  PROV_NAMES_ARIA_128_CTR = 'ARIA-128-CTR:1.2.410.200046.1.1.5';
  PROV_NAMES_CAMELLIA_256_ECB = 'CAMELLIA-256-ECB:0.3.4401.5.3.1.9.41';
  PROV_NAMES_CAMELLIA_192_ECB = 'CAMELLIA-192-ECB:0.3.4401.5.3.1.9.21';
  PROV_NAMES_CAMELLIA_128_ECB = 'CAMELLIA-128-ECB:0.3.4401.5.3.1.9.1';
  PROV_NAMES_CAMELLIA_256_CBC = 'CAMELLIA-256-CBC:CAMELLIA256:1.2.392.200011.61.1.1.1.4';
  PROV_NAMES_CAMELLIA_192_CBC = 'CAMELLIA-192-CBC:CAMELLIA192:1.2.392.200011.61.1.1.1.3';
  PROV_NAMES_CAMELLIA_128_CBC = 'CAMELLIA-128-CBC:CAMELLIA128:1.2.392.200011.61.1.1.1.2';
  PROV_NAMES_CAMELLIA_256_CBC_CTS = 'CAMELLIA-256-CBC-CTS';
  PROV_NAMES_CAMELLIA_192_CBC_CTS = 'CAMELLIA-192-CBC-CTS';
  PROV_NAMES_CAMELLIA_128_CBC_CTS = 'CAMELLIA-128-CBC-CTS';
  PROV_NAMES_CAMELLIA_256_OFB = 'CAMELLIA-256-OFB:0.3.4401.5.3.1.9.43';
  PROV_NAMES_CAMELLIA_192_OFB = 'CAMELLIA-192-OFB:0.3.4401.5.3.1.9.23';
  PROV_NAMES_CAMELLIA_128_OFB = 'CAMELLIA-128-OFB:0.3.4401.5.3.1.9.3';
  PROV_NAMES_CAMELLIA_256_CFB = 'CAMELLIA-256-CFB:0.3.4401.5.3.1.9.44';
  PROV_NAMES_CAMELLIA_192_CFB = 'CAMELLIA-192-CFB:0.3.4401.5.3.1.9.24';
  PROV_NAMES_CAMELLIA_128_CFB = 'CAMELLIA-128-CFB:0.3.4401.5.3.1.9.4';
  PROV_NAMES_CAMELLIA_256_CFB1 = 'CAMELLIA-256-CFB1';
  PROV_NAMES_CAMELLIA_192_CFB1 = 'CAMELLIA-192-CFB1';
  PROV_NAMES_CAMELLIA_128_CFB1 = 'CAMELLIA-128-CFB1';
  PROV_NAMES_CAMELLIA_256_CFB8 = 'CAMELLIA-256-CFB8';
  PROV_NAMES_CAMELLIA_192_CFB8 = 'CAMELLIA-192-CFB8';
  PROV_NAMES_CAMELLIA_128_CFB8 = 'CAMELLIA-128-CFB8';
  PROV_NAMES_CAMELLIA_256_CTR = 'CAMELLIA-256-CTR:0.3.4401.5.3.1.9.49';
  PROV_NAMES_CAMELLIA_192_CTR = 'CAMELLIA-192-CTR:0.3.4401.5.3.1.9.29';
  PROV_NAMES_CAMELLIA_128_CTR = 'CAMELLIA-128-CTR:0.3.4401.5.3.1.9.9';
  PROV_NAMES_DES_EDE3_OFB = 'DES-EDE3-OFB';
  PROV_NAMES_DES_EDE3_CFB = 'DES-EDE3-CFB';
  PROV_NAMES_DES_EDE3_CFB8 = 'DES-EDE3-CFB8';
  PROV_NAMES_DES_EDE3_CFB1 = 'DES-EDE3-CFB1';
  PROV_NAMES_DES3_WRAP = 'DES3-WRAP:id-smime-alg-CMS3DESwrap:1.2.840.113549.1.9.16.3.6';
  PROV_NAMES_DES_EDE_ECB = 'DES-EDE-ECB:DES-EDE:1.3.14.3.2.17';
  PROV_NAMES_DES_EDE_CBC = 'DES-EDE-CBC';
  PROV_NAMES_DES_EDE_OFB = 'DES-EDE-OFB';
  PROV_NAMES_DES_EDE_CFB = 'DES-EDE-CFB';
  PROV_NAMES_SM4_ECB = 'SM4-ECB:1.2.156.10197.1.104.1';
  PROV_NAMES_SM4_CBC = 'SM4-CBC:SM4:1.2.156.10197.1.104.2';
  PROV_NAMES_SM4_CTR = 'SM4-CTR:1.2.156.10197.1.104.7';
  PROV_NAMES_SM4_OFB = 'SM4-OFB:SM4-OFB128:1.2.156.10197.1.104.3';
  PROV_NAMES_SM4_CFB = 'SM4-CFB:SM4-CFB128:1.2.156.10197.1.104.4';
  PROV_NAMES_SM4_GCM = 'SM4-GCM:1.2.156.10197.1.104.8';
  PROV_NAMES_SM4_CCM = 'SM4-CCM:1.2.156.10197.1.104.9';
  PROV_NAMES_ChaCha20 = 'ChaCha20';
  PROV_NAMES_ChaCha20_Poly1305 = 'ChaCha20-Poly1305';
  PROV_NAMES_CAST5_ECB = 'CAST5-ECB';
  PROV_NAMES_CAST5_CBC = 'CAST5-CBC:CAST-CBC:CAST:1.2.840.113533.7.66.10';
  PROV_NAMES_CAST5_OFB = 'CAST5-OFB';
  PROV_NAMES_CAST5_CFB = 'CAST5-CFB';
  PROV_NAMES_BF_ECB = 'BF-ECB';
  PROV_NAMES_BF_CBC = 'BF-CBC:BF:BLOWFISH:1.3.6.1.4.1.3029.1.2';
  PROV_NAMES_BF_OFB = 'BF-OFB';
  PROV_NAMES_BF_CFB = 'BF-CFB';
  PROV_NAMES_IDEA_ECB = 'IDEA-ECB';
  PROV_NAMES_IDEA_CBC = 'IDEA-CBC:IDEA:1.3.6.1.4.1.188.7.1.1.2';
  PROV_NAMES_IDEA_OFB = 'IDEA-OFB:IDEA-OFB64';
  PROV_NAMES_IDEA_CFB = 'IDEA-CFB:IDEA-CFB64';
  PROV_NAMES_SEED_ECB = 'SEED-ECB:1.2.410.200004.1.3';
  PROV_NAMES_SEED_CBC = 'SEED-CBC:SEED:1.2.410.200004.1.4';
  PROV_NAMES_SEED_OFB = 'SEED-OFB:SEED-OFB128:1.2.410.200004.1.6';
  PROV_NAMES_SEED_CFB = 'SEED-CFB:SEED-CFB128:1.2.410.200004.1.5';
  PROV_NAMES_RC2_ECB = 'RC2-ECB';
  PROV_NAMES_RC2_CBC = 'RC2-CBC:RC2:RC2-128:1.2.840.113549.3.2';
  PROV_NAMES_RC2_40_CBC = 'RC2-40-CBC:RC2-40';
  PROV_NAMES_RC2_64_CBC = 'RC2-64-CBC:RC2-64';
  PROV_NAMES_RC2_CFB = 'RC2-CFB';
  PROV_NAMES_RC2_OFB = 'RC2-OFB';
  PROV_NAMES_RC4 = 'RC4:1.2.840.113549.3.4';
  PROV_NAMES_RC4_40 = 'RC4-40';
  PROV_NAMES_RC4_HMAC_MD5 = 'RC4-HMAC-MD5';
  PROV_NAMES_RC5_ECB = 'RC5-ECB';
  PROV_NAMES_RC5_CBC = 'RC5-CBC:RC5:1.2.840.113549.3.8';
  PROV_NAMES_RC5_OFB = 'RC5-OFB';
  PROV_NAMES_RC5_CFB = 'RC5-CFB';
  PROV_NAMES_DESX_CBC = 'DESX-CBC:DESX';
  PROV_NAMES_DES_ECB = 'DES-ECB:1.3.14.3.2.6';
  PROV_NAMES_DES_CBC = 'DES-CBC:DES:1.3.14.3.2.7';
  PROV_NAMES_DES_OFB = 'DES-OFB:1.3.14.3.2.8';
  PROV_NAMES_DES_CFB = 'DES-CFB:1.3.14.3.2.9';
  PROV_NAMES_DES_CFB1 = 'DES-CFB1';
  PROV_NAMES_DES_CFB8 = 'DES-CFB8';
  PROV_NAMES_SHA1 = 'SHA1:SHA-1:SSL3-SHA1:1.3.14.3.2.26';
  PROV_NAMES_SHA2_224 = 'SHA2-224:SHA-224:SHA224:2.16.840.1.101.3.4.2.4';
  PROV_NAMES_SHA2_256 = 'SHA2-256:SHA-256:SHA256:2.16.840.1.101.3.4.2.1';
  PROV_NAMES_SHA2_384 = 'SHA2-384:SHA-384:SHA384:2.16.840.1.101.3.4.2.2';
  PROV_NAMES_SHA2_512 = 'SHA2-512:SHA-512:SHA512:2.16.840.1.101.3.4.2.3';
  PROV_NAMES_SHA2_512_224 = 'SHA2-512/224:SHA-512/224:SHA512-224:2.16.840.1.101.3.4.2.5';
  PROV_NAMES_SHA2_512_256 = 'SHA2-512/256:SHA-512/256:SHA512-256:2.16.840.1.101.3.4.2.6';
  PROV_NAMES_SHA3_224 = 'SHA3-224:2.16.840.1.101.3.4.2.7';
  PROV_NAMES_SHA3_256 = 'SHA3-256:2.16.840.1.101.3.4.2.8';
  PROV_NAMES_SHA3_384 = 'SHA3-384:2.16.840.1.101.3.4.2.9';
  PROV_NAMES_SHA3_512 = 'SHA3-512:2.16.840.1.101.3.4.2.10';
  PROV_NAMES_KECCAK_224 = 'KECCAK-224';
  PROV_NAMES_KECCAK_256 = 'KECCAK-256';
  PROV_NAMES_KECCAK_384 = 'KECCAK-384';
  PROV_NAMES_KECCAK_512 = 'KECCAK-512';
  PROV_NAMES_SHAKE_128 = 'SHAKE-128:SHAKE128:2.16.840.1.101.3.4.2.11';
  PROV_NAMES_SHAKE_256 = 'SHAKE-256:SHAKE256:2.16.840.1.101.3.4.2.12';
  PROV_NAMES_KECCAK_KMAC_128 = 'KECCAK-KMAC-128:KECCAK-KMAC128';
  PROV_NAMES_KECCAK_KMAC_256 = 'KECCAK-KMAC-256:KECCAK-KMAC256';
  PROV_NAMES_BLAKE2S_256 = 'BLAKE2S-256:BLAKE2s256:1.3.6.1.4.1.1722.12.2.2.8';
  PROV_NAMES_BLAKE2B_512 = 'BLAKE2B-512:BLAKE2b512:1.3.6.1.4.1.1722.12.2.1.16';
  PROV_NAMES_SM3 = 'SM3:1.2.156.10197.1.401';
  PROV_NAMES_MD5 = 'MD5:SSL3-MD5:1.2.840.113549.2.5';
  PROV_NAMES_MD5_SHA1 = 'MD5-SHA1';
  PROV_NAMES_MD2 = 'MD2:1.2.840.113549.2.2';
  PROV_NAMES_MD4 = 'MD4:1.2.840.113549.2.4';
  PROV_NAMES_MDC2 = 'MDC2:2.5.8.3.101';
  PROV_NAMES_WHIRLPOOL = 'WHIRLPOOL:1.0.10118.3.0.55';
  PROV_NAMES_RIPEMD_160 = 'RIPEMD-160:RIPEMD160:RIPEMD:RMD160:1.3.36.3.2.1';
  PROV_NAMES_HKDF = 'HKDF';
  PROV_DESCS_HKDF_SIGN = 'OpenSSL HKDF via EVP_PKEY implementation';
  PROV_NAMES_TLS1_3_KDF = 'TLS13-KDF';
  PROV_NAMES_SSKDF = 'SSKDF';
  PROV_NAMES_PBKDF1 = 'PBKDF1';
  PROV_NAMES_PBKDF2 = 'PBKDF2:1.2.840.113549.1.5.12';
  PROV_NAMES_PVKKDF = 'PVKKDF';
  PROV_NAMES_SSHKDF = 'SSHKDF';
  PROV_NAMES_X963KDF = 'X963KDF:X942KDF-CONCAT';
  PROV_NAMES_X942KDF_ASN1 = 'X942KDF-ASN1:X942KDF';
  PROV_NAMES_TLS1_PRF = 'TLS1-PRF';
  PROV_DESCS_TLS1_PRF_SIGN = 'OpenSSL TLS1_PRF via EVP_PKEY implementation';
  PROV_NAMES_KBKDF = 'KBKDF';
  PROV_NAMES_PKCS12KDF = 'PKCS12KDF';
  PROV_NAMES_SCRYPT = 'SCRYPT:id-scrypt:1.3.6.1.4.1.11591.4.11';
  PROV_DESCS_SCRYPT_SIGN = 'OpenSSL SCRYPT via EVP_PKEY implementation';
  PROV_NAMES_KRB5KDF = 'KRB5KDF';
  PROV_NAMES_HMAC = 'HMAC';
  PROV_DESCS_HMAC_SIGN = 'OpenSSL HMAC via EVP_PKEY implementation';
  PROV_NAMES_CMAC = 'CMAC';
  PROV_DESCS_CMAC_SIGN = 'OpenSSL CMAC via EVP_PKEY implementation';
  PROV_NAMES_SIPHASH = 'SIPHASH';
  PROV_DESCS_SIPHASH_SIGN = 'OpenSSL SIPHASH via EVP_PKEY implementation';
  PROV_NAMES_POLY1305 = 'POLY1305';
  PROV_DESCS_POLY1305_SIGN = 'OpenSSL POLY1305 via EVP_PKEY implementation';
  PROV_NAMES_GMAC = 'GMAC:1.0.9797.3.4';
  PROV_NAMES_KMAC_128 = 'KMAC-128:KMAC128:2.16.840.1.101.3.4.2.19';
  PROV_NAMES_KMAC_256 = 'KMAC-256:KMAC256:2.16.840.1.101.3.4.2.20';
  PROV_NAMES_BLAKE2BMAC = 'BLAKE2BMAC:1.3.6.1.4.1.1722.12.2.1';
  PROV_NAMES_BLAKE2SMAC = 'BLAKE2SMAC:1.3.6.1.4.1.1722.12.2.2';
  PROV_NAMES_CTR_DRBG = 'CTR-DRBG';
  PROV_NAMES_HASH_DRBG = 'HASH-DRBG';
  PROV_NAMES_HMAC_DRBG = 'HMAC-DRBG';
  PROV_NAMES_TEST_RAND = 'TEST-RAND';
  PROV_NAMES_SEED_SRC = 'SEED-SRC';
  PROV_NAMES_EC = 'EC:id-ecPublicKey:1.2.840.10045.2.1';
  PROV_DESCS_EC = 'OpenSSL EC implementation';
  PROV_NAMES_ECDH = 'ECDH';
  PROV_DESCS_ECDH = 'OpenSSL ECDH implementation';
  PROV_NAMES_ECDSA = 'ECDSA';
  PROV_DESCS_ECDSA = 'OpenSSL ECDSA implementation';
  PROV_NAMES_X25519 = 'X25519:1.3.101.110';
  PROV_DESCS_X25519 = 'OpenSSL X25519 implementation';
  PROV_NAMES_X448 = 'X448:1.3.101.111';
  PROV_DESCS_X448 = 'OpenSSL X448 implementation';
  PROV_NAMES_ED25519 = 'ED25519:1.3.101.112';
  PROV_DESCS_ED25519 = 'OpenSSL ED25519 implementation';
  PROV_NAMES_ED448 = 'ED448:1.3.101.113';
  PROV_DESCS_ED448 = 'OpenSSL ED448 implementation';
  PROV_NAMES_DH = 'DH:dhKeyAgreement:1.2.840.113549.1.3.1';
  PROV_DESCS_DH = 'OpenSSL PKCS#3 DH implementation';
  PROV_NAMES_DHX = 'DHX:X9.42 DH:dhpublicnumber:1.2.840.10046.2.1';
  PROV_DESCS_DHX = 'OpenSSL X9.42 DH implementation';
  PROV_NAMES_DSA = 'DSA:dsaEncryption:1.2.840.10040.4.1';
  PROV_DESCS_DSA = 'OpenSSL DSA implementation';
  PROV_NAMES_RSA = 'RSA:rsaEncryption:1.2.840.113549.1.1.1';
  PROV_DESCS_RSA = 'OpenSSL RSA implementation';
  PROV_NAMES_RSA_PSS = 'RSA-PSS:RSASSA-PSS:1.2.840.113549.1.1.10';
  PROV_DESCS_RSA_PSS = 'OpenSSL RSA-PSS implementation';
  PROV_NAMES_SM2 = 'SM2:1.2.156.10197.1.301';
  PROV_DESCS_SM2 = 'OpenSSL SM2 implementation';

  OSSL_CIPHER_PARAM_PADDING = 'padding';
  OSSL_CIPHER_PARAM_USE_BITS = 'use-bits';
  OSSL_CIPHER_PARAM_TLS_VERSION = 'tls-version';
  OSSL_CIPHER_PARAM_TLS_MAC = 'tls-mac';
  OSSL_CIPHER_PARAM_TLS_MAC_SIZE = 'tls-mac-size';
  OSSL_CIPHER_PARAM_MODE = 'mode';
  OSSL_CIPHER_PARAM_BLOCK_SIZE = 'blocksize';
  OSSL_CIPHER_PARAM_AEAD = 'aead';
  OSSL_CIPHER_PARAM_CUSTOM_IV = 'custom-iv';
  OSSL_CIPHER_PARAM_CTS = 'cts';
  OSSL_CIPHER_PARAM_TLS1_MULTIBLOCK = 'tls-multi';
  OSSL_CIPHER_PARAM_HAS_RAND_KEY = 'has-randkey';
  OSSL_CIPHER_PARAM_KEYLEN = 'keylen';
  OSSL_CIPHER_PARAM_IVLEN = 'ivlen';
  OSSL_CIPHER_PARAM_IV = 'iv';
  OSSL_CIPHER_PARAM_UPDATED_IV = 'updated-iv';
  OSSL_CIPHER_PARAM_NUM = 'num';
  OSSL_CIPHER_PARAM_ROUNDS = 'rounds';
  OSSL_CIPHER_PARAM_AEAD_TAG = 'tag';
  OSSL_CIPHER_PARAM_AEAD_TLS1_AAD = 'tlsaad';
  OSSL_CIPHER_PARAM_AEAD_TLS1_AAD_PAD = 'tlsaadpad';
  OSSL_CIPHER_PARAM_AEAD_TLS1_IV_FIXED = 'tlsivfixed';
  OSSL_CIPHER_PARAM_AEAD_TLS1_GET_IV_GEN = 'tlsivgen';
  OSSL_CIPHER_PARAM_AEAD_TLS1_SET_IV_INV = 'tlsivinv';
  OSSL_CIPHER_PARAM_AEAD_IVLEN = OSSL_CIPHER_PARAM_IVLEN;
  OSSL_CIPHER_PARAM_AEAD_TAGLEN = 'taglen';
  OSSL_CIPHER_PARAM_AEAD_MAC_KEY = 'mackey';
  OSSL_CIPHER_PARAM_RANDOM_KEY = 'randkey';
  OSSL_CIPHER_PARAM_RC2_KEYBITS = 'keybits';
  OSSL_CIPHER_PARAM_SPEED = 'speed';
  OSSL_CIPHER_PARAM_CTS_MODE = 'cts_mode';
  OSSL_CIPHER_PARAM_ALGORITHM_ID_PARAMS = 'alg_id_param';
  OSSL_CIPHER_PARAM_TLS1_MULTIBLOCK_MAX_SEND_FRAGMENT = 'tls1multi_maxsndfrag';
  OSSL_CIPHER_PARAM_TLS1_MULTIBLOCK_MAX_BUFSIZE = 'tls1multi_maxbufsz';
  OSSL_CIPHER_PARAM_TLS1_MULTIBLOCK_INTERLEAVE = 'tls1multi_interleave';
  OSSL_CIPHER_PARAM_TLS1_MULTIBLOCK_AAD = 'tls1multi_aad';
  OSSL_CIPHER_PARAM_TLS1_MULTIBLOCK_AAD_PACKLEN = 'tls1multi_aadpacklen';
  OSSL_CIPHER_PARAM_TLS1_MULTIBLOCK_ENC = 'tls1multi_enc';
  OSSL_CIPHER_PARAM_TLS1_MULTIBLOCK_ENC_IN = 'tls1multi_encin';
  OSSL_CIPHER_PARAM_TLS1_MULTIBLOCK_ENC_LEN = 'tls1multi_enclen';
  OSSL_CIPHER_CTS_MODE_CS1 = 'CS1';
  OSSL_CIPHER_CTS_MODE_CS2 = 'CS2';
  OSSL_CIPHER_CTS_MODE_CS3 = 'CS3';
  OSSL_DIGEST_PARAM_XOFLEN = 'xoflen';
  OSSL_DIGEST_PARAM_SSL3_MS = 'ssl3-ms';
  OSSL_DIGEST_PARAM_PAD_TYPE = 'pad-type';
  OSSL_DIGEST_PARAM_MICALG = 'micalg';
  OSSL_DIGEST_PARAM_BLOCK_SIZE = 'blocksize';
  OSSL_DIGEST_PARAM_SIZE = 'size';
  OSSL_DIGEST_PARAM_XOF = 'xof';
  OSSL_DIGEST_PARAM_ALGID_ABSENT = 'algid-absent';

  PROV_CIPHER_FLAG_AEAD = $0001;
  PROV_CIPHER_FLAG_CUSTOM_IV = $0002;
  PROV_CIPHER_FLAG_CTS = $0004;
  PROV_CIPHER_FLAG_TLS1_MULTIBLOCK = $0008;
  PROV_CIPHER_FLAG_RAND_KEY = $0010;
  PROV_CIPHER_FLAG_VARIABLE_LENGTH = $0100;
  PROV_CIPHER_FLAG_INVERSE_CIPHER = $0200;
  CTS_FLAGS = PROV_CIPHER_FLAG_CTS;

  EVP_CIPH_STREAM_CIPHER = $0;
  EVP_CIPH_ECB_MODE = $1;
  EVP_CIPH_CBC_MODE = $2;
  EVP_CIPH_CFB_MODE = $3;
  EVP_CIPH_OFB_MODE = $4;
  EVP_CIPH_CTR_MODE = $5;
  EVP_CIPH_GCM_MODE = $6;
  EVP_CIPH_CCM_MODE = $7;
  EVP_CIPH_XTS_MODE = $10001;
  EVP_CIPH_WRAP_MODE = $10002;
  EVP_CIPH_OCB_MODE = $10003;
  EVP_CIPH_SIV_MODE = $10004;
  EVP_CIPH_MODE = $F0007;
  EVP_CIPH_VARIABLE_LENGTH = $8;
  EVP_CIPH_CUSTOM_IV = $10;
  EVP_CIPH_ALWAYS_CALL_INIT = $20;
  EVP_CIPH_CTRL_INIT = $40;
  EVP_CIPH_CUSTOM_KEY_LENGTH = $80;
  EVP_CIPH_NO_PADDING = $100;
  EVP_CIPH_RAND_KEY = $200;
  EVP_CIPH_CUSTOM_COPY = $400;
  EVP_CIPH_CUSTOM_IV_LENGTH = $800;
  EVP_CIPH_FLAG_DEFAULT_ASN1 = 0;
  EVP_CIPH_FLAG_LENGTH_BITS = $2000;
  EVP_CIPH_FLAG_FIPS = 0;
  EVP_CIPH_FLAG_NON_FIPS_ALLOW = 0;
  EVP_CIPH_FLAG_CTS = $4000;
  EVP_CIPH_FLAG_CUSTOM_CIPHER = $100000;
  EVP_CIPH_FLAG_AEAD_CIPHER = $200000;
  EVP_CIPH_FLAG_TLS1_1_MULTIBLOCK = $400000;
  EVP_CIPH_FLAG_PIPELINE = $800000;
  EVP_CIPH_FLAG_CUSTOM_ASN1 = $1000000;
  EVP_CIPH_FLAG_CIPHER_WITH_MAC = $2000000;
  EVP_CIPH_FLAG_GET_WRAP_CIPHER = $4000000;
  EVP_CIPH_FLAG_INVERSE_CIPHER = $8000000;

  ASN1_OBJECT_FLAG_DYNAMIC = $01;
  ASN1_OBJECT_FLAG_CRITICAL = $02;
  ASN1_OBJECT_FLAG_DYNAMIC_STRINGS = $04;
  ASN1_OBJECT_FLAG_DYNAMIC_DATA    = $08;
  BLAKE2S_BLOCKBYTES = 64;
  BLAKE2S_OUTBYTES = 32;
  BLAKE2S_KEYBYTES = 32;
  BLAKE2S_SALTBYTES = 8;
  BLAKE2S_PERSONALBYTES = 8;
  BLAKE2B_BLOCKBYTES = 128;
  BLAKE2B_OUTBYTES = 64;
  BLAKE2B_KEYBYTES = 64;
  BLAKE2B_SALTBYTES = 16;
  BLAKE2B_PERSONALBYTES = 16;
  BLAKE2B_DIGEST_LENGTH = 64;
  BLAKE2S_DIGEST_LENGTH = 32;
  KMAC_MAX_BLOCKSIZE = ((1600 - 128 * 2) div 8) ;
  KMAC_MAX_KEY = 256;
  KMAC_MIN_KEY = 4;
  KMAC_MAX_KEY_ENCODED = (KMAC_MAX_BLOCKSIZE * 2);
  KMAC_MAX_CUSTOM = 256;
  KMAC_MAX_ENCODED_HEADER_LEN = (1 + 3);
  KMAC_MAX_CUSTOM_ENCODED = (KMAC_MAX_CUSTOM + KMAC_MAX_ENCODED_HEADER_LEN);

  SIPHASH_BLOCK_SIZE = 8;
  SIPHASH_KEY_SIZE = 16;
  SIPHASH_MIN_DIGEST_SIZE = 8;
  SIPHASH_MAX_DIGEST_SIZE = 16;
  SIPHASH_C_ROUNDS = 2;
  SIPHASH_D_ROUNDS = 4;

  POLY1305_BLOCK_SIZE = 16;
  POLY1305_DIGEST_SIZE = 16;
  POLY1305_KEY_SIZE = 32;
  X_SER_BYTES = 56;
  X_PUBLIC_BYTES = X_SER_BYTES;
  X_PRIVATE_BYTES = X_PUBLIC_BYTES;
  X_PRIVATE_BITS = 448;
  X448_ENCODE_RATIO = 2;

  EC_R_ASN1_ERROR = 115;
  EC_R_BAD_SIGNATURE = 156;
  EC_R_BIGNUM_OUT_OF_RANGE = 144;
  EC_R_BUFFER_TOO_SMALL = 100;
  EC_R_CANNOT_INVERT = 165;
  EC_R_COORDINATES_OUT_OF_RANGE = 146;
  EC_R_CURVE_DOES_NOT_SUPPORT_ECDH = 160;
  EC_R_CURVE_DOES_NOT_SUPPORT_ECDSA = 170;
  EC_R_CURVE_DOES_NOT_SUPPORT_SIGNING = 159;
  EC_R_DECODE_ERROR = 142;
  EC_R_DISCRIMINANT_IS_ZERO = 118;
  EC_R_EC_GROUP_NEW_BY_NAME_FAILURE = 119;
  EC_R_FAILED_MAKING_PUBLIC_KEY = 166;
  EC_R_FIELD_TOO_LARGE = 143;
  EC_R_GF2M_NOT_SUPPORTED = 147;
  EC_R_GROUP2PKPARAMETERS_FAILURE = 120;
  EC_R_I2D_ECPKPARAMETERS_FAILURE = 121;
  EC_R_INCOMPATIBLE_OBJECTS = 101;
  EC_R_INVALID_A = 168;
  EC_R_INVALID_ARGUMENT = 112;
  EC_R_INVALID_B = 169;
  EC_R_INVALID_COFACTOR = 171;
  EC_R_INVALID_COMPRESSED_POINT = 110;
  EC_R_INVALID_COMPRESSION_BIT = 109;
  EC_R_INVALID_CURVE = 141;
  EC_R_INVALID_DIGEST = 151;
  EC_R_INVALID_DIGEST_TYPE = 138;
  EC_R_INVALID_ENCODING = 102;
  EC_R_INVALID_FIELD = 103;
  EC_R_INVALID_FORM = 104;
  EC_R_INVALID_GENERATOR = 173;
  EC_R_INVALID_GROUP_ORDER = 122;
  EC_R_INVALID_KEY = 116;
  EC_R_INVALID_LENGTH = 117;
  EC_R_INVALID_NAMED_GROUP_CONVERSION = 174;
  EC_R_INVALID_OUTPUT_LENGTH = 161;
  EC_R_INVALID_P = 172;
  EC_R_INVALID_PEER_KEY = 133;
  EC_R_INVALID_PENTANOMIAL_BASIS = 132;
  EC_R_INVALID_PRIVATE_KEY = 123;
  EC_R_INVALID_SEED = 175;
  EC_R_INVALID_TRINOMIAL_BASIS = 137;
  EC_R_KDF_PARAMETER_ERROR = 148;
  EC_R_KEYS_NOT_SET = 140;
  EC_R_LADDER_POST_FAILURE = 136;
  EC_R_LADDER_PRE_FAILURE = 153;
  EC_R_LADDER_STEP_FAILURE = 162;
  EC_R_MISSING_OID = 167;
  EC_R_MISSING_PARAMETERS = 124;
  EC_R_MISSING_PRIVATE_KEY = 125;
  EC_R_NEED_NEW_SETUP_VALUES = 157;
  EC_R_NOT_A_NIST_PRIME = 135;
  EC_R_NOT_IMPLEMENTED = 126;
  EC_R_NOT_INITIALIZED = 111;
  EC_R_NO_PARAMETERS_SET = 139;
  EC_R_NO_PRIVATE_VALUE = 154;
  EC_R_OPERATION_NOT_SUPPORTED = 152;
  EC_R_PASSED_NULL_PARAMETER = 134;
  EC_R_PEER_KEY_ERROR = 149;
  EC_R_POINT_ARITHMETIC_FAILURE = 155;
  EC_R_POINT_AT_INFINITY = 106;
  EC_R_POINT_COORDINATES_BLIND_FAILURE = 163;
  EC_R_POINT_IS_NOT_ON_CURVE = 107;
  EC_R_RANDOM_NUMBER_GENERATION_FAILED = 158;
  EC_R_SHARED_INFO_ERROR = 150;
  EC_R_SLOT_FULL = 108;
  EC_R_UNDEFINED_GENERATOR = 113;
  EC_R_UNDEFINED_ORDER = 128;
  EC_R_UNKNOWN_COFACTOR = 164;
  EC_R_UNKNOWN_GROUP = 129;
  EC_R_UNKNOWN_ORDER = 114;
  EC_R_UNSUPPORTED_FIELD = 131;
  EC_R_WRONG_CURVE_PARAMETERS = 145;
  EC_R_WRONG_ORDER = 130;

  ASN1_AFLG_REFCOUNT = 1;
  ASN1_AFLG_ENCODING = 2;
  ASN1_AFLG_BROKEN = 4;
  ASN1_AFLG_CONST_CB = 8;

  AEAD_FLAGS = (PROV_CIPHER_FLAG_AEAD or PROV_CIPHER_FLAG_CUSTOM_IV);
  AES_OCB_FLAGS = AEAD_FLAGS;
  MAXCHUNK    = (size_t(1) shl (sizeof(long) * 8 - 2));
  MAXBITCHUNK:size_t = (size_t(1) shl (sizeof(size_t) * 8 - 4));
  EVP_CTRL_RET_UNSUPPORTED = -1;
  SM3_DIGEST_LENGTH = 32;
  WPACKET_FLAGS_NONE = 0;
  UINT16_MAX = $ffff;
  OSSL_FUNC_ASYM_CIPHER_NEWCTX = 1;
  OSSL_FUNC_ASYM_CIPHER_ENCRYPT_INIT = 2;
  OSSL_FUNC_ASYM_CIPHER_ENCRYPT = 3;
  OSSL_FUNC_ASYM_CIPHER_DECRYPT_INIT = 4;
  OSSL_FUNC_ASYM_CIPHER_DECRYPT = 5;
  OSSL_FUNC_ASYM_CIPHER_FREECTX = 6;
  OSSL_FUNC_ASYM_CIPHER_DUPCTX = 7;
  OSSL_FUNC_ASYM_CIPHER_GET_CTX_PARAMS = 8;
  OSSL_FUNC_ASYM_CIPHER_GETTABLE_CTX_PARAMS = 9;
  OSSL_FUNC_ASYM_CIPHER_SET_CTX_PARAMS = 10;
  OSSL_FUNC_ASYM_CIPHER_SETTABLE_CTX_PARAMS = 11;

  OSSL_FUNC_KEM_NEWCTX = 1;
  OSSL_FUNC_KEM_ENCAPSULATE_INIT = 2;
  OSSL_FUNC_KEM_ENCAPSULATE = 3;
  OSSL_FUNC_KEM_DECAPSULATE_INIT = 4;
  OSSL_FUNC_KEM_DECAPSULATE = 5;
  OSSL_FUNC_KEM_FREECTX = 6;
  OSSL_FUNC_KEM_DUPCTX = 7;
  OSSL_FUNC_KEM_GET_CTX_PARAMS = 8;
  OSSL_FUNC_KEM_GETTABLE_CTX_PARAMS = 9;
  OSSL_FUNC_KEM_SET_CTX_PARAMS = 10;
  OSSL_FUNC_KEM_SETTABLE_CTX_PARAMS = 11;

  RSA_PKCS1_PADDING = 1;
  RSA_NO_PADDING = 3;
  RSA_PKCS1_OAEP_PADDING = 4;
  RSA_X931_PADDING = 5;
  RSA_PKCS1_PSS_PADDING = 6;
  RSA_PKCS1_WITH_TLS_PADDING = 7;
  RSA_PKCS1_PADDING_SIZE = 11;

  WPACKET_FLAGS_NON_ZERO_LENGTH = 1;
  WPACKET_FLAGS_ABANDON_ON_ZERO_LENGTH = 2;
  NID_sha1  = 64;

  COMBS_N = 5;
  COMBS_T = 5;
  COMBS_S = 18;

  NLIMBS = (64 div sizeof(word_t));
  //X_SER_BYTES = 56;
  SER_BYTES   = 56;
  UINT8_MAX  = $ff;
  C448_EDDSA_ENCODE_RATIO = 4;

  OSSL_FUNC_SIGNATURE_NEWCTX = 1;
  OSSL_FUNC_SIGNATURE_SIGN_INIT = 2;
  OSSL_FUNC_SIGNATURE_SIGN = 3;
  OSSL_FUNC_SIGNATURE_VERIFY_INIT = 4;
  OSSL_FUNC_SIGNATURE_VERIFY = 5;
  OSSL_FUNC_SIGNATURE_VERIFY_RECOVER_INIT = 6;
  OSSL_FUNC_SIGNATURE_VERIFY_RECOVER = 7;
  OSSL_FUNC_SIGNATURE_DIGEST_SIGN_INIT = 8;
  OSSL_FUNC_SIGNATURE_DIGEST_SIGN_UPDATE = 9;
  OSSL_FUNC_SIGNATURE_DIGEST_SIGN_FINAL = 10;
  OSSL_FUNC_SIGNATURE_DIGEST_SIGN = 11;
  OSSL_FUNC_SIGNATURE_DIGEST_VERIFY_INIT = 12;
  OSSL_FUNC_SIGNATURE_DIGEST_VERIFY_UPDATE = 13;
  OSSL_FUNC_SIGNATURE_DIGEST_VERIFY_FINAL = 14;
  OSSL_FUNC_SIGNATURE_DIGEST_VERIFY = 15;
  OSSL_FUNC_SIGNATURE_FREECTX = 16;
  OSSL_FUNC_SIGNATURE_DUPCTX = 17;
  OSSL_FUNC_SIGNATURE_GET_CTX_PARAMS = 18;
  OSSL_FUNC_SIGNATURE_GETTABLE_CTX_PARAMS = 19;
  OSSL_FUNC_SIGNATURE_SET_CTX_PARAMS = 20;
  OSSL_FUNC_SIGNATURE_SETTABLE_CTX_PARAMS = 21;
  OSSL_FUNC_SIGNATURE_GET_CTX_MD_PARAMS = 22;
  OSSL_FUNC_SIGNATURE_GETTABLE_CTX_MD_PARAMS = 23;
  OSSL_FUNC_SIGNATURE_SET_CTX_MD_PARAMS = 24;
  OSSL_FUNC_SIGNATURE_SETTABLE_CTX_MD_PARAMS = 25;
  OSSL_MAX_PROPQUERY_SIZE  =   256;
   SM2_R_ASN1_ERROR                                 = 100;
   SM2_R_BAD_SIGNATURE                              = 101;
   SM2_R_BUFFER_TOO_SMALL                           = 107;
   SM2_R_DIST_ID_TOO_LARGE                          = 110;
   SM2_R_ID_NOT_SET                                 = 112;
   SM2_R_ID_TOO_LARGE                               = 111;
   SM2_R_INVALID_CURVE                              = 108;
   SM2_R_INVALID_DIGEST                             = 102;
   SM2_R_INVALID_DIGEST_TYPE                        = 103;
   SM2_R_INVALID_ENCODING                           = 104;
   SM2_R_INVALID_FIELD                              = 105;
   SM2_R_INVALID_PRIVATE_KEY                        = 113;
   SM2_R_NO_PARAMETERS_SET                          = 109;
   SM2_R_USER_ID_TOO_LARGE                          = 106;

  X25519_KEYLEN = 32;
  X448_KEYLEN = 56;
  ED25519_KEYLEN = 32;
  ED448_KEYLEN = 57;
  MAX_KEYLEN = ED448_KEYLEN;
  X25519_BITS = 253;
  X25519_SECURITY_BITS = 128;
  X448_BITS = 448;
  X448_SECURITY_BITS = 224;
  ED25519_BITS = 256;
  ED25519_SECURITY_BITS = 128;
  ED25519_SIGSIZE = 64;
  ED448_BITS = 456;
  ED448_SECURITY_BITS = 224;
  ED448_SIGSIZE = 114;

  DSA_PARAMGEN_TYPE_FIPS_186_4 = 0;
  DSA_PARAMGEN_TYPE_FIPS_186_2 = 1;
  DSA_PARAMGEN_TYPE_FIPS_DEFAULT = 2;

  RSA_FLAG_TYPE_MASK = $F000;
  RSA_FLAG_TYPE_RSA = $0000;
  RSA_FLAG_TYPE_RSASSAPSS = $1000;
  RSA_FLAG_TYPE_RSAESOAEP = $2000;

  RSA_R_INVALID_DIGEST = 157;
  RSA_R_INVALID_DIGEST_LENGTH = 143;
  RSA_R_INVALID_HEADER = 137;
  RSA_R_INVALID_KEYPAIR = 171;
  RSA_R_INVALID_KEY_LENGTH = 173;
  RSA_R_INVALID_LABEL = 160;
  RSA_R_INVALID_LENGTH = 181;
  RSA_R_INVALID_MESSAGE_LENGTH = 131;
  RSA_R_INVALID_MGF1_MD = 156;
  RSA_R_INVALID_MODULUS = 174;
  RSA_R_INVALID_MULTI_PRIME_KEY = 167;
  RSA_R_INVALID_OAEP_PARAMETERS = 161;
  RSA_R_INVALID_PADDING = 138;
  RSA_R_INVALID_PADDING_MODE = 141;
  RSA_R_INVALID_PSS_PARAMETERS = 149;
  RSA_R_INVALID_PSS_SALTLEN = 146;
  RSA_R_INVALID_REQUEST = 175;
  RSA_R_INVALID_SALT_LENGTH = 150;
  RSA_R_INVALID_STRENGTH = 176;
  RSA_R_INVALID_TRAILER = 139;
  RSA_R_INVALID_X931_DIGEST = 142;
  RSA_R_PUB_EXPONENT_OUT_OF_RANGE = 178;
  RSA_R_PAIRWISE_TEST_FAILURE = 177;

  EC_FLAGS_DEFAULT_OCT = $1;
  EC_FLAGS_CUSTOM_CURVE = $2;
  EC_FLAGS_NO_SIGN      = $4;

  

  EC_PKEY_NO_PARAMETERS = $001;
  EC_PKEY_NO_PUBKEY = $002;
  EC_FLAG_SM2_RANGE = $0004;
  EC_FLAG_COFACTOR_ECDH = $1000;
  EC_FLAG_CHECK_NAMED_GROUP = $2000;
  EC_FLAG_CHECK_NAMED_GROUP_NIST = $4000;
  EC_FLAG_CHECK_NAMED_GROUP_MASK = (EC_FLAG_CHECK_NAMED_GROUP or EC_FLAG_CHECK_NAMED_GROUP_NIST);
  EC_FLAG_NON_FIPS_ALLOW = $0000;
  EC_FLAG_FIPS_CHECKED = $0000;

  FFC_PARAM_TYPE_DSA = 0;
  FFC_PARAM_TYPE_DH = 1;
  RSA_MIN_MODULUS_BITS =   512;

  OSSL_KEYMGMT_SELECT_PRIVATE_KEY = $01;
  OSSL_KEYMGMT_SELECT_PUBLIC_KEY = $02;
  OSSL_KEYMGMT_SELECT_DOMAIN_PARAMETERS = $04;
  OSSL_KEYMGMT_SELECT_OTHER_PARAMETERS = $80;
  OSSL_KEYMGMT_SELECT_ALL_PARAMETERS = (OSSL_KEYMGMT_SELECT_DOMAIN_PARAMETERS or OSSL_KEYMGMT_SELECT_OTHER_PARAMETERS);
  OSSL_KEYMGMT_SELECT_KEYPAIR = (OSSL_KEYMGMT_SELECT_PRIVATE_KEY or OSSL_KEYMGMT_SELECT_PUBLIC_KEY);
  OSSL_KEYMGMT_SELECT_ALL = (OSSL_KEYMGMT_SELECT_KEYPAIR or OSSL_KEYMGMT_SELECT_ALL_PARAMETERS);

  DSA_POSSIBLE_SELECTIONS = (OSSL_KEYMGMT_SELECT_KEYPAIR or OSSL_KEYMGMT_SELECT_DOMAIN_PARAMETERS);
  RSA_POSSIBLE_SELECTIONS = (OSSL_KEYMGMT_SELECT_KEYPAIR or OSSL_KEYMGMT_SELECT_OTHER_PARAMETERS);
  EC_POSSIBLE_SELECTIONS = (OSSL_KEYMGMT_SELECT_KEYPAIR or OSSL_KEYMGMT_SELECT_ALL_PARAMETERS);

  EVP_PKEY_KEY_PARAMETERS = (OSSL_KEYMGMT_SELECT_ALL_PARAMETERS);
  EVP_PKEY_PUBLIC_KEY = (EVP_PKEY_KEY_PARAMETERS or OSSL_KEYMGMT_SELECT_PUBLIC_KEY);
  EVP_PKEY_KEYPAIR = (EVP_PKEY_PUBLIC_KEY or OSSL_KEYMGMT_SELECT_PRIVATE_KEY);

  DSA_R_BAD_FFC_PARAMETERS = 114;
  DSA_R_BAD_Q_VALUE = 102;
  DSA_R_BN_DECODE_ERROR = 108;
  DSA_R_BN_ERROR = 109;
  DSA_R_DECODE_ERROR = 104;
  DSA_R_INVALID_DIGEST_TYPE = 106;
  DSA_R_INVALID_PARAMETERS = 112;
  DSA_R_MISSING_PARAMETERS = 101;
  DSA_R_MISSING_PRIVATE_KEY = 111;
  DSA_R_MODULUS_TOO_LARGE = 103;
  DSA_R_NO_PARAMETERS_SET = 107;
  DSA_R_PARAMETER_ENCODING_ERROR = 105;
  DSA_R_P_NOT_PRIME = 115;
  DSA_R_Q_NOT_PRIME = 113;
  DSA_R_SEED_LEN_SMALL = 110;

  DH_FLAG_CACHE_MONT_P = $01;
  DH_FLAG_TYPE_MASK = $F000;
  DH_FLAG_TYPE_DH = $0000;
  DH_FLAG_TYPE_DHX = $1000;
  DH_FLAG_NO_EXP_CONSTTIME = $00;
  DH_FLAG_FIPS_METHOD = $0400;
  DH_FLAG_NON_FIPS_ALLOW = $0400;

  TYPE_ANY = -1;
  TYPE_DH = DH_FLAG_TYPE_DH;
  TYPE_DHX = DH_FLAG_TYPE_DHX;

  BN_PRIMETEST_COMPOSITE = 0;
  BN_PRIMETEST_COMPOSITE_WITH_FACTOR = 1;
  BN_PRIMETEST_COMPOSITE_NOT_POWER_OF_PRIME = 2;
  BN_PRIMETEST_PROBABLY_PRIME = 3;
  FFC_ERROR_NOT_SUITABLE_GENERATOR = $08;

  FFC_CHECK_P_NOT_PRIME = $00001;
  FFC_CHECK_P_NOT_SAFE_PRIME = $00002;
  FFC_CHECK_UNKNOWN_GENERATOR = $00004;
  FFC_CHECK_NOT_SUITABLE_GENERATOR = $00008;
  FFC_CHECK_Q_NOT_PRIME = $00010;
  FFC_CHECK_INVALID_Q_VALUE = $00020;
  FFC_CHECK_INVALID_J_VALUE = $00040;
  FFC_CHECK_BAD_LN_PAIR = $00080;
  FFC_CHECK_INVALID_SEED_SIZE = $00100;
  FFC_CHECK_MISSING_SEED_OR_COUNTER = $00200;
  FFC_CHECK_INVALID_G = $00400;
  FFC_CHECK_INVALID_PQ = $00800;
  FFC_CHECK_INVALID_COUNTER = $01000;
  FFC_CHECK_P_MISMATCH = $02000;
  FFC_CHECK_Q_MISMATCH = $04000;
  FFC_CHECK_G_MISMATCH = $08000;
  FFC_CHECK_COUNTER_MISMATCH = $10000;

  OSSL_LIB_CTX_METHOD_LOW_PRIORITY = -1;
  OSSL_LIB_CTX_METHOD_DEFAULT_PRIORITY = 0;
  OSSL_LIB_CTX_METHOD_PRIORITY_1 = 1;
  OSSL_LIB_CTX_METHOD_PRIORITY_2 = 2;

  OSSL_SELF_TEST_PHASE_NONE = 'None';
  OSSL_SELF_TEST_PHASE_START = 'Start';
  OSSL_SELF_TEST_PHASE_CORRUPT = 'Corrupt';
  OSSL_SELF_TEST_PHASE_PASS = 'Pass';
  OSSL_SELF_TEST_PHASE_FAIL = 'Fail';
  OSSL_SELF_TEST_TYPE_NONE = 'None';
  OSSL_SELF_TEST_TYPE_MODULE_INTEGRITY = 'Module_Integrity';
  OSSL_SELF_TEST_TYPE_INSTALL_INTEGRITY = 'Install_Integrity';
  OSSL_SELF_TEST_TYPE_CRNG = 'Continuous_RNG_Test';
  OSSL_SELF_TEST_TYPE_PCT = 'Conditional_PCT';
  OSSL_SELF_TEST_TYPE_KAT_CIPHER = 'KAT_Cipher';
  OSSL_SELF_TEST_TYPE_KAT_ASYM_CIPHER = 'KAT_AsymmetricCipher';
  OSSL_SELF_TEST_TYPE_KAT_DIGEST = 'KAT_Digest';
  OSSL_SELF_TEST_TYPE_KAT_SIGNATURE = 'KAT_Signature';
  OSSL_SELF_TEST_TYPE_PCT_SIGNATURE = 'PCT_Signature';
  OSSL_SELF_TEST_TYPE_KAT_KDF = 'KAT_KDF';
  OSSL_SELF_TEST_TYPE_KAT_KA = 'KAT_KA';
  OSSL_SELF_TEST_TYPE_DRBG = 'DRBG';
  OSSL_SELF_TEST_DESC_NONE = 'None';
  OSSL_SELF_TEST_DESC_INTEGRITY_HMAC = 'HMAC';
  OSSL_SELF_TEST_DESC_PCT_RSA_PKCS1 = 'RSA';
  OSSL_SELF_TEST_DESC_PCT_ECDSA = 'ECDSA';
  OSSL_SELF_TEST_DESC_PCT_DSA = 'DSA';
  OSSL_SELF_TEST_DESC_CIPHER_AES_GCM = 'AES_GCM';
  OSSL_SELF_TEST_DESC_CIPHER_AES_ECB = 'AES_ECB_Decrypt';
  OSSL_SELF_TEST_DESC_CIPHER_TDES = 'TDES';
  OSSL_SELF_TEST_DESC_ASYM_RSA_ENC = 'RSA_Encrypt';
  OSSL_SELF_TEST_DESC_ASYM_RSA_DEC = 'RSA_Decrypt';
  OSSL_SELF_TEST_DESC_MD_SHA1 = 'SHA1';
  OSSL_SELF_TEST_DESC_MD_SHA2 = 'SHA2';
  OSSL_SELF_TEST_DESC_MD_SHA3 = 'SHA3';
  OSSL_SELF_TEST_DESC_SIGN_DSA = 'DSA';
  OSSL_SELF_TEST_DESC_SIGN_RSA = 'RSA';
  OSSL_SELF_TEST_DESC_SIGN_ECDSA = 'ECDSA';
  OSSL_SELF_TEST_DESC_DRBG_CTR = 'CTR';
  OSSL_SELF_TEST_DESC_DRBG_HASH = 'HASH';
  OSSL_SELF_TEST_DESC_DRBG_HMAC = 'HMAC';
  OSSL_SELF_TEST_DESC_KA_DH = 'DH';
  OSSL_SELF_TEST_DESC_KA_ECDH = 'ECDH';
  OSSL_SELF_TEST_DESC_KDF_HKDF = 'HKDF';
  OSSL_SELF_TEST_DESC_KDF_SSKDF = 'SSKDF';
  OSSL_SELF_TEST_DESC_KDF_X963KDF = 'X963KDF';
  OSSL_SELF_TEST_DESC_KDF_X942KDF = 'X942KDF';
  OSSL_SELF_TEST_DESC_KDF_PBKDF2 = 'PBKDF2';
  OSSL_SELF_TEST_DESC_KDF_SSHKDF = 'SSHKDF';
  OSSL_SELF_TEST_DESC_KDF_TLS12_PRF = 'TLS12_PRF';
  OSSL_SELF_TEST_DESC_KDF_KBKDF = 'KBKDF';
  OSSL_SELF_TEST_DESC_KDF_TLS13_EXTRACT = 'TLS13_KDF_EXTRACT';
  OSSL_SELF_TEST_DESC_KDF_TLS13_EXPAND = 'TLS13_KDF_EXPAND';
  OSSL_SELF_TEST_DESC_RNG = 'RNG';

  
  OSSL_KEYMGMT_VALIDATE_FULL_CHECK = 0;
  OSSL_KEYMGMT_VALIDATE_QUICK_CHECK = 1;

  FFC_ERROR_PUBKEY_TOO_SMALL = $01;
  FFC_ERROR_PUBKEY_TOO_LARGE = $02;
  FFC_ERROR_PUBKEY_INVALID = $04;
  FFC_ERROR_PRIVKEY_TOO_SMALL = $10;
  FFC_ERROR_PRIVKEY_TOO_LARGE = $20;

  UINT_MAX = $ffffffff;
  RESEED_INTERVAL = (1 shl 8);
  TIME_INTERVAL = (60*60);   // 1 hour

  FFC_PARAM_RET_STATUS_FAILED = 0;
  FFC_PARAM_RET_STATUS_SUCCESS = 1;
  FFC_PARAM_RET_STATUS_UNVERIFIABLE_G = 2;
  FFC_PARAM_MODE_VERIFY = 0;
  FFC_PARAM_MODE_GENERATE = 1;


  RAND_R_UNABLE_TO_CREATE_DRBG = 143;
  RAND_R_UNABLE_TO_FETCH_DRBG = 144;
  RAND_R_UNABLE_TO_GET_PARENT_RESEED_PROP_COUNTER = 141;
  RAND_R_UNABLE_TO_GET_PARENT_STRENGTH = 138;
  RAND_R_UNABLE_TO_LOCK_PARENT = 140;
  RAND_R_UNSUPPORTED_DRBG_FLAGS = 132;
  RAND_R_UNSUPPORTED_DRBG_TYPE = 120;

  PRIMARY_RESEED_INTERVAL = (1 shl 8);
  SECONDARY_RESEED_INTERVAL = (1 shl 16);
  PRIMARY_RESEED_TIME_INTERVAL = (60*60);
  SECONDARY_RESEED_TIME_INTERVAL = (7*60);

  EVP_RAND_STATE_UNINITIALISED = 0;
  EVP_RAND_STATE_READY = 1;
  EVP_RAND_STATE_ERROR = 2;

  DH_PARAMGEN_TYPE_GENERATOR = 0;
  DH_PARAMGEN_TYPE_FIPS_186_2 = 1;
  DH_PARAMGEN_TYPE_FIPS_186_4 = 2;
  DH_PARAMGEN_TYPE_GROUP = 3;

  DH_POSSIBLE_SELECTIONS = (OSSL_KEYMGMT_SELECT_KEYPAIR or OSSL_KEYMGMT_SELECT_DOMAIN_PARAMETERS);
  OSSL_PARAM_ALLOCATED_END  =  127;
  OSSL_PARAM_MERGE_LIST_MAX =  128;

  FFC_PARAM_FLAG_VALIDATE_PQ = $01;
  FFC_PARAM_FLAG_VALIDATE_G = $02;
  FFC_PARAM_FLAG_VALIDATE_PQG = (FFC_PARAM_FLAG_VALIDATE_PQ or FFC_PARAM_FLAG_VALIDATE_G);
  FFC_PARAM_FLAG_VALIDATE_LEGACY = $04;
  
  OSSL_FUNC_KEYMGMT_NEW = 1;
  OSSL_FUNC_KEYMGMT_GEN_INIT = 2;
  OSSL_FUNC_KEYMGMT_GEN_SET_TEMPLATE = 3;
  OSSL_FUNC_KEYMGMT_GEN_SET_PARAMS = 4;
  OSSL_FUNC_KEYMGMT_GEN_SETTABLE_PARAMS = 5;
  OSSL_FUNC_KEYMGMT_GEN = 6;
  OSSL_FUNC_KEYMGMT_GEN_CLEANUP = 7;
  OSSL_FUNC_KEYMGMT_LOAD = 8;
  OSSL_FUNC_KEYMGMT_FREE = 10;
  OSSL_FUNC_KEYMGMT_GET_PARAMS = 11;
  OSSL_FUNC_KEYMGMT_GETTABLE_PARAMS = 12;
  OSSL_FUNC_KEYMGMT_SET_PARAMS = 13;
  OSSL_FUNC_KEYMGMT_SETTABLE_PARAMS = 14;
  OSSL_FUNC_KEYMGMT_QUERY_OPERATION_NAME = 20;
  OSSL_FUNC_KEYMGMT_HAS = 21;
  OSSL_FUNC_KEYMGMT_VALIDATE = 22;
  OSSL_FUNC_KEYMGMT_MATCH = 23;
  OSSL_FUNC_KEYMGMT_IMPORT = 40;
  OSSL_FUNC_KEYMGMT_IMPORT_TYPES = 41;
  OSSL_FUNC_KEYMGMT_EXPORT = 42;
  OSSL_FUNC_KEYMGMT_EXPORT_TYPES = 43;
  OSSL_FUNC_KEYMGMT_DUP = 44;
  OSSL_FUNC_KEYEXCH_NEWCTX = 1;
  OSSL_FUNC_KEYEXCH_INIT = 2;
  OSSL_FUNC_KEYEXCH_DERIVE = 3;
  OSSL_FUNC_KEYEXCH_SET_PEER = 4;
  OSSL_FUNC_KEYEXCH_FREECTX = 5;
  OSSL_FUNC_KEYEXCH_DUPCTX = 6;
  OSSL_FUNC_KEYEXCH_SET_CTX_PARAMS = 7;
  OSSL_FUNC_KEYEXCH_SETTABLE_CTX_PARAMS = 8;
  OSSL_FUNC_KEYEXCH_GET_CTX_PARAMS = 9;
  OSSL_FUNC_KEYEXCH_GETTABLE_CTX_PARAMS = 10;

  OSSL_FUNC_RAND_NEWCTX = 1;
  OSSL_FUNC_RAND_FREECTX = 2;
  OSSL_FUNC_RAND_INSTANTIATE = 3;
  OSSL_FUNC_RAND_UNINSTANTIATE = 4;
  OSSL_FUNC_RAND_GENERATE = 5;
  OSSL_FUNC_RAND_RESEED = 6;
  OSSL_FUNC_RAND_NONCE = 7;
  OSSL_FUNC_RAND_ENABLE_LOCKING = 8;
  OSSL_FUNC_RAND_LOCK = 9;
  OSSL_FUNC_RAND_UNLOCK = 10;
  OSSL_FUNC_RAND_GETTABLE_PARAMS = 11;
  OSSL_FUNC_RAND_GETTABLE_CTX_PARAMS = 12;
  OSSL_FUNC_RAND_SETTABLE_CTX_PARAMS = 13;
  OSSL_FUNC_RAND_GET_PARAMS = 14;
  OSSL_FUNC_RAND_GET_CTX_PARAMS = 15;
  OSSL_FUNC_RAND_SET_CTX_PARAMS = 16;
  OSSL_FUNC_RAND_VERIFY_ZEROIZATION = 17;
  OSSL_FUNC_RAND_GET_SEED = 18;
  OSSL_FUNC_RAND_CLEAR_SEED = 19;

  DER_P_EOC = 0;
  DER_P_BOOLEAN = 1;
  DER_P_INTEGER = 2;
  DER_P_BIT_STRING = 3;
  DER_P_OCTET_STRING = 4;
  DER_P_NULL = 5;
  DER_P_OBJECT = 6;
  DER_P_OBJECT_DESCRIPTOR = 7;
  DER_P_EXTERNAL = 8;
  DER_P_REAL = 9;
  DER_P_ENUMERATED = 10;
  DER_P_UTF8STRING = 12;
  DER_P_SEQUENCE = 16;
  DER_P_SET = 17;
  DER_P_NUMERICSTRING = 18;
  DER_P_PRINTABLESTRING = 19;
  DER_P_T61STRING = 20;
  DER_P_VIDEOTEXSTRING = 21;
  DER_P_IA5STRING = 22;
  DER_P_UTCTIME = 23;
  DER_P_GENERALIZEDTIME = 24;
  DER_P_GRAPHICSTRING = 25;
  DER_P_ISO64STRING = 26;
  DER_P_GENERALSTRING = 27;
  DER_P_UNIVERSALSTRING = 28;
  DER_P_BMPSTRING = 30;
  DER_F_PRIMITIVE = $00;
  DER_F_CONSTRUCTED = $20;
  DER_C_UNIVERSAL = $00;
  DER_C_APPLICATION = $40;
  DER_C_CONTEXT = $80;
  DER_C_PRIVATE = $C0;
  DER_NO_CONTEXT = -1;


  OSSL_FUNC_CIPHER_NEWCTX = 1;
  OSSL_FUNC_CIPHER_ENCRYPT_INIT = 2;
  OSSL_FUNC_CIPHER_DECRYPT_INIT = 3;
  OSSL_FUNC_CIPHER_UPDATE = 4;
  OSSL_FUNC_CIPHER_FINAL = 5;
  OSSL_FUNC_CIPHER_CIPHER = 6;
  OSSL_FUNC_CIPHER_FREECTX = 7;
  OSSL_FUNC_CIPHER_DUPCTX = 8;
  OSSL_FUNC_CIPHER_GET_PARAMS = 9;
  OSSL_FUNC_CIPHER_GET_CTX_PARAMS = 10;
  OSSL_FUNC_CIPHER_SET_CTX_PARAMS = 11;
  OSSL_FUNC_CIPHER_GETTABLE_PARAMS = 12;
  OSSL_FUNC_CIPHER_GETTABLE_CTX_PARAMS = 13;
  OSSL_FUNC_CIPHER_SETTABLE_CTX_PARAMS = 14;

  OSSL_FUNC_DIGEST_NEWCTX = 1;
  OSSL_FUNC_DIGEST_INIT = 2;
  OSSL_FUNC_DIGEST_UPDATE = 3;
  OSSL_FUNC_DIGEST_FINAL = 4;
  OSSL_FUNC_DIGEST_DIGEST = 5;
  OSSL_FUNC_DIGEST_FREECTX = 6;
  OSSL_FUNC_DIGEST_DUPCTX = 7;
  OSSL_FUNC_DIGEST_GET_PARAMS = 8;
  OSSL_FUNC_DIGEST_SET_CTX_PARAMS = 9;
  OSSL_FUNC_DIGEST_GET_CTX_PARAMS = 10;
  OSSL_FUNC_DIGEST_GETTABLE_PARAMS = 11;
  OSSL_FUNC_DIGEST_SETTABLE_CTX_PARAMS = 12;
  OSSL_FUNC_DIGEST_GETTABLE_CTX_PARAMS = 13;

  EVP_R_INVALID_CUSTOM_LENGTH = 185;
  EVP_R_INVALID_DIGEST = 152;
  EVP_R_INVALID_IV_LENGTH = 194;
  EVP_R_INVALID_KEY = 163;
  EVP_R_INVALID_KEY_LENGTH = 130;
  EVP_R_INVALID_LENGTH = 221;
  EVP_R_INVALID_NULL_ALGORITHM = 218;
  EVP_R_INVALID_OPERATION = 148;
  EVP_R_INVALID_PROVIDER_FUNCTIONS = 193;
  EVP_R_INVALID_SALT_LENGTH = 186;
  EVP_R_INVALID_SECRET_LENGTH = 223;
  EVP_R_INVALID_SEED_LENGTH = 220;
  EVP_R_INVALID_VALUE = 222;
  EVP_R_OPERATION_NOT_INITIALIZED = 151;
  EVP_R_OPERATON_NOT_INITIALIZED = EVP_R_OPERATION_NOT_INITIALIZED;
  EVP_R_AES_KEY_SETUP_FAILED = 143;
  EVP_R_ARIA_KEY_SETUP_FAILED = 176;
  EVP_R_BAD_ALGORITHM_NAME = 200;
  EVP_R_BAD_DECRYPT = 100;
  EVP_R_BAD_KEY_LENGTH = 195;
  EVP_R_BUFFER_TOO_SMALL = 155;
  EVP_R_CACHE_CONSTANTS_FAILED = 225;
  EVP_R_CAMELLIA_KEY_SETUP_FAILED = 157;
  EVP_R_CANNOT_GET_PARAMETERS = 197;
  EVP_R_CANNOT_SET_PARAMETERS = 198;
  EVP_R_CIPHER_NOT_GCM_MODE = 184;
  EVP_R_CIPHER_PARAMETER_ERROR = 122;
  EVP_R_COMMAND_NOT_SUPPORTED = 147;
  EVP_R_CONFLICTING_ALGORITHM_NAME = 201;
  EVP_R_COPY_ERROR = 173;
  EVP_R_CTRL_NOT_IMPLEMENTED = 132;
  EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED = 133;
  EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH = 138;
  EVP_R_DECODE_ERROR = 114;
  EVP_R_DEFAULT_QUERY_PARSE_ERROR = 210;
  EVP_R_DIFFERENT_KEY_TYPES = 101;
  EVP_R_DIFFERENT_PARAMETERS = 153;
  EVP_R_ERROR_LOADING_SECTION = 165;
  EVP_R_EXPECTING_AN_HMAC_KEY = 174;
  EVP_R_EXPECTING_AN_RSA_KEY = 127;
  EVP_R_EXPECTING_A_DH_KEY = 128;
  EVP_R_EXPECTING_A_DSA_KEY = 129;
  EVP_R_EXPECTING_A_ECX_KEY = 219;
  EVP_R_EXPECTING_A_EC_KEY = 142;
  EVP_R_EXPECTING_A_POLY1305_KEY = 164;
  EVP_R_EXPECTING_A_SIPHASH_KEY = 175;
  EVP_R_FINAL_ERROR = 188;
  EVP_R_GENERATE_ERROR = 214;
  EVP_R_GET_RAW_KEY_FAILED = 182;
  EVP_R_ILLEGAL_SCRYPT_PARAMETERS = 171;
  EVP_R_INACCESSIBLE_DOMAIN_PARAMETERS = 204;
  EVP_R_INACCESSIBLE_KEY = 203;
  EVP_R_INITIALIZATION_ERROR = 134;
  EVP_R_INPUT_NOT_INITIALIZED = 111;
  
  EVP_R_KEYMGMT_EXPORT_FAILURE = 205;
  EVP_R_KEY_SETUP_FAILED = 180;
  EVP_R_LOCKING_NOT_SUPPORTED = 213;
  EVP_R_MEMORY_LIMIT_EXCEEDED = 172;
  EVP_R_MESSAGE_DIGEST_IS_NULL = 159;
  EVP_R_METHOD_NOT_SUPPORTED = 144;
  EVP_R_MISSING_PARAMETERS = 103;
  EVP_R_NOT_ABLE_TO_COPY_CTX = 190;
  EVP_R_NOT_XOF_OR_INVALID_LENGTH = 178;
  EVP_R_NO_CIPHER_SET = 131;
  EVP_R_NO_DEFAULT_DIGEST = 158;
  EVP_R_NO_DIGEST_SET = 139;
  EVP_R_NO_IMPORT_FUNCTION = 206;
  EVP_R_NO_KEYMGMT_AVAILABLE = 199;
  EVP_R_NO_KEYMGMT_PRESENT = 196;
  EVP_R_NO_KEY_SET = 154;
  EVP_R_NO_OPERATION_SET = 149;
  EVP_R_NULL_MAC_PKEY_CTX = 208;
  EVP_R_ONLY_ONESHOT_SUPPORTED = 177;
  EVP_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE = 150;
  EVP_R_OUTPUT_WOULD_OVERFLOW = 202;
  EVP_R_PARAMETER_TOO_LARGE = 187;
  EVP_R_PARTIALLY_OVERLAPPING = 162;
  EVP_R_PBKDF2_ERROR = 181;
  EVP_R_PKEY_APPLICATION_ASN1_METHOD_ALREADY_REGISTERED = 179;
  EVP_R_PRIVATE_KEY_DECODE_ERROR = 145;
  EVP_R_PRIVATE_KEY_ENCODE_ERROR = 146;
  EVP_R_PUBLIC_KEY_NOT_RSA = 106;
  EVP_R_SETTING_XOF_FAILED = 227;
  EVP_R_SET_DEFAULT_PROPERTY_FAILURE = 209;
  EVP_R_TOO_MANY_RECORDS = 183;
  EVP_R_UNABLE_TO_ENABLE_LOCKING = 212;
  EVP_R_UNABLE_TO_GET_MAXIMUM_REQUEST_SIZE = 215;
  EVP_R_UNABLE_TO_GET_RANDOM_STRENGTH = 216;
  EVP_R_UNABLE_TO_LOCK_CONTEXT = 211;
  EVP_R_UNABLE_TO_SET_CALLBACKS = 217;
  EVP_R_UNKNOWN_CIPHER = 160;
  EVP_R_UNKNOWN_DIGEST = 161;
  EVP_R_UNKNOWN_KEY_TYPE = 207;
  EVP_R_UNKNOWN_OPTION = 169;
  EVP_R_UNKNOWN_PBE_ALGORITHM = 121;
  EVP_R_UNSUPPORTED_ALGORITHM = 156;
  EVP_R_UNSUPPORTED_CIPHER = 107;
  EVP_R_UNSUPPORTED_KEYLENGTH = 123;
  EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION = 124;
  EVP_R_UNSUPPORTED_KEY_SIZE = 108;
  EVP_R_UNSUPPORTED_KEY_TYPE = 224;
  EVP_R_UNSUPPORTED_NUMBER_OF_ROUNDS = 135;
  EVP_R_UNSUPPORTED_PRF = 125;
  EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM = 118;
  EVP_R_UNSUPPORTED_SALT_TYPE = 126;
  EVP_R_UPDATE_ERROR = 189;
  EVP_R_WRAP_MODE_NOT_ALLOWED = 170;
  EVP_R_WRONG_FINAL_BLOCK_LENGTH = 109;
  EVP_R_XTS_DATA_UNIT_IS_TOO_LARGE = 191;
  EVP_R_XTS_DUPLICATED_KEYS = 192;

  NAME_SEPARATOR = ':';
  METHOD_ID_OPERATION_MASK = $000000FF;
  METHOD_ID_OPERATION_MAX = ((1 shl 8)-1);
  METHOD_ID_NAME_MASK = $7FFFFF00;
  METHOD_ID_NAME_OFFSET = 8;
  METHOD_ID_NAME_MAX = ((1 shl 23)-1);

  OSSL_FUNC_MAC_NEWCTX = 1;
  OSSL_FUNC_MAC_DUPCTX = 2;
  OSSL_FUNC_MAC_FREECTX = 3;
  OSSL_FUNC_MAC_INIT = 4;
  OSSL_FUNC_MAC_UPDATE = 5;
  OSSL_FUNC_MAC_FINAL = 6;
  OSSL_FUNC_MAC_GET_PARAMS = 7;
  OSSL_FUNC_MAC_GET_CTX_PARAMS = 8;
  OSSL_FUNC_MAC_SET_CTX_PARAMS = 9;
  OSSL_FUNC_MAC_GETTABLE_PARAMS = 10;
  OSSL_FUNC_MAC_GETTABLE_CTX_PARAMS = 11;
  OSSL_FUNC_MAC_SETTABLE_CTX_PARAMS = 12;

  //OSSL_PARAM_UNMODIFIED = size_t(-1);
  EVP_KDF_HKDF_MODE_EXTRACT_AND_EXPAND = 0;
  EVP_KDF_HKDF_MODE_EXTRACT_ONLY = 1;
  EVP_KDF_HKDF_MODE_EXPAND_ONLY = 2;

  PROV_R_MISMATCHING_DOMAIN_PARAMETERS = 203;
  PROV_R_MISSING_CEK_ALG = 144;
  PROV_R_MISSING_CIPHER = 155;
  PROV_R_MISSING_CONFIG_DATA = 213;
  PROV_R_MISSING_CONSTANT = 156;
  PROV_R_MISSING_KEY = 128;
  PROV_R_MISSING_MAC = 150;
  PROV_R_MISSING_MESSAGE_DIGEST = 129;
  PROV_R_MISSING_OID = 209;
  PROV_R_MISSING_PASS = 130;
  PROV_R_MISSING_SALT = 131;
  PROV_R_MISSING_SECRET = 132;
  PROV_R_MISSING_SEED = 140;
  PROV_R_MISSING_SESSION_ID = 133;
  PROV_R_MISSING_TYPE = 134;
  PROV_R_MISSING_XCGHASH = 135;

  PROV_R_ADDITIONAL_INPUT_TOO_LONG = 184;
  PROV_R_ALGORITHM_MISMATCH = 173;
  PROV_R_ALREADY_INSTANTIATED = 185;
  PROV_R_BAD_DECRYPT = 100;
  PROV_R_BAD_ENCODING = 141;
  PROV_R_BAD_LENGTH = 142;
  PROV_R_BAD_TLS_CLIENT_VERSION = 161;
  PROV_R_BN_ERROR = 160;
  PROV_R_CIPHER_OPERATION_FAILED = 102;
  PROV_R_DERIVATION_FUNCTION_INIT_FAILED = 205;
  PROV_R_DIGEST_NOT_ALLOWED = 174;
  PROV_R_ENTROPY_SOURCE_STRENGTH_TOO_WEAK = 186;
  PROV_R_ERROR_INSTANTIATING_DRBG = 188;
  PROV_R_ERROR_RETRIEVING_ENTROPY = 189;
  PROV_R_ERROR_RETRIEVING_NONCE = 190;
  PROV_R_FAILED_DURING_DERIVATION = 164;
  PROV_R_FAILED_TO_CREATE_LOCK = 180;
  PROV_R_FAILED_TO_DECRYPT = 162;
  PROV_R_FAILED_TO_GENERATE_KEY = 121;
  PROV_R_FAILED_TO_GET_PARAMETER = 103;
  PROV_R_FAILED_TO_SET_PARAMETER = 104;
  PROV_R_FAILED_TO_SIGN = 175;
  PROV_R_FIPS_MODULE_CONDITIONAL_ERROR = 227;
  PROV_R_FIPS_MODULE_ENTERING_ERROR_STATE = 224;
  PROV_R_FIPS_MODULE_IN_ERROR_STATE = 225;
  PROV_R_GENERATE_ERROR = 191;
  PROV_R_ILLEGAL_OR_UNSUPPORTED_PADDING_MODE = 165;
  PROV_R_INDICATOR_INTEGRITY_FAILURE = 210;
  PROV_R_INSUFFICIENT_DRBG_STRENGTH = 181;
  PROV_R_INVALID_AAD = 108;
  PROV_R_INVALID_CONFIG_DATA = 211;
  PROV_R_INVALID_CONSTANT_LENGTH = 157;
  PROV_R_INVALID_CURVE = 176;
  PROV_R_INVALID_CUSTOM_LENGTH = 111;
  PROV_R_INVALID_DATA = 115;
  PROV_R_INVALID_DIGEST = 122;
  PROV_R_INVALID_DIGEST_LENGTH = 166;
  PROV_R_INVALID_DIGEST_SIZE = 218;
  PROV_R_INVALID_INPUT_LENGTH = 230;
  PROV_R_INVALID_ITERATION_COUNT = 123;
  PROV_R_INVALID_IV_LENGTH = 109;
  PROV_R_INVALID_KEY = 158;
  PROV_R_INVALID_KEY_LENGTH = 105;
  PROV_R_INVALID_MAC = 151;
  PROV_R_INVALID_MGF1_MD = 167;
  PROV_R_INVALID_MODE = 125;
  PROV_R_INVALID_OUTPUT_LENGTH = 217;
  PROV_R_INVALID_PADDING_MODE = 168;
  PROV_R_INVALID_PUBINFO = 198;
  PROV_R_INVALID_SALT_LENGTH = 112;
  PROV_R_INVALID_SEED_LENGTH = 154;
  PROV_R_INVALID_SIGNATURE_SIZE = 179;
  PROV_R_INVALID_STATE = 212;
  PROV_R_INVALID_TAG = 110;
  PROV_R_INVALID_TAG_LENGTH = 118;
  PROV_R_INVALID_UKM_LENGTH = 200;
  PROV_R_INVALID_X931_DIGEST = 170;
  PROV_R_IN_ERROR_STATE = 192;
  PROV_R_KEY_SETUP_FAILED = 101;
  PROV_R_KEY_SIZE_TOO_SMALL = 171;
  PROV_R_LENGTH_TOO_LARGE = 202;
  
  PROV_R_MODULE_INTEGRITY_FAILURE = 214;
  PROV_R_NOT_A_PRIVATE_KEY = 221;
  PROV_R_NOT_A_PUBLIC_KEY = 220;
  PROV_R_NOT_INSTANTIATED = 193;
  PROV_R_NOT_PARAMETERS = 226;
  PROV_R_NOT_SUPPORTED = 136;
  PROV_R_NOT_XOF_OR_INVALID_LENGTH = 113;
  PROV_R_NO_KEY_SET = 114;
  PROV_R_NO_PARAMETERS_SET = 177;
  PROV_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE = 178;
  PROV_R_OUTPUT_BUFFER_TOO_SMALL = 106;
  PROV_R_PARENT_CANNOT_GENERATE_RANDOM_NUMBERS = 228;
  PROV_R_PARENT_CANNOT_SUPPLY_ENTROPY_SEED = 187;
  PROV_R_PARENT_LOCKING_NOT_ENABLED = 182;
  PROV_R_PARENT_STRENGTH_TOO_WEAK = 194;
  PROV_R_PATH_MUST_BE_ABSOLUTE = 219;
  PROV_R_PERSONALISATION_STRING_TOO_LONG = 195;
  PROV_R_PSS_SALTLEN_TOO_SMALL = 172;
  PROV_R_REQUEST_TOO_LARGE_FOR_DRBG = 196;
  PROV_R_REQUIRE_CTR_MODE_CIPHER = 206;
  PROV_R_RESEED_ERROR = 197;
  PROV_R_SEARCH_ONLY_SUPPORTED_FOR_DIRECTORIES = 222;
  PROV_R_SEED_SOURCES_MUST_NOT_HAVE_A_PARENT = 229;
  PROV_R_SELF_TEST_KAT_FAILURE = 215;
  PROV_R_SELF_TEST_POST_FAILURE = 216;
  PROV_R_TAG_NOT_NEEDED = 120;
  PROV_R_TAG_NOT_SET = 119;
  PROV_R_TOO_MANY_RECORDS = 126;
  PROV_R_UNABLE_TO_FIND_CIPHERS = 207;
  PROV_R_UNABLE_TO_GET_PARENT_STRENGTH = 199;
  PROV_R_UNABLE_TO_GET_PASSPHRASE = 159;
  PROV_R_UNABLE_TO_INITIALISE_CIPHERS = 208;
  PROV_R_UNABLE_TO_LOAD_SHA256 = 147;
  PROV_R_UNABLE_TO_LOCK_PARENT = 201;
  PROV_R_UNABLE_TO_RESEED = 204;
  PROV_R_UNSUPPORTED_CEK_ALG = 145;
  PROV_R_UNSUPPORTED_KEY_SIZE = 153;
  PROV_R_UNSUPPORTED_MAC_TYPE = 137;
  PROV_R_UNSUPPORTED_NUMBER_OF_ROUNDS = 152;
  PROV_R_URI_AUTHORITY_UNSUPPORTED = 223;
  PROV_R_VALUE_ERROR = 138;
  PROV_R_WRONG_FINAL_BLOCK_LENGTH = 107;
  PROV_R_WRONG_OUTPUT_BUFFER_SIZE = 139;
  PROV_R_XOF_DIGESTS_NOT_ALLOWED = 183;
  PROV_R_XTS_DATA_UNIT_IS_TOO_LARGE = 148;
  PROV_R_XTS_DUPLICATED_KEYS = 149;

  EVP_ORIG_DYNAMIC = 0;
  EVP_ORIG_GLOBAL = 1;
  EVP_ORIG_METH = 2;

  OSSL_TLS_GROUP_ID_sect163k1 = $0001;
  OSSL_TLS_GROUP_ID_sect163r1 = $0002;
  OSSL_TLS_GROUP_ID_sect163r2 = $0003;
  OSSL_TLS_GROUP_ID_sect193r1 = $0004;
  OSSL_TLS_GROUP_ID_sect193r2 = $0005;
  OSSL_TLS_GROUP_ID_sect233k1 = $0006;
  OSSL_TLS_GROUP_ID_sect233r1 = $0007;
  OSSL_TLS_GROUP_ID_sect239k1 = $0008;
  OSSL_TLS_GROUP_ID_sect283k1 = $0009;
  OSSL_TLS_GROUP_ID_sect283r1 = $000A;
  OSSL_TLS_GROUP_ID_sect409k1 = $000B;
  OSSL_TLS_GROUP_ID_sect409r1 = $000C;
  OSSL_TLS_GROUP_ID_sect571k1 = $000D;
  OSSL_TLS_GROUP_ID_sect571r1 = $000E;
  OSSL_TLS_GROUP_ID_secp160k1 = $000F;
  OSSL_TLS_GROUP_ID_secp160r1 = $0010;
  OSSL_TLS_GROUP_ID_secp160r2 = $0011;
  OSSL_TLS_GROUP_ID_secp192k1 = $0012;
  OSSL_TLS_GROUP_ID_secp192r1 = $0013;
  OSSL_TLS_GROUP_ID_secp224k1 = $0014;
  OSSL_TLS_GROUP_ID_secp224r1 = $0015;
  OSSL_TLS_GROUP_ID_secp256k1 = $0016;
  OSSL_TLS_GROUP_ID_secp256r1 = $0017;
  OSSL_TLS_GROUP_ID_secp384r1 = $0018;
  OSSL_TLS_GROUP_ID_secp521r1 = $0019;
  OSSL_TLS_GROUP_ID_brainpoolP256r1 = $001A;
  OSSL_TLS_GROUP_ID_brainpoolP384r1 = $001B;
  OSSL_TLS_GROUP_ID_brainpoolP512r1 = $001C;
  OSSL_TLS_GROUP_ID_x25519 = $001D;
  OSSL_TLS_GROUP_ID_x448 = $001E;
  OSSL_TLS_GROUP_ID_brainpoolP256r1_tls13 = $001F;
  OSSL_TLS_GROUP_ID_brainpoolP384r1_tls13 = $0020;
  OSSL_TLS_GROUP_ID_brainpoolP512r1_tls13 = $0021;
  OSSL_TLS_GROUP_ID_gc256A = $0022;
  OSSL_TLS_GROUP_ID_gc256B = $0023;
  OSSL_TLS_GROUP_ID_gc256C = $0024;
  OSSL_TLS_GROUP_ID_gc256D = $0025;
  OSSL_TLS_GROUP_ID_gc512A = $0026;
  OSSL_TLS_GROUP_ID_gc512B = $0027;
  OSSL_TLS_GROUP_ID_gc512C = $0028;
  OSSL_TLS_GROUP_ID_ffdhe2048 = $0100;
  OSSL_TLS_GROUP_ID_ffdhe3072 = $0101;
  OSSL_TLS_GROUP_ID_ffdhe4096 = $0102;
  OSSL_TLS_GROUP_ID_ffdhe6144 = $0103;
  OSSL_TLS_GROUP_ID_ffdhe8192 = $0104;

  OSSL_FUNC_GET_ENTROPY = 101;
  OSSL_FUNC_CLEANUP_ENTROPY = 102;
  OSSL_FUNC_GET_NONCE = 103;
  OSSL_FUNC_CLEANUP_NONCE = 104;

  OSSL_FUNC_BIO_NEW_FILE = 40;
  OSSL_FUNC_BIO_NEW_MEMBUF = 41;
  OSSL_FUNC_BIO_READ_EX = 42;
  OSSL_FUNC_BIO_WRITE_EX = 43;
  OSSL_FUNC_BIO_UP_REF = 44;
  OSSL_FUNC_BIO_FREE = 45;
  OSSL_FUNC_BIO_VPRINTF = 46;
  OSSL_FUNC_BIO_VSNPRINTF = 47;
  OSSL_FUNC_BIO_PUTS = 48;
  OSSL_FUNC_BIO_GETS = 49;
  OSSL_FUNC_BIO_CTRL = 50;

  OSSL_OP_DIGEST = 1;
  OSSL_OP_CIPHER = 2;
  OSSL_OP_MAC = 3;
  OSSL_OP_KDF = 4;
  OSSL_OP_RAND = 5;
  OSSL_OP_KEYMGMT = 10;
  OSSL_OP_KEYEXCH = 11;
  OSSL_OP_SIGNATURE = 12;
  OSSL_OP_ASYM_CIPHER = 13;
  OSSL_OP_KEM = 14;
  OSSL_OP_ENCODER = 20;
  OSSL_OP_DECODER = 21;
  OSSL_OP_STORE = 22;
  OSSL_OP__HIGHEST = 22;

  OSSL_FUNC_KDF_NEWCTX = 1;
  OSSL_FUNC_KDF_DUPCTX = 2;
  OSSL_FUNC_KDF_FREECTX = 3;
  OSSL_FUNC_KDF_RESET = 4;
  OSSL_FUNC_KDF_DERIVE = 5;
  OSSL_FUNC_KDF_GETTABLE_PARAMS = 6;
  OSSL_FUNC_KDF_GETTABLE_CTX_PARAMS = 7;
  OSSL_FUNC_KDF_SETTABLE_CTX_PARAMS = 8;
  OSSL_FUNC_KDF_GET_PARAMS = 9;
  OSSL_FUNC_KDF_GET_CTX_PARAMS = 10;
  OSSL_FUNC_KDF_SET_CTX_PARAMS = 11;

  OSSL_FUNC_CORE_GETTABLE_PARAMS = 1;
  OSSL_FUNC_CORE_GET_PARAMS = 2;
  OSSL_FUNC_CORE_THREAD_START = 3;
  OSSL_FUNC_CORE_GET_LIBCTX = 4;
  OSSL_FUNC_CORE_NEW_ERROR = 5;
  OSSL_FUNC_CORE_SET_ERROR_DEBUG = 6;
  OSSL_FUNC_CORE_VSET_ERROR = 7;
  OSSL_FUNC_CORE_SET_ERROR_MARK = 8;
  OSSL_FUNC_CORE_CLEAR_LAST_ERROR_MARK = 9;
  OSSL_FUNC_CORE_POP_ERROR_TO_MARK = 10;
  OSSL_FUNC_CORE_OBJ_ADD_SIGID = 11;
  OSSL_FUNC_CORE_OBJ_CREATE = 12;
  BIO_TYPE_DESCRIPTOR = $0100;
  BIO_TYPE_FILTER = $0200;
  BIO_TYPE_SOURCE_SINK = $0400;
  BIO_TYPE_NONE = 0;
  BIO_TYPE_MEM = (1 or BIO_TYPE_SOURCE_SINK);
  BIO_TYPE_FILE = (2 or BIO_TYPE_SOURCE_SINK);
  BIO_TYPE_FD = (4 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR);
  BIO_TYPE_SOCKET = (5 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR);
  BIO_TYPE_NULL = (6 or BIO_TYPE_SOURCE_SINK);
  BIO_TYPE_SSL = (7 or BIO_TYPE_FILTER);
  BIO_TYPE_MD = (8 or BIO_TYPE_FILTER);
  BIO_TYPE_BUFFER = (9 or BIO_TYPE_FILTER);
  BIO_TYPE_CIPHER = (10 or BIO_TYPE_FILTER);
  BIO_TYPE_BASE64 = (11 or BIO_TYPE_FILTER);
  BIO_TYPE_CONNECT = (12 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR);
  BIO_TYPE_ACCEPT = (13 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR);
  BIO_TYPE_NBIO_TEST = (16 or BIO_TYPE_FILTER);
  BIO_TYPE_NULL_FILTER = (17 or BIO_TYPE_FILTER);
  BIO_TYPE_BIO = (19 or BIO_TYPE_SOURCE_SINK);
  BIO_TYPE_LINEBUFFER = (20 or BIO_TYPE_FILTER);
  BIO_TYPE_DGRAM = (21 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR);
  BIO_TYPE_ASN1 = (22 or BIO_TYPE_FILTER);
  BIO_TYPE_COMP = (23 or BIO_TYPE_FILTER);
  BIO_TYPE_CORE_TO_PROV = (25 or BIO_TYPE_SOURCE_SINK);
  BIO_TYPE_START = 128;

 

  CRYPTO_R_BAD_ALGORITHM_NAME = 117;
  CRYPTO_R_CONFLICTING_NAMES = 118;
  CRYPTO_R_HEX_STRING_TOO_SHORT = 121;
  CRYPTO_R_ILLEGAL_HEX_DIGIT = 102;
  CRYPTO_R_INSUFFICIENT_DATA_SPACE = 106;
  CRYPTO_R_INSUFFICIENT_PARAM_SIZE = 107;
  CRYPTO_R_INSUFFICIENT_SECURE_DATA_SPACE = 108;
  CRYPTO_R_INTEGER_OVERFLOW = 127;
  CRYPTO_R_INVALID_NEGATIVE_VALUE = 122;
  CRYPTO_R_INVALID_NULL_ARGUMENT = 109;
  CRYPTO_R_INVALID_OSSL_PARAM_TYPE = 110;
  CRYPTO_R_NO_PARAMS_TO_MERGE = 131;
  CRYPTO_R_NO_SPACE_FOR_TERMINATING_NULL = 128;
  CRYPTO_R_ODD_NUMBER_OF_DIGITS = 103;
  CRYPTO_R_PARAM_CANNOT_BE_REPRESENTED_EXACTLY = 123;
  CRYPTO_R_PARAM_NOT_INTEGER_TYPE = 124;
  CRYPTO_R_PARAM_OF_INCOMPATIBLE_TYPE = 129;
  CRYPTO_R_PARAM_UNSIGNED_INTEGER_NEGATIVE_VALUE_UNSUPPORTED = 125;
  CRYPTO_R_PARAM_UNSUPPORTED_FLOATING_POINT_FORMAT = 130;
  CRYPTO_R_PARAM_VALUE_TOO_LARGE_FOR_DESTINATION = 126;
  CRYPTO_R_PROVIDER_ALREADY_EXISTS = 104;
  CRYPTO_R_PROVIDER_SECTION_ERROR = 105;
  CRYPTO_R_RANDOM_SECTION_ERROR = 119;
  CRYPTO_R_SECURE_MALLOC_FAILURE = 111;
  CRYPTO_R_STRING_TOO_LONG = 112;
  CRYPTO_R_TOO_MANY_BYTES = 113;
  CRYPTO_R_TOO_MANY_RECORDS = 114;
  CRYPTO_R_TOO_SMALL_BUFFER = 116;
  CRYPTO_R_UNKNOWN_NAME_IN_RANDOM_SECTION = 120;
  CRYPTO_R_ZERO_LENGTH_NUMBER = 115;

  DSO_R_CTRL_FAILED           =                     100;
  DSO_R_DSO_ALREADY_LOADED    =                     110;
  DSO_R_UNLOAD_FAILED         =                     107;
  DSO_R_UNSUPPORTED           =                     108;
  DSO_R_NAME_TRANSLATION_FAILED   =                 109;
  DSO_R_FINISH_FAILED         =                     102;
  DSO_R_LOAD_FAILED           =                     103;
  DSO_R_NULL_HANDLE           =                     104;
  DSO_R_STACK_ERROR           =                     105;
  DSO_R_SYM_FAILURE           =                     106;
  DSO_R_FAILURE               =                     114;
  DSO_R_INCORRECT_FILE_SYNTAX =                     115;
  DSO_R_NO_FILENAME           =                     111;
  DSO_R_EMPTY_FILE_STRUCTURE  =                     113;
  DSO_R_SET_FILENAME_FAILED   =                     112;
  DSO_R_FILENAME_TOO_BIG      =                     101;
  OPENSSL_INIT_BASE_ONLY =  $00040000;
  PROP_R_NOT_AN_IDENTIFIER = 103;
  PROP_R_NAME_TOO_LONG     = 100;
  PROP_R_NOT_AN_ASCII_CHARACTER       =             101;
  PROP_R_TRAILING_CHARACTERS          =             110;
  PROP_R_NO_MATCHING_STRING_DELIMITER =             106;
  PROP_R_NOT_AN_OCTAL_DIGIT           =             104;
  PROP_R_NOT_A_DECIMAL_DIGIT =                      105;
  PROP_R_NOT_AN_HEXADECIMAL_DIGIT     =             102;
  PROP_R_PARSE_FAILED                 =             108;
  PROP_R_NO_VALUE                     =             107;
  PROP_R_STRING_TOO_LONG   = 109;
  SN_modp_1536 = 'modp_1536';
  NID_modp_1536 = 1212;
  SN_modp_2048 = 'modp_2048';
  NID_modp_2048 = 1213;
  SN_modp_3072 = 'modp_3072';
  NID_modp_3072 = 1214;
  SN_modp_4096 = 'modp_4096';
  NID_modp_4096 = 1215;
  SN_modp_6144 = 'modp_6144';
  NID_modp_6144 = 1216;
  SN_modp_8192 = 'modp_8192';
  NID_modp_8192 = 1217;
  DSO_FLAG_NO_UNLOAD_ON_FREE      =        $04;
 

  OSSL_LIB_CTX_EVP_METHOD_STORE_INDEX = 0;
  OSSL_LIB_CTX_PROVIDER_STORE_INDEX = 1;
  OSSL_LIB_CTX_PROPERTY_DEFN_INDEX = 2;
  OSSL_LIB_CTX_PROPERTY_STRING_INDEX = 3;
  OSSL_LIB_CTX_NAMEMAP_INDEX = 4;
  OSSL_LIB_CTX_DRBG_INDEX = 5;
  OSSL_LIB_CTX_DRBG_NONCE_INDEX = 6;
  OSSL_LIB_CTX_RAND_CRNGT_INDEX = 7;
  OSSL_LIB_CTX_FIPS_PROV_INDEX = 9;
  OSSL_LIB_CTX_ENCODER_STORE_INDEX = 10;
  OSSL_LIB_CTX_DECODER_STORE_INDEX = 11;
  OSSL_LIB_CTX_SELF_TEST_CB_INDEX = 12;
  OSSL_LIB_CTX_BIO_PROV_INDEX = 13;
  OSSL_LIB_CTX_GLOBAL_PROPERTIES = 14;
  OSSL_LIB_CTX_STORE_LOADER_STORE_INDEX = 15;
  OSSL_LIB_CTX_PROVIDER_CONF_INDEX = 16;
  OSSL_LIB_CTX_BIO_CORE_INDEX = 17;
  OSSL_LIB_CTX_CHILD_PROVIDER_INDEX = 18;
  OSSL_LIB_CTX_MAX_INDEXES = 19;



  OSSL_PROV_PARAM_CORE_VERSION = 'openssl-version';
  OSSL_PROV_PARAM_CORE_PROV_NAME = 'provider-name';
  OSSL_PROV_PARAM_CORE_MODULE_FILENAME = 'module-filename';
  OSSL_PROV_FIPS_PARAM_MODULE_MAC      = 'module-mac';
  OSSL_PROV_FIPS_PARAM_INSTALL_MAC     = 'install-mac';
  OSSL_PROV_FIPS_PARAM_INSTALL_STATUS  = 'install-status';
  OSSL_PROV_FIPS_PARAM_INSTALL_VERSION = 'install-version';
  OSSL_PROV_FIPS_PARAM_CONDITIONAL_ERRORS = 'conditional-errors';
  OSSL_PROV_FIPS_PARAM_SECURITY_CHECKS = 'security-checks';

  OSSL_PROV_PARAM_NAME = 'name';
  OSSL_PROV_PARAM_VERSION = 'version';
  OSSL_PROV_PARAM_BUILDINFO = 'buildinfo';
  OSSL_PROV_PARAM_STATUS = 'status';
  OSSL_PROV_PARAM_SECURITY_CHECKS = 'security-checks';
  OSSL_PROV_PARAM_SELF_TEST_PHASE = 'st-phase';
  OSSL_PROV_PARAM_SELF_TEST_TYPE = 'st-type';
  OSSL_PROV_PARAM_SELF_TEST_DESC = 'st-desc';
  OSSL_OBJECT_PARAM_TYPE = 'type';
  OSSL_OBJECT_PARAM_DATA_TYPE = 'data-type';
  OSSL_OBJECT_PARAM_DATA_STRUCTURE = 'data-structure';
  OSSL_OBJECT_PARAM_REFERENCE = 'reference';
  OSSL_OBJECT_PARAM_DATA = 'data';
  OSSL_OBJECT_PARAM_DESC = 'desc';
  OSSL_ALG_PARAM_DIGEST = 'digest';
  OSSL_ALG_PARAM_CIPHER = 'cipher';
  OSSL_ALG_PARAM_ENGINE = 'engine';
  OSSL_ALG_PARAM_MAC = 'mac';
  OSSL_ALG_PARAM_PROPERTIES = 'properties';
  
  OSSL_DIGEST_NAME_MD5 = 'MD5';
  OSSL_DIGEST_NAME_MD5_SHA1 = 'MD5-SHA1';
  OSSL_DIGEST_NAME_SHA1 = 'SHA1';
  OSSL_DIGEST_NAME_SHA2_224 = 'SHA2-224';
  OSSL_DIGEST_NAME_SHA2_256 = 'SHA2-256';
  OSSL_DIGEST_NAME_SHA2_384 = 'SHA2-384';
  OSSL_DIGEST_NAME_SHA2_512 = 'SHA2-512';
  OSSL_DIGEST_NAME_SHA2_512_224 = 'SHA2-512/224';
  OSSL_DIGEST_NAME_SHA2_512_256 = 'SHA2-512/256';
  OSSL_DIGEST_NAME_MD2 = 'MD2';
  OSSL_DIGEST_NAME_MD4 = 'MD4';
  OSSL_DIGEST_NAME_MDC2 = 'MDC2';
  OSSL_DIGEST_NAME_RIPEMD160 = 'RIPEMD160';
  OSSL_DIGEST_NAME_SHA3_224 = 'SHA3-224';
  OSSL_DIGEST_NAME_SHA3_256 = 'SHA3-256';
  OSSL_DIGEST_NAME_SHA3_384 = 'SHA3-384';
  OSSL_DIGEST_NAME_SHA3_512 = 'SHA3-512';
  OSSL_DIGEST_NAME_KECCAK_KMAC128 = 'KECCAK-KMAC-128';
  OSSL_DIGEST_NAME_KECCAK_KMAC256 = 'KECCAK-KMAC-256';
  OSSL_DIGEST_NAME_SM3 = 'SM3';
  RSA_DEFAULT_DIGEST_NAME = OSSL_DIGEST_NAME_SHA1;
  OSSL_MAC_PARAM_KEY = 'key';
  OSSL_MAC_PARAM_IV = 'iv';
  OSSL_MAC_PARAM_CUSTOM = 'custom';
  OSSL_MAC_PARAM_SALT = 'salt';
  OSSL_MAC_PARAM_XOF = 'xof';
  OSSL_MAC_PARAM_DIGEST_NOINIT = 'digest-noinit';
  OSSL_MAC_PARAM_DIGEST_ONESHOT = 'digest-oneshot';
  OSSL_MAC_PARAM_C_ROUNDS = 'c-rounds';
  OSSL_MAC_PARAM_D_ROUNDS = 'd-rounds';
  OSSL_MAC_PARAM_CIPHER = OSSL_ALG_PARAM_CIPHER;
  OSSL_MAC_PARAM_DIGEST = OSSL_ALG_PARAM_DIGEST;
  OSSL_MAC_PARAM_PROPERTIES = OSSL_ALG_PARAM_PROPERTIES;
  OSSL_MAC_PARAM_SIZE = 'size';
  OSSL_MAC_PARAM_BLOCK_SIZE = 'block-size';
  OSSL_MAC_PARAM_TLS_DATA_SIZE = 'tls-data-size';
  OSSL_MAC_NAME_BLAKE2BMAC = 'BLAKE2BMAC';
  OSSL_MAC_NAME_BLAKE2SMAC = 'BLAKE2SMAC';
  OSSL_MAC_NAME_CMAC = 'CMAC';
  OSSL_MAC_NAME_GMAC = 'GMAC';
  OSSL_MAC_NAME_HMAC = 'HMAC';
  OSSL_MAC_NAME_KMAC128 = 'KMAC128';
  OSSL_MAC_NAME_KMAC256 = 'KMAC256';
  OSSL_MAC_NAME_POLY1305 = 'POLY1305';
  OSSL_MAC_NAME_SIPHASH = 'SIPHASH';
  OSSL_KDF_PARAM_SECRET = 'secret';
  OSSL_KDF_PARAM_KEY = 'key';
  OSSL_KDF_PARAM_SALT = 'salt';
  OSSL_KDF_PARAM_PASSWORD = 'pass';
  OSSL_KDF_PARAM_PREFIX = 'prefix';
  OSSL_KDF_PARAM_LABEL = 'label';
  OSSL_KDF_PARAM_DATA = 'data';
  OSSL_KDF_PARAM_DIGEST = OSSL_ALG_PARAM_DIGEST;
  OSSL_KDF_PARAM_CIPHER = OSSL_ALG_PARAM_CIPHER;
  OSSL_KDF_PARAM_MAC = OSSL_ALG_PARAM_MAC;
  OSSL_KDF_PARAM_MAC_SIZE = 'maclen';
  OSSL_KDF_PARAM_PROPERTIES = OSSL_ALG_PARAM_PROPERTIES;
  OSSL_KDF_PARAM_ITER = 'iter';
  OSSL_KDF_PARAM_MODE = 'mode';
  OSSL_KDF_PARAM_PKCS5 = 'pkcs5';
  OSSL_KDF_PARAM_UKM = 'ukm';
  OSSL_KDF_PARAM_CEK_ALG = 'cekalg';
  OSSL_KDF_PARAM_SCRYPT_N = 'n';
  OSSL_KDF_PARAM_SCRYPT_R = 'r';
  OSSL_KDF_PARAM_SCRYPT_P = 'p';
  OSSL_KDF_PARAM_SCRYPT_MAXMEM = 'maxmem_bytes';
  OSSL_KDF_PARAM_INFO = 'info';
  OSSL_KDF_PARAM_SEED = 'seed';
  OSSL_KDF_PARAM_SSHKDF_XCGHASH = 'xcghash';
  OSSL_KDF_PARAM_SSHKDF_SESSION_ID = 'session_id';
  OSSL_KDF_PARAM_SSHKDF_TYPE = 'type';
  OSSL_KDF_PARAM_SIZE = 'size';
  OSSL_KDF_PARAM_CONSTANT = 'constant';
  OSSL_KDF_PARAM_PKCS12_ID = 'id';
  OSSL_KDF_PARAM_KBKDF_USE_L = 'use-l';
  OSSL_KDF_PARAM_KBKDF_USE_SEPARATOR = 'use-separator';
  OSSL_KDF_PARAM_KBKDF_R = 'r';
  OSSL_KDF_PARAM_X942_ACVPINFO = 'acvp-info';
  OSSL_KDF_PARAM_X942_PARTYUINFO = 'partyu-info';
  OSSL_KDF_PARAM_X942_PARTYVINFO = 'partyv-info';
  OSSL_KDF_PARAM_X942_SUPP_PUBINFO = 'supp-pubinfo';
  OSSL_KDF_PARAM_X942_SUPP_PRIVINFO = 'supp-privinfo';
  OSSL_KDF_PARAM_X942_USE_KEYBITS = 'use-keybits';
  OSSL_KDF_NAME_HKDF = 'HKDF';
  OSSL_KDF_NAME_TLS1_3_KDF = 'TLS13-KDF';
  OSSL_KDF_NAME_PBKDF1 = 'PBKDF1';
  OSSL_KDF_NAME_PBKDF2 = 'PBKDF2';
  OSSL_KDF_NAME_SCRYPT = 'SCRYPT';
  OSSL_KDF_NAME_SSHKDF = 'SSHKDF';
  OSSL_KDF_NAME_SSKDF = 'SSKDF';
  OSSL_KDF_NAME_TLS1_PRF = 'TLS1-PRF';
  OSSL_KDF_NAME_X942KDF_ASN1 = 'X942KDF-ASN1';
  OSSL_KDF_NAME_X942KDF_CONCAT = 'X942KDF-CONCAT';
  OSSL_KDF_NAME_X963KDF = 'X963KDF';
  OSSL_KDF_NAME_KBKDF = 'KBKDF';
  OSSL_KDF_NAME_KRB5KDF = 'KRB5KDF';
  OSSL_RAND_PARAM_STATE = 'state';
  OSSL_RAND_PARAM_STRENGTH = 'strength';
  OSSL_RAND_PARAM_MAX_REQUEST = 'max_request';
  OSSL_RAND_PARAM_TEST_ENTROPY = 'test_entropy';
  OSSL_RAND_PARAM_TEST_NONCE = 'test_nonce';
  OSSL_DRBG_PARAM_RESEED_REQUESTS = 'reseed_requests';
  OSSL_DRBG_PARAM_RESEED_TIME_INTERVAL = 'reseed_time_interval';
  OSSL_DRBG_PARAM_MIN_ENTROPYLEN = 'min_entropylen';
  OSSL_DRBG_PARAM_MAX_ENTROPYLEN = 'max_entropylen';
  OSSL_DRBG_PARAM_MIN_NONCELEN = 'min_noncelen';
  OSSL_DRBG_PARAM_MAX_NONCELEN = 'max_noncelen';
  OSSL_DRBG_PARAM_MAX_PERSLEN = 'max_perslen';
  OSSL_DRBG_PARAM_MAX_ADINLEN = 'max_adinlen';
  OSSL_DRBG_PARAM_RESEED_COUNTER = 'reseed_counter';
  OSSL_DRBG_PARAM_RESEED_TIME = 'reseed_time';
  OSSL_DRBG_PARAM_PROPERTIES = OSSL_ALG_PARAM_PROPERTIES;
  OSSL_DRBG_PARAM_DIGEST = OSSL_ALG_PARAM_DIGEST;
  OSSL_DRBG_PARAM_CIPHER = OSSL_ALG_PARAM_CIPHER;
  OSSL_DRBG_PARAM_MAC = OSSL_ALG_PARAM_MAC;
  OSSL_DRBG_PARAM_USE_DF = 'use_derivation_function';
  OSSL_DRBG_PARAM_ENTROPY_REQUIRED = 'entropy_required';
  OSSL_DRBG_PARAM_PREDICTION_RESISTANCE = 'prediction_resistance';
  OSSL_DRBG_PARAM_MIN_LENGTH = 'minium_length';
  OSSL_DRBG_PARAM_MAX_LENGTH = 'maxium_length';
  OSSL_DRBG_PARAM_RANDOM_DATA = 'random_data';
  OSSL_DRBG_PARAM_SIZE = 'size';
  OSSL_PKEY_PARAM_BITS = 'bits';
  OSSL_PKEY_PARAM_MAX_SIZE = 'max-size';
  OSSL_PKEY_PARAM_SECURITY_BITS = 'security-bits';
  OSSL_PKEY_PARAM_DIGEST = OSSL_ALG_PARAM_DIGEST;
  OSSL_PKEY_PARAM_CIPHER = OSSL_ALG_PARAM_CIPHER;
  OSSL_PKEY_PARAM_ENGINE = OSSL_ALG_PARAM_ENGINE;
  OSSL_PKEY_PARAM_PROPERTIES = OSSL_ALG_PARAM_PROPERTIES;
  OSSL_PKEY_PARAM_DEFAULT_DIGEST = 'default-digest';
  OSSL_PKEY_PARAM_MANDATORY_DIGEST = 'mandatory-digest';
  OSSL_PKEY_PARAM_PAD_MODE = 'pad-mode';
  OSSL_PKEY_PARAM_DIGEST_SIZE = 'digest-size';
  OSSL_PKEY_PARAM_MASKGENFUNC = 'mgf';
  OSSL_PKEY_PARAM_MGF1_DIGEST = 'mgf1-digest';
  OSSL_PKEY_PARAM_MGF1_PROPERTIES = 'mgf1-properties';
  OSSL_PKEY_PARAM_ENCODED_PUBLIC_KEY = 'encoded-pub-key';
  OSSL_PKEY_PARAM_GROUP_NAME = 'group';
  OSSL_PKEY_PARAM_DIST_ID = 'distid';
  OSSL_PKEY_PARAM_PUB_KEY = 'pub';
  OSSL_PKEY_PARAM_PRIV_KEY = 'priv';
  OSSL_PKEY_PARAM_FFC_P = 'p';
  OSSL_PKEY_PARAM_FFC_G = 'g';
  OSSL_PKEY_PARAM_FFC_Q = 'q';
  OSSL_PKEY_PARAM_FFC_GINDEX = 'gindex';
  OSSL_PKEY_PARAM_FFC_PCOUNTER = 'pcounter';
  OSSL_PKEY_PARAM_FFC_SEED = 'seed';
  OSSL_PKEY_PARAM_FFC_COFACTOR = 'j';
  OSSL_PKEY_PARAM_FFC_H = 'hindex';
  OSSL_PKEY_PARAM_FFC_VALIDATE_PQ = 'validate-pq';
  OSSL_PKEY_PARAM_FFC_VALIDATE_G = 'validate-g';
  OSSL_PKEY_PARAM_FFC_VALIDATE_LEGACY = 'validate-legacy';
  OSSL_PKEY_PARAM_DH_GENERATOR = 'safeprime-generator';
  OSSL_PKEY_PARAM_DH_PRIV_LEN = 'priv_len';
  OSSL_PKEY_PARAM_EC_PUB_X = 'qx';
  OSSL_PKEY_PARAM_EC_PUB_Y = 'qy';
  OSSL_PKEY_PARAM_EC_FIELD_TYPE = 'field-type';
  OSSL_PKEY_PARAM_EC_P = 'p';
  OSSL_PKEY_PARAM_EC_A = 'a';
  OSSL_PKEY_PARAM_EC_B = 'b';
  OSSL_PKEY_PARAM_EC_GENERATOR = 'generator';
  OSSL_PKEY_PARAM_EC_ORDER = 'order';
  OSSL_PKEY_PARAM_EC_COFACTOR = 'cofactor';
  OSSL_PKEY_PARAM_EC_SEED = 'seed';
  OSSL_PKEY_PARAM_EC_CHAR2_M = 'm';
  OSSL_PKEY_PARAM_EC_CHAR2_TYPE = 'basis-type';
  OSSL_PKEY_PARAM_EC_CHAR2_TP_BASIS = 'tp';
  OSSL_PKEY_PARAM_EC_CHAR2_PP_K1 = 'k1';
  OSSL_PKEY_PARAM_EC_CHAR2_PP_K2 = 'k2';
  OSSL_PKEY_PARAM_EC_CHAR2_PP_K3 = 'k3';
  OSSL_PKEY_PARAM_EC_DECODED_FROM_EXPLICIT_PARAMS = 'decoded-from-explicit';
  OSSL_PKEY_PARAM_USE_COFACTOR_FLAG = 'use-cofactor-flag';
  OSSL_PKEY_PARAM_USE_COFACTOR_ECDH = OSSL_PKEY_PARAM_USE_COFACTOR_FLAG;
  OSSL_PKEY_PARAM_RSA_N = 'n';
  OSSL_PKEY_PARAM_RSA_E = 'e';
  OSSL_PKEY_PARAM_RSA_D = 'd';
  OSSL_PKEY_PARAM_RSA_FACTOR = 'rsa-factor';
  OSSL_PKEY_PARAM_RSA_EXPONENT = 'rsa-exponent';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT = 'rsa-coefficient';
  OSSL_PKEY_PARAM_RSA_FACTOR1 = OSSL_PKEY_PARAM_RSA_FACTOR+'1';
  OSSL_PKEY_PARAM_RSA_FACTOR2 = OSSL_PKEY_PARAM_RSA_FACTOR+'2';
  OSSL_PKEY_PARAM_RSA_FACTOR3 = OSSL_PKEY_PARAM_RSA_FACTOR+'3';
  OSSL_PKEY_PARAM_RSA_FACTOR4 = OSSL_PKEY_PARAM_RSA_FACTOR+'4';
  OSSL_PKEY_PARAM_RSA_FACTOR5 = OSSL_PKEY_PARAM_RSA_FACTOR+'5';
  OSSL_PKEY_PARAM_RSA_FACTOR6 = OSSL_PKEY_PARAM_RSA_FACTOR+'6';
  OSSL_PKEY_PARAM_RSA_FACTOR7 = OSSL_PKEY_PARAM_RSA_FACTOR+'7';
  OSSL_PKEY_PARAM_RSA_FACTOR8 = OSSL_PKEY_PARAM_RSA_FACTOR+'8';
  OSSL_PKEY_PARAM_RSA_FACTOR9 = OSSL_PKEY_PARAM_RSA_FACTOR+'9';
  OSSL_PKEY_PARAM_RSA_FACTOR10 = OSSL_PKEY_PARAM_RSA_FACTOR+'10';
  OSSL_PKEY_PARAM_RSA_EXPONENT1 = OSSL_PKEY_PARAM_RSA_EXPONENT+'1';
  OSSL_PKEY_PARAM_RSA_EXPONENT2 = OSSL_PKEY_PARAM_RSA_EXPONENT+'2';
  OSSL_PKEY_PARAM_RSA_EXPONENT3 = OSSL_PKEY_PARAM_RSA_EXPONENT+'3';
  OSSL_PKEY_PARAM_RSA_EXPONENT4 = OSSL_PKEY_PARAM_RSA_EXPONENT+'4';
  OSSL_PKEY_PARAM_RSA_EXPONENT5 = OSSL_PKEY_PARAM_RSA_EXPONENT+'5';
  OSSL_PKEY_PARAM_RSA_EXPONENT6 = OSSL_PKEY_PARAM_RSA_EXPONENT+'6';
  OSSL_PKEY_PARAM_RSA_EXPONENT7 = OSSL_PKEY_PARAM_RSA_EXPONENT+'7';
  OSSL_PKEY_PARAM_RSA_EXPONENT8 = OSSL_PKEY_PARAM_RSA_EXPONENT+'8';
  OSSL_PKEY_PARAM_RSA_EXPONENT9 = OSSL_PKEY_PARAM_RSA_EXPONENT+'9';
  OSSL_PKEY_PARAM_RSA_EXPONENT10 = OSSL_PKEY_PARAM_RSA_EXPONENT+'10';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT1 = OSSL_PKEY_PARAM_RSA_COEFFICIENT+'1';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT2 = OSSL_PKEY_PARAM_RSA_COEFFICIENT+'2';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT3 = OSSL_PKEY_PARAM_RSA_COEFFICIENT+'3';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT4 = OSSL_PKEY_PARAM_RSA_COEFFICIENT+'4';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT5 = OSSL_PKEY_PARAM_RSA_COEFFICIENT+'5';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT6 = OSSL_PKEY_PARAM_RSA_COEFFICIENT+'6';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT7 = OSSL_PKEY_PARAM_RSA_COEFFICIENT+'7';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT8 = OSSL_PKEY_PARAM_RSA_COEFFICIENT+'8';
  OSSL_PKEY_PARAM_RSA_COEFFICIENT9 = OSSL_PKEY_PARAM_RSA_COEFFICIENT+'9';
  OSSL_PKEY_RSA_PAD_MODE_NONE = 'none';
  OSSL_PKEY_RSA_PAD_MODE_PKCSV15 = 'pkcs1';
  OSSL_PKEY_RSA_PAD_MODE_OAEP = 'oaep';
  OSSL_PKEY_RSA_PAD_MODE_X931 = 'x931';
  OSSL_PKEY_RSA_PAD_MODE_PSS = 'pss';
  OSSL_PKEY_RSA_PSS_SALT_LEN_DIGEST = 'digest';
  OSSL_PKEY_RSA_PSS_SALT_LEN_MAX = 'max';
  OSSL_PKEY_RSA_PSS_SALT_LEN_AUTO = 'auto';
  OSSL_PKEY_PARAM_RSA_BITS = OSSL_PKEY_PARAM_BITS;
  OSSL_PKEY_PARAM_RSA_PRIMES = 'primes';
  OSSL_PKEY_PARAM_RSA_DIGEST = OSSL_PKEY_PARAM_DIGEST;
  OSSL_PKEY_PARAM_RSA_DIGEST_PROPS = OSSL_PKEY_PARAM_PROPERTIES;
  OSSL_PKEY_PARAM_RSA_MASKGENFUNC = OSSL_PKEY_PARAM_MASKGENFUNC;
  OSSL_PKEY_PARAM_RSA_MGF1_DIGEST = OSSL_PKEY_PARAM_MGF1_DIGEST;
  OSSL_PKEY_PARAM_RSA_PSS_SALTLEN = 'saltlen';
  OSSL_PKEY_PARAM_FFC_TYPE = 'type';
  OSSL_PKEY_PARAM_FFC_PBITS = 'pbits';
  OSSL_PKEY_PARAM_FFC_QBITS = 'qbits';
  OSSL_PKEY_PARAM_FFC_DIGEST = OSSL_PKEY_PARAM_DIGEST;
  OSSL_PKEY_PARAM_FFC_DIGEST_PROPS = OSSL_PKEY_PARAM_PROPERTIES;
  OSSL_PKEY_PARAM_EC_ENCODING = 'encoding';
  OSSL_PKEY_PARAM_EC_POINT_CONVERSION_FORMAT = 'point-format';
  OSSL_PKEY_PARAM_EC_GROUP_CHECK_TYPE = 'group-check';
  OSSL_PKEY_PARAM_EC_INCLUDE_PUBLIC = 'include-public';
  OSSL_PKEY_EC_ENCODING_EXPLICIT = 'explicit';
  OSSL_PKEY_EC_ENCODING_GROUP = 'named_curve';
  OSSL_PKEY_EC_POINT_CONVERSION_FORMAT_UNCOMPRESSED = 'uncompressed';
  OSSL_PKEY_EC_POINT_CONVERSION_FORMAT_COMPRESSED = 'compressed';
  OSSL_PKEY_EC_POINT_CONVERSION_FORMAT_HYBRID = 'hybrid';
  OSSL_PKEY_EC_GROUP_CHECK_DEFAULT = 'default';
  OSSL_PKEY_EC_GROUP_CHECK_NAMED = 'named';
  OSSL_PKEY_EC_GROUP_CHECK_NAMED_NIST = 'named-nist';
  OSSL_EXCHANGE_PARAM_PAD = 'pad';
  OSSL_EXCHANGE_PARAM_EC_ECDH_COFACTOR_MODE = 'ecdh-cofactor-mode';
  OSSL_EXCHANGE_PARAM_KDF_TYPE = 'kdf-type';
  OSSL_EXCHANGE_PARAM_KDF_DIGEST = 'kdf-digest';
  OSSL_EXCHANGE_PARAM_KDF_DIGEST_PROPS = 'kdf-digest-props';
  OSSL_EXCHANGE_PARAM_KDF_OUTLEN = 'kdf-outlen';
  OSSL_EXCHANGE_PARAM_KDF_UKM = 'kdf-ukm';
  OSSL_SIGNATURE_PARAM_ALGORITHM_ID = 'algorithm-id';
  OSSL_SIGNATURE_PARAM_PAD_MODE = OSSL_PKEY_PARAM_PAD_MODE;
  OSSL_SIGNATURE_PARAM_DIGEST = OSSL_PKEY_PARAM_DIGEST;
  OSSL_SIGNATURE_PARAM_PROPERTIES = OSSL_PKEY_PARAM_PROPERTIES;
  OSSL_SIGNATURE_PARAM_PSS_SALTLEN = 'saltlen';
  OSSL_SIGNATURE_PARAM_MGF1_DIGEST = OSSL_PKEY_PARAM_MGF1_DIGEST;
  OSSL_SIGNATURE_PARAM_MGF1_PROPERTIES = OSSL_PKEY_PARAM_MGF1_PROPERTIES;
  OSSL_SIGNATURE_PARAM_DIGEST_SIZE = OSSL_PKEY_PARAM_DIGEST_SIZE;
  OSSL_ASYM_CIPHER_PARAM_DIGEST = OSSL_PKEY_PARAM_DIGEST;
  OSSL_ASYM_CIPHER_PARAM_PROPERTIES = OSSL_PKEY_PARAM_PROPERTIES;
  OSSL_ASYM_CIPHER_PARAM_ENGINE = OSSL_PKEY_PARAM_ENGINE;
  OSSL_ASYM_CIPHER_PARAM_PAD_MODE = OSSL_PKEY_PARAM_PAD_MODE;
  OSSL_ASYM_CIPHER_PARAM_MGF1_DIGEST = OSSL_PKEY_PARAM_MGF1_DIGEST;
  OSSL_ASYM_CIPHER_PARAM_MGF1_DIGEST_PROPS = OSSL_PKEY_PARAM_MGF1_PROPERTIES;
  OSSL_ASYM_CIPHER_PARAM_OAEP_DIGEST = OSSL_ALG_PARAM_DIGEST;
  OSSL_ASYM_CIPHER_PARAM_OAEP_DIGEST_PROPS = 'digest-props';
  OSSL_ASYM_CIPHER_PARAM_OAEP_LABEL = 'oaep-label';
  OSSL_ASYM_CIPHER_PARAM_TLS_CLIENT_VERSION = 'tls-client-version';
  OSSL_ASYM_CIPHER_PARAM_TLS_NEGOTIATED_VERSION = 'tls-negotiated-version';
  OSSL_ENCODER_PARAM_CIPHER = OSSL_ALG_PARAM_CIPHER;
  OSSL_ENCODER_PARAM_PROPERTIES = OSSL_ALG_PARAM_PROPERTIES;
  OSSL_ENCODER_PARAM_ENCRYPT_LEVEL = 'encrypt-level';
  OSSL_ENCODER_PARAM_SAVE_PARAMETERS = 'save-parameters';
  OSSL_DECODER_PARAM_PROPERTIES = OSSL_ALG_PARAM_PROPERTIES;
  OSSL_PASSPHRASE_PARAM_INFO = 'info';
  OSSL_GEN_PARAM_POTENTIAL = 'potential';
  OSSL_GEN_PARAM_ITERATION = 'iteration';
  OSSL_PKEY_PARAM_RSA_TEST_XP1 = 'xp1';
  OSSL_PKEY_PARAM_RSA_TEST_XP2 = 'xp2';
  OSSL_PKEY_PARAM_RSA_TEST_XP = 'xp';
  OSSL_PKEY_PARAM_RSA_TEST_XQ1 = 'xq1';
  OSSL_PKEY_PARAM_RSA_TEST_XQ2 = 'xq2';
  OSSL_PKEY_PARAM_RSA_TEST_XQ = 'xq';
  OSSL_PKEY_PARAM_RSA_TEST_P1 = 'p1';
  OSSL_PKEY_PARAM_RSA_TEST_P2 = 'p2';
  OSSL_PKEY_PARAM_RSA_TEST_Q1 = 'q1';
  OSSL_PKEY_PARAM_RSA_TEST_Q2 = 'q2';
  OSSL_SIGNATURE_PARAM_KAT = 'kat';
  OSSL_KEM_PARAM_OPERATION = 'operation';
  OSSL_KEM_PARAM_OPERATION_RSASVE = 'RSASVE';
  OSSL_CAPABILITY_TLS_GROUP_NAME = 'tls-group-name';
  OSSL_CAPABILITY_TLS_GROUP_NAME_INTERNAL = 'tls-group-name-internal';
  OSSL_CAPABILITY_TLS_GROUP_ID = 'tls-group-id';
  OSSL_CAPABILITY_TLS_GROUP_ALG = 'tls-group-alg';
  OSSL_CAPABILITY_TLS_GROUP_SECURITY_BITS = 'tls-group-sec-bits';
  OSSL_CAPABILITY_TLS_GROUP_IS_KEM = 'tls-group-is-kem';
  OSSL_CAPABILITY_TLS_GROUP_MIN_TLS = 'tls-min-tls';
  OSSL_CAPABILITY_TLS_GROUP_MAX_TLS = 'tls-max-tls';
  OSSL_CAPABILITY_TLS_GROUP_MIN_DTLS = 'tls-min-dtls';
  OSSL_CAPABILITY_TLS_GROUP_MAX_DTLS = 'tls-max-dtls';
  OSSL_STORE_PARAM_EXPECT = 'expect';
  OSSL_STORE_PARAM_SUBJECT = 'subject';
  OSSL_STORE_PARAM_ISSUER = 'name';
  OSSL_STORE_PARAM_SERIAL = 'serial';
  OSSL_STORE_PARAM_DIGEST = 'digest';
  OSSL_STORE_PARAM_FINGERPRINT = 'fingerprint';
  OSSL_STORE_PARAM_ALIAS = 'alias';
  OSSL_STORE_PARAM_PROPERTIES = 'properties';
  OSSL_STORE_PARAM_INPUT_TYPE = 'input-type';

  OSSL_PARAM_REAL      =           3;
  INT32_MIN    =    (-2147483647 - 1);
  INT32_MAX    =    2147483647;
  INT64_MAX    =    9223372036854775807;
  INT64_MIN    =    (-9223372036854775807 - 1);
  UINT32_MAX   =    $ffffffff;
  UINT64_MAX   =    $ffffffffffffffff;
  ULONG_MAX    =    $ffffffff;
  DRBG_MAX_LENGTH  =  INT32_MAX;

  OPENSSL_FUNC = '(unknown function)';
  OSSL_PARAM_UNSIGNED_INTEGER  =   2;
  OSSL_PARAM_UTF8_STRING      =    4;
  OSSL_PARAM_UTF8_PTR         =    6;
  OSSL_PARAM_OCTET_PTR        =    7;
  OSSL_PARAM_OCTET_STRING     =    5;
  ERR_LIB_MASK =  $FF ;
  ERR_LIB_OFFSET  =               23;
  ERR_RFLAGS_OFFSET  =            18;
  ERR_REASON_MASK    = $7FFFFF;

  SIGINT    = 2;   // interrupt
  SIGILL    = 4;   // illegal instruction - invalid function image
  SIGFPE    = 8;   // floating point exception
  SIGSEGV   = 11;  // segment violation
  SIGTERM   = 15;  // Software termination signal from kill
  SIGBREAK  = 21;  // Ctrl-Break sequence
  SIGABRT  =       22;  // abnormal termination triggered by abort call
  OSSL_PARAM_INTEGER = 1;
  INT_MAX  =     2147483647;
  X509_ADD_FLAG_DEFAULT = 0;
  X509_CRL_VERSION_1 = 0;
  X509_CRL_VERSION_2 = 1;
  X509_ADD_FLAG_NO_DUP =  $4;
  X509_ADD_FLAG_NO_SS  =  $8;
  X509_ADD_FLAG_PREPEND = $2;
  X509_ADD_FLAG_UP_REF  = $1;
  X509_V_ERR_EC_KEY_EXPLICIT_PARAMS =  94;
  X509_V_ERR_PATHLEN_INVALID_FOR_NON_CA = 80;
  X509_V_ERR_PATHLEN_WITHOUT_KU_KEY_CERT_SIGN   =  81;
  X509_V_ERR_CA_BCONS_NOT_CRITICAL              =  89;
  X509_V_ERR_CA_CERT_MISSING_KEY_USAGE          =  92;
  X509_V_ERR_KU_KEY_CERT_SIGN_INVALID_FOR_NON_CA  = 82;
  X509_V_ERR_ISSUER_NAME_EMPTY                    = 83;
  X509_V_ERR_SUBJECT_NAME_EMPTY                   = 84;
  X509_V_ERR_EMPTY_SUBJECT_SAN_NOT_CRITICAL       = 88;
  X509_V_ERR_EMPTY_SUBJECT_ALT_NAME               = 87;
  X509_V_ERR_SIGNATURE_ALGORITHM_INCONSISTENCY    = 78;
  X509_V_ERR_AUTHORITY_KEY_IDENTIFIER_CRITICAL    = 90;
  X509_V_ERR_SUBJECT_KEY_IDENTIFIER_CRITICAL      = 91;
  X509_V_ERR_MISSING_AUTHORITY_KEY_IDENTIFIER     = 85;
  X509_V_ERR_MISSING_SUBJECT_KEY_IDENTIFIER       = 86;
  X509_V_ERR_EXTENSIONS_REQUIRE_VERSION_3         = 93;
  X509_V_ERR_SIGNATURE_ALGORITHM_MISMATCH = 77;
  X509_R_INVALID_DISTPOINT =                        143;
  EXFLAG_BCONS_CRITICAL  = $10000;
  EXFLAG_AKID_CRITICAL   = $20000;
  EXFLAG_SKID_CRITICAL   = $40000;
  EXFLAG_SAN_CRITICAL    = $80000;
  EXFLAG_NO_FINGERPRINT  = $100000 ;
  X509_R_UNKNOWN_SIGID_ALGS = 144;
  X509_R_ERROR_USING_SIGINF_SET   =                 142;
  X509_R_ERROR_GETTING_MD_BY_NID  =                 141;
  OSSL_PROPERTY_TRUE   =   1;
  OSSL_PROPERTY_FALSE  =   2;
  OSSL_MAX_NAME_SIZE   =   50;


  
  OSSL_BSEARCH_VALUE_ON_NOMATCH = $01;
  OSSL_BSEARCH_FIRST_VALUE_ON_MATCH  = $02;

  X509_V_ERR_NO_ISSUER_PUBLIC_KEY                 = 24;
  X509_V_ERR_UNSUPPORTED_SIGNATURE_ALGORITHM      = 76;
  //EXFLAG_NO_FINGERPRINT   = $100000;
  X509_VERSION_1 = 0;
  X509_VERSION_2 = 1;
  X509_VERSION_3 = 2;

  OSSL_LIB_CTX_MAX_RUN_ONCE        =          3;
  {$IF Defined(WIN32)}
  LIB_CRYPTO = 'libcrypto-1_1.dll';
  LIB_SSL = 'libssl-1_1.dll';
  _PU = '';
  {$ELSEIF Defined(WIN64)}
  LIB_CRYPTO = 'libcrypto-1_1-x64.dll';
  LIB_SSL = 'libssl-1_1-x64.dll';
  _PU = '';
  {$ELSEIF Defined(ANDROID64)}
  LIB_CRYPTO = 'libcrypto-android64.a';
  LIB_SSL = 'libssl-android64.a';
  _PU = '';
  {$ELSEIF Defined(ANDROID32)}
  LIB_CRYPTO = 'libcrypto-android32.a';
  LIB_SSL = 'libssl-android32.a';
  _PU = '';
  {$ELSEIF Defined(IOS)}
  LIB_CRYPTO = 'libcrypto-ios.a';
  LIB_SSL = 'libssl-ios.a';
  _PU = '';
  {$ELSEIF Defined(MACOS32)}
  LIB_CRYPTO = 'libssl-merged-osx32.dylib'; { We unify LibSsl and LibCrypto into a common shared library on macOS }
  LIB_SSL = 'libssl-merged-osx32.dylib';
  _PU = '_';
  {$ELSEIF Defined(MACOS64)}
  LIB_CRYPTO = 'libcrypto-osx64.a';
  LIB_SSL = 'libssl-osx64.a';
  _PU = '';
  {$ELSEIF Defined(LINUX)}
  LIB_CRYPTO = 'libcrypto.so';
  LIB_SSL = 'libssl.so';
  _PU = '';
  {$ELSE}
    {$MESSAGE Error 'Unsupported platform'}
  {$IFEND}
const
  OPENSSL_VER_1100 = $1010000f; // 1.1.0
  OPENSSL_VER_1101 = $10101000; // 1.1.1
  OPENSSL_VERSION_NUMBER = $1010107f;
  OPENSSL_VERSION_TEXT = 'OpenSSL 1.1.1g  21 Apr 2020';
  SHLIB_VERSION_HISTORY = '';
  SHLIB_VERSION_NUMBER = '1.1';
  OPENSSL_SYS_WIN32 = 1;
  OPENSSL_MIN_API = 0;
  OPENSSL_API_COMPAT = OPENSSL_MIN_API;
  _AES_ENCRYPT = 1;
  _AES_DECRYPT = 0;
  AES_MAXNR = 14;
  AES_BLOCK_SIZE = 16;
  _I64_MAX = 9223372036854775807;
  OSSL_SSIZE_MAX = _I64_MAX;
  CRYPTO_F_CMAC_CTX_NEW = 120;
  CRYPTO_F_CRYPTO_DUP_EX_DATA = 110;
  CRYPTO_F_CRYPTO_FREE_EX_DATA = 111;
  CRYPTO_F_CRYPTO_GET_EX_NEW_INDEX = 100;
  CRYPTO_F_CRYPTO_MEMDUP = 115;
  CRYPTO_F_CRYPTO_NEW_EX_DATA = 112;
  CRYPTO_F_CRYPTO_OCB128_COPY_CTX = 121;
  CRYPTO_F_CRYPTO_OCB128_INIT = 122;
  CRYPTO_F_CRYPTO_SET_EX_DATA = 102;
  CRYPTO_F_FIPS_MODE_SET = 109;
  CRYPTO_F_GET_AND_LOCK = 113;
  CRYPTO_F_OPENSSL_ATEXIT = 114;
  CRYPTO_F_OPENSSL_BUF2HEXSTR = 117;
  CRYPTO_F_OPENSSL_FOPEN = 119;
  CRYPTO_F_OPENSSL_HEXSTR2BUF = 118;
  CRYPTO_F_OPENSSL_INIT_CRYPTO = 116;
  CRYPTO_F_OPENSSL_LH_NEW = 126;
  CRYPTO_F_OPENSSL_SK_DEEP_COPY = 127;
  CRYPTO_F_OPENSSL_SK_DUP = 128;
  CRYPTO_F_PKEY_HMAC_INIT = 123;
  CRYPTO_F_PKEY_POLY1305_INIT = 124;
  CRYPTO_F_PKEY_SIPHASH_INIT = 125;
  CRYPTO_F_SK_RESERVE = 129;
  CRYPTO_R_FIPS_MODE_NOT_SUPPORTED = 101;
 
  SSLEAY_VERSION_NUMBER = OPENSSL_VERSION_NUMBER;
  //OPENSSL_VERSION = 0;
  OPENSSL_CFLAGS = 1;
  SSLEAY_CFLAGS = OPENSSL_CFLAGS;
  OPENSSL_BUILT_ON = 2;
  SSLEAY_BUILT_ON = OPENSSL_BUILT_ON;
  OPENSSL_PLATFORM = 3;
  SSLEAY_PLATFORM = OPENSSL_PLATFORM;
  OPENSSL_DIR = 4;
  SSLEAY_DIR = OPENSSL_DIR;
  CRYPTO_MEM_CHECK_OFF = $0;
  CRYPTO_MEM_CHECK_ON = $1;
  CRYPTO_MEM_CHECK_ENABLE = $2;
  CRYPTO_MEM_CHECK_DISABLE = $3;

  CRYPTO_EX_INDEX_SSL = 0;
  CRYPTO_EX_INDEX_SSL_CTX = 1;
  CRYPTO_EX_INDEX_SSL_SESSION = 2;
  CRYPTO_EX_INDEX_X509 = 3;
  CRYPTO_EX_INDEX_X509_STORE = 4;
  CRYPTO_EX_INDEX_X509_STORE_CTX = 5;
  CRYPTO_EX_INDEX_DH = 6;
  CRYPTO_EX_INDEX_DSA = 7;
  CRYPTO_EX_INDEX_EC_KEY = 8;
  CRYPTO_EX_INDEX_RSA = 9;
  CRYPTO_EX_INDEX_ENGINE = 10;
  CRYPTO_EX_INDEX_UI = 11;
  CRYPTO_EX_INDEX_BIO = 12;
  CRYPTO_EX_INDEX_APP = 13;
  CRYPTO_EX_INDEX_UI_METHOD = 14;
  CRYPTO_EX_INDEX_RAND_DRBG = 15;
  CRYPTO_EX_INDEX_DRBG = CRYPTO_EX_INDEX_RAND_DRBG;
  CRYPTO_EX_INDEX_OSSL_LIB_CTX = 16;
  CRYPTO_EX_INDEX_EVP_PKEY = 17;
  CRYPTO_EX_INDEX__COUNT = 18;

  OPENSSL_ENGINES_DIR = 5;
  CRYPTO_LOCK = 1;
  CRYPTO_UNLOCK = 2;
  CRYPTO_READ = 4;
  CRYPTO_WRITE = 8;
  OPENSSL_INIT_NO_LOAD_CRYPTO_STRINGS = $00000001;
  OPENSSL_INIT_LOAD_CRYPTO_STRINGS = $00000002;
  OPENSSL_INIT_ADD_ALL_CIPHERS = $00000004;
  OPENSSL_INIT_ADD_ALL_DIGESTS = $00000008;
  OPENSSL_INIT_NO_ADD_ALL_CIPHERS = $00000010;
  OPENSSL_INIT_NO_ADD_ALL_DIGESTS = $00000020;
  OPENSSL_INIT_LOAD_CONFIG = $00000040;
  OPENSSL_INIT_NO_LOAD_CONFIG = $00000080;
  OPENSSL_INIT_ASYNC = $00000100;
  OPENSSL_INIT_ENGINE_RDRAND = $00000200;
  OPENSSL_INIT_ENGINE_DYNAMIC = $00000400;
  OPENSSL_INIT_ENGINE_OPENSSL = $00000800;
  OPENSSL_INIT_ENGINE_CRYPTODEV = $00001000;
  OPENSSL_INIT_ENGINE_CAPI = $00002000;
  OPENSSL_INIT_ENGINE_PADLOCK = $00004000;
  OPENSSL_INIT_ENGINE_AFALG = $00008000;
  OPENSSL_INIT_ATFORK = $00020000;
  OPENSSL_INIT_NO_ATEXIT = $00080000;
  OPENSSL_INIT_ENGINE_ALL_BUILTIN = (OPENSSL_INIT_ENGINE_RDRAND or OPENSSL_INIT_ENGINE_DYNAMIC or OPENSSL_INIT_ENGINE_CRYPTODEV or OPENSSL_INIT_ENGINE_CAPI or OPENSSL_INIT_ENGINE_PADLOCK);
  CRYPTO_ONCE_STATIC_INIT = 0;
  BIO_F_ACPT_STATE = 100;
  BIO_F_ADDRINFO_WRAP = 148;
  BIO_F_ADDR_STRINGS = 134;
  BIO_F_BIO_ACCEPT = 101;
  BIO_F_BIO_ACCEPT_EX = 137;
  BIO_F_BIO_ACCEPT_NEW = 152;
  BIO_F_BIO_ADDR_NEW = 144;
  BIO_F_BIO_BIND = 147;
  BIO_F_BIO_CALLBACK_CTRL = 131;
  BIO_F_BIO_CONNECT = 138;
  BIO_F_BIO_CONNECT_NEW = 153;
  BIO_F_BIO_CTRL = 103;
  BIO_F_BIO_GETS = 104;
  BIO_F_BIO_GET_HOST_IP = 106;
  BIO_F_BIO_GET_NEW_INDEX = 102;
  BIO_F_BIO_GET_PORT = 107;
  BIO_F_BIO_LISTEN = 139;
  BIO_F_BIO_LOOKUP = 135;
  BIO_F_BIO_LOOKUP_EX = 143;
  BIO_F_BIO_MAKE_PAIR = 121;
  BIO_F_BIO_METH_NEW = 146;
  BIO_F_BIO_NEW = 108;
  BIO_F_BIO_NEW_DGRAM_SCTP = 145;
  BIO_F_BIO_NEW_FILE = 109;
  BIO_F_BIO_NEW_MEM_BUF = 126;
  BIO_F_BIO_NREAD = 123;
  BIO_F_BIO_NREAD0 = 124;
  BIO_F_BIO_NWRITE = 125;
  BIO_F_BIO_NWRITE0 = 122;
  BIO_F_BIO_PARSE_HOSTSERV = 136;
  BIO_F_BIO_PUTS = 110;
  BIO_F_BIO_READ = 111;
  BIO_F_BIO_READ_EX = 105;
  BIO_F_BIO_READ_INTERN = 120;
  BIO_F_BIO_SOCKET = 140;
  BIO_F_BIO_SOCKET_NBIO = 142;
  BIO_F_BIO_SOCK_INFO = 141;
  BIO_F_BIO_SOCK_INIT = 112;
  BIO_F_BIO_WRITE = 113;
  BIO_F_BIO_WRITE_EX = 119;
  BIO_F_BIO_WRITE_INTERN = 128;
  BIO_F_BUFFER_CTRL = 114;
  BIO_F_CONN_CTRL = 127;
  BIO_F_CONN_STATE = 115;
  BIO_F_DGRAM_SCTP_NEW = 149;
  BIO_F_DGRAM_SCTP_READ = 132;
  BIO_F_DGRAM_SCTP_WRITE = 133;
  BIO_F_DOAPR_OUTCH = 150;
  BIO_F_FILE_CTRL = 116;
  BIO_F_FILE_READ = 130;
  BIO_F_LINEBUFFER_CTRL = 129;
  BIO_F_LINEBUFFER_NEW = 151;
  BIO_F_MEM_WRITE = 117;
  BIO_F_NBIOF_NEW = 154;
  BIO_F_SLG_WRITE = 155;
  BIO_F_SSL_NEW = 118;
  BIO_R_ACCEPT_ERROR = 100;
  BIO_R_ADDRINFO_ADDR_IS_NOT_AF_INET = 141;
  BIO_R_AMBIGUOUS_HOST_OR_SERVICE = 129;
  BIO_R_BAD_FOPEN_MODE = 101;
  BIO_R_BROKEN_PIPE = 124;
  BIO_R_CONNECT_ERROR = 103;
  BIO_R_GETHOSTBYNAME_ADDR_IS_NOT_AF_INET = 107;
  BIO_R_GETSOCKNAME_ERROR = 132;
  BIO_R_GETSOCKNAME_TRUNCATED_ADDRESS = 133;
  BIO_R_GETTING_SOCKTYPE = 134;
  BIO_R_INVALID_ARGUMENT = 125;
  BIO_R_INVALID_SOCKET = 135;
  BIO_R_IN_USE = 123;
  BIO_R_LENGTH_TOO_LONG = 102;
  BIO_R_LISTEN_V6_ONLY = 136;
  BIO_R_LOOKUP_RETURNED_NOTHING = 142;
  BIO_R_MALFORMED_HOST_OR_SERVICE = 130;
  BIO_R_NBIO_CONNECT_ERROR = 110;
  BIO_R_NO_ACCEPT_ADDR_OR_SERVICE_SPECIFIED = 143;
  BIO_R_NO_HOSTNAME_OR_SERVICE_SPECIFIED = 144;
  BIO_R_CONNECT_TIMEOUT                  = 147;
  BIO_R_TRANSFER_ERROR                   = 104;
  BIO_R_TRANSFER_TIMEOUT                 = 105;
  BIO_R_NO_PORT_DEFINED = 113;
  BIO_R_NO_SUCH_FILE = 128;
  BIO_R_NULL_PARAMETER = 115;
  BIO_R_UNABLE_TO_BIND_SOCKET = 117;
  BIO_R_UNABLE_TO_CREATE_SOCKET = 118;
  BIO_R_UNABLE_TO_KEEPALIVE = 137;
  BIO_R_UNABLE_TO_LISTEN_SOCKET = 119;
  BIO_R_UNABLE_TO_NODELAY = 138;
  BIO_R_UNABLE_TO_REUSEADDR = 139;
  BIO_R_UNAVAILABLE_IP_FAMILY = 145;
  BIO_R_UNINITIALIZED = 120;
  BIO_R_UNKNOWN_INFO_TYPE = 140;
  BIO_R_UNSUPPORTED_IP_FAMILY = 146;
  BIO_R_UNSUPPORTED_METHOD = 121;
  BIO_R_UNSUPPORTED_PROTOCOL_FAMILY = 131;
  BIO_R_WRITE_TO_READ_ONLY_BIO = 126;
  BIO_R_WSASTARTUP = 122;
  
  BIO_NOCLOSE = $00;
  BIO_CLOSE = $01;
  BIO_CTRL_RESET = 1;
  BIO_CTRL_EOF = 2;
  BIO_CTRL_INFO = 3;
  BIO_CTRL_SET = 4;
  BIO_CTRL_GET = 5;
  BIO_CTRL_PUSH = 6;
  BIO_CTRL_POP = 7;
  BIO_CTRL_GET_CLOSE = 8;
  BIO_CTRL_SET_CLOSE = 9;
  _BIO_CTRL_PENDING = 10;
  BIO_CTRL_FLUSH = 11;
  BIO_CTRL_DUP = 12;
  _BIO_CTRL_WPENDING = 13;
  BIO_CTRL_SET_CALLBACK = 14;
  BIO_CTRL_GET_CALLBACK = 15;
  BIO_CTRL_PEEK = 29;
  BIO_CTRL_SET_FILENAME = 30;
  BIO_CTRL_DGRAM_CONNECT = 31;
  BIO_CTRL_DGRAM_SET_CONNECTED = 32;
  BIO_CTRL_DGRAM_SET_RECV_TIMEOUT = 33;
  BIO_CTRL_DGRAM_GET_RECV_TIMEOUT = 34;
  BIO_CTRL_DGRAM_SET_SEND_TIMEOUT = 35;
  BIO_CTRL_DGRAM_GET_SEND_TIMEOUT = 36;
  BIO_CTRL_DGRAM_GET_RECV_TIMER_EXP = 37;
  BIO_CTRL_DGRAM_GET_SEND_TIMER_EXP = 38;
  BIO_CTRL_DGRAM_MTU_DISCOVER = 39;
  BIO_CTRL_DGRAM_QUERY_MTU = 40;
  BIO_CTRL_DGRAM_GET_FALLBACK_MTU = 47;
  BIO_CTRL_DGRAM_GET_MTU = 41;
  BIO_CTRL_DGRAM_SET_MTU = 42;
  BIO_CTRL_DGRAM_MTU_EXCEEDED = 43;
  BIO_CTRL_DGRAM_GET_PEER = 46;
  BIO_CTRL_DGRAM_SET_PEER = 44;
  BIO_CTRL_DGRAM_SET_NEXT_TIMEOUT = 45;
  BIO_CTRL_DGRAM_SET_DONT_FRAG = 48;
  BIO_CTRL_DGRAM_GET_MTU_OVERHEAD = 49;
  BIO_CTRL_DGRAM_SCTP_SET_IN_HANDSHAKE = 50;
  BIO_CTRL_DGRAM_SET_PEEK_MODE = 71;
  BIO_FP_READ = $02;
  BIO_FP_WRITE = $04;
  BIO_FP_APPEND = $08;
  BIO_FP_TEXT = $10;
  BIO_FLAGS_READ = $01;
  BIO_FLAGS_WRITE = $02;
  BIO_FLAGS_IO_SPECIAL = $04;
  BIO_FLAGS_RWS = (BIO_FLAGS_READ or BIO_FLAGS_WRITE or BIO_FLAGS_IO_SPECIAL);
  BIO_FLAGS_SHOULD_RETRY = $08;
  BIO_FLAGS_UPLINK = 0;
  BIO_FLAGS_BASE64_NO_NL = $100;
  BIO_FLAGS_MEM_RDONLY = $200;
  BIO_FLAGS_NONCLEAR_RST = $400;
  BIO_FLAGS_IN_EOF = $800;
  BIO_RR_SSL_X509_LOOKUP = $01;
  BIO_RR_CONNECT = $02;
  BIO_RR_ACCEPT = $03;
  BIO_CB_FREE = $01;
  BIO_CB_READ = $02;
  BIO_CB_WRITE = $03;
  BIO_CB_PUTS = $04;
  BIO_CB_GETS = $05;
  BIO_CB_CTRL = $06;
  BIO_CB_RETURN = $80;
  BIO_C_SET_CONNECT = 100;
  BIO_C_DO_STATE_MACHINE = 101;
  BIO_C_SET_NBIO = 102;
  BIO_C_SET_FD = 104;
  BIO_C_GET_FD = 105;
  BIO_C_SET_FILE_PTR = 106;
  BIO_C_GET_FILE_PTR = 107;
  BIO_C_SET_FILENAME = 108;
  BIO_C_SET_SSL = 109;
  BIO_C_GET_SSL = 110;
  BIO_C_SET_MD = 111;
  BIO_C_GET_MD = 112;
  BIO_C_GET_CIPHER_STATUS = 113;
  BIO_C_SET_BUF_MEM = 114;
  BIO_C_GET_BUF_MEM_PTR = 115;
  BIO_C_GET_BUFF_NUM_LINES = 116;
  BIO_C_SET_BUFF_SIZE = 117;
  BIO_C_SET_ACCEPT = 118;
  BIO_C_SSL_MODE = 119;
  BIO_C_GET_MD_CTX = 120;
  BIO_C_SET_BUFF_READ_DATA = 122;
  BIO_C_GET_CONNECT = 123;
  BIO_C_GET_ACCEPT = 124;
  BIO_C_SET_SSL_RENEGOTIATE_BYTES = 125;
  BIO_C_GET_SSL_NUM_RENEGOTIATES = 126;
  BIO_C_SET_SSL_RENEGOTIATE_TIMEOUT = 127;
  BIO_C_FILE_SEEK = 128;
  BIO_C_GET_CIPHER_CTX = 129;
  BIO_C_SET_BUF_MEM_EOF_RETURN = 130;
  BIO_C_SET_BIND_MODE = 131;
  BIO_C_GET_BIND_MODE = 132;
  BIO_C_FILE_TELL = 133;
  BIO_C_GET_SOCKS = 134;
  BIO_C_SET_SOCKS = 135;
  BIO_C_SET_WRITE_BUF_SIZE = 136;
  BIO_C_GET_WRITE_BUF_SIZE = 137;
  BIO_C_MAKE_BIO_PAIR = 138;
  BIO_C_DESTROY_BIO_PAIR = 139;
  BIO_C_GET_WRITE_GUARANTEE = 140;
  BIO_C_GET_READ_REQUEST = 141;
  BIO_C_SHUTDOWN_WR = 142;
  BIO_C_NREAD0 = 143;
  BIO_C_NREAD = 144;
  BIO_C_NWRITE0 = 145;
  BIO_C_NWRITE = 146;
  BIO_C_RESET_READ_REQUEST = 147;
  BIO_C_SET_MD_CTX = 148;
  BIO_C_SET_PREFIX = 149;
  BIO_C_GET_PREFIX = 150;
  BIO_C_SET_SUFFIX = 151;
  BIO_C_GET_SUFFIX = 152;
  BIO_C_SET_EX_ARG = 153;
  BIO_C_GET_EX_ARG = 154;
  BIO_C_SET_CONNECT_MODE = 155;
  BIO_FAMILY_IPV4 = 4;
  BIO_FAMILY_IPV6 = 6;
  BIO_FAMILY_IPANY = 256;
  BIO_BIND_NORMAL = 0;
  BIO_SOCK_REUSEADDR = $01;
  BIO_BIND_REUSEADDR = BIO_SOCK_REUSEADDR;
  BIO_BIND_REUSEADDR_IF_UNUSED = BIO_SOCK_REUSEADDR;
  BIO_SOCK_V6_ONLY = $02;
  BIO_SOCK_KEEPALIVE = $04;
  BIO_SOCK_NONBLOCK = $08;
  BIO_SOCK_NODELAY = $10;
  ASN1_F_A2D_ASN1_OBJECT = 100;
  ASN1_F_A2I_ASN1_INTEGER = 102;
  ASN1_F_A2I_ASN1_STRING = 103;
  ASN1_F_APPEND_EXP = 176;
  ASN1_F_ASN1_BIO_INIT = 113;
  ASN1_F_ASN1_BIT_STRING_SET_BIT = 183;
  ASN1_F_ASN1_CB = 177;
  ASN1_F_ASN1_CHECK_TLEN = 104;
  ASN1_F_ASN1_COLLECT = 106;
  ASN1_F_ASN1_D2I_EX_PRIMITIVE = 108;
  ASN1_F_ASN1_D2I_FP = 109;
  ASN1_F_ASN1_D2I_READ_BIO = 107;
  ASN1_F_ASN1_DIGEST = 184;
  ASN1_F_ASN1_DO_ADB = 110;
  ASN1_F_ASN1_DO_LOCK = 233;
  ASN1_F_ASN1_DUP = 111;
  ASN1_F_ASN1_ENC_SAVE = 115;
  ASN1_F_ASN1_EX_C2I = 204;
  ASN1_F_ASN1_FIND_END = 190;
  ASN1_F_ASN1_GENERALIZEDTIME_ADJ = 216;
  ASN1_F_ASN1_GENERATE_V3 = 178;
  ASN1_F_ASN1_GET_INT64 = 224;
  ASN1_F_ASN1_GET_OBJECT = 114;
  ASN1_F_ASN1_GET_UINT64 = 225;
  ASN1_F_ASN1_I2D_BIO = 116;
  ASN1_F_ASN1_I2D_FP = 117;
  ASN1_F_ASN1_ITEM_D2I_FP = 206;
  ASN1_F_ASN1_ITEM_DUP = 191;
  ASN1_F_ASN1_ITEM_EMBED_D2I = 120;
  ASN1_F_ASN1_ITEM_EMBED_NEW = 121;
  ASN1_F_ASN1_ITEM_FLAGS_I2D = 118;
  ASN1_F_ASN1_ITEM_I2D_BIO = 192;
  ASN1_F_ASN1_ITEM_I2D_FP = 193;
  ASN1_F_ASN1_ITEM_PACK = 198;
  ASN1_F_ASN1_ITEM_SIGN = 195;
  ASN1_F_ASN1_ITEM_SIGN_CTX = 220;
  ASN1_F_ASN1_ITEM_UNPACK = 199;
  ASN1_F_ASN1_ITEM_VERIFY = 197;
  ASN1_F_ASN1_MBSTRING_NCOPY = 122;
  ASN1_F_ASN1_OBJECT_NEW = 123;
  ASN1_F_ASN1_OUTPUT_DATA = 214;
  ASN1_F_ASN1_PCTX_NEW = 205;
  ASN1_F_ASN1_PRIMITIVE_NEW = 119;
  ASN1_F_ASN1_SCTX_NEW = 221;
  ASN1_F_ASN1_SIGN = 128;
  ASN1_F_ASN1_STR2TYPE = 179;
  ASN1_F_ASN1_STRING_GET_INT64 = 227;
  ASN1_F_ASN1_STRING_GET_UINT64 = 230;
  ASN1_F_ASN1_STRING_SET = 186;
  ASN1_F_ASN1_STRING_TABLE_ADD = 129;
  ASN1_F_ASN1_STRING_TO_BN = 228;
  ASN1_F_ASN1_STRING_TYPE_NEW = 130;
  ASN1_F_ASN1_TEMPLATE_EX_D2I = 132;
  ASN1_F_ASN1_TEMPLATE_NEW = 133;
  ASN1_F_ASN1_TEMPLATE_NOEXP_D2I = 131;
  ASN1_F_ASN1_TIME_ADJ = 217;
  ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING = 134;
  ASN1_F_ASN1_TYPE_GET_OCTETSTRING = 135;
  ASN1_F_ASN1_UTCTIME_ADJ = 218;
  ASN1_F_ASN1_VERIFY = 137;
  ASN1_F_B64_READ_ASN1 = 209;
  ASN1_F_B64_WRITE_ASN1 = 210;
  ASN1_F_BIO_NEW_NDEF = 208;
  ASN1_F_BITSTR_CB = 180;
  ASN1_F_BN_TO_ASN1_STRING = 229;
  ASN1_F_C2I_ASN1_BIT_STRING = 189;
  ASN1_F_C2I_ASN1_INTEGER = 194;
  ASN1_F_C2I_ASN1_OBJECT = 196;
  ASN1_F_C2I_IBUF = 226;
  ASN1_F_C2I_UINT64_INT = 101;
  ASN1_F_COLLECT_DATA = 140;
  ASN1_F_D2I_ASN1_OBJECT = 147;
  ASN1_F_D2I_ASN1_UINTEGER = 150;
  ASN1_F_D2I_AUTOPRIVATEKEY = 207;
  ASN1_F_D2I_PRIVATEKEY = 154;
  ASN1_F_D2I_PUBLICKEY = 155;
  ASN1_F_DO_BUF = 142;
  ASN1_F_DO_CREATE = 124;
  ASN1_F_DO_DUMP = 125;
  ASN1_F_DO_TCREATE = 222;
  ASN1_F_I2A_ASN1_OBJECT = 126;
  ASN1_F_I2D_ASN1_BIO_STREAM = 211;
  ASN1_F_I2D_ASN1_OBJECT = 143;
  ASN1_F_I2D_DSA_PUBKEY = 161;
  ASN1_F_I2D_EC_PUBKEY = 181;
  ASN1_F_I2D_PRIVATEKEY = 163;
  ASN1_F_I2D_PUBLICKEY = 164;
  ASN1_F_I2D_RSA_PUBKEY = 165;
  ASN1_F_LONG_C2I = 166;
  ASN1_F_NDEF_PREFIX = 127;
  ASN1_F_NDEF_SUFFIX = 136;
  ASN1_F_OID_MODULE_INIT = 174;
  ASN1_F_PARSE_TAGGING = 182;
  ASN1_F_PKCS5_PBE2_SET_IV = 167;
  ASN1_F_PKCS5_PBE2_SET_SCRYPT = 231;
  ASN1_F_PKCS5_PBE_SET = 202;
  ASN1_F_PKCS5_PBE_SET0_ALGOR = 215;
  ASN1_F_PKCS5_PBKDF2_SET = 219;
  ASN1_F_PKCS5_SCRYPT_SET = 232;
  ASN1_F_SMIME_READ_ASN1 = 212;
  ASN1_F_SMIME_TEXT = 213;
  ASN1_F_STABLE_GET = 138;
  ASN1_F_STBL_MODULE_INIT = 223;
  ASN1_F_UINT32_C2I = 105;
  ASN1_F_UINT32_NEW = 139;
  ASN1_F_UINT64_C2I = 112;
  ASN1_F_UINT64_NEW = 141;
  ASN1_F_X509_CRL_ADD0_REVOKED = 169;
  ASN1_F_X509_INFO_NEW = 170;
  ASN1_F_X509_NAME_ENCODE = 203;
  ASN1_F_X509_NAME_EX_D2I = 158;
  ASN1_F_X509_NAME_EX_NEW = 171;
  ASN1_F_X509_PKEY_NEW = 173;

  
  BN_F_BNRAND = 127;
  BN_F_BNRAND_RANGE = 138;
  BN_F_BN_BLINDING_CONVERT_EX = 100;
  BN_F_BN_BLINDING_CREATE_PARAM = 128;
  BN_F_BN_BLINDING_INVERT_EX = 101;
  BN_F_BN_BLINDING_NEW = 102;
  BN_F_BN_BLINDING_UPDATE = 103;
  BN_F_BN_BN2DEC = 104;
  BN_F_BN_BN2HEX = 105;
  BN_F_BN_COMPUTE_WNAF = 142;
  BN_F_BN_CTX_GET = 116;
  BN_F_BN_CTX_NEW = 106;
  BN_F_BN_CTX_START = 129;
  BN_F_BN_DIV = 107;
  BN_F_BN_DIV_RECP = 130;
  BN_F_BN_EXP = 123;
  BN_F_BN_EXPAND_INTERNAL = 120;
  BN_F_BN_GENCB_NEW = 143;
  BN_F_BN_GENERATE_DSA_NONCE = 140;
  BN_F_BN_GENERATE_PRIME_EX = 141;
  BN_F_BN_GF2M_MOD = 131;
  BN_F_BN_GF2M_MOD_EXP = 132;
  BN_F_BN_GF2M_MOD_MUL = 133;
  BN_F_BN_GF2M_MOD_SOLVE_QUAD = 134;
  BN_F_BN_GF2M_MOD_SOLVE_QUAD_ARR = 135;
  BN_F_BN_GF2M_MOD_SQR = 136;
  BN_F_BN_GF2M_MOD_SQRT = 137;
  BN_F_BN_LSHIFT = 145;
  BN_F_BN_MOD_EXP2_MONT = 118;
  BN_F_BN_MOD_EXP_MONT = 109;
  BN_F_BN_MOD_EXP_MONT_CONSTTIME = 124;
  BN_F_BN_MOD_EXP_MONT_WORD = 117;
  BN_F_BN_MOD_EXP_RECP = 125;
  BN_F_BN_MOD_EXP_SIMPLE = 126;
  BN_F_BN_MOD_INVERSE = 110;
  BN_F_BN_MOD_INVERSE_NO_BRANCH = 139;
  BN_F_BN_MOD_LSHIFT_QUICK = 119;
  BN_F_BN_MOD_SQRT = 121;
  BN_F_BN_MONT_CTX_NEW = 149;
  BN_F_BN_MPI2BN = 112;
  BN_F_BN_NEW = 113;
  BN_F_BN_POOL_GET = 147;
  BN_F_BN_RAND = 114;
  BN_F_BN_RAND_RANGE = 122;
  BN_F_BN_RECP_CTX_NEW = 150;
  BN_F_BN_RSHIFT = 146;
  BN_F_BN_SET_WORDS = 144;
  BN_F_BN_STACK_PUSH = 148;
  BN_F_BN_USUB = 115;
  BN_R_ARG2_LT_ARG3 = 100;
  BN_R_BAD_RECIPROCAL = 101;
  BN_R_BIGNUM_TOO_LONG = 114;
  BN_R_BITS_TOO_SMALL = 118;
  BN_R_CALLED_WITH_EVEN_MODULUS = 102;
  BN_R_DIV_BY_ZERO = 103;
  BN_R_ENCODING_ERROR = 104;
  BN_R_EXPAND_ON_STATIC_BIGNUM_DATA = 105;
  BN_R_INPUT_NOT_REDUCED = 110;
  BN_R_INVALID_LENGTH = 106;
  BN_R_INVALID_RANGE = 115;
  BN_R_INVALID_SHIFT = 119;
  BN_R_NOT_A_SQUARE = 111;
  BN_R_NOT_INITIALIZED = 107;
  BN_R_NO_INVERSE = 108;
  BN_R_NO_SOLUTION = 116;
  BN_R_PRIVATE_KEY_TOO_LARGE = 117;
  BN_R_P_IS_NOT_PRIME = 112;
  BN_R_TOO_MANY_ITERATIONS = 113;
  BN_R_NO_SUITABLE_DIGEST  = 120;
  BN_R_TOO_MANY_TEMPORARY_VARIABLES = 109;
  BN_FLG_MALLOCED = $01;
  BN_FLG_STATIC_DATA = $02;
  BN_FLG_CONSTTIME = $04;
  BN_FLG_SECURE = $08;
  BN_FLG_EXP_CONSTTIME = BN_FLG_CONSTTIME;
  BN_FLG_FREE = $8000;
  BN_RAND_TOP_ANY = -1;
  BN_RAND_TOP_ONE = 0;
  BN_RAND_TOP_TWO = 1;
  BN_RAND_BOTTOM_ANY = 0;
  BN_RAND_BOTTOM_ODD = 1;
  BN_prime_checks = 0;
  BN_BLINDING_NO_UPDATE = $00000001;
  BN_BLINDING_NO_RECREATE = $00000002;
  V_ASN1_UNIVERSAL = $00;
  V_ASN1_APPLICATION = $40;
  V_ASN1_CONTEXT_SPECIFIC = $80;
  V_ASN1_PRIVATE = $c0;
  V_ASN1_CONSTRUCTED = $20;
  V_ASN1_PRIMITIVE_TAG = $1f;
  V_ASN1_PRIMATIVE_TAG = V_ASN1_PRIMITIVE_TAG; // *compat*
  V_ASN1_APP_CHOOSE = -2;
  V_ASN1_OTHER = -3;
  V_ASN1_ANY = -4;
  V_ASN1_UNDEF = -1;
  V_ASN1_EOC = 0;
  V_ASN1_BOOLEAN = 1;
  V_ASN1_INTEGER = 2;
  V_ASN1_BIT_STRING = 3;
  V_ASN1_OCTET_STRING = 4;
  V_ASN1_NULL = 5;
  V_ASN1_OBJECT = 6;
  V_ASN1_OBJECT_DESCRIPTOR = 7;
  V_ASN1_EXTERNAL = 8;
  V_ASN1_REAL = 9;
  V_ASN1_ENUMERATED = 10;
  V_ASN1_UTF8STRING = 12;
  V_ASN1_SEQUENCE = 16;
  V_ASN1_SET = 17;
  V_ASN1_NUMERICSTRING = 18;
  V_ASN1_PRINTABLESTRING = 19;
  V_ASN1_T61STRING = 20;
  V_ASN1_TELETEXSTRING = 20;
  V_ASN1_VIDEOTEXSTRING = 21;
  V_ASN1_IA5STRING = 22;
  V_ASN1_UTCTIME = 23;
  V_ASN1_GENERALIZEDTIME = 24;
  V_ASN1_GRAPHICSTRING = 25;
  V_ASN1_ISO64STRING = 26;
  V_ASN1_VISIBLESTRING = 26;
  V_ASN1_GENERALSTRING = 27;
  V_ASN1_UNIVERSALSTRING = 28;
  V_ASN1_BMPSTRING = 30;
  V_ASN1_NEG = $100;
  V_ASN1_NEG_INTEGER = (2 or V_ASN1_NEG);
  V_ASN1_NEG_ENUMERATED = (10 or V_ASN1_NEG);
  B_ASN1_NUMERICSTRING = $0001;
  B_ASN1_PRINTABLESTRING = $0002;
  B_ASN1_T61STRING = $0004;
  B_ASN1_TELETEXSTRING = $0004;
  B_ASN1_VIDEOTEXSTRING = $0008;
  B_ASN1_IA5STRING = $0010;
  B_ASN1_GRAPHICSTRING = $0020;
  B_ASN1_ISO64STRING = $0040;
  B_ASN1_VISIBLESTRING = $0040;
  B_ASN1_GENERALSTRING = $0080;
  B_ASN1_UNIVERSALSTRING = $0100;
  B_ASN1_OCTET_STRING = $0200;
  B_ASN1_BIT_STRING = $0400;
  B_ASN1_BMPSTRING = $0800;
  B_ASN1_UNKNOWN = $1000;
  B_ASN1_UTF8STRING = $2000;
  B_ASN1_UTCTIME = $4000;
  B_ASN1_GENERALIZEDTIME = $8000;
  B_ASN1_SEQUENCE = $10000;
  MBSTRING_FLAG = $1000;
  MBSTRING_UTF8 = (MBSTRING_FLAG);
  MBSTRING_ASC = (MBSTRING_FLAG or 1);
  MBSTRING_BMP = (MBSTRING_FLAG or 2);
  MBSTRING_UNIV = (MBSTRING_FLAG or 4);
  SMIME_OLDMIME = $400;
  SMIME_CRLFEOL = $800;
  SMIME_STREAM = $1000;
  ASN1_STRING_FLAG_BITS_LEFT = $08;
  ASN1_STRING_FLAG_NDEF = $010;
  ASN1_STRING_FLAG_CONT = $020;
  ASN1_STRING_FLAG_MSTRING = $040;
  ASN1_STRING_FLAG_EMBED = $080;
  ASN1_STRING_FLAG_X509_TIME = $100;
  ASN1_LONG_UNDEF = $7fffffff;
  STABLE_FLAGS_MALLOC = $01;
  STABLE_FLAGS_CLEAR = STABLE_FLAGS_MALLOC;
  STABLE_NO_MASK = $02;
  DIRSTRING_TYPE = (B_ASN1_PRINTABLESTRING or B_ASN1_T61STRING or B_ASN1_BMPSTRING or B_ASN1_UTF8STRING);
  PKCS9STRING_TYPE = (DIRSTRING_TYPE or B_ASN1_IA5STRING);
  ASN1_STRFLGS_ESC_2253 = 1;
  ASN1_STRFLGS_ESC_CTRL = 2;
  ASN1_STRFLGS_ESC_MSB = 4;
  ASN1_STRFLGS_ESC_QUOTE = 8;
  CHARTYPE_PRINTABLESTRING = $10;
  CHARTYPE_FIRST_ESC_2253 = $20;
  CHARTYPE_LAST_ESC_2253 = $40;
  ASN1_STRFLGS_UTF8_CONVERT = $10;
  ASN1_STRFLGS_IGNORE_TYPE = $20;
  ASN1_STRFLGS_SHOW_TYPE = $40;
  ASN1_STRFLGS_DUMP_ALL = $80;
  ASN1_STRFLGS_DUMP_UNKNOWN = $100;
  ASN1_STRFLGS_DUMP_DER = $200;
  ASN1_STRFLGS_ESC_2254 = $400;
  ASN1_STRFLGS_RFC2253 = (ASN1_STRFLGS_ESC_2253 or ASN1_STRFLGS_ESC_CTRL or ASN1_STRFLGS_ESC_MSB or ASN1_STRFLGS_UTF8_CONVERT or ASN1_STRFLGS_DUMP_UNKNOWN or ASN1_STRFLGS_DUMP_DER);
  B_ASN1_TIME = B_ASN1_UTCTIME or B_ASN1_GENERALIZEDTIME;
  B_ASN1_PRINTABLE = B_ASN1_NUMERICSTRING or B_ASN1_PRINTABLESTRING or B_ASN1_T61STRING or B_ASN1_IA5STRING or B_ASN1_BIT_STRING or B_ASN1_UNIVERSALSTRING or B_ASN1_BMPSTRING or B_ASN1_UTF8STRING or B_ASN1_SEQUENCE or B_ASN1_UNKNOWN;
  B_ASN1_DIRECTORYSTRING = B_ASN1_PRINTABLESTRING or B_ASN1_TELETEXSTRING or B_ASN1_BMPSTRING or B_ASN1_UNIVERSALSTRING or B_ASN1_UTF8STRING;
  B_ASN1_DISPLAYTEXT = B_ASN1_IA5STRING or B_ASN1_VISIBLESTRING or B_ASN1_BMPSTRING or B_ASN1_UTF8STRING;
  ASN1_PCTX_FLAGS_SHOW_ABSENT = $001;
  ASN1_PCTX_FLAGS_SHOW_SEQUENCE = $002;
  ASN1_PCTX_FLAGS_SHOW_SSOF = $004;
  ASN1_PCTX_FLAGS_SHOW_TYPE = $008;
  ASN1_PCTX_FLAGS_NO_ANY_TYPE = $010;
  ASN1_PCTX_FLAGS_NO_MSTRING_TYPE = $020;
  ASN1_PCTX_FLAGS_NO_FIELD_NAME = $040;
  ASN1_PCTX_FLAGS_SHOW_FIELD_STRUCT_NAME = $080;
  ASN1_PCTX_FLAGS_NO_STRUCT_NAME = $100;
  ASN1_TFLG_OPTIONAL = ($1);
  ASN1_TFLG_SET_OF = ($1 shl 1);
  ASN1_TFLG_SEQUENCE_OF = ($2 shl 1);
  ASN1_TFLG_SET_ORDER = ($3 shl 1);
  ASN1_TFLG_SK_MASK = ($3 shl 1);
  ASN1_TFLG_IMPTAG = ($1 shl 3);
  ASN1_TFLG_EXPTAG = ($2 shl 3);
  ASN1_TFLG_TAG_MASK = ($3 shl 3);
  ASN1_TFLG_CONTEXT = ($2 shl 6);
  ASN1_TFLG_IMPLICIT = (ASN1_TFLG_IMPTAG or ASN1_TFLG_CONTEXT);
  ASN1_TFLG_EXPLICIT = (ASN1_TFLG_EXPTAG or ASN1_TFLG_CONTEXT);
  ASN1_TFLG_UNIVERSAL = ($0 shl 6);
  ASN1_TFLG_APPLICATION = ($1 shl 6);
  ASN1_TFLG_PRIVATE = ($3 shl 6);
  ASN1_TFLG_TAG_CLASS = ($3 shl 6);
  ASN1_TFLG_ADB_MASK = ($3 shl 8);
  ASN1_TFLG_ADB_OID = ($1 shl 8);
  ASN1_TFLG_ADB_INT = ($1 shl 9);
  ASN1_TFLG_NDEF = ($1 shl 11);
  ASN1_TFLG_EMBED = ($1 shl 12);
  ASN1_ITYPE_PRIMITIVE = $0;
  ASN1_ITYPE_SEQUENCE = $1;
  ASN1_ITYPE_CHOICE = $2;
  ASN1_ITYPE_EXTERN = $4;
  ASN1_ITYPE_MSTRING = $5;
  ASN1_ITYPE_NDEF_SEQUENCE = $6;
  
  ASN1_OP_NEW_PRE = 0;
  ASN1_OP_NEW_POST = 1;
  ASN1_OP_FREE_PRE = 2;
  ASN1_OP_FREE_POST = 3;
  ASN1_OP_D2I_PRE = 4;
  ASN1_OP_D2I_POST = 5;
  ASN1_OP_I2D_PRE = 6;
  ASN1_OP_I2D_POST = 7;
  ASN1_OP_PRINT_PRE = 8;
  ASN1_OP_PRINT_POST = 9;
  ASN1_OP_STREAM_PRE = 10;
  ASN1_OP_STREAM_POST = 11;
  ASN1_OP_DETACHED_PRE = 12;
  ASN1_OP_DETACHED_POST = 13;
  ASN1_OP_DUP_PRE = 14;
  ASN1_OP_DUP_POST = 15;
  ASN1_OP_GET0_LIBCTX = 16;
  ASN1_OP_GET0_PROPQ = 17;

  ASYNC_F_ASYNC_CTX_NEW = 100;
  ASYNC_F_ASYNC_INIT_THREAD = 101;
  ASYNC_F_ASYNC_JOB_NEW = 102;
  ASYNC_F_ASYNC_PAUSE_JOB = 103;
  ASYNC_F_ASYNC_START_FUNC = 104;
  ASYNC_F_ASYNC_START_JOB = 105;
  ASYNC_F_ASYNC_WAIT_CTX_SET_WAIT_FD = 106;
  ASYNC_R_FAILED_TO_SET_POOL = 101;
  ASYNC_R_FAILED_TO_SWAP_CONTEXT = 102;
  ASYNC_R_INIT_FAILED = 105;
  ASYNC_R_INVALID_POOL_SIZE = 103;
  ASYNC_ERR = 0;
  ASYNC_NO_JOBS = 1;
  ASYNC_PAUSE = 2;
  ASYNC_FINISH = 3;
  _BF_ENCRYPT = 1;
  _BF_DECRYPT = 0;
  BF_ROUNDS = 16;
  BF_BLOCK = 8;
  BUF_F_BUF_MEM_GROW = 100;
  BUF_F_BUF_MEM_GROW_CLEAN = 105;
  BUF_F_BUF_MEM_NEW = 101;
  BUF_MEM_FLAG_SECURE = $01;
  _CAMELLIA_ENCRYPT = 1;
  _CAMELLIA_DECRYPT = 0;
  CAMELLIA_BLOCK_SIZE = 16;
  
  _CAST_ENCRYPT = 1;
  _CAST_DECRYPT = 0;
  CAST_BLOCK = 8;
  CAST_KEY_LENGTH = 16;
  EVP_F_AESNI_INIT_KEY = 165;
  EVP_F_AESNI_XTS_INIT_KEY = 207;
  EVP_F_AES_GCM_CTRL = 196;
  EVP_F_AES_INIT_KEY = 133;
  EVP_F_AES_OCB_CIPHER = 169;
  EVP_F_AES_T4_INIT_KEY = 178;
  EVP_F_AES_T4_XTS_INIT_KEY = 208;
  EVP_F_AES_WRAP_CIPHER = 170;
  EVP_F_AES_XTS_INIT_KEY = 209;
  EVP_F_ALG_MODULE_INIT = 177;
  EVP_F_ARIA_CCM_INIT_KEY = 175;
  EVP_F_ARIA_GCM_CTRL = 197;
  EVP_F_ARIA_GCM_INIT_KEY = 176;
  EVP_F_ARIA_INIT_KEY = 185;
  EVP_F_B64_NEW = 198;
  EVP_F_CAMELLIA_INIT_KEY = 159;
  EVP_F_CHACHA20_POLY1305_CTRL = 182;
  EVP_F_CMLL_T4_INIT_KEY = 179;
  EVP_F_DES_EDE3_WRAP_CIPHER = 171;
  EVP_F_DO_SIGVER_INIT = 161;
  EVP_F_ENC_NEW = 199;
  EVP_F_EVP_CIPHERINIT_EX = 123;
  EVP_F_EVP_CIPHER_ASN1_TO_PARAM = 204;
  EVP_F_EVP_CIPHER_CTX_COPY = 163;
  EVP_F_EVP_CIPHER_CTX_CTRL = 124;
  EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH = 122;
  EVP_F_EVP_CIPHER_PARAM_TO_ASN1 = 205;
  EVP_F_EVP_DECRYPTFINAL_EX = 101;
  EVP_F_EVP_DECRYPTUPDATE = 166;
  EVP_F_EVP_DIGESTFINALXOF = 174;
  EVP_F_EVP_DIGESTINIT_EX = 128;
  EVP_F_EVP_ENCRYPTDECRYPTUPDATE = 219;
  EVP_F_EVP_ENCRYPTFINAL_EX = 127;
  EVP_F_EVP_ENCRYPTUPDATE = 167;
  EVP_F_EVP_MD_CTX_COPY_EX = 110;
  EVP_F_EVP_MD_SIZE = 162;
  EVP_F_EVP_OPENINIT = 102;
  EVP_F_EVP_PBE_ALG_ADD = 115;
  EVP_F_EVP_PBE_ALG_ADD_TYPE = 160;
  EVP_F_EVP_PBE_CIPHERINIT = 116;
  EVP_F_EVP_PBE_SCRYPT = 181;
  EVP_F_EVP_PKCS82PKEY = 111;
  EVP_F_EVP_PKEY2PKCS8 = 113;
  EVP_F_EVP_PKEY_ASN1_ADD0 = 188;
  EVP_F_EVP_PKEY_CHECK = 186;
  EVP_F_EVP_PKEY_COPY_PARAMETERS = 103;
  EVP_F_EVP_PKEY_CTX_CTRL = 137;
  EVP_F_EVP_PKEY_CTX_CTRL_STR = 150;
  EVP_F_EVP_PKEY_CTX_DUP = 156;
  EVP_F_EVP_PKEY_CTX_MD = 168;
  EVP_F_EVP_PKEY_DECRYPT = 104;
  EVP_F_EVP_PKEY_DECRYPT_INIT = 138;
  EVP_F_EVP_PKEY_DECRYPT_OLD = 151;
  EVP_F_EVP_PKEY_DERIVE = 153;
  EVP_F_EVP_PKEY_DERIVE_INIT = 154;
  EVP_F_EVP_PKEY_DERIVE_SET_PEER = 155;
  EVP_F_EVP_PKEY_ENCRYPT = 105;
  EVP_F_EVP_PKEY_ENCRYPT_INIT = 139;
  EVP_F_EVP_PKEY_ENCRYPT_OLD = 152;
  EVP_F_EVP_PKEY_GET0_DH = 119;
  EVP_F_EVP_PKEY_GET0_DSA = 120;
  EVP_F_EVP_PKEY_GET0_EC_KEY = 131;
  EVP_F_EVP_PKEY_GET0_HMAC = 183;
  EVP_F_EVP_PKEY_GET0_POLY1305 = 184;
  EVP_F_EVP_PKEY_GET0_RSA = 121;
  EVP_F_EVP_PKEY_GET0_SIPHASH = 172;
  EVP_F_EVP_PKEY_GET_RAW_PRIVATE_KEY = 202;
  EVP_F_EVP_PKEY_GET_RAW_PUBLIC_KEY = 203;
  EVP_F_EVP_PKEY_KEYGEN = 146;
  EVP_F_EVP_PKEY_KEYGEN_INIT = 147;
  EVP_F_EVP_PKEY_METH_ADD0 = 194;
  EVP_F_EVP_PKEY_METH_NEW = 195;
  EVP_F_EVP_PKEY_NEW = 106;
  EVP_F_EVP_PKEY_NEW_CMAC_KEY = 193;
  EVP_F_EVP_PKEY_NEW_RAW_PRIVATE_KEY = 191;
  EVP_F_EVP_PKEY_NEW_RAW_PUBLIC_KEY = 192;
  EVP_F_EVP_PKEY_PARAMGEN = 148;
  EVP_F_EVP_PKEY_PARAMGEN_INIT = 149;
  EVP_F_EVP_PKEY_PARAM_CHECK = 189;
  EVP_F_EVP_PKEY_PUBLIC_CHECK = 190;
  EVP_F_EVP_PKEY_SET1_ENGINE = 187;
  EVP_F_EVP_PKEY_SET_ALIAS_TYPE = 206;
  EVP_F_EVP_PKEY_SIGN = 140;
  EVP_F_EVP_PKEY_SIGN_INIT = 141;
  EVP_F_EVP_PKEY_VERIFY = 142;
  EVP_F_EVP_PKEY_VERIFY_INIT = 143;
  EVP_F_EVP_PKEY_VERIFY_RECOVER = 144;
  EVP_F_EVP_PKEY_VERIFY_RECOVER_INIT = 145;
  EVP_F_EVP_SIGNFINAL = 107;
  EVP_F_EVP_VERIFYFINAL = 108;
  EVP_F_INT_CTX_NEW = 157;
  EVP_F_OK_NEW = 200;
  EVP_F_PKCS5_PBE_KEYIVGEN = 117;
  EVP_F_PKCS5_V2_PBE_KEYIVGEN = 118;
  EVP_F_PKCS5_V2_PBKDF2_KEYIVGEN = 164;
  EVP_F_PKCS5_V2_SCRYPT_KEYIVGEN = 180;
  EVP_F_PKEY_SET_TYPE = 158;
  EVP_F_RC2_MAGIC_TO_METH = 109;
  EVP_F_RC5_CTRL = 125;
  EVP_F_R_32_12_16_INIT_KEY = 242;
  EVP_F_S390X_AES_GCM_CTRL = 201;
  EVP_F_UPDATE = 173;
  EVP_R_INVALID_FIPS_MODE = 168;
  EVP_R_KEYGEN_FAILURE = 120;

  EVP_MAX_MD_SIZE = 64;
  EVP_MAX_KEY_LENGTH = 64;
  EVP_MAX_IV_LENGTH = 16;
  EVP_MAX_BLOCK_LENGTH = 32;
  PKCS5_SALT_LEN = 8;
  PKCS5_DEFAULT_ITER = 2048;
  SN_undef = 'UNDEF';
  LN_undef = 'undefined';
  NID_undef = 0;
  OBJ_undef = 0;
  SN_itu_t = 'ITU-T';
  LN_itu_t = 'itu-t';
  NID_itu_t = 645;
  OBJ_itu_t = 0;
  NID_ccitt = 404;
  OBJ_ccitt = OBJ_itu_t;
  SN_iso = 'ISO';
  LN_iso = 'iso';
  NID_iso = 181;
  OBJ_iso = 1;
  SN_joint_iso_itu_t = 'JOINT-ISO-ITU-T';
  LN_joint_iso_itu_t = 'joint-iso-itu-t';
  NID_joint_iso_itu_t = 646;
  OBJ_joint_iso_itu_t = 2;
  NID_joint_iso_ccitt = 393;
  OBJ_joint_iso_ccitt = OBJ_joint_iso_itu_t;
  SN_member_body = 'member-body';
  LN_member_body = 'ISO Member Body';
  NID_member_body = 182;
  SN_identified_organization = 'identified-organization';
  NID_identified_organization = 676;
  SN_hmac_md5 = 'HMAC-MD5';
  LN_hmac_md5 = 'hmac-md5';
  NID_hmac_md5 = 780;
  SN_hmac_sha1 = 'HMAC-SHA1';
  LN_hmac_sha1 = 'hmac-sha1';
  NID_hmac_sha1 = 781;
  SN_x509ExtAdmission = 'x509ExtAdmission';
  LN_x509ExtAdmission = 'Professional Information or basis for Admission';
  NID_x509ExtAdmission = 1093;
  SN_certicom_arc = 'certicom-arc';
  NID_certicom_arc = 677;
  SN_ieee = 'ieee';
  NID_ieee = 1170;
  SN_ieee_siswg = 'ieee-siswg';
  LN_ieee_siswg = 'IEEE Security in Storage Working Group';
  NID_ieee_siswg = 1171;
  SN_international_organizations = 'international-organizations';
  LN_international_organizations = 'International Organizations';
  NID_international_organizations = 647;
  SN_wap = 'wap';
  NID_wap = 678;
  SN_wap_wsg = 'wap-wsg';
  NID_wap_wsg = 679;
  SN_selected_attribute_types = 'selected-attribute-types';
  LN_selected_attribute_types = 'Selected Attribute Types';
  NID_selected_attribute_types = 394;
  SN_clearance = 'clearance';
  NID_clearance = 395;
  SN_ISO_US = 'ISO-US';
  LN_ISO_US = 'ISO US Member Body';
  NID_ISO_US = 183;
  SN_X9_57 = 'X9-57';
  LN_X9_57 = 'X9.57';
  NID_X9_57 = 184;
  SN_X9cm = 'X9cm';
  LN_X9cm = 'X9.57 CM ?';
  NID_X9cm = 185;
  SN_ISO_CN = 'ISO-CN';
  LN_ISO_CN = 'ISO CN Member Body';
  NID_ISO_CN = 1140;
  SN_oscca = 'oscca';
  NID_oscca = 1141;
  SN_sm_scheme = 'sm-scheme';
  NID_sm_scheme = 1142;
  SN_dsa = 'DSA';
  LN_dsa = 'dsaEncryption';
  NID_dsa = 116;
  SN_dsaWithSHA1 = 'DSA-SHA1';
  LN_dsaWithSHA1 = 'dsaWithSHA1';
  NID_dsaWithSHA1 = 113;
  SN_ansi_X9_62 = 'ansi-X9-62';
  LN_ansi_X9_62 = 'ANSI X9.62';
  NID_ansi_X9_62 = 405;
  SN_X9_62_prime_field = 'prime-field';
  NID_X9_62_prime_field = 406;
  SN_X9_62_characteristic_two_field = 'characteristic-two-field';
  NID_X9_62_characteristic_two_field = 407;
  SN_X9_62_id_characteristic_two_basis = 'id-characteristic-two-basis';
  NID_X9_62_id_characteristic_two_basis = 680;
  SN_X9_62_onBasis = 'onBasis';
  NID_X9_62_onBasis = 681;
  SN_X9_62_tpBasis = 'tpBasis';
  NID_X9_62_tpBasis = 682;
  SN_X9_62_ppBasis = 'ppBasis';
  NID_X9_62_ppBasis = 683;
  SN_X9_62_id_ecPublicKey = 'id-ecPublicKey';
  NID_X9_62_id_ecPublicKey = 408;
  SN_X9_62_c2pnb163v1 = 'c2pnb163v1';
  NID_X9_62_c2pnb163v1 = 684;
  SN_X9_62_c2pnb163v2 = 'c2pnb163v2';
  NID_X9_62_c2pnb163v2 = 685;
  SN_X9_62_c2pnb163v3 = 'c2pnb163v3';
  NID_X9_62_c2pnb163v3 = 686;
  SN_X9_62_c2pnb176v1 = 'c2pnb176v1';
  NID_X9_62_c2pnb176v1 = 687;
  SN_X9_62_c2tnb191v1 = 'c2tnb191v1';
  NID_X9_62_c2tnb191v1 = 688;
  SN_X9_62_c2tnb191v2 = 'c2tnb191v2';
  NID_X9_62_c2tnb191v2 = 689;
  SN_X9_62_c2tnb191v3 = 'c2tnb191v3';
  NID_X9_62_c2tnb191v3 = 690;
  SN_X9_62_c2onb191v4 = 'c2onb191v4';
  NID_X9_62_c2onb191v4 = 691;
  SN_X9_62_c2onb191v5 = 'c2onb191v5';
  NID_X9_62_c2onb191v5 = 692;
  SN_X9_62_c2pnb208w1 = 'c2pnb208w1';
  NID_X9_62_c2pnb208w1 = 693;
  SN_X9_62_c2tnb239v1 = 'c2tnb239v1';
  NID_X9_62_c2tnb239v1 = 694;
  SN_X9_62_c2tnb239v2 = 'c2tnb239v2';
  NID_X9_62_c2tnb239v2 = 695;
  SN_X9_62_c2tnb239v3 = 'c2tnb239v3';
  NID_X9_62_c2tnb239v3 = 696;
  SN_X9_62_c2onb239v4 = 'c2onb239v4';
  NID_X9_62_c2onb239v4 = 697;
  SN_X9_62_c2onb239v5 = 'c2onb239v5';
  NID_X9_62_c2onb239v5 = 698;
  SN_X9_62_c2pnb272w1 = 'c2pnb272w1';
  NID_X9_62_c2pnb272w1 = 699;
  SN_X9_62_c2pnb304w1 = 'c2pnb304w1';
  NID_X9_62_c2pnb304w1 = 700;
  SN_X9_62_c2tnb359v1 = 'c2tnb359v1';
  NID_X9_62_c2tnb359v1 = 701;
  SN_X9_62_c2pnb368w1 = 'c2pnb368w1';
  NID_X9_62_c2pnb368w1 = 702;
  SN_X9_62_c2tnb431r1 = 'c2tnb431r1';
  NID_X9_62_c2tnb431r1 = 703;
  SN_X9_62_prime192v1 = 'prime192v1';
  NID_X9_62_prime192v1 = 409;
  SN_X9_62_prime192v2 = 'prime192v2';
  NID_X9_62_prime192v2 = 410;
  SN_X9_62_prime192v3 = 'prime192v3';
  NID_X9_62_prime192v3 = 411;
  SN_X9_62_prime239v1 = 'prime239v1';
  NID_X9_62_prime239v1 = 412;
  SN_X9_62_prime239v2 = 'prime239v2';
  NID_X9_62_prime239v2 = 413;
  SN_X9_62_prime239v3 = 'prime239v3';
  NID_X9_62_prime239v3 = 414;
  SN_X9_62_prime256v1 = 'prime256v1';
  NID_X9_62_prime256v1 = 415;
  SN_ecdsa_with_SHA1 = 'ecdsa-with-SHA1';
  NID_ecdsa_with_SHA1 = 416;
  SN_ecdsa_with_Recommended = 'ecdsa-with-Recommended';
  NID_ecdsa_with_Recommended = 791;
  SN_ecdsa_with_Specified = 'ecdsa-with-Specified';
  NID_ecdsa_with_Specified = 792;
  SN_ecdsa_with_SHA224 = 'ecdsa-with-SHA224';
  NID_ecdsa_with_SHA224 = 793;
  SN_ecdsa_with_SHA256 = 'ecdsa-with-SHA256';
  NID_ecdsa_with_SHA256 = 794;
  SN_ecdsa_with_SHA384 = 'ecdsa-with-SHA384';
  NID_ecdsa_with_SHA384 = 795;
  SN_ecdsa_with_SHA512 = 'ecdsa-with-SHA512';
  NID_ecdsa_with_SHA512 = 796;
  SN_secp112r1 = 'secp112r1';
  NID_secp112r1 = 704;
  SN_secp112r2 = 'secp112r2';
  NID_secp112r2 = 705;
  SN_secp128r1 = 'secp128r1';
  NID_secp128r1 = 706;
  SN_secp128r2 = 'secp128r2';
  NID_secp128r2 = 707;
  SN_secp160k1 = 'secp160k1';
  NID_secp160k1 = 708;
  SN_secp160r1 = 'secp160r1';
  NID_secp160r1 = 709;
  SN_secp160r2 = 'secp160r2';
  NID_secp160r2 = 710;
  SN_secp192k1 = 'secp192k1';
  NID_secp192k1 = 711;
  SN_secp224k1 = 'secp224k1';
  NID_secp224k1 = 712;
  SN_secp224r1 = 'secp224r1';
  NID_secp224r1 = 713;
  SN_secp256k1 = 'secp256k1';
  NID_secp256k1 = 714;
  SN_secp384r1 = 'secp384r1';
  NID_secp384r1 = 715;
  SN_secp521r1 = 'secp521r1';
  NID_secp521r1 = 716;
  SN_sect113r1 = 'sect113r1';
  NID_sect113r1 = 717;
  SN_sect113r2 = 'sect113r2';
  NID_sect113r2 = 718;
  SN_sect131r1 = 'sect131r1';
  NID_sect131r1 = 719;
  SN_sect131r2 = 'sect131r2';
  NID_sect131r2 = 720;
  SN_sect163k1 = 'sect163k1';
  NID_sect163k1 = 721;
  SN_sect163r1 = 'sect163r1';
  NID_sect163r1 = 722;
  SN_sect163r2 = 'sect163r2';
  NID_sect163r2 = 723;
  SN_sect193r1 = 'sect193r1';
  NID_sect193r1 = 724;
  SN_sect193r2 = 'sect193r2';
  NID_sect193r2 = 725;
  SN_sect233k1 = 'sect233k1';
  NID_sect233k1 = 726;
  SN_sect233r1 = 'sect233r1';
  NID_sect233r1 = 727;
  SN_sect239k1 = 'sect239k1';
  NID_sect239k1 = 728;
  SN_sect283k1 = 'sect283k1';
  NID_sect283k1 = 729;
  SN_sect283r1 = 'sect283r1';
  NID_sect283r1 = 730;
  SN_sect409k1 = 'sect409k1';
  NID_sect409k1 = 731;
  SN_sect409r1 = 'sect409r1';
  NID_sect409r1 = 732;
  SN_sect571k1 = 'sect571k1';
  NID_sect571k1 = 733;
  SN_sect571r1 = 'sect571r1';
  NID_sect571r1 = 734;
  SN_wap_wsg_idm_ecid_wtls1 = 'wap-wsg-idm-ecid-wtls1';
  NID_wap_wsg_idm_ecid_wtls1 = 735;
  SN_wap_wsg_idm_ecid_wtls3 = 'wap-wsg-idm-ecid-wtls3';
  NID_wap_wsg_idm_ecid_wtls3 = 736;
  SN_wap_wsg_idm_ecid_wtls4 = 'wap-wsg-idm-ecid-wtls4';
  NID_wap_wsg_idm_ecid_wtls4 = 737;
  SN_wap_wsg_idm_ecid_wtls5 = 'wap-wsg-idm-ecid-wtls5';
  NID_wap_wsg_idm_ecid_wtls5 = 738;
  SN_wap_wsg_idm_ecid_wtls6 = 'wap-wsg-idm-ecid-wtls6';
  NID_wap_wsg_idm_ecid_wtls6 = 739;
  SN_wap_wsg_idm_ecid_wtls7 = 'wap-wsg-idm-ecid-wtls7';
  NID_wap_wsg_idm_ecid_wtls7 = 740;
  SN_wap_wsg_idm_ecid_wtls8 = 'wap-wsg-idm-ecid-wtls8';
  NID_wap_wsg_idm_ecid_wtls8 = 741;
  SN_wap_wsg_idm_ecid_wtls9 = 'wap-wsg-idm-ecid-wtls9';
  NID_wap_wsg_idm_ecid_wtls9 = 742;
  SN_wap_wsg_idm_ecid_wtls10 = 'wap-wsg-idm-ecid-wtls10';
  NID_wap_wsg_idm_ecid_wtls10 = 743;
  SN_wap_wsg_idm_ecid_wtls11 = 'wap-wsg-idm-ecid-wtls11';
  NID_wap_wsg_idm_ecid_wtls11 = 744;
  SN_wap_wsg_idm_ecid_wtls12 = 'wap-wsg-idm-ecid-wtls12';
  NID_wap_wsg_idm_ecid_wtls12 = 745;
  SN_cast5_cbc = 'CAST5-CBC';
  LN_cast5_cbc = 'cast5-cbc';
  NID_cast5_cbc = 108;
  SN_cast5_ecb = 'CAST5-ECB';
  LN_cast5_ecb = 'cast5-ecb';
  NID_cast5_ecb = 109;
  SN_cast5_cfb64 = 'CAST5-CFB';
  LN_cast5_cfb64 = 'cast5-cfb';
  NID_cast5_cfb64 = 110;
  SN_cast5_ofb64 = 'CAST5-OFB';
  LN_cast5_ofb64 = 'cast5-ofb';
  NID_cast5_ofb64 = 111;
  LN_pbeWithMD5AndCast5_CBC = 'pbeWithMD5AndCast5CBC';
  NID_pbeWithMD5AndCast5_CBC = 112;
  SN_id_PasswordBasedMAC = 'id-PasswordBasedMAC';
  LN_id_PasswordBasedMAC = 'password based MAC';
  NID_id_PasswordBasedMAC = 782;
  SN_id_DHBasedMac = 'id-DHBasedMac';
  LN_id_DHBasedMac = 'Diffie-Hellman based MAC';
  NID_id_DHBasedMac = 783;
  SN_rsadsi = 'rsadsi';
  LN_rsadsi = 'RSA Data Security, Inc.';
  NID_rsadsi = 1;
  SN_pkcs = 'pkcs';
  LN_pkcs = 'RSA Data Security, Inc. PKCS';
  NID_pkcs = 2;
  SN_pkcs1 = 'pkcs1';
  NID_pkcs1 = 186;
  LN_rsaEncryption = 'rsaEncryption';
  NID_rsaEncryption = 6;
  SN_md2WithRSAEncryption = 'RSA-MD2';
  LN_md2WithRSAEncryption = 'md2WithRSAEncryption';
  NID_md2WithRSAEncryption = 7;
  SN_md4WithRSAEncryption = 'RSA-MD4';
  LN_md4WithRSAEncryption = 'md4WithRSAEncryption';
  NID_md4WithRSAEncryption = 396;
  SN_md5WithRSAEncryption = 'RSA-MD5';
  LN_md5WithRSAEncryption = 'md5WithRSAEncryption';
  NID_md5WithRSAEncryption = 8;
  SN_sha1WithRSAEncryption = 'RSA-SHA1';
  LN_sha1WithRSAEncryption = 'sha1WithRSAEncryption';
  NID_sha1WithRSAEncryption = 65;
  SN_rsaesOaep = 'RSAES-OAEP';
  LN_rsaesOaep = 'rsaesOaep';
  NID_rsaesOaep = 919;
  SN_mgf1 = 'MGF1';
  LN_mgf1 = 'mgf1';
  NID_mgf1 = 911;
  SN_pSpecified = 'PSPECIFIED';
  LN_pSpecified = 'pSpecified';
  NID_pSpecified = 935;
  SN_rsassaPss = 'RSASSA-PSS';
  LN_rsassaPss = 'rsassaPss';
  NID_rsassaPss = 912;
  SN_sha256WithRSAEncryption = 'RSA-SHA256';
  LN_sha256WithRSAEncryption = 'sha256WithRSAEncryption';
  NID_sha256WithRSAEncryption = 668;
  SN_sha384WithRSAEncryption = 'RSA-SHA384';
  LN_sha384WithRSAEncryption = 'sha384WithRSAEncryption';
  NID_sha384WithRSAEncryption = 669;
  SN_sha512WithRSAEncryption = 'RSA-SHA512';
  LN_sha512WithRSAEncryption = 'sha512WithRSAEncryption';
  NID_sha512WithRSAEncryption = 670;
  SN_sha224WithRSAEncryption = 'RSA-SHA224';
  LN_sha224WithRSAEncryption = 'sha224WithRSAEncryption';
  NID_sha224WithRSAEncryption = 671;
  SN_sha512_224WithRSAEncryption = 'RSA-SHA512/224';
  LN_sha512_224WithRSAEncryption = 'sha512-224WithRSAEncryption';
  NID_sha512_224WithRSAEncryption = 1145;
  SN_sha512_256WithRSAEncryption = 'RSA-SHA512/256';
  LN_sha512_256WithRSAEncryption = 'sha512-256WithRSAEncryption';
  NID_sha512_256WithRSAEncryption = 1146;
  SN_pkcs3 = 'pkcs3';
  NID_pkcs3 = 27;
  LN_dhKeyAgreement = 'dhKeyAgreement';
  NID_dhKeyAgreement = 28;
  SN_pkcs5 = 'pkcs5';
  NID_pkcs5 = 187;
  SN_pbeWithMD2AndDES_CBC = 'PBE-MD2-DES';
  LN_pbeWithMD2AndDES_CBC = 'pbeWithMD2AndDES-CBC';
  NID_pbeWithMD2AndDES_CBC = 9;
  SN_pbeWithMD5AndDES_CBC = 'PBE-MD5-DES';
  LN_pbeWithMD5AndDES_CBC = 'pbeWithMD5AndDES-CBC';
  NID_pbeWithMD5AndDES_CBC = 10;
  SN_pbeWithMD2AndRC2_CBC = 'PBE-MD2-RC2-64';
  LN_pbeWithMD2AndRC2_CBC = 'pbeWithMD2AndRC2-CBC';
  NID_pbeWithMD2AndRC2_CBC = 168;
  SN_pbeWithMD5AndRC2_CBC = 'PBE-MD5-RC2-64';
  LN_pbeWithMD5AndRC2_CBC = 'pbeWithMD5AndRC2-CBC';
  NID_pbeWithMD5AndRC2_CBC = 169;
  SN_pbeWithSHA1AndDES_CBC = 'PBE-SHA1-DES';
  LN_pbeWithSHA1AndDES_CBC = 'pbeWithSHA1AndDES-CBC';
  NID_pbeWithSHA1AndDES_CBC = 170;
  SN_pbeWithSHA1AndRC2_CBC = 'PBE-SHA1-RC2-64';
  LN_pbeWithSHA1AndRC2_CBC = 'pbeWithSHA1AndRC2-CBC';
  NID_pbeWithSHA1AndRC2_CBC = 68;
  LN_id_pbkdf2 = 'PBKDF2';
  NID_id_pbkdf2 = 69;
  LN_pbes2 = 'PBES2';
  NID_pbes2 = 161;
  LN_pbmac1 = 'PBMAC1';
  NID_pbmac1 = 162;
  SN_pkcs7 = 'pkcs7';
  NID_pkcs7 = 20;
  LN_pkcs7_data = 'pkcs7-data';
  NID_pkcs7_data = 21;
  LN_pkcs7_signed = 'pkcs7-signedData';
  NID_pkcs7_signed = 22;
  LN_pkcs7_enveloped = 'pkcs7-envelopedData';
  NID_pkcs7_enveloped = 23;
  LN_pkcs7_signedAndEnveloped = 'pkcs7-signedAndEnvelopedData';
  NID_pkcs7_signedAndEnveloped = 24;
  LN_pkcs7_digest = 'pkcs7-digestData';
  NID_pkcs7_digest = 25;
  LN_pkcs7_encrypted = 'pkcs7-encryptedData';
  NID_pkcs7_encrypted = 26;
  SN_pkcs9 = 'pkcs9';
  NID_pkcs9 = 47;
  LN_pkcs9_emailAddress = 'emailAddress';
  NID_pkcs9_emailAddress = 48;
  LN_pkcs9_unstructuredName = 'unstructuredName';
  NID_pkcs9_unstructuredName = 49;
  LN_pkcs9_contentType = 'contentType';
  NID_pkcs9_contentType = 50;
  LN_pkcs9_messageDigest = 'messageDigest';
  NID_pkcs9_messageDigest = 51;
  LN_pkcs9_signingTime = 'signingTime';
  NID_pkcs9_signingTime = 52;
  LN_pkcs9_countersignature = 'countersignature';
  NID_pkcs9_countersignature = 53;
  LN_pkcs9_challengePassword = 'challengePassword';
  NID_pkcs9_challengePassword = 54;
  LN_pkcs9_unstructuredAddress = 'unstructuredAddress';
  NID_pkcs9_unstructuredAddress = 55;
  LN_pkcs9_extCertAttributes = 'extendedCertificateAttributes';
  NID_pkcs9_extCertAttributes = 56;
  SN_ext_req = 'extReq';
  LN_ext_req = 'Extension Request';
  NID_ext_req = 172;
  SN_SMIMECapabilities = 'SMIME-CAPS';
  LN_SMIMECapabilities = 'S/MIME Capabilities';
  NID_SMIMECapabilities = 167;
  SN_SMIME = 'SMIME';
  LN_SMIME = 'S/MIME';
  NID_SMIME = 188;
  SN_id_smime_mod = 'id-smime-mod';
  NID_id_smime_mod = 189;
  SN_id_smime_ct = 'id-smime-ct';
  NID_id_smime_ct = 190;
  SN_id_smime_aa = 'id-smime-aa';
  NID_id_smime_aa = 191;
  SN_id_smime_alg = 'id-smime-alg';
  NID_id_smime_alg = 192;
  SN_id_smime_cd = 'id-smime-cd';
  NID_id_smime_cd = 193;
  SN_id_smime_spq = 'id-smime-spq';
  NID_id_smime_spq = 194;
  SN_id_smime_cti = 'id-smime-cti';
  NID_id_smime_cti = 195;
  SN_id_smime_mod_cms = 'id-smime-mod-cms';
  NID_id_smime_mod_cms = 196;
  SN_id_smime_mod_ess = 'id-smime-mod-ess';
  NID_id_smime_mod_ess = 197;
  SN_id_smime_mod_oid = 'id-smime-mod-oid';
  NID_id_smime_mod_oid = 198;
  SN_id_smime_mod_msg_v3 = 'id-smime-mod-msg-v3';
  NID_id_smime_mod_msg_v3 = 199;
  SN_id_smime_mod_ets_eSignature_88 = 'id-smime-mod-ets-eSignature-88';
  NID_id_smime_mod_ets_eSignature_88 = 200;
  SN_id_smime_mod_ets_eSignature_97 = 'id-smime-mod-ets-eSignature-97';
  NID_id_smime_mod_ets_eSignature_97 = 201;
  SN_id_smime_mod_ets_eSigPolicy_88 = 'id-smime-mod-ets-eSigPolicy-88';
  NID_id_smime_mod_ets_eSigPolicy_88 = 202;
  SN_id_smime_mod_ets_eSigPolicy_97 = 'id-smime-mod-ets-eSigPolicy-97';
  NID_id_smime_mod_ets_eSigPolicy_97 = 203;
  SN_id_smime_ct_receipt = 'id-smime-ct-receipt';
  NID_id_smime_ct_receipt = 204;
  SN_id_smime_ct_authData = 'id-smime-ct-authData';
  NID_id_smime_ct_authData = 205;
  SN_id_smime_ct_publishCert = 'id-smime-ct-publishCert';
  NID_id_smime_ct_publishCert = 206;
  SN_id_smime_ct_TSTInfo = 'id-smime-ct-TSTInfo';
  NID_id_smime_ct_TSTInfo = 207;
  SN_id_smime_ct_TDTInfo = 'id-smime-ct-TDTInfo';
  NID_id_smime_ct_TDTInfo = 208;
  SN_id_smime_ct_contentInfo = 'id-smime-ct-contentInfo';
  NID_id_smime_ct_contentInfo = 209;
  SN_id_smime_ct_DVCSRequestData = 'id-smime-ct-DVCSRequestData';
  NID_id_smime_ct_DVCSRequestData = 210;
  SN_id_smime_ct_DVCSResponseData = 'id-smime-ct-DVCSResponseData';
  NID_id_smime_ct_DVCSResponseData = 211;
  SN_id_smime_ct_compressedData = 'id-smime-ct-compressedData';
  NID_id_smime_ct_compressedData = 786;
  SN_id_smime_ct_contentCollection = 'id-smime-ct-contentCollection';
  NID_id_smime_ct_contentCollection = 1058;
  SN_id_smime_ct_authEnvelopedData = 'id-smime-ct-authEnvelopedData';
  NID_id_smime_ct_authEnvelopedData = 1059;
  SN_id_ct_asciiTextWithCRLF = 'id-ct-asciiTextWithCRLF';
  NID_id_ct_asciiTextWithCRLF = 787;
  SN_id_ct_xml = 'id-ct-xml';
  NID_id_ct_xml = 1060;
  SN_id_smime_aa_receiptRequest = 'id-smime-aa-receiptRequest';
  NID_id_smime_aa_receiptRequest = 212;
  SN_id_smime_aa_securityLabel = 'id-smime-aa-securityLabel';
  NID_id_smime_aa_securityLabel = 213;
  SN_id_smime_aa_mlExpandHistory = 'id-smime-aa-mlExpandHistory';
  NID_id_smime_aa_mlExpandHistory = 214;
  SN_id_smime_aa_contentHint = 'id-smime-aa-contentHint';
  NID_id_smime_aa_contentHint = 215;
  SN_id_smime_aa_msgSigDigest = 'id-smime-aa-msgSigDigest';
  NID_id_smime_aa_msgSigDigest = 216;
  SN_id_smime_aa_encapContentType = 'id-smime-aa-encapContentType';
  NID_id_smime_aa_encapContentType = 217;
  SN_id_smime_aa_contentIdentifier = 'id-smime-aa-contentIdentifier';
  NID_id_smime_aa_contentIdentifier = 218;
  SN_id_smime_aa_macValue = 'id-smime-aa-macValue';
  NID_id_smime_aa_macValue = 219;
  SN_id_smime_aa_equivalentLabels = 'id-smime-aa-equivalentLabels';
  NID_id_smime_aa_equivalentLabels = 220;
  SN_id_smime_aa_contentReference = 'id-smime-aa-contentReference';
  NID_id_smime_aa_contentReference = 221;
  SN_id_smime_aa_encrypKeyPref = 'id-smime-aa-encrypKeyPref';
  NID_id_smime_aa_encrypKeyPref = 222;
  SN_id_smime_aa_signingCertificate = 'id-smime-aa-signingCertificate';
  NID_id_smime_aa_signingCertificate = 223;
  SN_id_smime_aa_smimeEncryptCerts = 'id-smime-aa-smimeEncryptCerts';
  NID_id_smime_aa_smimeEncryptCerts = 224;
  SN_id_smime_aa_timeStampToken = 'id-smime-aa-timeStampToken';
  NID_id_smime_aa_timeStampToken = 225;
  SN_id_smime_aa_ets_sigPolicyId = 'id-smime-aa-ets-sigPolicyId';
  NID_id_smime_aa_ets_sigPolicyId = 226;
  SN_id_smime_aa_ets_commitmentType = 'id-smime-aa-ets-commitmentType';
  NID_id_smime_aa_ets_commitmentType = 227;
  SN_id_smime_aa_ets_signerLocation = 'id-smime-aa-ets-signerLocation';
  NID_id_smime_aa_ets_signerLocation = 228;
  SN_id_smime_aa_ets_signerAttr = 'id-smime-aa-ets-signerAttr';
  NID_id_smime_aa_ets_signerAttr = 229;
  SN_id_smime_aa_ets_otherSigCert = 'id-smime-aa-ets-otherSigCert';
  NID_id_smime_aa_ets_otherSigCert = 230;
  SN_id_smime_aa_ets_contentTimestamp = 'id-smime-aa-ets-contentTimestamp';
  NID_id_smime_aa_ets_contentTimestamp = 231;
  SN_id_smime_aa_ets_CertificateRefs = 'id-smime-aa-ets-CertificateRefs';
  NID_id_smime_aa_ets_CertificateRefs = 232;
  SN_id_smime_aa_ets_RevocationRefs = 'id-smime-aa-ets-RevocationRefs';
  NID_id_smime_aa_ets_RevocationRefs = 233;
  SN_id_smime_aa_ets_certValues = 'id-smime-aa-ets-certValues';
  NID_id_smime_aa_ets_certValues = 234;
  SN_id_smime_aa_ets_revocationValues = 'id-smime-aa-ets-revocationValues';
  NID_id_smime_aa_ets_revocationValues = 235;
  SN_id_smime_aa_ets_escTimeStamp = 'id-smime-aa-ets-escTimeStamp';
  NID_id_smime_aa_ets_escTimeStamp = 236;
  SN_id_smime_aa_ets_certCRLTimestamp = 'id-smime-aa-ets-certCRLTimestamp';
  NID_id_smime_aa_ets_certCRLTimestamp = 237;
  SN_id_smime_aa_ets_archiveTimeStamp = 'id-smime-aa-ets-archiveTimeStamp';
  NID_id_smime_aa_ets_archiveTimeStamp = 238;
  SN_id_smime_aa_signatureType = 'id-smime-aa-signatureType';
  NID_id_smime_aa_signatureType = 239;
  SN_id_smime_aa_dvcs_dvc = 'id-smime-aa-dvcs-dvc';
  NID_id_smime_aa_dvcs_dvc = 240;
  SN_id_smime_aa_signingCertificateV2 = 'id-smime-aa-signingCertificateV2';
  NID_id_smime_aa_signingCertificateV2 = 1086;
  SN_id_smime_alg_ESDHwith3DES = 'id-smime-alg-ESDHwith3DES';
  NID_id_smime_alg_ESDHwith3DES = 241;
  SN_id_smime_alg_ESDHwithRC2 = 'id-smime-alg-ESDHwithRC2';
  NID_id_smime_alg_ESDHwithRC2 = 242;
  SN_id_smime_alg_3DESwrap = 'id-smime-alg-3DESwrap';
  NID_id_smime_alg_3DESwrap = 243;
  SN_id_smime_alg_RC2wrap = 'id-smime-alg-RC2wrap';
  NID_id_smime_alg_RC2wrap = 244;
  SN_id_smime_alg_ESDH = 'id-smime-alg-ESDH';
  NID_id_smime_alg_ESDH = 245;
  SN_id_smime_alg_CMS3DESwrap = 'id-smime-alg-CMS3DESwrap';
  NID_id_smime_alg_CMS3DESwrap = 246;
  SN_id_smime_alg_CMSRC2wrap = 'id-smime-alg-CMSRC2wrap';
  NID_id_smime_alg_CMSRC2wrap = 247;
  SN_id_alg_PWRI_KEK = 'id-alg-PWRI-KEK';
  NID_id_alg_PWRI_KEK = 893;
  SN_id_smime_cd_ldap = 'id-smime-cd-ldap';
  NID_id_smime_cd_ldap = 248;
  SN_id_smime_spq_ets_sqt_uri = 'id-smime-spq-ets-sqt-uri';
  NID_id_smime_spq_ets_sqt_uri = 249;
  SN_id_smime_spq_ets_sqt_unotice = 'id-smime-spq-ets-sqt-unotice';
  NID_id_smime_spq_ets_sqt_unotice = 250;
  SN_id_smime_cti_ets_proofOfOrigin = 'id-smime-cti-ets-proofOfOrigin';
  NID_id_smime_cti_ets_proofOfOrigin = 251;
  SN_id_smime_cti_ets_proofOfReceipt = 'id-smime-cti-ets-proofOfReceipt';
  NID_id_smime_cti_ets_proofOfReceipt = 252;
  SN_id_smime_cti_ets_proofOfDelivery = 'id-smime-cti-ets-proofOfDelivery';
  NID_id_smime_cti_ets_proofOfDelivery = 253;
  SN_id_smime_cti_ets_proofOfSender = 'id-smime-cti-ets-proofOfSender';
  NID_id_smime_cti_ets_proofOfSender = 254;
  SN_id_smime_cti_ets_proofOfApproval = 'id-smime-cti-ets-proofOfApproval';
  NID_id_smime_cti_ets_proofOfApproval = 255;
  SN_id_smime_cti_ets_proofOfCreation = 'id-smime-cti-ets-proofOfCreation';
  NID_id_smime_cti_ets_proofOfCreation = 256;
  LN_friendlyName = 'friendlyName';
  NID_friendlyName = 156;
  LN_localKeyID = 'localKeyID';
  NID_localKeyID = 157;
  SN_ms_csp_name = 'CSPName';
  LN_ms_csp_name = 'Microsoft CSP Name';
  NID_ms_csp_name = 417;
  SN_LocalKeySet = 'LocalKeySet';
  LN_LocalKeySet = 'Microsoft Local Key set';
  NID_LocalKeySet = 856;
  LN_x509Certificate = 'x509Certificate';
  NID_x509Certificate = 158;
  LN_sdsiCertificate = 'sdsiCertificate';
  NID_sdsiCertificate = 159;
  LN_x509Crl = 'x509Crl';
  NID_x509Crl = 160;
  SN_pbe_WithSHA1And128BitRC4 = 'PBE-SHA1-RC4-128';
  LN_pbe_WithSHA1And128BitRC4 = 'pbeWithSHA1And128BitRC4';
  NID_pbe_WithSHA1And128BitRC4 = 144;
  SN_pbe_WithSHA1And40BitRC4 = 'PBE-SHA1-RC4-40';
  LN_pbe_WithSHA1And40BitRC4 = 'pbeWithSHA1And40BitRC4';
  NID_pbe_WithSHA1And40BitRC4 = 145;
  SN_pbe_WithSHA1And3_Key_TripleDES_CBC = 'PBE-SHA1-3DES';
  LN_pbe_WithSHA1And3_Key_TripleDES_CBC = 'pbeWithSHA1And3-KeyTripleDES-CBC';
  NID_pbe_WithSHA1And3_Key_TripleDES_CBC = 146;
  SN_pbe_WithSHA1And2_Key_TripleDES_CBC = 'PBE-SHA1-2DES';
  LN_pbe_WithSHA1And2_Key_TripleDES_CBC = 'pbeWithSHA1And2-KeyTripleDES-CBC';
  NID_pbe_WithSHA1And2_Key_TripleDES_CBC = 147;
  SN_pbe_WithSHA1And128BitRC2_CBC = 'PBE-SHA1-RC2-128';
  LN_pbe_WithSHA1And128BitRC2_CBC = 'pbeWithSHA1And128BitRC2-CBC';
  NID_pbe_WithSHA1And128BitRC2_CBC = 148;
  SN_pbe_WithSHA1And40BitRC2_CBC = 'PBE-SHA1-RC2-40';
  LN_pbe_WithSHA1And40BitRC2_CBC = 'pbeWithSHA1And40BitRC2-CBC';
  NID_pbe_WithSHA1And40BitRC2_CBC = 149;
  LN_keyBag = 'keyBag';
  NID_keyBag = 150;
  LN_pkcs8ShroudedKeyBag = 'pkcs8ShroudedKeyBag';
  NID_pkcs8ShroudedKeyBag = 151;
  LN_certBag = 'certBag';
  NID_certBag = 152;
  LN_crlBag = 'crlBag';
  NID_crlBag = 153;
  LN_secretBag = 'secretBag';
  NID_secretBag = 154;
  LN_safeContentsBag = 'safeContentsBag';
  NID_safeContentsBag = 155;
  SN_md2 = 'MD2';
  LN_md2 = 'md2';
  NID_md2 = 3;
  SN_md4 = 'MD4';
  LN_md4 = 'md4';
  NID_md4 = 257;
  SN_md5 = 'MD5';
  LN_md5 = 'md5';
  NID_md5 = 4;
  SN_md5_sha1 = 'MD5-SHA1';
  LN_md5_sha1 = 'md5-sha1';
  NID_md5_sha1 = 114;
  LN_hmacWithMD5 = 'hmacWithMD5';
  NID_hmacWithMD5 = 797;
  LN_hmacWithSHA1 = 'hmacWithSHA1';
  NID_hmacWithSHA1 = 163;
  SN_sm2 = 'SM2';
  LN_sm2 = 'sm2';
  NID_sm2 = 1172;
  SN_sm3 = 'SM3';
  LN_sm3 = 'sm3';
  NID_sm3 = 1143;
  SN_sm3WithRSAEncryption = 'RSA-SM3';
  LN_sm3WithRSAEncryption = 'sm3WithRSAEncryption';
  NID_sm3WithRSAEncryption = 1144;
  LN_hmacWithSHA224 = 'hmacWithSHA224';
  NID_hmacWithSHA224 = 798;
  LN_hmacWithSHA256 = 'hmacWithSHA256';
  NID_hmacWithSHA256 = 799;
  LN_hmacWithSHA384 = 'hmacWithSHA384';
  NID_hmacWithSHA384 = 800;
  LN_hmacWithSHA512 = 'hmacWithSHA512';
  NID_hmacWithSHA512 = 801;
  LN_hmacWithSHA512_224 = 'hmacWithSHA512-224';
  NID_hmacWithSHA512_224 = 1193;
  LN_hmacWithSHA512_256 = 'hmacWithSHA512-256';
  NID_hmacWithSHA512_256 = 1194;
  SN_rc2_cbc = 'RC2-CBC';
  LN_rc2_cbc = 'rc2-cbc';
  NID_rc2_cbc = 37;
  SN_rc2_ecb = 'RC2-ECB';
  LN_rc2_ecb = 'rc2-ecb';
  NID_rc2_ecb = 38;
  SN_rc2_cfb64 = 'RC2-CFB';
  LN_rc2_cfb64 = 'rc2-cfb';
  NID_rc2_cfb64 = 39;
  SN_rc2_ofb64 = 'RC2-OFB';
  LN_rc2_ofb64 = 'rc2-ofb';
  NID_rc2_ofb64 = 40;
  SN_rc2_40_cbc = 'RC2-40-CBC';
  LN_rc2_40_cbc = 'rc2-40-cbc';
  NID_rc2_40_cbc = 98;
  SN_rc2_64_cbc = 'RC2-64-CBC';
  LN_rc2_64_cbc = 'rc2-64-cbc';
  NID_rc2_64_cbc = 166;
  SN_rc4 = 'RC4';
  LN_rc4 = 'rc4';
  NID_rc4 = 5;
  SN_rc4_40 = 'RC4-40';
  LN_rc4_40 = 'rc4-40';
  NID_rc4_40 = 97;
  SN_des_ede3_cbc = 'DES-EDE3-CBC';
  LN_des_ede3_cbc = 'des-ede3-cbc';
  NID_des_ede3_cbc = 44;
  SN_rc5_cbc = 'RC5-CBC';
  LN_rc5_cbc = 'rc5-cbc';
  NID_rc5_cbc = 120;
  SN_rc5_ecb = 'RC5-ECB';
  LN_rc5_ecb = 'rc5-ecb';
  NID_rc5_ecb = 121;
  SN_rc5_cfb64 = 'RC5-CFB';
  LN_rc5_cfb64 = 'rc5-cfb';
  NID_rc5_cfb64 = 122;
  SN_rc5_ofb64 = 'RC5-OFB';
  LN_rc5_ofb64 = 'rc5-ofb';
  NID_rc5_ofb64 = 123;
  SN_ms_ext_req = 'msExtReq';
  LN_ms_ext_req = 'Microsoft Extension Request';
  NID_ms_ext_req = 171;
  SN_ms_code_ind = 'msCodeInd';
  LN_ms_code_ind = 'Microsoft Individual Code Signing';
  NID_ms_code_ind = 134;
  SN_ms_code_com = 'msCodeCom';
  LN_ms_code_com = 'Microsoft Commercial Code Signing';
  NID_ms_code_com = 135;
  SN_ms_ctl_sign = 'msCTLSign';
  LN_ms_ctl_sign = 'Microsoft Trust List Signing';
  NID_ms_ctl_sign = 136;
  SN_ms_sgc = 'msSGC';
  LN_ms_sgc = 'Microsoft Server Gated Crypto';
  NID_ms_sgc = 137;
  SN_ms_efs = 'msEFS';
  LN_ms_efs = 'Microsoft Encrypted File System';
  NID_ms_efs = 138;
  SN_ms_smartcard_login = 'msSmartcardLogin';
  LN_ms_smartcard_login = 'Microsoft Smartcard Login';
  NID_ms_smartcard_login = 648;
  SN_ms_upn = 'msUPN';
  LN_ms_upn = 'Microsoft User Principal Name';
  NID_ms_upn = 649;
  SN_idea_cbc = 'IDEA-CBC';
  LN_idea_cbc = 'idea-cbc';
  NID_idea_cbc = 34;
  SN_idea_ecb = 'IDEA-ECB';
  LN_idea_ecb = 'idea-ecb';
  NID_idea_ecb = 36;
  SN_idea_cfb64 = 'IDEA-CFB';
  LN_idea_cfb64 = 'idea-cfb';
  NID_idea_cfb64 = 35;
  SN_idea_ofb64 = 'IDEA-OFB';
  LN_idea_ofb64 = 'idea-ofb';
  NID_idea_ofb64 = 46;
  SN_bf_cbc = 'BF-CBC';
  LN_bf_cbc = 'bf-cbc';
  NID_bf_cbc = 91;
  SN_bf_ecb = 'BF-ECB';
  LN_bf_ecb = 'bf-ecb';
  NID_bf_ecb = 92;
  SN_bf_cfb64 = 'BF-CFB';
  LN_bf_cfb64 = 'bf-cfb';
  NID_bf_cfb64 = 93;
  SN_bf_ofb64 = 'BF-OFB';
  LN_bf_ofb64 = 'bf-ofb';
  NID_bf_ofb64 = 94;
  SN_id_pkix = 'PKIX';
  NID_id_pkix = 127;
  SN_id_pkix_mod = 'id-pkix-mod';
  NID_id_pkix_mod = 258;
  SN_id_pe = 'id-pe';
  NID_id_pe = 175;
  SN_id_qt = 'id-qt';
  NID_id_qt = 259;
  SN_id_kp = 'id-kp';
  NID_id_kp = 128;
  SN_id_it = 'id-it';
  NID_id_it = 260;
  SN_id_pkip = 'id-pkip';
  NID_id_pkip = 261;
  SN_id_alg = 'id-alg';
  NID_id_alg = 262;
  SN_id_cmc = 'id-cmc';
  NID_id_cmc = 263;
  SN_id_on = 'id-on';
  NID_id_on = 264;
  SN_id_pda = 'id-pda';
  NID_id_pda = 265;
  SN_id_aca = 'id-aca';
  NID_id_aca = 266;
  SN_id_qcs = 'id-qcs';
  NID_id_qcs = 267;
  SN_id_cct = 'id-cct';
  NID_id_cct = 268;
  SN_id_ppl = 'id-ppl';
  NID_id_ppl = 662;
  SN_id_ad = 'id-ad';
  NID_id_ad = 176;
  SN_id_pkix1_explicit_88 = 'id-pkix1-explicit-88';
  NID_id_pkix1_explicit_88 = 269;
  SN_id_pkix1_implicit_88 = 'id-pkix1-implicit-88';
  NID_id_pkix1_implicit_88 = 270;
  SN_id_pkix1_explicit_93 = 'id-pkix1-explicit-93';
  NID_id_pkix1_explicit_93 = 271;
  SN_id_pkix1_implicit_93 = 'id-pkix1-implicit-93';
  NID_id_pkix1_implicit_93 = 272;
  SN_id_mod_crmf = 'id-mod-crmf';
  NID_id_mod_crmf = 273;
  SN_id_mod_cmc = 'id-mod-cmc';
  NID_id_mod_cmc = 274;
  SN_id_mod_kea_profile_88 = 'id-mod-kea-profile-88';
  NID_id_mod_kea_profile_88 = 275;
  SN_id_mod_kea_profile_93 = 'id-mod-kea-profile-93';
  NID_id_mod_kea_profile_93 = 276;
  SN_id_mod_cmp = 'id-mod-cmp';
  NID_id_mod_cmp = 277;
  SN_id_mod_qualified_cert_88 = 'id-mod-qualified-cert-88';
  NID_id_mod_qualified_cert_88 = 278;
  SN_id_mod_qualified_cert_93 = 'id-mod-qualified-cert-93';
  NID_id_mod_qualified_cert_93 = 279;
  SN_id_mod_attribute_cert = 'id-mod-attribute-cert';
  NID_id_mod_attribute_cert = 280;
  SN_id_mod_timestamp_protocol = 'id-mod-timestamp-protocol';
  NID_id_mod_timestamp_protocol = 281;
  SN_id_mod_ocsp = 'id-mod-ocsp';
  NID_id_mod_ocsp = 282;
  SN_id_mod_dvcs = 'id-mod-dvcs';
  NID_id_mod_dvcs = 283;
  SN_id_mod_cmp2000 = 'id-mod-cmp2000';
  NID_id_mod_cmp2000 = 284;
  SN_info_access = 'authorityInfoAccess';
  LN_info_access = 'Authority Information Access';
  NID_info_access = 177;
  SN_biometricInfo = 'biometricInfo';
  LN_biometricInfo = 'Biometric Info';
  NID_biometricInfo = 285;
  SN_qcStatements = 'qcStatements';
  NID_qcStatements = 286;
  SN_ac_auditEntity = 'ac-auditEntity';
  NID_ac_auditEntity = 287;
  SN_ac_targeting = 'ac-targeting';
  NID_ac_targeting = 288;
  SN_aaControls = 'aaControls';
  NID_aaControls = 289;
  SN_sbgp_ipAddrBlock = 'sbgp-ipAddrBlock';
  NID_sbgp_ipAddrBlock = 290;
  SN_sbgp_autonomousSysNum = 'sbgp-autonomousSysNum';
  NID_sbgp_autonomousSysNum = 291;
  SN_sbgp_routerIdentifier = 'sbgp-routerIdentifier';
  NID_sbgp_routerIdentifier = 292;
  SN_ac_proxying = 'ac-proxying';
  NID_ac_proxying = 397;
  SN_sinfo_access = 'subjectInfoAccess';
  LN_sinfo_access = 'Subject Information Access';
  NID_sinfo_access = 398;
  SN_proxyCertInfo = 'proxyCertInfo';
  LN_proxyCertInfo = 'Proxy Certificate Information';
  NID_proxyCertInfo = 663;
  SN_tlsfeature = 'tlsfeature';
  LN_tlsfeature = 'TLS Feature';
  NID_tlsfeature = 1020;
  SN_id_qt_cps = 'id-qt-cps';
  LN_id_qt_cps = 'Policy Qualifier CPS';
  NID_id_qt_cps = 164;
  SN_id_qt_unotice = 'id-qt-unotice';
  LN_id_qt_unotice = 'Policy Qualifier User Notice';
  NID_id_qt_unotice = 165;
  SN_textNotice = 'textNotice';
  NID_textNotice = 293;
  SN_server_auth = 'serverAuth';
  LN_server_auth = 'TLS Web Server Authentication';
  NID_server_auth = 129;
  SN_client_auth = 'clientAuth';
  LN_client_auth = 'TLS Web Client Authentication';
  NID_client_auth = 130;
  SN_code_sign = 'codeSigning';
  LN_code_sign = 'Code Signing';
  NID_code_sign = 131;
  SN_email_protect = 'emailProtection';
  LN_email_protect = 'E-mail Protection';
  NID_email_protect = 132;
  SN_ipsecEndSystem = 'ipsecEndSystem';
  LN_ipsecEndSystem = 'IPSec End System';
  NID_ipsecEndSystem = 294;
  SN_ipsecTunnel = 'ipsecTunnel';
  LN_ipsecTunnel = 'IPSec Tunnel';
  NID_ipsecTunnel = 295;
  SN_ipsecUser = 'ipsecUser';
  LN_ipsecUser = 'IPSec User';
  NID_ipsecUser = 296;
  SN_time_stamp = 'timeStamping';
  LN_time_stamp = 'Time Stamping';
  NID_time_stamp = 133;
  SN_OCSP_sign = 'OCSPSigning';
  LN_OCSP_sign = 'OCSP Signing';
  NID_OCSP_sign = 180;
  SN_dvcs = 'DVCS';
  LN_dvcs = 'dvcs';
  NID_dvcs = 297;
  SN_ipsec_IKE = 'ipsecIKE';
  LN_ipsec_IKE = 'ipsec Internet Key Exchange';
  NID_ipsec_IKE = 1022;
  SN_capwapAC = 'capwapAC';
  LN_capwapAC = 'Ctrl/provision WAP Access';
  NID_capwapAC = 1023;
  SN_capwapWTP = 'capwapWTP';
  LN_capwapWTP = 'Ctrl/Provision WAP Termination';
  NID_capwapWTP = 1024;
  SN_sshClient = 'secureShellClient';
  LN_sshClient = 'SSH Client';
  NID_sshClient = 1025;
  SN_sshServer = 'secureShellServer';
  LN_sshServer = 'SSH Server';
  NID_sshServer = 1026;
  SN_sendRouter = 'sendRouter';
  LN_sendRouter = 'Send Router';
  NID_sendRouter = 1027;
  SN_sendProxiedRouter = 'sendProxiedRouter';
  LN_sendProxiedRouter = 'Send Proxied Router';
  NID_sendProxiedRouter = 1028;
  SN_sendOwner = 'sendOwner';
  LN_sendOwner = 'Send Owner';
  NID_sendOwner = 1029;
  SN_sendProxiedOwner = 'sendProxiedOwner';
  LN_sendProxiedOwner = 'Send Proxied Owner';
  NID_sendProxiedOwner = 1030;
  SN_cmcCA = 'cmcCA';
  LN_cmcCA = 'CMC Certificate Authority';
  NID_cmcCA = 1131;
  SN_cmcRA = 'cmcRA';
  LN_cmcRA = 'CMC Registration Authority';
  NID_cmcRA = 1132;
  SN_id_it_caProtEncCert = 'id-it-caProtEncCert';
  NID_id_it_caProtEncCert = 298;
  SN_id_it_signKeyPairTypes = 'id-it-signKeyPairTypes';
  NID_id_it_signKeyPairTypes = 299;
  SN_id_it_encKeyPairTypes = 'id-it-encKeyPairTypes';
  NID_id_it_encKeyPairTypes = 300;
  SN_id_it_preferredSymmAlg = 'id-it-preferredSymmAlg';
  NID_id_it_preferredSymmAlg = 301;
  SN_id_it_caKeyUpdateInfo = 'id-it-caKeyUpdateInfo';
  NID_id_it_caKeyUpdateInfo = 302;
  SN_id_it_currentCRL = 'id-it-currentCRL';
  NID_id_it_currentCRL = 303;
  SN_id_it_unsupportedOIDs = 'id-it-unsupportedOIDs';
  NID_id_it_unsupportedOIDs = 304;
  SN_id_it_subscriptionRequest = 'id-it-subscriptionRequest';
  NID_id_it_subscriptionRequest = 305;
  SN_id_it_subscriptionResponse = 'id-it-subscriptionResponse';
  NID_id_it_subscriptionResponse = 306;
  SN_id_it_keyPairParamReq = 'id-it-keyPairParamReq';
  NID_id_it_keyPairParamReq = 307;
  SN_id_it_keyPairParamRep = 'id-it-keyPairParamRep';
  NID_id_it_keyPairParamRep = 308;
  SN_id_it_revPassphrase = 'id-it-revPassphrase';
  NID_id_it_revPassphrase = 309;
  SN_id_it_implicitConfirm = 'id-it-implicitConfirm';
  NID_id_it_implicitConfirm = 310;
  SN_id_it_confirmWaitTime = 'id-it-confirmWaitTime';
  NID_id_it_confirmWaitTime = 311;
  SN_id_it_origPKIMessage = 'id-it-origPKIMessage';
  NID_id_it_origPKIMessage = 312;
  SN_id_it_suppLangTags = 'id-it-suppLangTags';
  NID_id_it_suppLangTags = 784;
  SN_id_regCtrl = 'id-regCtrl';
  NID_id_regCtrl = 313;
  SN_id_regInfo = 'id-regInfo';
  NID_id_regInfo = 314;
  SN_id_regCtrl_regToken = 'id-regCtrl-regToken';
  NID_id_regCtrl_regToken = 315;
  SN_id_regCtrl_authenticator = 'id-regCtrl-authenticator';
  NID_id_regCtrl_authenticator = 316;
  SN_id_regCtrl_pkiPublicationInfo = 'id-regCtrl-pkiPublicationInfo';
  NID_id_regCtrl_pkiPublicationInfo = 317;
  SN_id_regCtrl_pkiArchiveOptions = 'id-regCtrl-pkiArchiveOptions';
  NID_id_regCtrl_pkiArchiveOptions = 318;
  SN_id_regCtrl_oldCertID = 'id-regCtrl-oldCertID';
  NID_id_regCtrl_oldCertID = 319;
  SN_id_regCtrl_protocolEncrKey = 'id-regCtrl-protocolEncrKey';
  NID_id_regCtrl_protocolEncrKey = 320;
  SN_id_regInfo_utf8Pairs = 'id-regInfo-utf8Pairs';
  NID_id_regInfo_utf8Pairs = 321;
  SN_id_regInfo_certReq = 'id-regInfo-certReq';
  NID_id_regInfo_certReq = 322;
  SN_id_alg_des40 = 'id-alg-des40';
  NID_id_alg_des40 = 323;
  SN_id_alg_noSignature = 'id-alg-noSignature';
  NID_id_alg_noSignature = 324;
  SN_id_alg_dh_sig_hmac_sha1 = 'id-alg-dh-sig-hmac-sha1';
  NID_id_alg_dh_sig_hmac_sha1 = 325;
  SN_id_alg_dh_pop = 'id-alg-dh-pop';
  NID_id_alg_dh_pop = 326;
  SN_id_cmc_statusInfo = 'id-cmc-statusInfo';
  NID_id_cmc_statusInfo = 327;
  SN_id_cmc_identification = 'id-cmc-identification';
  NID_id_cmc_identification = 328;
  SN_id_cmc_identityProof = 'id-cmc-identityProof';
  NID_id_cmc_identityProof = 329;
  SN_id_cmc_dataReturn = 'id-cmc-dataReturn';
  NID_id_cmc_dataReturn = 330;
  SN_id_cmc_transactionId = 'id-cmc-transactionId';
  NID_id_cmc_transactionId = 331;
  SN_id_cmc_senderNonce = 'id-cmc-senderNonce';
  NID_id_cmc_senderNonce = 332;
  SN_id_cmc_recipientNonce = 'id-cmc-recipientNonce';
  NID_id_cmc_recipientNonce = 333;
  SN_id_cmc_addExtensions = 'id-cmc-addExtensions';
  NID_id_cmc_addExtensions = 334;
  SN_id_cmc_encryptedPOP = 'id-cmc-encryptedPOP';
  NID_id_cmc_encryptedPOP = 335;
  SN_id_cmc_decryptedPOP = 'id-cmc-decryptedPOP';
  NID_id_cmc_decryptedPOP = 336;
  SN_id_cmc_lraPOPWitness = 'id-cmc-lraPOPWitness';
  NID_id_cmc_lraPOPWitness = 337;
  SN_id_cmc_getCert = 'id-cmc-getCert';
  NID_id_cmc_getCert = 338;
  SN_id_cmc_getCRL = 'id-cmc-getCRL';
  NID_id_cmc_getCRL = 339;
  SN_id_cmc_revokeRequest = 'id-cmc-revokeRequest';
  NID_id_cmc_revokeRequest = 340;
  SN_id_cmc_regInfo = 'id-cmc-regInfo';
  NID_id_cmc_regInfo = 341;
  SN_id_cmc_responseInfo = 'id-cmc-responseInfo';
  NID_id_cmc_responseInfo = 342;
  SN_id_cmc_queryPending = 'id-cmc-queryPending';
  NID_id_cmc_queryPending = 343;
  SN_id_cmc_popLinkRandom = 'id-cmc-popLinkRandom';
  NID_id_cmc_popLinkRandom = 344;
  SN_id_cmc_popLinkWitness = 'id-cmc-popLinkWitness';
  NID_id_cmc_popLinkWitness = 345;
  SN_id_cmc_confirmCertAcceptance = 'id-cmc-confirmCertAcceptance';
  NID_id_cmc_confirmCertAcceptance = 346;
  SN_id_on_personalData = 'id-on-personalData';
  NID_id_on_personalData = 347;
  SN_id_on_permanentIdentifier = 'id-on-permanentIdentifier';
  LN_id_on_permanentIdentifier = 'Permanent Identifier';
  NID_id_on_permanentIdentifier = 858;
  SN_id_pda_dateOfBirth = 'id-pda-dateOfBirth';
  NID_id_pda_dateOfBirth = 348;
  SN_id_pda_placeOfBirth = 'id-pda-placeOfBirth';
  NID_id_pda_placeOfBirth = 349;
  SN_id_pda_gender = 'id-pda-gender';
  NID_id_pda_gender = 351;
  SN_id_pda_countryOfCitizenship = 'id-pda-countryOfCitizenship';
  NID_id_pda_countryOfCitizenship = 352;
  SN_id_pda_countryOfResidence = 'id-pda-countryOfResidence';
  NID_id_pda_countryOfResidence = 353;
  SN_id_aca_authenticationInfo = 'id-aca-authenticationInfo';
  NID_id_aca_authenticationInfo = 354;
  SN_id_aca_accessIdentity = 'id-aca-accessIdentity';
  NID_id_aca_accessIdentity = 355;
  SN_id_aca_chargingIdentity = 'id-aca-chargingIdentity';
  NID_id_aca_chargingIdentity = 356;
  SN_id_aca_group = 'id-aca-group';
  NID_id_aca_group = 357;
  SN_id_aca_role = 'id-aca-role';
  NID_id_aca_role = 358;
  SN_id_aca_encAttrs = 'id-aca-encAttrs';
  NID_id_aca_encAttrs = 399;
  SN_id_qcs_pkixQCSyntax_v1 = 'id-qcs-pkixQCSyntax-v1';
  NID_id_qcs_pkixQCSyntax_v1 = 359;
  SN_id_cct_crs = 'id-cct-crs';
  NID_id_cct_crs = 360;
  SN_id_cct_PKIData = 'id-cct-PKIData';
  NID_id_cct_PKIData = 361;
  SN_id_cct_PKIResponse = 'id-cct-PKIResponse';
  NID_id_cct_PKIResponse = 362;
  SN_id_ppl_anyLanguage = 'id-ppl-anyLanguage';
  LN_id_ppl_anyLanguage = 'Any language';
  NID_id_ppl_anyLanguage = 664;
  SN_id_ppl_inheritAll = 'id-ppl-inheritAll';
  LN_id_ppl_inheritAll = 'Inherit all';
  NID_id_ppl_inheritAll = 665;
  SN_Independent = 'id-ppl-independent';
  LN_Independent = 'Independent';
  NID_Independent = 667;
  SN_ad_OCSP = 'OCSP';
  LN_ad_OCSP = 'OCSP';
  NID_ad_OCSP = 178;
  SN_ad_ca_issuers = 'caIssuers';
  LN_ad_ca_issuers = 'CA Issuers';
  NID_ad_ca_issuers = 179;
  SN_ad_timeStamping = 'ad_timestamping';
  LN_ad_timeStamping = 'AD Time Stamping';
  NID_ad_timeStamping = 363;
  SN_ad_dvcs = 'AD_DVCS';
  LN_ad_dvcs = 'ad dvcs';
  NID_ad_dvcs = 364;
  SN_caRepository = 'caRepository';
  LN_caRepository = 'CA Repository';
  NID_caRepository = 785;
  SN_id_pkix_OCSP_basic = 'basicOCSPResponse';
  LN_id_pkix_OCSP_basic = 'Basic OCSP Response';
  NID_id_pkix_OCSP_basic = 365;
  SN_id_pkix_OCSP_Nonce = 'Nonce';
  LN_id_pkix_OCSP_Nonce = 'OCSP Nonce';
  NID_id_pkix_OCSP_Nonce = 366;
  SN_id_pkix_OCSP_CrlID = 'CrlID';
  LN_id_pkix_OCSP_CrlID = 'OCSP CRL ID';
  NID_id_pkix_OCSP_CrlID = 367;
  SN_id_pkix_OCSP_acceptableResponses = 'acceptableResponses';
  LN_id_pkix_OCSP_acceptableResponses = 'Acceptable OCSP Responses';
  NID_id_pkix_OCSP_acceptableResponses = 368;
  SN_id_pkix_OCSP_noCheck = 'noCheck';
  LN_id_pkix_OCSP_noCheck = 'OCSP No Check';
  NID_id_pkix_OCSP_noCheck = 369;
  SN_id_pkix_OCSP_archiveCutoff = 'archiveCutoff';
  LN_id_pkix_OCSP_archiveCutoff = 'OCSP Archive Cutoff';
  NID_id_pkix_OCSP_archiveCutoff = 370;
  SN_id_pkix_OCSP_serviceLocator = 'serviceLocator';
  LN_id_pkix_OCSP_serviceLocator = 'OCSP Service Locator';
  NID_id_pkix_OCSP_serviceLocator = 371;
  SN_id_pkix_OCSP_extendedStatus = 'extendedStatus';
  LN_id_pkix_OCSP_extendedStatus = 'Extended OCSP Status';
  NID_id_pkix_OCSP_extendedStatus = 372;
  SN_id_pkix_OCSP_valid = 'valid';
  NID_id_pkix_OCSP_valid = 373;
  SN_id_pkix_OCSP_path = 'path';
  NID_id_pkix_OCSP_path = 374;
  SN_id_pkix_OCSP_trustRoot = 'trustRoot';
  LN_id_pkix_OCSP_trustRoot = 'Trust Root';
  NID_id_pkix_OCSP_trustRoot = 375;
  SN_algorithm = 'algorithm';
  LN_algorithm = 'algorithm';
  NID_algorithm = 376;
  SN_md5WithRSA = 'RSA-NP-MD5';
  LN_md5WithRSA = 'md5WithRSA';
  NID_md5WithRSA = 104;
  SN_des_ecb = 'DES-ECB';
  LN_des_ecb = 'des-ecb';
  NID_des_ecb = 29;
  SN_des_cbc = 'DES-CBC';
  LN_des_cbc = 'des-cbc';
  NID_des_cbc = 31;
  SN_des_ofb64 = 'DES-OFB';
  LN_des_ofb64 = 'des-ofb';
  NID_des_ofb64 = 45;
  SN_des_cfb64 = 'DES-CFB';
  LN_des_cfb64 = 'des-cfb';
  NID_des_cfb64 = 30;
  SN_rsaSignature = 'rsaSignature';
  NID_rsaSignature = 377;
  SN_dsa_2 = 'DSA-old';
  LN_dsa_2 = 'dsaEncryption-old';
  NID_dsa_2 = 67;
  SN_dsaWithSHA = 'DSA-SHA';
  LN_dsaWithSHA = 'dsaWithSHA';
  NID_dsaWithSHA = 66;
  SN_shaWithRSAEncryption = 'RSA-SHA';
  LN_shaWithRSAEncryption = 'shaWithRSAEncryption';
  NID_shaWithRSAEncryption = 42;
  SN_des_ede_ecb = 'DES-EDE';
  LN_des_ede_ecb = 'des-ede';
  NID_des_ede_ecb = 32;
  SN_des_ede3_ecb = 'DES-EDE3';
  LN_des_ede3_ecb = 'des-ede3';
  NID_des_ede3_ecb = 33;
  SN_des_ede_cbc = 'DES-EDE-CBC';
  LN_des_ede_cbc = 'des-ede-cbc';
  NID_des_ede_cbc = 43;
  SN_des_ede_cfb64 = 'DES-EDE-CFB';
  LN_des_ede_cfb64 = 'des-ede-cfb';
  NID_des_ede_cfb64 = 60;
  SN_des_ede3_cfb64 = 'DES-EDE3-CFB';
  LN_des_ede3_cfb64 = 'des-ede3-cfb';
  NID_des_ede3_cfb64 = 61;
  SN_des_ede_ofb64 = 'DES-EDE-OFB';
  LN_des_ede_ofb64 = 'des-ede-ofb';
  NID_des_ede_ofb64 = 62;
  SN_des_ede3_ofb64 = 'DES-EDE3-OFB';
  LN_des_ede3_ofb64 = 'des-ede3-ofb';
  NID_des_ede3_ofb64 = 63;
  SN_desx_cbc = 'DESX-CBC';
  LN_desx_cbc = 'desx-cbc';
  NID_desx_cbc = 80;
  SN_sha = 'SHA';
  LN_sha = 'sha';
  NID_sha = 41;
  SN_sha1 = 'SHA1';
  LN_sha1 = 'sha1';
  //NID_sha1 = 64;
  SN_dsaWithSHA1_2 = 'DSA-SHA1-old';
  LN_dsaWithSHA1_2 = 'dsaWithSHA1-old';
  NID_dsaWithSHA1_2 = 70;
  SN_sha1WithRSA = 'RSA-SHA1-2';
  LN_sha1WithRSA = 'sha1WithRSA';
  NID_sha1WithRSA = 115;
  SN_ripemd160 = 'RIPEMD160';
  LN_ripemd160 = 'ripemd160';
  NID_ripemd160 = 117;
  SN_ripemd160WithRSA = 'RSA-RIPEMD160';
  LN_ripemd160WithRSA = 'ripemd160WithRSA';
  NID_ripemd160WithRSA = 119;
  SN_blake2b512 = 'BLAKE2b512';
  LN_blake2b512 = 'blake2b512';
  NID_blake2b512 = 1056;
  SN_blake2s256 = 'BLAKE2s256';
  LN_blake2s256 = 'blake2s256';
  NID_blake2s256 = 1057;
  SN_sxnet = 'SXNetID';
  LN_sxnet = 'Strong Extranet ID';
  NID_sxnet = 143;
  SN_X500 = 'X500';
  LN_X500 = 'directory services (X.500)';
  NID_X500 = 11;
  SN_X509 = 'X509';
  NID_X509 = 12;
  SN_commonName = 'CN';
  LN_commonName = 'commonName';
  NID_commonName = 13;
  SN_surname = 'SN';
  LN_surname = 'surname';
  NID_surname = 100;
  LN_serialNumber = 'serialNumber';
  NID_serialNumber = 105;
  SN_countryName = 'C';
  LN_countryName = 'countryName';
  NID_countryName = 14;
  SN_localityName = 'L';
  LN_localityName = 'localityName';
  NID_localityName = 15;
  SN_stateOrProvinceName = 'ST';
  LN_stateOrProvinceName = 'stateOrProvinceName';
  NID_stateOrProvinceName = 16;
  SN_streetAddress = 'street';
  LN_streetAddress = 'streetAddress';
  NID_streetAddress = 660;
  SN_organizationName = 'O';
  LN_organizationName = 'organizationName';
  NID_organizationName = 17;
  SN_organizationalUnitName = 'OU';
  LN_organizationalUnitName = 'organizationalUnitName';
  NID_organizationalUnitName = 18;
  SN_title = 'title';
  LN_title = 'title';
  NID_title = 106;
  LN_description = 'description';
  NID_description = 107;
  LN_searchGuide = 'searchGuide';
  NID_searchGuide = 859;
  LN_businessCategory = 'businessCategory';
  NID_businessCategory = 860;
  LN_postalAddress = 'postalAddress';
  NID_postalAddress = 861;
  LN_postalCode = 'postalCode';
  NID_postalCode = 661;
  LN_postOfficeBox = 'postOfficeBox';
  NID_postOfficeBox = 862;
  LN_physicalDeliveryOfficeName = 'physicalDeliveryOfficeName';
  NID_physicalDeliveryOfficeName = 863;
  LN_telephoneNumber = 'telephoneNumber';
  NID_telephoneNumber = 864;
  LN_telexNumber = 'telexNumber';
  NID_telexNumber = 865;
  LN_teletexTerminalIdentifier = 'teletexTerminalIdentifier';
  NID_teletexTerminalIdentifier = 866;
  LN_facsimileTelephoneNumber = 'facsimileTelephoneNumber';
  NID_facsimileTelephoneNumber = 867;
  LN_x121Address = 'x121Address';
  NID_x121Address = 868;
  LN_internationaliSDNNumber = 'internationaliSDNNumber';
  NID_internationaliSDNNumber = 869;
  LN_registeredAddress = 'registeredAddress';
  NID_registeredAddress = 870;
  LN_destinationIndicator = 'destinationIndicator';
  NID_destinationIndicator = 871;
  LN_preferredDeliveryMethod = 'preferredDeliveryMethod';
  NID_preferredDeliveryMethod = 872;
  LN_presentationAddress = 'presentationAddress';
  NID_presentationAddress = 873;
  LN_supportedApplicationContext = 'supportedApplicationContext';
  NID_supportedApplicationContext = 874;
  SN_member = 'member';
  NID_member = 875;
  SN_owner = 'owner';
  NID_owner = 876;
  LN_roleOccupant = 'roleOccupant';
  NID_roleOccupant = 877;
  SN_seeAlso = 'seeAlso';
  NID_seeAlso = 878;
  LN_userPassword = 'userPassword';
  NID_userPassword = 879;
  LN_userCertificate = 'userCertificate';
  NID_userCertificate = 880;
  LN_cACertificate = 'cACertificate';
  NID_cACertificate = 881;
  LN_authorityRevocationList = 'authorityRevocationList';
  NID_authorityRevocationList = 882;
  LN_certificateRevocationList = 'certificateRevocationList';
  NID_certificateRevocationList = 883;
  LN_crossCertificatePair = 'crossCertificatePair';
  NID_crossCertificatePair = 884;
  SN_name = 'name';
  LN_name = 'name';
  NID_name = 173;
  SN_givenName = 'GN';
  LN_givenName = 'givenName';
  NID_givenName = 99;
  SN_initials = 'initials';
  LN_initials = 'initials';
  NID_initials = 101;
  LN_generationQualifier = 'generationQualifier';
  NID_generationQualifier = 509;
  LN_x500UniqueIdentifier = 'x500UniqueIdentifier';
  NID_x500UniqueIdentifier = 503;
  SN_dnQualifier = 'dnQualifier';
  LN_dnQualifier = 'dnQualifier';
  NID_dnQualifier = 174;
  LN_enhancedSearchGuide = 'enhancedSearchGuide';
  NID_enhancedSearchGuide = 885;
  LN_protocolInformation = 'protocolInformation';
  NID_protocolInformation = 886;
  LN_distinguishedName = 'distinguishedName';
  NID_distinguishedName = 887;
  LN_uniqueMember = 'uniqueMember';
  NID_uniqueMember = 888;
  LN_houseIdentifier = 'houseIdentifier';
  NID_houseIdentifier = 889;
  LN_supportedAlgorithms = 'supportedAlgorithms';
  NID_supportedAlgorithms = 890;
  LN_deltaRevocationList = 'deltaRevocationList';
  NID_deltaRevocationList = 891;
  SN_dmdName = 'dmdName';
  NID_dmdName = 892;
  LN_pseudonym = 'pseudonym';
  NID_pseudonym = 510;
  SN_role = 'role';
  LN_role = 'role';
  NID_role = 400;
  LN_organizationIdentifier = 'organizationIdentifier';
  NID_organizationIdentifier = 1089;
  SN_countryCode3c = 'c3';
  LN_countryCode3c = 'countryCode3c';
  NID_countryCode3c = 1090;
  SN_countryCode3n = 'n3';
  LN_countryCode3n = 'countryCode3n';
  NID_countryCode3n = 1091;
  LN_dnsName = 'dnsName';
  NID_dnsName = 1092;
  SN_X500algorithms = 'X500algorithms';
  LN_X500algorithms = 'directory services - algorithms';
  NID_X500algorithms = 378;
  SN_rsa = 'RSA';
  LN_rsa = 'rsa';
  NID_rsa = 19;
  SN_mdc2WithRSA = 'RSA-MDC2';
  LN_mdc2WithRSA = 'mdc2WithRSA';
  NID_mdc2WithRSA = 96;
  SN_mdc2 = 'MDC2';
  LN_mdc2 = 'mdc2';
  NID_mdc2 = 95;
  SN_id_ce = 'id-ce';
  NID_id_ce = 81;
  SN_subject_directory_attributes = 'subjectDirectoryAttributes';
  LN_subject_directory_attributes = 'X509v3 Subject Directory Attributes';
  NID_subject_directory_attributes = 769;
  SN_subject_key_identifier = 'subjectKeyIdentifier';
  LN_subject_key_identifier = 'X509v3 Subject Key Identifier';
  NID_subject_key_identifier = 82;
  SN_key_usage = 'keyUsage';
  LN_key_usage = 'X509v3 Key Usage';
  NID_key_usage = 83;
  SN_private_key_usage_period = 'privateKeyUsagePeriod';
  LN_private_key_usage_period = 'X509v3 Private Key Usage Period';
  NID_private_key_usage_period = 84;
  SN_subject_alt_name = 'subjectAltName';
  LN_subject_alt_name = 'X509v3 Subject Alternative Name';
  NID_subject_alt_name = 85;
  SN_issuer_alt_name = 'issuerAltName';
  LN_issuer_alt_name = 'X509v3 Issuer Alternative Name';
  NID_issuer_alt_name = 86;
  SN_basic_constraints = 'basicConstraints';
  LN_basic_constraints = 'X509v3 Basic Constraints';
  NID_basic_constraints = 87;
  SN_crl_number = 'crlNumber';
  LN_crl_number = 'X509v3 CRL Number';
  NID_crl_number = 88;
  SN_crl_reason = 'CRLReason';
  LN_crl_reason = 'X509v3 CRL Reason Code';
  NID_crl_reason = 141;
  SN_invalidity_date = 'invalidityDate';
  LN_invalidity_date = 'Invalidity Date';
  NID_invalidity_date = 142;
  SN_delta_crl = 'deltaCRL';
  LN_delta_crl = 'X509v3 Delta CRL Indicator';
  NID_delta_crl = 140;
  SN_issuing_distribution_point = 'issuingDistributionPoint';
  LN_issuing_distribution_point = 'X509v3 Issuing Distribution Point';
  NID_issuing_distribution_point = 770;
  SN_certificate_issuer = 'certificateIssuer';
  LN_certificate_issuer = 'X509v3 Certificate Issuer';
  NID_certificate_issuer = 771;
  SN_name_constraints = 'nameConstraints';
  LN_name_constraints = 'X509v3 Name Constraints';
  NID_name_constraints = 666;
  SN_crl_distribution_points = 'crlDistributionPoints';
  LN_crl_distribution_points = 'X509v3 CRL Distribution Points';
  NID_crl_distribution_points = 103;
  SN_certificate_policies = 'certificatePolicies';
  LN_certificate_policies = 'X509v3 Certificate Policies';
  NID_certificate_policies = 89;
  SN_any_policy = 'anyPolicy';
  LN_any_policy = 'X509v3 Any Policy';
  NID_any_policy = 746;
  SN_policy_mappings = 'policyMappings';
  LN_policy_mappings = 'X509v3 Policy Mappings';
  NID_policy_mappings = 747;
  SN_authority_key_identifier = 'authorityKeyIdentifier';
  LN_authority_key_identifier = 'X509v3 Authority Key Identifier';
  NID_authority_key_identifier = 90;
  SN_policy_constraints = 'policyConstraints';
  LN_policy_constraints = 'X509v3 Policy Constraints';
  NID_policy_constraints = 401;
  SN_ext_key_usage = 'extendedKeyUsage';
  LN_ext_key_usage = 'X509v3 Extended Key Usage';
  NID_ext_key_usage = 126;
  SN_freshest_crl = 'freshestCRL';
  LN_freshest_crl = 'X509v3 Freshest CRL';
  NID_freshest_crl = 857;
  SN_inhibit_any_policy = 'inhibitAnyPolicy';
  LN_inhibit_any_policy = 'X509v3 Inhibit Any Policy';
  NID_inhibit_any_policy = 748;
  SN_target_information = 'targetInformation';
  LN_target_information = 'X509v3 AC Targeting';
  NID_target_information = 402;
  SN_no_rev_avail = 'noRevAvail';
  LN_no_rev_avail = 'X509v3 No Revocation Available';
  NID_no_rev_avail = 403;
  SN_anyExtendedKeyUsage = 'anyExtendedKeyUsage';
  LN_anyExtendedKeyUsage = 'Any Extended Key Usage';
  NID_anyExtendedKeyUsage = 910;
  SN_netscape = 'Netscape';
  LN_netscape = 'Netscape Communications Corp.';
  NID_netscape = 57;
  SN_netscape_cert_extension = 'nsCertExt';
  LN_netscape_cert_extension = 'Netscape Certificate Extension';
  NID_netscape_cert_extension = 58;
  SN_netscape_data_type = 'nsDataType';
  LN_netscape_data_type = 'Netscape Data Type';
  NID_netscape_data_type = 59;
  SN_netscape_cert_type = 'nsCertType';
  LN_netscape_cert_type = 'Netscape Cert Type';
  NID_netscape_cert_type = 71;
  SN_netscape_base_url = 'nsBaseUrl';
  LN_netscape_base_url = 'Netscape Base Url';
  NID_netscape_base_url = 72;
  SN_netscape_revocation_url = 'nsRevocationUrl';
  LN_netscape_revocation_url = 'Netscape Revocation Url';
  NID_netscape_revocation_url = 73;
  SN_netscape_ca_revocation_url = 'nsCaRevocationUrl';
  LN_netscape_ca_revocation_url = 'Netscape CA Revocation Url';
  NID_netscape_ca_revocation_url = 74;
  SN_netscape_renewal_url = 'nsRenewalUrl';
  LN_netscape_renewal_url = 'Netscape Renewal Url';
  NID_netscape_renewal_url = 75;
  SN_netscape_ca_policy_url = 'nsCaPolicyUrl';
  LN_netscape_ca_policy_url = 'Netscape CA Policy Url';
  NID_netscape_ca_policy_url = 76;
  SN_netscape_ssl_server_name = 'nsSslServerName';
  LN_netscape_ssl_server_name = 'Netscape SSL Server Name';
  NID_netscape_ssl_server_name = 77;
  SN_netscape_comment = 'nsComment';
  LN_netscape_comment = 'Netscape Comment';
  NID_netscape_comment = 78;
  SN_netscape_cert_sequence = 'nsCertSequence';
  LN_netscape_cert_sequence = 'Netscape Certificate Sequence';
  NID_netscape_cert_sequence = 79;
  SN_ns_sgc = 'nsSGC';
  LN_ns_sgc = 'Netscape Server Gated Crypto';
  NID_ns_sgc = 139;
  SN_org = 'ORG';
  LN_org = 'org';
  NID_org = 379;
  SN_dod = 'DOD';
  LN_dod = 'dod';
  NID_dod = 380;
  SN_iana = 'IANA';
  LN_iana = 'iana';
  NID_iana = 381;
  SN_Directory = 'directory';
  LN_Directory = 'Directory';
  NID_Directory = 382;
  SN_Management = 'mgmt';
  LN_Management = 'Management';
  NID_Management = 383;
  SN_Experimental = 'experimental';
  LN_Experimental = 'Experimental';
  NID_Experimental = 384;
  SN_Private = 'private';
  LN_Private = 'Private';
  NID_Private = 385;
  SN_Security = 'security';
  LN_Security = 'Security';
  NID_Security = 386;
  SN_SNMPv2 = 'snmpv2';
  LN_SNMPv2 = 'SNMPv2';
  NID_SNMPv2 = 387;
  LN_Mail = 'Mail';
  NID_Mail = 388;
  SN_Enterprises = 'enterprises';
  LN_Enterprises = 'Enterprises';
  NID_Enterprises = 389;
  SN_dcObject = 'dcobject';
  LN_dcObject = 'dcObject';
  NID_dcObject = 390;
  SN_mime_mhs = 'mime-mhs';
  LN_mime_mhs = 'MIME MHS';
  NID_mime_mhs = 504;
  SN_mime_mhs_headings = 'mime-mhs-headings';
  LN_mime_mhs_headings = 'mime-mhs-headings';
  NID_mime_mhs_headings = 505;
  SN_mime_mhs_bodies = 'mime-mhs-bodies';
  LN_mime_mhs_bodies = 'mime-mhs-bodies';
  NID_mime_mhs_bodies = 506;
  SN_id_hex_partial_message = 'id-hex-partial-message';
  LN_id_hex_partial_message = 'id-hex-partial-message';
  NID_id_hex_partial_message = 507;
  SN_id_hex_multipart_message = 'id-hex-multipart-message';
  LN_id_hex_multipart_message = 'id-hex-multipart-message';
  NID_id_hex_multipart_message = 508;
  SN_zlib_compression = 'ZLIB';
  LN_zlib_compression = 'zlib compression';
  NID_zlib_compression = 125;
  SN_aes_128_ecb = 'AES-128-ECB';
  LN_aes_128_ecb = 'aes-128-ecb';
  NID_aes_128_ecb = 418;
  SN_aes_128_cbc = 'AES-128-CBC';
  LN_aes_128_cbc = 'aes-128-cbc';
  NID_aes_128_cbc = 419;
  SN_aes_128_ofb128 = 'AES-128-OFB';
  LN_aes_128_ofb128 = 'aes-128-ofb';
  NID_aes_128_ofb128 = 420;
  SN_aes_128_cfb128 = 'AES-128-CFB';
  LN_aes_128_cfb128 = 'aes-128-cfb';
  NID_aes_128_cfb128 = 421;
  SN_id_aes128_wrap = 'id-aes128-wrap';
  NID_id_aes128_wrap = 788;
  SN_aes_128_gcm = 'id-aes128-GCM';
  LN_aes_128_gcm = 'aes-128-gcm';
  NID_aes_128_gcm = 895;
  SN_aes_128_ccm = 'id-aes128-CCM';
  LN_aes_128_ccm = 'aes-128-ccm';
  NID_aes_128_ccm = 896;
  SN_id_aes128_wrap_pad = 'id-aes128-wrap-pad';
  NID_id_aes128_wrap_pad = 897;
  SN_aes_192_ecb = 'AES-192-ECB';
  LN_aes_192_ecb = 'aes-192-ecb';
  NID_aes_192_ecb = 422;
  SN_aes_192_cbc = 'AES-192-CBC';
  LN_aes_192_cbc = 'aes-192-cbc';
  NID_aes_192_cbc = 423;
  SN_aes_192_ofb128 = 'AES-192-OFB';
  LN_aes_192_ofb128 = 'aes-192-ofb';
  NID_aes_192_ofb128 = 424;
  SN_aes_192_cfb128 = 'AES-192-CFB';
  LN_aes_192_cfb128 = 'aes-192-cfb';
  NID_aes_192_cfb128 = 425;
  SN_id_aes192_wrap = 'id-aes192-wrap';
  NID_id_aes192_wrap = 789;
  SN_aes_192_gcm = 'id-aes192-GCM';
  LN_aes_192_gcm = 'aes-192-gcm';
  NID_aes_192_gcm = 898;
  SN_aes_192_ccm = 'id-aes192-CCM';
  LN_aes_192_ccm = 'aes-192-ccm';
  NID_aes_192_ccm = 899;
  SN_id_aes192_wrap_pad = 'id-aes192-wrap-pad';
  NID_id_aes192_wrap_pad = 900;
  SN_aes_256_ecb = 'AES-256-ECB';
  LN_aes_256_ecb = 'aes-256-ecb';
  NID_aes_256_ecb = 426;
  SN_aes_256_cbc = 'AES-256-CBC';
  LN_aes_256_cbc = 'aes-256-cbc';
  NID_aes_256_cbc = 427;
  SN_aes_256_ofb128 = 'AES-256-OFB';
  LN_aes_256_ofb128 = 'aes-256-ofb';
  NID_aes_256_ofb128 = 428;
  SN_aes_256_cfb128 = 'AES-256-CFB';
  LN_aes_256_cfb128 = 'aes-256-cfb';
  NID_aes_256_cfb128 = 429;
  SN_id_aes256_wrap = 'id-aes256-wrap';
  NID_id_aes256_wrap = 790;
  SN_aes_256_gcm = 'id-aes256-GCM';
  LN_aes_256_gcm = 'aes-256-gcm';
  NID_aes_256_gcm = 901;
  SN_aes_256_ccm = 'id-aes256-CCM';
  LN_aes_256_ccm = 'aes-256-ccm';
  NID_aes_256_ccm = 902;
  SN_id_aes256_wrap_pad = 'id-aes256-wrap-pad';
  NID_id_aes256_wrap_pad = 903;
  SN_aes_128_xts = 'AES-128-XTS';
  LN_aes_128_xts = 'aes-128-xts';
  NID_aes_128_xts = 913;
  SN_aes_256_xts = 'AES-256-XTS';
  LN_aes_256_xts = 'aes-256-xts';
  NID_aes_256_xts = 914;
  SN_aes_128_cfb1 = 'AES-128-CFB1';
  LN_aes_128_cfb1 = 'aes-128-cfb1';
  NID_aes_128_cfb1 = 650;
  SN_aes_192_cfb1 = 'AES-192-CFB1';
  LN_aes_192_cfb1 = 'aes-192-cfb1';
  NID_aes_192_cfb1 = 651;
  SN_aes_256_cfb1 = 'AES-256-CFB1';
  LN_aes_256_cfb1 = 'aes-256-cfb1';
  NID_aes_256_cfb1 = 652;
  SN_aes_128_cfb8 = 'AES-128-CFB8';
  LN_aes_128_cfb8 = 'aes-128-cfb8';
  NID_aes_128_cfb8 = 653;
  SN_aes_192_cfb8 = 'AES-192-CFB8';
  LN_aes_192_cfb8 = 'aes-192-cfb8';
  NID_aes_192_cfb8 = 654;
  SN_aes_256_cfb8 = 'AES-256-CFB8';
  LN_aes_256_cfb8 = 'aes-256-cfb8';
  NID_aes_256_cfb8 = 655;
  SN_aes_128_ctr = 'AES-128-CTR';
  LN_aes_128_ctr = 'aes-128-ctr';
  NID_aes_128_ctr = 904;
  SN_aes_192_ctr = 'AES-192-CTR';
  LN_aes_192_ctr = 'aes-192-ctr';
  NID_aes_192_ctr = 905;
  SN_aes_256_ctr = 'AES-256-CTR';
  LN_aes_256_ctr = 'aes-256-ctr';
  NID_aes_256_ctr = 906;
  SN_aes_128_ocb = 'AES-128-OCB';
  LN_aes_128_ocb = 'aes-128-ocb';
  NID_aes_128_ocb = 958;
  SN_aes_192_ocb = 'AES-192-OCB';
  LN_aes_192_ocb = 'aes-192-ocb';
  NID_aes_192_ocb = 959;
  SN_aes_256_ocb = 'AES-256-OCB';
  LN_aes_256_ocb = 'aes-256-ocb';
  NID_aes_256_ocb = 960;
  SN_des_cfb1 = 'DES-CFB1';
  LN_des_cfb1 = 'des-cfb1';
  NID_des_cfb1 = 656;
  SN_des_cfb8 = 'DES-CFB8';
  LN_des_cfb8 = 'des-cfb8';
  NID_des_cfb8 = 657;
  SN_des_ede3_cfb1 = 'DES-EDE3-CFB1';
  LN_des_ede3_cfb1 = 'des-ede3-cfb1';
  NID_des_ede3_cfb1 = 658;
  SN_des_ede3_cfb8 = 'DES-EDE3-CFB8';
  LN_des_ede3_cfb8 = 'des-ede3-cfb8';
  NID_des_ede3_cfb8 = 659;
  SN_sha256 = 'SHA256';
  LN_sha256 = 'sha256';
  NID_sha256 = 672;
  SN_sha384 = 'SHA384';
  LN_sha384 = 'sha384';
  NID_sha384 = 673;
  SN_sha512 = 'SHA512';
  LN_sha512 = 'sha512';
  NID_sha512 = 674;
  SN_sha224 = 'SHA224';
  LN_sha224 = 'sha224';
  NID_sha224 = 675;
  SN_sha512_224 = 'SHA512-224';
  LN_sha512_224 = 'sha512-224';
  NID_sha512_224 = 1094;
  SN_sha512_256 = 'SHA512-256';
  LN_sha512_256 = 'sha512-256';
  NID_sha512_256 = 1095;
  SN_sha3_224 = 'SHA3-224';
  LN_sha3_224 = 'sha3-224';
  NID_sha3_224 = 1096;
  SN_sha3_256 = 'SHA3-256';
  LN_sha3_256 = 'sha3-256';
  NID_sha3_256 = 1097;
  SN_sha3_384 = 'SHA3-384';
  LN_sha3_384 = 'sha3-384';
  NID_sha3_384 = 1098;
  SN_sha3_512 = 'SHA3-512';
  LN_sha3_512 = 'sha3-512';
  NID_sha3_512 = 1099;
  SN_shake128 = 'SHAKE128';
  LN_shake128 = 'shake128';
  NID_shake128 = 1100;
  SN_shake256 = 'SHAKE256';
  LN_shake256 = 'shake256';
  NID_shake256 = 1101;
  SN_hmac_sha3_224 = 'id-hmacWithSHA3-224';
  LN_hmac_sha3_224 = 'hmac-sha3-224';
  NID_hmac_sha3_224 = 1102;
  SN_hmac_sha3_256 = 'id-hmacWithSHA3-256';
  LN_hmac_sha3_256 = 'hmac-sha3-256';
  NID_hmac_sha3_256 = 1103;
  SN_hmac_sha3_384 = 'id-hmacWithSHA3-384';
  LN_hmac_sha3_384 = 'hmac-sha3-384';
  NID_hmac_sha3_384 = 1104;
  SN_hmac_sha3_512 = 'id-hmacWithSHA3-512';
  LN_hmac_sha3_512 = 'hmac-sha3-512';
  NID_hmac_sha3_512 = 1105;
  SN_dsa_with_SHA224 = 'dsa_with_SHA224';
  NID_dsa_with_SHA224 = 802;
  SN_dsa_with_SHA256 = 'dsa_with_SHA256';
  NID_dsa_with_SHA256 = 803;
  SN_dsa_with_SHA384 = 'id-dsa-with-sha384';
  LN_dsa_with_SHA384 = 'dsa_with_SHA384';
  NID_dsa_with_SHA384 = 1106;
  SN_dsa_with_SHA512 = 'id-dsa-with-sha512';
  LN_dsa_with_SHA512 = 'dsa_with_SHA512';
  NID_dsa_with_SHA512 = 1107;
  SN_dsa_with_SHA3_224 = 'id-dsa-with-sha3-224';
  LN_dsa_with_SHA3_224 = 'dsa_with_SHA3-224';
  NID_dsa_with_SHA3_224 = 1108;
  SN_dsa_with_SHA3_256 = 'id-dsa-with-sha3-256';
  LN_dsa_with_SHA3_256 = 'dsa_with_SHA3-256';
  NID_dsa_with_SHA3_256 = 1109;
  SN_dsa_with_SHA3_384 = 'id-dsa-with-sha3-384';
  LN_dsa_with_SHA3_384 = 'dsa_with_SHA3-384';
  NID_dsa_with_SHA3_384 = 1110;
  SN_dsa_with_SHA3_512 = 'id-dsa-with-sha3-512';
  LN_dsa_with_SHA3_512 = 'dsa_with_SHA3-512';
  NID_dsa_with_SHA3_512 = 1111;
  SN_ecdsa_with_SHA3_224 = 'id-ecdsa-with-sha3-224';
  LN_ecdsa_with_SHA3_224 = 'ecdsa_with_SHA3-224';
  NID_ecdsa_with_SHA3_224 = 1112;
  SN_ecdsa_with_SHA3_256 = 'id-ecdsa-with-sha3-256';
  LN_ecdsa_with_SHA3_256 = 'ecdsa_with_SHA3-256';
  NID_ecdsa_with_SHA3_256 = 1113;
  SN_ecdsa_with_SHA3_384 = 'id-ecdsa-with-sha3-384';
  LN_ecdsa_with_SHA3_384 = 'ecdsa_with_SHA3-384';
  NID_ecdsa_with_SHA3_384 = 1114;
  SN_ecdsa_with_SHA3_512 = 'id-ecdsa-with-sha3-512';
  LN_ecdsa_with_SHA3_512 = 'ecdsa_with_SHA3-512';
  NID_ecdsa_with_SHA3_512 = 1115;
  SN_RSA_SHA3_224 = 'id-rsassa-pkcs1-v1_5-with-sha3-224';
  LN_RSA_SHA3_224 = 'RSA-SHA3-224';
  NID_RSA_SHA3_224 = 1116;
  SN_RSA_SHA3_256 = 'id-rsassa-pkcs1-v1_5-with-sha3-256';
  LN_RSA_SHA3_256 = 'RSA-SHA3-256';
  NID_RSA_SHA3_256 = 1117;
  SN_RSA_SHA3_384 = 'id-rsassa-pkcs1-v1_5-with-sha3-384';
  LN_RSA_SHA3_384 = 'RSA-SHA3-384';
  NID_RSA_SHA3_384 = 1118;
  SN_RSA_SHA3_512 = 'id-rsassa-pkcs1-v1_5-with-sha3-512';
  LN_RSA_SHA3_512 = 'RSA-SHA3-512';
  NID_RSA_SHA3_512 = 1119;
  SN_hold_instruction_code = 'holdInstructionCode';
  LN_hold_instruction_code = 'Hold Instruction Code';
  NID_hold_instruction_code = 430;
  SN_hold_instruction_none = 'holdInstructionNone';
  LN_hold_instruction_none = 'Hold Instruction None';
  NID_hold_instruction_none = 431;
  SN_hold_instruction_call_issuer = 'holdInstructionCallIssuer';
  LN_hold_instruction_call_issuer = 'Hold Instruction Call Issuer';
  NID_hold_instruction_call_issuer = 432;
  SN_hold_instruction_reject = 'holdInstructionReject';
  LN_hold_instruction_reject = 'Hold Instruction Reject';
  NID_hold_instruction_reject = 433;
  SN_data = 'data';
  NID_data = 434;
  SN_pss = 'pss';
  NID_pss = 435;
  SN_ucl = 'ucl';
  NID_ucl = 436;
  SN_pilot = 'pilot';
  NID_pilot = 437;
  LN_pilotAttributeType = 'pilotAttributeType';
  NID_pilotAttributeType = 438;
  LN_pilotAttributeSyntax = 'pilotAttributeSyntax';
  NID_pilotAttributeSyntax = 439;
  LN_pilotObjectClass = 'pilotObjectClass';
  NID_pilotObjectClass = 440;
  LN_pilotGroups = 'pilotGroups';
  NID_pilotGroups = 441;
  LN_iA5StringSyntax = 'iA5StringSyntax';
  NID_iA5StringSyntax = 442;
  LN_caseIgnoreIA5StringSyntax = 'caseIgnoreIA5StringSyntax';
  NID_caseIgnoreIA5StringSyntax = 443;
  LN_pilotObject = 'pilotObject';
  NID_pilotObject = 444;
  LN_pilotPerson = 'pilotPerson';
  NID_pilotPerson = 445;
  SN_account = 'account';
  NID_account = 446;
  SN_document = 'document';
  NID_document = 447;
  SN_room = 'room';
  NID_room = 448;
  LN_documentSeries = 'documentSeries';
  NID_documentSeries = 449;
  SN_Domain = 'domain';
  LN_Domain = 'Domain';
  NID_Domain = 392;
  LN_rFC822localPart = 'rFC822localPart';
  NID_rFC822localPart = 450;
  LN_dNSDomain = 'dNSDomain';
  NID_dNSDomain = 451;
  LN_domainRelatedObject = 'domainRelatedObject';
  NID_domainRelatedObject = 452;
  LN_friendlyCountry = 'friendlyCountry';
  NID_friendlyCountry = 453;
  LN_simpleSecurityObject = 'simpleSecurityObject';
  NID_simpleSecurityObject = 454;
  LN_pilotOrganization = 'pilotOrganization';
  NID_pilotOrganization = 455;
  LN_pilotDSA = 'pilotDSA';
  NID_pilotDSA = 456;
  LN_qualityLabelledData = 'qualityLabelledData';
  NID_qualityLabelledData = 457;
  SN_userId = 'UID';
  LN_userId = 'userId';
  NID_userId = 458;
  LN_textEncodedORAddress = 'textEncodedORAddress';
  NID_textEncodedORAddress = 459;
  SN_rfc822Mailbox = 'mail';
  LN_rfc822Mailbox = 'rfc822Mailbox';
  NID_rfc822Mailbox = 460;
  SN_info = 'info';
  NID_info = 461;
  LN_favouriteDrink = 'favouriteDrink';
  NID_favouriteDrink = 462;
  LN_roomNumber = 'roomNumber';
  NID_roomNumber = 463;
  SN_photo = 'photo';
  NID_photo = 464;
  LN_userClass = 'userClass';
  NID_userClass = 465;
  SN_host = 'host';
  NID_host = 466;
  SN_manager = 'manager';
  NID_manager = 467;
  LN_documentIdentifier = 'documentIdentifier';
  NID_documentIdentifier = 468;
  LN_documentTitle = 'documentTitle';
  NID_documentTitle = 469;
  LN_documentVersion = 'documentVersion';
  NID_documentVersion = 470;
  LN_documentAuthor = 'documentAuthor';
  NID_documentAuthor = 471;
  LN_documentLocation = 'documentLocation';
  NID_documentLocation = 472;
  LN_homeTelephoneNumber = 'homeTelephoneNumber';
  NID_homeTelephoneNumber = 473;
  SN_secretary = 'secretary';
  NID_secretary = 474;
  LN_otherMailbox = 'otherMailbox';
  NID_otherMailbox = 475;
  LN_lastModifiedTime = 'lastModifiedTime';
  NID_lastModifiedTime = 476;
  LN_lastModifiedBy = 'lastModifiedBy';
  NID_lastModifiedBy = 477;
  SN_domainComponent = 'DC';
  LN_domainComponent = 'domainComponent';
  NID_domainComponent = 391;
  LN_aRecord = 'aRecord';
  NID_aRecord = 478;
  LN_pilotAttributeType27 = 'pilotAttributeType27';
  NID_pilotAttributeType27 = 479;
  LN_mXRecord = 'mXRecord';
  NID_mXRecord = 480;
  LN_nSRecord = 'nSRecord';
  NID_nSRecord = 481;
  LN_sOARecord = 'sOARecord';
  NID_sOARecord = 482;
  LN_cNAMERecord = 'cNAMERecord';
  NID_cNAMERecord = 483;
  LN_associatedDomain = 'associatedDomain';
  NID_associatedDomain = 484;
  LN_associatedName = 'associatedName';
  NID_associatedName = 485;
  LN_homePostalAddress = 'homePostalAddress';
  NID_homePostalAddress = 486;
  LN_personalTitle = 'personalTitle';
  NID_personalTitle = 487;
  LN_mobileTelephoneNumber = 'mobileTelephoneNumber';
  NID_mobileTelephoneNumber = 488;
  LN_pagerTelephoneNumber = 'pagerTelephoneNumber';
  NID_pagerTelephoneNumber = 489;
  LN_friendlyCountryName = 'friendlyCountryName';
  NID_friendlyCountryName = 490;
  SN_uniqueIdentifier = 'uid';
  LN_uniqueIdentifier = 'uniqueIdentifier';
  NID_uniqueIdentifier = 102;
  LN_organizationalStatus = 'organizationalStatus';
  NID_organizationalStatus = 491;
  LN_janetMailbox = 'janetMailbox';
  NID_janetMailbox = 492;
  LN_mailPreferenceOption = 'mailPreferenceOption';
  NID_mailPreferenceOption = 493;
  LN_buildingName = 'buildingName';
  NID_buildingName = 494;
  LN_dSAQuality = 'dSAQuality';
  NID_dSAQuality = 495;
  LN_singleLevelQuality = 'singleLevelQuality';
  NID_singleLevelQuality = 496;
  LN_subtreeMinimumQuality = 'subtreeMinimumQuality';
  NID_subtreeMinimumQuality = 497;
  LN_subtreeMaximumQuality = 'subtreeMaximumQuality';
  NID_subtreeMaximumQuality = 498;
  LN_personalSignature = 'personalSignature';
  NID_personalSignature = 499;
  LN_dITRedirect = 'dITRedirect';
  NID_dITRedirect = 500;
  SN_audio = 'audio';
  NID_audio = 501;
  LN_documentPublisher = 'documentPublisher';
  NID_documentPublisher = 502;
  SN_id_set = 'id-set';
  LN_id_set = 'Secure Electronic Transactions';
  NID_id_set = 512;
  SN_set_ctype = 'set-ctype';
  LN_set_ctype = 'content types';
  NID_set_ctype = 513;
  SN_set_msgExt = 'set-msgExt';
  LN_set_msgExt = 'message extensions';
  NID_set_msgExt = 514;
  SN_set_attr = 'set-attr';
  NID_set_attr = 515;
  SN_set_policy = 'set-policy';
  NID_set_policy = 516;
  SN_set_certExt = 'set-certExt';
  LN_set_certExt = 'certificate extensions';
  NID_set_certExt = 517;
  SN_set_brand = 'set-brand';
  NID_set_brand = 518;
  SN_setct_PANData = 'setct-PANData';
  NID_setct_PANData = 519;
  SN_setct_PANToken = 'setct-PANToken';
  NID_setct_PANToken = 520;
  SN_setct_PANOnly = 'setct-PANOnly';
  NID_setct_PANOnly = 521;
  SN_setct_OIData = 'setct-OIData';
  NID_setct_OIData = 522;
  SN_setct_PI = 'setct-PI';
  NID_setct_PI = 523;
  SN_setct_PIData = 'setct-PIData';
  NID_setct_PIData = 524;
  SN_setct_PIDataUnsigned = 'setct-PIDataUnsigned';
  NID_setct_PIDataUnsigned = 525;
  SN_setct_HODInput = 'setct-HODInput';
  NID_setct_HODInput = 526;
  SN_setct_AuthResBaggage = 'setct-AuthResBaggage';
  NID_setct_AuthResBaggage = 527;
  SN_setct_AuthRevReqBaggage = 'setct-AuthRevReqBaggage';
  NID_setct_AuthRevReqBaggage = 528;
  SN_setct_AuthRevResBaggage = 'setct-AuthRevResBaggage';
  NID_setct_AuthRevResBaggage = 529;
  SN_setct_CapTokenSeq = 'setct-CapTokenSeq';
  NID_setct_CapTokenSeq = 530;
  SN_setct_PInitResData = 'setct-PInitResData';
  NID_setct_PInitResData = 531;
  SN_setct_PI_TBS = 'setct-PI-TBS';
  NID_setct_PI_TBS = 532;
  SN_setct_PResData = 'setct-PResData';
  NID_setct_PResData = 533;
  SN_setct_AuthReqTBS = 'setct-AuthReqTBS';
  NID_setct_AuthReqTBS = 534;
  SN_setct_AuthResTBS = 'setct-AuthResTBS';
  NID_setct_AuthResTBS = 535;
  SN_setct_AuthResTBSX = 'setct-AuthResTBSX';
  NID_setct_AuthResTBSX = 536;
  SN_setct_AuthTokenTBS = 'setct-AuthTokenTBS';
  NID_setct_AuthTokenTBS = 537;
  SN_setct_CapTokenData = 'setct-CapTokenData';
  NID_setct_CapTokenData = 538;
  SN_setct_CapTokenTBS = 'setct-CapTokenTBS';
  NID_setct_CapTokenTBS = 539;
  SN_setct_AcqCardCodeMsg = 'setct-AcqCardCodeMsg';
  NID_setct_AcqCardCodeMsg = 540;
  SN_setct_AuthRevReqTBS = 'setct-AuthRevReqTBS';
  NID_setct_AuthRevReqTBS = 541;
  SN_setct_AuthRevResData = 'setct-AuthRevResData';
  NID_setct_AuthRevResData = 542;
  SN_setct_AuthRevResTBS = 'setct-AuthRevResTBS';
  NID_setct_AuthRevResTBS = 543;
  SN_setct_CapReqTBS = 'setct-CapReqTBS';
  NID_setct_CapReqTBS = 544;
  SN_setct_CapReqTBSX = 'setct-CapReqTBSX';
  NID_setct_CapReqTBSX = 545;
  SN_setct_CapResData = 'setct-CapResData';
  NID_setct_CapResData = 546;
  SN_setct_CapRevReqTBS = 'setct-CapRevReqTBS';
  NID_setct_CapRevReqTBS = 547;
  SN_setct_CapRevReqTBSX = 'setct-CapRevReqTBSX';
  NID_setct_CapRevReqTBSX = 548;
  SN_setct_CapRevResData = 'setct-CapRevResData';
  NID_setct_CapRevResData = 549;
  SN_setct_CredReqTBS = 'setct-CredReqTBS';
  NID_setct_CredReqTBS = 550;
  SN_setct_CredReqTBSX = 'setct-CredReqTBSX';
  NID_setct_CredReqTBSX = 551;
  SN_setct_CredResData = 'setct-CredResData';
  NID_setct_CredResData = 552;
  SN_setct_CredRevReqTBS = 'setct-CredRevReqTBS';
  NID_setct_CredRevReqTBS = 553;
  SN_setct_CredRevReqTBSX = 'setct-CredRevReqTBSX';
  NID_setct_CredRevReqTBSX = 554;
  SN_setct_CredRevResData = 'setct-CredRevResData';
  NID_setct_CredRevResData = 555;
  SN_setct_PCertReqData = 'setct-PCertReqData';
  NID_setct_PCertReqData = 556;
  SN_setct_PCertResTBS = 'setct-PCertResTBS';
  NID_setct_PCertResTBS = 557;
  SN_setct_BatchAdminReqData = 'setct-BatchAdminReqData';
  NID_setct_BatchAdminReqData = 558;
  SN_setct_BatchAdminResData = 'setct-BatchAdminResData';
  NID_setct_BatchAdminResData = 559;
  SN_setct_CardCInitResTBS = 'setct-CardCInitResTBS';
  NID_setct_CardCInitResTBS = 560;
  SN_setct_MeAqCInitResTBS = 'setct-MeAqCInitResTBS';
  NID_setct_MeAqCInitResTBS = 561;
  SN_setct_RegFormResTBS = 'setct-RegFormResTBS';
  NID_setct_RegFormResTBS = 562;
  SN_setct_CertReqData = 'setct-CertReqData';
  NID_setct_CertReqData = 563;
  SN_setct_CertReqTBS = 'setct-CertReqTBS';
  NID_setct_CertReqTBS = 564;
  SN_setct_CertResData = 'setct-CertResData';
  NID_setct_CertResData = 565;
  SN_setct_CertInqReqTBS = 'setct-CertInqReqTBS';
  NID_setct_CertInqReqTBS = 566;
  SN_setct_ErrorTBS = 'setct-ErrorTBS';
  NID_setct_ErrorTBS = 567;
  SN_setct_PIDualSignedTBE = 'setct-PIDualSignedTBE';
  NID_setct_PIDualSignedTBE = 568;
  SN_setct_PIUnsignedTBE = 'setct-PIUnsignedTBE';
  NID_setct_PIUnsignedTBE = 569;
  SN_setct_AuthReqTBE = 'setct-AuthReqTBE';
  NID_setct_AuthReqTBE = 570;
  SN_setct_AuthResTBE = 'setct-AuthResTBE';
  NID_setct_AuthResTBE = 571;
  SN_setct_AuthResTBEX = 'setct-AuthResTBEX';
  NID_setct_AuthResTBEX = 572;
  SN_setct_AuthTokenTBE = 'setct-AuthTokenTBE';
  NID_setct_AuthTokenTBE = 573;
  SN_setct_CapTokenTBE = 'setct-CapTokenTBE';
  NID_setct_CapTokenTBE = 574;
  SN_setct_CapTokenTBEX = 'setct-CapTokenTBEX';
  NID_setct_CapTokenTBEX = 575;
  SN_setct_AcqCardCodeMsgTBE = 'setct-AcqCardCodeMsgTBE';
  NID_setct_AcqCardCodeMsgTBE = 576;
  SN_setct_AuthRevReqTBE = 'setct-AuthRevReqTBE';
  NID_setct_AuthRevReqTBE = 577;
  SN_setct_AuthRevResTBE = 'setct-AuthRevResTBE';
  NID_setct_AuthRevResTBE = 578;
  SN_setct_AuthRevResTBEB = 'setct-AuthRevResTBEB';
  NID_setct_AuthRevResTBEB = 579;
  SN_setct_CapReqTBE = 'setct-CapReqTBE';
  NID_setct_CapReqTBE = 580;
  SN_setct_CapReqTBEX = 'setct-CapReqTBEX';
  NID_setct_CapReqTBEX = 581;
  SN_setct_CapResTBE = 'setct-CapResTBE';
  NID_setct_CapResTBE = 582;
  SN_setct_CapRevReqTBE = 'setct-CapRevReqTBE';
  NID_setct_CapRevReqTBE = 583;
  SN_setct_CapRevReqTBEX = 'setct-CapRevReqTBEX';
  NID_setct_CapRevReqTBEX = 584;
  SN_setct_CapRevResTBE = 'setct-CapRevResTBE';
  NID_setct_CapRevResTBE = 585;
  SN_setct_CredReqTBE = 'setct-CredReqTBE';
  NID_setct_CredReqTBE = 586;
  SN_setct_CredReqTBEX = 'setct-CredReqTBEX';
  NID_setct_CredReqTBEX = 587;
  SN_setct_CredResTBE = 'setct-CredResTBE';
  NID_setct_CredResTBE = 588;
  SN_setct_CredRevReqTBE = 'setct-CredRevReqTBE';
  NID_setct_CredRevReqTBE = 589;
  SN_setct_CredRevReqTBEX = 'setct-CredRevReqTBEX';
  NID_setct_CredRevReqTBEX = 590;
  SN_setct_CredRevResTBE = 'setct-CredRevResTBE';
  NID_setct_CredRevResTBE = 591;
  SN_setct_BatchAdminReqTBE = 'setct-BatchAdminReqTBE';
  NID_setct_BatchAdminReqTBE = 592;
  SN_setct_BatchAdminResTBE = 'setct-BatchAdminResTBE';
  NID_setct_BatchAdminResTBE = 593;
  SN_setct_RegFormReqTBE = 'setct-RegFormReqTBE';
  NID_setct_RegFormReqTBE = 594;
  SN_setct_CertReqTBE = 'setct-CertReqTBE';
  NID_setct_CertReqTBE = 595;
  SN_setct_CertReqTBEX = 'setct-CertReqTBEX';
  NID_setct_CertReqTBEX = 596;
  SN_setct_CertResTBE = 'setct-CertResTBE';
  NID_setct_CertResTBE = 597;
  SN_setct_CRLNotificationTBS = 'setct-CRLNotificationTBS';
  NID_setct_CRLNotificationTBS = 598;
  SN_setct_CRLNotificationResTBS = 'setct-CRLNotificationResTBS';
  NID_setct_CRLNotificationResTBS = 599;
  SN_setct_BCIDistributionTBS = 'setct-BCIDistributionTBS';
  NID_setct_BCIDistributionTBS = 600;
  SN_setext_genCrypt = 'setext-genCrypt';
  LN_setext_genCrypt = 'generic cryptogram';
  NID_setext_genCrypt = 601;
  SN_setext_miAuth = 'setext-miAuth';
  LN_setext_miAuth = 'merchant initiated auth';
  NID_setext_miAuth = 602;
  SN_setext_pinSecure = 'setext-pinSecure';
  NID_setext_pinSecure = 603;
  SN_setext_pinAny = 'setext-pinAny';
  NID_setext_pinAny = 604;
  SN_setext_track2 = 'setext-track2';
  NID_setext_track2 = 605;
  SN_setext_cv = 'setext-cv';
  LN_setext_cv = 'additional verification';
  NID_setext_cv = 606;
  SN_set_policy_root = 'set-policy-root';
  NID_set_policy_root = 607;
  SN_setCext_hashedRoot = 'setCext-hashedRoot';
  NID_setCext_hashedRoot = 608;
  SN_setCext_certType = 'setCext-certType';
  NID_setCext_certType = 609;
  SN_setCext_merchData = 'setCext-merchData';
  NID_setCext_merchData = 610;
  SN_setCext_cCertRequired = 'setCext-cCertRequired';
  NID_setCext_cCertRequired = 611;
  SN_setCext_tunneling = 'setCext-tunneling';
  NID_setCext_tunneling = 612;
  SN_setCext_setExt = 'setCext-setExt';
  NID_setCext_setExt = 613;
  SN_setCext_setQualf = 'setCext-setQualf';
  NID_setCext_setQualf = 614;
  SN_setCext_PGWYcapabilities = 'setCext-PGWYcapabilities';
  NID_setCext_PGWYcapabilities = 615;
  SN_setCext_TokenIdentifier = 'setCext-TokenIdentifier';
  NID_setCext_TokenIdentifier = 616;
  SN_setCext_Track2Data = 'setCext-Track2Data';
  NID_setCext_Track2Data = 617;
  SN_setCext_TokenType = 'setCext-TokenType';
  NID_setCext_TokenType = 618;
  SN_setCext_IssuerCapabilities = 'setCext-IssuerCapabilities';
  NID_setCext_IssuerCapabilities = 619;
  SN_setAttr_Cert = 'setAttr-Cert';
  NID_setAttr_Cert = 620;
  SN_setAttr_PGWYcap = 'setAttr-PGWYcap';
  LN_setAttr_PGWYcap = 'payment gateway capabilities';
  NID_setAttr_PGWYcap = 621;
  SN_setAttr_TokenType = 'setAttr-TokenType';
  NID_setAttr_TokenType = 622;
  SN_setAttr_IssCap = 'setAttr-IssCap';
  LN_setAttr_IssCap = 'issuer capabilities';
  NID_setAttr_IssCap = 623;
  SN_set_rootKeyThumb = 'set-rootKeyThumb';
  NID_set_rootKeyThumb = 624;
  SN_set_addPolicy = 'set-addPolicy';
  NID_set_addPolicy = 625;
  SN_setAttr_Token_EMV = 'setAttr-Token-EMV';
  NID_setAttr_Token_EMV = 626;
  SN_setAttr_Token_B0Prime = 'setAttr-Token-B0Prime';
  NID_setAttr_Token_B0Prime = 627;
  SN_setAttr_IssCap_CVM = 'setAttr-IssCap-CVM';
  NID_setAttr_IssCap_CVM = 628;
  SN_setAttr_IssCap_T2 = 'setAttr-IssCap-T2';
  NID_setAttr_IssCap_T2 = 629;
  SN_setAttr_IssCap_Sig = 'setAttr-IssCap-Sig';
  NID_setAttr_IssCap_Sig = 630;
  SN_setAttr_GenCryptgrm = 'setAttr-GenCryptgrm';
  LN_setAttr_GenCryptgrm = 'generate cryptogram';
  NID_setAttr_GenCryptgrm = 631;
  SN_setAttr_T2Enc = 'setAttr-T2Enc';
  LN_setAttr_T2Enc = 'encrypted track 2';
  NID_setAttr_T2Enc = 632;
  SN_setAttr_T2cleartxt = 'setAttr-T2cleartxt';
  LN_setAttr_T2cleartxt = 'cleartext track 2';
  NID_setAttr_T2cleartxt = 633;
  SN_setAttr_TokICCsig = 'setAttr-TokICCsig';
  LN_setAttr_TokICCsig = 'ICC or token signature';
  NID_setAttr_TokICCsig = 634;
  SN_setAttr_SecDevSig = 'setAttr-SecDevSig';
  LN_setAttr_SecDevSig = 'secure device signature';
  NID_setAttr_SecDevSig = 635;
  SN_set_brand_IATA_ATA = 'set-brand-IATA-ATA';
  NID_set_brand_IATA_ATA = 636;
  SN_set_brand_Diners = 'set-brand-Diners';
  NID_set_brand_Diners = 637;
  SN_set_brand_AmericanExpress = 'set-brand-AmericanExpress';
  NID_set_brand_AmericanExpress = 638;
  SN_set_brand_JCB = 'set-brand-JCB';
  NID_set_brand_JCB = 639;
  SN_set_brand_Visa = 'set-brand-Visa';
  NID_set_brand_Visa = 640;
  SN_set_brand_MasterCard = 'set-brand-MasterCard';
  NID_set_brand_MasterCard = 641;
  SN_set_brand_Novus = 'set-brand-Novus';
  NID_set_brand_Novus = 642;
  SN_des_cdmf = 'DES-CDMF';
  LN_des_cdmf = 'des-cdmf';
  NID_des_cdmf = 643;
  SN_rsaOAEPEncryptionSET = 'rsaOAEPEncryptionSET';
  NID_rsaOAEPEncryptionSET = 644;
  SN_ipsec3 = 'Oakley-EC2N-3';
  LN_ipsec3 = 'ipsec3';
  NID_ipsec3 = 749;
  SN_ipsec4 = 'Oakley-EC2N-4';
  LN_ipsec4 = 'ipsec4';
  NID_ipsec4 = 750;
  SN_whirlpool = 'whirlpool';
  NID_whirlpool = 804;
  SN_cryptopro = 'cryptopro';
  NID_cryptopro = 805;
  SN_cryptocom = 'cryptocom';
  NID_cryptocom = 806;
  SN_id_tc26 = 'id-tc26';
  NID_id_tc26 = 974;
  SN_id_GostR3411_94_with_GostR3410_2001 = 'id-GostR3411-94-with-GostR3410-2001';
  LN_id_GostR3411_94_with_GostR3410_2001 = 'GOST R 34.11-94 with GOST R 34.10-2001';
  NID_id_GostR3411_94_with_GostR3410_2001 = 807;
  SN_id_GostR3411_94_with_GostR3410_94 = 'id-GostR3411-94-with-GostR3410-94';
  LN_id_GostR3411_94_with_GostR3410_94 = 'GOST R 34.11-94 with GOST R 34.10-94';
  NID_id_GostR3411_94_with_GostR3410_94 = 808;
  SN_id_GostR3411_94 = 'md_gost94';
  LN_id_GostR3411_94 = 'GOST R 34.11-94';
  NID_id_GostR3411_94 = 809;
  SN_id_HMACGostR3411_94 = 'id-HMACGostR3411-94';
  LN_id_HMACGostR3411_94 = 'HMAC GOST 34.11-94';
  NID_id_HMACGostR3411_94 = 810;
  SN_id_GostR3410_2001 = 'gost2001';
  LN_id_GostR3410_2001 = 'GOST R 34.10-2001';
  NID_id_GostR3410_2001 = 811;
  SN_id_GostR3410_94 = 'gost94';
  LN_id_GostR3410_94 = 'GOST R 34.10-94';
  NID_id_GostR3410_94 = 812;
  SN_id_Gost28147_89 = 'gost89';
  LN_id_Gost28147_89 = 'GOST 28147-89';
  NID_id_Gost28147_89 = 813;
  SN_gost89_cnt = 'gost89-cnt';
  NID_gost89_cnt = 814;
  SN_gost89_cnt_12 = 'gost89-cnt-12';
  NID_gost89_cnt_12 = 975;
  SN_gost89_cbc = 'gost89-cbc';
  NID_gost89_cbc = 1009;
  SN_gost89_ecb = 'gost89-ecb';
  NID_gost89_ecb = 1010;
  SN_gost89_ctr = 'gost89-ctr';
  NID_gost89_ctr = 1011;
  SN_id_Gost28147_89_MAC = 'gost-mac';
  LN_id_Gost28147_89_MAC = 'GOST 28147-89 MAC';
  NID_id_Gost28147_89_MAC = 815;
  SN_gost_mac_12 = 'gost-mac-12';
  NID_gost_mac_12 = 976;
  SN_id_GostR3411_94_prf = 'prf-gostr3411-94';
  LN_id_GostR3411_94_prf = 'GOST R 34.11-94 PRF';
  NID_id_GostR3411_94_prf = 816;
  SN_id_GostR3410_2001DH = 'id-GostR3410-2001DH';
  LN_id_GostR3410_2001DH = 'GOST R 34.10-2001 DH';
  NID_id_GostR3410_2001DH = 817;
  SN_id_GostR3410_94DH = 'id-GostR3410-94DH';
  LN_id_GostR3410_94DH = 'GOST R 34.10-94 DH';
  NID_id_GostR3410_94DH = 818;
  SN_id_Gost28147_89_CryptoPro_KeyMeshing = 'id-Gost28147-89-CryptoPro-KeyMeshing';
  NID_id_Gost28147_89_CryptoPro_KeyMeshing = 819;
  SN_id_Gost28147_89_None_KeyMeshing = 'id-Gost28147-89-None-KeyMeshing';
  NID_id_Gost28147_89_None_KeyMeshing = 820;
  SN_id_GostR3411_94_TestParamSet = 'id-GostR3411-94-TestParamSet';
  NID_id_GostR3411_94_TestParamSet = 821;
  SN_id_GostR3411_94_CryptoProParamSet = 'id-GostR3411-94-CryptoProParamSet';
  NID_id_GostR3411_94_CryptoProParamSet = 822;
  SN_id_Gost28147_89_TestParamSet = 'id-Gost28147-89-TestParamSet';
  NID_id_Gost28147_89_TestParamSet = 823;
  SN_id_Gost28147_89_CryptoPro_A_ParamSet = 'id-Gost28147-89-CryptoPro-A-ParamSet';
  NID_id_Gost28147_89_CryptoPro_A_ParamSet = 824;
  SN_id_Gost28147_89_CryptoPro_B_ParamSet = 'id-Gost28147-89-CryptoPro-B-ParamSet';
  NID_id_Gost28147_89_CryptoPro_B_ParamSet = 825;
  SN_id_Gost28147_89_CryptoPro_C_ParamSet = 'id-Gost28147-89-CryptoPro-C-ParamSet';
  NID_id_Gost28147_89_CryptoPro_C_ParamSet = 826;
  SN_id_Gost28147_89_CryptoPro_D_ParamSet = 'id-Gost28147-89-CryptoPro-D-ParamSet';
  NID_id_Gost28147_89_CryptoPro_D_ParamSet = 827;
  SN_id_Gost28147_89_CryptoPro_Oscar_1_1_ParamSet = 'id-Gost28147-89-CryptoPro-Oscar-1-1-ParamSet';
  NID_id_Gost28147_89_CryptoPro_Oscar_1_1_ParamSet = 828;
  SN_id_Gost28147_89_CryptoPro_Oscar_1_0_ParamSet = 'id-Gost28147-89-CryptoPro-Oscar-1-0-ParamSet';
  NID_id_Gost28147_89_CryptoPro_Oscar_1_0_ParamSet = 829;
  SN_id_Gost28147_89_CryptoPro_RIC_1_ParamSet = 'id-Gost28147-89-CryptoPro-RIC-1-ParamSet';
  NID_id_Gost28147_89_CryptoPro_RIC_1_ParamSet = 830;
  SN_id_GostR3410_94_TestParamSet = 'id-GostR3410-94-TestParamSet';
  NID_id_GostR3410_94_TestParamSet = 831;
  SN_id_GostR3410_94_CryptoPro_A_ParamSet = 'id-GostR3410-94-CryptoPro-A-ParamSet';
  NID_id_GostR3410_94_CryptoPro_A_ParamSet = 832;
  SN_id_GostR3410_94_CryptoPro_B_ParamSet = 'id-GostR3410-94-CryptoPro-B-ParamSet';
  NID_id_GostR3410_94_CryptoPro_B_ParamSet = 833;
  SN_id_GostR3410_94_CryptoPro_C_ParamSet = 'id-GostR3410-94-CryptoPro-C-ParamSet';
  NID_id_GostR3410_94_CryptoPro_C_ParamSet = 834;
  SN_id_GostR3410_94_CryptoPro_D_ParamSet = 'id-GostR3410-94-CryptoPro-D-ParamSet';
  NID_id_GostR3410_94_CryptoPro_D_ParamSet = 835;
  SN_id_GostR3410_94_CryptoPro_XchA_ParamSet = 'id-GostR3410-94-CryptoPro-XchA-ParamSet';
  NID_id_GostR3410_94_CryptoPro_XchA_ParamSet = 836;
  SN_id_GostR3410_94_CryptoPro_XchB_ParamSet = 'id-GostR3410-94-CryptoPro-XchB-ParamSet';
  NID_id_GostR3410_94_CryptoPro_XchB_ParamSet = 837;
  SN_id_GostR3410_94_CryptoPro_XchC_ParamSet = 'id-GostR3410-94-CryptoPro-XchC-ParamSet';
  NID_id_GostR3410_94_CryptoPro_XchC_ParamSet = 838;
  SN_id_GostR3410_2001_TestParamSet = 'id-GostR3410-2001-TestParamSet';
  NID_id_GostR3410_2001_TestParamSet = 839;
  SN_id_GostR3410_2001_CryptoPro_A_ParamSet = 'id-GostR3410-2001-CryptoPro-A-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_A_ParamSet = 840;
  SN_id_GostR3410_2001_CryptoPro_B_ParamSet = 'id-GostR3410-2001-CryptoPro-B-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_B_ParamSet = 841;
  SN_id_GostR3410_2001_CryptoPro_C_ParamSet = 'id-GostR3410-2001-CryptoPro-C-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_C_ParamSet = 842;
  SN_id_GostR3410_2001_CryptoPro_XchA_ParamSet = 'id-GostR3410-2001-CryptoPro-XchA-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_XchA_ParamSet = 843;
  SN_id_GostR3410_2001_CryptoPro_XchB_ParamSet = 'id-GostR3410-2001-CryptoPro-XchB-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_XchB_ParamSet = 844;
  SN_id_GostR3410_94_a = 'id-GostR3410-94-a';
  NID_id_GostR3410_94_a = 845;
  SN_id_GostR3410_94_aBis = 'id-GostR3410-94-aBis';
  NID_id_GostR3410_94_aBis = 846;
  SN_id_GostR3410_94_b = 'id-GostR3410-94-b';
  NID_id_GostR3410_94_b = 847;
  SN_id_GostR3410_94_bBis = 'id-GostR3410-94-bBis';
  NID_id_GostR3410_94_bBis = 848;
  SN_id_Gost28147_89_cc = 'id-Gost28147-89-cc';
  LN_id_Gost28147_89_cc = 'GOST 28147-89 Cryptocom ParamSet';
  NID_id_Gost28147_89_cc = 849;
  SN_id_GostR3410_94_cc = 'gost94cc';
  LN_id_GostR3410_94_cc = 'GOST 34.10-94 Cryptocom';
  NID_id_GostR3410_94_cc = 850;
  SN_id_GostR3410_2001_cc = 'gost2001cc';
  LN_id_GostR3410_2001_cc = 'GOST 34.10-2001 Cryptocom';
  NID_id_GostR3410_2001_cc = 851;
  SN_id_GostR3411_94_with_GostR3410_94_cc = 'id-GostR3411-94-with-GostR3410-94-cc';
  LN_id_GostR3411_94_with_GostR3410_94_cc = 'GOST R 34.11-94 with GOST R 34.10-94 Cryptocom';
  NID_id_GostR3411_94_with_GostR3410_94_cc = 852;
  SN_id_GostR3411_94_with_GostR3410_2001_cc = 'id-GostR3411-94-with-GostR3410-2001-cc';
  LN_id_GostR3411_94_with_GostR3410_2001_cc = 'GOST R 34.11-94 with GOST R 34.10-2001 Cryptocom';
  NID_id_GostR3411_94_with_GostR3410_2001_cc = 853;
  SN_id_GostR3410_2001_ParamSet_cc = 'id-GostR3410-2001-ParamSet-cc';
  LN_id_GostR3410_2001_ParamSet_cc = 'GOST R 3410-2001 Parameter Set Cryptocom';
  NID_id_GostR3410_2001_ParamSet_cc = 854;
  SN_id_tc26_algorithms = 'id-tc26-algorithms';
  NID_id_tc26_algorithms = 977;
  SN_id_tc26_sign = 'id-tc26-sign';
  NID_id_tc26_sign = 978;
  SN_id_GostR3410_2012_256 = 'gost2012_256';
  LN_id_GostR3410_2012_256 = 'GOST R 34.10-2012 with 256 bit modulus';
  NID_id_GostR3410_2012_256 = 979;
  SN_id_GostR3410_2012_512 = 'gost2012_512';
  LN_id_GostR3410_2012_512 = 'GOST R 34.10-2012 with 512 bit modulus';
  NID_id_GostR3410_2012_512 = 980;
  SN_id_tc26_digest = 'id-tc26-digest';
  NID_id_tc26_digest = 981;
  SN_id_GostR3411_2012_256 = 'md_gost12_256';
  LN_id_GostR3411_2012_256 = 'GOST R 34.11-2012 with 256 bit hash';
  NID_id_GostR3411_2012_256 = 982;
  SN_id_GostR3411_2012_512 = 'md_gost12_512';
  LN_id_GostR3411_2012_512 = 'GOST R 34.11-2012 with 512 bit hash';
  NID_id_GostR3411_2012_512 = 983;
  SN_id_tc26_signwithdigest = 'id-tc26-signwithdigest';
  NID_id_tc26_signwithdigest = 984;
  SN_id_tc26_signwithdigest_gost3410_2012_256 = 'id-tc26-signwithdigest-gost3410-2012-256';
  LN_id_tc26_signwithdigest_gost3410_2012_256 = 'GOST R 34.10-2012 with GOST R 34.11-2012 (256 bit)';
  NID_id_tc26_signwithdigest_gost3410_2012_256 = 985;
  SN_id_tc26_signwithdigest_gost3410_2012_512 = 'id-tc26-signwithdigest-gost3410-2012-512';
  LN_id_tc26_signwithdigest_gost3410_2012_512 = 'GOST R 34.10-2012 with GOST R 34.11-2012 (512 bit)';
  NID_id_tc26_signwithdigest_gost3410_2012_512 = 986;
  SN_id_tc26_mac = 'id-tc26-mac';
  NID_id_tc26_mac = 987;
  SN_id_tc26_hmac_gost_3411_2012_256 = 'id-tc26-hmac-gost-3411-2012-256';
  LN_id_tc26_hmac_gost_3411_2012_256 = 'HMAC GOST 34.11-2012 256 bit';
  NID_id_tc26_hmac_gost_3411_2012_256 = 988;
  SN_id_tc26_hmac_gost_3411_2012_512 = 'id-tc26-hmac-gost-3411-2012-512';
  LN_id_tc26_hmac_gost_3411_2012_512 = 'HMAC GOST 34.11-2012 512 bit';
  NID_id_tc26_hmac_gost_3411_2012_512 = 989;
  SN_id_tc26_cipher = 'id-tc26-cipher';
  NID_id_tc26_cipher = 990;
  SN_id_tc26_cipher_gostr3412_2015_magma = 'id-tc26-cipher-gostr3412-2015-magma';
  NID_id_tc26_cipher_gostr3412_2015_magma = 1173;
  SN_id_tc26_cipher_gostr3412_2015_magma_ctracpkm = 'id-tc26-cipher-gostr3412-2015-magma-ctracpkm';
  NID_id_tc26_cipher_gostr3412_2015_magma_ctracpkm = 1174;
  SN_id_tc26_cipher_gostr3412_2015_magma_ctracpkm_omac = 'id-tc26-cipher-gostr3412-2015-magma-ctracpkm-omac';
  NID_id_tc26_cipher_gostr3412_2015_magma_ctracpkm_omac = 1175;
  SN_id_tc26_cipher_gostr3412_2015_kuznyechik = 'id-tc26-cipher-gostr3412-2015-kuznyechik';
  NID_id_tc26_cipher_gostr3412_2015_kuznyechik = 1176;
  SN_id_tc26_cipher_gostr3412_2015_kuznyechik_ctracpkm = 'id-tc26-cipher-gostr3412-2015-kuznyechik-ctracpkm';
  NID_id_tc26_cipher_gostr3412_2015_kuznyechik_ctracpkm = 1177;
  SN_id_tc26_cipher_gostr3412_2015_kuznyechik_ctracpkm_omac = 'id-tc26-cipher-gostr3412-2015-kuznyechik-ctracpkm-omac';
  NID_id_tc26_cipher_gostr3412_2015_kuznyechik_ctracpkm_omac = 1178;
  SN_id_tc26_agreement = 'id-tc26-agreement';
  NID_id_tc26_agreement = 991;
  SN_id_tc26_agreement_gost_3410_2012_256 = 'id-tc26-agreement-gost-3410-2012-256';
  NID_id_tc26_agreement_gost_3410_2012_256 = 992;
  SN_id_tc26_agreement_gost_3410_2012_512 = 'id-tc26-agreement-gost-3410-2012-512';
  NID_id_tc26_agreement_gost_3410_2012_512 = 993;
  SN_id_tc26_wrap = 'id-tc26-wrap';
  NID_id_tc26_wrap = 1179;
  SN_id_tc26_wrap_gostr3412_2015_magma = 'id-tc26-wrap-gostr3412-2015-magma';
  NID_id_tc26_wrap_gostr3412_2015_magma = 1180;
  SN_id_tc26_wrap_gostr3412_2015_magma_kexp15 = 'id-tc26-wrap-gostr3412-2015-magma-kexp15';
  NID_id_tc26_wrap_gostr3412_2015_magma_kexp15 = 1181;
  SN_id_tc26_wrap_gostr3412_2015_kuznyechik = 'id-tc26-wrap-gostr3412-2015-kuznyechik';
  NID_id_tc26_wrap_gostr3412_2015_kuznyechik = 1182;
  SN_id_tc26_wrap_gostr3412_2015_kuznyechik_kexp15 = 'id-tc26-wrap-gostr3412-2015-kuznyechik-kexp15';
  NID_id_tc26_wrap_gostr3412_2015_kuznyechik_kexp15 = 1183;
  SN_id_tc26_constants = 'id-tc26-constants';
  NID_id_tc26_constants = 994;
  SN_id_tc26_sign_constants = 'id-tc26-sign-constants';
  NID_id_tc26_sign_constants = 995;
  SN_id_tc26_gost_3410_2012_256_constants = 'id-tc26-gost-3410-2012-256-constants';
  NID_id_tc26_gost_3410_2012_256_constants = 1147;
  SN_id_tc26_gost_3410_2012_256_paramSetA = 'id-tc26-gost-3410-2012-256-paramSetA';
  LN_id_tc26_gost_3410_2012_256_paramSetA = 'GOST R 34.10-2012 (256 bit) ParamSet A';
  NID_id_tc26_gost_3410_2012_256_paramSetA = 1148;
  SN_id_tc26_gost_3410_2012_256_paramSetB = 'id-tc26-gost-3410-2012-256-paramSetB';
  LN_id_tc26_gost_3410_2012_256_paramSetB = 'GOST R 34.10-2012 (256 bit) ParamSet B';
  NID_id_tc26_gost_3410_2012_256_paramSetB = 1184;
  SN_id_tc26_gost_3410_2012_256_paramSetC = 'id-tc26-gost-3410-2012-256-paramSetC';
  LN_id_tc26_gost_3410_2012_256_paramSetC = 'GOST R 34.10-2012 (256 bit) ParamSet C';
  NID_id_tc26_gost_3410_2012_256_paramSetC = 1185;
  SN_id_tc26_gost_3410_2012_256_paramSetD = 'id-tc26-gost-3410-2012-256-paramSetD';
  LN_id_tc26_gost_3410_2012_256_paramSetD = 'GOST R 34.10-2012 (256 bit) ParamSet D';
  NID_id_tc26_gost_3410_2012_256_paramSetD = 1186;
  SN_id_tc26_gost_3410_2012_512_constants = 'id-tc26-gost-3410-2012-512-constants';
  NID_id_tc26_gost_3410_2012_512_constants = 996;
  SN_id_tc26_gost_3410_2012_512_paramSetTest = 'id-tc26-gost-3410-2012-512-paramSetTest';
  LN_id_tc26_gost_3410_2012_512_paramSetTest = 'GOST R 34.10-2012 (512 bit) testing parameter set';
  NID_id_tc26_gost_3410_2012_512_paramSetTest = 997;
  SN_id_tc26_gost_3410_2012_512_paramSetA = 'id-tc26-gost-3410-2012-512-paramSetA';
  LN_id_tc26_gost_3410_2012_512_paramSetA = 'GOST R 34.10-2012 (512 bit) ParamSet A';
  NID_id_tc26_gost_3410_2012_512_paramSetA = 998;
  SN_id_tc26_gost_3410_2012_512_paramSetB = 'id-tc26-gost-3410-2012-512-paramSetB';
  LN_id_tc26_gost_3410_2012_512_paramSetB = 'GOST R 34.10-2012 (512 bit) ParamSet B';
  NID_id_tc26_gost_3410_2012_512_paramSetB = 999;
  SN_id_tc26_gost_3410_2012_512_paramSetC = 'id-tc26-gost-3410-2012-512-paramSetC';
  LN_id_tc26_gost_3410_2012_512_paramSetC = 'GOST R 34.10-2012 (512 bit) ParamSet C';
  NID_id_tc26_gost_3410_2012_512_paramSetC = 1149;
  SN_id_tc26_digest_constants = 'id-tc26-digest-constants';
  NID_id_tc26_digest_constants = 1000;
  SN_id_tc26_cipher_constants = 'id-tc26-cipher-constants';
  NID_id_tc26_cipher_constants = 1001;
  SN_id_tc26_gost_28147_constants = 'id-tc26-gost-28147-constants';
  NID_id_tc26_gost_28147_constants = 1002;
  SN_id_tc26_gost_28147_param_Z = 'id-tc26-gost-28147-param-Z';
  LN_id_tc26_gost_28147_param_Z = 'GOST 28147-89 TC26 parameter set';
  NID_id_tc26_gost_28147_param_Z = 1003;
  SN_INN = 'INN';
  LN_INN = 'INN';
  NID_INN = 1004;
  SN_OGRN = 'OGRN';
  LN_OGRN = 'OGRN';
  NID_OGRN = 1005;
  SN_SNILS = 'SNILS';
  LN_SNILS = 'SNILS';
  NID_SNILS = 1006;
  SN_subjectSignTool = 'subjectSignTool';
  LN_subjectSignTool = 'Signing Tool of Subject';
  NID_subjectSignTool = 1007;
  SN_issuerSignTool = 'issuerSignTool';
  LN_issuerSignTool = 'Signing Tool of Issuer';
  NID_issuerSignTool = 1008;
  SN_grasshopper_ecb = 'grasshopper-ecb';
  NID_grasshopper_ecb = 1012;
  SN_grasshopper_ctr = 'grasshopper-ctr';
  NID_grasshopper_ctr = 1013;
  SN_grasshopper_ofb = 'grasshopper-ofb';
  NID_grasshopper_ofb = 1014;
  SN_grasshopper_cbc = 'grasshopper-cbc';
  NID_grasshopper_cbc = 1015;
  SN_grasshopper_cfb = 'grasshopper-cfb';
  NID_grasshopper_cfb = 1016;
  SN_grasshopper_mac = 'grasshopper-mac';
  NID_grasshopper_mac = 1017;
  SN_magma_ecb = 'magma-ecb';
  NID_magma_ecb = 1187;
  SN_magma_ctr = 'magma-ctr';
  NID_magma_ctr = 1188;
  SN_magma_ofb = 'magma-ofb';
  NID_magma_ofb = 1189;
  SN_magma_cbc = 'magma-cbc';
  NID_magma_cbc = 1190;
  SN_magma_cfb = 'magma-cfb';
  NID_magma_cfb = 1191;
  SN_magma_mac = 'magma-mac';
  NID_magma_mac = 1192;
  SN_camellia_128_cbc = 'CAMELLIA-128-CBC';
  LN_camellia_128_cbc = 'camellia-128-cbc';
  NID_camellia_128_cbc = 751;
  SN_camellia_192_cbc = 'CAMELLIA-192-CBC';
  LN_camellia_192_cbc = 'camellia-192-cbc';
  NID_camellia_192_cbc = 752;
  SN_camellia_256_cbc = 'CAMELLIA-256-CBC';
  LN_camellia_256_cbc = 'camellia-256-cbc';
  NID_camellia_256_cbc = 753;
  SN_id_camellia128_wrap = 'id-camellia128-wrap';
  NID_id_camellia128_wrap = 907;
  SN_id_camellia192_wrap = 'id-camellia192-wrap';
  NID_id_camellia192_wrap = 908;
  SN_id_camellia256_wrap = 'id-camellia256-wrap';
  NID_id_camellia256_wrap = 909;
  SN_camellia_128_ecb = 'CAMELLIA-128-ECB';
  LN_camellia_128_ecb = 'camellia-128-ecb';
  NID_camellia_128_ecb = 754;
  SN_camellia_128_ofb128 = 'CAMELLIA-128-OFB';
  LN_camellia_128_ofb128 = 'camellia-128-ofb';
  NID_camellia_128_ofb128 = 766;
  SN_camellia_128_cfb128 = 'CAMELLIA-128-CFB';
  LN_camellia_128_cfb128 = 'camellia-128-cfb';
  NID_camellia_128_cfb128 = 757;
  SN_camellia_128_gcm = 'CAMELLIA-128-GCM';
  LN_camellia_128_gcm = 'camellia-128-gcm';
  NID_camellia_128_gcm = 961;
  SN_camellia_128_ccm = 'CAMELLIA-128-CCM';
  LN_camellia_128_ccm = 'camellia-128-ccm';
  NID_camellia_128_ccm = 962;
  SN_camellia_128_ctr = 'CAMELLIA-128-CTR';
  LN_camellia_128_ctr = 'camellia-128-ctr';
  NID_camellia_128_ctr = 963;
  SN_camellia_128_cmac = 'CAMELLIA-128-CMAC';
  LN_camellia_128_cmac = 'camellia-128-cmac';
  NID_camellia_128_cmac = 964;
  SN_camellia_192_ecb = 'CAMELLIA-192-ECB';
  LN_camellia_192_ecb = 'camellia-192-ecb';
  NID_camellia_192_ecb = 755;
  SN_camellia_192_ofb128 = 'CAMELLIA-192-OFB';
  LN_camellia_192_ofb128 = 'camellia-192-ofb';
  NID_camellia_192_ofb128 = 767;
  SN_camellia_192_cfb128 = 'CAMELLIA-192-CFB';
  LN_camellia_192_cfb128 = 'camellia-192-cfb';
  NID_camellia_192_cfb128 = 758;
  SN_camellia_192_gcm = 'CAMELLIA-192-GCM';
  LN_camellia_192_gcm = 'camellia-192-gcm';
  NID_camellia_192_gcm = 965;
  SN_camellia_192_ccm = 'CAMELLIA-192-CCM';
  LN_camellia_192_ccm = 'camellia-192-ccm';
  NID_camellia_192_ccm = 966;
  SN_camellia_192_ctr = 'CAMELLIA-192-CTR';
  LN_camellia_192_ctr = 'camellia-192-ctr';
  NID_camellia_192_ctr = 967;
  SN_camellia_192_cmac = 'CAMELLIA-192-CMAC';
  LN_camellia_192_cmac = 'camellia-192-cmac';
  NID_camellia_192_cmac = 968;
  SN_camellia_256_ecb = 'CAMELLIA-256-ECB';
  LN_camellia_256_ecb = 'camellia-256-ecb';
  NID_camellia_256_ecb = 756;
  SN_camellia_256_ofb128 = 'CAMELLIA-256-OFB';
  LN_camellia_256_ofb128 = 'camellia-256-ofb';
  NID_camellia_256_ofb128 = 768;
  SN_camellia_256_cfb128 = 'CAMELLIA-256-CFB';
  LN_camellia_256_cfb128 = 'camellia-256-cfb';
  NID_camellia_256_cfb128 = 759;
  SN_camellia_256_gcm = 'CAMELLIA-256-GCM';
  LN_camellia_256_gcm = 'camellia-256-gcm';
  NID_camellia_256_gcm = 969;
  SN_camellia_256_ccm = 'CAMELLIA-256-CCM';
  LN_camellia_256_ccm = 'camellia-256-ccm';
  NID_camellia_256_ccm = 970;
  SN_camellia_256_ctr = 'CAMELLIA-256-CTR';
  LN_camellia_256_ctr = 'camellia-256-ctr';
  NID_camellia_256_ctr = 971;
  SN_camellia_256_cmac = 'CAMELLIA-256-CMAC';
  LN_camellia_256_cmac = 'camellia-256-cmac';
  NID_camellia_256_cmac = 972;
  SN_camellia_128_cfb1 = 'CAMELLIA-128-CFB1';
  LN_camellia_128_cfb1 = 'camellia-128-cfb1';
  NID_camellia_128_cfb1 = 760;
  SN_camellia_192_cfb1 = 'CAMELLIA-192-CFB1';
  LN_camellia_192_cfb1 = 'camellia-192-cfb1';
  NID_camellia_192_cfb1 = 761;
  SN_camellia_256_cfb1 = 'CAMELLIA-256-CFB1';
  LN_camellia_256_cfb1 = 'camellia-256-cfb1';
  NID_camellia_256_cfb1 = 762;
  SN_camellia_128_cfb8 = 'CAMELLIA-128-CFB8';
  LN_camellia_128_cfb8 = 'camellia-128-cfb8';
  NID_camellia_128_cfb8 = 763;
  SN_camellia_192_cfb8 = 'CAMELLIA-192-CFB8';
  LN_camellia_192_cfb8 = 'camellia-192-cfb8';
  NID_camellia_192_cfb8 = 764;
  SN_camellia_256_cfb8 = 'CAMELLIA-256-CFB8';
  LN_camellia_256_cfb8 = 'camellia-256-cfb8';
  NID_camellia_256_cfb8 = 765;
  SN_aria_128_ecb = 'ARIA-128-ECB';
  LN_aria_128_ecb = 'aria-128-ecb';
  NID_aria_128_ecb = 1065;
  SN_aria_128_cbc = 'ARIA-128-CBC';
  LN_aria_128_cbc = 'aria-128-cbc';
  NID_aria_128_cbc = 1066;
  SN_aria_128_cfb128 = 'ARIA-128-CFB';
  LN_aria_128_cfb128 = 'aria-128-cfb';
  NID_aria_128_cfb128 = 1067;
  SN_aria_128_ofb128 = 'ARIA-128-OFB';
  LN_aria_128_ofb128 = 'aria-128-ofb';
  NID_aria_128_ofb128 = 1068;
  SN_aria_128_ctr = 'ARIA-128-CTR';
  LN_aria_128_ctr = 'aria-128-ctr';
  NID_aria_128_ctr = 1069;
  SN_aria_192_ecb = 'ARIA-192-ECB';
  LN_aria_192_ecb = 'aria-192-ecb';
  NID_aria_192_ecb = 1070;
  SN_aria_192_cbc = 'ARIA-192-CBC';
  LN_aria_192_cbc = 'aria-192-cbc';
  NID_aria_192_cbc = 1071;
  SN_aria_192_cfb128 = 'ARIA-192-CFB';
  LN_aria_192_cfb128 = 'aria-192-cfb';
  NID_aria_192_cfb128 = 1072;
  SN_aria_192_ofb128 = 'ARIA-192-OFB';
  LN_aria_192_ofb128 = 'aria-192-ofb';
  NID_aria_192_ofb128 = 1073;
  SN_aria_192_ctr = 'ARIA-192-CTR';
  LN_aria_192_ctr = 'aria-192-ctr';
  NID_aria_192_ctr = 1074;
  SN_aria_256_ecb = 'ARIA-256-ECB';
  LN_aria_256_ecb = 'aria-256-ecb';
  NID_aria_256_ecb = 1075;
  SN_aria_256_cbc = 'ARIA-256-CBC';
  LN_aria_256_cbc = 'aria-256-cbc';
  NID_aria_256_cbc = 1076;
  SN_aria_256_cfb128 = 'ARIA-256-CFB';
  LN_aria_256_cfb128 = 'aria-256-cfb';
  NID_aria_256_cfb128 = 1077;
  SN_aria_256_ofb128 = 'ARIA-256-OFB';
  LN_aria_256_ofb128 = 'aria-256-ofb';
  NID_aria_256_ofb128 = 1078;
  SN_aria_256_ctr = 'ARIA-256-CTR';
  LN_aria_256_ctr = 'aria-256-ctr';
  NID_aria_256_ctr = 1079;
  SN_aria_128_cfb1 = 'ARIA-128-CFB1';
  LN_aria_128_cfb1 = 'aria-128-cfb1';
  NID_aria_128_cfb1 = 1080;
  SN_aria_192_cfb1 = 'ARIA-192-CFB1';
  LN_aria_192_cfb1 = 'aria-192-cfb1';
  NID_aria_192_cfb1 = 1081;
  SN_aria_256_cfb1 = 'ARIA-256-CFB1';
  LN_aria_256_cfb1 = 'aria-256-cfb1';
  NID_aria_256_cfb1 = 1082;
  SN_aria_128_cfb8 = 'ARIA-128-CFB8';
  LN_aria_128_cfb8 = 'aria-128-cfb8';
  NID_aria_128_cfb8 = 1083;
  SN_aria_192_cfb8 = 'ARIA-192-CFB8';
  LN_aria_192_cfb8 = 'aria-192-cfb8';
  NID_aria_192_cfb8 = 1084;
  SN_aria_256_cfb8 = 'ARIA-256-CFB8';
  LN_aria_256_cfb8 = 'aria-256-cfb8';
  NID_aria_256_cfb8 = 1085;
  SN_aria_128_ccm = 'ARIA-128-CCM';
  LN_aria_128_ccm = 'aria-128-ccm';
  NID_aria_128_ccm = 1120;
  SN_aria_192_ccm = 'ARIA-192-CCM';
  LN_aria_192_ccm = 'aria-192-ccm';
  NID_aria_192_ccm = 1121;
  SN_aria_256_ccm = 'ARIA-256-CCM';
  LN_aria_256_ccm = 'aria-256-ccm';
  NID_aria_256_ccm = 1122;
  SN_aria_128_gcm = 'ARIA-128-GCM';
  LN_aria_128_gcm = 'aria-128-gcm';
  NID_aria_128_gcm = 1123;
  SN_aria_192_gcm = 'ARIA-192-GCM';
  LN_aria_192_gcm = 'aria-192-gcm';
  NID_aria_192_gcm = 1124;
  SN_aria_256_gcm = 'ARIA-256-GCM';
  LN_aria_256_gcm = 'aria-256-gcm';
  NID_aria_256_gcm = 1125;
  SN_kisa = 'KISA';
  LN_kisa = 'kisa';
  NID_kisa = 773;
  SN_seed_ecb = 'SEED-ECB';
  LN_seed_ecb = 'seed-ecb';
  NID_seed_ecb = 776;
  SN_seed_cbc = 'SEED-CBC';
  LN_seed_cbc = 'seed-cbc';
  NID_seed_cbc = 777;
  SN_seed_cfb128 = 'SEED-CFB';
  LN_seed_cfb128 = 'seed-cfb';
  NID_seed_cfb128 = 779;
  SN_seed_ofb128 = 'SEED-OFB';
  LN_seed_ofb128 = 'seed-ofb';
  NID_seed_ofb128 = 778;
  SN_sm4_ecb = 'SM4-ECB';
  LN_sm4_ecb = 'sm4-ecb';
  NID_sm4_ecb = 1133;
  SN_sm4_cbc = 'SM4-CBC';
  LN_sm4_cbc = 'sm4-cbc';
  NID_sm4_cbc = 1134;
  SN_sm4_ofb128 = 'SM4-OFB';
  LN_sm4_ofb128 = 'sm4-ofb';
  NID_sm4_ofb128 = 1135;
  SN_sm4_cfb128 = 'SM4-CFB';
  LN_sm4_cfb128 = 'sm4-cfb';
  NID_sm4_cfb128 = 1137;
  SN_sm4_cfb1 = 'SM4-CFB1';
  LN_sm4_cfb1 = 'sm4-cfb1';
  NID_sm4_cfb1 = 1136;
  SN_sm4_cfb8 = 'SM4-CFB8';
  LN_sm4_cfb8 = 'sm4-cfb8';
  NID_sm4_cfb8 = 1138;
  SN_sm4_ctr = 'SM4-CTR';
  LN_sm4_ctr = 'sm4-ctr';
  NID_sm4_ctr = 1139;
  SN_hmac = 'HMAC';
  LN_hmac = 'hmac';
  NID_hmac = 855;
  SN_cmac = 'CMAC';
  LN_cmac = 'cmac';
  NID_cmac = 894;
  SN_rc4_hmac_md5 = 'RC4-HMAC-MD5';
  LN_rc4_hmac_md5 = 'rc4-hmac-md5';
  NID_rc4_hmac_md5 = 915;
  SN_aes_128_cbc_hmac_sha1 = 'AES-128-CBC-HMAC-SHA1';
  LN_aes_128_cbc_hmac_sha1 = 'aes-128-cbc-hmac-sha1';
  NID_aes_128_cbc_hmac_sha1 = 916;
  SN_aes_192_cbc_hmac_sha1 = 'AES-192-CBC-HMAC-SHA1';
  LN_aes_192_cbc_hmac_sha1 = 'aes-192-cbc-hmac-sha1';
  NID_aes_192_cbc_hmac_sha1 = 917;
  SN_aes_256_cbc_hmac_sha1 = 'AES-256-CBC-HMAC-SHA1';
  LN_aes_256_cbc_hmac_sha1 = 'aes-256-cbc-hmac-sha1';
  NID_aes_256_cbc_hmac_sha1 = 918;
  SN_aes_128_cbc_hmac_sha256 = 'AES-128-CBC-HMAC-SHA256';
  LN_aes_128_cbc_hmac_sha256 = 'aes-128-cbc-hmac-sha256';
  NID_aes_128_cbc_hmac_sha256 = 948;
  SN_aes_192_cbc_hmac_sha256 = 'AES-192-CBC-HMAC-SHA256';
  LN_aes_192_cbc_hmac_sha256 = 'aes-192-cbc-hmac-sha256';
  NID_aes_192_cbc_hmac_sha256 = 949;
  SN_aes_256_cbc_hmac_sha256 = 'AES-256-CBC-HMAC-SHA256';
  LN_aes_256_cbc_hmac_sha256 = 'aes-256-cbc-hmac-sha256';
  NID_aes_256_cbc_hmac_sha256 = 950;
  SN_chacha20_poly1305 = 'ChaCha20-Poly1305';
  LN_chacha20_poly1305 = 'chacha20-poly1305';
  NID_chacha20_poly1305 = 1018;
  SN_chacha20 = 'ChaCha20';
  LN_chacha20 = 'chacha20';
  NID_chacha20 = 1019;
  SN_dhpublicnumber = 'dhpublicnumber';
  LN_dhpublicnumber = 'X9.42 DH';
  NID_dhpublicnumber = 920;
  SN_brainpoolP160r1 = 'brainpoolP160r1';
  NID_brainpoolP160r1 = 921;
  SN_brainpoolP160t1 = 'brainpoolP160t1';
  NID_brainpoolP160t1 = 922;
  SN_brainpoolP192r1 = 'brainpoolP192r1';
  NID_brainpoolP192r1 = 923;
  SN_brainpoolP192t1 = 'brainpoolP192t1';
  NID_brainpoolP192t1 = 924;
  SN_brainpoolP224r1 = 'brainpoolP224r1';
  NID_brainpoolP224r1 = 925;
  SN_brainpoolP224t1 = 'brainpoolP224t1';
  NID_brainpoolP224t1 = 926;
  SN_brainpoolP256r1 = 'brainpoolP256r1';
  NID_brainpoolP256r1 = 927;
  SN_brainpoolP256t1 = 'brainpoolP256t1';
  NID_brainpoolP256t1 = 928;
  SN_brainpoolP320r1 = 'brainpoolP320r1';
  NID_brainpoolP320r1 = 929;
  SN_brainpoolP320t1 = 'brainpoolP320t1';
  NID_brainpoolP320t1 = 930;
  SN_brainpoolP384r1 = 'brainpoolP384r1';
  NID_brainpoolP384r1 = 931;
  SN_brainpoolP384t1 = 'brainpoolP384t1';
  NID_brainpoolP384t1 = 932;
  SN_brainpoolP512r1 = 'brainpoolP512r1';
  NID_brainpoolP512r1 = 933;
  SN_brainpoolP512t1 = 'brainpoolP512t1';
  NID_brainpoolP512t1 = 934;
  SN_dhSinglePass_stdDH_sha1kdf_scheme = 'dhSinglePass-stdDH-sha1kdf-scheme';
  NID_dhSinglePass_stdDH_sha1kdf_scheme = 936;
  SN_dhSinglePass_stdDH_sha224kdf_scheme = 'dhSinglePass-stdDH-sha224kdf-scheme';
  NID_dhSinglePass_stdDH_sha224kdf_scheme = 937;
  SN_dhSinglePass_stdDH_sha256kdf_scheme = 'dhSinglePass-stdDH-sha256kdf-scheme';
  NID_dhSinglePass_stdDH_sha256kdf_scheme = 938;
  SN_dhSinglePass_stdDH_sha384kdf_scheme = 'dhSinglePass-stdDH-sha384kdf-scheme';
  NID_dhSinglePass_stdDH_sha384kdf_scheme = 939;
  SN_dhSinglePass_stdDH_sha512kdf_scheme = 'dhSinglePass-stdDH-sha512kdf-scheme';
  NID_dhSinglePass_stdDH_sha512kdf_scheme = 940;
  SN_dhSinglePass_cofactorDH_sha1kdf_scheme = 'dhSinglePass-cofactorDH-sha1kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha1kdf_scheme = 941;
  SN_dhSinglePass_cofactorDH_sha224kdf_scheme = 'dhSinglePass-cofactorDH-sha224kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha224kdf_scheme = 942;
  SN_dhSinglePass_cofactorDH_sha256kdf_scheme = 'dhSinglePass-cofactorDH-sha256kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha256kdf_scheme = 943;
  SN_dhSinglePass_cofactorDH_sha384kdf_scheme = 'dhSinglePass-cofactorDH-sha384kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha384kdf_scheme = 944;
  SN_dhSinglePass_cofactorDH_sha512kdf_scheme = 'dhSinglePass-cofactorDH-sha512kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha512kdf_scheme = 945;
  SN_dh_std_kdf = 'dh-std-kdf';
  NID_dh_std_kdf = 946;
  SN_dh_cofactor_kdf = 'dh-cofactor-kdf';
  NID_dh_cofactor_kdf = 947;
  SN_ct_precert_scts = 'ct_precert_scts';
  LN_ct_precert_scts = 'CT Precertificate SCTs';
  NID_ct_precert_scts = 951;
  SN_ct_precert_poison = 'ct_precert_poison';
  LN_ct_precert_poison = 'CT Precertificate Poison';
  NID_ct_precert_poison = 952;
  SN_ct_precert_signer = 'ct_precert_signer';
  LN_ct_precert_signer = 'CT Precertificate Signer';
  NID_ct_precert_signer = 953;
  SN_ct_cert_scts = 'ct_cert_scts';
  LN_ct_cert_scts = 'CT Certificate SCTs';
  NID_ct_cert_scts = 954;
  SN_jurisdictionLocalityName = 'jurisdictionL';
  LN_jurisdictionLocalityName = 'jurisdictionLocalityName';
  NID_jurisdictionLocalityName = 955;
  SN_jurisdictionStateOrProvinceName = 'jurisdictionST';
  LN_jurisdictionStateOrProvinceName = 'jurisdictionStateOrProvinceName';
  NID_jurisdictionStateOrProvinceName = 956;
  SN_jurisdictionCountryName = 'jurisdictionC';
  LN_jurisdictionCountryName = 'jurisdictionCountryName';
  NID_jurisdictionCountryName = 957;
  SN_id_scrypt = 'id-scrypt';
  LN_id_scrypt = 'scrypt';
  NID_id_scrypt = 973;
  SN_tls1_prf = 'TLS1-PRF';
  LN_tls1_prf = 'tls1-prf';
  NID_tls1_prf = 1021;
  SN_hkdf = 'HKDF';
  LN_hkdf = 'hkdf';
  NID_hkdf = 1036;
  SN_id_pkinit = 'id-pkinit';
  NID_id_pkinit = 1031;
  SN_pkInitClientAuth = 'pkInitClientAuth';
  LN_pkInitClientAuth = 'PKINIT Client Auth';
  NID_pkInitClientAuth = 1032;
  SN_pkInitKDC = 'pkInitKDC';
  LN_pkInitKDC = 'Signing KDC Response';
  NID_pkInitKDC = 1033;
  SN_X25519 = 'X25519';
  NID_X25519 = 1034;
  SN_X448 = 'X448';
  NID_X448 = 1035;
  SN_ED25519 = 'ED25519';
  NID_ED25519 = 1087;
  SN_ED448 = 'ED448';
  NID_ED448 = 1088;
  SN_kx_rsa = 'KxRSA';
  LN_kx_rsa = 'kx-rsa';
  NID_kx_rsa = 1037;
  SN_kx_ecdhe = 'KxECDHE';
  LN_kx_ecdhe = 'kx-ecdhe';
  NID_kx_ecdhe = 1038;
  SN_kx_dhe = 'KxDHE';
  LN_kx_dhe = 'kx-dhe';
  NID_kx_dhe = 1039;
  SN_kx_ecdhe_psk = 'KxECDHE-PSK';
  LN_kx_ecdhe_psk = 'kx-ecdhe-psk';
  NID_kx_ecdhe_psk = 1040;
  SN_kx_dhe_psk = 'KxDHE-PSK';
  LN_kx_dhe_psk = 'kx-dhe-psk';
  NID_kx_dhe_psk = 1041;
  SN_kx_rsa_psk = 'KxRSA_PSK';
  LN_kx_rsa_psk = 'kx-rsa-psk';
  NID_kx_rsa_psk = 1042;
  SN_kx_psk = 'KxPSK';
  LN_kx_psk = 'kx-psk';
  NID_kx_psk = 1043;
  SN_kx_srp = 'KxSRP';
  LN_kx_srp = 'kx-srp';
  NID_kx_srp = 1044;
  SN_kx_gost = 'KxGOST';
  LN_kx_gost = 'kx-gost';
  NID_kx_gost = 1045;
  SN_kx_any = 'KxANY';
  LN_kx_any = 'kx-any';
  NID_kx_any = 1063;
  SN_auth_rsa = 'AuthRSA';
  LN_auth_rsa = 'auth-rsa';
  NID_auth_rsa = 1046;
  SN_auth_ecdsa = 'AuthECDSA';
  LN_auth_ecdsa = 'auth-ecdsa';
  NID_auth_ecdsa = 1047;
  SN_auth_psk = 'AuthPSK';
  LN_auth_psk = 'auth-psk';
  NID_auth_psk = 1048;
  SN_auth_dss = 'AuthDSS';
  LN_auth_dss = 'auth-dss';
  NID_auth_dss = 1049;
  SN_auth_gost01 = 'AuthGOST01';
  LN_auth_gost01 = 'auth-gost01';
  NID_auth_gost01 = 1050;
  SN_auth_gost12 = 'AuthGOST12';
  LN_auth_gost12 = 'auth-gost12';
  NID_auth_gost12 = 1051;
  SN_auth_srp = 'AuthSRP';
  LN_auth_srp = 'auth-srp';
  NID_auth_srp = 1052;
  SN_auth_null = 'AuthNULL';
  LN_auth_null = 'auth-null';
  NID_auth_null = 1053;
  SN_auth_any = 'AuthANY';
  LN_auth_any = 'auth-any';
  NID_auth_any = 1064;
  SN_poly1305 = 'Poly1305';
  LN_poly1305 = 'poly1305';
  NID_poly1305 = 1061;
  SN_siphash = 'SipHash';
  LN_siphash = 'siphash';
  NID_siphash = 1062;
  SN_ffdhe2048 = 'ffdhe2048';
  NID_ffdhe2048 = 1126;
  SN_ffdhe3072 = 'ffdhe3072';
  NID_ffdhe3072 = 1127;
  SN_ffdhe4096 = 'ffdhe4096';
  NID_ffdhe4096 = 1128;
  SN_ffdhe6144 = 'ffdhe6144';
  NID_ffdhe6144 = 1129;
  SN_ffdhe8192 = 'ffdhe8192';
  NID_ffdhe8192 = 1130;
  SN_ISO_UA = 'ISO-UA';
  NID_ISO_UA = 1150;
  SN_ua_pki = 'ua-pki';
  NID_ua_pki = 1151;
  SN_dstu28147 = 'dstu28147';
  LN_dstu28147 = 'DSTU Gost 28147-2009';
  NID_dstu28147 = 1152;
  SN_dstu28147_ofb = 'dstu28147-ofb';
  LN_dstu28147_ofb = 'DSTU Gost 28147-2009 OFB mode';
  NID_dstu28147_ofb = 1153;
  SN_dstu28147_cfb = 'dstu28147-cfb';
  LN_dstu28147_cfb = 'DSTU Gost 28147-2009 CFB mode';
  NID_dstu28147_cfb = 1154;
  SN_dstu28147_wrap = 'dstu28147-wrap';
  LN_dstu28147_wrap = 'DSTU Gost 28147-2009 key wrap';
  NID_dstu28147_wrap = 1155;
  SN_hmacWithDstu34311 = 'hmacWithDstu34311';
  LN_hmacWithDstu34311 = 'HMAC DSTU Gost 34311-95';
  NID_hmacWithDstu34311 = 1156;
  SN_dstu34311 = 'dstu34311';
  LN_dstu34311 = 'DSTU Gost 34311-95';
  NID_dstu34311 = 1157;
  SN_dstu4145le = 'dstu4145le';
  LN_dstu4145le = 'DSTU 4145-2002 little endian';
  NID_dstu4145le = 1158;
  SN_dstu4145be = 'dstu4145be';
  LN_dstu4145be = 'DSTU 4145-2002 big endian';
  NID_dstu4145be = 1159;
  SN_uacurve0 = 'uacurve0';
  LN_uacurve0 = 'DSTU curve 0';
  NID_uacurve0 = 1160;
  SN_uacurve1 = 'uacurve1';
  LN_uacurve1 = 'DSTU curve 1';
  NID_uacurve1 = 1161;
  SN_uacurve2 = 'uacurve2';
  LN_uacurve2 = 'DSTU curve 2';
  NID_uacurve2 = 1162;
  SN_uacurve3 = 'uacurve3';
  LN_uacurve3 = 'DSTU curve 3';
  NID_uacurve3 = 1163;
  SN_uacurve4 = 'uacurve4';
  LN_uacurve4 = 'DSTU curve 4';
  NID_uacurve4 = 1164;
  SN_uacurve5 = 'uacurve5';
  LN_uacurve5 = 'DSTU curve 5';
  NID_uacurve5 = 1165;
  SN_uacurve6 = 'uacurve6';
  LN_uacurve6 = 'DSTU curve 6';
  NID_uacurve6 = 1166;
  SN_uacurve7 = 'uacurve7';
  LN_uacurve7 = 'DSTU curve 7';
  NID_uacurve7 = 1167;
  SN_uacurve8 = 'uacurve8';
  LN_uacurve8 = 'DSTU curve 8';
  NID_uacurve8 = 1168;
  SN_uacurve9 = 'uacurve9';
  LN_uacurve9 = 'DSTU curve 9';
  NID_uacurve9 = 1169;
  OBJ_F_OBJ_ADD_OBJECT = 105;
  OBJ_F_OBJ_ADD_SIGID = 107;
  OBJ_F_OBJ_CREATE = 100;
  OBJ_F_OBJ_DUP = 101;
  OBJ_F_OBJ_NAME_NEW_INDEX = 106;
  OBJ_F_OBJ_NID2LN = 102;
  OBJ_F_OBJ_NID2OBJ = 103;
  OBJ_F_OBJ_NID2SN = 104;
  OBJ_F_OBJ_TXT2OBJ = 108;
  OBJ_R_OID_EXISTS = 102;
  OBJ_R_UNKNOWN_NID = 101;
  OBJ_NAME_TYPE_UNDEF = $00;
  OBJ_NAME_TYPE_MD_METH = $01;
  OBJ_NAME_TYPE_CIPHER_METH = $02;
  OBJ_NAME_TYPE_PKEY_METH = $03;
  OBJ_NAME_TYPE_COMP_METH = $04;
  OBJ_NAME_TYPE_MAC_METH  = $05;
  OBJ_NAME_TYPE_KDF_METH  = $06;
  OBJ_NAME_TYPE_NUM = $05;
  OBJ_NAME_ALIAS = $8000;
  OBJ_BSEARCH_VALUE_ON_NOMATCH = $01;
  OBJ_BSEARCH_FIRST_VALUE_ON_MATCH = $02;
  EVP_PK_RSA = $0001;
  EVP_PK_DSA = $0002;
  EVP_PK_DH = $0004;
  EVP_PK_EC = $0008;
  EVP_PKT_SIGN = $0010;
  EVP_PKT_ENC = $0020;
  EVP_PKT_EXCH = $0040;
  EVP_PKS_RSA = $0100;
  EVP_PKS_DSA = $0200;
  EVP_PKS_EC = $0400;
  EVP_PKEY_NONE = NID_undef;
  EVP_PKEY_RSA = NID_rsaEncryption;
  EVP_PKEY_RSA2 = NID_rsa;
  EVP_PKEY_RSA_PSS = NID_rsassaPss;
  EVP_PKEY_DSA = NID_dsa;
  EVP_PKEY_DSA1 = NID_dsa_2;
  EVP_PKEY_DSA2 = NID_dsaWithSHA;
  EVP_PKEY_DSA3 = NID_dsaWithSHA1;
  EVP_PKEY_DSA4 = NID_dsaWithSHA1_2;
  EVP_PKEY_DH = NID_dhKeyAgreement;
  EVP_PKEY_DHX = NID_dhpublicnumber;
  EVP_PKEY_EC = NID_X9_62_id_ecPublicKey;
  EVP_PKEY_SM2 = NID_sm2;
  EVP_PKEY_HMAC = NID_hmac;
  EVP_PKEY_CMAC = NID_cmac;
  EVP_PKEY_SCRYPT = NID_id_scrypt;
  EVP_PKEY_TLS1_PRF = NID_tls1_prf;
  EVP_PKEY_HKDF = NID_hkdf;
  EVP_PKEY_POLY1305 = NID_poly1305;
  EVP_PKEY_SIPHASH = NID_siphash;
  EVP_PKEY_X25519 = NID_X25519;
  EVP_PKEY_ED25519 = NID_ED25519;
  EVP_PKEY_X448 = NID_X448;
  EVP_PKEY_ED448 = NID_ED448;
  EVP_PKEY_MO_SIGN = $0001;
  EVP_PKEY_MO_VERIFY = $0002;
  EVP_PKEY_MO_ENCRYPT = $0004;
  EVP_PKEY_MO_DECRYPT = $0008;
  EVP_MD_FLAG_ONESHOT = $0001;
  EVP_MD_FLAG_XOF = $0002;
  EVP_MD_FLAG_DIGALGID_MASK = $0018;
  EVP_MD_FLAG_DIGALGID_NULL = $0000;
  EVP_MD_FLAG_DIGALGID_ABSENT = $0008;
  EVP_MD_FLAG_DIGALGID_CUSTOM = $0018;
  EVP_MD_FLAG_FIPS = $0400;
  EVP_MD_CTRL_DIGALGID = $1;
  EVP_MD_CTRL_MICALG = $2;
  EVP_MD_CTRL_XOF_LEN = $3;
  EVP_MD_CTRL_ALG_CTRL = $1000;
  EVP_MD_CTX_FLAG_ONESHOT = $0001;
  EVP_MD_CTX_FLAG_CLEANED = $0002;
  EVP_MD_CTX_FLAG_REUSE = $0004;
  EVP_MD_CTX_FLAG_NON_FIPS_ALLOW = $0008;
  EVP_MD_CTX_FLAG_PAD_MASK = $F0;
  EVP_MD_CTX_FLAG_PAD_PKCS1 = $00;
  EVP_MD_CTX_FLAG_PAD_X931 = $10;
  EVP_MD_CTX_FLAG_PAD_PSS = $20;
  EVP_MD_CTX_FLAG_NO_INIT = $0100;
  EVP_MD_CTX_FLAG_FINALISE = $0200;

  EVP_CIPHER_CTX_FLAG_WRAP_ALLOW = $1;
  EVP_CTRL_INIT = $0;
  EVP_CTRL_SET_KEY_LENGTH = $1;
  EVP_CTRL_GET_RC2_KEY_BITS = $2;
  EVP_CTRL_SET_RC2_KEY_BITS = $3;
  EVP_CTRL_GET_RC5_ROUNDS = $4;
  EVP_CTRL_SET_RC5_ROUNDS = $5;
  EVP_CTRL_RAND_KEY = $6;
  EVP_CTRL_PBE_PRF_NID = $7;
  EVP_CTRL_COPY = $8;
  EVP_CTRL_AEAD_SET_IVLEN = $9;
  EVP_CTRL_AEAD_GET_TAG = $10;
  EVP_CTRL_AEAD_SET_TAG = $11;
  EVP_CTRL_AEAD_SET_IV_FIXED = $12;
  EVP_CTRL_GCM_SET_IVLEN = EVP_CTRL_AEAD_SET_IVLEN;
  EVP_CTRL_GCM_GET_TAG = EVP_CTRL_AEAD_GET_TAG;
  EVP_CTRL_GCM_SET_TAG = EVP_CTRL_AEAD_SET_TAG;
  EVP_CTRL_GCM_SET_IV_FIXED = EVP_CTRL_AEAD_SET_IV_FIXED;
  EVP_CTRL_GCM_IV_GEN = $13;
  EVP_CTRL_CCM_SET_IVLEN = EVP_CTRL_AEAD_SET_IVLEN;
  EVP_CTRL_CCM_GET_TAG = EVP_CTRL_AEAD_GET_TAG;
  EVP_CTRL_CCM_SET_TAG = EVP_CTRL_AEAD_SET_TAG;
  EVP_CTRL_CCM_SET_IV_FIXED = EVP_CTRL_AEAD_SET_IV_FIXED;
  EVP_CTRL_CCM_SET_L = $14;
  EVP_CTRL_CCM_SET_MSGLEN = $15;
  EVP_CTRL_AEAD_TLS1_AAD = $16;
  EVP_CTRL_AEAD_SET_MAC_KEY = $17;
  EVP_CTRL_GCM_SET_IV_INV = $18;
  EVP_CTRL_TLS1_1_MULTIBLOCK_AAD = $19;
  EVP_CTRL_TLS1_1_MULTIBLOCK_ENCRYPT = $1a;
  EVP_CTRL_TLS1_1_MULTIBLOCK_DECRYPT = $1b;
  EVP_CTRL_TLS1_1_MULTIBLOCK_MAX_BUFSIZE = $1c;
  EVP_CTRL_SSL3_MASTER_SECRET = $1d;
  EVP_CTRL_SET_SBOX = $1e;
  EVP_CTRL_SBOX_USED = $1f;
  EVP_CTRL_KEY_MESH = $20;
  EVP_CTRL_BLOCK_PADDING_MODE = $21;
  EVP_CTRL_SET_PIPELINE_OUTPUT_BUFS = $22;
  EVP_CTRL_SET_PIPELINE_INPUT_BUFS = $23;
  EVP_CTRL_SET_PIPELINE_INPUT_LENS = $24;
  EVP_CTRL_GET_IVLEN = $25;
  EVP_CTRL_SET_SPEED = $27;
  EVP_PADDING_PKCS7 = 1;
  EVP_PADDING_ISO7816_4 = 2;
  EVP_PADDING_ANSI923 = 3;
  EVP_PADDING_ISO10126 = 4;
  EVP_PADDING_ZERO = 5;
  EVP_AEAD_TLS1_AAD_LEN = 13;
  EVP_GCM_TLS_FIXED_IV_LEN = 4;
  EVP_GCM_TLS_EXPLICIT_IV_LEN = 8;
  EVP_GCM_TLS_TAG_LEN = 16;
  EVP_CCM_TLS_FIXED_IV_LEN = 4;
  EVP_CCM_TLS_EXPLICIT_IV_LEN = 8;
  EVP_CCM_TLS_IV_LEN = 12;
  EVP_CCM_TLS_TAG_LEN = 16;
  EVP_CCM8_TLS_TAG_LEN = 8;
  EVP_CHACHAPOLY_TLS_TAG_LEN = 16;
  EVP_PBE_TYPE_OUTER = $0;
  EVP_PBE_TYPE_PRF = $1;
  EVP_PBE_TYPE_KDF = $2;
  ASN1_PKEY_ALIAS = $1;
  ASN1_PKEY_DYNAMIC = $2;
  ASN1_PKEY_SIGPARAM_NULL = $4;
  ASN1_PKEY_CTRL_PKCS7_SIGN = $1;
  ASN1_PKEY_CTRL_PKCS7_ENCRYPT = $2;
  ASN1_PKEY_CTRL_DEFAULT_MD_NID = $3;
  ASN1_PKEY_CTRL_CMS_SIGN = $5;
  ASN1_PKEY_CTRL_CMS_ENVELOPE = $7;
  ASN1_PKEY_CTRL_CMS_RI_TYPE = $8;
  ASN1_PKEY_CTRL_SET1_TLS_ENCPT = $9;
  ASN1_PKEY_CTRL_GET1_TLS_ENCPT = $a;
  EVP_PKEY_OP_UNDEFINED = 0;
  EVP_PKEY_OP_PARAMGEN = (1 shl 1);
  EVP_PKEY_OP_KEYGEN = (1 shl 2);
  EVP_PKEY_OP_SIGN = (1 shl 3);
  EVP_PKEY_OP_VERIFY = (1 shl 4);
  EVP_PKEY_OP_VERIFYRECOVER = (1 shl 5);
  EVP_PKEY_OP_SIGNCTX = (1 shl 6);
  EVP_PKEY_OP_VERIFYCTX = (1 shl 7);
  EVP_PKEY_OP_ENCRYPT = (1 shl 8);
  EVP_PKEY_OP_DECRYPT = (1 shl 9);
  EVP_PKEY_OP_DERIVE = (1 shl 10);
  EVP_PKEY_OP_ENCAPSULATE = (1 shl 12);
  EVP_PKEY_OP_DECAPSULATE = (1 shl 13);
  EVP_PKEY_OP_TYPE_SIG = (EVP_PKEY_OP_SIGN or EVP_PKEY_OP_VERIFY or EVP_PKEY_OP_VERIFYRECOVER or EVP_PKEY_OP_SIGNCTX or EVP_PKEY_OP_VERIFYCTX);
  EVP_PKEY_OP_TYPE_CRYPT = (EVP_PKEY_OP_ENCRYPT or EVP_PKEY_OP_DECRYPT);
  EVP_PKEY_OP_TYPE_NOGEN = (EVP_PKEY_OP_TYPE_SIG or EVP_PKEY_OP_TYPE_CRYPT or EVP_PKEY_OP_DERIVE);
  EVP_PKEY_OP_TYPE_GEN = (EVP_PKEY_OP_PARAMGEN or EVP_PKEY_OP_KEYGEN);
  EVP_PKEY_CTRL_MD = 1;
  EVP_PKEY_CTRL_PEER_KEY = 2;
  EVP_PKEY_CTRL_PKCS7_ENCRYPT = 3;
  EVP_PKEY_CTRL_PKCS7_DECRYPT = 4;
  EVP_PKEY_CTRL_PKCS7_SIGN = 5;
  EVP_PKEY_CTRL_SET_MAC_KEY = 6;
  EVP_PKEY_CTRL_DIGESTINIT = 7;
  EVP_PKEY_CTRL_SET_IV = 8;
  EVP_PKEY_CTRL_CMS_ENCRYPT = 9;
  EVP_PKEY_CTRL_CMS_DECRYPT = 10;
  EVP_PKEY_CTRL_CMS_SIGN = 11;
  EVP_PKEY_CTRL_CIPHER = 12;
  EVP_PKEY_CTRL_GET_MD = 13;
  EVP_PKEY_CTRL_SET_DIGEST_SIZE = 14;
  EVP_PKEY_ALG_CTRL = $1000;
  EVP_PKEY_FLAG_AUTOARGLEN = 2;
  EVP_PKEY_FLAG_SIGCTX_CUSTOM = 4;
  EC_F_BN_TO_FELEM = 224;
  EC_F_D2I_ECPARAMETERS = 144;
  EC_F_D2I_ECPKPARAMETERS = 145;
  EC_F_D2I_ECPRIVATEKEY = 146;
  EC_F_DO_EC_KEY_PRINT = 221;
  EC_F_ECDH_CMS_DECRYPT = 238;
  EC_F_ECDH_CMS_SET_SHARED_INFO = 239;
  EC_F_ECDH_COMPUTE_KEY = 246;
  EC_F_ECDH_SIMPLE_COMPUTE_KEY = 257;
  EC_F_ECDSA_DO_SIGN_EX = 251;
  EC_F_ECDSA_DO_VERIFY = 252;
  EC_F_ECDSA_SIGN_EX = 254;
  EC_F_ECDSA_SIGN_SETUP = 248;
  EC_F_ECDSA_SIG_NEW = 265;
  EC_F_ECDSA_VERIFY = 253;
  EC_F_ECD_ITEM_VERIFY = 270;
  EC_F_ECKEY_PARAM2TYPE = 223;
  EC_F_ECKEY_PARAM_DECODE = 212;
  EC_F_ECKEY_PRIV_DECODE = 213;
  EC_F_ECKEY_PRIV_ENCODE = 214;
  EC_F_ECKEY_PUB_DECODE = 215;
  EC_F_ECKEY_PUB_ENCODE = 216;
  EC_F_ECKEY_TYPE2PARAM = 220;
  EC_F_ECPARAMETERS_PRINT = 147;
  EC_F_ECPARAMETERS_PRINT_FP = 148;
  EC_F_ECPKPARAMETERS_PRINT = 149;
  EC_F_ECPKPARAMETERS_PRINT_FP = 150;
  EC_F_ECP_NISTZ256_GET_AFFINE = 240;
  EC_F_ECP_NISTZ256_INV_MOD_ORD = 275;
  EC_F_ECP_NISTZ256_MULT_PRECOMPUTE = 243;
  EC_F_ECP_NISTZ256_POINTS_MUL = 241;
  EC_F_ECP_NISTZ256_PRE_COMP_NEW = 244;
  EC_F_ECP_NISTZ256_WINDOWED_MUL = 242;
  EC_F_ECX_KEY_OP = 266;
  EC_F_ECX_PRIV_ENCODE = 267;
  EC_F_ECX_PUB_ENCODE = 268;
  EC_F_EC_ASN1_GROUP2CURVE = 153;
  EC_F_EC_ASN1_GROUP2FIELDID = 154;
  EC_F_EC_GF2M_MONTGOMERY_POINT_MULTIPLY = 208;
  EC_F_EC_GF2M_SIMPLE_FIELD_INV = 296;
  EC_F_EC_GF2M_SIMPLE_GROUP_CHECK_DISCRIMINANT = 159;
  EC_F_EC_GF2M_SIMPLE_GROUP_SET_CURVE = 195;
  EC_F_EC_GF2M_SIMPLE_LADDER_POST = 285;
  EC_F_EC_GF2M_SIMPLE_LADDER_PRE = 288;
  EC_F_EC_GF2M_SIMPLE_OCT2POINT = 160;
  EC_F_EC_GF2M_SIMPLE_POINT2OCT = 161;
  EC_F_EC_GF2M_SIMPLE_POINTS_MUL = 289;
  EC_F_EC_GF2M_SIMPLE_POINT_GET_AFFINE_COORDINATES = 162;
  EC_F_EC_GF2M_SIMPLE_POINT_SET_AFFINE_COORDINATES = 163;
  EC_F_EC_GF2M_SIMPLE_SET_COMPRESSED_COORDINATES = 164;
  EC_F_EC_GFP_MONT_FIELD_DECODE = 133;
  EC_F_EC_GFP_MONT_FIELD_ENCODE = 134;
  EC_F_EC_GFP_MONT_FIELD_INV = 297;
  EC_F_EC_GFP_MONT_FIELD_MUL = 131;
  EC_F_EC_GFP_MONT_FIELD_SET_TO_ONE = 209;
  EC_F_EC_GFP_MONT_FIELD_SQR = 132;
  EC_F_EC_GFP_MONT_GROUP_SET_CURVE = 189;
  EC_F_EC_GFP_NISTP224_GROUP_SET_CURVE = 225;
  EC_F_EC_GFP_NISTP224_POINTS_MUL = 228;
  EC_F_EC_GFP_NISTP224_POINT_GET_AFFINE_COORDINATES = 226;
  EC_F_EC_GFP_NISTP256_GROUP_SET_CURVE = 230;
  EC_F_EC_GFP_NISTP256_POINTS_MUL = 231;
  EC_F_EC_GFP_NISTP256_POINT_GET_AFFINE_COORDINATES = 232;
  EC_F_EC_GFP_NISTP521_GROUP_SET_CURVE = 233;
  EC_F_EC_GFP_NISTP521_POINTS_MUL = 234;
  EC_F_EC_GFP_NISTP521_POINT_GET_AFFINE_COORDINATES = 235;
  EC_F_EC_GFP_NIST_FIELD_MUL = 200;
  EC_F_EC_GFP_NIST_FIELD_SQR = 201;
  EC_F_EC_GFP_NIST_GROUP_SET_CURVE = 202;
  EC_F_EC_GFP_SIMPLE_BLIND_COORDINATES = 287;
  EC_F_EC_GFP_SIMPLE_FIELD_INV = 298;
  EC_F_EC_GFP_SIMPLE_GROUP_CHECK_DISCRIMINANT = 165;
  EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE = 166;
  EC_F_EC_GFP_SIMPLE_MAKE_AFFINE = 102;
  EC_F_EC_GFP_SIMPLE_OCT2POINT = 103;
  EC_F_EC_GFP_SIMPLE_POINT2OCT = 104;
  EC_F_EC_GFP_SIMPLE_POINTS_MAKE_AFFINE = 137;
  EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES = 167;
  EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES = 168;
  EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES = 169;
  EC_F_EC_GROUP_CHECK = 170;
  EC_F_EC_GROUP_CHECK_DISCRIMINANT = 171;
  EC_F_EC_GROUP_COPY = 106;
  EC_F_EC_GROUP_GET_CURVE = 291;
  EC_F_EC_GROUP_GET_CURVE_GF2M = 172;
  EC_F_EC_GROUP_GET_CURVE_GFP = 130;
  EC_F_EC_GROUP_GET_DEGREE = 173;
  EC_F_EC_GROUP_GET_ECPARAMETERS = 261;
  EC_F_EC_GROUP_GET_ECPKPARAMETERS = 262;
  EC_F_EC_GROUP_GET_PENTANOMIAL_BASIS = 193;
  EC_F_EC_GROUP_GET_TRINOMIAL_BASIS = 194;
  EC_F_EC_GROUP_NEW = 108;
  EC_F_EC_GROUP_NEW_BY_CURVE_NAME = 174;
  EC_F_EC_GROUP_NEW_FROM_DATA = 175;
  EC_F_EC_GROUP_NEW_FROM_ECPARAMETERS = 263;
  EC_F_EC_GROUP_NEW_FROM_ECPKPARAMETERS = 264;
  EC_F_EC_GROUP_SET_CURVE = 292;
  EC_F_EC_GROUP_SET_CURVE_GF2M = 176;
  EC_F_EC_GROUP_SET_CURVE_GFP = 109;
  EC_F_EC_GROUP_SET_GENERATOR = 111;
  EC_F_EC_GROUP_SET_SEED = 286;
  EC_F_EC_KEY_CHECK_KEY = 177;
  EC_F_EC_KEY_COPY = 178;
  EC_F_EC_KEY_GENERATE_KEY = 179;
  EC_F_EC_KEY_NEW = 182;
  EC_F_EC_KEY_NEW_METHOD = 245;
  EC_F_EC_KEY_OCT2PRIV = 255;
  EC_F_EC_KEY_PRINT = 180;
  EC_F_EC_KEY_PRINT_FP = 181;
  EC_F_EC_KEY_PRIV2BUF = 279;
  EC_F_EC_KEY_PRIV2OCT = 256;
  EC_F_EC_KEY_SET_PUBLIC_KEY_AFFINE_COORDINATES = 229;
  EC_F_EC_KEY_SIMPLE_CHECK_KEY = 258;
  EC_F_EC_KEY_SIMPLE_OCT2PRIV = 259;
  EC_F_EC_KEY_SIMPLE_PRIV2OCT = 260;
  EC_F_EC_PKEY_CHECK = 273;
  EC_F_EC_PKEY_PARAM_CHECK = 274;
  EC_F_EC_POINTS_MAKE_AFFINE = 136;
  EC_F_EC_POINTS_MUL = 290;
  EC_F_EC_POINT_ADD = 112;
  EC_F_EC_POINT_BN2POINT = 280;
  EC_F_EC_POINT_CMP = 113;
  EC_F_EC_POINT_COPY = 114;
  EC_F_EC_POINT_DBL = 115;
  EC_F_EC_POINT_GET_AFFINE_COORDINATES = 293;
  EC_F_EC_POINT_GET_AFFINE_COORDINATES_GF2M = 183;
  EC_F_EC_POINT_GET_AFFINE_COORDINATES_GFP = 116;
  EC_F_EC_POINT_GET_JPROJECTIVE_COORDINATES_GFP = 117;
  EC_F_EC_POINT_INVERT = 210;
  EC_F_EC_POINT_IS_AT_INFINITY = 118;
  EC_F_EC_POINT_IS_ON_CURVE = 119;
  EC_F_EC_POINT_MAKE_AFFINE = 120;
  EC_F_EC_POINT_NEW = 121;
  EC_F_EC_POINT_OCT2POINT = 122;
  EC_F_EC_POINT_POINT2BUF = 281;
  EC_F_EC_POINT_POINT2OCT = 123;
  EC_F_EC_POINT_SET_AFFINE_COORDINATES = 294;
  EC_F_EC_POINT_SET_AFFINE_COORDINATES_GF2M = 185;
  EC_F_EC_POINT_SET_AFFINE_COORDINATES_GFP = 124;
  EC_F_EC_POINT_SET_COMPRESSED_COORDINATES = 295;
  EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GF2M = 186;
  EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GFP = 125;
  EC_F_EC_POINT_SET_JPROJECTIVE_COORDINATES_GFP = 126;
  EC_F_EC_POINT_SET_TO_INFINITY = 127;
  EC_F_EC_PRE_COMP_NEW = 196;
  EC_F_EC_SCALAR_MUL_LADDER = 284;
  EC_F_EC_WNAF_MUL = 187;
  EC_F_EC_WNAF_PRECOMPUTE_MULT = 188;
  EC_F_I2D_ECPARAMETERS = 190;
  EC_F_I2D_ECPKPARAMETERS = 191;
  EC_F_I2D_ECPRIVATEKEY = 192;
  EC_F_I2O_ECPUBLICKEY = 151;
  EC_F_NISTP224_PRE_COMP_NEW = 227;
  EC_F_NISTP256_PRE_COMP_NEW = 236;
  EC_F_NISTP521_PRE_COMP_NEW = 237;
  EC_F_O2I_ECPUBLICKEY = 152;
  EC_F_OLD_EC_PRIV_DECODE = 222;
  EC_F_OSSL_ECDH_COMPUTE_KEY = 247;
  EC_F_OSSL_ECDSA_SIGN_SIG = 249;
  EC_F_OSSL_ECDSA_VERIFY_SIG = 250;
  EC_F_PKEY_ECD_CTRL = 271;
  EC_F_PKEY_ECD_DIGESTSIGN = 272;
  EC_F_PKEY_ECD_DIGESTSIGN25519 = 276;
  EC_F_PKEY_ECD_DIGESTSIGN448 = 277;
  EC_F_PKEY_ECX_DERIVE = 269;
  EC_F_PKEY_EC_CTRL = 197;
  EC_F_PKEY_EC_CTRL_STR = 198;
  EC_F_PKEY_EC_DERIVE = 217;
  EC_F_PKEY_EC_INIT = 282;
  EC_F_PKEY_EC_KDF_DERIVE = 283;
  EC_F_PKEY_EC_KEYGEN = 199;
  EC_F_PKEY_EC_PARAMGEN = 219;
  EC_F_PKEY_EC_SIGN = 218;
  EC_F_VALIDATE_ECX_DERIVE = 278;

  
  OPENSSL_ECC_MAX_FIELD_BITS = 661;
  OPENSSL_EC_EXPLICIT_CURVE = $000;
  OPENSSL_EC_NAMED_CURVE = $001;

  EVP_PKEY_CTRL_EC_PARAMGEN_CURVE_NID = (EVP_PKEY_ALG_CTRL+1);
  EVP_PKEY_CTRL_EC_PARAM_ENC = (EVP_PKEY_ALG_CTRL+2);
  EVP_PKEY_CTRL_EC_ECDH_COFACTOR = (EVP_PKEY_ALG_CTRL+3);
  EVP_PKEY_CTRL_EC_KDF_TYPE = (EVP_PKEY_ALG_CTRL+4);
  EVP_PKEY_CTRL_EC_KDF_MD = (EVP_PKEY_ALG_CTRL+5);
  EVP_PKEY_CTRL_GET_EC_KDF_MD = (EVP_PKEY_ALG_CTRL+6);
  EVP_PKEY_CTRL_EC_KDF_OUTLEN = (EVP_PKEY_ALG_CTRL+7);
  EVP_PKEY_CTRL_GET_EC_KDF_OUTLEN = (EVP_PKEY_ALG_CTRL+8);
  EVP_PKEY_CTRL_EC_KDF_UKM = (EVP_PKEY_ALG_CTRL+9);
  EVP_PKEY_CTRL_GET_EC_KDF_UKM = (EVP_PKEY_ALG_CTRL+10);
  EVP_PKEY_CTRL_SET1_ID = (EVP_PKEY_ALG_CTRL+11);
  EVP_PKEY_CTRL_GET1_ID = (EVP_PKEY_ALG_CTRL+12);
  EVP_PKEY_CTRL_GET1_ID_LEN = (EVP_PKEY_ALG_CTRL+13);
  EVP_PKEY_ECDH_KDF_NONE = 1;
  EVP_PKEY_ECDH_KDF_X9_63 = 2;
  EVP_PKEY_ECDH_KDF_X9_62 = EVP_PKEY_ECDH_KDF_X9_63;
  RSA_F_CHECK_PADDING_MD = 140;
  RSA_F_ENCODE_PKCS1 = 146;
  RSA_F_INT_RSA_VERIFY = 145;
  RSA_F_OLD_RSA_PRIV_DECODE = 147;
  RSA_F_PKEY_PSS_INIT = 165;
  RSA_F_PKEY_RSA_CTRL = 143;
  RSA_F_PKEY_RSA_CTRL_STR = 144;
  RSA_F_PKEY_RSA_SIGN = 142;
  RSA_F_PKEY_RSA_VERIFY = 149;
  RSA_F_PKEY_RSA_VERIFYRECOVER = 141;
  RSA_F_RSA_ALGOR_TO_MD = 156;
  RSA_F_RSA_BUILTIN_KEYGEN = 129;
  RSA_F_RSA_CHECK_KEY = 123;
  RSA_F_RSA_CHECK_KEY_EX = 160;
  RSA_F_RSA_CMS_DECRYPT = 159;
  RSA_F_RSA_CMS_VERIFY = 158;
  RSA_F_RSA_ITEM_VERIFY = 148;
  RSA_F_RSA_METH_DUP = 161;
  RSA_F_RSA_METH_NEW = 162;
  RSA_F_RSA_METH_SET1_NAME = 163;
  RSA_F_RSA_MGF1_TO_MD = 157;
  RSA_F_RSA_MULTIP_INFO_NEW = 166;
  RSA_F_RSA_NEW_METHOD = 106;
  RSA_F_RSA_NULL = 124;
  RSA_F_RSA_NULL_PRIVATE_DECRYPT = 132;
  RSA_F_RSA_NULL_PRIVATE_ENCRYPT = 133;
  RSA_F_RSA_NULL_PUBLIC_DECRYPT = 134;
  RSA_F_RSA_NULL_PUBLIC_ENCRYPT = 135;
  RSA_F_RSA_OSSL_PRIVATE_DECRYPT = 101;
  RSA_F_RSA_OSSL_PRIVATE_ENCRYPT = 102;
  RSA_F_RSA_OSSL_PUBLIC_DECRYPT = 103;
  RSA_F_RSA_OSSL_PUBLIC_ENCRYPT = 104;
  RSA_F_RSA_PADDING_ADD_NONE = 107;
  RSA_F_RSA_PADDING_ADD_PKCS1_OAEP = 121;
  RSA_F_RSA_PADDING_ADD_PKCS1_OAEP_MGF1 = 154;
  RSA_F_RSA_PADDING_ADD_PKCS1_PSS = 125;
  RSA_F_RSA_PADDING_ADD_PKCS1_PSS_MGF1 = 152;
  RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_1 = 108;
  RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_2 = 109;
  RSA_F_RSA_PADDING_ADD_SSLV23 = 110;
  RSA_F_RSA_PADDING_ADD_X931 = 127;
  RSA_F_RSA_PADDING_CHECK_NONE = 111;
  RSA_F_RSA_PADDING_CHECK_PKCS1_OAEP = 122;
  RSA_F_RSA_PADDING_CHECK_PKCS1_OAEP_MGF1 = 153;
  RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_1 = 112;
  RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_2 = 113;
  RSA_F_RSA_PADDING_CHECK_SSLV23 = 114;
  RSA_F_RSA_PADDING_CHECK_X931 = 128;
  RSA_F_RSA_PARAM_DECODE = 164;
  RSA_F_RSA_PRINT = 115;
  RSA_F_RSA_PRINT_FP = 116;
  RSA_F_RSA_PRIV_DECODE = 150;
  RSA_F_RSA_PRIV_ENCODE = 138;
  RSA_F_RSA_PSS_GET_PARAM = 151;
  RSA_F_RSA_PSS_TO_CTX = 155;
  RSA_F_RSA_PUB_DECODE = 139;
  RSA_F_RSA_SETUP_BLINDING = 136;
  RSA_F_RSA_SIGN = 117;
  RSA_F_RSA_SIGN_ASN1_OCTET_STRING = 118;
  RSA_F_RSA_VERIFY = 119;
  RSA_F_RSA_VERIFY_ASN1_OCTET_STRING = 120;
  RSA_F_RSA_VERIFY_PKCS1_PSS_MGF1 = 126;
  RSA_F_SETUP_TBUF = 167;
  RSA_R_ALGORITHM_MISMATCH = 100;
  RSA_R_BAD_E_VALUE = 101;
  RSA_R_BAD_FIXED_HEADER_DECRYPT = 102;
  RSA_R_BAD_PAD_BYTE_COUNT = 103;
  RSA_R_BAD_SIGNATURE = 104;
  RSA_R_BLOCK_TYPE_IS_NOT_01 = 106;
  RSA_R_BLOCK_TYPE_IS_NOT_02 = 107;
  RSA_R_DATA_GREATER_THAN_MOD_LEN = 108;
  RSA_R_DATA_TOO_LARGE = 109;
  RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE = 110;
  RSA_R_DATA_TOO_LARGE_FOR_MODULUS = 132;
  RSA_R_DATA_TOO_SMALL = 111;
  RSA_R_DATA_TOO_SMALL_FOR_KEY_SIZE = 122;
  RSA_R_DIGEST_DOES_NOT_MATCH = 158;
  RSA_R_DIGEST_NOT_ALLOWED = 145;
  RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY = 112;
  RSA_R_DMP1_NOT_CONGRUENT_TO_D = 124;
  RSA_R_DMQ1_NOT_CONGRUENT_TO_D = 125;
  RSA_R_D_E_NOT_CONGRUENT_TO_1 = 123;
  RSA_R_FIRST_OCTET_INVALID = 133;
  RSA_R_ILLEGAL_OR_UNSUPPORTED_PADDING_MODE = 144;
  
  RSA_R_IQMP_NOT_INVERSE_OF_Q = 126;
  RSA_R_KEY_PRIME_NUM_INVALID = 165;
  RSA_R_KEY_SIZE_TOO_SMALL = 120;
  RSA_R_LAST_OCTET_INVALID = 134;
  RSA_R_MISSING_PRIVATE_KEY = 179;
  RSA_R_MGF1_DIGEST_NOT_ALLOWED = 152;
  RSA_R_MODULUS_TOO_LARGE = 105;
  RSA_R_MP_COEFFICIENT_NOT_INVERSE_OF_R = 168;
  RSA_R_MP_EXPONENT_NOT_CONGRUENT_TO_D = 169;
  RSA_R_MP_R_NOT_PRIME = 170;
  RSA_R_NO_PUBLIC_EXPONENT = 140;
  RSA_R_NULL_BEFORE_BLOCK_MISSING = 113;
  RSA_R_N_DOES_NOT_EQUAL_PRODUCT_OF_PRIMES = 172;
  RSA_R_N_DOES_NOT_EQUAL_P_Q = 127;
  RSA_R_OAEP_DECODING_ERROR = 121;
  RSA_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE = 148;
  RSA_R_PADDING_CHECK_FAILED = 114;
  RSA_R_PKCS_DECODING_ERROR = 159;
  RSA_R_PSS_SALTLEN_TOO_SMALL = 164;
  RSA_R_P_NOT_PRIME = 128;
  RSA_R_Q_NOT_PRIME = 129;
  RSA_R_RSA_OPERATIONS_NOT_SUPPORTED = 130;
  RSA_R_SLEN_CHECK_FAILED = 136;
  RSA_R_SLEN_RECOVERY_FAILED = 135;
  RSA_R_SSLV3_ROLLBACK_ATTACK = 115;
  RSA_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD = 116;
  RSA_R_RANDOMNESS_SOURCE_STRENGTH_INSUFFICIENT =   180;
  RSA_R_UNKNOWN_ALGORITHM_TYPE = 117;
  RSA_R_UNKNOWN_DIGEST = 166;
  RSA_R_UNKNOWN_MASK_DIGEST = 151;
  RSA_R_UNKNOWN_PADDING_TYPE = 118;
  RSA_R_UNSUPPORTED_ENCRYPTION_TYPE = 162;
  RSA_R_UNSUPPORTED_LABEL_SOURCE = 163;
  RSA_R_UNSUPPORTED_MASK_ALGORITHM = 153;
  RSA_R_UNSUPPORTED_MASK_PARAMETER = 154;
  RSA_R_UNSUPPORTED_SIGNATURE_TYPE = 155;
  RSA_R_VALUE_MISSING = 147;
  RSA_R_WRONG_SIGNATURE_LENGTH = 119;
  OPENSSL_RSA_MAX_MODULUS_BITS = 16384;
  OPENSSL_RSA_FIPS_MIN_MODULUS_BITS = 1024;
  OPENSSL_RSA_SMALL_MODULUS_BITS = 3072;
  OPENSSL_RSA_MAX_PUBEXP_BITS = 64;
  RSA_3 = $3;
  RSA_F4 = $10001;
  RSA_ASN1_VERSION_DEFAULT = 0;
  RSA_ASN1_VERSION_MULTI = 1;
  RSA_DEFAULT_PRIME_NUM = 2;
  RSA_METHOD_FLAG_NO_CHECK = $0001;
  RSA_FLAG_CACHE_PUBLIC = $0002;
  RSA_FLAG_CACHE_PRIVATE = $0004;
  RSA_FLAG_BLINDING = $0008;
  RSA_FLAG_THREAD_SAFE = $0010;
  RSA_FLAG_EXT_PKEY = $0020;
  RSA_FLAG_NO_BLINDING = $0080;
  RSA_FLAG_NO_CONSTTIME = $0000;
  RSA_FLAG_NO_EXP_CONSTTIME = RSA_FLAG_NO_CONSTTIME;
  RSA_PSS_SALTLEN_DIGEST = -1;
  RSA_PSS_SALTLEN_AUTO = -2;
  RSA_PSS_SALTLEN_MAX = -3;
  RSA_PSS_SALTLEN_MAX_SIGN = -2;
  EVP_PKEY_CTRL_RSA_PADDING = (EVP_PKEY_ALG_CTRL+1);
  EVP_PKEY_CTRL_RSA_PSS_SALTLEN = (EVP_PKEY_ALG_CTRL+2);
  EVP_PKEY_CTRL_RSA_KEYGEN_BITS = (EVP_PKEY_ALG_CTRL+3);
  EVP_PKEY_CTRL_RSA_KEYGEN_PUBEXP = (EVP_PKEY_ALG_CTRL+4);
  EVP_PKEY_CTRL_RSA_MGF1_MD = (EVP_PKEY_ALG_CTRL+5);
  EVP_PKEY_CTRL_GET_RSA_PADDING = (EVP_PKEY_ALG_CTRL+6);
  EVP_PKEY_CTRL_GET_RSA_PSS_SALTLEN = (EVP_PKEY_ALG_CTRL+7);
  EVP_PKEY_CTRL_GET_RSA_MGF1_MD = (EVP_PKEY_ALG_CTRL+8);
  EVP_PKEY_CTRL_RSA_OAEP_MD = (EVP_PKEY_ALG_CTRL+9);
  EVP_PKEY_CTRL_RSA_OAEP_LABEL = (EVP_PKEY_ALG_CTRL+10);
  EVP_PKEY_CTRL_GET_RSA_OAEP_MD = (EVP_PKEY_ALG_CTRL+11);
  EVP_PKEY_CTRL_GET_RSA_OAEP_LABEL = (EVP_PKEY_ALG_CTRL+12);
  EVP_PKEY_CTRL_RSA_KEYGEN_PRIMES = (EVP_PKEY_ALG_CTRL+13);
  
  RSA_FLAG_FIPS_METHOD = $0400;
  RSA_FLAG_NON_FIPS_ALLOW = $0400;
  RSA_FLAG_CHECKED = $0800;
  DH_F_COMPUTE_KEY = 102;
  DH_F_DHPARAMS_PRINT_FP = 101;
  DH_F_DH_BUILTIN_GENPARAMS = 106;
  DH_F_DH_CHECK_EX = 121;
  DH_F_DH_CHECK_PARAMS_EX = 122;
  DH_F_DH_CHECK_PUB_KEY_EX = 123;
  DH_F_DH_CMS_DECRYPT = 114;
  DH_F_DH_CMS_SET_PEERKEY = 115;
  DH_F_DH_CMS_SET_SHARED_INFO = 116;
  DH_F_DH_METH_DUP = 117;
  DH_F_DH_METH_NEW = 118;
  DH_F_DH_METH_SET1_NAME = 119;
  DH_F_DH_NEW_BY_NID = 104;
  DH_F_DH_NEW_METHOD = 105;
  DH_F_DH_PARAM_DECODE = 107;
  DH_F_DH_PKEY_PUBLIC_CHECK = 124;
  DH_F_DH_PRIV_DECODE = 110;
  DH_F_DH_PRIV_ENCODE = 111;
  DH_F_DH_PUB_DECODE = 108;
  DH_F_DH_PUB_ENCODE = 109;
  DH_F_DO_DH_PRINT = 100;
  DH_F_GENERATE_KEY = 103;
  DH_F_PKEY_DH_CTRL_STR = 120;
  DH_F_PKEY_DH_DERIVE = 112;
  DH_F_PKEY_DH_INIT = 125;
  DH_F_PKEY_DH_KEYGEN = 113;
  
  OPENSSL_DH_MAX_MODULUS_BITS = 10000;
  OPENSSL_DH_FIPS_MIN_MODULUS_BITS = 1024;

  DH_GENERATOR_2 = 2;
  DH_GENERATOR_5 = 5;
  DH_CHECK_P_NOT_PRIME = $01;
  DH_CHECK_P_NOT_SAFE_PRIME = $02;
  DH_UNABLE_TO_CHECK_GENERATOR = $04;
  DH_NOT_SUITABLE_GENERATOR = $08;
  DH_CHECK_Q_NOT_PRIME = $10;
  DH_CHECK_INVALID_Q_VALUE = $20;
  DH_CHECK_INVALID_J_VALUE = $40;
  DH_CHECK_PUBKEY_TOO_SMALL = $01;
  DH_CHECK_PUBKEY_TOO_LARGE = $02;
  DH_CHECK_PUBKEY_INVALID = $04;
  DH_CHECK_P_NOT_STRONG_PRIME = DH_CHECK_P_NOT_SAFE_PRIME;
  EVP_PKEY_CTRL_DH_PARAMGEN_PRIME_LEN = (EVP_PKEY_ALG_CTRL+1);
  EVP_PKEY_CTRL_DH_PARAMGEN_GENERATOR = (EVP_PKEY_ALG_CTRL+2);
  EVP_PKEY_CTRL_DH_RFC5114 = (EVP_PKEY_ALG_CTRL+3);
  EVP_PKEY_CTRL_DH_PARAMGEN_SUBPRIME_LEN = (EVP_PKEY_ALG_CTRL+4);
  EVP_PKEY_CTRL_DH_PARAMGEN_TYPE = (EVP_PKEY_ALG_CTRL+5);
  EVP_PKEY_CTRL_DH_KDF_TYPE = (EVP_PKEY_ALG_CTRL+6);
  EVP_PKEY_CTRL_DH_KDF_MD = (EVP_PKEY_ALG_CTRL+7);
  EVP_PKEY_CTRL_GET_DH_KDF_MD = (EVP_PKEY_ALG_CTRL+8);
  EVP_PKEY_CTRL_DH_KDF_OUTLEN = (EVP_PKEY_ALG_CTRL+9);
  EVP_PKEY_CTRL_GET_DH_KDF_OUTLEN = (EVP_PKEY_ALG_CTRL+10);
  EVP_PKEY_CTRL_DH_KDF_UKM = (EVP_PKEY_ALG_CTRL+11);
  EVP_PKEY_CTRL_GET_DH_KDF_UKM = (EVP_PKEY_ALG_CTRL+12);
  EVP_PKEY_CTRL_DH_KDF_OID = (EVP_PKEY_ALG_CTRL+13);
  EVP_PKEY_CTRL_GET_DH_KDF_OID = (EVP_PKEY_ALG_CTRL+14);
  EVP_PKEY_CTRL_DH_NID = (EVP_PKEY_ALG_CTRL+15);
  EVP_PKEY_CTRL_DH_PAD = (EVP_PKEY_ALG_CTRL+16);
  EVP_PKEY_DH_KDF_NONE = 1;
  EVP_PKEY_DH_KDF_X9_42 = 2;
  DSA_F_DSAPARAMS_PRINT = 100;
  DSA_F_DSAPARAMS_PRINT_FP = 101;
  DSA_F_DSA_BUILTIN_PARAMGEN = 125;
  DSA_F_DSA_BUILTIN_PARAMGEN2 = 126;
  DSA_F_DSA_DO_SIGN = 112;
  DSA_F_DSA_DO_VERIFY = 113;
  DSA_F_DSA_METH_DUP = 127;
  DSA_F_DSA_METH_NEW = 128;
  DSA_F_DSA_METH_SET1_NAME = 129;
  DSA_F_DSA_NEW_METHOD = 103;
  DSA_F_DSA_PARAM_DECODE = 119;
  DSA_F_DSA_PRINT_FP = 105;
  DSA_F_DSA_PRIV_DECODE = 115;
  DSA_F_DSA_PRIV_ENCODE = 116;
  DSA_F_DSA_PUB_DECODE = 117;
  DSA_F_DSA_PUB_ENCODE = 118;
  DSA_F_DSA_SIGN = 106;
  DSA_F_DSA_SIGN_SETUP = 107;
  DSA_F_DSA_SIG_NEW = 102;
  DSA_F_OLD_DSA_PRIV_DECODE = 122;
  DSA_F_PKEY_DSA_CTRL = 120;
  DSA_F_PKEY_DSA_CTRL_STR = 104;
  DSA_F_PKEY_DSA_KEYGEN = 121;
  FFC_UNVERIFIABLE_GINDEX = -1;

  OPENSSL_DSA_MAX_MODULUS_BITS = 10000;
  OPENSSL_DSA_FIPS_MIN_MODULUS_BITS = 1024;
  DSA_FLAG_CACHE_MONT_P = $01;
  DSA_FLAG_NO_EXP_CONSTTIME = $00;
  DSA_FLAG_FIPS_METHOD = $0400;
  DSA_FLAG_NON_FIPS_ALLOW = $0400;
  DSA_FLAG_FIPS_CHECKED = $0800;
  DSS_prime_checks = 64;
  EVP_PKEY_CTRL_DSA_PARAMGEN_BITS = (EVP_PKEY_ALG_CTRL+1);
  EVP_PKEY_CTRL_DSA_PARAMGEN_Q_BITS = (EVP_PKEY_ALG_CTRL+2);
  EVP_PKEY_CTRL_DSA_PARAMGEN_MD = (EVP_PKEY_ALG_CTRL+3);
  
  SHA_LAST_BLOCK = (SHA_CBLOCK-8);
  SHA_DIGEST_LENGTH = 20;
  SHA256_CBLOCK = (SHA_LBLOCK*4);
  SHA224_DIGEST_LENGTH = 28;
  SHA256_DIGEST_LENGTH = 32;
  SHA384_DIGEST_LENGTH = 48;
  SHA512_DIGEST_LENGTH = 64;
  SHA512_CBLOCK = (SHA_LBLOCK*8);
  X509_F_ADD_CERT_DIR = 100;
  X509_F_BUILD_CHAIN = 106;
  X509_F_BY_FILE_CTRL = 101;
  X509_F_CHECK_NAME_CONSTRAINTS = 149;
  X509_F_CHECK_POLICY = 145;
  X509_F_DANE_I2D = 107;
  X509_F_DIR_CTRL = 102;
  X509_F_GET_CERT_BY_SUBJECT = 103;
  X509_F_I2D_X509_AUX = 151;
  X509_F_LOOKUP_CERTS_SK = 152;
  X509_F_NETSCAPE_SPKI_B64_DECODE = 129;
  X509_F_NETSCAPE_SPKI_B64_ENCODE = 130;
  X509_F_NEW_DIR = 153;
  X509_F_X509AT_ADD1_ATTR = 135;
  X509_F_X509V3_ADD_EXT = 104;
  X509_F_X509_ATTRIBUTE_CREATE_BY_NID = 136;
  X509_F_X509_ATTRIBUTE_CREATE_BY_OBJ = 137;
  X509_F_X509_ATTRIBUTE_CREATE_BY_TXT = 140;
  X509_F_X509_ATTRIBUTE_GET0_DATA = 139;
  X509_F_X509_ATTRIBUTE_SET1_DATA = 138;
  X509_F_X509_CHECK_PRIVATE_KEY = 128;
  X509_F_X509_CRL_DIFF = 105;
  X509_F_X509_CRL_METHOD_NEW = 154;
  X509_F_X509_CRL_PRINT_FP = 147;
  X509_F_X509_EXTENSION_CREATE_BY_NID = 108;
  X509_F_X509_EXTENSION_CREATE_BY_OBJ = 109;
  X509_F_X509_GET_PUBKEY_PARAMETERS = 110;
  X509_F_X509_LOAD_CERT_CRL_FILE = 132;
  X509_F_X509_LOAD_CERT_FILE = 111;
  X509_F_X509_LOAD_CRL_FILE = 112;
  X509_F_X509_LOOKUP_METH_NEW = 160;
  X509_F_X509_LOOKUP_NEW = 155;
  X509_F_X509_NAME_ADD_ENTRY = 113;
  X509_F_X509_NAME_CANON = 156;
  X509_F_X509_NAME_ENTRY_CREATE_BY_NID = 114;
  X509_F_X509_NAME_ENTRY_CREATE_BY_TXT = 131;
  X509_F_X509_NAME_ENTRY_SET_OBJECT = 115;
  X509_F_X509_NAME_ONELINE = 116;
  X509_F_X509_NAME_PRINT = 117;
  X509_F_X509_OBJECT_NEW = 150;
  X509_F_X509_PRINT_EX_FP = 118;
  X509_F_X509_PUBKEY_DECODE = 148;
  X509_F_X509_PUBKEY_GET0 = 119;
  X509_F_X509_PUBKEY_SET = 120;
  X509_F_X509_REQ_CHECK_PRIVATE_KEY = 144;
  X509_F_X509_REQ_PRINT_EX = 121;
  X509_F_X509_REQ_PRINT_FP = 122;
  X509_F_X509_REQ_TO_X509 = 123;
  X509_F_X509_STORE_ADD_CERT = 124;
  X509_F_X509_STORE_ADD_CRL = 125;
  X509_F_X509_STORE_ADD_LOOKUP = 157;
  X509_F_X509_STORE_CTX_GET1_ISSUER = 146;
  X509_F_X509_STORE_CTX_INIT = 143;
  X509_F_X509_STORE_CTX_NEW = 142;
  X509_F_X509_STORE_CTX_PURPOSE_INHERIT = 134;
  X509_F_X509_STORE_NEW = 158;
  X509_F_X509_TO_X509_REQ = 126;
  X509_F_X509_TRUST_ADD = 133;
  X509_F_X509_TRUST_SET = 141;
  X509_F_X509_VERIFY_CERT = 127;
  X509_F_X509_VERIFY_PARAM_NEW = 159;
  X509_R_AKID_MISMATCH = 110;
  X509_R_BAD_SELECTOR = 133;
  X509_R_BAD_X509_FILETYPE = 100;
  X509_R_BASE64_DECODE_ERROR = 118;
  X509_R_CANT_CHECK_DH_KEY = 114;
  X509_R_CERT_ALREADY_IN_HASH_TABLE = 101;
  X509_R_CRL_ALREADY_DELTA = 127;
  X509_R_CRL_VERIFY_FAILURE = 131;
  X509_R_IDP_MISMATCH = 128;
  X509_R_INVALID_ATTRIBUTES = 138;
  X509_R_INVALID_DIRECTORY = 113;
  X509_R_INVALID_FIELD_NAME = 119;
  X509_R_INVALID_TRUST = 123;
  X509_R_ISSUER_MISMATCH = 129;
  X509_R_KEY_TYPE_MISMATCH = 115;
  X509_R_KEY_VALUES_MISMATCH = 116;
  X509_R_LOADING_CERT_DIR = 103;
  X509_R_LOADING_DEFAULTS = 104;
  X509_R_METHOD_NOT_SUPPORTED = 124;
  X509_R_NAME_TOO_LONG = 134;
  X509_R_NEWER_CRL_NOT_NEWER = 132;
  X509_R_NO_CERTIFICATE_FOUND = 135;
  X509_R_NO_CERTIFICATE_OR_CRL_FOUND = 136;
  X509_R_CERTIFICATE_VERIFICATION_FAILED  =  139;
  X509_R_NO_CERT_SET_FOR_US_TO_VERIFY = 105;
  X509_R_NO_CRL_FOUND = 137;
  X509_R_NO_CRL_NUMBER = 130;
  X509_R_PUBLIC_KEY_DECODE_ERROR = 125;
  X509_R_PUBLIC_KEY_ENCODE_ERROR = 126;
  X509_R_SHOULD_RETRY = 106;
  X509_R_UNABLE_TO_FIND_PARAMETERS_IN_CHAIN = 107;
  X509_R_UNABLE_TO_GET_CERTS_PUBLIC_KEY = 108;
  X509_R_UNKNOWN_KEY_TYPE = 117;
  X509_R_UNKNOWN_NID = 109;
  X509_R_UNKNOWN_PURPOSE_ID = 121;
  X509_R_UNKNOWN_TRUST_ID = 120;
  X509_R_UNSUPPORTED_ALGORITHM = 111;
  X509_R_WRONG_LOOKUP_TYPE = 112;
  X509_R_WRONG_TYPE = 122;
  X509_SIG_INFO_VALID = $1;
  X509_SIG_INFO_TLS = $2;
  X509_FILETYPE_PEM = 1;
  X509_FILETYPE_ASN1 = 2;
  X509_FILETYPE_DEFAULT = 3;
  X509v3_KU_DIGITAL_SIGNATURE = $0080;
  X509v3_KU_NON_REPUDIATION = $0040;
  X509v3_KU_KEY_ENCIPHERMENT = $0020;
  X509v3_KU_DATA_ENCIPHERMENT = $0010;
  X509v3_KU_KEY_AGREEMENT = $0008;
  X509v3_KU_KEY_CERT_SIGN = $0004;
  X509v3_KU_CRL_SIGN = $0002;
  X509v3_KU_ENCIPHER_ONLY = $0001;
  X509v3_KU_DECIPHER_ONLY = $8000;
  X509v3_KU_UNDEF = $ffff;
  X509_EX_V_NETSCAPE_HACK = $8000;
  X509_EX_V_INIT = $0001;
  X509_TRUST_DEFAULT = 0;
  X509_TRUST_COMPAT = 1;
  X509_TRUST_SSL_CLIENT = 2;
  X509_TRUST_SSL_SERVER = 3;
  X509_TRUST_EMAIL = 4;
  X509_TRUST_OBJECT_SIGN = 5;
  X509_TRUST_OCSP_SIGN = 6;
  X509_TRUST_OCSP_REQUEST = 7;
  X509_TRUST_TSA = 8;
  X509_TRUST_MIN = 1;
  X509_TRUST_MAX = 8;
  X509_TRUST_DYNAMIC = (1 shl 0);
  X509_TRUST_DYNAMIC_NAME = (1 shl 1);
  X509_TRUST_NO_SS_COMPAT = (1 shl 2);
  X509_TRUST_DO_SS_COMPAT = (1 shl 3);
  X509_TRUST_OK_ANY_EKU = (1 shl 4);
  X509_TRUST_TRUSTED = 1;
  X509_TRUST_REJECTED = 2;
  X509_TRUST_UNTRUSTED = 3;
  X509_FLAG_COMPAT = 0;
  X509_FLAG_NO_HEADER = 1;
  X509_FLAG_NO_VERSION = (1 shl 1);
  X509_FLAG_NO_SERIAL = (1 shl 2);
  X509_FLAG_NO_SIGNAME = (1 shl 3);
  X509_FLAG_NO_ISSUER = (1 shl 4);
  X509_FLAG_NO_VALIDITY = (1 shl 5);
  X509_FLAG_NO_SUBJECT = (1 shl 6);
  X509_FLAG_NO_PUBKEY = (1 shl 7);
  X509_FLAG_NO_EXTENSIONS = (1 shl 8);
  X509_FLAG_NO_SIGDUMP = (1 shl 9);
  X509_FLAG_NO_AUX = (1 shl 10);
  X509_FLAG_NO_ATTRIBUTES = (1 shl 11);
  X509_FLAG_NO_IDS = (1 shl 12);
  XN_FLAG_SEP_MASK = ($f shl 16);
  XN_FLAG_COMPAT = 0;
  XN_FLAG_SEP_COMMA_PLUS = (1 shl 16);
  XN_FLAG_SEP_CPLUS_SPC = (2 shl 16);
  XN_FLAG_SEP_SPLUS_SPC = (3 shl 16);
  XN_FLAG_SEP_MULTILINE = (4 shl 16);
  XN_FLAG_DN_REV = (1 shl 20);
  XN_FLAG_FN_MASK = ($3 shl 21);
  XN_FLAG_FN_SN = 0;
  XN_FLAG_FN_LN = (1 shl 21);
  XN_FLAG_FN_OID = (2 shl 21);
  XN_FLAG_FN_NONE = (3 shl 21);
  XN_FLAG_SPC_EQ = (1 shl 23);
  XN_FLAG_DUMP_UNKNOWN_FIELDS = (1 shl 24);
  XN_FLAG_FN_ALIGN = (1 shl 25);
  XN_FLAG_RFC2253 = (ASN1_STRFLGS_RFC2253 or XN_FLAG_SEP_COMMA_PLUS or XN_FLAG_DN_REV or XN_FLAG_FN_SN or XN_FLAG_DUMP_UNKNOWN_FIELDS);
  XN_FLAG_ONELINE = (ASN1_STRFLGS_RFC2253 or ASN1_STRFLGS_ESC_QUOTE or XN_FLAG_SEP_CPLUS_SPC or XN_FLAG_SPC_EQ or XN_FLAG_FN_SN);
  XN_FLAG_MULTILINE = (ASN1_STRFLGS_ESC_CTRL or ASN1_STRFLGS_ESC_MSB or XN_FLAG_SEP_MULTILINE or XN_FLAG_SPC_EQ or XN_FLAG_FN_LN or XN_FLAG_FN_ALIGN);
  LH_LOAD_MULT = 256;
//  _LHASH = OPENSSL_LHASH;
//  LHASH_NODE = OPENSSL_LH_NODE;
  X509_LU_RETRY = -1;
  X509_LU_FAIL = 0;
  X509_L_FILE_LOAD = 1;
  X509_L_ADD_DIR = 2;
  X509_V_OK = 0;
  X509_V_ERR_UNSPECIFIED = 1;
  X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT = 2;
  X509_V_ERR_UNABLE_TO_GET_CRL = 3;
  X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE = 4;
  X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE = 5;
  X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY = 6;
  X509_V_ERR_CERT_SIGNATURE_FAILURE = 7;
  X509_V_ERR_CRL_SIGNATURE_FAILURE = 8;
  X509_V_ERR_CERT_NOT_YET_VALID = 9;
  X509_V_ERR_CERT_HAS_EXPIRED = 10;
  X509_V_ERR_CRL_NOT_YET_VALID = 11;
  X509_V_ERR_CRL_HAS_EXPIRED = 12;
  X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD = 13;
  X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD = 14;
  X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD = 15;
  X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD = 16;
  X509_V_ERR_OUT_OF_MEM = 17;
  X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT = 18;
  X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN = 19;
  X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY = 20;
  X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE = 21;
  X509_V_ERR_CERT_CHAIN_TOO_LONG = 22;
  X509_V_ERR_CERT_REVOKED = 23;
  X509_V_ERR_INVALID_CA = 24;
  X509_V_ERR_PATH_LENGTH_EXCEEDED = 25;
  X509_V_ERR_INVALID_PURPOSE = 26;
  X509_V_ERR_CERT_UNTRUSTED = 27;
  X509_V_ERR_CERT_REJECTED = 28;
  X509_V_ERR_SUBJECT_ISSUER_MISMATCH = 29;
  X509_V_ERR_AKID_SKID_MISMATCH = 30;
  X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH = 31;
  X509_V_ERR_KEYUSAGE_NO_CERTSIGN = 32;
  X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER = 33;
  X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION = 34;
  X509_V_ERR_KEYUSAGE_NO_CRL_SIGN = 35;
  X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION = 36;
  X509_V_ERR_INVALID_NON_CA = 37;
  X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED = 38;
  X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE = 39;
  X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED = 40;
  X509_V_ERR_INVALID_EXTENSION = 41;
  X509_V_ERR_INVALID_POLICY_EXTENSION = 42;
  X509_V_ERR_NO_EXPLICIT_POLICY = 43;
  X509_V_ERR_DIFFERENT_CRL_SCOPE = 44;
  X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE = 45;
  X509_V_ERR_UNNESTED_RESOURCE = 46;
  X509_V_ERR_PERMITTED_VIOLATION = 47;
  X509_V_ERR_EXCLUDED_VIOLATION = 48;
  X509_V_ERR_SUBTREE_MINMAX = 49;
  X509_V_ERR_APPLICATION_VERIFICATION = 50;
  X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE = 51;
  X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX = 52;
  X509_V_ERR_UNSUPPORTED_NAME_SYNTAX = 53;
  X509_V_ERR_CRL_PATH_VALIDATION_ERROR = 54;
  X509_V_ERR_PATH_LOOP = 55;
  X509_V_ERR_SUITE_B_INVALID_VERSION = 56;
  X509_V_ERR_SUITE_B_INVALID_ALGORITHM = 57;
  X509_V_ERR_SUITE_B_INVALID_CURVE = 58;
  X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM = 59;
  X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED = 60;
  X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256 = 61;
  X509_V_ERR_HOSTNAME_MISMATCH = 62;
  X509_V_ERR_EMAIL_MISMATCH = 63;
  X509_V_ERR_IP_ADDRESS_MISMATCH = 64;
  X509_V_ERR_DANE_NO_MATCH = 65;
  X509_V_ERR_EE_KEY_TOO_SMALL = 66;
  X509_V_ERR_CA_KEY_TOO_SMALL = 67;
  X509_V_ERR_CA_MD_TOO_WEAK = 68;
  X509_V_ERR_INVALID_CALL = 69;
  X509_V_ERR_STORE_LOOKUP = 70;
  X509_V_ERR_NO_VALID_SCTS = 71;
  X509_V_ERR_PROXY_SUBJECT_NAME_VIOLATION = 72;
  X509_V_ERR_OCSP_VERIFY_NEEDED = 73;
  X509_V_ERR_OCSP_VERIFY_FAILED = 74;
  X509_V_ERR_OCSP_CERT_UNKNOWN = 75;
  X509_V_FLAG_CB_ISSUER_CHECK = $0;
  X509_V_FLAG_USE_CHECK_TIME = $2;
  X509_V_FLAG_CRL_CHECK = $4;
  X509_V_FLAG_CRL_CHECK_ALL = $8;
  X509_V_FLAG_IGNORE_CRITICAL = $10;
  X509_V_FLAG_X509_STRICT = $20;
  X509_V_FLAG_ALLOW_PROXY_CERTS = $40;
  X509_V_FLAG_POLICY_CHECK = $80;
  X509_V_FLAG_EXPLICIT_POLICY = $100;
  X509_V_FLAG_INHIBIT_ANY = $200;
  X509_V_FLAG_INHIBIT_MAP = $400;
  X509_V_FLAG_NOTIFY_POLICY = $800;
  X509_V_FLAG_EXTENDED_CRL_SUPPORT = $1000;
  X509_V_FLAG_USE_DELTAS = $2000;
  X509_V_FLAG_CHECK_SS_SIGNATURE = $4000;
  X509_V_FLAG_TRUSTED_FIRST = $8000;
  X509_V_FLAG_SUITEB_128_LOS_ONLY = $10000;
  X509_V_FLAG_SUITEB_192_LOS = $20000;
  X509_V_FLAG_SUITEB_128_LOS = $30000;
  X509_V_FLAG_PARTIAL_CHAIN = $80000;
  X509_V_FLAG_NO_ALT_CHAINS = $100000;
  X509_V_FLAG_NO_CHECK_TIME = $200000;
  X509_VP_FLAG_DEFAULT = $1;
  X509_VP_FLAG_OVERWRITE = $2;
  X509_VP_FLAG_RESET_FLAGS = $4;
  X509_VP_FLAG_LOCKED = $8;
  X509_VP_FLAG_ONCE = $10;
  X509_V_FLAG_POLICY_MASK = (X509_V_FLAG_POLICY_CHECK or X509_V_FLAG_EXPLICIT_POLICY or X509_V_FLAG_INHIBIT_ANY or X509_V_FLAG_INHIBIT_MAP);
  DANE_FLAG_NO_DANE_EE_NAMECHECKS = (1 shl 0);
  X509_PCY_TREE_FAILURE = -2;
  X509_PCY_TREE_INVALID = -1;
  X509_PCY_TREE_INTERNAL = 0;
  X509_PCY_TREE_VALID = 1;
  X509_PCY_TREE_EMPTY = 2;
  X509_PCY_TREE_EXPLICIT = 4;
  PKCS7_F_DO_PKCS7_SIGNED_ATTRIB = 136;
  PKCS7_F_PKCS7_ADD0_ATTRIB_SIGNING_TIME = 135;
  PKCS7_F_PKCS7_ADD_ATTRIB_SMIMECAP = 118;
  PKCS7_F_PKCS7_ADD_CERTIFICATE = 100;
  PKCS7_F_PKCS7_ADD_CRL = 101;
  PKCS7_F_PKCS7_ADD_RECIPIENT_INFO = 102;
  PKCS7_F_PKCS7_ADD_SIGNATURE = 131;
  PKCS7_F_PKCS7_ADD_SIGNER = 103;
  PKCS7_F_PKCS7_BIO_ADD_DIGEST = 125;
  PKCS7_F_PKCS7_COPY_EXISTING_DIGEST = 138;
  PKCS7_F_PKCS7_CTRL = 104;
  PKCS7_F_PKCS7_DATADECODE = 112;
  PKCS7_F_PKCS7_DATAFINAL = 128;
  PKCS7_F_PKCS7_DATAINIT = 105;
  PKCS7_F_PKCS7_DATAVERIFY = 107;
  PKCS7_F_PKCS7_DECRYPT = 114;
  PKCS7_F_PKCS7_DECRYPT_RINFO = 133;
  PKCS7_F_PKCS7_ENCODE_RINFO = 132;
  PKCS7_F_PKCS7_ENCRYPT = 115;
  PKCS7_F_PKCS7_FINAL = 134;
  PKCS7_F_PKCS7_FIND_DIGEST = 127;
  PKCS7_F_PKCS7_GET0_SIGNERS = 124;
  PKCS7_F_PKCS7_RECIP_INFO_SET = 130;
  PKCS7_F_PKCS7_SET_CIPHER = 108;
  PKCS7_F_PKCS7_SET_CONTENT = 109;
  PKCS7_F_PKCS7_SET_DIGEST = 126;
  PKCS7_F_PKCS7_SET_TYPE = 110;
  PKCS7_F_PKCS7_SIGN = 116;
  PKCS7_F_PKCS7_SIGNATUREVERIFY = 113;
  PKCS7_F_PKCS7_SIGNER_INFO_SET = 129;
  PKCS7_F_PKCS7_SIGNER_INFO_SIGN = 139;
  PKCS7_F_PKCS7_SIGN_ADD_SIGNER = 137;
  PKCS7_F_PKCS7_SIMPLE_SMIMECAP = 119;
  PKCS7_F_PKCS7_VERIFY = 117;
  PKCS7_R_CERTIFICATE_VERIFY_ERROR = 117;
  PKCS7_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER = 144;
  PKCS7_R_CIPHER_NOT_INITIALIZED = 116;
  PKCS7_R_CONTENT_AND_DATA_PRESENT = 118;
  PKCS7_R_CTRL_ERROR = 152;
  PKCS7_R_DECRYPT_ERROR = 119;
  PKCS7_R_DIGEST_FAILURE = 101;
  PKCS7_R_ENCRYPTION_CTRL_FAILURE = 149;
  PKCS7_R_ENCRYPTION_NOT_SUPPORTED_FOR_THIS_KEY_TYPE = 150;
  PKCS7_R_ERROR_ADDING_RECIPIENT = 120;
  PKCS7_R_ERROR_SETTING_CIPHER = 121;
  PKCS7_R_INVALID_NULL_POINTER = 143;
  PKCS7_R_INVALID_SIGNED_DATA_TYPE = 155;
  PKCS7_R_NO_CONTENT = 122;
  PKCS7_R_NO_DEFAULT_DIGEST = 151;
  PKCS7_R_NO_MATCHING_DIGEST_TYPE_FOUND = 154;
  PKCS7_R_NO_RECIPIENT_MATCHES_CERTIFICATE = 115;
  PKCS7_R_NO_SIGNATURES_ON_DATA = 123;
  PKCS7_R_NO_SIGNERS = 142;
  PKCS7_R_OPERATION_NOT_SUPPORTED_ON_THIS_TYPE = 104;
  PKCS7_R_PKCS7_ADD_SIGNATURE_ERROR = 124;
  PKCS7_R_PKCS7_ADD_SIGNER_ERROR = 153;
  PKCS7_R_PKCS7_DATASIGN = 145;
  PKCS7_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE = 127;
  PKCS7_R_SIGNATURE_FAILURE = 105;
  PKCS7_R_SIGNER_CERTIFICATE_NOT_FOUND = 128;
  PKCS7_R_SIGNING_CTRL_FAILURE = 147;
  PKCS7_R_SIGNING_NOT_SUPPORTED_FOR_THIS_KEY_TYPE = 148;
  PKCS7_R_SMIME_TEXT_ERROR = 129;
  PKCS7_R_UNABLE_TO_FIND_CERTIFICATE = 106;
  PKCS7_R_UNABLE_TO_FIND_MEM_BIO = 107;
  PKCS7_R_UNABLE_TO_FIND_MESSAGE_DIGEST = 108;
  PKCS7_R_UNKNOWN_DIGEST_TYPE = 109;
  PKCS7_R_UNKNOWN_OPERATION = 110;
  PKCS7_R_UNSUPPORTED_CIPHER_TYPE = 111;
  PKCS7_R_UNSUPPORTED_CONTENT_TYPE = 112;
  PKCS7_R_WRONG_CONTENT_TYPE = 113;
  PKCS7_R_WRONG_PKCS7_TYPE = 114;
  PKCS7_S_HEADER = 0;
  PKCS7_S_BODY = 1;
  PKCS7_S_TAIL = 2;
  PKCS7_OP_SET_DETACHED_SIGNATURE = 1;
  PKCS7_OP_GET_DETACHED_SIGNATURE = 2;
  PKCS7_TEXT = $1;
  PKCS7_NOCERTS = $2;
  PKCS7_NOSIGS = $4;
  PKCS7_NOCHAIN = $8;
  PKCS7_NOINTERN = $10;
  PKCS7_NOVERIFY = $20;
  PKCS7_DETACHED = $40;
  PKCS7_BINARY = $80;
  PKCS7_NOATTR = $100;
  PKCS7_NOSMIMECAP = $200;
  PKCS7_NOOLDMIMETYPE = $400;
  PKCS7_CRLFEOL = $800;
  _PKCS7_STREAM = $1000;
  PKCS7_NOCRL = $2000;
  PKCS7_PARTIAL = $4000;
  PKCS7_REUSE_DIGEST = $8000;
  PKCS7_NO_DUAL_CONTENT = $10000;
  _SMIME_TEXT = PKCS7_TEXT;
  SMIME_NOCERTS = PKCS7_NOCERTS;
  SMIME_NOSIGS = PKCS7_NOSIGS;
  SMIME_NOCHAIN = PKCS7_NOCHAIN;
  SMIME_NOINTERN = PKCS7_NOINTERN;
  SMIME_NOVERIFY = PKCS7_NOVERIFY;
  SMIME_DETACHED = PKCS7_DETACHED;
  SMIME_BINARY = PKCS7_BINARY;
  SMIME_NOATTR = PKCS7_NOATTR;
  SMIME_ASCIICRLF = $80000;
  X509_EXT_PACK_UNKNOWN = 1;
  X509_EXT_PACK_STRING = 2;
  CONF_F_CONF_DUMP_FP = 104;
  CONF_F_CONF_LOAD = 100;
  CONF_F_CONF_LOAD_FP = 103;
  CONF_F_CONF_PARSE_LIST = 119;
  CONF_F_DEF_LOAD = 120;
  CONF_F_DEF_LOAD_BIO = 121;
  CONF_F_GET_NEXT_FILE = 107;
  CONF_F_MODULE_ADD = 122;
  CONF_F_MODULE_INIT = 115;
  CONF_F_MODULE_LOAD_DSO = 117;
  CONF_F_MODULE_RUN = 118;
  CONF_F_NCONF_DUMP_BIO = 105;
  CONF_F_NCONF_DUMP_FP = 106;
  CONF_F_NCONF_GET_NUMBER_E = 112;
  CONF_F_NCONF_GET_SECTION = 108;
  CONF_F_NCONF_GET_STRING = 109;
  CONF_F_NCONF_LOAD = 113;
  CONF_F_NCONF_LOAD_BIO = 110;
  CONF_F_NCONF_LOAD_FP = 114;
  CONF_F_NCONF_NEW = 111;
  CONF_F_PROCESS_INCLUDE = 116;
  CONF_F_SSL_MODULE_INIT = 123;
  CONF_F_STR_COPY = 101;

  CONF_R_RELATIVE_PATH  = 125;
  CONF_R_MISSING_CLOSE_SQUARE_BRACKET = 100;
  CONF_R_ERROR_LOADING_DSO = 110;
  CONF_R_LIST_CANNOT_BE_NULL = 115;
  CONF_R_INVALID_PRAGMA      = 122;
  CONF_R_MISSING_EQUAL_SIGN = 101;
  CONF_R_MISSING_INIT_FUNCTION = 112;
  CONF_R_MODULE_INITIALIZATION_ERROR = 109;
  CONF_R_NO_CLOSE_BRACE = 102;
  CONF_R_NO_CONF = 105;
  CONF_R_NO_CONF_OR_ENVIRONMENT_VARIABLE = 106;
  CONF_R_NO_SECTION = 107;
  CONF_R_NO_SUCH_FILE = 114;
  CONF_R_NO_VALUE = 108;
  CONF_R_NUMBER_TOO_LARGE = 121;
  CONF_R_RECURSIVE_DIRECTORY_INCLUDE = 111;
  CONF_R_SSL_COMMAND_SECTION_EMPTY = 117;
  CONF_R_SSL_COMMAND_SECTION_NOT_FOUND = 118;
  CONF_R_SSL_SECTION_EMPTY = 119;
  CONF_R_SSL_SECTION_NOT_FOUND = 120;
  CONF_R_UNABLE_TO_CREATE_NEW_SECTION = 103;
  CONF_R_UNKNOWN_MODULE_NAME = 113;
  CONF_R_VARIABLE_EXPANSION_TOO_LONG = 116;
  CONF_R_VARIABLE_HAS_NO_VALUE = 104;
  CONF_R_MANDATORY_BRACES_IN_VARIABLE_EXPANSION  =  123;
  CONF_R_OPENSSL_CONF_REFERENCES_MISSING_SECTION =  124;
  CONF_MFLAGS_IGNORE_ERRORS = $1;
  CONF_MFLAGS_IGNORE_RETURN_CODES = $2;
  CONF_MFLAGS_SILENT = $4;
  CONF_MFLAGS_NO_DSO = $8;
  CONF_MFLAGS_IGNORE_MISSING_FILE = $10;
  CONF_MFLAGS_DEFAULT_SECTION = $20;

  DEFAULT_CONF_MFLAGS =
    (CONF_MFLAGS_DEFAULT_SECTION or
     CONF_MFLAGS_IGNORE_MISSING_FILE or
     CONF_MFLAGS_IGNORE_RETURN_CODES);

  X509V3_F_A2I_GENERAL_NAME = 164;
  X509V3_F_ADDR_VALIDATE_PATH_INTERNAL = 166;
  X509V3_F_ASIDENTIFIERCHOICE_CANONIZE = 161;
  X509V3_F_ASIDENTIFIERCHOICE_IS_CANONICAL = 162;
  X509V3_F_BIGNUM_TO_STRING = 167;
  X509V3_F_COPY_EMAIL = 122;
  X509V3_F_COPY_ISSUER = 123;
  X509V3_F_DO_DIRNAME = 144;
  X509V3_F_DO_EXT_I2D = 135;
  X509V3_F_DO_EXT_NCONF = 151;
  X509V3_F_GNAMES_FROM_SECTNAME = 156;
  X509V3_F_I2S_ASN1_ENUMERATED = 121;
  X509V3_F_I2S_ASN1_IA5STRING = 149;
  X509V3_F_I2S_ASN1_INTEGER = 120;
  X509V3_F_I2V_AUTHORITY_INFO_ACCESS = 138;
  X509V3_F_LEVEL_ADD_NODE = 168;
  X509V3_F_NOTICE_SECTION = 132;
  X509V3_F_NREF_NOS = 133;
  X509V3_F_POLICY_CACHE_CREATE = 169;
  X509V3_F_POLICY_CACHE_NEW = 170;
  X509V3_F_POLICY_DATA_NEW = 171;
  X509V3_F_POLICY_SECTION = 131;
  X509V3_F_PROCESS_PCI_VALUE = 150;
  X509V3_F_R2I_CERTPOL = 130;
  X509V3_F_R2I_PCI = 155;
  X509V3_F_S2I_ASN1_IA5STRING = 100;
  X509V3_F_S2I_ASN1_INTEGER = 108;
  X509V3_F_S2I_ASN1_OCTET_STRING = 112;
  X509V3_F_S2I_SKEY_ID = 115;
  X509V3_F_SET_DIST_POINT_NAME = 158;
  X509V3_F_SXNET_ADD_ID_ASC = 125;
  X509V3_F_SXNET_ADD_ID_INTEGER = 126;
  X509V3_F_SXNET_ADD_ID_ULONG = 127;
  X509V3_F_SXNET_GET_ID_ASC = 128;
  X509V3_F_SXNET_GET_ID_ULONG = 129;
  X509V3_F_TREE_INIT = 172;
  X509V3_F_V2I_ASIDENTIFIERS = 163;
  X509V3_F_V2I_ASN1_BIT_STRING = 101;
  X509V3_F_V2I_AUTHORITY_INFO_ACCESS = 139;
  X509V3_F_V2I_AUTHORITY_KEYID = 119;
  X509V3_F_V2I_BASIC_CONSTRAINTS = 102;
  X509V3_F_V2I_CRLD = 134;
  X509V3_F_V2I_EXTENDED_KEY_USAGE = 103;
  X509V3_F_V2I_GENERAL_NAMES = 118;
  X509V3_F_V2I_GENERAL_NAME_EX = 117;
  X509V3_F_V2I_IDP = 157;
  X509V3_F_V2I_IPADDRBLOCKS = 159;
  X509V3_F_V2I_ISSUER_ALT = 153;
  X509V3_F_V2I_NAME_CONSTRAINTS = 147;
  X509V3_F_V2I_POLICY_CONSTRAINTS = 146;
  X509V3_F_V2I_POLICY_MAPPINGS = 145;
  X509V3_F_V2I_SUBJECT_ALT = 154;
  X509V3_F_V2I_TLS_FEATURE = 165;
  X509V3_F_V3_GENERIC_EXTENSION = 116;
  X509V3_F_X509V3_ADD1_I2D = 140;
  X509V3_F_X509V3_ADD_VALUE = 105;
  X509V3_F_X509V3_EXT_ADD = 104;
  X509V3_F_X509V3_EXT_ADD_ALIAS = 106;
  X509V3_F_X509V3_EXT_I2D = 136;
  X509V3_F_X509V3_EXT_NCONF = 152;
  X509V3_F_X509V3_GET_SECTION = 142;
  X509V3_F_X509V3_GET_STRING = 143;
  X509V3_F_X509V3_GET_VALUE_BOOL = 110;
  X509V3_F_X509V3_PARSE_LIST = 109;
  X509V3_F_X509_PURPOSE_ADD = 137;
  X509V3_F_X509_PURPOSE_SET = 141;
  X509V3_R_BAD_IP_ADDRESS = 118;
  X509V3_R_BAD_OBJECT = 119;
  X509V3_R_INVALID_CERTIFICATE = 158;
  X509V3_R_NEGATIVE_PATHLEN = 168;
  X509V3_R_EMPTY_KEY_USAGE  = 169;
  X509V3_R_BAD_VALUE  = 171;
  X509V3_R_UNKNOWN_VALUE = 172;
  X509V3_R_BN_DEC2BN_ERROR = 100;
  X509V3_R_BN_TO_ASN1_INTEGER_ERROR = 101;
  X509V3_R_BAD_OPTION               =               170;
  X509V3_R_DIRNAME_ERROR = 149;
  X509V3_R_DISTPOINT_ALREADY_SET = 160;
  X509V3_R_DUPLICATE_ZONE_ID = 133;
  X509V3_R_ERROR_CONVERTING_ZONE = 131;
  X509V3_R_ERROR_CREATING_EXTENSION = 144;
  X509V3_R_ERROR_IN_EXTENSION = 128;
  X509V3_R_EXPECTED_A_SECTION_NAME = 137;
  X509V3_R_EXTENSION_EXISTS = 145;
  X509V3_R_EXTENSION_NAME_ERROR = 115;
  X509V3_R_EXTENSION_NOT_FOUND = 102;
  X509V3_R_EXTENSION_SETTING_NOT_SUPPORTED = 103;
  X509V3_R_EXTENSION_VALUE_ERROR = 116;
  X509V3_R_ILLEGAL_EMPTY_EXTENSION = 151;
  X509V3_R_INCORRECT_POLICY_SYNTAX_TAG = 152;
  X509V3_R_INVALID_ASNUMBER = 162;
  X509V3_R_INVALID_EMPTY_NAME = 108;
  X509V3_R_INVALID_ASRANGE = 163;
  X509V3_R_INVALID_BOOLEAN_STRING = 104;
  X509V3_R_INVALID_EXTENSION_STRING = 105;
  X509V3_R_INVALID_INHERITANCE = 165;
  X509V3_R_INVALID_IPADDRESS = 166;
  X509V3_R_INVALID_MULTIPLE_RDNS = 161;
  X509V3_R_INVALID_NAME = 106;
  X509V3_R_INVALID_NULL_ARGUMENT = 107;
  X509V3_R_INVALID_NULL_NAME = 108;
  X509V3_R_INVALID_NULL_VALUE = 109;
  X509V3_R_INVALID_NUMBER = 140;
  X509V3_R_INVALID_NUMBERS = 141;
  X509V3_R_INVALID_OBJECT_IDENTIFIER = 110;
  X509V3_R_INVALID_OPTION = 138;
  X509V3_R_INVALID_POLICY_IDENTIFIER = 134;
  X509V3_R_INVALID_PROXY_POLICY_SETTING = 153;
  X509V3_R_INVALID_PURPOSE = 146;
  X509V3_R_INVALID_SAFI = 164;
  X509V3_R_INVALID_SECTION = 135;
  X509V3_R_INVALID_SYNTAX = 143;
  X509V3_R_ISSUER_DECODE_ERROR = 126;
  X509V3_R_MISSING_VALUE = 124;
  X509V3_R_NEED_ORGANIZATION_AND_NUMBERS = 142;
  X509V3_R_NO_CONFIG_DATABASE = 136;
  X509V3_R_NO_ISSUER_CERTIFICATE = 121;
  X509V3_R_NO_ISSUER_DETAILS = 127;
  X509V3_R_NO_POLICY_IDENTIFIER = 139;
  X509V3_R_NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED = 154;
  X509V3_R_NO_PUBLIC_KEY = 114;
  X509V3_R_NO_SUBJECT_DETAILS = 125;
  X509V3_R_OPERATION_NOT_DEFINED = 148;
  X509V3_R_OTHERNAME_ERROR = 147;
  X509V3_R_POLICY_LANGUAGE_ALREADY_DEFINED = 155;
  X509V3_R_POLICY_PATH_LENGTH = 156;
  X509V3_R_POLICY_PATH_LENGTH_ALREADY_DEFINED = 157;
  X509V3_R_POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY = 159;
  X509V3_R_SECTION_NOT_FOUND = 150;
  X509V3_R_UNABLE_TO_GET_ISSUER_DETAILS = 122;
  X509V3_R_UNABLE_TO_GET_ISSUER_KEYID = 123;
  X509V3_R_UNKNOWN_BIT_STRING_ARGUMENT = 111;
  X509V3_R_UNKNOWN_EXTENSION = 129;
  X509V3_R_UNKNOWN_EXTENSION_NAME = 130;
  X509V3_R_UNKNOWN_OPTION = 120;
  X509V3_R_UNSUPPORTED_OPTION = 117;
  X509V3_R_UNSUPPORTED_TYPE = 167;
  X509V3_R_USER_TOO_LONG = 132;
  CTX_TEST = $1;
  X509V3_CTX_REPLACE = $2;
  X509V3_EXT_DYNAMIC = $1;
  X509V3_EXT_CTX_DEP = $2;
  X509V3_EXT_MULTILINE = $4;
  GEN_OTHERNAME = 0;
  GEN_EMAIL = 1;
  GEN_DNS = 2;
  GEN_X400 = 3;
  GEN_DIRNAME = 4;
  GEN_EDIPARTY = 5;
  GEN_URI = 6;
  GEN_IPADD = 7;
  GEN_RID = 8;
  CRLDP_ALL_REASONS = $807f;
  CRL_REASON_NONE = -1;
  CRL_REASON_UNSPECIFIED = 0;
  CRL_REASON_KEY_COMPROMISE = 1;
  CRL_REASON_CA_COMPROMISE = 2;
  CRL_REASON_AFFILIATION_CHANGED = 3;
  CRL_REASON_SUPERSEDED = 4;
  CRL_REASON_CESSATION_OF_OPERATION = 5;
  CRL_REASON_CERTIFICATE_HOLD = 6;
  CRL_REASON_REMOVE_FROM_CRL = 8;
  CRL_REASON_PRIVILEGE_WITHDRAWN = 9;
  CRL_REASON_AA_COMPROMISE = 10;
  IDP_PRESENT = $1;
  IDP_INVALID = $2;
  IDP_ONLYUSER = $4;
  IDP_ONLYCA = $8;
  IDP_ONLYATTR = $10;
  IDP_INDIRECT = $20;
  IDP_REASONS = $40;
  EXFLAG_BCONS = $1;
  EXFLAG_KUSAGE = $2;
  EXFLAG_XKUSAGE = $4;
  EXFLAG_NSCERT = $8;
  EXFLAG_CA = $10;
  EXFLAG_SI = $20;
  EXFLAG_V1 = $40;
  EXFLAG_INVALID = $80;
  EXFLAG_SET = $100;
  EXFLAG_CRITICAL = $200;
  EXFLAG_PROXY = $400;
  EXFLAG_INVALID_POLICY = $800;
  EXFLAG_FRESHEST = $1000;
  EXFLAG_SS = $2000;
  KU_DIGITAL_SIGNATURE = $0080;
  KU_NON_REPUDIATION = $0040;
  KU_KEY_ENCIPHERMENT = $0020;
  KU_DATA_ENCIPHERMENT = $0010;
  KU_KEY_AGREEMENT = $0008;
  KU_KEY_CERT_SIGN = $0004;
  KU_CRL_SIGN = $0002;
  KU_ENCIPHER_ONLY = $0001;
  KU_DECIPHER_ONLY = $8000;
  NS_SSL_CLIENT = $80;
  NS_SSL_SERVER = $40;
  NS_SMIME = $20;
  NS_OBJSIGN = $10;
  NS_SSL_CA = $04;
  NS_SMIME_CA = $02;
  NS_OBJSIGN_CA = $01;
  NS_ANY_CA = (NS_SSL_CA or NS_SMIME_CA or NS_OBJSIGN_CA);
  XKU_SSL_SERVER = $1;
  XKU_SSL_CLIENT = $2;
  XKU_SMIME = $4;
  XKU_CODE_SIGN = $8;
  XKU_SGC = $10;
  XKU_OCSP_SIGN = $20;
  XKU_TIMESTAMP = $40;
  XKU_DVCS = $80;
  XKU_ANYEKU = $100;
  X509_PURPOSE_DYNAMIC = $1;
  X509_PURPOSE_DYNAMIC_NAME = $2;
  X509_PURPOSE_SSL_CLIENT = 1;
  X509_PURPOSE_SSL_SERVER = 2;
  X509_PURPOSE_NS_SSL_SERVER = 3;
  X509_PURPOSE_SMIME_SIGN = 4;
  X509_PURPOSE_SMIME_ENCRYPT = 5;
  X509_PURPOSE_CRL_SIGN = 6;
  X509_PURPOSE_ANY = 7;
  X509_PURPOSE_OCSP_HELPER = 8;
  X509_PURPOSE_TIMESTAMP_SIGN = 9;
  X509_PURPOSE_MIN = 1;
  X509_PURPOSE_MAX = 9;
  X509V3_EXT_UNKNOWN_MASK = ($f shl 16);
  X509V3_EXT_DEFAULT = 0;
  X509V3_EXT_ERROR_UNKNOWN = (1 shl 16);
  X509V3_EXT_PARSE_UNKNOWN = (2 shl 16);
  X509V3_EXT_DUMP_UNKNOWN = (3 shl 16);
  X509V3_ADD_OP_MASK = $f;
  X509V3_ADD_DEFAULT = 0;
  X509V3_ADD_APPEND = 1;
  X509V3_ADD_REPLACE = 2;
  X509V3_ADD_REPLACE_EXISTING = 3;
  X509V3_ADD_KEEP_EXISTING = 4;
  X509V3_ADD_DELETE = 5;
  X509V3_ADD_SILENT = $10;
  X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT = $1;
  X509_CHECK_FLAG_NO_WILDCARDS = $2;
  X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS = $4;
  X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS = $8;
  X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS = $10;
  X509_CHECK_FLAG_NEVER_CHECK_SUBJECT = $20;
  _X509_CHECK_FLAG_DOT_SUBDOMAINS = $8000;
  ASIdOrRange_id = 0;
  ASIdOrRange_range = 1;
  ASIdentifierChoice_inherit = 0;
  ASIdentifierChoice_asIdsOrRanges = 1;
  IPAddressOrRange_addressPrefix = 0;
  IPAddressOrRange_addressRange = 1;
  IPAddressChoice_inherit = 0;
  IPAddressChoice_addressesOrRanges = 1;
  V3_ASID_ASNUM = 0;
  V3_ASID_RDI = 1;
  IANA_AFI_IPV4 = 1;
  IANA_AFI_IPV6 = 2;
  CMS_F_CHECK_CONTENT = 99;
  CMS_F_CMS_ADD0_CERT = 164;
  CMS_F_CMS_ADD0_RECIPIENT_KEY = 100;
  CMS_F_CMS_ADD0_RECIPIENT_PASSWORD = 165;
  CMS_F_CMS_ADD1_RECEIPTREQUEST = 158;
  CMS_F_CMS_ADD1_RECIPIENT_CERT = 101;
  CMS_F_CMS_ADD1_SIGNER = 102;
  CMS_F_CMS_ADD1_SIGNINGTIME = 103;
  CMS_F_CMS_COMPRESS = 104;
  CMS_F_CMS_COMPRESSEDDATA_CREATE = 105;
  CMS_F_CMS_COMPRESSEDDATA_INIT_BIO = 106;
  CMS_F_CMS_COPY_CONTENT = 107;
  CMS_F_CMS_COPY_MESSAGEDIGEST = 108;
  CMS_F_CMS_DATA = 109;
  CMS_F_CMS_DATAFINAL = 110;
  CMS_F_CMS_DATAINIT = 111;
  CMS_F_CMS_DECRYPT = 112;
  CMS_F_CMS_DECRYPT_SET1_KEY = 113;
  CMS_F_CMS_DECRYPT_SET1_PASSWORD = 166;
  CMS_F_CMS_DECRYPT_SET1_PKEY = 114;
  CMS_F_CMS_DIGESTALGORITHM_FIND_CTX = 115;
  CMS_F_CMS_DIGESTALGORITHM_INIT_BIO = 116;
  CMS_F_CMS_DIGESTEDDATA_DO_FINAL = 117;
  CMS_F_CMS_DIGEST_VERIFY = 118;
  CMS_F_CMS_ENCODE_RECEIPT = 161;
  CMS_F_CMS_ENCRYPT = 119;
  CMS_F_CMS_ENCRYPTEDCONTENT_INIT = 179;
  CMS_F_CMS_ENCRYPTEDCONTENT_INIT_BIO = 120;
  CMS_F_CMS_ENCRYPTEDDATA_DECRYPT = 121;
  CMS_F_CMS_ENCRYPTEDDATA_ENCRYPT = 122;
  CMS_F_CMS_ENCRYPTEDDATA_SET1_KEY = 123;
  CMS_F_CMS_ENVELOPEDDATA_CREATE = 124;
  CMS_F_CMS_ENVELOPEDDATA_INIT_BIO = 125;
  CMS_F_CMS_ENVELOPED_DATA_INIT = 126;
  CMS_F_CMS_ENV_ASN1_CTRL = 171;
  CMS_F_CMS_FINAL = 127;
  CMS_F_CMS_GET0_CERTIFICATE_CHOICES = 128;
  CMS_F_CMS_GET0_CONTENT = 129;
  CMS_F_CMS_GET0_ECONTENT_TYPE = 130;
  CMS_F_CMS_GET0_ENVELOPED = 131;
  CMS_F_CMS_GET0_REVOCATION_CHOICES = 132;
  CMS_F_CMS_GET0_SIGNED = 133;
  CMS_F_CMS_MSGSIGDIGEST_ADD1 = 162;
  CMS_F_CMS_RECEIPTREQUEST_CREATE0 = 159;
  CMS_F_CMS_RECEIPT_VERIFY = 160;
  CMS_F_CMS_RECIPIENTINFO_DECRYPT = 134;
  CMS_F_CMS_RECIPIENTINFO_ENCRYPT = 169;
  CMS_F_CMS_RECIPIENTINFO_KARI_ENCRYPT = 178;
  CMS_F_CMS_RECIPIENTINFO_KARI_GET0_ALG = 175;
  CMS_F_CMS_RECIPIENTINFO_KARI_GET0_ORIG_ID = 173;
  CMS_F_CMS_RECIPIENTINFO_KARI_GET0_REKS = 172;
  CMS_F_CMS_RECIPIENTINFO_KARI_ORIG_ID_CMP = 174;
  CMS_F_CMS_RECIPIENTINFO_KEKRI_DECRYPT = 135;
  CMS_F_CMS_RECIPIENTINFO_KEKRI_ENCRYPT = 136;
  CMS_F_CMS_RECIPIENTINFO_KEKRI_GET0_ID = 137;
  CMS_F_CMS_RECIPIENTINFO_KEKRI_ID_CMP = 138;
  CMS_F_CMS_RECIPIENTINFO_KTRI_CERT_CMP = 139;
  CMS_F_CMS_RECIPIENTINFO_KTRI_DECRYPT = 140;
  CMS_F_CMS_RECIPIENTINFO_KTRI_ENCRYPT = 141;
  CMS_F_CMS_RECIPIENTINFO_KTRI_GET0_ALGS = 142;
  CMS_F_CMS_RECIPIENTINFO_KTRI_GET0_SIGNER_ID = 143;
  CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT = 167;
  CMS_F_CMS_RECIPIENTINFO_SET0_KEY = 144;
  CMS_F_CMS_RECIPIENTINFO_SET0_PASSWORD = 168;
  CMS_F_CMS_RECIPIENTINFO_SET0_PKEY = 145;
  CMS_F_CMS_SD_ASN1_CTRL = 170;
  CMS_F_CMS_SET1_IAS = 176;
  CMS_F_CMS_SET1_KEYID = 177;
  CMS_F_CMS_SET1_SIGNERIDENTIFIER = 146;
  CMS_F_CMS_SET_DETACHED = 147;
  CMS_F_CMS_SIGN = 148;
  CMS_F_CMS_SIGNED_DATA_INIT = 149;
  CMS_F_CMS_SIGNERINFO_CONTENT_SIGN = 150;
  CMS_F_CMS_SIGNERINFO_SIGN = 151;
  CMS_F_CMS_SIGNERINFO_VERIFY = 152;
  CMS_F_CMS_SIGNERINFO_VERIFY_CERT = 153;
  CMS_F_CMS_SIGNERINFO_VERIFY_CONTENT = 154;
  CMS_F_CMS_SIGN_RECEIPT = 163;
  CMS_F_CMS_SI_CHECK_ATTRIBUTES = 183;
  CMS_F_CMS_STREAM = 155;
  CMS_F_CMS_UNCOMPRESS = 156;
  CMS_F_CMS_VERIFY = 157;
  CMS_F_KEK_UNWRAP_KEY = 180;
  CMS_R_ADD_SIGNER_ERROR = 99;
  CMS_R_ATTRIBUTE_ERROR = 161;
  CMS_R_CERTIFICATE_ALREADY_PRESENT = 175;
  CMS_R_CIPHER_AEAD_SET_TAG_ERROR   =               184;
  CMS_R_CIPHER_GET_TAG              =               185;
  CMS_R_CERTIFICATE_HAS_NO_KEYID = 160;
  CMS_R_CERTIFICATE_VERIFY_ERROR = 100;
  CMS_R_CIPHER_INITIALISATION_ERROR = 101;
  CMS_R_CIPHER_PARAMETER_INITIALISATION_ERROR = 102;
  CMS_R_CMS_DATAFINAL_ERROR = 103;
  CMS_R_CMS_LIB = 104;
  CMS_R_CONTENTIDENTIFIER_MISMATCH = 170;
  CMS_R_CONTENT_NOT_FOUND = 105;
  CMS_R_CONTENT_TYPE_MISMATCH = 171;
  CMS_R_CONTENT_TYPE_NOT_COMPRESSED_DATA = 106;
  CMS_R_CONTENT_TYPE_NOT_ENVELOPED_DATA = 107;
  CMS_R_CONTENT_TYPE_NOT_SIGNED_DATA = 108;
  CMS_R_CONTENT_VERIFY_ERROR = 109;
  CMS_R_CTRL_ERROR = 110;
  CMS_R_DECODE_ERROR         =                      187;
  CMS_R_ESS_SIGNING_CERTID_MISMATCH_ERROR     =     183;
  CMS_R_CTRL_FAILURE = 111;
  CMS_R_DECRYPT_ERROR = 112;
  CMS_R_ERROR_GETTING_PUBLIC_KEY = 113;
  CMS_R_ERROR_READING_MESSAGEDIGEST_ATTRIBUTE = 114;
  CMS_R_ERROR_SETTING_KEY = 115;
  CMS_R_ERROR_SETTING_RECIPIENTINFO = 116;
  CMS_R_INVALID_ENCRYPTED_KEY_LENGTH = 117;
  CMS_R_INVALID_KEY_ENCRYPTION_PARAMETER = 176;
  CMS_R_INVALID_LABEL                    =          190;
  CMS_R_INVALID_OAEP_PARAMETERS          =          191;
  CMS_R_KDF_PARAMETER_ERROR              =          186;
  CMS_R_INVALID_KEY_LENGTH = 118;
  CMS_R_MD_BIO_INIT_ERROR = 119;
  CMS_R_MESSAGEDIGEST_ATTRIBUTE_WRONG_LENGTH = 120;
  CMS_R_MESSAGEDIGEST_WRONG_LENGTH = 121;
  CMS_R_MSGSIGDIGEST_ERROR = 172;
  CMS_R_MSGSIGDIGEST_VERIFICATION_FAILURE = 162;
  CMS_R_MSGSIGDIGEST_WRONG_LENGTH = 163;
  CMS_R_NEED_ONE_SIGNER = 164;
  CMS_R_NOT_A_SIGNED_RECEIPT = 165;
  CMS_R_NOT_ENCRYPTED_DATA = 122;
  CMS_R_NOT_KEK = 123;
  CMS_R_NOT_KEY_AGREEMENT = 181;
  CMS_R_NOT_KEY_TRANSPORT = 124;
  CMS_R_NOT_PWRI = 177;
  CMS_R_NOT_SUPPORTED_FOR_THIS_KEY_TYPE = 125;
  CMS_R_NO_CIPHER = 126;
  CMS_R_NO_CONTENT = 127;
  CMS_R_NO_CONTENT_TYPE = 173;
  CMS_R_NO_DEFAULT_DIGEST = 128;
  CMS_R_NO_DIGEST_SET = 129;
  CMS_R_NO_KEY = 130;
  CMS_R_NO_KEY_OR_CERT = 174;
  CMS_R_NO_MATCHING_DIGEST = 131;
  CMS_R_NO_MATCHING_RECIPIENT = 132;
  CMS_R_NO_MATCHING_SIGNATURE = 166;
  CMS_R_NO_MSGSIGDIGEST = 167;
  CMS_R_NO_PASSWORD = 178;
  CMS_R_NO_PRIVATE_KEY = 133;
  CMS_R_NO_PUBLIC_KEY = 134;
  CMS_R_NO_RECEIPT_REQUEST = 168;
  CMS_R_NO_SIGNERS = 135;
  CMS_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE = 136;
  CMS_R_PEER_KEY_ERROR                         =    188;
  CMS_R_SHARED_INFO_ERROR                      =    189;
  CMS_R_RECEIPT_DECODE_ERROR = 169;
  CMS_R_RECIPIENT_ERROR = 137;
  CMS_R_SIGNER_CERTIFICATE_NOT_FOUND = 138;
  CMS_R_SIGNFINAL_ERROR = 139;
  CMS_R_SMIME_TEXT_ERROR = 140;
  CMS_R_STORE_INIT_ERROR = 141;
  CMS_R_TYPE_NOT_COMPRESSED_DATA = 142;
  CMS_R_TYPE_NOT_DATA = 143;
  CMS_R_TYPE_NOT_DIGESTED_DATA = 144;
  CMS_R_TYPE_NOT_ENCRYPTED_DATA = 145;
  CMS_R_TYPE_NOT_ENVELOPED_DATA = 146;
  CMS_R_UNABLE_TO_FINALIZE_CONTEXT = 147;
  CMS_R_UNKNOWN_CIPHER = 148;
  CMS_R_UNKNOWN_DIGEST_ALGORITHM = 149;
  CMS_R_UNKNOWN_ID = 150;
  CMS_R_UNSUPPORTED_COMPRESSION_ALGORITHM = 151;
  CMS_R_UNSUPPORTED_CONTENT_TYPE = 152;
  CMS_R_UNSUPPORTED_KEK_ALGORITHM = 153;
  CMS_R_UNSUPPORTED_KEY_ENCRYPTION_ALGORITHM = 179;
  CMS_R_UNSUPPORTED_ENCRYPTION_TYPE          =      192;
  CMS_R_UNSUPPORTED_LABEL_SOURCE             =      193;
  CMS_R_UNSUPPORTED_RECIPIENTINFO_TYPE = 155;
  CMS_R_UNSUPPORTED_RECIPIENT_TYPE = 154;
  CMS_R_UNSUPPORTED_TYPE = 156;
  CMS_R_UNWRAP_ERROR = 157;
  CMS_R_UNWRAP_FAILURE = 180;
  CMS_R_VERIFICATION_FAILURE = 158;
  CMS_R_WRAP_ERROR = 159;
  CMS_SIGNERINFO_ISSUER_SERIAL = 0;
  CMS_SIGNERINFO_KEYIDENTIFIER = 1;
  CMS_RECIPINFO_NONE = -1;
  CMS_RECIPINFO_TRANS = 0;
  CMS_RECIPINFO_AGREE = 1;
  CMS_RECIPINFO_KEK = 2;
  CMS_RECIPINFO_PASS = 3;
  CMS_RECIPINFO_OTHER = 4;
  CMS_TEXT = $1;
  CMS_NOCERTS = $2;
  CMS_NO_CONTENT_VERIFY = $4;
  CMS_NO_ATTR_VERIFY = $8;
  CMS_NOSIGS = (CMS_NO_CONTENT_VERIFY or CMS_NO_ATTR_VERIFY);
  CMS_NOINTERN = $10;
  CMS_NO_SIGNER_CERT_VERIFY = $20;
  CMS_NOVERIFY = $20;
  CMS_DETACHED = $40;
  CMS_BINARY = $80;
  CMS_NOATTR = $100;
  CMS_NOSMIMECAP = $200;
  CMS_NOOLDMIMETYPE = $400;
  CMS_CRLFEOL = $800;
  _CMS_STREAM = $1000;
  CMS_NOCRL = $2000;
  CMS_PARTIAL = $4000;
  CMS_REUSE_DIGEST = $8000;
  CMS_USE_KEYID = $10000;
  CMS_DEBUG_DECRYPT = $20000;
  CMS_KEY_PARAM = $40000;
  CMS_ASCIICRLF = $80000;
  CMS_R_UNKNOWN_DIGEST_ALGORITM = CMS_R_UNKNOWN_DIGEST_ALGORITHM;
  CMS_R_UNSUPPORTED_RECPIENTINFO_TYPE = CMS_R_UNSUPPORTED_RECIPIENTINFO_TYPE;
  COMP_F_BIO_ZLIB_FLUSH = 99;
  COMP_F_BIO_ZLIB_NEW = 100;
  COMP_F_BIO_ZLIB_READ = 101;
  COMP_F_BIO_ZLIB_WRITE = 102;
  COMP_F_COMP_CTX_NEW = 103;
  COMP_R_ZLIB_DEFLATE_ERROR = 99;
  COMP_R_ZLIB_INFLATE_ERROR = 100;
  COMP_R_ZLIB_NOT_SUPPORTED = 101;
  CT_F_CTLOG_NEW = 117;
  CT_F_CTLOG_NEW_FROM_BASE64 = 118;
  CT_F_CTLOG_NEW_FROM_CONF = 119;
  CT_F_CTLOG_STORE_LOAD_CTX_NEW = 122;
  CT_F_CTLOG_STORE_LOAD_FILE = 123;
  CT_F_CTLOG_STORE_LOAD_LOG = 130;
  CT_F_CTLOG_STORE_NEW = 131;
  CT_F_CT_BASE64_DECODE = 124;
  CT_F_CT_POLICY_EVAL_CTX_NEW = 133;
  CT_F_CT_V1_LOG_ID_FROM_PKEY = 125;
  CT_F_I2O_SCT = 107;
  CT_F_I2O_SCT_LIST = 108;
  CT_F_I2O_SCT_SIGNATURE = 109;
  CT_F_O2I_SCT = 110;
  CT_F_O2I_SCT_LIST = 111;
  CT_F_O2I_SCT_SIGNATURE = 112;
  CT_F_SCT_CTX_NEW = 126;
  CT_F_SCT_CTX_VERIFY = 128;
  CT_F_SCT_NEW = 100;
  CT_F_SCT_NEW_FROM_BASE64 = 127;
  CT_F_SCT_SET0_LOG_ID = 101;
  CT_F_SCT_SET1_EXTENSIONS = 114;
  CT_F_SCT_SET1_LOG_ID = 115;
  CT_F_SCT_SET1_SIGNATURE = 116;
  CT_F_SCT_SET_LOG_ENTRY_TYPE = 102;
  CT_F_SCT_SET_SIGNATURE_NID = 103;
  CT_F_SCT_SET_VERSION = 104;
  CT_R_BASE64_DECODE_ERROR = 108;
  CT_R_INVALID_LOG_ID_LENGTH = 100;
  CT_R_LOG_CONF_INVALID = 109;
  CT_R_LOG_CONF_INVALID_KEY = 110;
  CT_R_LOG_CONF_MISSING_DESCRIPTION = 111;
  CT_R_LOG_CONF_MISSING_KEY = 112;
  CT_R_LOG_KEY_INVALID = 113;
  CT_R_SCT_FUTURE_TIMESTAMP = 116;
  CT_R_SCT_INVALID = 104;
  CT_R_SCT_INVALID_SIGNATURE = 107;
  CT_R_SCT_LIST_INVALID = 105;
  CT_R_SCT_LOG_ID_MISMATCH = 114;
  CT_R_SCT_NOT_SET = 106;
  CT_R_SCT_UNSUPPORTED_VERSION = 115;
  CT_R_UNRECOGNIZED_SIGNATURE_NID = 101;
  CT_R_UNSUPPORTED_ENTRY_TYPE = 102;
  CT_R_UNSUPPORTED_VERSION = 103;
  SCT_MIN_RSA_BITS = 2048;
  CT_V1_HASHLEN = SHA256_DIGEST_LENGTH;
  DES_ENCRYPT = 1;
  DES_DECRYPT = 0;
  DES_CBC_MODE = 0;
  DES_PCBC_MODE = 1;
  DTLS1_VERSION = $FEFF;
  DTLS1_2_VERSION = $FEFD;
  DTLS_MIN_VERSION = DTLS1_VERSION;
  DTLS_MAX_VERSION = DTLS1_2_VERSION;
  DTLS1_VERSION_MAJOR = $FE;
  DTLS1_BAD_VER = $0100;
  DTLS_ANY_VERSION = $1FFFF;
  DTLS1_COOKIE_LENGTH = 256;
  DTLS1_RT_HEADER_LENGTH = 13;
  DTLS1_HM_HEADER_LENGTH = 12;
  DTLS1_HM_BAD_FRAGMENT = -2;
  DTLS1_HM_FRAGMENT_RETRY = -3;
  DTLS1_CCS_HEADER_LENGTH = 1;
  DTLS1_AL_HEADER_LENGTH = 2;
  DTLS1_TMO_READ_COUNT = 2;
  DTLS1_TMO_WRITE_COUNT = 2;
  DTLS1_TMO_ALERT_COUNT = 12;
  RAND_F_DATA_COLLECT_METHOD = 127;
  RAND_F_DRBG_BYTES = 101;
  RAND_F_DRBG_GET_ENTROPY = 105;
  RAND_F_DRBG_SETUP = 117;
  RAND_F_GET_ENTROPY = 106;
  RAND_F_RAND_BYTES = 100;
  RAND_F_RAND_DRBG_ENABLE_LOCKING = 119;
  RAND_F_RAND_DRBG_GENERATE = 107;
  RAND_F_RAND_DRBG_GET_ENTROPY = 120;
  RAND_F_RAND_DRBG_GET_NONCE = 123;
  RAND_F_RAND_DRBG_INSTANTIATE = 108;
  RAND_F_RAND_DRBG_NEW = 109;
  RAND_F_RAND_DRBG_RESEED = 110;
  RAND_F_RAND_DRBG_RESTART = 102;
  RAND_F_RAND_DRBG_SET = 104;
  RAND_F_RAND_DRBG_SET_DEFAULTS = 121;
  RAND_F_RAND_DRBG_UNINSTANTIATE = 118;
  RAND_F_RAND_LOAD_FILE = 111;
  RAND_F_RAND_POOL_ACQUIRE_ENTROPY = 122;
  RAND_F_RAND_POOL_ADD = 103;
  RAND_F_RAND_POOL_ADD_BEGIN = 113;
  RAND_F_RAND_POOL_ADD_END = 114;
  RAND_F_RAND_POOL_ATTACH = 124;
  RAND_F_RAND_POOL_BYTES_NEEDED = 115;
  RAND_F_RAND_POOL_GROW = 125;
  RAND_F_RAND_POOL_NEW = 116;
  RAND_F_RAND_PSEUDO_BYTES = 126;
  RAND_F_RAND_WRITE_FILE = 112;
  RAND_R_ADDITIONAL_INPUT_TOO_LONG = 102;
  RAND_R_ALREADY_INSTANTIATED = 103;
  RAND_R_ARGUMENT_OUT_OF_RANGE = 105;
  RAND_R_CANNOT_OPEN_FILE = 121;
  RAND_R_DRBG_ALREADY_INITIALIZED = 129;
  RAND_R_DRBG_NOT_INITIALISED = 104;
  RAND_R_ENTROPY_INPUT_TOO_LONG = 106;
  RAND_R_ENTROPY_OUT_OF_RANGE = 124;
  RAND_R_ERROR_ENTROPY_POOL_WAS_IGNORED = 127;
  RAND_R_ERROR_INITIALISING_DRBG = 107;
  RAND_R_ERROR_INSTANTIATING_DRBG = 108;
  RAND_R_ERROR_RETRIEVING_ADDITIONAL_INPUT = 109;
  RAND_R_ERROR_RETRIEVING_ENTROPY = 110;
  RAND_R_ERROR_RETRIEVING_NONCE = 111;
  RAND_R_FAILED_TO_CREATE_LOCK = 126;
  RAND_R_FUNC_NOT_IMPLEMENTED = 101;
  RAND_R_FWRITE_ERROR = 123;
  RAND_R_GENERATE_ERROR = 112;
  RAND_R_INTERNAL_ERROR = 113;
  RAND_R_IN_ERROR_STATE = 114;
  RAND_R_NOT_A_REGULAR_FILE = 122;
  RAND_R_INSUFFICIENT_DRBG_STRENGTH      = 139;
  RAND_R_NOT_INSTANTIATED = 115;
  RAND_R_NO_DRBG_IMPLEMENTATION_SELECTED = 128;
  RAND_R_PARENT_LOCKING_NOT_ENABLED = 130;
  RAND_R_PARENT_STRENGTH_TOO_WEAK = 131;
  RAND_R_PERSONALISATION_STRING_TOO_LONG = 116;
  RAND_R_PREDICTION_RESISTANCE_NOT_SUPPORTED = 133;
  RAND_R_PRNG_NOT_SEEDED = 100;
  RAND_R_RANDOM_POOL_OVERFLOW = 125;
  RAND_R_RANDOM_POOL_UNDERFLOW = 134;
  RAND_R_REQUEST_TOO_LARGE_FOR_DRBG = 117;
  RAND_R_RESEED_ERROR = 118;
  RAND_R_SELFTEST_FAILURE = 119;
  RAND_R_TOO_LITTLE_NONCE_REQUESTED = 135;
  RAND_R_TOO_MUCH_NONCE_REQUESTED = 136;
 
  PEM_F_B2I_DSS = 127;
  PEM_F_B2I_PVK_BIO = 128;
  PEM_F_B2I_RSA = 129;
  PEM_F_CHECK_BITLEN_DSA = 130;
  PEM_F_CHECK_BITLEN_RSA = 131;
  PEM_F_D2I_PKCS8PRIVATEKEY_BIO = 120;
  PEM_F_D2I_PKCS8PRIVATEKEY_FP = 121;
  PEM_F_DO_B2I = 132;
  PEM_F_DO_B2I_BIO = 133;
  PEM_F_DO_BLOB_HEADER = 134;
  PEM_F_DO_I2B = 146;
  PEM_F_DO_PK8PKEY = 126;
  PEM_F_DO_PK8PKEY_FP = 125;
  PEM_F_DO_PVK_BODY = 135;
  PEM_F_DO_PVK_HEADER = 136;
  PEM_F_GET_HEADER_AND_DATA = 143;
  PEM_F_GET_NAME = 144;
  PEM_F_I2B_PVK = 137;
  PEM_F_I2B_PVK_BIO = 138;
  PEM_F_LOAD_IV = 101;
  PEM_F_PEM_ASN1_READ = 102;
  PEM_F_PEM_ASN1_READ_BIO = 103;
  PEM_F_PEM_ASN1_WRITE = 104;
  PEM_F_PEM_ASN1_WRITE_BIO = 105;
  PEM_F_PEM_DEF_CALLBACK = 100;
  PEM_F_PEM_DO_HEADER = 106;
  PEM_F_PEM_GET_EVP_CIPHER_INFO = 107;
  PEM_F_PEM_READ = 108;
  PEM_F_PEM_READ_BIO = 109;
  PEM_F_PEM_READ_BIO_DHPARAMS = 141;
  PEM_F_PEM_READ_BIO_EX = 145;
  PEM_F_PEM_READ_BIO_PARAMETERS = 140;
  PEM_F_PEM_READ_BIO_PRIVATEKEY = 123;
  PEM_F_PEM_READ_DHPARAMS = 142;
  PEM_F_PEM_READ_PRIVATEKEY = 124;
  PEM_F_PEM_SIGNFINAL = 112;
  PEM_F_PEM_WRITE = 113;
  PEM_F_PEM_WRITE_BIO = 114;
  PEM_F_PEM_WRITE_PRIVATEKEY = 139;
  PEM_F_PEM_X509_INFO_READ = 115;
  PEM_F_PEM_X509_INFO_READ_BIO = 116;
  PEM_F_PEM_X509_INFO_WRITE_BIO = 117;
  PEM_R_BAD_BASE64_DECODE = 100;
  PEM_R_BAD_DECRYPT = 101;
  PEM_R_BAD_END_LINE = 102;
  PEM_R_BAD_IV_CHARS = 103;
  PEM_R_BAD_MAGIC_NUMBER = 116;
  PEM_R_BAD_PASSWORD_READ = 104;
  PEM_R_BAD_VERSION_NUMBER = 117;
  PEM_R_BIO_WRITE_FAILURE = 118;
  PEM_R_CIPHER_IS_NULL = 127;
  PEM_R_ERROR_CONVERTING_PRIVATE_KEY = 115;
  PEM_R_EXPECTING_PRIVATE_KEY_BLOB = 119;
  PEM_R_EXPECTING_PUBLIC_KEY_BLOB = 120;
  PEM_R_HEADER_TOO_LONG = 128;
  PEM_R_INCONSISTENT_HEADER = 121;
  PEM_R_KEYBLOB_HEADER_PARSE_ERROR = 122;
  PEM_R_KEYBLOB_TOO_SHORT = 123;
  PEM_R_MISSING_DEK_IV = 129;
  PEM_R_NOT_DEK_INFO = 105;
  PEM_R_NOT_ENCRYPTED = 106;
  PEM_R_NOT_PROC_TYPE = 107;
  PEM_R_NO_START_LINE = 108;
  PEM_R_PROBLEMS_GETTING_PASSWORD = 109;
  PEM_R_PVK_DATA_TOO_SHORT = 124;
  PEM_R_PVK_TOO_SHORT = 125;
  PEM_R_READ_KEY = 111;
  PEM_R_SHORT_HEADER = 112;
  PEM_R_UNEXPECTED_DEK_IV = 130;
  PEM_R_UNSUPPORTED_CIPHER = 113;
  PEM_R_UNSUPPORTED_ENCRYPTION = 114;
  PEM_R_UNSUPPORTED_KEY_COMPONENTS = 126;
  PEM_R_EXPECTING_DSS_KEY_BLOB = 131;
  PEM_R_EXPECTING_RSA_KEY_BLOB = 132;
  PEM_R_UNSUPPORTED_PUBLIC_KEY_TYPE = 110;
  PEM_BUFSIZE = 1024;
  PEM_STRING_X509_OLD = 'X509 CERTIFICATE';
  PEM_STRING_X509 = 'CERTIFICATE';
  PEM_STRING_X509_TRUSTED = 'TRUSTED CERTIFICATE';
  PEM_STRING_X509_REQ_OLD = 'NEW CERTIFICATE REQUEST';
  PEM_STRING_X509_REQ = 'CERTIFICATE REQUEST';
  PEM_STRING_X509_CRL = 'X509 CRL';
  PEM_STRING_EVP_PKEY = 'ANY PRIVATE KEY';
  PEM_STRING_PUBLIC = 'PUBLIC KEY';
  PEM_STRING_RSA = 'RSA PRIVATE KEY';
  PEM_STRING_RSA_PUBLIC = 'RSA PUBLIC KEY';
  PEM_STRING_DSA = 'DSA PRIVATE KEY';
  PEM_STRING_DSA_PUBLIC = 'DSA PUBLIC KEY';
  PEM_STRING_PKCS7 = 'PKCS7';
  PEM_STRING_PKCS7_SIGNED = 'PKCS #7 SIGNED DATA';
  PEM_STRING_PKCS8 = 'ENCRYPTED PRIVATE KEY';
  PEM_STRING_PKCS8INF = 'PRIVATE KEY';
  PEM_STRING_DHPARAMS = 'DH PARAMETERS';
  PEM_STRING_DHXPARAMS = 'X9.42 DH PARAMETERS';
  PEM_STRING_SSL_SESSION = 'SSL SESSION PARAMETERS';
  PEM_STRING_DSAPARAMS = 'DSA PARAMETERS';
  PEM_STRING_ECDSA_PUBLIC = 'ECDSA PUBLIC KEY';
  PEM_STRING_ECPARAMETERS = 'EC PARAMETERS';
  PEM_STRING_ECPRIVATEKEY = 'EC PRIVATE KEY';
  PEM_STRING_PARAMETERS = 'PARAMETERS';
  PEM_STRING_CMS = 'CMS';
  PEM_TYPE_ENCRYPTED = 10;
  PEM_TYPE_MIC_ONLY = 20;
  PEM_TYPE_MIC_CLEAR = 30;
  PEM_TYPE_CLEAR = 40;
  PEM_FLAG_SECURE = $1;
  PEM_FLAG_EAY_COMPATIBLE = $2;
  PEM_FLAG_ONLY_B64 = $4;
  UI_F_CLOSE_CONSOLE = 115;
  UI_F_ECHO_CONSOLE = 116;
  UI_F_GENERAL_ALLOCATE_BOOLEAN = 108;
  UI_F_GENERAL_ALLOCATE_PROMPT = 109;
  UI_F_NOECHO_CONSOLE = 117;
  UI_F_OPEN_CONSOLE = 114;
  UI_F_UI_CONSTRUCT_PROMPT = 121;
  UI_F_UI_CREATE_METHOD = 112;
  UI_F_UI_CTRL = 111;
  UI_F_UI_DUP_ERROR_STRING = 101;
  UI_F_UI_DUP_INFO_STRING = 102;
  UI_F_UI_DUP_INPUT_BOOLEAN = 110;
  UI_F_UI_DUP_INPUT_STRING = 103;
  UI_F_UI_DUP_USER_DATA = 118;
  UI_F_UI_DUP_VERIFY_STRING = 106;
  UI_F_UI_GET0_RESULT = 107;
  UI_F_UI_GET_RESULT_LENGTH = 119;
  UI_F_UI_NEW_METHOD = 104;
  UI_F_UI_PROCESS = 113;
  UI_F_UI_SET_RESULT = 105;
  UI_F_UI_SET_RESULT_EX = 120;
  UI_R_COMMON_OK_AND_CANCEL_CHARACTERS = 104;
  UI_R_INDEX_TOO_LARGE = 102;
  UI_R_INDEX_TOO_SMALL = 103;
  UI_R_NO_RESULT_BUFFER = 105;
  UI_R_PROCESSING_ERROR = 107;
  UI_R_RESULT_TOO_LARGE = 100;
  UI_R_RESULT_TOO_SMALL = 101;
  UI_R_SYSASSIGN_ERROR = 109;
  UI_R_SYSDASSGN_ERROR = 110;
  UI_R_SYSQIOW_ERROR = 111;
  UI_R_UNKNOWN_CONTROL_COMMAND = 106;
  UI_R_UNKNOWN_TTYGET_ERRNO_VALUE = 108;
  UI_R_USER_DATA_DUPLICATION_UNSUPPORTED = 112;
  UI_INPUT_FLAG_ECHO = $01;
  UI_INPUT_FLAG_DEFAULT_PWD = $02;
  UI_INPUT_FLAG_USER_BASE = 16;
  UI_CTRL_PRINT_ERRORS = 1;
  UI_CTRL_IS_REDOABLE = 2;
  ERR_TXT_MALLOCED = $01;
  ERR_TXT_STRING = $02;
  ERR_FLAG_MARK = $01;
  ERR_FLAG_CLEAR = $02;
  ERR_NUM_ERRORS = 16;
  ERR_LIB_NONE = 1;
  ERR_LIB_SYS = 2;
  ERR_LIB_BN = 3;
  ERR_LIB_RSA = 4;
  ERR_LIB_DH = 5;
  ERR_LIB_EVP = 6;
  ERR_LIB_BUF = 7;
  ERR_LIB_OBJ = 8;
  ERR_LIB_PEM = 9;
  ERR_LIB_DSA = 10;
  ERR_LIB_X509 = 11;
  ERR_LIB_ASN1 = 13;
  ERR_LIB_CONF = 14;
  ERR_LIB_CRYPTO = 15;
  ERR_LIB_EC = 16;
  ERR_LIB_SSL = 20;
  ERR_LIB_BIO = 32;
  ERR_LIB_PKCS7 = 33;
  ERR_LIB_X509V3 = 34;
  ERR_LIB_PKCS12 = 35;
  ERR_LIB_RAND = 36;
  ERR_LIB_DSO = 37;
  ERR_LIB_ENGINE = 38;
  ERR_LIB_OCSP = 39;
  ERR_LIB_UI = 40;
  ERR_LIB_COMP = 41;
  ERR_LIB_ECDSA = 42;
  ERR_LIB_ECDH = 43;
  ERR_LIB_OSSL_STORE = 44;
  ERR_LIB_FIPS = 45;
  ERR_LIB_CMS = 46;
  ERR_LIB_TS = 47;
  ERR_LIB_HMAC = 48;
  ERR_LIB_CT = 50;
  ERR_LIB_ASYNC = 51;
  ERR_LIB_KDF = 52;
  ERR_LIB_SM2 = 53;
  ERR_LIB_USER = 128;
  SYS_F_FOPEN = 1;
  SYS_F_CONNECT = 2;
  SYS_F_GETSERVBYNAME = 3;
  SYS_F_SOCKET = 4;
  SYS_F_IOCTLSOCKET = 5;
  SYS_F_BIND = 6;
  SYS_F_LISTEN = 7;
  SYS_F_ACCEPT = 8;
  SYS_F_WSASTARTUP = 9;
  SYS_F_OPENDIR = 10;
  SYS_F_FREAD = 11;
  SYS_F_GETADDRINFO = 12;
  SYS_F_GETNAMEINFO = 13;
  SYS_F_SETSOCKOPT = 14;
  SYS_F_GETSOCKOPT = 15;
  SYS_F_GETSOCKNAME = 16;
  SYS_F_GETHOSTBYNAME = 17;
  SYS_F_FFLUSH = 18;
  SYS_F_OPEN = 19;
  SYS_F_CLOSE = 20;
  SYS_F_IOCTL = 21;
  SYS_F_STAT = 22;
  SYS_F_FCNTL = 23;
  SYS_F_FSTAT = 24;
  ERR_R_SYS_LIB = ERR_LIB_SYS;
  ERR_R_BN_LIB = ERR_LIB_BN;
  ERR_R_RSA_LIB = ERR_LIB_RSA;
  ERR_R_DH_LIB = ERR_LIB_DH;
  ERR_R_EVP_LIB = ERR_LIB_EVP;
  ERR_R_BUF_LIB = ERR_LIB_BUF;
  ERR_R_OBJ_LIB = ERR_LIB_OBJ;
  ERR_R_PEM_LIB = ERR_LIB_PEM;
  ERR_R_DSA_LIB = ERR_LIB_DSA;
  ERR_R_X509_LIB = ERR_LIB_X509;
  ERR_R_ASN1_LIB = ERR_LIB_ASN1;
  ERR_R_EC_LIB = ERR_LIB_EC;
  ERR_R_BIO_LIB = ERR_LIB_BIO;
  ERR_R_PKCS7_LIB = ERR_LIB_PKCS7;
  ERR_R_X509V3_LIB = ERR_LIB_X509V3;
  ERR_R_ENGINE_LIB = ERR_LIB_ENGINE;
  ERR_R_UI_LIB = ERR_LIB_UI;
  ERR_R_ECDSA_LIB = ERR_LIB_ECDSA;
  ERR_R_OSSL_STORE_LIB = ERR_LIB_OSSL_STORE;
  ERR_R_NESTED_ASN1_ERROR = 58;
  ERR_R_MISSING_ASN1_EOS = 63;
  ERR_R_FATAL = 64;
  ERR_R_MALLOC_FAILURE = (1 or ERR_R_FATAL);
  ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED = (2 or ERR_R_FATAL);
  ERR_R_PASSED_NULL_PARAMETER = (3 or ERR_R_FATAL);
  ERR_R_INTERNAL_ERROR = (4 or ERR_R_FATAL);
  ERR_R_DISABLED = (5 or ERR_R_FATAL);
  ERR_R_INIT_FAIL = (6 or ERR_R_FATAL);
  ERR_R_PASSED_INVALID_ARGUMENT = (7);
  ERR_R_OPERATION_FAIL = (8 or ERR_R_FATAL);
  ENGINE_F_DIGEST_UPDATE = 198;
  ENGINE_F_DYNAMIC_CTRL = 180;
  ENGINE_F_DYNAMIC_GET_DATA_CTX = 181;
  ENGINE_F_DYNAMIC_LOAD = 182;
  ENGINE_F_DYNAMIC_SET_DATA_CTX = 183;
  ENGINE_F_ENGINE_ADD = 105;
  ENGINE_F_ENGINE_BY_ID = 106;
  ENGINE_F_ENGINE_CMD_IS_EXECUTABLE = 170;
  ENGINE_F_ENGINE_CTRL = 142;
  ENGINE_F_ENGINE_CTRL_CMD = 178;
  ENGINE_F_ENGINE_CTRL_CMD_STRING = 171;
  ENGINE_F_ENGINE_FINISH = 107;
  ENGINE_F_ENGINE_GET_CIPHER = 185;
  ENGINE_F_ENGINE_GET_DIGEST = 186;
  ENGINE_F_ENGINE_GET_FIRST = 195;
  ENGINE_F_ENGINE_GET_LAST = 196;
  ENGINE_F_ENGINE_GET_NEXT = 115;
  ENGINE_F_ENGINE_GET_PKEY_ASN1_METH = 193;
  ENGINE_F_ENGINE_GET_PKEY_METH = 192;
  ENGINE_F_ENGINE_GET_PREV = 116;
  ENGINE_F_ENGINE_INIT = 119;
  ENGINE_F_ENGINE_LIST_ADD = 120;
  ENGINE_F_ENGINE_LIST_REMOVE = 121;
  ENGINE_F_ENGINE_LOAD_PRIVATE_KEY = 150;
  ENGINE_F_ENGINE_LOAD_PUBLIC_KEY = 151;
  ENGINE_F_ENGINE_LOAD_SSL_CLIENT_CERT = 194;
  ENGINE_F_ENGINE_NEW = 122;
  ENGINE_F_ENGINE_PKEY_ASN1_FIND_STR = 197;
  ENGINE_F_ENGINE_REMOVE = 123;
  ENGINE_F_ENGINE_SET_DEFAULT_STRING = 189;
  ENGINE_F_ENGINE_SET_ID = 129;
  ENGINE_F_ENGINE_SET_NAME = 130;
  ENGINE_F_ENGINE_TABLE_REGISTER = 184;
  ENGINE_F_ENGINE_UNLOCKED_FINISH = 191;
  ENGINE_F_ENGINE_UP_REF = 190;
  ENGINE_F_INT_CLEANUP_ITEM = 199;
  ENGINE_F_INT_CTRL_HELPER = 172;
  ENGINE_F_INT_ENGINE_CONFIGURE = 188;
  ENGINE_F_INT_ENGINE_MODULE_INIT = 187;
  ENGINE_F_OSSL_HMAC_INIT = 200;
  ENGINE_R_ALREADY_LOADED = 100;
  ENGINE_R_ARGUMENT_IS_NOT_A_NUMBER = 133;
  ENGINE_R_CMD_NOT_EXECUTABLE = 134;
  ENGINE_R_COMMAND_TAKES_INPUT = 135;
  ENGINE_R_COMMAND_TAKES_NO_INPUT = 136;
  ENGINE_R_CONFLICTING_ENGINE_ID = 103;
  ENGINE_R_CTRL_COMMAND_NOT_IMPLEMENTED = 119;
  ENGINE_R_DSO_FAILURE = 104;
  ENGINE_R_DSO_NOT_FOUND = 132;
  ENGINE_R_ENGINES_SECTION_ERROR = 148;
  ENGINE_R_ENGINE_CONFIGURATION_ERROR = 102;
  ENGINE_R_ENGINE_IS_NOT_IN_LIST = 105;
  ENGINE_R_ENGINE_SECTION_ERROR = 149;
  ENGINE_R_FAILED_LOADING_PRIVATE_KEY = 128;
  ENGINE_R_FAILED_LOADING_PUBLIC_KEY = 129;
  ENGINE_R_FINISH_FAILED = 106;
  ENGINE_R_ID_OR_NAME_MISSING = 108;
  ENGINE_R_INIT_FAILED = 109;
  ENGINE_R_INTERNAL_LIST_ERROR = 110;
  ENGINE_R_INVALID_ARGUMENT = 143;
  ENGINE_R_INVALID_CMD_NAME = 137;
  ENGINE_R_INVALID_CMD_NUMBER = 138;
  ENGINE_R_INVALID_INIT_VALUE = 151;
  ENGINE_R_INVALID_STRING = 150;
  ENGINE_R_NOT_INITIALISED = 117;
  ENGINE_R_NOT_LOADED = 112;
  ENGINE_R_NO_CONTROL_FUNCTION = 120;
  ENGINE_R_NO_INDEX = 144;
  ENGINE_R_NO_LOAD_FUNCTION = 125;
  ENGINE_R_NO_REFERENCE = 130;
  ENGINE_R_NO_SUCH_ENGINE = 116;
  ENGINE_R_UNIMPLEMENTED_CIPHER = 146;
  ENGINE_R_UNIMPLEMENTED_DIGEST = 147;
  ENGINE_R_UNIMPLEMENTED_PUBLIC_KEY_METHOD = 101;
  ENGINE_R_VERSION_INCOMPATIBILITY = 145;
  ENGINE_CTRL_SET_LOGSTREAM = 1;
  ENGINE_CTRL_SET_PASSWORD_CALLBACK = 2;
  ENGINE_CTRL_HUP = 3;
  ENGINE_CTRL_SET_USER_INTERFACE = 4;
  ENGINE_CTRL_SET_CALLBACK_DATA = 5;
  ENGINE_CTRL_LOAD_CONFIGURATION = 6;
  ENGINE_CTRL_LOAD_SECTION = 7;
  ENGINE_CTRL_HAS_CTRL_FUNCTION = 10;
  ENGINE_CTRL_GET_FIRST_CMD_TYPE = 11;
  ENGINE_CTRL_GET_NEXT_CMD_TYPE = 12;
  ENGINE_CTRL_GET_CMD_FROM_NAME = 13;
  ENGINE_CTRL_GET_NAME_LEN_FROM_CMD = 14;
  ENGINE_CTRL_GET_NAME_FROM_CMD = 15;
  ENGINE_CTRL_GET_DESC_LEN_FROM_CMD = 16;
  ENGINE_CTRL_GET_DESC_FROM_CMD = 17;
  ENGINE_CTRL_GET_CMD_FLAGS = 18;
  ENGINE_CMD_BASE = 200;
  ENGINE_CTRL_CHIL_SET_FORKCHECK = 100;
  ENGINE_CTRL_CHIL_NO_LOCKING = 101;
  HMAC_MAX_MD_CBLOCK = 128;
  _IDEA_ENCRYPT = 1;
  IDEA_DECRYPT = 0;
  IDEA_BLOCK = 8;
  IDEA_KEY_LENGTH = 16;
  KDF_F_PKEY_HKDF_CTRL_STR = 103;
  KDF_F_PKEY_HKDF_DERIVE = 102;
  KDF_F_PKEY_HKDF_INIT = 108;
  KDF_F_PKEY_SCRYPT_CTRL_STR = 104;
  KDF_F_PKEY_SCRYPT_CTRL_UINT64 = 105;
  KDF_F_PKEY_SCRYPT_DERIVE = 109;
  KDF_F_PKEY_SCRYPT_INIT = 106;
  KDF_F_PKEY_SCRYPT_SET_MEMBUF = 107;
  KDF_F_PKEY_TLS1_PRF_CTRL_STR = 100;
  KDF_F_PKEY_TLS1_PRF_DERIVE = 101;
  KDF_F_PKEY_TLS1_PRF_INIT = 110;
  KDF_F_TLS1_PRF_ALG = 111;
  KDF_R_INVALID_DIGEST = 100;
  KDF_R_MISSING_ITERATION_COUNT = 109;
  KDF_R_MISSING_KEY = 104;
  KDF_R_MISSING_MESSAGE_DIGEST = 105;
  KDF_R_MISSING_PARAMETER = 101;
  KDF_R_MISSING_PASS = 110;
  KDF_R_MISSING_SALT = 111;
  KDF_R_MISSING_SECRET = 107;
  KDF_R_MISSING_SEED = 106;
  KDF_R_UNKNOWN_PARAMETER_TYPE = 103;
  KDF_R_VALUE_ERROR = 108;
  KDF_R_VALUE_MISSING = 102;
  EVP_PKEY_CTRL_TLS_MD = (EVP_PKEY_ALG_CTRL);
  EVP_PKEY_CTRL_TLS_SECRET = (EVP_PKEY_ALG_CTRL+1);
  EVP_PKEY_CTRL_TLS_SEED = (EVP_PKEY_ALG_CTRL+2);
  EVP_PKEY_CTRL_HKDF_MD = (EVP_PKEY_ALG_CTRL+3);
  EVP_PKEY_CTRL_HKDF_SALT = (EVP_PKEY_ALG_CTRL+4);
  EVP_PKEY_CTRL_HKDF_KEY = (EVP_PKEY_ALG_CTRL+5);
  EVP_PKEY_CTRL_HKDF_INFO = (EVP_PKEY_ALG_CTRL+6);
  EVP_PKEY_CTRL_HKDF_MODE = (EVP_PKEY_ALG_CTRL+7);
  EVP_PKEY_CTRL_PASS = (EVP_PKEY_ALG_CTRL+8);
  EVP_PKEY_CTRL_SCRYPT_SALT = (EVP_PKEY_ALG_CTRL+9);
  EVP_PKEY_CTRL_SCRYPT_N = (EVP_PKEY_ALG_CTRL+10);
  EVP_PKEY_CTRL_SCRYPT_R = (EVP_PKEY_ALG_CTRL+11);
  EVP_PKEY_CTRL_SCRYPT_P = (EVP_PKEY_ALG_CTRL+12);
  EVP_PKEY_CTRL_SCRYPT_MAXMEM_BYTES = (EVP_PKEY_ALG_CTRL+13);
  EVP_PKEY_HKDEF_MODE_EXTRACT_AND_EXPAND = 0;
  EVP_PKEY_HKDEF_MODE_EXTRACT_ONLY = 1;
  EVP_PKEY_HKDEF_MODE_EXPAND_ONLY = 2;
  MD4_CBLOCK = 64;
  MD4_LBLOCK = (MD4_CBLOCK div 4);
  MD4_DIGEST_LENGTH = 16;
  MD5_CBLOCK = 64;
  MD5_LBLOCK = (MD5_CBLOCK div 4);
  MD5_DIGEST_LENGTH = 16;
  MDC2_BLOCK = 8;
  MDC2_DIGEST_LENGTH = 16;
  OCSP_REVOKED_STATUS_NOSTATUS = -1;
  OCSP_REVOKED_STATUS_UNSPECIFIED = 0;
  OCSP_REVOKED_STATUS_KEYCOMPROMISE = 1;
  OCSP_REVOKED_STATUS_CACOMPROMISE = 2;
  OCSP_REVOKED_STATUS_AFFILIATIONCHANGED = 3;
  OCSP_REVOKED_STATUS_SUPERSEDED = 4;
  OCSP_REVOKED_STATUS_CESSATIONOFOPERATION = 5;
  OCSP_REVOKED_STATUS_CERTIFICATEHOLD = 6;
  OCSP_REVOKED_STATUS_REMOVEFROMCRL = 8;
  OCSP_F_D2I_OCSP_NONCE = 102;
  OCSP_F_OCSP_BASIC_ADD1_STATUS = 103;
  OCSP_F_OCSP_BASIC_SIGN = 104;
  OCSP_F_OCSP_BASIC_SIGN_CTX = 119;
  OCSP_F_OCSP_BASIC_VERIFY = 105;
  OCSP_F_OCSP_CERT_ID_NEW = 101;
  OCSP_F_OCSP_CHECK_DELEGATED = 106;
  OCSP_F_OCSP_CHECK_IDS = 107;
  OCSP_F_OCSP_CHECK_ISSUER = 108;
  OCSP_F_OCSP_CHECK_VALIDITY = 115;
  OCSP_F_OCSP_MATCH_ISSUERID = 109;
  OCSP_F_OCSP_PARSE_URL = 114;
  OCSP_F_OCSP_REQUEST_SIGN = 110;
  OCSP_F_OCSP_REQUEST_VERIFY = 116;
  OCSP_F_OCSP_RESPONSE_GET1_BASIC = 111;
  OCSP_F_PARSE_HTTP_LINE1 = 118;
  OCSP_R_CERTIFICATE_VERIFY_ERROR = 101;
  OCSP_R_DIGEST_ERR = 102;
  OCSP_R_DIGEST_NAME_ERR           =                106;
  OCSP_R_DIGEST_SIZE_ERR           =                107;
  OCSP_R_ERROR_IN_NEXTUPDATE_FIELD = 122;
  OCSP_R_ERROR_IN_THISUPDATE_FIELD = 123;
  OCSP_R_ERROR_PARSING_URL = 121;
  OCSP_R_MISSING_OCSPSIGNING_USAGE = 103;
  OCSP_R_NEXTUPDATE_BEFORE_THISUPDATE = 124;
  OCSP_R_NOT_BASIC_RESPONSE = 104;
  OCSP_R_NO_CERTIFICATES_IN_CHAIN = 105;
  OCSP_R_NO_RESPONSE_DATA = 108;
  OCSP_R_NO_REVOKED_TIME = 109;
  OCSP_R_NO_SIGNER_KEY = 130;
  OCSP_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE = 110;
  OCSP_R_REQUEST_NOT_SIGNED = 128;
  OCSP_R_RESPONSE_CONTAINS_NO_REVOCATION_DATA = 111;
  OCSP_R_ROOT_CA_NOT_TRUSTED = 112;
  OCSP_R_SERVER_RESPONSE_ERROR = 114;
  OCSP_R_SERVER_RESPONSE_PARSE_ERROR = 115;
  OCSP_R_SIGNATURE_FAILURE = 117;
  OCSP_R_SIGNER_CERTIFICATE_NOT_FOUND = 118;
  OCSP_R_STATUS_EXPIRED = 125;
  OCSP_R_STATUS_NOT_YET_VALID = 126;
  OCSP_R_STATUS_TOO_OLD = 127;
  OCSP_R_UNKNOWN_MESSAGE_DIGEST = 119;
  OCSP_R_UNKNOWN_NID = 120;
  OCSP_R_UNSUPPORTED_REQUESTORNAME_TYPE = 129;
  OCSP_DEFAULT_NONCE_LENGTH = 16;
  OCSP_NOCERTS = $1;
  OCSP_NOINTERN = $2;
  OCSP_NOSIGS = $4;
  OCSP_NOCHAIN = $8;
  OCSP_NOVERIFY = $10;
  OCSP_NOEXPLICIT = $20;
  OCSP_NOCASIGN = $40;
  OCSP_NODELEGATED = $80;
  OCSP_NOCHECKS = $100;
  OCSP_TRUSTOTHER = $200;
  OCSP_RESPID_KEY = $400;
  OCSP_NOTIME = $800;
  OCSP_RESPONSE_STATUS_SUCCESSFUL = 0;
  OCSP_RESPONSE_STATUS_MALFORMEDREQUEST = 1;
  OCSP_RESPONSE_STATUS_INTERNALERROR = 2;
  OCSP_RESPONSE_STATUS_TRYLATER = 3;
  OCSP_RESPONSE_STATUS_SIGREQUIRED = 5;
  OCSP_RESPONSE_STATUS_UNAUTHORIZED = 6;
  V_OCSP_RESPID_NAME = 0;
  V_OCSP_RESPID_KEY = 1;
  V_OCSP_CERTSTATUS_GOOD = 0;
  V_OCSP_CERTSTATUS_REVOKED = 1;
  V_OCSP_CERTSTATUS_UNKNOWN = 2;
  PEM_STRING_OCSP_REQUEST = 'OCSP REQUEST';
  PEM_STRING_OCSP_RESPONSE = 'OCSP RESPONSE';
  PKCS12_F_OPENSSL_ASC2UNI = 121;
  PKCS12_F_OPENSSL_UNI2ASC = 124;
  PKCS12_F_OPENSSL_UNI2UTF8 = 127;
  PKCS12_F_OPENSSL_UTF82UNI = 129;
  PKCS12_F_PKCS12_CREATE = 105;
  PKCS12_F_PKCS12_GEN_MAC = 107;
  PKCS12_F_PKCS12_INIT = 109;
  PKCS12_F_PKCS12_ITEM_DECRYPT_D2I = 106;
  PKCS12_F_PKCS12_ITEM_I2D_ENCRYPT = 108;
  PKCS12_F_PKCS12_ITEM_PACK_SAFEBAG = 117;
  PKCS12_F_PKCS12_KEY_GEN_ASC = 110;
  PKCS12_F_PKCS12_KEY_GEN_UNI = 111;
  PKCS12_F_PKCS12_KEY_GEN_UTF8 = 116;
  PKCS12_F_PKCS12_NEWPASS = 128;
  PKCS12_F_PKCS12_PACK_P7DATA = 114;
  PKCS12_F_PKCS12_PACK_P7ENCDATA = 115;
  PKCS12_F_PKCS12_PARSE = 118;
  PKCS12_F_PKCS12_PBE_CRYPT = 119;
  PKCS12_F_PKCS12_PBE_KEYIVGEN = 120;
  PKCS12_F_PKCS12_SAFEBAG_CREATE0_P8INF = 112;
  PKCS12_F_PKCS12_SAFEBAG_CREATE0_PKCS8 = 113;
  PKCS12_F_PKCS12_SAFEBAG_CREATE_PKCS8_ENCRYPT = 133;
  PKCS12_F_PKCS12_SETUP_MAC = 122;
  PKCS12_F_PKCS12_SET_MAC = 123;
  PKCS12_F_PKCS12_UNPACK_AUTHSAFES = 130;
  PKCS12_F_PKCS12_UNPACK_P7DATA = 131;
  PKCS12_F_PKCS12_VERIFY_MAC = 126;
  PKCS12_F_PKCS8_ENCRYPT = 125;
  PKCS12_F_PKCS8_SET0_PBE = 132;
  PKCS12_R_CANT_PACK_STRUCTURE = 100;
  PKCS12_R_CONTENT_TYPE_NOT_DATA = 121;
  PKCS12_R_DECODE_ERROR = 101;
  PKCS12_R_ENCODE_ERROR = 102;
  PKCS12_R_ENCRYPT_ERROR = 103;
  PKCS12_R_ERROR_SETTING_ENCRYPTED_DATA_TYPE = 120;
  PKCS12_R_INVALID_NULL_ARGUMENT = 104;
  PKCS12_R_INVALID_NULL_PKCS12_POINTER = 105;
  PKCS12_R_INVALID_TYPE                =            112;
  PKCS12_R_IV_GEN_ERROR = 106;
  PKCS12_R_KEY_GEN_ERROR = 107;
  PKCS12_R_MAC_ABSENT = 108;
  PKCS12_R_MAC_GENERATION_ERROR = 109;
  PKCS12_R_MAC_SETUP_ERROR = 110;
  PKCS12_R_MAC_STRING_SET_ERROR = 111;
  PKCS12_R_MAC_VERIFY_FAILURE = 113;
  PKCS12_R_PARSE_ERROR = 114;
  PKCS12_R_PKCS12_ALGOR_CIPHERINIT_ERROR = 115;
  PKCS12_R_PKCS12_CIPHERFINAL_ERROR = 116;
  PKCS12_R_PKCS12_PBE_CRYPT_ERROR = 117;
  PKCS12_R_UNKNOWN_DIGEST_ALGORITHM = 118;
  PKCS12_R_UNSUPPORTED_PKCS12_MODE = 119;
  PKCS12_KEY_ID = 1;
  PKCS12_IV_ID = 2;
  PKCS12_MAC_ID = 3;
  PKCS12_DEFAULT_ITER = PKCS5_DEFAULT_ITER;
  PKCS12_MAC_KEY_LENGTH = 20;
  PKCS12_SALT_LEN = 8;
  KEY_EX = $10;
  KEY_SIG = $80;
  PKCS12_ERROR = 0;
  PKCS12_OK = 1;
  RAND_DRBG_FLAG_CTR_NO_DF = $1;
  RAND_DRBG_USED_FLAGS = (RAND_DRBG_FLAG_CTR_NO_DF);
  RAND_DRBG_STRENGTH = 256;
  RAND_DRBG_TYPE = NID_aes_256_ctr;
  RAND_DRBG_FLAGS = 0;
  _RC2_ENCRYPT = 1;
  _RC2_DECRYPT = 0;
  RC2_BLOCK = 8;
  RC2_KEY_LENGTH = 16;
  RIPEMD160_CBLOCK = 64;
  RIPEMD160_LBLOCK = (RIPEMD160_CBLOCK div 4);
  RIPEMD160_DIGEST_LENGTH = 20;
  SEED_BLOCK_SIZE = 16;
  SEED_KEY_LENGTH = 16;
  SRP_NO_ERROR = 0;
  SRP_ERR_VBASE_INCOMPLETE_FILE = 1;
  SRP_ERR_VBASE_BN_LIB = 2;
  SRP_ERR_OPEN_FILE = 3;
  SRP_ERR_MEMORY = 4;
  DB_srptype = 0;
  DB_srpverifier = 1;
  DB_srpsalt = 2;
  DB_srpid = 3;
  DB_srpgN = 4;
  DB_srpinfo = 5;
  DB_NUMBER = 6;
  DB_SRP_INDEX = 'I';
  DB_SRP_VALID = 'V';
  DB_SRP_REVOKED = 'R';
  DB_SRP_MODIF = 'v';
  SRP_MINIMAL_N = 1024;
  SSL_F_ADD_CLIENT_KEY_SHARE_EXT = 438;
  SSL_F_ADD_KEY_SHARE = 512;
  SSL_F_BYTES_TO_CIPHER_LIST = 519;
  SSL_F_CHECK_SUITEB_CIPHER_LIST = 331;
  SSL_F_CIPHERSUITE_CB = 622;
  SSL_F_CONSTRUCT_CA_NAMES = 552;
  SSL_F_CONSTRUCT_KEY_EXCHANGE_TBS = 553;
  SSL_F_CONSTRUCT_STATEFUL_TICKET = 636;
  SSL_F_CONSTRUCT_STATELESS_TICKET = 637;
  SSL_F_CREATE_SYNTHETIC_MESSAGE_HASH = 539;
  SSL_F_CREATE_TICKET_PREQUEL = 638;
  SSL_F_CT_MOVE_SCTS = 345;
  SSL_F_CT_STRICT = 349;
  SSL_F_CUSTOM_EXT_ADD = 554;
  SSL_F_CUSTOM_EXT_PARSE = 555;
  SSL_F_D2I_SSL_SESSION = 103;
  SSL_F_DANE_CTX_ENABLE = 347;
  SSL_F_DANE_MTYPE_SET = 393;
  SSL_F_DANE_TLSA_ADD = 394;
  SSL_F_DERIVE_SECRET_KEY_AND_IV = 514;
  SSL_F_DO_DTLS1_WRITE = 245;
  SSL_F_DO_SSL3_WRITE = 104;
  SSL_F_DTLS1_BUFFER_RECORD = 247;
  SSL_F_DTLS1_CHECK_TIMEOUT_NUM = 318;
  SSL_F_DTLS1_HEARTBEAT = 305;
  SSL_F_DTLS1_HM_FRAGMENT_NEW = 623;
  SSL_F_DTLS1_PREPROCESS_FRAGMENT = 288;
  SSL_F_DTLS1_PROCESS_BUFFERED_RECORDS = 424;
  SSL_F_DTLS1_PROCESS_RECORD = 257;
  SSL_F_DTLS1_READ_BYTES = 258;
  SSL_F_DTLS1_READ_FAILED = 339;
  SSL_F_DTLS1_RETRANSMIT_MESSAGE = 390;
  SSL_F_DTLS1_WRITE_APP_DATA_BYTES = 268;
  SSL_F_DTLS1_WRITE_BYTES = 545;
  SSL_F_DTLSV1_LISTEN = 350;
  SSL_F_DTLS_CONSTRUCT_CHANGE_CIPHER_SPEC = 371;
  SSL_F_DTLS_CONSTRUCT_HELLO_VERIFY_REQUEST = 385;
  SSL_F_DTLS_GET_REASSEMBLED_MESSAGE = 370;
  SSL_F_DTLS_PROCESS_HELLO_VERIFY = 386;
  SSL_F_DTLS_RECORD_LAYER_NEW = 635;
  SSL_F_DTLS_WAIT_FOR_DRY = 592;
  SSL_F_EARLY_DATA_COUNT_OK = 532;
  SSL_F_FINAL_EARLY_DATA = 556;
  SSL_F_FINAL_EC_PT_FORMATS = 485;
  SSL_F_FINAL_EMS = 486;
  SSL_F_FINAL_KEY_SHARE = 503;
  SSL_F_FINAL_MAXFRAGMENTLEN = 557;
  SSL_F_FINAL_RENEGOTIATE = 483;
  SSL_F_FINAL_SERVER_NAME = 558;
  SSL_F_FINAL_SIG_ALGS = 497;
  SSL_F_GET_CERT_VERIFY_TBS_DATA = 588;
  SSL_F_NSS_KEYLOG_INT = 500;
  SSL_F_OPENSSL_INIT_SSL = 342;
  SSL_F_OSSL_STATEM_CLIENT13_READ_TRANSITION = 436;
  SSL_F_OSSL_STATEM_CLIENT13_WRITE_TRANSITION = 598;
  SSL_F_OSSL_STATEM_CLIENT_CONSTRUCT_MESSAGE = 430;
  SSL_F_OSSL_STATEM_CLIENT_POST_PROCESS_MESSAGE = 593;
  SSL_F_OSSL_STATEM_CLIENT_PROCESS_MESSAGE = 594;
  SSL_F_OSSL_STATEM_CLIENT_READ_TRANSITION = 417;
  SSL_F_OSSL_STATEM_CLIENT_WRITE_TRANSITION = 599;
  SSL_F_OSSL_STATEM_SERVER13_READ_TRANSITION = 437;
  SSL_F_OSSL_STATEM_SERVER13_WRITE_TRANSITION = 600;
  SSL_F_OSSL_STATEM_SERVER_CONSTRUCT_MESSAGE = 431;
  SSL_F_OSSL_STATEM_SERVER_POST_PROCESS_MESSAGE = 601;
  SSL_F_OSSL_STATEM_SERVER_POST_WORK = 602;
  SSL_F_OSSL_STATEM_SERVER_PRE_WORK = 640;
  SSL_F_OSSL_STATEM_SERVER_PROCESS_MESSAGE = 603;
  SSL_F_OSSL_STATEM_SERVER_READ_TRANSITION = 418;
  SSL_F_OSSL_STATEM_SERVER_WRITE_TRANSITION = 604;
  SSL_F_PARSE_CA_NAMES = 541;
  SSL_F_PITEM_NEW = 624;
  SSL_F_PQUEUE_NEW = 625;
  SSL_F_PROCESS_KEY_SHARE_EXT = 439;
  SSL_F_READ_STATE_MACHINE = 352;
  SSL_F_SET_CLIENT_CIPHERSUITE = 540;
  SSL_F_SRP_GENERATE_CLIENT_MASTER_SECRET = 595;
  SSL_F_SRP_GENERATE_SERVER_MASTER_SECRET = 589;
  SSL_F_SRP_VERIFY_SERVER_PARAM = 596;
  SSL_F_SSL3_CHANGE_CIPHER_STATE = 129;
  SSL_F_SSL3_CHECK_CERT_AND_ALGORITHM = 130;
  SSL_F_SSL3_CTRL = 213;
  SSL_F_SSL3_CTX_CTRL = 133;
  SSL_F_SSL3_DIGEST_CACHED_RECORDS = 293;
  SSL_F_SSL3_DO_CHANGE_CIPHER_SPEC = 292;
  SSL_F_SSL3_ENC = 608;
  SSL_F_SSL3_FINAL_FINISH_MAC = 285;
  SSL_F_SSL3_FINISH_MAC = 587;
  SSL_F_SSL3_GENERATE_KEY_BLOCK = 238;
  SSL_F_SSL3_GENERATE_MASTER_SECRET = 388;
  SSL_F_SSL3_GET_RECORD = 143;
  SSL_F_SSL3_INIT_FINISHED_MAC = 397;
  SSL_F_SSL3_OUTPUT_CERT_CHAIN = 147;
  SSL_F_SSL3_READ_BYTES = 148;
  SSL_F_SSL3_READ_N = 149;
  SSL_F_SSL3_SETUP_KEY_BLOCK = 157;
  SSL_F_SSL3_SETUP_READ_BUFFER = 156;
  SSL_F_SSL3_SETUP_WRITE_BUFFER = 291;
  SSL_F_SSL3_WRITE_BYTES = 158;
  SSL_F_SSL3_WRITE_PENDING = 159;
  SSL_F_SSL_ADD_CERT_CHAIN = 316;
  SSL_F_SSL_ADD_CERT_TO_BUF = 319;
  SSL_F_SSL_ADD_CERT_TO_WPACKET = 493;
  SSL_F_SSL_ADD_CLIENTHELLO_RENEGOTIATE_EXT = 298;
  SSL_F_SSL_ADD_CLIENTHELLO_TLSEXT = 277;
  SSL_F_SSL_ADD_CLIENTHELLO_USE_SRTP_EXT = 307;
  SSL_F_SSL_ADD_DIR_CERT_SUBJECTS_TO_STACK = 215;
  SSL_F_SSL_ADD_FILE_CERT_SUBJECTS_TO_STACK = 216;
  SSL_F_SSL_ADD_SERVERHELLO_RENEGOTIATE_EXT = 299;
  SSL_F_SSL_ADD_SERVERHELLO_TLSEXT = 278;
  SSL_F_SSL_ADD_SERVERHELLO_USE_SRTP_EXT = 308;
  SSL_F_SSL_BAD_METHOD = 160;
  SSL_F_SSL_BUILD_CERT_CHAIN = 332;
  SSL_F_SSL_BYTES_TO_CIPHER_LIST = 161;
  SSL_F_SSL_CACHE_CIPHERLIST = 520;
  SSL_F_SSL_CERT_ADD0_CHAIN_CERT = 346;
  SSL_F_SSL_CERT_DUP = 221;
  SSL_F_SSL_CERT_NEW = 162;
  SSL_F_SSL_CERT_SET0_CHAIN = 340;
  SSL_F_SSL_CHECK_PRIVATE_KEY = 163;
  SSL_F_SSL_CHECK_SERVERHELLO_TLSEXT = 280;
  SSL_F_SSL_CHECK_SRP_EXT_CLIENTHELLO = 606;
  SSL_F_SSL_CHECK_SRVR_ECC_CERT_AND_ALG = 279;
  SSL_F_SSL_CHOOSE_CLIENT_VERSION = 607;
  SSL_F_SSL_CIPHER_DESCRIPTION = 626;
  SSL_F_SSL_CIPHER_LIST_TO_BYTES = 425;
  SSL_F_SSL_CIPHER_PROCESS_RULESTR = 230;
  SSL_F_SSL_CIPHER_STRENGTH_SORT = 231;
  SSL_F_SSL_CLEAR = 164;
  SSL_F_SSL_CLIENT_HELLO_GET1_EXTENSIONS_PRESENT = 627;
  SSL_F_SSL_COMP_ADD_COMPRESSION_METHOD = 165;
  SSL_F_SSL_CONF_CMD = 334;
  SSL_F_SSL_CREATE_CIPHER_LIST = 166;
  SSL_F_SSL_CTRL = 232;
  SSL_F_SSL_CTX_CHECK_PRIVATE_KEY = 168;
  SSL_F_SSL_CTX_ENABLE_CT = 398;
  SSL_F_SSL_CTX_MAKE_PROFILES = 309;
  SSL_F_SSL_CTX_NEW = 169;
  SSL_F_SSL_CTX_SET_ALPN_PROTOS = 343;
  SSL_F_SSL_CTX_SET_CIPHER_LIST = 269;
  SSL_F_SSL_CTX_SET_CLIENT_CERT_ENGINE = 290;
  SSL_F_SSL_CTX_SET_CT_VALIDATION_CALLBACK = 396;
  SSL_F_SSL_CTX_SET_SESSION_ID_CONTEXT = 219;
  SSL_F_SSL_CTX_SET_SSL_VERSION = 170;
  SSL_F_SSL_CTX_SET_TLSEXT_MAX_FRAGMENT_LENGTH = 551;
  SSL_F_SSL_CTX_USE_CERTIFICATE = 171;
  SSL_F_SSL_CTX_USE_CERTIFICATE_ASN1 = 172;
  SSL_F_SSL_CTX_USE_CERTIFICATE_FILE = 173;
  SSL_F_SSL_CTX_USE_PRIVATEKEY = 174;
  SSL_F_SSL_CTX_USE_PRIVATEKEY_ASN1 = 175;
  SSL_F_SSL_CTX_USE_PRIVATEKEY_FILE = 176;
  SSL_F_SSL_CTX_USE_PSK_IDENTITY_HINT = 272;
  SSL_F_SSL_CTX_USE_RSAPRIVATEKEY = 177;
  SSL_F_SSL_CTX_USE_RSAPRIVATEKEY_ASN1 = 178;
  SSL_F_SSL_CTX_USE_RSAPRIVATEKEY_FILE = 179;
  SSL_F_SSL_CTX_USE_SERVERINFO = 336;
  SSL_F_SSL_CTX_USE_SERVERINFO_EX = 543;
  SSL_F_SSL_CTX_USE_SERVERINFO_FILE = 337;
  SSL_F_SSL_DANE_DUP = 403;
  SSL_F_SSL_DANE_ENABLE = 395;
  SSL_F_SSL_DERIVE = 590;
  SSL_F_SSL_DO_CONFIG = 391;
  SSL_F_SSL_DO_HANDSHAKE = 180;
  SSL_F_SSL_DUP_CA_LIST = 408;
  SSL_F_SSL_ENABLE_CT = 402;
  SSL_F_SSL_GENERATE_PKEY_GROUP = 559;
  SSL_F_SSL_GENERATE_SESSION_ID = 547;
  SSL_F_SSL_GET_NEW_SESSION = 181;
  SSL_F_SSL_GET_PREV_SESSION = 217;
  SSL_F_SSL_GET_SERVER_CERT_INDEX = 322;
  SSL_F_SSL_GET_SIGN_PKEY = 183;
  SSL_F_SSL_HANDSHAKE_HASH = 560;
  SSL_F_SSL_INIT_WBIO_BUFFER = 184;
  SSL_F_SSL_KEY_UPDATE = 515;
  SSL_F_SSL_LOAD_CLIENT_CA_FILE = 185;
  SSL_F_SSL_LOG_MASTER_SECRET = 498;
  SSL_F_SSL_LOG_RSA_CLIENT_KEY_EXCHANGE = 499;
  SSL_F_SSL_MODULE_INIT = 392;
  SSL_F_SSL_NEW = 186;
  SSL_F_SSL_NEXT_PROTO_VALIDATE = 565;
  SSL_F_SSL_PARSE_CLIENTHELLO_RENEGOTIATE_EXT = 300;
  SSL_F_SSL_PARSE_CLIENTHELLO_TLSEXT = 302;
  SSL_F_SSL_PARSE_CLIENTHELLO_USE_SRTP_EXT = 310;
  SSL_F_SSL_PARSE_SERVERHELLO_RENEGOTIATE_EXT = 301;
  SSL_F_SSL_PARSE_SERVERHELLO_TLSEXT = 303;
  SSL_F_SSL_PARSE_SERVERHELLO_USE_SRTP_EXT = 311;
  SSL_F_SSL_PEEK = 270;
  SSL_F_SSL_PEEK_EX = 432;
  SSL_F_SSL_PEEK_INTERNAL = 522;
  SSL_F_SSL_READ = 223;
  SSL_F_SSL_READ_EARLY_DATA = 529;
  SSL_F_SSL_READ_EX = 434;
  SSL_F_SSL_READ_INTERNAL = 523;
  SSL_F_SSL_RENEGOTIATE = 516;
  SSL_F_SSL_RENEGOTIATE_ABBREVIATED = 546;
  SSL_F_SSL_SCAN_CLIENTHELLO_TLSEXT = 320;
  SSL_F_SSL_SCAN_SERVERHELLO_TLSEXT = 321;
  SSL_F_SSL_SESSION_DUP = 348;
  SSL_F_SSL_SESSION_NEW = 189;
  SSL_F_SSL_SESSION_PRINT_FP = 190;
  SSL_F_SSL_SESSION_SET1_ID = 423;
  SSL_F_SSL_SESSION_SET1_ID_CONTEXT = 312;
  SSL_F_SSL_SET_ALPN_PROTOS = 344;
  SSL_F_SSL_SET_CERT = 191;
  SSL_F_SSL_SET_CERT_AND_KEY = 621;
  SSL_F_SSL_SET_CIPHER_LIST = 271;
  SSL_F_SSL_SET_CT_VALIDATION_CALLBACK = 399;
  SSL_F_SSL_SET_FD = 192;
  SSL_F_SSL_SET_PKEY = 193;
  SSL_F_SSL_SET_RFD = 194;
  SSL_F_SSL_SET_SESSION = 195;
  SSL_F_SSL_SET_SESSION_ID_CONTEXT = 218;
  SSL_F_SSL_SET_SESSION_TICKET_EXT = 294;
  SSL_F_SSL_SET_TLSEXT_MAX_FRAGMENT_LENGTH = 550;
  SSL_F_SSL_SET_WFD = 196;
  SSL_F_SSL_SHUTDOWN = 224;
  SSL_F_SSL_SRP_CTX_INIT = 313;
  SSL_F_SSL_START_ASYNC_JOB = 389;
  SSL_F_SSL_UNDEFINED_FUNCTION = 197;
  SSL_F_SSL_UNDEFINED_VOID_FUNCTION = 244;
  SSL_F_SSL_USE_CERTIFICATE = 198;
  SSL_F_SSL_USE_CERTIFICATE_ASN1 = 199;
  SSL_F_SSL_USE_CERTIFICATE_FILE = 200;
  SSL_F_SSL_USE_PRIVATEKEY = 201;
  SSL_F_SSL_USE_PRIVATEKEY_ASN1 = 202;
  SSL_F_SSL_USE_PRIVATEKEY_FILE = 203;
  SSL_F_SSL_USE_PSK_IDENTITY_HINT = 273;
  SSL_F_SSL_USE_RSAPRIVATEKEY = 204;
  SSL_F_SSL_USE_RSAPRIVATEKEY_ASN1 = 205;
  SSL_F_SSL_USE_RSAPRIVATEKEY_FILE = 206;
  SSL_F_SSL_VALIDATE_CT = 400;
  SSL_F_SSL_VERIFY_CERT_CHAIN = 207;
  SSL_F_SSL_VERIFY_CLIENT_POST_HANDSHAKE = 616;
  SSL_F_SSL_WRITE = 208;
  SSL_F_SSL_WRITE_EARLY_DATA = 526;
  SSL_F_SSL_WRITE_EARLY_FINISH = 527;
  SSL_F_SSL_WRITE_EX = 433;
  SSL_F_SSL_WRITE_INTERNAL = 524;
  SSL_F_STATE_MACHINE = 353;
  SSL_F_TLS12_CHECK_PEER_SIGALG = 333;
  SSL_F_TLS12_COPY_SIGALGS = 533;
  SSL_F_TLS13_CHANGE_CIPHER_STATE = 440;
  SSL_F_TLS13_ENC = 609;
  SSL_F_TLS13_FINAL_FINISH_MAC = 605;
  SSL_F_TLS13_GENERATE_SECRET = 591;
  SSL_F_TLS13_HKDF_EXPAND = 561;
  SSL_F_TLS13_RESTORE_HANDSHAKE_DIGEST_FOR_PHA = 617;
  SSL_F_TLS13_SAVE_HANDSHAKE_DIGEST_FOR_PHA = 618;
  SSL_F_TLS13_SETUP_KEY_BLOCK = 441;
  SSL_F_TLS1_CHANGE_CIPHER_STATE = 209;
  SSL_F_TLS1_CHECK_DUPLICATE_EXTENSIONS = 341;
  SSL_F_TLS1_ENC = 401;
  SSL_F_TLS1_EXPORT_KEYING_MATERIAL = 314;
  SSL_F_TLS1_GET_CURVELIST = 338;
  SSL_F_TLS1_PRF = 284;
  SSL_F_TLS1_SAVE_U16 = 628;
  SSL_F_TLS1_SETUP_KEY_BLOCK = 211;
  SSL_F_TLS1_SET_GROUPS = 629;
  SSL_F_TLS1_SET_RAW_SIGALGS = 630;
  SSL_F_TLS1_SET_SERVER_SIGALGS = 335;
  SSL_F_TLS1_SET_SHARED_SIGALGS = 631;
  SSL_F_TLS1_SET_SIGALGS = 632;
  SSL_F_TLS_CHOOSE_SIGALG = 513;
  SSL_F_TLS_CLIENT_KEY_EXCHANGE_POST_WORK = 354;
  SSL_F_TLS_COLLECT_EXTENSIONS = 435;
  SSL_F_TLS_CONSTRUCT_CERTIFICATE_AUTHORITIES = 542;
  SSL_F_TLS_CONSTRUCT_CERTIFICATE_REQUEST = 372;
  SSL_F_TLS_CONSTRUCT_CERT_STATUS = 429;
  SSL_F_TLS_CONSTRUCT_CERT_STATUS_BODY = 494;
  SSL_F_TLS_CONSTRUCT_CERT_VERIFY = 496;
  SSL_F_TLS_CONSTRUCT_CHANGE_CIPHER_SPEC = 427;
  SSL_F_TLS_CONSTRUCT_CKE_DHE = 404;
  SSL_F_TLS_CONSTRUCT_CKE_ECDHE = 405;
  SSL_F_TLS_CONSTRUCT_CKE_GOST = 406;
  SSL_F_TLS_CONSTRUCT_CKE_PSK_PREAMBLE = 407;
  SSL_F_TLS_CONSTRUCT_CKE_RSA = 409;
  SSL_F_TLS_CONSTRUCT_CKE_SRP = 410;
  SSL_F_TLS_CONSTRUCT_CLIENT_CERTIFICATE = 484;
  SSL_F_TLS_CONSTRUCT_CLIENT_HELLO = 487;
  SSL_F_TLS_CONSTRUCT_CLIENT_KEY_EXCHANGE = 488;
  SSL_F_TLS_CONSTRUCT_CLIENT_VERIFY = 489;
  SSL_F_TLS_CONSTRUCT_CTOS_ALPN = 466;
  SSL_F_TLS_CONSTRUCT_CTOS_CERTIFICATE = 355;
  SSL_F_TLS_CONSTRUCT_CTOS_COOKIE = 535;
  SSL_F_TLS_CONSTRUCT_CTOS_EARLY_DATA = 530;
  SSL_F_TLS_CONSTRUCT_CTOS_EC_PT_FORMATS = 467;
  SSL_F_TLS_CONSTRUCT_CTOS_EMS = 468;
  SSL_F_TLS_CONSTRUCT_CTOS_ETM = 469;
  SSL_F_TLS_CONSTRUCT_CTOS_HELLO = 356;
  SSL_F_TLS_CONSTRUCT_CTOS_KEY_EXCHANGE = 357;
  SSL_F_TLS_CONSTRUCT_CTOS_KEY_SHARE = 470;
  SSL_F_TLS_CONSTRUCT_CTOS_MAXFRAGMENTLEN = 549;
  SSL_F_TLS_CONSTRUCT_CTOS_NPN = 471;
  SSL_F_TLS_CONSTRUCT_CTOS_PADDING = 472;
  SSL_F_TLS_CONSTRUCT_CTOS_POST_HANDSHAKE_AUTH = 619;
  SSL_F_TLS_CONSTRUCT_CTOS_PSK = 501;
  SSL_F_TLS_CONSTRUCT_CTOS_PSK_KEX_MODES = 509;
  SSL_F_TLS_CONSTRUCT_CTOS_RENEGOTIATE = 473;
  SSL_F_TLS_CONSTRUCT_CTOS_SCT = 474;
  SSL_F_TLS_CONSTRUCT_CTOS_SERVER_NAME = 475;
  SSL_F_TLS_CONSTRUCT_CTOS_SESSION_TICKET = 476;
  SSL_F_TLS_CONSTRUCT_CTOS_SIG_ALGS = 477;
  SSL_F_TLS_CONSTRUCT_CTOS_SRP = 478;
  SSL_F_TLS_CONSTRUCT_CTOS_STATUS_REQUEST = 479;
  SSL_F_TLS_CONSTRUCT_CTOS_SUPPORTED_GROUPS = 480;
  SSL_F_TLS_CONSTRUCT_CTOS_SUPPORTED_VERSIONS = 481;
  SSL_F_TLS_CONSTRUCT_CTOS_USE_SRTP = 482;
  SSL_F_TLS_CONSTRUCT_CTOS_VERIFY = 358;
  SSL_F_TLS_CONSTRUCT_ENCRYPTED_EXTENSIONS = 443;
  SSL_F_TLS_CONSTRUCT_END_OF_EARLY_DATA = 536;
  SSL_F_TLS_CONSTRUCT_EXTENSIONS = 447;
  SSL_F_TLS_CONSTRUCT_FINISHED = 359;
  SSL_F_TLS_CONSTRUCT_HELLO_REQUEST = 373;
  SSL_F_TLS_CONSTRUCT_HELLO_RETRY_REQUEST = 510;
  SSL_F_TLS_CONSTRUCT_KEY_UPDATE = 517;
  SSL_F_TLS_CONSTRUCT_NEW_SESSION_TICKET = 428;
  SSL_F_TLS_CONSTRUCT_NEXT_PROTO = 426;
  SSL_F_TLS_CONSTRUCT_SERVER_CERTIFICATE = 490;
  SSL_F_TLS_CONSTRUCT_SERVER_HELLO = 491;
  SSL_F_TLS_CONSTRUCT_SERVER_KEY_EXCHANGE = 492;
  SSL_F_TLS_CONSTRUCT_STOC_ALPN = 451;
  SSL_F_TLS_CONSTRUCT_STOC_CERTIFICATE = 374;
  SSL_F_TLS_CONSTRUCT_STOC_COOKIE = 613;
  SSL_F_TLS_CONSTRUCT_STOC_CRYPTOPRO_BUG = 452;
  SSL_F_TLS_CONSTRUCT_STOC_DONE = 375;
  SSL_F_TLS_CONSTRUCT_STOC_EARLY_DATA = 531;
  SSL_F_TLS_CONSTRUCT_STOC_EARLY_DATA_INFO = 525;
  SSL_F_TLS_CONSTRUCT_STOC_EC_PT_FORMATS = 453;
  SSL_F_TLS_CONSTRUCT_STOC_EMS = 454;
  SSL_F_TLS_CONSTRUCT_STOC_ETM = 455;
  SSL_F_TLS_CONSTRUCT_STOC_HELLO = 376;
  SSL_F_TLS_CONSTRUCT_STOC_KEY_EXCHANGE = 377;
  SSL_F_TLS_CONSTRUCT_STOC_KEY_SHARE = 456;
  SSL_F_TLS_CONSTRUCT_STOC_MAXFRAGMENTLEN = 548;
  SSL_F_TLS_CONSTRUCT_STOC_NEXT_PROTO_NEG = 457;
  SSL_F_TLS_CONSTRUCT_STOC_PSK = 504;
  SSL_F_TLS_CONSTRUCT_STOC_RENEGOTIATE = 458;
  SSL_F_TLS_CONSTRUCT_STOC_SERVER_NAME = 459;
  SSL_F_TLS_CONSTRUCT_STOC_SESSION_TICKET = 460;
  SSL_F_TLS_CONSTRUCT_STOC_STATUS_REQUEST = 461;
  SSL_F_TLS_CONSTRUCT_STOC_SUPPORTED_GROUPS = 544;
  SSL_F_TLS_CONSTRUCT_STOC_SUPPORTED_VERSIONS = 611;
  SSL_F_TLS_CONSTRUCT_STOC_USE_SRTP = 462;
  SSL_F_TLS_EARLY_POST_PROCESS_CLIENT_HELLO = 521;
  SSL_F_TLS_FINISH_HANDSHAKE = 597;
  SSL_F_TLS_GET_MESSAGE_BODY = 351;
  SSL_F_TLS_GET_MESSAGE_HEADER = 387;
  SSL_F_TLS_HANDLE_ALPN = 562;
  SSL_F_TLS_HANDLE_STATUS_REQUEST = 563;
  SSL_F_TLS_PARSE_CERTIFICATE_AUTHORITIES = 566;
  SSL_F_TLS_PARSE_CLIENTHELLO_TLSEXT = 449;
  SSL_F_TLS_PARSE_CTOS_ALPN = 567;
  SSL_F_TLS_PARSE_CTOS_COOKIE = 614;
  SSL_F_TLS_PARSE_CTOS_EARLY_DATA = 568;
  SSL_F_TLS_PARSE_CTOS_EC_PT_FORMATS = 569;
  SSL_F_TLS_PARSE_CTOS_EMS = 570;
  SSL_F_TLS_PARSE_CTOS_KEY_SHARE = 463;
  SSL_F_TLS_PARSE_CTOS_MAXFRAGMENTLEN = 571;
  SSL_F_TLS_PARSE_CTOS_POST_HANDSHAKE_AUTH = 620;
  SSL_F_TLS_PARSE_CTOS_PSK = 505;
  SSL_F_TLS_PARSE_CTOS_PSK_KEX_MODES = 572;
  SSL_F_TLS_PARSE_CTOS_RENEGOTIATE = 464;
  SSL_F_TLS_PARSE_CTOS_SERVER_NAME = 573;
  SSL_F_TLS_PARSE_CTOS_SESSION_TICKET = 574;
  SSL_F_TLS_PARSE_CTOS_SIG_ALGS = 575;
  SSL_F_TLS_PARSE_CTOS_SIG_ALGS_CERT = 615;
  SSL_F_TLS_PARSE_CTOS_SRP = 576;
  SSL_F_TLS_PARSE_CTOS_STATUS_REQUEST = 577;
  SSL_F_TLS_PARSE_CTOS_SUPPORTED_GROUPS = 578;
  SSL_F_TLS_PARSE_CTOS_USE_SRTP = 465;
  SSL_F_TLS_PARSE_STOC_ALPN = 579;
  SSL_F_TLS_PARSE_STOC_COOKIE = 534;
  SSL_F_TLS_PARSE_STOC_EARLY_DATA = 538;
  SSL_F_TLS_PARSE_STOC_EARLY_DATA_INFO = 528;
  SSL_F_TLS_PARSE_STOC_EC_PT_FORMATS = 580;
  SSL_F_TLS_PARSE_STOC_KEY_SHARE = 445;
  SSL_F_TLS_PARSE_STOC_MAXFRAGMENTLEN = 581;
  SSL_F_TLS_PARSE_STOC_NPN = 582;
  SSL_F_TLS_PARSE_STOC_PSK = 502;
  SSL_F_TLS_PARSE_STOC_RENEGOTIATE = 448;
  SSL_F_TLS_PARSE_STOC_SCT = 564;
  SSL_F_TLS_PARSE_STOC_SERVER_NAME = 583;
  SSL_F_TLS_PARSE_STOC_SESSION_TICKET = 584;
  SSL_F_TLS_PARSE_STOC_STATUS_REQUEST = 585;
  SSL_F_TLS_PARSE_STOC_SUPPORTED_VERSIONS = 612;
  SSL_F_TLS_PARSE_STOC_USE_SRTP = 446;
  SSL_F_TLS_POST_PROCESS_CLIENT_HELLO = 378;
  SSL_F_TLS_POST_PROCESS_CLIENT_KEY_EXCHANGE = 384;
  SSL_F_TLS_PREPARE_CLIENT_CERTIFICATE = 360;
  SSL_F_TLS_PROCESS_AS_HELLO_RETRY_REQUEST = 610;
  SSL_F_TLS_PROCESS_CERTIFICATE_REQUEST = 361;
  SSL_F_TLS_PROCESS_CERT_STATUS = 362;
  SSL_F_TLS_PROCESS_CERT_STATUS_BODY = 495;
  SSL_F_TLS_PROCESS_CERT_VERIFY = 379;
  SSL_F_TLS_PROCESS_CHANGE_CIPHER_SPEC = 363;
  SSL_F_TLS_PROCESS_CKE_DHE = 411;
  SSL_F_TLS_PROCESS_CKE_ECDHE = 412;
  SSL_F_TLS_PROCESS_CKE_GOST = 413;
  SSL_F_TLS_PROCESS_CKE_PSK_PREAMBLE = 414;
  SSL_F_TLS_PROCESS_CKE_RSA = 415;
  SSL_F_TLS_PROCESS_CKE_SRP = 416;
  SSL_F_TLS_PROCESS_CLIENT_CERTIFICATE = 380;
  SSL_F_TLS_PROCESS_CLIENT_HELLO = 381;
  SSL_F_TLS_PROCESS_CLIENT_KEY_EXCHANGE = 382;
  SSL_F_TLS_PROCESS_ENCRYPTED_EXTENSIONS = 444;
  SSL_F_TLS_PROCESS_END_OF_EARLY_DATA = 537;
  SSL_F_TLS_PROCESS_FINISHED = 364;
  SSL_F_TLS_PROCESS_HELLO_REQ = 507;
  SSL_F_TLS_PROCESS_HELLO_RETRY_REQUEST = 511;
  SSL_F_TLS_PROCESS_INITIAL_SERVER_FLIGHT = 442;
  SSL_F_TLS_PROCESS_KEY_EXCHANGE = 365;
  SSL_F_TLS_PROCESS_KEY_UPDATE = 518;
  SSL_F_TLS_PROCESS_NEW_SESSION_TICKET = 366;
  SSL_F_TLS_PROCESS_NEXT_PROTO = 383;
  SSL_F_TLS_PROCESS_SERVER_CERTIFICATE = 367;
  SSL_F_TLS_PROCESS_SERVER_DONE = 368;
  SSL_F_TLS_PROCESS_SERVER_HELLO = 369;
  SSL_F_TLS_PROCESS_SKE_DHE = 419;
  SSL_F_TLS_PROCESS_SKE_ECDHE = 420;
  SSL_F_TLS_PROCESS_SKE_PSK_PREAMBLE = 421;
  SSL_F_TLS_PROCESS_SKE_SRP = 422;
  SSL_F_TLS_PSK_DO_BINDER = 506;
  SSL_F_TLS_SCAN_CLIENTHELLO_TLSEXT = 450;
  SSL_F_TLS_SETUP_HANDSHAKE = 508;
  SSL_F_USE_CERTIFICATE_CHAIN_FILE = 220;
  SSL_F_WPACKET_INTERN_INIT_LEN = 633;
  SSL_F_WPACKET_START_SUB_PACKET_LEN__ = 634;
  SSL_F_WRITE_STATE_MACHINE = 586;
  SSL_R_APPLICATION_DATA_AFTER_CLOSE_NOTIFY = 291;
  SSL_R_APP_DATA_IN_HANDSHAKE = 100;
  SSL_R_ATTEMPT_TO_REUSE_SESSION_IN_DIFFERENT_CONTEXT = 272;
  SSL_R_AT_LEAST_TLS_1_0_NEEDED_IN_FIPS_MODE = 143;
  SSL_R_AT_LEAST_TLS_1_2_NEEDED_IN_SUITEB_MODE = 158;
  SSL_R_BAD_CHANGE_CIPHER_SPEC = 103;
  SSL_R_BAD_CIPHER = 186;
  SSL_R_BAD_DATA = 390;
  SSL_R_BAD_DATA_RETURNED_BY_CALLBACK = 106;
  SSL_R_BAD_DECOMPRESSION = 107;
  SSL_R_BAD_DH_VALUE = 102;
  SSL_R_BAD_DIGEST_LENGTH = 111;
  SSL_R_BAD_EARLY_DATA = 233;
  SSL_R_BAD_ECC_CERT = 304;
  SSL_R_BAD_ECPOINT = 306;
  SSL_R_BAD_EXTENSION = 110;
  SSL_R_BAD_HANDSHAKE_LENGTH = 332;
  SSL_R_BAD_HANDSHAKE_STATE = 236;
  SSL_R_BAD_HELLO_REQUEST = 105;
  SSL_R_BAD_HRR_VERSION = 263;
  SSL_R_BAD_KEY_SHARE = 108;
  SSL_R_BAD_KEY_UPDATE = 122;
  SSL_R_BAD_LEGACY_VERSION = 292;
  SSL_R_BAD_LENGTH = 271;
  SSL_R_BAD_PACKET = 240;
  SSL_R_BAD_PACKET_LENGTH = 115;
  SSL_R_BAD_PROTOCOL_VERSION_NUMBER = 116;
  SSL_R_BAD_PSK = 219;
  SSL_R_BAD_PSK_IDENTITY = 114;
  SSL_R_BAD_RECORD_TYPE = 443;
  SSL_R_BAD_RSA_ENCRYPT = 119;
  SSL_R_BAD_SIGNATURE = 123;
  SSL_R_BAD_SRP_A_LENGTH = 347;
  SSL_R_BAD_SRP_PARAMETERS = 371;
  SSL_R_BAD_SRTP_MKI_VALUE = 352;
  SSL_R_BAD_SRTP_PROTECTION_PROFILE_LIST = 353;
  SSL_R_BAD_SSL_FILETYPE = 124;
  SSL_R_BAD_VALUE = 384;
  SSL_R_BAD_WRITE_RETRY = 127;
  SSL_R_BINDER_DOES_NOT_VERIFY = 253;
  SSL_R_BIO_NOT_SET = 128;
  SSL_R_BLOCK_CIPHER_PAD_IS_WRONG = 129;
  SSL_R_BN_LIB = 130;
  SSL_R_CALLBACK_FAILED = 234;
  SSL_R_CANNOT_CHANGE_CIPHER = 109;
  SSL_R_CA_DN_LENGTH_MISMATCH = 131;
  SSL_R_CA_KEY_TOO_SMALL = 397;
  SSL_R_CA_MD_TOO_WEAK = 398;
  SSL_R_CCS_RECEIVED_EARLY = 133;
  SSL_R_CERTIFICATE_VERIFY_FAILED = 134;
  SSL_R_CERT_CB_ERROR = 377;
  SSL_R_CERT_LENGTH_MISMATCH = 135;
  SSL_R_CIPHERSUITE_DIGEST_HAS_CHANGED = 218;
  SSL_R_CIPHER_CODE_WRONG_LENGTH = 137;
  SSL_R_CIPHER_OR_HASH_UNAVAILABLE = 138;
  SSL_R_CLIENTHELLO_TLSEXT = 226;
  SSL_R_COMPRESSED_LENGTH_TOO_LONG = 140;
  SSL_R_COMPRESSION_DISABLED = 343;
  SSL_R_COMPRESSION_FAILURE = 141;
  SSL_R_COMPRESSION_ID_NOT_WITHIN_PRIVATE_RANGE = 307;
  SSL_R_COMPRESSION_LIBRARY_ERROR = 142;
  SSL_R_CONNECTION_TYPE_NOT_SET = 144;
  SSL_R_CONTEXT_NOT_DANE_ENABLED = 167;
  SSL_R_COOKIE_GEN_CALLBACK_FAILURE = 400;
  SSL_R_COOKIE_MISMATCH = 308;
  SSL_R_CUSTOM_EXT_HANDLER_ALREADY_INSTALLED = 206;
  SSL_R_DANE_ALREADY_ENABLED = 172;
  SSL_R_DANE_CANNOT_OVERRIDE_MTYPE_FULL = 173;
  SSL_R_DANE_NOT_ENABLED = 175;
  SSL_R_DANE_TLSA_BAD_CERTIFICATE = 180;
  SSL_R_DANE_TLSA_BAD_CERTIFICATE_USAGE = 184;
  SSL_R_DANE_TLSA_BAD_DATA_LENGTH = 189;
  SSL_R_DANE_TLSA_BAD_DIGEST_LENGTH = 192;
  SSL_R_DANE_TLSA_BAD_MATCHING_TYPE = 200;
  SSL_R_DANE_TLSA_BAD_PUBLIC_KEY = 201;
  SSL_R_DANE_TLSA_BAD_SELECTOR = 202;
  SSL_R_DANE_TLSA_NULL_DATA = 203;
  SSL_R_DATA_BETWEEN_CCS_AND_FINISHED = 145;
  SSL_R_DATA_LENGTH_TOO_LONG = 146;
  SSL_R_DECRYPTION_FAILED = 147;
  SSL_R_DECRYPTION_FAILED_OR_BAD_RECORD_MAC = 281;
  SSL_R_DH_KEY_TOO_SMALL = 394;
  SSL_R_DH_PUBLIC_VALUE_LENGTH_IS_WRONG = 148;
  SSL_R_DIGEST_CHECK_FAILED = 149;
  SSL_R_DTLS_MESSAGE_TOO_BIG = 334;
  SSL_R_DUPLICATE_COMPRESSION_ID = 309;
  SSL_R_ECC_CERT_NOT_FOR_SIGNING = 318;
  SSL_R_ECDH_REQUIRED_FOR_SUITEB_MODE = 374;
  SSL_R_EE_KEY_TOO_SMALL = 399;
  SSL_R_EMPTY_SRTP_PROTECTION_PROFILE_LIST = 354;
  SSL_R_ENCRYPTED_LENGTH_TOO_LONG = 150;
  SSL_R_ERROR_IN_RECEIVED_CIPHER_LIST = 151;
  SSL_R_ERROR_SETTING_TLSA_BASE_DOMAIN = 204;
  SSL_R_EXCEEDS_MAX_FRAGMENT_SIZE = 194;
  SSL_R_EXCESSIVE_MESSAGE_SIZE = 152;
  SSL_R_EXTENSION_NOT_RECEIVED = 279;
  SSL_R_EXTRA_DATA_IN_MESSAGE = 153;
  SSL_R_EXT_LENGTH_MISMATCH = 163;
  SSL_R_FAILED_TO_INIT_ASYNC = 405;
  SSL_R_FRAGMENTED_CLIENT_HELLO = 401;
  SSL_R_GOT_A_FIN_BEFORE_A_CCS = 154;
  SSL_R_HTTPS_PROXY_REQUEST = 155;
  SSL_R_HTTP_REQUEST = 156;
  SSL_R_ILLEGAL_POINT_COMPRESSION = 162;
  SSL_R_ILLEGAL_SUITEB_DIGEST = 380;
  SSL_R_INAPPROPRIATE_FALLBACK = 373;
  SSL_R_INCONSISTENT_COMPRESSION = 340;
  SSL_R_INCONSISTENT_EARLY_DATA_ALPN = 222;
  SSL_R_INCONSISTENT_EARLY_DATA_SNI = 231;
  SSL_R_INCONSISTENT_EXTMS = 104;
  SSL_R_INSUFFICIENT_SECURITY = 241;
  SSL_R_INVALID_ALERT = 205;
  SSL_R_INVALID_CCS_MESSAGE = 260;
  SSL_R_INVALID_CERTIFICATE_OR_ALG = 238;
  SSL_R_INVALID_COMMAND = 280;
  SSL_R_INVALID_COMPRESSION_ALGORITHM = 341;
  SSL_R_INVALID_CONFIG = 283;
  SSL_R_INVALID_CONFIGURATION_NAME = 113;
  SSL_R_INVALID_CONTEXT = 282;
  SSL_R_INVALID_CT_VALIDATION_TYPE = 212;
  SSL_R_INVALID_KEY_UPDATE_TYPE = 120;
  SSL_R_INVALID_MAX_EARLY_DATA = 174;
  SSL_R_INVALID_NULL_CMD_NAME = 385;
  SSL_R_INVALID_SEQUENCE_NUMBER = 402;
  SSL_R_INVALID_SERVERINFO_DATA = 388;
  SSL_R_INVALID_SESSION_ID = 999;
  SSL_R_INVALID_SRP_USERNAME = 357;
  SSL_R_INVALID_STATUS_RESPONSE = 328;
  SSL_R_INVALID_TICKET_KEYS_LENGTH = 325;
  SSL_R_LENGTH_MISMATCH = 159;
  SSL_R_LENGTH_TOO_LONG = 404;
  SSL_R_LENGTH_TOO_SHORT = 160;
  SSL_R_LIBRARY_BUG = 274;
  SSL_R_LIBRARY_HAS_NO_CIPHERS = 161;
  SSL_R_MISSING_DSA_SIGNING_CERT = 165;
  SSL_R_MISSING_ECDSA_SIGNING_CERT = 381;
  SSL_R_MISSING_FATAL = 256;
  SSL_R_MISSING_PARAMETERS = 290;
  SSL_R_MISSING_RSA_CERTIFICATE = 168;
  SSL_R_MISSING_RSA_ENCRYPTING_CERT = 169;
  SSL_R_MISSING_RSA_SIGNING_CERT = 170;
  SSL_R_MISSING_SIGALGS_EXTENSION = 112;
  SSL_R_MISSING_SIGNING_CERT = 221;
  SSL_R_MISSING_SRP_PARAM = 358;
  SSL_R_MISSING_SUPPORTED_GROUPS_EXTENSION = 209;
  SSL_R_MISSING_TMP_DH_KEY = 171;
  SSL_R_MISSING_TMP_ECDH_KEY = 311;
  SSL_R_MIXED_HANDSHAKE_AND_NON_HANDSHAKE_DATA = 293;
  SSL_R_NOT_ON_RECORD_BOUNDARY = 182;
  SSL_R_NOT_REPLACING_CERTIFICATE = 289;
  SSL_R_NOT_SERVER = 284;
  SSL_R_NO_APPLICATION_PROTOCOL = 235;
  SSL_R_NO_CERTIFICATES_RETURNED = 176;
  SSL_R_NO_CERTIFICATE_ASSIGNED = 177;
  SSL_R_NO_CERTIFICATE_SET = 179;
  SSL_R_NO_CHANGE_FOLLOWING_HRR = 214;
  SSL_R_NO_CIPHERS_AVAILABLE = 181;
  SSL_R_NO_CIPHERS_SPECIFIED = 183;
  SSL_R_NO_CIPHER_MATCH = 185;
  SSL_R_NO_CLIENT_CERT_METHOD = 331;
  SSL_R_NO_COMPRESSION_SPECIFIED = 187;
  SSL_R_NO_COOKIE_CALLBACK_SET = 287;
  SSL_R_NO_GOST_CERTIFICATE_SENT_BY_PEER = 330;
  SSL_R_NO_METHOD_SPECIFIED = 188;
  SSL_R_NO_PEM_EXTENSIONS = 389;
  SSL_R_NO_PRIVATE_KEY_ASSIGNED = 190;
  SSL_R_NO_PROTOCOLS_AVAILABLE = 191;
  SSL_R_NO_RENEGOTIATION = 339;
  SSL_R_NO_REQUIRED_DIGEST = 324;
  SSL_R_NO_SHARED_CIPHER = 193;
  SSL_R_NO_SHARED_GROUPS = 410;
  SSL_R_NO_SHARED_SIGNATURE_ALGORITHMS = 376;
  SSL_R_NO_SRTP_PROFILES = 359;
  SSL_R_NO_SUITABLE_KEY_SHARE = 101;
  SSL_R_NO_SUITABLE_SIGNATURE_ALGORITHM = 118;
  SSL_R_NO_VALID_SCTS = 216;
  SSL_R_NO_VERIFY_COOKIE_CALLBACK = 403;
  SSL_R_NULL_SSL_CTX = 195;
  SSL_R_NULL_SSL_METHOD_PASSED = 196;
  SSL_R_OLD_SESSION_CIPHER_NOT_RETURNED = 197;
  SSL_R_OLD_SESSION_COMPRESSION_ALGORITHM_NOT_RETURNED = 344;
  SSL_R_OVERFLOW_ERROR = 237;
  SSL_R_PACKET_LENGTH_TOO_LONG = 198;
  SSL_R_PARSE_TLSEXT = 227;
  SSL_R_PATH_TOO_LONG = 270;
  SSL_R_PEER_DID_NOT_RETURN_A_CERTIFICATE = 199;
  SSL_R_PEM_NAME_BAD_PREFIX = 391;
  SSL_R_PEM_NAME_TOO_SHORT = 392;
  SSL_R_PIPELINE_FAILURE = 406;
  SSL_R_POST_HANDSHAKE_AUTH_ENCODING_ERR = 278;
  SSL_R_PRIVATE_KEY_MISMATCH = 288;
  SSL_R_PROTOCOL_IS_SHUTDOWN = 207;
  SSL_R_PSK_IDENTITY_NOT_FOUND = 223;
  SSL_R_PSK_NO_CLIENT_CB = 224;
  SSL_R_PSK_NO_SERVER_CB = 225;
  SSL_R_READ_BIO_NOT_SET = 211;
  SSL_R_READ_TIMEOUT_EXPIRED = 312;
  SSL_R_RECORD_LENGTH_MISMATCH = 213;
  SSL_R_RECORD_TOO_SMALL = 298;
  SSL_R_RENEGOTIATE_EXT_TOO_LONG = 335;
  SSL_R_RENEGOTIATION_ENCODING_ERR = 336;
  SSL_R_RENEGOTIATION_MISMATCH = 337;
  SSL_R_REQUEST_PENDING = 285;
  SSL_R_REQUEST_SENT = 286;
  SSL_R_REQUIRED_CIPHER_MISSING = 215;
  SSL_R_REQUIRED_COMPRESSION_ALGORITHM_MISSING = 342;
  SSL_R_SCSV_RECEIVED_WHEN_RENEGOTIATING = 345;
  SSL_R_SCT_VERIFICATION_FAILED = 208;
  SSL_R_SERVERHELLO_TLSEXT = 275;
  SSL_R_SESSION_ID_CONTEXT_UNINITIALIZED = 277;
  SSL_R_SHUTDOWN_WHILE_IN_INIT = 407;
  SSL_R_SIGNATURE_ALGORITHMS_ERROR = 360;
  SSL_R_SIGNATURE_FOR_NON_SIGNING_CERTIFICATE = 220;
  SSL_R_SRP_A_CALC = 361;
  SSL_R_SRTP_COULD_NOT_ALLOCATE_PROFILES = 362;
  SSL_R_SRTP_PROTECTION_PROFILE_LIST_TOO_LONG = 363;
  SSL_R_SRTP_UNKNOWN_PROTECTION_PROFILE = 364;
  SSL_R_SSL3_EXT_INVALID_MAX_FRAGMENT_LENGTH = 232;
  SSL_R_SSL3_EXT_INVALID_SERVERNAME = 319;
  SSL_R_SSL3_EXT_INVALID_SERVERNAME_TYPE = 320;
  SSL_R_SSL3_SESSION_ID_TOO_LONG = 300;
  SSL_R_SSLV3_ALERT_BAD_CERTIFICATE = 1042;
  SSL_R_SSLV3_ALERT_BAD_RECORD_MAC = 1020;
  SSL_R_SSLV3_ALERT_CERTIFICATE_EXPIRED = 1045;
  SSL_R_SSLV3_ALERT_CERTIFICATE_REVOKED = 1044;
  SSL_R_SSLV3_ALERT_CERTIFICATE_UNKNOWN = 1046;
  SSL_R_SSLV3_ALERT_DECOMPRESSION_FAILURE = 1030;
  SSL_R_SSLV3_ALERT_HANDSHAKE_FAILURE = 1040;
  SSL_R_SSLV3_ALERT_ILLEGAL_PARAMETER = 1047;
  SSL_R_SSLV3_ALERT_NO_CERTIFICATE = 1041;
  SSL_R_SSLV3_ALERT_UNEXPECTED_MESSAGE = 1010;
  SSL_R_SSLV3_ALERT_UNSUPPORTED_CERTIFICATE = 1043;
  SSL_R_SSL_COMMAND_SECTION_EMPTY = 117;
  SSL_R_SSL_COMMAND_SECTION_NOT_FOUND = 125;
  SSL_R_SSL_CTX_HAS_NO_DEFAULT_SSL_VERSION = 228;
  SSL_R_SSL_HANDSHAKE_FAILURE = 229;
  SSL_R_SSL_LIBRARY_HAS_NO_CIPHERS = 230;
  SSL_R_SSL_NEGATIVE_LENGTH = 372;
  SSL_R_SSL_SECTION_EMPTY = 126;
  SSL_R_SSL_SECTION_NOT_FOUND = 136;
  SSL_R_SSL_SESSION_ID_CALLBACK_FAILED = 301;
  SSL_R_SSL_SESSION_ID_CONFLICT = 302;
  SSL_R_SSL_SESSION_ID_CONTEXT_TOO_LONG = 273;
  SSL_R_SSL_SESSION_ID_HAS_BAD_LENGTH = 303;
  SSL_R_SSL_SESSION_ID_TOO_LONG = 408;
  SSL_R_SSL_SESSION_VERSION_MISMATCH = 210;
  SSL_R_STILL_IN_INIT = 121;
  SSL_R_TLSV13_ALERT_CERTIFICATE_REQUIRED = 1116;
  SSL_R_TLSV13_ALERT_MISSING_EXTENSION = 1109;
  SSL_R_TLSV1_ALERT_ACCESS_DENIED = 1049;
  SSL_R_TLSV1_ALERT_DECODE_ERROR = 1050;
  SSL_R_TLSV1_ALERT_DECRYPTION_FAILED = 1021;
  SSL_R_TLSV1_ALERT_DECRYPT_ERROR = 1051;
  SSL_R_TLSV1_ALERT_EXPORT_RESTRICTION = 1060;
  SSL_R_TLSV1_ALERT_INAPPROPRIATE_FALLBACK = 1086;
  SSL_R_TLSV1_ALERT_INSUFFICIENT_SECURITY = 1071;
  SSL_R_TLSV1_ALERT_INTERNAL_ERROR = 1080;
  SSL_R_TLSV1_ALERT_NO_RENEGOTIATION = 1100;
  SSL_R_TLSV1_ALERT_PROTOCOL_VERSION = 1070;
  SSL_R_TLSV1_ALERT_RECORD_OVERFLOW = 1022;
  SSL_R_TLSV1_ALERT_UNKNOWN_CA = 1048;
  SSL_R_TLSV1_ALERT_USER_CANCELLED = 1090;
  SSL_R_TLSV1_BAD_CERTIFICATE_HASH_VALUE = 1114;
  SSL_R_TLSV1_BAD_CERTIFICATE_STATUS_RESPONSE = 1113;
  SSL_R_TLSV1_CERTIFICATE_UNOBTAINABLE = 1111;
  SSL_R_TLSV1_UNRECOGNIZED_NAME = 1112;
  SSL_R_TLSV1_UNSUPPORTED_EXTENSION = 1110;
  SSL_R_TLS_HEARTBEAT_PEER_DOESNT_ACCEPT = 365;
  SSL_R_TLS_HEARTBEAT_PENDING = 366;
  SSL_R_TLS_ILLEGAL_EXPORTER_LABEL = 367;
  SSL_R_TLS_INVALID_ECPOINTFORMAT_LIST = 157;
  SSL_R_TOO_MANY_KEY_UPDATES = 132;
  SSL_R_TOO_MANY_WARN_ALERTS = 409;
  SSL_R_TOO_MUCH_EARLY_DATA = 164;
  SSL_R_UNABLE_TO_FIND_ECDH_PARAMETERS = 314;
  SSL_R_UNABLE_TO_FIND_PUBLIC_KEY_PARAMETERS = 239;
  SSL_R_UNABLE_TO_LOAD_SSL3_MD5_ROUTINES = 242;
  SSL_R_UNABLE_TO_LOAD_SSL3_SHA1_ROUTINES = 243;
  SSL_R_UNEXPECTED_CCS_MESSAGE = 262;
  SSL_R_UNEXPECTED_END_OF_EARLY_DATA = 178;
  SSL_R_UNEXPECTED_MESSAGE = 244;
  SSL_R_UNEXPECTED_RECORD = 245;
  SSL_R_UNINITIALIZED = 276;
  SSL_R_UNKNOWN_ALERT_TYPE = 246;
  SSL_R_UNKNOWN_CERTIFICATE_TYPE = 247;
  SSL_R_UNKNOWN_CIPHER_RETURNED = 248;
  SSL_R_UNKNOWN_CIPHER_TYPE = 249;
  SSL_R_UNKNOWN_CMD_NAME = 386;
  SSL_R_UNKNOWN_COMMAND = 139;
  SSL_R_UNKNOWN_DIGEST = 368;
  SSL_R_UNKNOWN_KEY_EXCHANGE_TYPE = 250;
  SSL_R_UNKNOWN_PKEY_TYPE = 251;
  SSL_R_UNKNOWN_PROTOCOL = 252;
  SSL_R_UNKNOWN_SSL_VERSION = 254;
  SSL_R_UNKNOWN_STATE = 255;
  SSL_R_UNSAFE_LEGACY_RENEGOTIATION_DISABLED = 338;
  SSL_R_UNSOLICITED_EXTENSION = 217;
  SSL_R_UNSUPPORTED_COMPRESSION_ALGORITHM = 257;
  SSL_R_UNSUPPORTED_ELLIPTIC_CURVE = 315;
  SSL_R_UNSUPPORTED_PROTOCOL = 258;
  SSL_R_UNSUPPORTED_SSL_VERSION = 259;
  SSL_R_UNSUPPORTED_STATUS_TYPE = 329;
  SSL_R_USE_SRTP_NOT_NEGOTIATED = 369;
  SSL_R_VERSION_TOO_HIGH = 166;
  SSL_R_VERSION_TOO_LOW = 396;
  SSL_R_WRONG_CERTIFICATE_TYPE = 383;
  SSL_R_WRONG_CIPHER_RETURNED = 261;
  SSL_R_WRONG_CURVE = 378;
  SSL_R_WRONG_SIGNATURE_LENGTH = 264;
  SSL_R_WRONG_SIGNATURE_SIZE = 265;
  SSL_R_WRONG_SIGNATURE_TYPE = 370;
  SSL_R_WRONG_SSL_VERSION = 266;
  SSL_R_WRONG_VERSION_NUMBER = 267;
  SSL_R_X509_LIB = 268;
  SSL_R_X509_VERIFICATION_SETUP_PROBLEMS = 269;
  SSL_SESSION_ASN1_VERSION = $0001;
  SSL_MAX_SSL_SESSION_ID_LENGTH = 32;
  SSL_MAX_SID_CTX_LENGTH = 32;
  SSL_MIN_RSA_MODULUS_LENGTH_IN_BYTES = (512 div 8);
  SSL_MAX_KEY_ARG_LENGTH = 8;
  SSL_MAX_MASTER_KEY_LENGTH = 48;
  SSL_MAX_PIPELINES = 32;
  SSL_TXT_LOW = 'LOW';
  SSL_TXT_MEDIUM = 'MEDIUM';
  SSL_TXT_HIGH = 'HIGH';
  SSL_TXT_FIPS = 'FIPS';
  SSL_TXT_aNULL = 'aNULL';
  SSL_TXT_eNULL = 'eNULL';
  SSL_TXT_NULL = 'NULL';
  SSL_TXT_kRSA = 'kRSA';
  SSL_TXT_kDHr = 'kDHr';
  SSL_TXT_kDHd = 'kDHd';
  SSL_TXT_kDH = 'kDH';
  SSL_TXT_kEDH = 'kEDH';
  SSL_TXT_kDHE = 'kDHE';
  SSL_TXT_kECDHr = 'kECDHr';
  SSL_TXT_kECDHe = 'kECDHe';
  SSL_TXT_kECDH = 'kECDH';
  SSL_TXT_kEECDH = 'kEECDH';
//  SSL_TXT_kECDHE = 'kECDHE';
  SSL_TXT_kPSK = 'kPSK';
  SSL_TXT_kRSAPSK = 'kRSAPSK';
  SSL_TXT_kECDHEPSK = 'kECDHEPSK';
  SSL_TXT_kDHEPSK = 'kDHEPSK';
  SSL_TXT_kGOST = 'kGOST';
  SSL_TXT_kSRP = 'kSRP';
  SSL_TXT_aRSA = 'aRSA';
  SSL_TXT_aDSS = 'aDSS';
  SSL_TXT_aDH = 'aDH';
  SSL_TXT_aECDH = 'aECDH';
  SSL_TXT_aECDSA = 'aECDSA';
  SSL_TXT_aPSK = 'aPSK';
  SSL_TXT_aGOST94 = 'aGOST94';
  SSL_TXT_aGOST01 = 'aGOST01';
  SSL_TXT_aGOST12 = 'aGOST12';
  SSL_TXT_aGOST = 'aGOST';
  SSL_TXT_aSRP = 'aSRP';
  SSL_TXT_DSS = 'DSS';
  SSL_TXT_DH = 'DH';
  SSL_TXT_DHE = 'DHE';
  SSL_TXT_EDH = 'EDH';
//  SSL_TXT_ADH = 'ADH';
  SSL_TXT_RSA = 'RSA';
  SSL_TXT_ECDH = 'ECDH';
  SSL_TXT_EECDH = 'EECDH';
  SSL_TXT_ECDHE = 'ECDHE';
//  SSL_TXT_AECDH = 'AECDH';
  SSL_TXT_ECDSA = 'ECDSA';
  SSL_TXT_PSK = 'PSK';
  SSL_TXT_SRP = 'SRP';
  SSL_TXT_DES = 'DES';
  SSL_TXT_3DES = '3DES';
  SSL_TXT_RC4 = 'RC4';
  SSL_TXT_RC2 = 'RC2';
  SSL_TXT_IDEA = 'IDEA';
  SSL_TXT_SEED = 'SEED';
  SSL_TXT_AES128 = 'AES128';
  SSL_TXT_AES256 = 'AES256';
  SSL_TXT_AES = 'AES';
  SSL_TXT_AES_GCM = 'AESGCM';
  SSL_TXT_AES_CCM = 'AESCCM';
  SSL_TXT_AES_CCM_8 = 'AESCCM8';
  SSL_TXT_CAMELLIA128 = 'CAMELLIA128';
  SSL_TXT_CAMELLIA256 = 'CAMELLIA256';
  SSL_TXT_CAMELLIA = 'CAMELLIA';
  SSL_TXT_CHACHA20 = 'CHACHA20';
  SSL_TXT_GOST = 'GOST89';
  SSL_TXT_ARIA = 'ARIA';
  SSL_TXT_ARIA_GCM = 'ARIAGCM';
  SSL_TXT_ARIA128 = 'ARIA128';
  SSL_TXT_ARIA256 = 'ARIA256';
  SSL_TXT_MD5 = 'MD5';
  SSL_TXT_SHA1 = 'SHA1';
  SSL_TXT_SHA = 'SHA';
  SSL_TXT_GOST94 = 'GOST94';
  SSL_TXT_GOST89MAC = 'GOST89MAC';
  SSL_TXT_GOST12 = 'GOST12';
  SSL_TXT_GOST89MAC12 = 'GOST89MAC12';
  SSL_TXT_SHA256 = 'SHA256';
  SSL_TXT_SHA384 = 'SHA384';
  SSL_TXT_SSLV3 = 'SSLv3';
  SSL_TXT_TLSV1 = 'TLSv1';
  SSL_TXT_TLSV1_1 = 'TLSv1.1';
  SSL_TXT_TLSV1_2 = 'TLSv1.2';
  SSL_TXT_ALL = 'ALL';
  SSL_TXT_CMPALL = 'COMPLEMENTOFALL';
  SSL_TXT_CMPDEF = 'COMPLEMENTOFDEFAULT';
  SSL_DEFAULT_CIPHER_LIST = 'ALL:!COMPLEMENTOFDEFAULT:!eNULL';
  TLS_DEFAULT_CIPHERSUITES = 'TLS_AES_256_GCM_SHA384:' + 'TLS_CHACHA20_POLY1305_SHA256:' + 'TLS_AES_128_GCM_SHA256';
  SSL_SENT_SHUTDOWN = 1;
  SSL_RECEIVED_SHUTDOWN = 2;
  SSL_FILETYPE_ASN1 = X509_FILETYPE_ASN1;
  SSL_FILETYPE_PEM = X509_FILETYPE_PEM;
  SSL_EXT_TLS_ONLY = $0001;
  SSL_EXT_DTLS_ONLY = $0002;
  SSL_EXT_TLS_IMPLEMENTATION_ONLY = $0004;
  SSL_EXT_SSL3_ALLOWED = $0008;
  SSL_EXT_TLS1_2_AND_BELOW_ONLY = $0010;
  SSL_EXT_TLS1_3_ONLY = $0020;
  SSL_EXT_IGNORE_ON_RESUMPTION = $0040;
  SSL_EXT_CLIENT_HELLO = $0080;
  SSL_EXT_TLS1_2_SERVER_HELLO = $0100;
  SSL_EXT_TLS1_3_SERVER_HELLO = $0200;
  SSL_EXT_TLS1_3_ENCRYPTED_EXTENSIONS = $0400;
  SSL_EXT_TLS1_3_HELLO_RETRY_REQUEST = $0800;
  SSL_EXT_TLS1_3_CERTIFICATE = $1000;
  SSL_EXT_TLS1_3_NEW_SESSION_TICKET = $2000;
  SSL_EXT_TLS1_3_CERTIFICATE_REQUEST = $4000;
  SSL_OP_LEGACY_SERVER_CONNECT = $00000004;
  SSL_OP_TLSEXT_PADDING = $00000010;
  SSL_OP_SAFARI_ECDHE_ECDSA_BUG = $00000040;
  SSL_OP_ALLOW_NO_DHE_KEX = $00000400;
  SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS = $00000800;
  SSL_OP_NO_QUERY_MTU = $00001000;
  SSL_OP_COOKIE_EXCHANGE = $00002000;
  SSL_OP_NO_TICKET = $00004000;
  SSL_OP_CISCO_ANYCONNECT = $00008000;
  SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = $00010000;
  SSL_OP_NO_COMPRESSION = $00020000;
  SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION = $00040000;
  SSL_OP_NO_ENCRYPT_THEN_MAC = $00080000;
  SSL_OP_ENABLE_MIDDLEBOX_COMPAT = $00100000;
  SSL_OP_PRIORITIZE_CHACHA = $00200000;
  SSL_OP_CIPHER_SERVER_PREFERENCE = $00400000;
  SSL_OP_TLS_ROLLBACK_BUG = $00800000;
  SSL_OP_NO_ANTI_REPLAY = $01000000;
  SSL_OP_NO_SSLv3 = $02000000;
  SSL_OP_NO_TLSv1 = $04000000;
  SSL_OP_NO_TLSv1_2 = $08000000;
  SSL_OP_NO_TLSv1_1 = $10000000;
  SSL_OP_NO_TLSv1_3 = $20000000;
  SSL_OP_NO_DTLSv1 = $04000000;
  SSL_OP_NO_DTLSv1_2 = $08000000;
  SSL_OP_NO_SSL_MASK = (SSL_OP_NO_SSLv3 or SSL_OP_NO_TLSv1 or SSL_OP_NO_TLSv1_1 or SSL_OP_NO_TLSv1_2 or SSL_OP_NO_TLSv1_3);
  SSL_OP_NO_DTLS_MASK = (SSL_OP_NO_DTLSv1 or SSL_OP_NO_DTLSv1_2);
  SSL_OP_NO_RENEGOTIATION = $40000000;
  SSL_OP_CRYPTOPRO_TLSEXT_BUG = $80000000;
  SSL_OP_ALL = (SSL_OP_CRYPTOPRO_TLSEXT_BUG or SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS or SSL_OP_LEGACY_SERVER_CONNECT or SSL_OP_TLSEXT_PADDING or SSL_OP_SAFARI_ECDHE_ECDSA_BUG);
  SSL_OP_MICROSOFT_SESS_ID_BUG = $0;
  SSL_OP_NETSCAPE_CHALLENGE_BUG = $0;
  SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG = $0;
  SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG = $0;
  SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER = $0;
  SSL_OP_MSIE_SSLV2_RSA_PADDING = $0;
  SSL_OP_SSLEAY_080_CLIENT_DH_BUG = $0;
  SSL_OP_TLS_D5_BUG = $0;
  SSL_OP_TLS_BLOCK_PADDING_BUG = $0;
  SSL_OP_SINGLE_ECDH_USE = $0;
  SSL_OP_SINGLE_DH_USE = $0;
  SSL_OP_EPHEMERAL_RSA = $0;
  SSL_OP_NO_SSLv2 = $0;
  SSL_OP_PKCS1_CHECK_1 = $0;
  SSL_OP_PKCS1_CHECK_2 = $0;
  SSL_OP_NETSCAPE_CA_DN_BUG = $0;
  SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG = $0;
  SSL_MODE_ENABLE_PARTIAL_WRITE = $00000001;
  SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER = $00000002;
  SSL_MODE_AUTO_RETRY = $00000004;
  SSL_MODE_NO_AUTO_CHAIN = $00000008;
  SSL_MODE_RELEASE_BUFFERS = $00000010;
  SSL_MODE_SEND_CLIENTHELLO_TIME = $00000020;
  SSL_MODE_SEND_SERVERHELLO_TIME = $00000040;
  SSL_MODE_SEND_FALLBACK_SCSV = $00000080;
  SSL_MODE_ASYNC = $00000100;
  SSL_MODE_DTLS_SCTP_LABEL_LENGTH_BUG = $00000400;
  SSL_CERT_FLAG_TLS_STRICT = $00000001;
  SSL_CERT_FLAG_SUITEB_128_LOS_ONLY = $10000;
  SSL_CERT_FLAG_SUITEB_192_LOS = $20000;
  SSL_CERT_FLAG_SUITEB_128_LOS = $30000;
  SSL_CERT_FLAG_BROKEN_PROTOCOL = $10000000;
  SSL_BUILD_CHAIN_FLAG_UNTRUSTED = $1;
  SSL_BUILD_CHAIN_FLAG_NO_ROOT = $2;
  SSL_BUILD_CHAIN_FLAG_CHECK = $4;
  SSL_BUILD_CHAIN_FLAG_IGNORE_ERROR = $8;
  SSL_BUILD_CHAIN_FLAG_CLEAR_ERROR = $10;
  CERT_PKEY_VALID = $1;
  CERT_PKEY_SIGN = $2;
  CERT_PKEY_EE_SIGNATURE = $10;
  CERT_PKEY_CA_SIGNATURE = $20;
  CERT_PKEY_EE_PARAM = $40;
  CERT_PKEY_CA_PARAM = $80;
  CERT_PKEY_EXPLICIT_SIGN = $100;
  CERT_PKEY_ISSUER_NAME = $200;
  CERT_PKEY_CERT_TYPE = $400;
  CERT_PKEY_SUITEB = $800;
  SSL_CONF_FLAG_CMDLINE = $1;
  SSL_CONF_FLAG_FILE = $2;
  SSL_CONF_FLAG_CLIENT = $4;
  SSL_CONF_FLAG_SERVER = $8;
  SSL_CONF_FLAG_SHOW_ERRORS = $10;
  SSL_CONF_FLAG_CERTIFICATE = $20;
  SSL_CONF_FLAG_REQUIRE_PRIVATE = $40;
  SSL_CONF_TYPE_UNKNOWN = $0;
  SSL_CONF_TYPE_STRING = $1;
  SSL_CONF_TYPE_FILE = $2;
  SSL_CONF_TYPE_DIR = $3;
  SSL_CONF_TYPE_NONE = $4;
  SSL_COOKIE_LENGTH = 4096;
  SSL_MAX_CERT_LIST_DEFAULT = 1024*100;
  SSL_SESSION_CACHE_MAX_SIZE_DEFAULT = (1024*20);
  SSL_SESS_CACHE_OFF = $0000;
  SSL_SESS_CACHE_CLIENT = $0001;
  SSL_SESS_CACHE_SERVER = $0002;
  SSL_SESS_CACHE_BOTH = (SSL_SESS_CACHE_CLIENT or SSL_SESS_CACHE_SERVER);
  SSL_SESS_CACHE_NO_AUTO_CLEAR = $0080;
  SSL_SESS_CACHE_NO_INTERNAL_LOOKUP = $0100;
  SSL_SESS_CACHE_NO_INTERNAL_STORE = $0200;
  SSL_SESS_CACHE_NO_INTERNAL = (SSL_SESS_CACHE_NO_INTERNAL_LOOKUP or SSL_SESS_CACHE_NO_INTERNAL_STORE);
  OPENSSL_NPN_UNSUPPORTED = 0;
  OPENSSL_NPN_NEGOTIATED = 1;
  OPENSSL_NPN_NO_OVERLAP = 2;
  PSK_MAX_IDENTITY_LEN = 128;
  PSK_MAX_PSK_LEN = 256;
  SSL_NOTHING = 1;
  SSL_WRITING = 2;
  SSL_READING = 3;
  SSL_X509_LOOKUP = 4;
  SSL_ASYNC_PAUSED = 5;
  SSL_ASYNC_NO_JOBS = 6;
  SSL_CLIENT_HELLO_CB = 7;
  SSL_MAC_FLAG_READ_MAC_STREAM = 1;
  SSL_MAC_FLAG_WRITE_MAC_STREAM = 2;
  SSL2_VERSION = $0002;
  SSL2_MT_CLIENT_HELLO = 1;
  SSL3_CK_SCSV = $030000FF;
  SSL3_CK_FALLBACK_SCSV = $03005600;
  SSL3_CK_RSA_NULL_MD5 = $03000001;
  SSL3_CK_RSA_NULL_SHA = $03000002;
  SSL3_CK_RSA_RC4_40_MD5 = $03000003;
  SSL3_CK_RSA_RC4_128_MD5 = $03000004;
  SSL3_CK_RSA_RC4_128_SHA = $03000005;
  SSL3_CK_RSA_RC2_40_MD5 = $03000006;
  SSL3_CK_RSA_IDEA_128_SHA = $03000007;
  SSL3_CK_RSA_DES_40_CBC_SHA = $03000008;
  SSL3_CK_RSA_DES_64_CBC_SHA = $03000009;
  SSL3_CK_RSA_DES_192_CBC3_SHA = $0300000A;
  SSL3_CK_DH_DSS_DES_40_CBC_SHA = $0300000B;
  SSL3_CK_DH_DSS_DES_64_CBC_SHA = $0300000C;
  SSL3_CK_DH_DSS_DES_192_CBC3_SHA = $0300000D;
  SSL3_CK_DH_RSA_DES_40_CBC_SHA = $0300000E;
  SSL3_CK_DH_RSA_DES_64_CBC_SHA = $0300000F;
  SSL3_CK_DH_RSA_DES_192_CBC3_SHA = $03000010;
  SSL3_CK_DHE_DSS_DES_40_CBC_SHA = $03000011;
  SSL3_CK_EDH_DSS_DES_40_CBC_SHA = SSL3_CK_DHE_DSS_DES_40_CBC_SHA;
  SSL3_CK_DHE_DSS_DES_64_CBC_SHA = $03000012;
  SSL3_CK_EDH_DSS_DES_64_CBC_SHA = SSL3_CK_DHE_DSS_DES_64_CBC_SHA;
  SSL3_CK_DHE_DSS_DES_192_CBC3_SHA = $03000013;
  SSL3_CK_EDH_DSS_DES_192_CBC3_SHA = SSL3_CK_DHE_DSS_DES_192_CBC3_SHA;
  SSL3_CK_DHE_RSA_DES_40_CBC_SHA = $03000014;
  SSL3_CK_EDH_RSA_DES_40_CBC_SHA = SSL3_CK_DHE_RSA_DES_40_CBC_SHA;
  SSL3_CK_DHE_RSA_DES_64_CBC_SHA = $03000015;
  SSL3_CK_EDH_RSA_DES_64_CBC_SHA = SSL3_CK_DHE_RSA_DES_64_CBC_SHA;
  SSL3_CK_DHE_RSA_DES_192_CBC3_SHA = $03000016;
  SSL3_CK_EDH_RSA_DES_192_CBC3_SHA = SSL3_CK_DHE_RSA_DES_192_CBC3_SHA;
  SSL3_CK_ADH_RC4_40_MD5 = $03000017;
  SSL3_CK_ADH_RC4_128_MD5 = $03000018;
  SSL3_CK_ADH_DES_40_CBC_SHA = $03000019;
  SSL3_CK_ADH_DES_64_CBC_SHA = $0300001A;
  SSL3_CK_ADH_DES_192_CBC_SHA = $0300001B;
  SSL3_RFC_RSA_NULL_MD5 = 'TLS_RSA_WITH_NULL_MD5';
  SSL3_RFC_RSA_NULL_SHA = 'TLS_RSA_WITH_NULL_SHA';
  SSL3_RFC_RSA_DES_192_CBC3_SHA = 'TLS_RSA_WITH_3DES_EDE_CBC_SHA';
  SSL3_RFC_DHE_DSS_DES_192_CBC3_SHA = 'TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA';
  SSL3_RFC_DHE_RSA_DES_192_CBC3_SHA = 'TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA';
  SSL3_RFC_ADH_DES_192_CBC_SHA = 'TLS_DH_anon_WITH_3DES_EDE_CBC_SHA';
  SSL3_RFC_RSA_IDEA_128_SHA = 'TLS_RSA_WITH_IDEA_CBC_SHA';
  SSL3_RFC_RSA_RC4_128_MD5 = 'TLS_RSA_WITH_RC4_128_MD5';
  SSL3_RFC_RSA_RC4_128_SHA = 'TLS_RSA_WITH_RC4_128_SHA';
  SSL3_RFC_ADH_RC4_128_MD5 = 'TLS_DH_anon_WITH_RC4_128_MD5';
  SSL3_TXT_RSA_NULL_MD5 = 'NULL-MD5';
  SSL3_TXT_RSA_NULL_SHA = 'NULL-SHA';
  SSL3_TXT_RSA_RC4_40_MD5 = 'EXP-RC4-MD5';
  SSL3_TXT_RSA_RC4_128_MD5 = 'RC4-MD5';
  SSL3_TXT_RSA_RC4_128_SHA = 'RC4-SHA';
  SSL3_TXT_RSA_RC2_40_MD5 = 'EXP-RC2-CBC-MD5';
  SSL3_TXT_RSA_IDEA_128_SHA = 'IDEA-CBC-SHA';
  SSL3_TXT_RSA_DES_40_CBC_SHA = 'EXP-DES-CBC-SHA';
  SSL3_TXT_RSA_DES_64_CBC_SHA = 'DES-CBC-SHA';
  SSL3_TXT_RSA_DES_192_CBC3_SHA = 'DES-CBC3-SHA';
  SSL3_TXT_DH_DSS_DES_40_CBC_SHA = 'EXP-DH-DSS-DES-CBC-SHA';
  SSL3_TXT_DH_DSS_DES_64_CBC_SHA = 'DH-DSS-DES-CBC-SHA';
  SSL3_TXT_DH_DSS_DES_192_CBC3_SHA = 'DH-DSS-DES-CBC3-SHA';
  SSL3_TXT_DH_RSA_DES_40_CBC_SHA = 'EXP-DH-RSA-DES-CBC-SHA';
  SSL3_TXT_DH_RSA_DES_64_CBC_SHA = 'DH-RSA-DES-CBC-SHA';
  SSL3_TXT_DH_RSA_DES_192_CBC3_SHA = 'DH-RSA-DES-CBC3-SHA';
  SSL3_TXT_DHE_DSS_DES_40_CBC_SHA = 'EXP-DHE-DSS-DES-CBC-SHA';
  SSL3_TXT_DHE_DSS_DES_64_CBC_SHA = 'DHE-DSS-DES-CBC-SHA';
  SSL3_TXT_DHE_DSS_DES_192_CBC3_SHA = 'DHE-DSS-DES-CBC3-SHA';
  SSL3_TXT_DHE_RSA_DES_40_CBC_SHA = 'EXP-DHE-RSA-DES-CBC-SHA';
  SSL3_TXT_DHE_RSA_DES_64_CBC_SHA = 'DHE-RSA-DES-CBC-SHA';
  SSL3_TXT_DHE_RSA_DES_192_CBC3_SHA = 'DHE-RSA-DES-CBC3-SHA';
  SSL3_TXT_EDH_DSS_DES_40_CBC_SHA = 'EXP-EDH-DSS-DES-CBC-SHA';
  SSL3_TXT_EDH_DSS_DES_64_CBC_SHA = 'EDH-DSS-DES-CBC-SHA';
  SSL3_TXT_EDH_DSS_DES_192_CBC3_SHA = 'EDH-DSS-DES-CBC3-SHA';
  SSL3_TXT_EDH_RSA_DES_40_CBC_SHA = 'EXP-EDH-RSA-DES-CBC-SHA';
  SSL3_TXT_EDH_RSA_DES_64_CBC_SHA = 'EDH-RSA-DES-CBC-SHA';
  SSL3_TXT_EDH_RSA_DES_192_CBC3_SHA = 'EDH-RSA-DES-CBC3-SHA';
  SSL3_TXT_ADH_RC4_40_MD5 = 'EXP-ADH-RC4-MD5';
  SSL3_TXT_ADH_RC4_128_MD5 = 'ADH-RC4-MD5';
  SSL3_TXT_ADH_DES_40_CBC_SHA = 'EXP-ADH-DES-CBC-SHA';
  SSL3_TXT_ADH_DES_64_CBC_SHA = 'ADH-DES-CBC-SHA';
  SSL3_TXT_ADH_DES_192_CBC_SHA = 'ADH-DES-CBC3-SHA';
  SSL3_SSL_SESSION_ID_LENGTH = 32;
  SSL3_MAX_SSL_SESSION_ID_LENGTH = 32;
  SSL3_MASTER_SECRET_SIZE = 48;
  SSL3_RANDOM_SIZE = 32;
  SSL3_SESSION_ID_SIZE = 32;
  SSL3_RT_HEADER_LENGTH = 5;
  SSL3_HM_HEADER_LENGTH = 4;
  SSL3_ALIGN_PAYLOAD = 8;
  SSL3_RT_MAX_MD_SIZE = 64;
  SSL_RT_MAX_CIPHER_BLOCK_SIZE = 16;
  SSL3_RT_MAX_EXTRA = (16384);
  SSL3_RT_MAX_PLAIN_LENGTH = 16384;
  SSL3_RT_MAX_COMPRESSED_OVERHEAD = 1024;
  SSL3_RT_MAX_ENCRYPTED_OVERHEAD = (256+SSL3_RT_MAX_MD_SIZE);
  SSL3_RT_MAX_TLS13_ENCRYPTED_OVERHEAD = 256;
  SSL3_RT_SEND_MAX_ENCRYPTED_OVERHEAD = (SSL_RT_MAX_CIPHER_BLOCK_SIZE+SSL3_RT_MAX_MD_SIZE);
  SSL3_RT_MAX_COMPRESSED_LENGTH = (SSL3_RT_MAX_PLAIN_LENGTH+SSL3_RT_MAX_COMPRESSED_OVERHEAD);
  SSL3_RT_MAX_ENCRYPTED_LENGTH = (SSL3_RT_MAX_ENCRYPTED_OVERHEAD+SSL3_RT_MAX_COMPRESSED_LENGTH);
  SSL3_RT_MAX_TLS13_ENCRYPTED_LENGTH = (SSL3_RT_MAX_PLAIN_LENGTH+SSL3_RT_MAX_TLS13_ENCRYPTED_OVERHEAD);
  SSL3_RT_MAX_PACKET_SIZE = (SSL3_RT_MAX_ENCRYPTED_LENGTH+SSL3_RT_HEADER_LENGTH);
  SSL3_MD_CLIENT_FINISHED_CONST = #67''#76''#78''#84;
  SSL3_MD_SERVER_FINISHED_CONST = #83''#82''#86''#82;
  SSL3_VERSION = $0300;
  SSL3_VERSION_MAJOR = $03;
  SSL3_VERSION_MINOR = $00;
  SSL3_RT_CHANGE_CIPHER_SPEC = 20;
  SSL3_RT_ALERT = 21;
  SSL3_RT_HANDSHAKE = 22;
  SSL3_RT_APPLICATION_DATA = 23;
  DTLS1_RT_HEARTBEAT = 24;
  TLS1_RT_CRYPTO = $1000;
  TLS1_RT_CRYPTO_PREMASTER = (TLS1_RT_CRYPTO or $1);
  TLS1_RT_CRYPTO_CLIENT_RANDOM = (TLS1_RT_CRYPTO or $2);
  TLS1_RT_CRYPTO_SERVER_RANDOM = (TLS1_RT_CRYPTO or $3);
  TLS1_RT_CRYPTO_MASTER = (TLS1_RT_CRYPTO or $4);
  TLS1_RT_CRYPTO_READ = $0000;
  TLS1_RT_CRYPTO_WRITE = $0100;
  TLS1_RT_CRYPTO_MAC = (TLS1_RT_CRYPTO or $5);
  TLS1_RT_CRYPTO_KEY = (TLS1_RT_CRYPTO or $6);
  TLS1_RT_CRYPTO_IV = (TLS1_RT_CRYPTO or $7);
  TLS1_RT_CRYPTO_FIXED_IV = (TLS1_RT_CRYPTO or $8);
  SSL3_RT_HEADER = $100;
  SSL3_RT_INNER_CONTENT_TYPE = $101;
  SSL3_AL_WARNING = 1;
  SSL3_AL_FATAL = 2;
  SSL3_AD_CLOSE_NOTIFY = 0;
  SSL3_AD_UNEXPECTED_MESSAGE = 10;
  SSL3_AD_BAD_RECORD_MAC = 20;
  SSL3_AD_DECOMPRESSION_FAILURE = 30;
  SSL3_AD_HANDSHAKE_FAILURE = 40;
  SSL3_AD_NO_CERTIFICATE = 41;
  SSL3_AD_BAD_CERTIFICATE = 42;
  SSL3_AD_UNSUPPORTED_CERTIFICATE = 43;
  SSL3_AD_CERTIFICATE_REVOKED = 44;
  SSL3_AD_CERTIFICATE_EXPIRED = 45;
  SSL3_AD_CERTIFICATE_UNKNOWN = 46;
  SSL3_AD_ILLEGAL_PARAMETER = 47;
  TLS1_HB_REQUEST = 1;
  TLS1_HB_RESPONSE = 2;
  SSL3_CT_RSA_SIGN = 1;
  SSL3_CT_DSS_SIGN = 2;
  SSL3_CT_RSA_FIXED_DH = 3;
  SSL3_CT_DSS_FIXED_DH = 4;
  SSL3_CT_RSA_EPHEMERAL_DH = 5;
  SSL3_CT_DSS_EPHEMERAL_DH = 6;
  SSL3_CT_FORTEZZA_DMS = 20;
  SSL3_CT_NUMBER = 10;
  SSL3_FLAGS_NO_RENEGOTIATE_CIPHERS = $0001;
  TLS1_FLAGS_TLS_PADDING_BUG = $0;
  TLS1_FLAGS_SKIP_CERT_VERIFY = $0010;
  TLS1_FLAGS_ENCRYPT_THEN_MAC_READ = $0100;
  TLS1_FLAGS_ENCRYPT_THEN_MAC = TLS1_FLAGS_ENCRYPT_THEN_MAC_READ;
  TLS1_FLAGS_RECEIVED_EXTMS = $0200;
  TLS1_FLAGS_ENCRYPT_THEN_MAC_WRITE = $0400;
  TLS1_FLAGS_STATELESS = $0800;
  SSL3_MT_HELLO_REQUEST = 0;
  SSL3_MT_CLIENT_HELLO = 1;
  SSL3_MT_SERVER_HELLO = 2;
  SSL3_MT_NEWSESSION_TICKET = 4;
  SSL3_MT_END_OF_EARLY_DATA = 5;
  SSL3_MT_ENCRYPTED_EXTENSIONS = 8;
  SSL3_MT_CERTIFICATE = 11;
  SSL3_MT_SERVER_KEY_EXCHANGE = 12;
  SSL3_MT_CERTIFICATE_REQUEST = 13;
  SSL3_MT_SERVER_DONE = 14;
  SSL3_MT_CERTIFICATE_VERIFY = 15;
  SSL3_MT_CLIENT_KEY_EXCHANGE = 16;
  SSL3_MT_FINISHED = 20;
  SSL3_MT_CERTIFICATE_URL = 21;
  SSL3_MT_CERTIFICATE_STATUS = 22;
  SSL3_MT_SUPPLEMENTAL_DATA = 23;
  SSL3_MT_KEY_UPDATE = 24;
  SSL3_MT_NEXT_PROTO = 67;
  SSL3_MT_MESSAGE_HASH = 254;
  DTLS1_MT_HELLO_VERIFY_REQUEST = 3;
  SSL3_MT_CHANGE_CIPHER_SPEC = $0101;
  SSL3_MT_CCS = 1;
  SSL3_CC_READ = $001;
  SSL3_CC_WRITE = $002;
  SSL3_CC_CLIENT = $010;
  SSL3_CC_SERVER = $020;
  SSL3_CC_EARLY = $040;
  SSL3_CC_HANDSHAKE = $080;
  SSL3_CC_APPLICATION = $100;
  SSL3_CHANGE_CIPHER_CLIENT_WRITE = (SSL3_CC_CLIENT or SSL3_CC_WRITE);
  SSL3_CHANGE_CIPHER_SERVER_READ = (SSL3_CC_SERVER or SSL3_CC_READ);
  SSL3_CHANGE_CIPHER_CLIENT_READ = (SSL3_CC_CLIENT or SSL3_CC_READ);
  SSL3_CHANGE_CIPHER_SERVER_WRITE = (SSL3_CC_SERVER or SSL3_CC_WRITE);
  OPENSSL_TLS_SECURITY_LEVEL = 1;
  TLS1_VERSION = $0301;
  TLS1_1_VERSION = $0302;
  TLS1_2_VERSION = $0303;
  TLS1_3_VERSION = $0304;
  TLS_MAX_VERSION = TLS1_3_VERSION;
  TLS_ANY_VERSION = $10000;
  TLS1_VERSION_MAJOR = $03;
  TLS1_VERSION_MINOR = $01;
  TLS1_1_VERSION_MAJOR = $03;
  TLS1_1_VERSION_MINOR = $02;
  TLS1_2_VERSION_MAJOR = $03;
  TLS1_2_VERSION_MINOR = $03;
  TLS1_AD_DECRYPTION_FAILED = 21;
  TLS1_AD_RECORD_OVERFLOW = 22;
  TLS1_AD_UNKNOWN_CA = 48;
  TLS1_AD_ACCESS_DENIED = 49;
  TLS1_AD_DECODE_ERROR = 50;
  TLS1_AD_DECRYPT_ERROR = 51;
  TLS1_AD_EXPORT_RESTRICTION = 60;
  TLS1_AD_PROTOCOL_VERSION = 70;
  TLS1_AD_INSUFFICIENT_SECURITY = 71;
  TLS1_AD_INTERNAL_ERROR = 80;
  TLS1_AD_INAPPROPRIATE_FALLBACK = 86;
  TLS1_AD_USER_CANCELLED = 90;
  TLS1_AD_NO_RENEGOTIATION = 100;
  TLS13_AD_MISSING_EXTENSION = 109;
  TLS13_AD_CERTIFICATE_REQUIRED = 116;
  TLS1_AD_UNSUPPORTED_EXTENSION = 110;
  TLS1_AD_CERTIFICATE_UNOBTAINABLE = 111;
  TLS1_AD_UNRECOGNIZED_NAME = 112;
  TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE = 113;
  TLS1_AD_BAD_CERTIFICATE_HASH_VALUE = 114;
  TLS1_AD_UNKNOWN_PSK_IDENTITY = 115;
  TLS1_AD_NO_APPLICATION_PROTOCOL = 120;
  TLSEXT_TYPE_server_name = 0;
  TLSEXT_TYPE_max_fragment_length = 1;
  TLSEXT_TYPE_client_certificate_url = 2;
  TLSEXT_TYPE_trusted_ca_keys = 3;
  TLSEXT_TYPE_truncated_hmac = 4;
  TLSEXT_TYPE_status_request = 5;
  TLSEXT_TYPE_user_mapping = 6;
  TLSEXT_TYPE_client_authz = 7;
  TLSEXT_TYPE_server_authz = 8;
  TLSEXT_TYPE_cert_type = 9;
  TLSEXT_TYPE_supported_groups = 10;
  TLSEXT_TYPE_elliptic_curves = TLSEXT_TYPE_supported_groups;
  TLSEXT_TYPE_ec_point_formats = 11;
  TLSEXT_TYPE_srp = 12;
  TLSEXT_TYPE_signature_algorithms = 13;
  TLSEXT_TYPE_use_srtp = 14;
  TLSEXT_TYPE_heartbeat = 15;
  TLSEXT_TYPE_application_layer_protocol_negotiation = 16;
  TLSEXT_TYPE_signed_certificate_timestamp = 18;
  TLSEXT_TYPE_padding = 21;
  TLSEXT_TYPE_encrypt_then_mac = 22;
  TLSEXT_TYPE_extended_master_secret = 23;
  TLSEXT_TYPE_session_ticket = 35;
  TLSEXT_TYPE_psk = 41;
  TLSEXT_TYPE_early_data = 42;
  TLSEXT_TYPE_supported_versions = 43;
  TLSEXT_TYPE_cookie = 44;
  TLSEXT_TYPE_psk_kex_modes = 45;
  TLSEXT_TYPE_certificate_authorities = 47;
  TLSEXT_TYPE_post_handshake_auth = 49;
  TLSEXT_TYPE_signature_algorithms_cert = 50;
  TLSEXT_TYPE_key_share = 51;
  TLSEXT_TYPE_renegotiate = $ff01;
  TLSEXT_TYPE_next_proto_neg = 13172;
  TLSEXT_NAMETYPE_host_name = 0;
  TLSEXT_STATUSTYPE_ocsp = 1;
  TLSEXT_ECPOINTFORMAT_first = 0;
  TLSEXT_ECPOINTFORMAT_uncompressed = 0;
  TLSEXT_ECPOINTFORMAT_ansiX962_compressed_prime = 1;
  TLSEXT_ECPOINTFORMAT_ansiX962_compressed_char2 = 2;
  TLSEXT_ECPOINTFORMAT_last = 2;
  TLSEXT_signature_anonymous = 0;
  TLSEXT_signature_rsa = 1;
  TLSEXT_signature_dsa = 2;
  TLSEXT_signature_ecdsa = 3;
  TLSEXT_signature_gostr34102001 = 237;
  TLSEXT_signature_gostr34102012_256 = 238;
  TLSEXT_signature_gostr34102012_512 = 239;
  TLSEXT_signature_num = 7;
  TLSEXT_hash_none = 0;
  TLSEXT_hash_md5 = 1;
  TLSEXT_hash_sha1 = 2;
  TLSEXT_hash_sha224 = 3;
  TLSEXT_hash_sha256 = 4;
  TLSEXT_hash_sha384 = 5;
  TLSEXT_hash_sha512 = 6;
  TLSEXT_hash_gostr3411 = 237;
  TLSEXT_hash_gostr34112012_256 = 238;
  TLSEXT_hash_gostr34112012_512 = 239;
  TLSEXT_hash_num = 10;
  TLSEXT_nid_unknown = $1000000;
  TLSEXT_curve_P_256 = 23;
  TLSEXT_curve_P_384 = 24;
  TLSEXT_max_fragment_length_DISABLED = 0;
  TLSEXT_max_fragment_length_512 = 1;
  TLSEXT_max_fragment_length_1024 = 2;
  TLSEXT_max_fragment_length_2048 = 3;
  TLSEXT_max_fragment_length_4096 = 4;
  TLSEXT_MAXLEN_host_name = 255;
  SSL_TLSEXT_ERR_OK = 0;
  SSL_TLSEXT_ERR_ALERT_WARNING = 1;
  SSL_TLSEXT_ERR_ALERT_FATAL = 2;
  SSL_TLSEXT_ERR_NOACK = 3;
  TLS1_CK_PSK_WITH_RC4_128_SHA = $0300008A;
  TLS1_CK_PSK_WITH_3DES_EDE_CBC_SHA = $0300008B;
  TLS1_CK_PSK_WITH_AES_128_CBC_SHA = $0300008C;
  TLS1_CK_PSK_WITH_AES_256_CBC_SHA = $0300008D;
  TLS1_CK_DHE_PSK_WITH_RC4_128_SHA = $0300008E;
  TLS1_CK_DHE_PSK_WITH_3DES_EDE_CBC_SHA = $0300008F;
  TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA = $03000090;
  TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA = $03000091;
  TLS1_CK_RSA_PSK_WITH_RC4_128_SHA = $03000092;
  TLS1_CK_RSA_PSK_WITH_3DES_EDE_CBC_SHA = $03000093;
  TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA = $03000094;
  TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA = $03000095;
  TLS1_CK_PSK_WITH_AES_128_GCM_SHA256 = $030000A8;
  TLS1_CK_PSK_WITH_AES_256_GCM_SHA384 = $030000A9;
  TLS1_CK_DHE_PSK_WITH_AES_128_GCM_SHA256 = $030000AA;
  TLS1_CK_DHE_PSK_WITH_AES_256_GCM_SHA384 = $030000AB;
  TLS1_CK_RSA_PSK_WITH_AES_128_GCM_SHA256 = $030000AC;
  TLS1_CK_RSA_PSK_WITH_AES_256_GCM_SHA384 = $030000AD;
  TLS1_CK_PSK_WITH_AES_128_CBC_SHA256 = $030000AE;
  TLS1_CK_PSK_WITH_AES_256_CBC_SHA384 = $030000AF;
  TLS1_CK_PSK_WITH_NULL_SHA256 = $030000B0;
  TLS1_CK_PSK_WITH_NULL_SHA384 = $030000B1;
  TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA256 = $030000B2;
  TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA384 = $030000B3;
  TLS1_CK_DHE_PSK_WITH_NULL_SHA256 = $030000B4;
  TLS1_CK_DHE_PSK_WITH_NULL_SHA384 = $030000B5;
  TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA256 = $030000B6;
  TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA384 = $030000B7;
  TLS1_CK_RSA_PSK_WITH_NULL_SHA256 = $030000B8;
  TLS1_CK_RSA_PSK_WITH_NULL_SHA384 = $030000B9;
  TLS1_CK_PSK_WITH_NULL_SHA = $0300002C;
  TLS1_CK_DHE_PSK_WITH_NULL_SHA = $0300002D;
  TLS1_CK_RSA_PSK_WITH_NULL_SHA = $0300002E;
  TLS1_CK_RSA_WITH_AES_128_SHA = $0300002F;
  TLS1_CK_DH_DSS_WITH_AES_128_SHA = $03000030;
  TLS1_CK_DH_RSA_WITH_AES_128_SHA = $03000031;
  TLS1_CK_DHE_DSS_WITH_AES_128_SHA = $03000032;
  TLS1_CK_DHE_RSA_WITH_AES_128_SHA = $03000033;
  TLS1_CK_ADH_WITH_AES_128_SHA = $03000034;
  TLS1_CK_RSA_WITH_AES_256_SHA = $03000035;
  TLS1_CK_DH_DSS_WITH_AES_256_SHA = $03000036;
  TLS1_CK_DH_RSA_WITH_AES_256_SHA = $03000037;
  TLS1_CK_DHE_DSS_WITH_AES_256_SHA = $03000038;
  TLS1_CK_DHE_RSA_WITH_AES_256_SHA = $03000039;
  TLS1_CK_ADH_WITH_AES_256_SHA = $0300003A;
  TLS1_CK_RSA_WITH_NULL_SHA256 = $0300003B;
  TLS1_CK_RSA_WITH_AES_128_SHA256 = $0300003C;
  TLS1_CK_RSA_WITH_AES_256_SHA256 = $0300003D;
  TLS1_CK_DH_DSS_WITH_AES_128_SHA256 = $0300003E;
  TLS1_CK_DH_RSA_WITH_AES_128_SHA256 = $0300003F;
  TLS1_CK_DHE_DSS_WITH_AES_128_SHA256 = $03000040;
  TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000041;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = $03000042;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000043;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = $03000044;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000045;
  TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA = $03000046;
  TLS1_CK_DHE_RSA_WITH_AES_128_SHA256 = $03000067;
  TLS1_CK_DH_DSS_WITH_AES_256_SHA256 = $03000068;
  TLS1_CK_DH_RSA_WITH_AES_256_SHA256 = $03000069;
  TLS1_CK_DHE_DSS_WITH_AES_256_SHA256 = $0300006A;
  TLS1_CK_DHE_RSA_WITH_AES_256_SHA256 = $0300006B;
  TLS1_CK_ADH_WITH_AES_128_SHA256 = $0300006C;
  TLS1_CK_ADH_WITH_AES_256_SHA256 = $0300006D;
  TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000084;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = $03000085;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000086;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = $03000087;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000088;
  TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA = $03000089;
  TLS1_CK_RSA_WITH_SEED_SHA = $03000096;
  TLS1_CK_DH_DSS_WITH_SEED_SHA = $03000097;
  TLS1_CK_DH_RSA_WITH_SEED_SHA = $03000098;
  TLS1_CK_DHE_DSS_WITH_SEED_SHA = $03000099;
  TLS1_CK_DHE_RSA_WITH_SEED_SHA = $0300009A;
  TLS1_CK_ADH_WITH_SEED_SHA = $0300009B;
  TLS1_CK_RSA_WITH_AES_128_GCM_SHA256 = $0300009C;
  TLS1_CK_RSA_WITH_AES_256_GCM_SHA384 = $0300009D;
  TLS1_CK_DHE_RSA_WITH_AES_128_GCM_SHA256 = $0300009E;
  TLS1_CK_DHE_RSA_WITH_AES_256_GCM_SHA384 = $0300009F;
  TLS1_CK_DH_RSA_WITH_AES_128_GCM_SHA256 = $030000A0;
  TLS1_CK_DH_RSA_WITH_AES_256_GCM_SHA384 = $030000A1;
  TLS1_CK_DHE_DSS_WITH_AES_128_GCM_SHA256 = $030000A2;
  TLS1_CK_DHE_DSS_WITH_AES_256_GCM_SHA384 = $030000A3;
  TLS1_CK_DH_DSS_WITH_AES_128_GCM_SHA256 = $030000A4;
  TLS1_CK_DH_DSS_WITH_AES_256_GCM_SHA384 = $030000A5;
  TLS1_CK_ADH_WITH_AES_128_GCM_SHA256 = $030000A6;
  TLS1_CK_ADH_WITH_AES_256_GCM_SHA384 = $030000A7;
  TLS1_CK_RSA_WITH_AES_128_CCM = $0300C09C;
  TLS1_CK_RSA_WITH_AES_256_CCM = $0300C09D;
  TLS1_CK_DHE_RSA_WITH_AES_128_CCM = $0300C09E;
  TLS1_CK_DHE_RSA_WITH_AES_256_CCM = $0300C09F;
  TLS1_CK_RSA_WITH_AES_128_CCM_8 = $0300C0A0;
  TLS1_CK_RSA_WITH_AES_256_CCM_8 = $0300C0A1;
  TLS1_CK_DHE_RSA_WITH_AES_128_CCM_8 = $0300C0A2;
  TLS1_CK_DHE_RSA_WITH_AES_256_CCM_8 = $0300C0A3;
  TLS1_CK_PSK_WITH_AES_128_CCM = $0300C0A4;
  TLS1_CK_PSK_WITH_AES_256_CCM = $0300C0A5;
  TLS1_CK_DHE_PSK_WITH_AES_128_CCM = $0300C0A6;
  TLS1_CK_DHE_PSK_WITH_AES_256_CCM = $0300C0A7;
  TLS1_CK_PSK_WITH_AES_128_CCM_8 = $0300C0A8;
  TLS1_CK_PSK_WITH_AES_256_CCM_8 = $0300C0A9;
  TLS1_CK_DHE_PSK_WITH_AES_128_CCM_8 = $0300C0AA;
  TLS1_CK_DHE_PSK_WITH_AES_256_CCM_8 = $0300C0AB;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM = $0300C0AC;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM = $0300C0AD;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM_8 = $0300C0AE;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM_8 = $0300C0AF;
  TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $030000BA;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = $030000BB;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $030000BC;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = $030000BD;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $030000BE;
  TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA256 = $030000BF;
  TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA256 = $030000C0;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = $030000C1;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = $030000C2;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = $030000C3;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = $030000C4;
  TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA256 = $030000C5;
  TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA = $0300C001;
  TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA = $0300C002;
  TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA = $0300C003;
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA = $0300C004;
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA = $0300C005;
  TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA = $0300C006;
  TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA = $0300C007;
  TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = $0300C008;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = $0300C009;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = $0300C00A;
  TLS1_CK_ECDH_RSA_WITH_NULL_SHA = $0300C00B;
  TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA = $0300C00C;
  TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA = $0300C00D;
  TLS1_CK_ECDH_RSA_WITH_AES_128_CBC_SHA = $0300C00E;
  TLS1_CK_ECDH_RSA_WITH_AES_256_CBC_SHA = $0300C00F;
  TLS1_CK_ECDHE_RSA_WITH_NULL_SHA = $0300C010;
  TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA = $0300C011;
  TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA = $0300C012;
  TLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA = $0300C013;
  TLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA = $0300C014;
  TLS1_CK_ECDH_anon_WITH_NULL_SHA = $0300C015;
  TLS1_CK_ECDH_anon_WITH_RC4_128_SHA = $0300C016;
  TLS1_CK_ECDH_anon_WITH_DES_192_CBC3_SHA = $0300C017;
  TLS1_CK_ECDH_anon_WITH_AES_128_CBC_SHA = $0300C018;
  TLS1_CK_ECDH_anon_WITH_AES_256_CBC_SHA = $0300C019;
  TLS1_CK_SRP_SHA_WITH_3DES_EDE_CBC_SHA = $0300C01A;
  TLS1_CK_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = $0300C01B;
  TLS1_CK_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = $0300C01C;
  TLS1_CK_SRP_SHA_WITH_AES_128_CBC_SHA = $0300C01D;
  TLS1_CK_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = $0300C01E;
  TLS1_CK_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = $0300C01F;
  TLS1_CK_SRP_SHA_WITH_AES_256_CBC_SHA = $0300C020;
  TLS1_CK_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = $0300C021;
  TLS1_CK_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = $0300C022;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_SHA256 = $0300C023;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_SHA384 = $0300C024;
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_SHA256 = $0300C025;
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_SHA384 = $0300C026;
  TLS1_CK_ECDHE_RSA_WITH_AES_128_SHA256 = $0300C027;
  TLS1_CK_ECDHE_RSA_WITH_AES_256_SHA384 = $0300C028;
  TLS1_CK_ECDH_RSA_WITH_AES_128_SHA256 = $0300C029;
  TLS1_CK_ECDH_RSA_WITH_AES_256_SHA384 = $0300C02A;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = $0300C02B;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = $0300C02C;
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = $0300C02D;
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = $0300C02E;
  TLS1_CK_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = $0300C02F;
  TLS1_CK_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = $0300C030;
  TLS1_CK_ECDH_RSA_WITH_AES_128_GCM_SHA256 = $0300C031;
  TLS1_CK_ECDH_RSA_WITH_AES_256_GCM_SHA384 = $0300C032;
  TLS1_CK_ECDHE_PSK_WITH_RC4_128_SHA = $0300C033;
  TLS1_CK_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = $0300C034;
  TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA = $0300C035;
  TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA = $0300C036;
  TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = $0300C037;
  TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = $0300C038;
  TLS1_CK_ECDHE_PSK_WITH_NULL_SHA = $0300C039;
  TLS1_CK_ECDHE_PSK_WITH_NULL_SHA256 = $0300C03A;
  TLS1_CK_ECDHE_PSK_WITH_NULL_SHA384 = $0300C03B;
  TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C072;
  TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C073;
  TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C074;
  TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C075;
  TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C076;
  TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C077;
  TLS1_CK_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C078;
  TLS1_CK_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C079;
  TLS1_CK_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C094;
  TLS1_CK_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C095;
  TLS1_CK_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C096;
  TLS1_CK_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C097;
  TLS1_CK_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C098;
  TLS1_CK_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C099;
  TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C09A;
  TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C09B;
  TLS1_CK_ECDHE_RSA_WITH_CHACHA20_POLY1305 = $0300CCA8;
  TLS1_CK_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 = $0300CCA9;
  TLS1_CK_DHE_RSA_WITH_CHACHA20_POLY1305 = $0300CCAA;
  TLS1_CK_PSK_WITH_CHACHA20_POLY1305 = $0300CCAB;
  TLS1_CK_ECDHE_PSK_WITH_CHACHA20_POLY1305 = $0300CCAC;
  TLS1_CK_DHE_PSK_WITH_CHACHA20_POLY1305 = $0300CCAD;
  TLS1_CK_RSA_PSK_WITH_CHACHA20_POLY1305 = $0300CCAE;
  TLS1_3_CK_AES_128_GCM_SHA256 = $03001301;
  TLS1_3_CK_AES_256_GCM_SHA384 = $03001302;
  TLS1_3_CK_CHACHA20_POLY1305_SHA256 = $03001303;
  TLS1_3_CK_AES_128_CCM_SHA256 = $03001304;
  TLS1_3_CK_AES_128_CCM_8_SHA256 = $03001305;
  TLS1_CK_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C050;
  TLS1_CK_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C051;
  TLS1_CK_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C052;
  TLS1_CK_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C053;
  TLS1_CK_DH_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C054;
  TLS1_CK_DH_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C055;
  TLS1_CK_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = $0300C056;
  TLS1_CK_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = $0300C057;
  TLS1_CK_DH_DSS_WITH_ARIA_128_GCM_SHA256 = $0300C058;
  TLS1_CK_DH_DSS_WITH_ARIA_256_GCM_SHA384 = $0300C059;
  TLS1_CK_DH_anon_WITH_ARIA_128_GCM_SHA256 = $0300C05A;
  TLS1_CK_DH_anon_WITH_ARIA_256_GCM_SHA384 = $0300C05B;
  TLS1_CK_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = $0300C05C;
  TLS1_CK_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = $0300C05D;
  TLS1_CK_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = $0300C05E;
  TLS1_CK_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = $0300C05F;
  TLS1_CK_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C060;
  TLS1_CK_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C061;
  TLS1_CK_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C062;
  TLS1_CK_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C063;
  TLS1_CK_PSK_WITH_ARIA_128_GCM_SHA256 = $0300C06A;
  TLS1_CK_PSK_WITH_ARIA_256_GCM_SHA384 = $0300C06B;
  TLS1_CK_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = $0300C06C;
  TLS1_CK_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = $0300C06D;
  TLS1_CK_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = $0300C06E;
  TLS1_CK_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = $0300C06F;
  TLS1_RFC_RSA_WITH_AES_128_SHA = 'TLS_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_AES_128_SHA = 'TLS_DHE_DSS_WITH_AES_128_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_AES_128_SHA = 'TLS_DHE_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ADH_WITH_AES_128_SHA = 'TLS_DH_anon_WITH_AES_128_CBC_SHA';
  TLS1_RFC_RSA_WITH_AES_256_SHA = 'TLS_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_AES_256_SHA = 'TLS_DHE_DSS_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_AES_256_SHA = 'TLS_DHE_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ADH_WITH_AES_256_SHA = 'TLS_DH_anon_WITH_AES_256_CBC_SHA';
  TLS1_RFC_RSA_WITH_NULL_SHA256 = 'TLS_RSA_WITH_NULL_SHA256';
  TLS1_RFC_RSA_WITH_AES_128_SHA256 = 'TLS_RSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_RSA_WITH_AES_256_SHA256 = 'TLS_RSA_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_AES_128_SHA256 = 'TLS_DHE_DSS_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_AES_128_SHA256 = 'TLS_DHE_RSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_AES_256_SHA256 = 'TLS_DHE_DSS_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_AES_256_SHA256 = 'TLS_DHE_RSA_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_ADH_WITH_AES_128_SHA256 = 'TLS_DH_anon_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ADH_WITH_AES_256_SHA256 = 'TLS_DH_anon_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_RSA_WITH_AES_128_GCM_SHA256 = 'TLS_RSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_RSA_WITH_AES_256_GCM_SHA384 = 'TLS_RSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_DHE_RSA_WITH_AES_128_GCM_SHA256 = 'TLS_DHE_RSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_DHE_RSA_WITH_AES_256_GCM_SHA384 = 'TLS_DHE_RSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_DHE_DSS_WITH_AES_128_GCM_SHA256 = 'TLS_DHE_DSS_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_DHE_DSS_WITH_AES_256_GCM_SHA384 = 'TLS_DHE_DSS_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_ADH_WITH_AES_128_GCM_SHA256 = 'TLS_DH_anon_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_ADH_WITH_AES_256_GCM_SHA384 = 'TLS_DH_anon_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_RSA_WITH_AES_128_CCM = 'TLS_RSA_WITH_AES_128_CCM';
  TLS1_RFC_RSA_WITH_AES_256_CCM = 'TLS_RSA_WITH_AES_256_CCM';
  TLS1_RFC_DHE_RSA_WITH_AES_128_CCM = 'TLS_DHE_RSA_WITH_AES_128_CCM';
  TLS1_RFC_DHE_RSA_WITH_AES_256_CCM = 'TLS_DHE_RSA_WITH_AES_256_CCM';
  TLS1_RFC_RSA_WITH_AES_128_CCM_8 = 'TLS_RSA_WITH_AES_128_CCM_8';
  TLS1_RFC_RSA_WITH_AES_256_CCM_8 = 'TLS_RSA_WITH_AES_256_CCM_8';
  TLS1_RFC_DHE_RSA_WITH_AES_128_CCM_8 = 'TLS_DHE_RSA_WITH_AES_128_CCM_8';
  TLS1_RFC_DHE_RSA_WITH_AES_256_CCM_8 = 'TLS_DHE_RSA_WITH_AES_256_CCM_8';
  TLS1_RFC_PSK_WITH_AES_128_CCM = 'TLS_PSK_WITH_AES_128_CCM';
  TLS1_RFC_PSK_WITH_AES_256_CCM = 'TLS_PSK_WITH_AES_256_CCM';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CCM = 'TLS_DHE_PSK_WITH_AES_128_CCM';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CCM = 'TLS_DHE_PSK_WITH_AES_256_CCM';
  TLS1_RFC_PSK_WITH_AES_128_CCM_8 = 'TLS_PSK_WITH_AES_128_CCM_8';
  TLS1_RFC_PSK_WITH_AES_256_CCM_8 = 'TLS_PSK_WITH_AES_256_CCM_8';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CCM_8 = 'TLS_PSK_DHE_WITH_AES_128_CCM_8';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CCM_8 = 'TLS_PSK_DHE_WITH_AES_256_CCM_8';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM = 'TLS_ECDHE_ECDSA_WITH_AES_128_CCM';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM = 'TLS_ECDHE_ECDSA_WITH_AES_256_CCM';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 'TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 'TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8';
  TLS1_3_RFC_AES_128_GCM_SHA256 = 'TLS_AES_128_GCM_SHA256';
  TLS1_3_RFC_AES_256_GCM_SHA384 = 'TLS_AES_256_GCM_SHA384';
  TLS1_3_RFC_CHACHA20_POLY1305_SHA256 = 'TLS_CHACHA20_POLY1305_SHA256';
  TLS1_3_RFC_AES_128_CCM_SHA256 = 'TLS_AES_128_CCM_SHA256';
  TLS1_3_RFC_AES_128_CCM_8_SHA256 = 'TLS_AES_128_CCM_8_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_NULL_SHA = 'TLS_ECDHE_ECDSA_WITH_NULL_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = 'TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 'TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 'TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_NULL_SHA = 'TLS_ECDHE_RSA_WITH_NULL_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_DES_192_CBC3_SHA = 'TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_AES_128_CBC_SHA = 'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_AES_256_CBC_SHA = 'TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDH_anon_WITH_NULL_SHA = 'TLS_ECDH_anon_WITH_NULL_SHA';
  TLS1_RFC_ECDH_anon_WITH_DES_192_CBC3_SHA = 'TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDH_anon_WITH_AES_128_CBC_SHA = 'TLS_ECDH_anon_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDH_anon_WITH_AES_256_CBC_SHA = 'TLS_ECDH_anon_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_SHA256 = 'TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_SHA384 = 'TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_AES_128_SHA256 = 'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_AES_256_SHA384 = 'TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 'TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 'TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 'TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 'TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_PSK_WITH_NULL_SHA = 'TLS_PSK_WITH_NULL_SHA';
  TLS1_RFC_DHE_PSK_WITH_NULL_SHA = 'TLS_DHE_PSK_WITH_NULL_SHA';
  TLS1_RFC_RSA_PSK_WITH_NULL_SHA = 'TLS_RSA_PSK_WITH_NULL_SHA';
  TLS1_RFC_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_PSK_WITH_AES_128_CBC_SHA = 'TLS_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_PSK_WITH_AES_256_CBC_SHA = 'TLS_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA = 'TLS_DHE_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA = 'TLS_DHE_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA = 'TLS_RSA_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA = 'TLS_RSA_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_PSK_WITH_AES_128_GCM_SHA256 = 'TLS_PSK_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_PSK_WITH_AES_256_GCM_SHA384 = 'TLS_PSK_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_DHE_PSK_WITH_AES_128_GCM_SHA256 = 'TLS_DHE_PSK_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_DHE_PSK_WITH_AES_256_GCM_SHA384 = 'TLS_DHE_PSK_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_RSA_PSK_WITH_AES_128_GCM_SHA256 = 'TLS_RSA_PSK_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_RSA_PSK_WITH_AES_256_GCM_SHA384 = 'TLS_RSA_PSK_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_PSK_WITH_NULL_SHA256 = 'TLS_PSK_WITH_NULL_SHA256';
  TLS1_RFC_PSK_WITH_NULL_SHA384 = 'TLS_PSK_WITH_NULL_SHA384';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_DHE_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_DHE_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_DHE_PSK_WITH_NULL_SHA256 = 'TLS_DHE_PSK_WITH_NULL_SHA256';
  TLS1_RFC_DHE_PSK_WITH_NULL_SHA384 = 'TLS_DHE_PSK_WITH_NULL_SHA384';
  TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_RSA_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_RSA_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_RSA_PSK_WITH_NULL_SHA256 = 'TLS_RSA_PSK_WITH_NULL_SHA256';
  TLS1_RFC_RSA_PSK_WITH_NULL_SHA384 = 'TLS_RSA_PSK_WITH_NULL_SHA384';
  TLS1_RFC_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA = 'TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA = 'TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA = 'TLS_ECDHE_PSK_WITH_NULL_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA256 = 'TLS_ECDHE_PSK_WITH_NULL_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA384 = 'TLS_ECDHE_PSK_WITH_NULL_SHA384';
  TLS1_RFC_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 'TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 'TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 'TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_SRP_SHA_WITH_AES_128_CBC_SHA = 'TLS_SRP_SHA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 'TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 'TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA';
  TLS1_RFC_SRP_SHA_WITH_AES_256_CBC_SHA = 'TLS_SRP_SHA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 'TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 'TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_CHACHA20_POLY1305 = 'TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_CHACHA20_POLY1305 = 'TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 = 'TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_PSK_WITH_CHACHA20_POLY1305 = 'TLS_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_CHACHA20_POLY1305 = 'TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_DHE_PSK_WITH_CHACHA20_POLY1305 = 'TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_RSA_PSK_WITH_CHACHA20_POLY1305 = 'TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA = 'TLS_RSA_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 'TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 'TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA = 'TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA = 'TLS_RSA_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 'TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 'TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA = 'TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_RSA_WITH_SEED_SHA = 'TLS_RSA_WITH_SEED_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_SEED_SHA = 'TLS_DHE_DSS_WITH_SEED_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_SEED_SHA = 'TLS_DHE_RSA_WITH_SEED_CBC_SHA';
  TLS1_RFC_ADH_WITH_SEED_SHA = 'TLS_DH_anon_WITH_SEED_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_RC4_128_SHA = 'TLS_ECDHE_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_ECDH_anon_WITH_RC4_128_SHA = 'TLS_ECDH_anon_WITH_RC4_128_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_RC4_128_SHA = 'TLS_ECDHE_ECDSA_WITH_RC4_128_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_RC4_128_SHA = 'TLS_ECDHE_RSA_WITH_RC4_128_SHA';
  TLS1_RFC_PSK_WITH_RC4_128_SHA = 'TLS_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_RSA_PSK_WITH_RC4_128_SHA = 'TLS_RSA_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_DHE_PSK_WITH_RC4_128_SHA = 'TLS_DHE_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 'TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 'TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 'TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 'TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DH_anon_WITH_ARIA_128_GCM_SHA256 = 'TLS_DH_anon_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DH_anon_WITH_ARIA_256_GCM_SHA384 = 'TLS_DH_anon_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_PSK_WITH_ARIA_128_GCM_SHA256 = 'TLS_PSK_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_PSK_WITH_ARIA_256_GCM_SHA384 = 'TLS_PSK_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 'TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 'TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 'TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 'TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384';
  TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA = 'DHE-DSS-RC4-SHA';
  TLS1_TXT_PSK_WITH_NULL_SHA = 'PSK-NULL-SHA';
  TLS1_TXT_DHE_PSK_WITH_NULL_SHA = 'DHE-PSK-NULL-SHA';
  TLS1_TXT_RSA_PSK_WITH_NULL_SHA = 'RSA-PSK-NULL-SHA';
  TLS1_TXT_RSA_WITH_AES_128_SHA = 'AES128-SHA';
  TLS1_TXT_DH_DSS_WITH_AES_128_SHA = 'DH-DSS-AES128-SHA';
  TLS1_TXT_DH_RSA_WITH_AES_128_SHA = 'DH-RSA-AES128-SHA';
  TLS1_TXT_DHE_DSS_WITH_AES_128_SHA = 'DHE-DSS-AES128-SHA';
  TLS1_TXT_DHE_RSA_WITH_AES_128_SHA = 'DHE-RSA-AES128-SHA';
  TLS1_TXT_ADH_WITH_AES_128_SHA = 'ADH-AES128-SHA';
  TLS1_TXT_RSA_WITH_AES_256_SHA = 'AES256-SHA';
  TLS1_TXT_DH_DSS_WITH_AES_256_SHA = 'DH-DSS-AES256-SHA';
  TLS1_TXT_DH_RSA_WITH_AES_256_SHA = 'DH-RSA-AES256-SHA';
  TLS1_TXT_DHE_DSS_WITH_AES_256_SHA = 'DHE-DSS-AES256-SHA';
  TLS1_TXT_DHE_RSA_WITH_AES_256_SHA = 'DHE-RSA-AES256-SHA';
  TLS1_TXT_ADH_WITH_AES_256_SHA = 'ADH-AES256-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA = 'ECDH-ECDSA-NULL-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA = 'ECDH-ECDSA-RC4-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA = 'ECDH-ECDSA-DES-CBC3-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 'ECDH-ECDSA-AES128-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 'ECDH-ECDSA-AES256-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA = 'ECDHE-ECDSA-NULL-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA = 'ECDHE-ECDSA-RC4-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = 'ECDHE-ECDSA-DES-CBC3-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 'ECDHE-ECDSA-AES128-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 'ECDHE-ECDSA-AES256-SHA';
  TLS1_TXT_ECDH_RSA_WITH_NULL_SHA = 'ECDH-RSA-NULL-SHA';
  TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA = 'ECDH-RSA-RC4-SHA';
  TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA = 'ECDH-RSA-DES-CBC3-SHA';
  TLS1_TXT_ECDH_RSA_WITH_AES_128_CBC_SHA = 'ECDH-RSA-AES128-SHA';
  TLS1_TXT_ECDH_RSA_WITH_AES_256_CBC_SHA = 'ECDH-RSA-AES256-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA = 'ECDHE-RSA-NULL-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA = 'ECDHE-RSA-RC4-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA = 'ECDHE-RSA-DES-CBC3-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_CBC_SHA = 'ECDHE-RSA-AES128-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_CBC_SHA = 'ECDHE-RSA-AES256-SHA';
  TLS1_TXT_ECDH_anon_WITH_NULL_SHA = 'AECDH-NULL-SHA';
  TLS1_TXT_ECDH_anon_WITH_RC4_128_SHA = 'AECDH-RC4-SHA';
  TLS1_TXT_ECDH_anon_WITH_DES_192_CBC3_SHA = 'AECDH-DES-CBC3-SHA';
  TLS1_TXT_ECDH_anon_WITH_AES_128_CBC_SHA = 'AECDH-AES128-SHA';
  TLS1_TXT_ECDH_anon_WITH_AES_256_CBC_SHA = 'AECDH-AES256-SHA';
  TLS1_TXT_PSK_WITH_RC4_128_SHA = 'PSK-RC4-SHA';
  TLS1_TXT_PSK_WITH_3DES_EDE_CBC_SHA = 'PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_PSK_WITH_AES_128_CBC_SHA = 'PSK-AES128-CBC-SHA';
  TLS1_TXT_PSK_WITH_AES_256_CBC_SHA = 'PSK-AES256-CBC-SHA';
  TLS1_TXT_DHE_PSK_WITH_RC4_128_SHA = 'DHE-PSK-RC4-SHA';
  TLS1_TXT_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 'DHE-PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA = 'DHE-PSK-AES128-CBC-SHA';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA = 'DHE-PSK-AES256-CBC-SHA';
  TLS1_TXT_RSA_PSK_WITH_RC4_128_SHA = 'RSA-PSK-RC4-SHA';
  TLS1_TXT_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 'RSA-PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA = 'RSA-PSK-AES128-CBC-SHA';
  TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA = 'RSA-PSK-AES256-CBC-SHA';
  TLS1_TXT_PSK_WITH_AES_128_GCM_SHA256 = 'PSK-AES128-GCM-SHA256';
  TLS1_TXT_PSK_WITH_AES_256_GCM_SHA384 = 'PSK-AES256-GCM-SHA384';
  TLS1_TXT_DHE_PSK_WITH_AES_128_GCM_SHA256 = 'DHE-PSK-AES128-GCM-SHA256';
  TLS1_TXT_DHE_PSK_WITH_AES_256_GCM_SHA384 = 'DHE-PSK-AES256-GCM-SHA384';
  TLS1_TXT_RSA_PSK_WITH_AES_128_GCM_SHA256 = 'RSA-PSK-AES128-GCM-SHA256';
  TLS1_TXT_RSA_PSK_WITH_AES_256_GCM_SHA384 = 'RSA-PSK-AES256-GCM-SHA384';
  TLS1_TXT_PSK_WITH_AES_128_CBC_SHA256 = 'PSK-AES128-CBC-SHA256';
  TLS1_TXT_PSK_WITH_AES_256_CBC_SHA384 = 'PSK-AES256-CBC-SHA384';
  TLS1_TXT_PSK_WITH_NULL_SHA256 = 'PSK-NULL-SHA256';
  TLS1_TXT_PSK_WITH_NULL_SHA384 = 'PSK-NULL-SHA384';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA256 = 'DHE-PSK-AES128-CBC-SHA256';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA384 = 'DHE-PSK-AES256-CBC-SHA384';
  TLS1_TXT_DHE_PSK_WITH_NULL_SHA256 = 'DHE-PSK-NULL-SHA256';
  TLS1_TXT_DHE_PSK_WITH_NULL_SHA384 = 'DHE-PSK-NULL-SHA384';
  TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA256 = 'RSA-PSK-AES128-CBC-SHA256';
  TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA384 = 'RSA-PSK-AES256-CBC-SHA384';
  TLS1_TXT_RSA_PSK_WITH_NULL_SHA256 = 'RSA-PSK-NULL-SHA256';
  TLS1_TXT_RSA_PSK_WITH_NULL_SHA384 = 'RSA-PSK-NULL-SHA384';
  TLS1_TXT_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 'SRP-3DES-EDE-CBC-SHA';
  TLS1_TXT_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 'SRP-RSA-3DES-EDE-CBC-SHA';
  TLS1_TXT_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 'SRP-DSS-3DES-EDE-CBC-SHA';
  TLS1_TXT_SRP_SHA_WITH_AES_128_CBC_SHA = 'SRP-AES-128-CBC-SHA';
  TLS1_TXT_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 'SRP-RSA-AES-128-CBC-SHA';
  TLS1_TXT_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 'SRP-DSS-AES-128-CBC-SHA';
  TLS1_TXT_SRP_SHA_WITH_AES_256_CBC_SHA = 'SRP-AES-256-CBC-SHA';
  TLS1_TXT_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 'SRP-RSA-AES-256-CBC-SHA';
  TLS1_TXT_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 'SRP-DSS-AES-256-CBC-SHA';
  TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA = 'CAMELLIA128-SHA';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 'DH-DSS-CAMELLIA128-SHA';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 'DH-RSA-CAMELLIA128-SHA';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 'DHE-DSS-CAMELLIA128-SHA';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 'DHE-RSA-CAMELLIA128-SHA';
  TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA = 'ADH-CAMELLIA128-SHA';
  TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA = 'CAMELLIA256-SHA';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 'DH-DSS-CAMELLIA256-SHA';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 'DH-RSA-CAMELLIA256-SHA';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 'DHE-DSS-CAMELLIA256-SHA';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 'DHE-RSA-CAMELLIA256-SHA';
  TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA = 'ADH-CAMELLIA256-SHA';
  TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'CAMELLIA128-SHA256';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 'DH-DSS-CAMELLIA128-SHA256';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'DH-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 'DHE-DSS-CAMELLIA128-SHA256';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'DHE-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA256 = 'ADH-CAMELLIA128-SHA256';
  TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'CAMELLIA256-SHA256';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 'DH-DSS-CAMELLIA256-SHA256';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'DH-RSA-CAMELLIA256-SHA256';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 'DHE-DSS-CAMELLIA256-SHA256';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'DHE-RSA-CAMELLIA256-SHA256';
  TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA256 = 'ADH-CAMELLIA256-SHA256';
  TLS1_TXT_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'PSK-CAMELLIA128-SHA256';
  TLS1_TXT_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'PSK-CAMELLIA256-SHA384';
  TLS1_TXT_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'DHE-PSK-CAMELLIA128-SHA256';
  TLS1_TXT_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'DHE-PSK-CAMELLIA256-SHA384';
  TLS1_TXT_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'RSA-PSK-CAMELLIA128-SHA256';
  TLS1_TXT_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'RSA-PSK-CAMELLIA256-SHA384';
  TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDHE-PSK-CAMELLIA128-SHA256';
  TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDHE-PSK-CAMELLIA256-SHA384';
  TLS1_TXT_RSA_WITH_SEED_SHA = 'SEED-SHA';
  TLS1_TXT_DH_DSS_WITH_SEED_SHA = 'DH-DSS-SEED-SHA';
  TLS1_TXT_DH_RSA_WITH_SEED_SHA = 'DH-RSA-SEED-SHA';
  TLS1_TXT_DHE_DSS_WITH_SEED_SHA = 'DHE-DSS-SEED-SHA';
  TLS1_TXT_DHE_RSA_WITH_SEED_SHA = 'DHE-RSA-SEED-SHA';
  TLS1_TXT_ADH_WITH_SEED_SHA = 'ADH-SEED-SHA';
  TLS1_TXT_RSA_WITH_NULL_SHA256 = 'NULL-SHA256';
  TLS1_TXT_RSA_WITH_AES_128_SHA256 = 'AES128-SHA256';
  TLS1_TXT_RSA_WITH_AES_256_SHA256 = 'AES256-SHA256';
  TLS1_TXT_DH_DSS_WITH_AES_128_SHA256 = 'DH-DSS-AES128-SHA256';
  TLS1_TXT_DH_RSA_WITH_AES_128_SHA256 = 'DH-RSA-AES128-SHA256';
  TLS1_TXT_DHE_DSS_WITH_AES_128_SHA256 = 'DHE-DSS-AES128-SHA256';
  TLS1_TXT_DHE_RSA_WITH_AES_128_SHA256 = 'DHE-RSA-AES128-SHA256';
  TLS1_TXT_DH_DSS_WITH_AES_256_SHA256 = 'DH-DSS-AES256-SHA256';
  TLS1_TXT_DH_RSA_WITH_AES_256_SHA256 = 'DH-RSA-AES256-SHA256';
  TLS1_TXT_DHE_DSS_WITH_AES_256_SHA256 = 'DHE-DSS-AES256-SHA256';
  TLS1_TXT_DHE_RSA_WITH_AES_256_SHA256 = 'DHE-RSA-AES256-SHA256';
  TLS1_TXT_ADH_WITH_AES_128_SHA256 = 'ADH-AES128-SHA256';
  TLS1_TXT_ADH_WITH_AES_256_SHA256 = 'ADH-AES256-SHA256';
  TLS1_TXT_RSA_WITH_AES_128_GCM_SHA256 = 'AES128-GCM-SHA256';
  TLS1_TXT_RSA_WITH_AES_256_GCM_SHA384 = 'AES256-GCM-SHA384';
  TLS1_TXT_DHE_RSA_WITH_AES_128_GCM_SHA256 = 'DHE-RSA-AES128-GCM-SHA256';
  TLS1_TXT_DHE_RSA_WITH_AES_256_GCM_SHA384 = 'DHE-RSA-AES256-GCM-SHA384';
  TLS1_TXT_DH_RSA_WITH_AES_128_GCM_SHA256 = 'DH-RSA-AES128-GCM-SHA256';
  TLS1_TXT_DH_RSA_WITH_AES_256_GCM_SHA384 = 'DH-RSA-AES256-GCM-SHA384';
  TLS1_TXT_DHE_DSS_WITH_AES_128_GCM_SHA256 = 'DHE-DSS-AES128-GCM-SHA256';
  TLS1_TXT_DHE_DSS_WITH_AES_256_GCM_SHA384 = 'DHE-DSS-AES256-GCM-SHA384';
  TLS1_TXT_DH_DSS_WITH_AES_128_GCM_SHA256 = 'DH-DSS-AES128-GCM-SHA256';
  TLS1_TXT_DH_DSS_WITH_AES_256_GCM_SHA384 = 'DH-DSS-AES256-GCM-SHA384';
  TLS1_TXT_ADH_WITH_AES_128_GCM_SHA256 = 'ADH-AES128-GCM-SHA256';
  TLS1_TXT_ADH_WITH_AES_256_GCM_SHA384 = 'ADH-AES256-GCM-SHA384';
  TLS1_TXT_RSA_WITH_AES_128_CCM = 'AES128-CCM';
  TLS1_TXT_RSA_WITH_AES_256_CCM = 'AES256-CCM';
  TLS1_TXT_DHE_RSA_WITH_AES_128_CCM = 'DHE-RSA-AES128-CCM';
  TLS1_TXT_DHE_RSA_WITH_AES_256_CCM = 'DHE-RSA-AES256-CCM';
  TLS1_TXT_RSA_WITH_AES_128_CCM_8 = 'AES128-CCM8';
  TLS1_TXT_RSA_WITH_AES_256_CCM_8 = 'AES256-CCM8';
  TLS1_TXT_DHE_RSA_WITH_AES_128_CCM_8 = 'DHE-RSA-AES128-CCM8';
  TLS1_TXT_DHE_RSA_WITH_AES_256_CCM_8 = 'DHE-RSA-AES256-CCM8';
  TLS1_TXT_PSK_WITH_AES_128_CCM = 'PSK-AES128-CCM';
  TLS1_TXT_PSK_WITH_AES_256_CCM = 'PSK-AES256-CCM';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CCM = 'DHE-PSK-AES128-CCM';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CCM = 'DHE-PSK-AES256-CCM';
  TLS1_TXT_PSK_WITH_AES_128_CCM_8 = 'PSK-AES128-CCM8';
  TLS1_TXT_PSK_WITH_AES_256_CCM_8 = 'PSK-AES256-CCM8';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CCM_8 = 'DHE-PSK-AES128-CCM8';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CCM_8 = 'DHE-PSK-AES256-CCM8';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM = 'ECDHE-ECDSA-AES128-CCM';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM = 'ECDHE-ECDSA-AES256-CCM';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 'ECDHE-ECDSA-AES128-CCM8';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 'ECDHE-ECDSA-AES256-CCM8';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_SHA256 = 'ECDHE-ECDSA-AES128-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_SHA384 = 'ECDHE-ECDSA-AES256-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_SHA256 = 'ECDH-ECDSA-AES128-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_SHA384 = 'ECDH-ECDSA-AES256-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_SHA256 = 'ECDHE-RSA-AES128-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_SHA384 = 'ECDHE-RSA-AES256-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_AES_128_SHA256 = 'ECDH-RSA-AES128-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_AES_256_SHA384 = 'ECDH-RSA-AES256-SHA384';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 'ECDHE-ECDSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 'ECDHE-ECDSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = 'ECDH-ECDSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = 'ECDH-ECDSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 'ECDHE-RSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 'ECDHE-RSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_AES_128_GCM_SHA256 = 'ECDH-RSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_AES_256_GCM_SHA384 = 'ECDH-RSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDHE_PSK_WITH_RC4_128_SHA = 'ECDHE-PSK-RC4-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 'ECDHE-PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA = 'ECDHE-PSK-AES128-CBC-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA = 'ECDHE-PSK-AES256-CBC-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 'ECDHE-PSK-AES128-CBC-SHA256';
  TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 'ECDHE-PSK-AES256-CBC-SHA384';
  TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA = 'ECDHE-PSK-NULL-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA256 = 'ECDHE-PSK-NULL-SHA256';
  TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA384 = 'ECDHE-PSK-NULL-SHA384';
  TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDHE-ECDSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDHE-ECDSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDH-ECDSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDH-ECDSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDHE-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDHE-RSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDH-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDH-RSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_CHACHA20_POLY1305 = 'ECDHE-RSA-CHACHA20-POLY1305';
  TLS1_TXT_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 = 'ECDHE-ECDSA-CHACHA20-POLY1305';
  TLS1_TXT_DHE_RSA_WITH_CHACHA20_POLY1305 = 'DHE-RSA-CHACHA20-POLY1305';
  TLS1_TXT_PSK_WITH_CHACHA20_POLY1305 = 'PSK-CHACHA20-POLY1305';
  TLS1_TXT_ECDHE_PSK_WITH_CHACHA20_POLY1305 = 'ECDHE-PSK-CHACHA20-POLY1305';
  TLS1_TXT_DHE_PSK_WITH_CHACHA20_POLY1305 = 'DHE-PSK-CHACHA20-POLY1305';
  TLS1_TXT_RSA_PSK_WITH_CHACHA20_POLY1305 = 'RSA-PSK-CHACHA20-POLY1305';
  TLS1_TXT_RSA_WITH_ARIA_128_GCM_SHA256 = 'ARIA128-GCM-SHA256';
  TLS1_TXT_RSA_WITH_ARIA_256_GCM_SHA384 = 'ARIA256-GCM-SHA384';
  TLS1_TXT_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'DHE-RSA-ARIA128-GCM-SHA256';
  TLS1_TXT_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'DHE-RSA-ARIA256-GCM-SHA384';
  TLS1_TXT_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 'DH-RSA-ARIA128-GCM-SHA256';
  TLS1_TXT_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 'DH-RSA-ARIA256-GCM-SHA384';
  TLS1_TXT_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 'DHE-DSS-ARIA128-GCM-SHA256';
  TLS1_TXT_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 'DHE-DSS-ARIA256-GCM-SHA384';
  TLS1_TXT_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 'DH-DSS-ARIA128-GCM-SHA256';
  TLS1_TXT_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 'DH-DSS-ARIA256-GCM-SHA384';
  TLS1_TXT_DH_anon_WITH_ARIA_128_GCM_SHA256 = 'ADH-ARIA128-GCM-SHA256';
  TLS1_TXT_DH_anon_WITH_ARIA_256_GCM_SHA384 = 'ADH-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'ECDHE-ECDSA-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'ECDHE-ECDSA-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'ECDH-ECDSA-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'ECDH-ECDSA-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'ECDHE-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'ECDHE-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 'ECDH-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 'ECDH-ARIA256-GCM-SHA384';
  TLS1_TXT_PSK_WITH_ARIA_128_GCM_SHA256 = 'PSK-ARIA128-GCM-SHA256';
  TLS1_TXT_PSK_WITH_ARIA_256_GCM_SHA384 = 'PSK-ARIA256-GCM-SHA384';
  TLS1_TXT_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 'DHE-PSK-ARIA128-GCM-SHA256';
  TLS1_TXT_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 'DHE-PSK-ARIA256-GCM-SHA384';
  TLS1_TXT_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 'RSA-PSK-ARIA128-GCM-SHA256';
  TLS1_TXT_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 'RSA-PSK-ARIA256-GCM-SHA384';
  TLS_CT_RSA_SIGN = 1;
  TLS_CT_DSS_SIGN = 2;
  TLS_CT_RSA_FIXED_DH = 3;
  TLS_CT_DSS_FIXED_DH = 4;
  TLS_CT_ECDSA_SIGN = 64;
  TLS_CT_RSA_FIXED_ECDH = 65;
  TLS_CT_ECDSA_FIXED_ECDH = 66;
  TLS_CT_GOST01_SIGN = 22;
  TLS_CT_GOST12_SIGN = 238;
  TLS_CT_GOST12_512_SIGN = 239;
  TLS_CT_NUMBER = 10;
  TLS1_FINISH_MAC_LENGTH = 12;
  TLS_MD_MAX_CONST_SIZE = 22;
  TLS_MD_CLIENT_FINISH_CONST = 'client finished';
  TLS_MD_CLIENT_FINISH_CONST_SIZE = 15;
  TLS_MD_SERVER_FINISH_CONST = 'server finished';
  TLS_MD_SERVER_FINISH_CONST_SIZE = 15;
  TLS_MD_KEY_EXPANSION_CONST = 'key expansion';
  TLS_MD_KEY_EXPANSION_CONST_SIZE = 13;
  TLS_MD_CLIENT_WRITE_KEY_CONST = 'client write key';
  TLS_MD_CLIENT_WRITE_KEY_CONST_SIZE = 16;
  TLS_MD_SERVER_WRITE_KEY_CONST = 'server write key';
  TLS_MD_SERVER_WRITE_KEY_CONST_SIZE = 16;
  TLS_MD_IV_BLOCK_CONST = 'IV block';
  TLS_MD_IV_BLOCK_CONST_SIZE = 8;
  TLS_MD_MASTER_SECRET_CONST = 'master secret';
  TLS_MD_MASTER_SECRET_CONST_SIZE = 13;
  TLS_MD_EXTENDED_MASTER_SECRET_CONST = 'extended master secret';
  TLS_MD_EXTENDED_MASTER_SECRET_CONST_SIZE = 22;
  SSL_KEY_UPDATE_NONE = -1;
  SSL_KEY_UPDATE_NOT_REQUESTED = 0;
  SSL_KEY_UPDATE_REQUESTED = 1;
  SSL_ST_CONNECT = $1000;
  SSL_ST_ACCEPT = $2000;
  SSL_ST_MASK = $0FFF;
  SSL_CB_LOOP = $01;
  SSL_CB_EXIT = $02;
  SSL_CB_READ = $04;
  SSL_CB_WRITE = $08;
  SSL_CB_ALERT = $4000;
  SSL_CB_READ_ALERT = (SSL_CB_ALERT or SSL_CB_READ);
  SSL_CB_WRITE_ALERT = (SSL_CB_ALERT or SSL_CB_WRITE);
  SSL_CB_ACCEPT_LOOP = (SSL_ST_ACCEPT or SSL_CB_LOOP);
  SSL_CB_ACCEPT_EXIT = (SSL_ST_ACCEPT or SSL_CB_EXIT);
  SSL_CB_CONNECT_LOOP = (SSL_ST_CONNECT or SSL_CB_LOOP);
  SSL_CB_CONNECT_EXIT = (SSL_ST_CONNECT or SSL_CB_EXIT);
  SSL_CB_HANDSHAKE_START = $10;
  SSL_CB_HANDSHAKE_DONE = $20;
  SSL_ST_READ_HEADER = $F0;
  SSL_ST_READ_BODY = $F1;
  SSL_ST_READ_DONE = $F2;
  SSL_VERIFY_NONE = $00;
  SSL_VERIFY_PEER = $01;
  SSL_VERIFY_FAIL_IF_NO_PEER_CERT = $02;
  SSL_VERIFY_CLIENT_ONCE = $04;
  SSL_VERIFY_POST_HANDSHAKE = $08;
  SSL_AD_REASON_OFFSET = 1000;
  SSL_AD_CLOSE_NOTIFY = SSL3_AD_CLOSE_NOTIFY;
  SSL_AD_UNEXPECTED_MESSAGE = SSL3_AD_UNEXPECTED_MESSAGE;
  SSL_AD_BAD_RECORD_MAC = SSL3_AD_BAD_RECORD_MAC;
  SSL_AD_DECRYPTION_FAILED = TLS1_AD_DECRYPTION_FAILED;
  SSL_AD_RECORD_OVERFLOW = TLS1_AD_RECORD_OVERFLOW;
  SSL_AD_DECOMPRESSION_FAILURE = SSL3_AD_DECOMPRESSION_FAILURE;
  SSL_AD_HANDSHAKE_FAILURE = SSL3_AD_HANDSHAKE_FAILURE;
  SSL_AD_NO_CERTIFICATE = SSL3_AD_NO_CERTIFICATE;
  SSL_AD_BAD_CERTIFICATE = SSL3_AD_BAD_CERTIFICATE;
  SSL_AD_UNSUPPORTED_CERTIFICATE = SSL3_AD_UNSUPPORTED_CERTIFICATE;
  SSL_AD_CERTIFICATE_REVOKED = SSL3_AD_CERTIFICATE_REVOKED;
  SSL_AD_CERTIFICATE_EXPIRED = SSL3_AD_CERTIFICATE_EXPIRED;
  SSL_AD_CERTIFICATE_UNKNOWN = SSL3_AD_CERTIFICATE_UNKNOWN;
  SSL_AD_ILLEGAL_PARAMETER = SSL3_AD_ILLEGAL_PARAMETER;
  SSL_AD_UNKNOWN_CA = TLS1_AD_UNKNOWN_CA;
  SSL_AD_ACCESS_DENIED = TLS1_AD_ACCESS_DENIED;
  SSL_AD_DECODE_ERROR = TLS1_AD_DECODE_ERROR;
  SSL_AD_DECRYPT_ERROR = TLS1_AD_DECRYPT_ERROR;
  SSL_AD_EXPORT_RESTRICTION = TLS1_AD_EXPORT_RESTRICTION;
  SSL_AD_PROTOCOL_VERSION = TLS1_AD_PROTOCOL_VERSION;
  SSL_AD_INSUFFICIENT_SECURITY = TLS1_AD_INSUFFICIENT_SECURITY;
  SSL_AD_INTERNAL_ERROR = TLS1_AD_INTERNAL_ERROR;
  SSL_AD_USER_CANCELLED = TLS1_AD_USER_CANCELLED;
  SSL_AD_NO_RENEGOTIATION = TLS1_AD_NO_RENEGOTIATION;
  SSL_AD_MISSING_EXTENSION = TLS13_AD_MISSING_EXTENSION;
  SSL_AD_CERTIFICATE_REQUIRED = TLS13_AD_CERTIFICATE_REQUIRED;
  SSL_AD_UNSUPPORTED_EXTENSION = TLS1_AD_UNSUPPORTED_EXTENSION;
  SSL_AD_CERTIFICATE_UNOBTAINABLE = TLS1_AD_CERTIFICATE_UNOBTAINABLE;
  SSL_AD_UNRECOGNIZED_NAME = TLS1_AD_UNRECOGNIZED_NAME;
  SSL_AD_BAD_CERTIFICATE_STATUS_RESPONSE = TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE;
  SSL_AD_BAD_CERTIFICATE_HASH_VALUE = TLS1_AD_BAD_CERTIFICATE_HASH_VALUE;
  SSL_AD_UNKNOWN_PSK_IDENTITY = TLS1_AD_UNKNOWN_PSK_IDENTITY;
  SSL_AD_INAPPROPRIATE_FALLBACK = TLS1_AD_INAPPROPRIATE_FALLBACK;
  SSL_AD_NO_APPLICATION_PROTOCOL = TLS1_AD_NO_APPLICATION_PROTOCOL;
  SSL_ERROR_NONE = 0;
  SSL_ERROR_SSL = 1;
  SSL_ERROR_WANT_READ = 2;
  SSL_ERROR_WANT_WRITE = 3;
  SSL_ERROR_WANT_X509_LOOKUP = 4;
  SSL_ERROR_SYSCALL = 5;
  SSL_ERROR_ZERO_RETURN = 6;
  SSL_ERROR_WANT_CONNECT = 7;
  SSL_ERROR_WANT_ACCEPT = 8;
  SSL_ERROR_WANT_ASYNC = 9;
  SSL_ERROR_WANT_ASYNC_JOB = 10;
  SSL_ERROR_WANT_CLIENT_HELLO_CB = 11;
  SSL_CTRL_SET_TMP_DH = 3;
  SSL_CTRL_SET_TMP_ECDH = 4;
  SSL_CTRL_SET_TMP_DH_CB = 6;
  SSL_CTRL_GET_CLIENT_CERT_REQUEST = 9;
  SSL_CTRL_GET_NUM_RENEGOTIATIONS = 10;
  SSL_CTRL_CLEAR_NUM_RENEGOTIATIONS = 11;
  SSL_CTRL_GET_TOTAL_RENEGOTIATIONS = 12;
  SSL_CTRL_GET_FLAGS = 13;
  SSL_CTRL_EXTRA_CHAIN_CERT = 14;
  SSL_CTRL_SET_MSG_CALLBACK = 15;
  SSL_CTRL_SET_MSG_CALLBACK_ARG = 16;
  SSL_CTRL_SET_MTU = 17;
  SSL_CTRL_SESS_NUMBER = 20;
  SSL_CTRL_SESS_CONNECT = 21;
  SSL_CTRL_SESS_CONNECT_GOOD = 22;
  SSL_CTRL_SESS_CONNECT_RENEGOTIATE = 23;
  SSL_CTRL_SESS_ACCEPT = 24;
  SSL_CTRL_SESS_ACCEPT_GOOD = 25;
  SSL_CTRL_SESS_ACCEPT_RENEGOTIATE = 26;
  SSL_CTRL_SESS_HIT = 27;
  SSL_CTRL_SESS_CB_HIT = 28;
  SSL_CTRL_SESS_MISSES = 29;
  SSL_CTRL_SESS_TIMEOUTS = 30;
  SSL_CTRL_SESS_CACHE_FULL = 31;
  SSL_CTRL_MODE = 33;
  SSL_CTRL_GET_READ_AHEAD = 40;
  SSL_CTRL_SET_READ_AHEAD = 41;
  SSL_CTRL_SET_SESS_CACHE_SIZE = 42;
  SSL_CTRL_GET_SESS_CACHE_SIZE = 43;
  SSL_CTRL_SET_SESS_CACHE_MODE = 44;
  SSL_CTRL_GET_SESS_CACHE_MODE = 45;
  SSL_CTRL_GET_MAX_CERT_LIST = 50;
  SSL_CTRL_SET_MAX_CERT_LIST = 51;
  SSL_CTRL_SET_MAX_SEND_FRAGMENT = 52;
  SSL_CTRL_SET_TLSEXT_SERVERNAME_CB = 53;
  SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG = 54;
  SSL_CTRL_SET_TLSEXT_HOSTNAME = 55;
  SSL_CTRL_SET_TLSEXT_DEBUG_CB = 56;
  SSL_CTRL_SET_TLSEXT_DEBUG_ARG = 57;
  SSL_CTRL_GET_TLSEXT_TICKET_KEYS = 58;
  SSL_CTRL_SET_TLSEXT_TICKET_KEYS = 59;
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB = 63;
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG = 64;
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE = 65;
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS = 66;
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS = 67;
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS = 68;
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS = 69;
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP = 70;
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP = 71;
  SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB = 72;
  SSL_CTRL_SET_TLS_EXT_SRP_USERNAME_CB = 75;
  SSL_CTRL_SET_SRP_VERIFY_PARAM_CB = 76;
  SSL_CTRL_SET_SRP_GIVE_CLIENT_PWD_CB = 77;
  SSL_CTRL_SET_SRP_ARG = 78;
  SSL_CTRL_SET_TLS_EXT_SRP_USERNAME = 79;
  SSL_CTRL_SET_TLS_EXT_SRP_STRENGTH = 80;
  SSL_CTRL_SET_TLS_EXT_SRP_PASSWORD = 81;
  DTLS_CTRL_GET_TIMEOUT = 73;
  DTLS_CTRL_HANDLE_TIMEOUT = 74;
  SSL_CTRL_GET_RI_SUPPORT = 76;
  SSL_CTRL_CLEAR_MODE = 78;
  SSL_CTRL_SET_NOT_RESUMABLE_SESS_CB = 79;
  SSL_CTRL_GET_EXTRA_CHAIN_CERTS = 82;
  SSL_CTRL_CLEAR_EXTRA_CHAIN_CERTS = 83;
  SSL_CTRL_CHAIN = 88;
  SSL_CTRL_CHAIN_CERT = 89;
  SSL_CTRL_GET_GROUPS = 90;
  SSL_CTRL_SET_GROUPS = 91;
  SSL_CTRL_SET_GROUPS_LIST = 92;
  SSL_CTRL_GET_SHARED_GROUP = 93;
  SSL_CTRL_SET_SIGALGS = 97;
  SSL_CTRL_SET_SIGALGS_LIST = 98;
  SSL_CTRL_CERT_FLAGS = 99;
  SSL_CTRL_CLEAR_CERT_FLAGS = 100;
  SSL_CTRL_SET_CLIENT_SIGALGS = 101;
  SSL_CTRL_SET_CLIENT_SIGALGS_LIST = 102;
  SSL_CTRL_GET_CLIENT_CERT_TYPES = 103;
  SSL_CTRL_SET_CLIENT_CERT_TYPES = 104;
  SSL_CTRL_BUILD_CERT_CHAIN = 105;
  SSL_CTRL_SET_VERIFY_CERT_STORE = 106;
  SSL_CTRL_SET_CHAIN_CERT_STORE = 107;
  SSL_CTRL_GET_PEER_SIGNATURE_NID = 108;
  SSL_CTRL_GET_PEER_TMP_KEY = 109;
  SSL_CTRL_GET_RAW_CIPHERLIST = 110;
  SSL_CTRL_GET_EC_POINT_FORMATS = 111;
  SSL_CTRL_GET_CHAIN_CERTS = 115;
  SSL_CTRL_SELECT_CURRENT_CERT = 116;
  SSL_CTRL_SET_CURRENT_CERT = 117;
  SSL_CTRL_SET_DH_AUTO = 118;
  DTLS_CTRL_SET_LINK_MTU = 120;
  DTLS_CTRL_GET_LINK_MIN_MTU = 121;
  SSL_CTRL_GET_EXTMS_SUPPORT = 122;
  SSL_CTRL_SET_MIN_PROTO_VERSION = 123;
  SSL_CTRL_SET_MAX_PROTO_VERSION = 124;
  SSL_CTRL_SET_SPLIT_SEND_FRAGMENT = 125;
  SSL_CTRL_SET_MAX_PIPELINES = 126;
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE = 127;
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB = 128;
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB_ARG = 129;
  SSL_CTRL_GET_MIN_PROTO_VERSION = 130;
  SSL_CTRL_GET_MAX_PROTO_VERSION = 131;
  SSL_CTRL_GET_SIGNATURE_NID = 132;
  SSL_CTRL_GET_TMP_KEY = 133;
  SSL_CERT_SET_FIRST = 1;
  SSL_CERT_SET_NEXT = 2;
  SSL_CERT_SET_SERVER = 3;
  SSL_CTRL_GET_SERVER_TMP_KEY = SSL_CTRL_GET_PEER_TMP_KEY;
  SSL_CTRL_GET_CURVES = SSL_CTRL_GET_GROUPS;
  SSL_CTRL_SET_CURVES = SSL_CTRL_SET_GROUPS;
  SSL_CTRL_SET_CURVES_LIST = SSL_CTRL_SET_GROUPS_LIST;
  SSL_CTRL_GET_SHARED_CURVE = SSL_CTRL_GET_SHARED_GROUP;
  SSL_SERVERINFOV1 = 1;
  SSL_SERVERINFOV2 = 2;
  SSL_CLIENT_HELLO_SUCCESS = 1;
  SSL_CLIENT_HELLO_ERROR = 0;
  SSL_CLIENT_HELLO_RETRY = (-1);
  SSL_READ_EARLY_DATA_ERROR = 0;
  SSL_READ_EARLY_DATA_SUCCESS = 1;
  SSL_READ_EARLY_DATA_FINISH = 2;
  SSL_EARLY_DATA_NOT_SENT = 0;
  SSL_EARLY_DATA_REJECTED = 1;
  SSL_EARLY_DATA_ACCEPTED = 2;
  SSL_SECOP_OTHER_TYPE = $ffff0000;
  SSL_SECOP_OTHER_NONE = 0;
  SSL_SECOP_OTHER_CIPHER = (1 shl 16);
  SSL_SECOP_OTHER_CURVE = (2 shl 16);
  SSL_SECOP_OTHER_DH = (3 shl 16);
  SSL_SECOP_OTHER_PKEY = (4 shl 16);
  SSL_SECOP_OTHER_SIGALG = (5 shl 16);
  SSL_SECOP_OTHER_CERT = (6 shl 16);
  SSL_SECOP_PEER = $1000;
  SSL_SECOP_CIPHER_SUPPORTED = (1 or SSL_SECOP_OTHER_CIPHER);
  SSL_SECOP_CIPHER_SHARED = (2 or SSL_SECOP_OTHER_CIPHER);
  SSL_SECOP_CIPHER_CHECK = (3 or SSL_SECOP_OTHER_CIPHER);
  SSL_SECOP_CURVE_SUPPORTED = (4 or SSL_SECOP_OTHER_CURVE);
  SSL_SECOP_CURVE_SHARED = (5 or SSL_SECOP_OTHER_CURVE);
  SSL_SECOP_CURVE_CHECK = (6 or SSL_SECOP_OTHER_CURVE);
  SSL_SECOP_TMP_DH = (7 or SSL_SECOP_OTHER_PKEY);
  SSL_SECOP_VERSION = (9 or SSL_SECOP_OTHER_NONE);
  SSL_SECOP_TICKET = (10 or SSL_SECOP_OTHER_NONE);
  SSL_SECOP_SIGALG_SUPPORTED = (11 or SSL_SECOP_OTHER_SIGALG);
  SSL_SECOP_SIGALG_SHARED = (12 or SSL_SECOP_OTHER_SIGALG);
  SSL_SECOP_SIGALG_CHECK = (13 or SSL_SECOP_OTHER_SIGALG);
  SSL_SECOP_SIGALG_MASK = (14 or SSL_SECOP_OTHER_SIGALG);
  SSL_SECOP_COMPRESSION = (15 or SSL_SECOP_OTHER_NONE);
  SSL_SECOP_EE_KEY = (16 or SSL_SECOP_OTHER_CERT);
  SSL_SECOP_CA_KEY = (17 or SSL_SECOP_OTHER_CERT);
  SSL_SECOP_CA_MD = (18 or SSL_SECOP_OTHER_CERT);
  SSL_SECOP_PEER_EE_KEY = (SSL_SECOP_EE_KEY or SSL_SECOP_PEER);
  SSL_SECOP_PEER_CA_KEY = (SSL_SECOP_CA_KEY or SSL_SECOP_PEER);
  SSL_SECOP_PEER_CA_MD = (SSL_SECOP_CA_MD or SSL_SECOP_PEER);
  OPENSSL_INIT_NO_LOAD_SSL_STRINGS = $00100000;
  OPENSSL_INIT_LOAD_SSL_STRINGS = $00200000;
  OPENSSL_INIT_SSL_DEFAULT = (OPENSSL_INIT_LOAD_SSL_STRINGS or OPENSSL_INIT_LOAD_CRYPTO_STRINGS);
  SSL_TICKET_FATAL_ERR_MALLOC = 0;
  SSL_TICKET_FATAL_ERR_OTHER = 1;
  SSL_TICKET_NONE = 2;
  SSL_TICKET_EMPTY = 3;
  SSL_TICKET_NO_DECRYPT = 4;
  SSL_TICKET_SUCCESS = 5;
  SSL_TICKET_SUCCESS_RENEW = 6;
  SSL_TICKET_RETURN_ABORT = 0;
  SSL_TICKET_RETURN_IGNORE = 1;
  SSL_TICKET_RETURN_IGNORE_RENEW = 2;
  SSL_TICKET_RETURN_USE = 3;
  SSL_TICKET_RETURN_USE_RENEW = 4;
  SRTP_AES128_CM_SHA1_80 = $0001;
  SRTP_AES128_CM_SHA1_32 = $0002;
  SRTP_AES128_F8_SHA1_80 = $0003;
  SRTP_AES128_F8_SHA1_32 = $0004;
  SRTP_NULL_SHA1_80 = $0005;
  SRTP_NULL_SHA1_32 = $0006;
  SRTP_AEAD_AES_128_GCM = $0007;
  SRTP_AEAD_AES_256_GCM = $0008;
  OSSL_STORE_F_FILE_CTRL = 129;
  OSSL_STORE_F_FILE_FIND = 138;
  OSSL_STORE_F_FILE_GET_PASS = 118;
  OSSL_STORE_F_FILE_LOAD = 119;
  OSSL_STORE_F_FILE_LOAD_TRY_DECODE = 124;
  OSSL_STORE_F_FILE_NAME_TO_URI = 126;
  OSSL_STORE_F_FILE_OPEN = 120;
  OSSL_STORE_F_OSSL_STORE_ATTACH_PEM_BIO = 127;
  OSSL_STORE_F_OSSL_STORE_EXPECT = 130;
  OSSL_STORE_F_OSSL_STORE_FILE_ATTACH_PEM_BIO_INT = 128;
  OSSL_STORE_F_OSSL_STORE_FIND = 131;
  OSSL_STORE_F_OSSL_STORE_GET0_LOADER_INT = 100;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_CERT = 101;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_CRL = 102;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_NAME = 103;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_NAME_DESCRIPTION = 135;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_PARAMS = 104;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_PKEY = 105;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_CERT = 106;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_CRL = 107;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_EMBEDDED = 123;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_NAME = 109;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_PARAMS = 110;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_PKEY = 111;
  OSSL_STORE_F_OSSL_STORE_INFO_SET0_NAME_DESCRIPTION = 134;
  OSSL_STORE_F_OSSL_STORE_INIT_ONCE = 112;
  OSSL_STORE_F_OSSL_STORE_LOADER_NEW = 113;
  OSSL_STORE_F_OSSL_STORE_OPEN = 114;
  OSSL_STORE_F_OSSL_STORE_OPEN_INT = 115;
  OSSL_STORE_F_OSSL_STORE_REGISTER_LOADER_INT = 117;
  OSSL_STORE_F_OSSL_STORE_SEARCH_BY_ALIAS = 132;
  OSSL_STORE_F_OSSL_STORE_SEARCH_BY_ISSUER_SERIAL = 133;
  OSSL_STORE_F_OSSL_STORE_SEARCH_BY_KEY_FINGERPRINT = 136;
  OSSL_STORE_F_OSSL_STORE_SEARCH_BY_NAME = 137;
  OSSL_STORE_F_OSSL_STORE_UNREGISTER_LOADER_INT = 116;
  OSSL_STORE_F_TRY_DECODE_PARAMS = 121;
  OSSL_STORE_F_TRY_DECODE_PKCS12 = 122;
  OSSL_STORE_F_TRY_DECODE_PKCS8ENCRYPTED = 125;
  OSSL_STORE_R_AMBIGUOUS_CONTENT_TYPE = 107;
  OSSL_STORE_R_BAD_PASSWORD_READ = 115;
  OSSL_STORE_R_ERROR_VERIFYING_PKCS12_MAC = 113;
  OSSL_STORE_R_FINGERPRINT_SIZE_DOES_NOT_MATCH_DIGEST = 121;
  OSSL_STORE_R_INVALID_SCHEME = 106;
  OSSL_STORE_R_IS_NOT_A = 112;
  OSSL_STORE_R_LOADER_INCOMPLETE = 116;
  OSSL_STORE_R_LOADING_STARTED = 117;
  OSSL_STORE_R_NOT_A_CERTIFICATE = 100;
  OSSL_STORE_R_NOT_A_CRL = 101;
  OSSL_STORE_R_NOT_A_KEY = 102;
  OSSL_STORE_R_NOT_A_NAME = 103;
  OSSL_STORE_R_NOT_PARAMETERS = 104;
  OSSL_STORE_R_PASSPHRASE_CALLBACK_ERROR = 114;
  OSSL_STORE_R_NOT_A_PRIVATE_KEY  =    102;
  OSSL_STORE_R_NOT_A_PUBLIC_KEY   =                 122;
  OSSL_STORE_R_NO_LOADERS_FOUND   =                 123;
  OSSL_STORE_R_PATH_MUST_BE_ABSOLUTE = 108;
  OSSL_STORE_R_SEARCH_ONLY_SUPPORTED_FOR_DIRECTORIES = 119;
  OSSL_STORE_R_UI_PROCESS_INTERRUPTED_OR_CANCELLED = 109;
  OSSL_STORE_R_UNREGISTERED_SCHEME = 105;
  OSSL_STORE_R_UNSUPPORTED_CONTENT_TYPE = 110;
  OSSL_STORE_R_UNSUPPORTED_OPERATION = 118;
  OSSL_STORE_R_UNSUPPORTED_SEARCH_TYPE = 120;
  OSSL_STORE_R_URI_AUTHORITY_UNSUPPORTED = 111;
  OSSL_STORE_C_USE_SECMEM = 1;
  OSSL_STORE_C_CUSTOM_START = 100;
  OSSL_STORE_INFO_NAME = 1;
  OSSL_STORE_INFO_PARAMS = 2;
  OSSL_STORE_INFO_PKEY = 3;
  OSSL_STORE_INFO_CERT = 4;
  OSSL_STORE_INFO_CRL = 5;
  _OSSL_STORE_SEARCH_BY_NAME = 1;
  _OSSL_STORE_SEARCH_BY_ISSUER_SERIAL = 2;
  _OSSL_STORE_SEARCH_BY_KEY_FINGERPRINT = 3;
  _OSSL_STORE_SEARCH_BY_ALIAS = 4;
  TS_F_DEF_SERIAL_CB = 110;
  TS_F_DEF_TIME_CB = 111;
  TS_F_ESS_ADD_SIGNING_CERT = 112;
  TS_F_ESS_ADD_SIGNING_CERT_V2 = 147;
  TS_F_ESS_CERT_ID_NEW_INIT = 113;
  TS_F_ESS_CERT_ID_V2_NEW_INIT = 156;
  TS_F_ESS_SIGNING_CERT_NEW_INIT = 114;
  TS_F_ESS_SIGNING_CERT_V2_NEW_INIT = 157;
  TS_F_INT_TS_RESP_VERIFY_TOKEN = 149;
  TS_F_PKCS7_TO_TS_TST_INFO = 148;
  TS_F_TS_ACCURACY_SET_MICROS = 115;
  TS_F_TS_ACCURACY_SET_MILLIS = 116;
  TS_F_TS_ACCURACY_SET_SECONDS = 117;
  TS_F_TS_CHECK_IMPRINTS = 100;
  TS_F_TS_CHECK_NONCES = 101;
  TS_F_TS_CHECK_POLICY = 102;
  TS_F_TS_CHECK_SIGNING_CERTS = 103;
  TS_F_TS_CHECK_STATUS_INFO = 104;
  TS_F_TS_COMPUTE_IMPRINT = 145;
  TS_F_TS_CONF_INVALID = 151;
  TS_F_TS_CONF_LOAD_CERT = 153;
  TS_F_TS_CONF_LOAD_CERTS = 154;
  TS_F_TS_CONF_LOAD_KEY = 155;
  TS_F_TS_CONF_LOOKUP_FAIL = 152;
  TS_F_TS_CONF_SET_DEFAULT_ENGINE = 146;
  TS_F_TS_GET_STATUS_TEXT = 105;
  TS_F_TS_MSG_IMPRINT_SET_ALGO = 118;
  TS_F_TS_REQ_SET_MSG_IMPRINT = 119;
  TS_F_TS_REQ_SET_NONCE = 120;
  TS_F_TS_REQ_SET_POLICY_ID = 121;
  TS_F_TS_RESP_CREATE_RESPONSE = 122;
  TS_F_TS_RESP_CREATE_TST_INFO = 123;
  TS_F_TS_RESP_CTX_ADD_FAILURE_INFO = 124;
  TS_F_TS_RESP_CTX_ADD_MD = 125;
  TS_F_TS_RESP_CTX_ADD_POLICY = 126;
  TS_F_TS_RESP_CTX_NEW = 127;
  TS_F_TS_RESP_CTX_SET_ACCURACY = 128;
  TS_F_TS_RESP_CTX_SET_CERTS = 129;
  TS_F_TS_RESP_CTX_SET_DEF_POLICY = 130;
  TS_F_TS_RESP_CTX_SET_SIGNER_CERT = 131;
  TS_F_TS_RESP_CTX_SET_STATUS_INFO = 132;
  TS_F_TS_RESP_GET_POLICY = 133;
  TS_F_TS_RESP_SET_GENTIME_WITH_PRECISION = 134;
  TS_F_TS_RESP_SET_STATUS_INFO = 135;
  TS_F_TS_RESP_SET_TST_INFO = 150;
  TS_F_TS_RESP_SIGN = 136;
  TS_F_TS_RESP_VERIFY_SIGNATURE = 106;
  TS_F_TS_TST_INFO_SET_ACCURACY = 137;
  TS_F_TS_TST_INFO_SET_MSG_IMPRINT = 138;
  TS_F_TS_TST_INFO_SET_NONCE = 139;
  TS_F_TS_TST_INFO_SET_POLICY_ID = 140;
  TS_F_TS_TST_INFO_SET_SERIAL = 141;
  TS_F_TS_TST_INFO_SET_TIME = 142;
  TS_F_TS_TST_INFO_SET_TSA = 143;
  TS_F_TS_VERIFY = 108;
  TS_F_TS_VERIFY_CERT = 109;
  TS_F_TS_VERIFY_CTX_NEW = 144;
  TS_R_BAD_PKCS7_TYPE = 132;
  TS_R_BAD_TYPE = 133;
  TS_R_CANNOT_LOAD_CERT = 137;
  TS_R_CANNOT_LOAD_KEY = 138;
  TS_R_CERTIFICATE_VERIFY_ERROR = 100;
  TS_R_COULD_NOT_SET_ENGINE = 127;
  TS_R_COULD_NOT_SET_TIME = 115;
  TS_R_DETACHED_CONTENT = 134;
  TS_R_ESS_ADD_SIGNING_CERT_ERROR = 116;
  TS_R_ESS_ADD_SIGNING_CERT_V2_ERROR = 139;
  TS_R_ESS_SIGNING_CERTIFICATE_ERROR = 101;
  TS_R_INVALID_NULL_POINTER = 102;
  TS_R_INVALID_SIGNER_CERTIFICATE_PURPOSE = 117;
  TS_R_MESSAGE_IMPRINT_MISMATCH = 103;
  TS_R_NONCE_MISMATCH = 104;
  TS_R_NONCE_NOT_RETURNED = 105;
  TS_R_NO_CONTENT = 106;
  TS_R_NO_TIME_STAMP_TOKEN = 107;
  TS_R_PKCS7_ADD_SIGNATURE_ERROR = 118;
  TS_R_PKCS7_ADD_SIGNED_ATTR_ERROR = 119;
  TS_R_PKCS7_TO_TS_TST_INFO_FAILED = 129;
  TS_R_POLICY_MISMATCH = 108;
  TS_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE = 120;
  TS_R_RESPONSE_SETUP_ERROR = 121;
  TS_R_SIGNATURE_FAILURE = 109;
  TS_R_THERE_MUST_BE_ONE_SIGNER = 110;
  TS_R_TIME_SYSCALL_ERROR = 122;
  TS_R_TOKEN_NOT_PRESENT = 130;
  TS_R_TOKEN_PRESENT = 131;
  TS_R_TSA_NAME_MISMATCH = 111;
  TS_R_TSA_UNTRUSTED = 112;
  TS_R_TST_INFO_SETUP_ERROR = 123;
  TS_R_TS_DATASIGN = 124;
  TS_R_UNACCEPTABLE_POLICY = 125;
  TS_R_UNSUPPORTED_MD_ALGORITHM = 126;
  TS_R_UNSUPPORTED_VERSION = 113;
  TS_R_VAR_BAD_VALUE = 135;
  TS_R_VAR_LOOKUP_FAILURE = 136;
  TS_R_WRONG_CONTENT_TYPE = 114;
  TS_STATUS_GRANTED = 0;
  TS_STATUS_GRANTED_WITH_MODS = 1;
  TS_STATUS_REJECTION = 2;
  TS_STATUS_WAITING = 3;
  TS_STATUS_REVOCATION_WARNING = 4;
  TS_STATUS_REVOCATION_NOTIFICATION = 5;
  TS_INFO_BAD_ALG = 0;
  TS_INFO_BAD_REQUEST = 2;
  TS_INFO_BAD_DATA_FORMAT = 5;
  TS_INFO_TIME_NOT_AVAILABLE = 14;
  TS_INFO_UNACCEPTED_POLICY = 15;
  TS_INFO_UNACCEPTED_EXTENSION = 16;
  TS_INFO_ADD_INFO_NOT_AVAILABLE = 17;
  TS_INFO_SYSTEM_FAILURE = 25;
  TS_TSA_NAME = $01;
  TS_ORDERING = $02;
  TS_ESS_CERT_ID_CHAIN = $04;
  TS_MAX_CLOCK_PRECISION_DIGITS = 6;
  TS_MAX_STATUS_LENGTH = (1024*1024);
  TS_VFY_SIGNATURE = (1 shl 0);
  TS_VFY_VERSION = (1 shl 1);
  TS_VFY_POLICY = (1 shl 2);
  TS_VFY_IMPRINT = (1 shl 3);
  TS_VFY_DATA = (1 shl 4);
  TS_VFY_NONCE = (1 shl 5);
  TS_VFY_SIGNER = (1 shl 6);
  TS_VFY_TSA_NAME = (1 shl 7);
  TS_VFY_ALL_IMPRINT = (TS_VFY_SIGNATURE or TS_VFY_VERSION or TS_VFY_POLICY or TS_VFY_IMPRINT or TS_VFY_NONCE or TS_VFY_SIGNER or TS_VFY_TSA_NAME);
  TS_VFY_ALL_DATA = (TS_VFY_SIGNATURE or TS_VFY_VERSION or TS_VFY_POLICY or TS_VFY_DATA or TS_VFY_NONCE or TS_VFY_SIGNER or TS_VFY_TSA_NAME);
  DB_ERROR_OK = 0;
  DB_ERROR_MALLOC = 1;
  DB_ERROR_INDEX_CLASH = 2;
  DB_ERROR_INDEX_OUT_OF_RANGE = 3;
  DB_ERROR_NO_INDEX = 4;
  DB_ERROR_INSERT_INDEX_CLASH = 5;
  DB_ERROR_WRONG_NUM_FIELDS = 6;
  WHIRLPOOL_DIGEST_LENGTH = (512 div 8);
  WHIRLPOOL_BBLOCK = 512;
  WHIRLPOOL_COUNTER = (256 div 8);
type
  PCRYPTO_EX_DATA = ^TCRYPTO_EX_DATA;
  TCRYPTO_EX_new = procedure(parent: Pointer; ptr: Pointer; ad: PCRYPTO_EX_DATA; idx: Integer; argl: Integer; argp: Pointer);
  TCRYPTO_EX_free = procedure(parent: Pointer; ptr: Pointer; ad: PCRYPTO_EX_DATA; idx: Integer; argl: Integer; argp: Pointer);
  TCRYPTO_EX_dup = function(&to: PCRYPTO_EX_DATA;const from: PCRYPTO_EX_DATA; from_d: PPointer; idx: Integer; argl: Integer; argp: Pointer): Integer;
  ex_callback_st = record

    argl      : long;
    argp      : Pointer;
    priority  : integer;
    new_func  : TCRYPTO_EX_new;
    free_func : TCRYPTO_EX_free;
    dup_func  : TCRYPTO_EX_dup;
  end;
  TEX_CALLBACK = ex_callback_st;
  PEX_CALLBACK = ^TEX_CALLBACK;
  PPEX_CALLBACK = ^PEX_CALLBACK;

  ossl_item_st = record
    id : size_t;
    ptr : PUTF8Char;
  end;

  PCRYPTO_RWLOCK = ^Uint32;
  POSSL_LIB_CTX = ^TOSSL_LIB_CTX;
  PPOSSL_LIB_CTX = ^POSSL_LIB_CTX;
  Pstack_st_void = Pointer;
  PPstack_st_void = ^Pstack_st_void;

  crypto_ex_data_st = record
    ctx: POSSL_LIB_CTX;
    sk: Pstack_st_void;
  end;
  TCRYPTO_EX_DATA = crypto_ex_data_st;

  Pstack_st_EX_CALLBACK = Pointer;
  ex_callbacks_st = record
    meth: Pstack_st_EX_CALLBACK;
  end;
  TEX_CALLBACKS = ex_callbacks_st;
  PEX_CALLBACKS = ^TEX_CALLBACKS;

  ossl_ex_data_global_st = record
    ex_data_lock : PCRYPTO_RWLOCK;
    ex_data      : array[0..(CRYPTO_EX_INDEX__COUNT)-1] of TEX_CALLBACKS;
  end;
  TOSSL_EX_DATA_GLOBAL = ossl_ex_data_global_st;
  POSSL_EX_DATA_GLOBAL = ^TOSSL_EX_DATA_GLOBAL;

  Tossl_lib_ctx_onfree_fn = procedure(ctx: POSSL_LIB_CTX);
  Possl_lib_ctx_onfree_list_st = ^ossl_lib_ctx_onfree_list_st;
  ossl_lib_ctx_onfree_list_st = record
    fn: Tossl_lib_ctx_onfree_fn ;
    next: Possl_lib_ctx_onfree_list_st;
  end;

  ossl_lib_ctx_st = record
    lock          : PCRYPTO_RWLOCK;
    data          : TCRYPTO_EX_DATA;
    global        : TOSSL_EX_DATA_GLOBAL;
    dyn_indexes   : array[0..(OSSL_LIB_CTX_MAX_INDEXES)-1] of integer;
    index_locks   : array[0..(OSSL_LIB_CTX_MAX_INDEXES)-1] of PCRYPTO_RWLOCK;
    oncelock      : PCRYPTO_RWLOCK;
    run_once_done,
    run_once_ret  : array[0..(OSSL_LIB_CTX_MAX_RUN_ONCE)-1] of integer;
    onfreelist    : Possl_lib_ctx_onfree_list_st;
    ischild       : uint32;
  end;

  TOSSL_LIB_CTX = ossl_lib_ctx_st;

  //lh_NAMENUM_ENTRY_dummy =
  lhash_st_NAMENUM_ENTRY = record
     dummy: record
        case Integer of
          0: (d1: Pointer);
          1: (d2: Cardinal);
          2: (d3: Integer);
     end;
  end;
  Plhash_st_NAMENUM_ENTRY = ^lhash_st_NAMENUM_ENTRY;

  ossl_namemap_st = record
    stored: int;
    lock : PCRYPTO_RWLOCK;
    namenum : Plhash_st_NAMENUM_ENTRY;
    {$IFNDEF FPC}[volatile] {$ENDIF} max_number: int ;
  end;
  TOSSL_NAMEMAP = ossl_namemap_st ;
  POSSL_NAMEMAP = ^TOSSL_NAMEMAP;
  TOSSL_ITEM = ossl_item_st ;
  POSSL_ITEM = ^TOSSL_ITEM;

  ossl_lib_ctx_method = record
    priority : integer;
    new_func : function ( ctx : POSSL_LIB_CTX):Pointer;
    free_func: procedure ( p : Pointer);
  end;
  TOSSL_LIB_CTX_METHOD = ossl_lib_ctx_method;
  POSSL_LIB_CTX_METHOD = ^TOSSL_LIB_CTX_METHOD;
  // Forward declarations
  PPUTF8Char = ^PUTF8Char;
  PPPUTF8Char = ^PPUTF8Char;
  PPByte = ^PByte;
  PPPByte = ^PPByte;
  PPInteger = ^PInteger;

  PInt64 = ^Int64;
  PPint64 = ^Pint64;
  //PPointer = ^Pointer;
  PUInt64 = ^UInt64;
  PPUInt64 = ^PUInt64;
  PLongint = ^Longint;
  PUInt8 = PByte;
  PPUInt8 = ^PUInt8;
  PUInt32 = ^UInt32;
  Pint32 = ^int32;
  PPint32 = ^Pint32;
  PPuint32 = ^Puint32;

  Pstack_st = Pointer;
  PPstack_st = ^Pstack_st;
  Pstack_st_OPENSSL_STRING = Pointer;
  PPstack_st_OPENSSL_STRING = ^Pstack_st_OPENSSL_STRING;
  Pstack_st_OPENSSL_CSTRING = Pointer;
  PPstack_st_OPENSSL_CSTRING = ^Pstack_st_OPENSSL_CSTRING;
  Pstack_st_OPENSSL_BLOCK = Pointer;
  PPstack_st_OPENSSL_BLOCK = ^Pstack_st_OPENSSL_BLOCK;
  Pasn1_object_st = Pointer;
  PPasn1_object_st = ^Pasn1_object_st;
  Pasn1_pctx_st = Pointer;
  PPasn1_pctx_st = ^Pasn1_pctx_st;
  Pasn1_sctx_st = Pointer;
  PPasn1_sctx_st = ^Pasn1_sctx_st;
  Pdane_st = Pointer;
  PPdane_st = ^Pdane_st;
  Pbio_st = ^bio_st;
  PPbio_st = ^Pbio_st;
  Pbignum_st = Pointer;
  PPbignum_st = ^Pbignum_st;
  Pbignum_ctx = Pointer;
  PPbignum_ctx = ^Pbignum_ctx;
  Pbn_blinding_st = Pointer;
  PPbn_blinding_st = ^Pbn_blinding_st;
  Pbn_mont_ctx_st = Pointer;
  PPbn_mont_ctx_st = ^Pbn_mont_ctx_st;
  Pbn_recp_ctx_st = Pointer;
  PPbn_recp_ctx_st = ^Pbn_recp_ctx_st;
  Pbn_gencb_st = Pointer;
  PPbn_gencb_st = ^Pbn_gencb_st;
  Pevp_cipher_st = Pointer;
  PPevp_cipher_st = ^Pevp_cipher_st;
  Pevp_cipher_ctx_st = Pointer;
  PPevp_cipher_ctx_st = ^Pevp_cipher_ctx_st;
  Pevp_md_st = Pointer;
  PPevp_md_st = ^Pevp_md_st;
  Pevp_md_ctx_st = Pointer;
  PPevp_md_ctx_st = ^Pevp_md_ctx_st;
  Pevp_pkey_st = Pointer;
  PPevp_pkey_st = ^Pevp_pkey_st;
  Pevp_pkey_asn1_method_st = Pointer;
  PPevp_pkey_asn1_method_st = ^Pevp_pkey_asn1_method_st;
  Pevp_pkey_method_st = Pointer;
  PPevp_pkey_method_st = ^Pevp_pkey_method_st;
  Pevp_pkey_ctx_st = Pointer;
  PPevp_pkey_ctx_st = ^Pevp_pkey_ctx_st;
  Pevp_Encode_Ctx_st = Pointer;
  PPevp_Encode_Ctx_st = ^Pevp_Encode_Ctx_st;
  Phmac_ctx_st = Pointer;
  PPhmac_ctx_st = ^Phmac_ctx_st;
  Prsa_meth_st = Pointer;
  PPrsa_meth_st = ^Prsa_meth_st;
  Pec_key_method_st = Pointer;
  PPec_key_method_st = ^Pec_key_method_st;
  Prand_drbg_st = Pointer;
  PPrand_drbg_st = ^Prand_drbg_st;
  Pssl_dane_st = Pointer;
  PPssl_dane_st = ^Pssl_dane_st;
  Px509_st = Pointer;
  PPx509_st = ^Px509_st;
  PX509_crl_st = Pointer;
  PPX509_crl_st = ^PX509_crl_st;
  Px509_crl_method_st = Pointer;
  PPx509_crl_method_st = ^Px509_crl_method_st;
  Px509_revoked_st = Pointer;
  PPx509_revoked_st = ^Px509_revoked_st;
  PX509_name_st = Pointer;
  PPX509_name_st = ^PX509_name_st;
  PX509_pubkey_st = Pointer;
  PPX509_pubkey_st = ^PX509_pubkey_st;
  Px509_store_st = ^x509_store_st;
  PPx509_store_st = ^Px509_store_st;



  Px509_store_ctx_st = Pointer;
  PPx509_store_ctx_st = ^Px509_store_ctx_st;
  Px509_object_st = Pointer;
  PPx509_object_st = ^Px509_object_st;
  Px509_lookup_st = Pointer;
  PPx509_lookup_st = ^Px509_lookup_st;
  Px509_lookup_method_st = Pointer;
  PPx509_lookup_method_st = ^Px509_lookup_method_st;

  PX509_VERIFY_PARAM_st = ^X509_VERIFY_PARAM_st;
  PPX509_VERIFY_PARAM_st = ^PX509_VERIFY_PARAM_st;
  Px509_sig_info_st = Pointer;
  PPx509_sig_info_st = ^Px509_sig_info_st;
  Ppkcs8_priv_key_info_st = Pointer;
  PPpkcs8_priv_key_info_st = ^Ppkcs8_priv_key_info_st;
  Possl_init_settings_st = Pointer;
  PPossl_init_settings_st = ^Possl_init_settings_st;
  Pui_st = Pointer;
  PPui_st = ^Pui_st;
  Pui_method_st = Pointer;
  PPui_method_st = ^Pui_method_st;
  Pengine_st = ^engine_st;
  PPengine_st = ^Pengine_st;
  Pssl_st = Pointer;
  PPssl_st = ^Pssl_st;
  Pssl_ctx_st = Pointer;
  PPssl_ctx_st = ^Pssl_ctx_st;
  Pcomp_ctx_st = Pointer;
  PPcomp_ctx_st = ^Pcomp_ctx_st;
  Pcomp_method_st = Pointer;
  PPcomp_method_st = ^Pcomp_method_st;
  PX509_POLICY_NODE_st = Pointer;
  PPX509_POLICY_NODE_st = ^PX509_POLICY_NODE_st;
  PX509_POLICY_LEVEL_st = Pointer;
  PPX509_POLICY_LEVEL_st = ^PX509_POLICY_LEVEL_st;
  PX509_POLICY_TREE_st = Pointer;
  PPX509_POLICY_TREE_st = ^PX509_POLICY_TREE_st;
  PX509_POLICY_CACHE_st = Pointer;
  PPX509_POLICY_CACHE_st = ^PX509_POLICY_CACHE_st;
  Pocsp_req_ctx_st = Pointer;
  PPocsp_req_ctx_st = ^Pocsp_req_ctx_st;
  Pocsp_response_st = Pointer;
  PPocsp_response_st = ^Pocsp_response_st;
  Pocsp_responder_id_st = Pointer;
  PPocsp_responder_id_st = ^Pocsp_responder_id_st;
  Psct_st = Pointer;
  PPsct_st = ^Psct_st;
  Psct_ctx_st = Pointer;
  PPsct_ctx_st = ^Psct_ctx_st;
  Pctlog_st = Pointer;
  PPctlog_st = ^Pctlog_st;
  Pctlog_store_st = Pointer;
  PPctlog_store_st = ^Pctlog_store_st;
  Pct_policy_eval_ctx_st = Pointer;
  PPct_policy_eval_ctx_st = ^Pct_policy_eval_ctx_st;
  Possl_store_info_st = Pointer;
  PPossl_store_info_st = ^Possl_store_info_st;
  Possl_store_search_st = Pointer;
  PPossl_store_search_st = ^Possl_store_search_st;

  Pbio_addrinfo_st = Pointer;
  PPbio_addrinfo_st = ^Pbio_addrinfo_st;
  Pbio_method_st = Pointer;
  PPbio_method_st = ^Pbio_method_st;
  Pstack_st_BIO = Pointer;
  PPstack_st_BIO = ^Pstack_st_BIO;
  Phostent = Pointer;
  PPhostent = ^Phostent;
  Pstack_st_X509_ALGOR = Pointer;
  PPstack_st_X509_ALGOR = ^Pstack_st_X509_ALGOR;
  Pstack_st_ASN1_STRING_TABLE = Pointer;
  PPstack_st_ASN1_STRING_TABLE = ^Pstack_st_ASN1_STRING_TABLE;
  PASN1_VALUE_st = Pointer;
  PPASN1_VALUE_st = ^PASN1_VALUE_st;
  Pstack_st_ASN1_INTEGER = Pointer;
  PPstack_st_ASN1_INTEGER = ^Pstack_st_ASN1_INTEGER;
  Pstack_st_ASN1_GENERALSTRING = Pointer;
  PPstack_st_ASN1_GENERALSTRING = ^Pstack_st_ASN1_GENERALSTRING;
  Pstack_st_ASN1_UTF8STRING = Pointer;
  PPstack_st_ASN1_UTF8STRING = ^Pstack_st_ASN1_UTF8STRING;
  Pstack_st_ASN1_TYPE = Pointer;
  PPstack_st_ASN1_TYPE = ^Pstack_st_ASN1_TYPE;
  Pstack_st_ASN1_OBJECT = Pointer;
  PPstack_st_ASN1_OBJECT = ^Pstack_st_ASN1_OBJECT;
  Pstack_st_ASN1_VALUE = Pointer;
  PPstack_st_ASN1_VALUE = ^Pstack_st_ASN1_VALUE;
  Pasync_job_st = Pointer;
  PPasync_job_st = ^Pasync_job_st;
  Pasync_wait_ctx_st = Pointer;
  PPasync_wait_ctx_st = ^Pasync_wait_ctx_st;
  //PRSA = ^TRSA;

  Pdsa_st = Pointer;
  PPdsa_st = ^Pdsa_st;
  Pdh_st = ^dh_st;
  PPdh_st = ^Pdh_st;
  Pec_key_st = Pointer;
  PPec_key_st = ^Pec_key_st;
  PCMAC_CTX_st = Pointer;
  PPCMAC_CTX_st = ^PCMAC_CTX_st;
  Pec_method_st = Pointer;
  PPec_method_st = ^Pec_method_st;
  Pec_group_st = Pointer;
  PPec_group_st = ^Pec_group_st;
  
  Pecpk_parameters_st = Pointer;
  PPecpk_parameters_st = ^Pecpk_parameters_st;
  Pec_parameters_st = Pointer;
  PPec_parameters_st = ^Pec_parameters_st;
  PECDSA_SIG_st = Pointer;
  PPECDSA_SIG_st = ^PECDSA_SIG_st;
  PDSA_SIG_st = Pointer;
  PPDSA_SIG_st = ^PDSA_SIG_st;
  PX509_sig_st = Pointer;
  PPX509_sig_st = ^PX509_sig_st;
  PX509_name_entry_st = Pointer;
  PPX509_name_entry_st = ^PX509_name_entry_st;
  Pstack_st_X509_NAME_ENTRY = Pointer;
  Pstack_st_STACK_OF_X509_NAME_ENTRY = Pointer;
  PPstack_st_X509_NAME_ENTRY = ^Pstack_st_X509_NAME_ENTRY;
  Pstack_st_X509_NAME = Pointer;
  PPstack_st_X509_NAME = ^Pstack_st_X509_NAME;
  PX509_extension_st = Pointer;
  PPX509_extension_st = ^PX509_extension_st;
  Pstack_st_X509_EXTENSION = Pointer;
  PPstack_st_X509_EXTENSION = ^Pstack_st_X509_EXTENSION;
  Px509_attributes_st = Pointer;
  PPx509_attributes_st = ^Px509_attributes_st;
  Pstack_st_X509_ATTRIBUTE = Pointer;
  PPstack_st_X509_ATTRIBUTE = ^Pstack_st_X509_ATTRIBUTE;
  PX509_req_info_st = Pointer;
  PPX509_req_info_st = ^PX509_req_info_st;
  PX509_req_st = Pointer;
  PPX509_req_st = ^PX509_req_st;
  Px509_cert_aux_st = Pointer;
  PPx509_cert_aux_st = ^Px509_cert_aux_st;
  Px509_cinf_st = ^x509_cinf_st;
  PPx509_cinf_st = ^Px509_cinf_st;
  Pstack_st_X509 = Pointer;
  PPstack_st_X509 = ^Pstack_st_X509;
  Pstack_st_X509_TRUST = Pointer;
  PPstack_st_X509_TRUST = ^Pstack_st_X509_TRUST;
  Pstack_st_X509_REVOKED = Pointer;
  PPstack_st_X509_REVOKED = ^Pstack_st_X509_REVOKED;
  PX509_crl_info_st = Pointer;
  PPX509_crl_info_st = ^PX509_crl_info_st;
  Pstack_st_X509_CRL = Pointer;
  PPstack_st_X509_CRL = ^Pstack_st_X509_CRL;
  Pstack_st_X509_INFO = Pointer;
  PPstack_st_X509_INFO = ^Pstack_st_X509_INFO;

  Plhash_node_st = ^lhash_node_st;
  POPENSSL_LH_NODE = ^TOPENSSL_LH_NODE;
  lhash_node_st = record

    data : Pointer;
    next : POPENSSL_LH_NODE;
    hash : uint64;
  end;
  TOPENSSL_LH_NODE = lhash_node_st;



  PPlhash_node_st = ^Plhash_node_st;
  Plhash_st = ^lhash_st;
  PPlhash_st = ^Plhash_st;
  Pstack_st_X509_LOOKUP = Pointer;
  PPstack_st_X509_LOOKUP = ^Pstack_st_X509_LOOKUP;
  Pstack_st_X509_OBJECT = Pointer;
  PPstack_st_X509_OBJECT = ^Pstack_st_X509_OBJECT;
  Pstack_st_X509_VERIFY_PARAM = Pointer;
  PPstack_st_X509_VERIFY_PARAM = ^Pstack_st_X509_VERIFY_PARAM;
  Pstack_st_PKCS7_SIGNER_INFO = Pointer;
  PPstack_st_PKCS7_SIGNER_INFO = ^Pstack_st_PKCS7_SIGNER_INFO;
  Pstack_st_PKCS7_RECIP_INFO = Pointer;
  PPstack_st_PKCS7_RECIP_INFO = ^Pstack_st_PKCS7_RECIP_INFO;
  Pstack_st_PKCS7 = Pointer;
  PPstack_st_PKCS7 = ^Pstack_st_PKCS7;
  Pstack_st_CONF_VALUE = Pointer;
  PPstack_st_CONF_VALUE = ^Pstack_st_CONF_VALUE;
  Pconf_imodule_st = Pointer;
  PPconf_imodule_st = ^Pconf_imodule_st;
  Pconf_module_st = Pointer;
  PPconf_module_st = ^Pconf_module_st;
  Pstack_st_CONF_MODULE = Pointer;
  PPstack_st_CONF_MODULE = ^Pstack_st_CONF_MODULE;
  Pstack_st_CONF_IMODULE = Pointer;
  PPstack_st_CONF_IMODULE = ^Pstack_st_CONF_IMODULE;
  Pstack_st_X509V3_EXT_METHOD = Pointer;
  PPstack_st_X509V3_EXT_METHOD = ^Pstack_st_X509V3_EXT_METHOD;
  Pstack_st_GENERAL_NAME = Pointer;
  PPstack_st_GENERAL_NAME = ^Pstack_st_GENERAL_NAME;
  Pstack_st_GENERAL_NAMES = Pointer;
  PPstack_st_GENERAL_NAMES = ^Pstack_st_GENERAL_NAMES;
  Pstack_st_ACCESS_DESCRIPTION = Pointer;
  PPstack_st_ACCESS_DESCRIPTION = ^Pstack_st_ACCESS_DESCRIPTION;
  Pstack_st_DIST_POINT = Pointer;
  PPstack_st_DIST_POINT = ^Pstack_st_DIST_POINT;
  Pstack_st_SXNETID = Pointer;
  PPstack_st_SXNETID = ^Pstack_st_SXNETID;
  Pstack_st_POLICYQUALINFO = Pointer;
  PPstack_st_POLICYQUALINFO = ^Pstack_st_POLICYQUALINFO;
  Pstack_st_POLICYINFO = Pointer;
  PPstack_st_POLICYINFO = ^Pstack_st_POLICYINFO;
  Pstack_st_POLICY_MAPPING = Pointer;
  PPstack_st_POLICY_MAPPING = ^Pstack_st_POLICY_MAPPING;
  Pstack_st_GENERAL_SUBTREE = Pointer;
  PPstack_st_GENERAL_SUBTREE = ^Pstack_st_GENERAL_SUBTREE;
  Pstack_st_X509_PURPOSE = Pointer;
  PPstack_st_X509_PURPOSE = ^Pstack_st_X509_PURPOSE;
  Pstack_st_X509_POLICY_NODE = Pointer;
  PPstack_st_X509_POLICY_NODE = ^Pstack_st_X509_POLICY_NODE;
  Pstack_st_ASIdOrRange = Pointer;
  PPstack_st_ASIdOrRange = ^Pstack_st_ASIdOrRange;
  Pstack_st_IPAddressOrRange = Pointer;
  PPstack_st_IPAddressOrRange = ^Pstack_st_IPAddressOrRange;
  Pstack_st_IPAddressFamily = Pointer;
  PPstack_st_IPAddressFamily = ^Pstack_st_IPAddressFamily;
  Pstack_st_ASN1_STRING = Pointer;
  PPstack_st_ASN1_STRING = ^Pstack_st_ASN1_STRING;
  PNamingAuthority_st = Pointer;
  PPNamingAuthority_st = ^PNamingAuthority_st;
  PProfessionInfo_st = Pointer;
  PPProfessionInfo_st = ^PProfessionInfo_st;
  PAdmissions_st = Pointer;
  PPAdmissions_st = ^PAdmissions_st;
  PAdmissionSyntax_st = Pointer;
  PPAdmissionSyntax_st = ^PAdmissionSyntax_st;
  Pstack_st_ADMISSIONS = Pointer;
  PPstack_st_ADMISSIONS = ^Pstack_st_ADMISSIONS;
  Pstack_st_PROFESSION_INFO = Pointer;
  PPstack_st_PROFESSION_INFO = ^Pstack_st_PROFESSION_INFO;
  PCMS_ContentInfo_st = Pointer;
  PPCMS_ContentInfo_st = ^PCMS_ContentInfo_st;
  PCMS_SignerInfo_st = Pointer;
  PPCMS_SignerInfo_st = ^PCMS_SignerInfo_st;
  PCMS_RevocationInfoChoice_st = Pointer;
  PPCMS_RevocationInfoChoice_st = ^PCMS_RevocationInfoChoice_st;
  PCMS_RecipientInfo_st = Pointer;
  PPCMS_RecipientInfo_st = ^PCMS_RecipientInfo_st;
  PCMS_ReceiptRequest_st = Pointer;
  PPCMS_ReceiptRequest_st = ^PCMS_ReceiptRequest_st;
  PCMS_Receipt_st = Pointer;
  PPCMS_Receipt_st = ^PCMS_Receipt_st;
  PCMS_RecipientEncryptedKey_st = Pointer;
  PPCMS_RecipientEncryptedKey_st = ^PCMS_RecipientEncryptedKey_st;
  PCMS_OtherKeyAttribute_st = Pointer;
  PPCMS_OtherKeyAttribute_st = ^PCMS_OtherKeyAttribute_st;
  Pstack_st_CMS_SignerInfo = Pointer;
  PPstack_st_CMS_SignerInfo = ^Pstack_st_CMS_SignerInfo;
  Pstack_st_CMS_RecipientEncryptedKey = Pointer;
  PPstack_st_CMS_RecipientEncryptedKey = ^Pstack_st_CMS_RecipientEncryptedKey;
  Pstack_st_CMS_RecipientInfo = Pointer;
  PPstack_st_CMS_RecipientInfo = ^Pstack_st_CMS_RecipientInfo;
  Pstack_st_CMS_RevocationInfoChoice = Pointer;
  PPstack_st_CMS_RevocationInfoChoice = ^Pstack_st_CMS_RevocationInfoChoice;
  Pstack_st_SCT = Pointer;
  PPstack_st_SCT = ^Pstack_st_SCT;
  Pstack_st_CTLOG = Pointer;
  PPstack_st_CTLOG = ^Pstack_st_CTLOG;
  Pui_string_st = Pointer;
  PPui_string_st = ^Pui_string_st;
  Pstack_st_UI_STRING = Pointer;
  PPstack_st_UI_STRING = ^Pstack_st_UI_STRING;
  Pocsp_cert_id_st = Pointer;
  PPocsp_cert_id_st = ^Pocsp_cert_id_st;
  Pstack_st_OCSP_CERTID = Pointer;
  PPstack_st_OCSP_CERTID = ^Pstack_st_OCSP_CERTID;
  Pocsp_one_request_st = Pointer;
  PPocsp_one_request_st = ^Pocsp_one_request_st;
  Pstack_st_OCSP_ONEREQ = Pointer;
  PPstack_st_OCSP_ONEREQ = ^Pstack_st_OCSP_ONEREQ;
  Pocsp_req_info_st = Pointer;
  PPocsp_req_info_st = ^Pocsp_req_info_st;
  Pocsp_signature_st = Pointer;
  PPocsp_signature_st = ^Pocsp_signature_st;
  Pocsp_request_st = Pointer;
  PPocsp_request_st = ^Pocsp_request_st;
  Pocsp_resp_bytes_st = Pointer;
  PPocsp_resp_bytes_st = ^Pocsp_resp_bytes_st;
  Pstack_st_OCSP_RESPID = Pointer;
  PPstack_st_OCSP_RESPID = ^Pstack_st_OCSP_RESPID;
  Pocsp_revoked_info_st = Pointer;
  PPocsp_revoked_info_st = ^Pocsp_revoked_info_st;
  Pocsp_cert_status_st = Pointer;
  PPocsp_cert_status_st = ^Pocsp_cert_status_st;
  Pocsp_single_response_st = Pointer;
  PPocsp_single_response_st = ^Pocsp_single_response_st;
  Pstack_st_OCSP_SINGLERESP = Pointer;
  PPstack_st_OCSP_SINGLERESP = ^Pstack_st_OCSP_SINGLERESP;
  Pocsp_response_data_st = Pointer;
  PPocsp_response_data_st = ^Pocsp_response_data_st;
  Pocsp_basic_response_st = Pointer;
  PPocsp_basic_response_st = ^Pocsp_basic_response_st;
  Pocsp_crl_id_st = Pointer;
  PPocsp_crl_id_st = ^Pocsp_crl_id_st;
  Pocsp_service_locator_st = Pointer;
  PPocsp_service_locator_st = ^Pocsp_service_locator_st;
  PPKCS12_MAC_DATA_st = Pointer;
  PPPKCS12_MAC_DATA_st = ^PPKCS12_MAC_DATA_st;
  PPKCS12_st = Pointer;
  PPPKCS12_st = ^PPKCS12_st;
  PPKCS12_SAFEBAG_st = Pointer;
  PPPKCS12_SAFEBAG_st = ^PPKCS12_SAFEBAG_st;
  Pstack_st_PKCS12_SAFEBAG = Pointer;
  PPstack_st_PKCS12_SAFEBAG = ^Pstack_st_PKCS12_SAFEBAG;
  Ppkcs12_bag_st = Pointer;
  PPpkcs12_bag_st = ^Ppkcs12_bag_st;
  Pstack_st_SRP_gN_cache = Pointer;
  PPstack_st_SRP_gN_cache = ^Pstack_st_SRP_gN_cache;
  Pstack_st_SRP_user_pwd = Pointer;
  PPstack_st_SRP_user_pwd = ^Pstack_st_SRP_user_pwd;
  Pstack_st_SRP_gN = Pointer;
  PPstack_st_SRP_gN = ^Pstack_st_SRP_gN;
  Pssl_method_st = Pointer;
  PPssl_method_st = ^Pssl_method_st;
  Pssl_cipher_st = Pointer;
  PPssl_cipher_st = ^Pssl_cipher_st;
  Pssl_session_st = Pointer;
  PPssl_session_st = ^Pssl_session_st;
  Ptls_sigalgs_st = Pointer;
  PPtls_sigalgs_st = ^Ptls_sigalgs_st;
  Pssl_conf_ctx_st = Pointer;
  PPssl_conf_ctx_st = ^Pssl_conf_ctx_st;
  Pssl_comp_st = Pointer;
  PPssl_comp_st = ^Pssl_comp_st;
  Pstack_st_SRTP_PROTECTION_PROFILE = Pointer;
  PPstack_st_SRTP_PROTECTION_PROFILE = ^Pstack_st_SRTP_PROTECTION_PROFILE;
  Plhash_st_SSL_SESSION = Pointer;
  PPlhash_st_SSL_SESSION = ^Plhash_st_SSL_SESSION;
  Pstack_st_SSL_CIPHER = Pointer;
  PPstack_st_SSL_CIPHER = ^Pstack_st_SSL_CIPHER;
  Pstack_st_SSL_COMP = Pointer;
  PPstack_st_SSL_COMP = ^Pstack_st_SSL_COMP;
  Possl_store_ctx_st = Pointer;
  PPossl_store_ctx_st = ^Possl_store_ctx_st;
  Possl_store_loader_st = Pointer;
  PPossl_store_loader_st = ^Possl_store_loader_st;
  Possl_store_loader_ctx_st = Pointer;
  PPossl_store_loader_ctx_st = ^Possl_store_loader_ctx_st;
  PTS_msg_imprint_st = Pointer;
  PPTS_msg_imprint_st = ^PTS_msg_imprint_st;
  PTS_req_st = Pointer;
  PPTS_req_st = ^PTS_req_st;
  PTS_accuracy_st = Pointer;
  PPTS_accuracy_st = ^PTS_accuracy_st;
  PTS_tst_info_st = Pointer;
  PPTS_tst_info_st = ^PTS_tst_info_st;
  PTS_status_info_st = Pointer;
  PPTS_status_info_st = ^PTS_status_info_st;
  Pstack_st_ESS_CERT_ID = Pointer;
  PPstack_st_ESS_CERT_ID = ^Pstack_st_ESS_CERT_ID;
  PESS_cert_id_v2_st = Pointer;
  PPESS_cert_id_v2_st = ^PESS_cert_id_v2_st;
  PESS_signing_cert_v2_st = Pointer;
  PPESS_signing_cert_v2_st = ^PESS_signing_cert_v2_st;
  Pstack_st_ESS_CERT_ID_V2 = Pointer;
  PPstack_st_ESS_CERT_ID_V2 = ^Pstack_st_ESS_CERT_ID_V2;
  PTS_resp_st = Pointer;
  PPTS_resp_st = ^PTS_resp_st;
  Pstack_st_EVP_MD = Pointer;
  PPstack_st_EVP_MD = ^Pstack_st_EVP_MD;
  Pstack_st_OPENSSL_PSTRING = Pointer;
  PPstack_st_OPENSSL_PSTRING = ^Pstack_st_OPENSSL_PSTRING;
  Paes_key_st = ^aes_key_st;
  PENGINE = ^TENGINE;
  PPENGINE = ^PENGINE;
  PASN1_TYPE = ^TASN1_TYPE;
  PPASN1_TYPE = ^PASN1_TYPE;

  MD5state_st = record
    A: Cardinal;
    B: Cardinal;
    C: Cardinal;
    D: Cardinal;
    Nl: Cardinal;
    Nh: Cardinal;
    data: array [0..15] of Cardinal;
    num: Cardinal;
  end;
  TMD5_CTX = MD5state_st;
  PMD5_CTX = ^TMD5_CTX;
  PMD5state_st = ^MD5state_st;


  aes_key_st = record
    rd_key: array [0..59] of Cardinal;
    rounds: Integer;
  end;
  TAES_KEY = aes_key_st;
  PAES_KEY = ^TAES_KEY;
  OPENSSL_sk_compfunc = function(const p1, p2: Pointer): Integer;
  OPENSSL_sk_freefunc = procedure(p1: Pointer);
  OPENSSL_sk_copyfunc = function(p1: Pointer): Pointer;
  OPENSSL_STRING = PUTF8Char;
  POPENSSL_STRING = ^OPENSSL_STRING;
  PPOPENSSL_STRING = ^POPENSSL_STRING;
  OPENSSL_CSTRING = PUTF8Char;
  POPENSSL_CSTRING = ^OPENSSL_CSTRING;

  TPointers = TArray<Pointer>;
   stack_st = packed record
    num       : integer;
    data      : PPointer;//array of Pointer;
    sorted,
    num_alloc : integer;
    comp      : OPENSSL_sk_compfunc;
    buffer    : TArray<Pointer>;
  end;
  TOPENSSL_STACK = stack_st;
  POPENSSL_STACK = ^TOPENSSL_STACK;
  PPOPENSSL_STACK = ^POPENSSL_STACK;
  sk_OPENSSL_STRING_compfunc = function(a: PPUTF8Char; b: PPUTF8Char): Integer;
  sk_OPENSSL_STRING_freefunc = procedure(a: PUTF8Char);
  sk_OPENSSL_STRING_copyfunc = function(const a: PUTF8Char): PUTF8Char;
  sk_OPENSSL_CSTRING_compfunc = function(a: PPUTF8Char; b: PPUTF8Char): Integer;
  sk_OPENSSL_CSTRING_freefunc = procedure(a: PUTF8Char);
  sk_OPENSSL_CSTRING_copyfunc = function(a: PUTF8Char): PUTF8Char;
  OPENSSL_BLOCK = Pointer;
  sk_OPENSSL_BLOCK_compfunc = function(a: PPointer; b: PPointer): Integer;
  sk_OPENSSL_BLOCK_freefunc = procedure(a: Pointer);
  sk_OPENSSL_BLOCK_copyfunc = function(a: Pointer): Pointer;
  PBIO = ^TBIO;
  PPBIO = ^PBIO;

  PBIGNUM = ^TBIGNUM;
  PPBIGNUM = ^PBIGNUM;
  PBN_CTX = ^TBN_CTX;
  PPBN_CTX = ^PBN_CTX;
  PBN_BLINDING = ^TBN_BLINDING;
  PPBN_BLINDING = ^PBN_BLINDING;
  PBN_MONT_CTX = ^TBN_MONT_CTX;
  PPBN_MONT_CTX = ^PBN_MONT_CTX;
  PBN_RECP_CTX = ^TBN_RECP_CTX;
  PPBN_RECP_CTX = ^PBN_RECP_CTX;
 
  PEVP_CIPHER = ^TEVP_CIPHER;
  POSSL_PROVIDER = ^TOSSL_PROVIDER;
  PPOSSL_PROVIDER = ^POSSL_PROVIDER;
  POSSL_PARAM = ^TOSSL_PARAM;
  PPOSSL_PARAM = ^POSSL_PARAM;
  CRYPTO_REF_COUNT = Int;
  PCRYPTO_REF_COUNT = ^CRYPTO_REF_COUNT;
  evp_cipher_ctx_st = record
    cipher: PEVP_CIPHER;
    engine: PENGINE;
    encrypt: Integer;
    buf_len: Integer;
    oiv: array [0..15] of Byte;
    iv: array [0..15] of Byte;
    buf: array [0..31] of Byte;
    num: Integer;
    app_data: Pointer;
    key_len: Integer;
    flags: Cardinal;
    cipher_data: Pointer;
    final_used: Integer;
    block_mask: Integer;
    &final: array [0..31] of Byte;
    algctx: Pointer;
    fetched_cipher: PEVP_CIPHER;
  end;
  TEVP_CIPHER_CTX = evp_cipher_ctx_st;
  PEVP_CIPHER_CTX = ^TEVP_CIPHER_CTX;
  PPEVP_CIPHER_CTX = ^PEVP_CIPHER_CTX;

  TOSSL_FUNC_cipher_newctx_fn = function(provctx: Pointer): Pointer;
  TOSSL_FUNC_cipher_encrypt_init_fn = function(cctx: Pointer; const key: PByte; keylen: size_t; const iv: PByte; ivlen: size_t; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_cipher_decrypt_init_fn = function(cctx: Pointer; const key: PByte; keylen: size_t; const iv: PByte; ivlen: size_t; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_cipher_update_fn = function(cctx: Pointer; &out: PByte; outl: Psize_t; outsize: size_t; const &in: PByte; inl: size_t): Integer;
  TOSSL_FUNC_cipher_final_fn = function(cctx: Pointer; &out: PByte; outl: Psize_t; outsize: size_t): Integer;
  TOSSL_FUNC_cipher_cipher_fn = function(cctx: Pointer; &out: PByte; outl: Psize_t; outsize: size_t; const &in: PByte; inl: size_t): Integer;
  TOSSL_FUNC_cipher_freectx_fn = procedure(cctx: Pointer);
  TOSSL_FUNC_cipher_dupctx_fn = function(cctx: Pointer): Pointer;
  TOSSL_FUNC_cipher_get_params_fn = function(params: POSSL_PARAM): Integer;
  TOSSL_FUNC_cipher_get_ctx_params_fn = function(cctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_cipher_set_ctx_params_fn = function(cctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_cipher_gettable_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_cipher_settable_ctx_params_fn = function(cctx: Pointer; provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_cipher_gettable_ctx_params_fn = function(cctx: Pointer; provctx: Pointer): POSSL_PARAM;

  Tinit_func = function(ctx: PEVP_CIPHER_CTX; key, iv: PByte; enc: Integer): Integer;
  Tdo_cipher_func = function(ctx: PEVP_CIPHER_CTX; _out: PByte; {const} _in: PByte; inl: size_t): Integer;
  Tevp_cipher_cleanup_func = function(p1: PEVP_CIPHER_CTX): Integer;
  Tset_asn1_parameters_func = function(p1: PEVP_CIPHER_CTX; p2: PASN1_TYPE): Integer;
  Tget_asn1_parameters_func = function(p1: PEVP_CIPHER_CTX; p2: PASN1_TYPE): Integer;
  Tctrl_func = function(p1: PEVP_CIPHER_CTX; &type: Integer; arg: Integer; ptr: Pointer): Integer;

  evp_cipher_st = record
    nid: Integer;
    block_size: Integer;
    key_len: Integer;
    iv_len: Integer;
    flags: Cardinal;
    origin: Integer;
    init: function(ctx: PEVP_CIPHER_CTX; key, iv: PByte; enc: Integer): Integer;
    do_cipher: function(ctx: PEVP_CIPHER_CTX; _out: PByte; {const} _in: PByte; inl: size_t): Integer;
    cleanup: function(p1: PEVP_CIPHER_CTX): Integer;
    ctx_size: Integer;
    set_asn1_parameters: function(p1: PEVP_CIPHER_CTX; p2: PASN1_TYPE): Integer;
    get_asn1_parameters: function(p1: PEVP_CIPHER_CTX; p2: PASN1_TYPE): Integer;
    ctrl: function(p1: PEVP_CIPHER_CTX; &type: Integer; arg: Integer; ptr: Pointer): Integer;
    app_data: Pointer;
    name_id: Integer;
    type_name: PUTF8Char;
    description: PUTF8Char;
    prov: POSSL_PROVIDER;
    refcnt: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
    newctx: TOSSL_FUNC_cipher_newctx_fn;
    einit: TOSSL_FUNC_cipher_encrypt_init_fn;
    dinit: TOSSL_FUNC_cipher_decrypt_init_fn;
    cupdate: TOSSL_FUNC_cipher_update_fn;
    cfinal: TOSSL_FUNC_cipher_final_fn;
    ccipher: TOSSL_FUNC_cipher_cipher_fn;
    freectx: TOSSL_FUNC_cipher_freectx_fn;
    dupctx: TOSSL_FUNC_cipher_dupctx_fn;
    get_params: TOSSL_FUNC_cipher_get_params_fn;
    get_ctx_params: TOSSL_FUNC_cipher_get_ctx_params_fn;
    set_ctx_params: TOSSL_FUNC_cipher_set_ctx_params_fn;
    gettable_params: TOSSL_FUNC_cipher_gettable_params_fn;
    gettable_ctx_params: TOSSL_FUNC_cipher_gettable_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_cipher_settable_ctx_params_fn;
  end;
  TEVP_CIPHER = evp_cipher_st;

  PBN_GENCB = ^TBN_GENCB;
  PPEVP_CIPHER = ^PEVP_CIPHER;
  PRSA = ^TRSA;
  PPRSA = ^PRSA;

  rsa_meth_st = record
    name: PUTF8Char;
    rsa_pub_enc: function(flen: Integer; const from: PByte; &to: PByte; rsa: PRSA; padding: Integer): Integer;
    rsa_pub_dec: function(flen: Integer; const from: PByte; &to: PByte; rsa: PRSA; padding: Integer): Integer;
    rsa_priv_enc: function(flen: Integer; const from: PByte; &to: PByte; rsa: PRSA; padding: Integer): Integer;
    rsa_priv_dec: function(flen: Integer; const from: PByte; &to: PByte; rsa: PRSA; padding: Integer): Integer;
    rsa_mod_exp: function(r0: PBIGNUM; const I: PBIGNUM; rsa: PRSA; ctx: PBN_CTX): Integer;
    bn_mod_exp: function(r: PBIGNUM; const a: PBIGNUM; const p: PBIGNUM; const m: PBIGNUM; ctx: PBN_CTX; m_ctx: PBN_MONT_CTX): Integer;
    init: function(rsa: PRSA): Integer;
    finish: function(rsa: PRSA): Integer;
    flags: Integer;
    app_data: PUTF8Char;
    rsa_sign: function(&type: Integer; const m: PByte; m_length: uint32; sigret: PByte; siglen: Puint32; const rsa: PRSA): Integer;
    rsa_verify: function(dtype: Integer; const m: PByte; m_length: Cardinal; const sigbuf: PByte; siglen: Cardinal; const rsa: PRSA): Integer;
    rsa_keygen: function(rsa: PRSA; bits: Integer; e: PBIGNUM; cb: PBN_GENCB): Integer;
    rsa_multi_prime_keygen: function(rsa: PRSA; bits: Integer; primes: Integer; e: PBIGNUM; cb: PBN_GENCB): Integer;
  end;
  TRSA_METHOD = rsa_meth_st;
  PRSA_METHOD = ^TRSA_METHOD;

  PDSA = ^TDSA;
  PPDSA = ^PDSA;
  DSA_SIG_st = record
    r: PBIGNUM;
    s: PBIGNUM;
  end;
  TDSA_SIG = DSA_SIG_st;
  PDSA_SIG = ^TDSA_SIG;
  PPDSA_SIG = ^PDSA_SIG;

  dsa_method = record
    name: PUTF8Char;
    dsa_do_sign: function(const dgst: PByte; dlen: Integer; dsa: PDSA): PDSA_SIG;
    dsa_sign_setup: function(dsa: PDSA; ctx_in: PBN_CTX; kinvp: PPBIGNUM; rp: PPBIGNUM): Integer;
    dsa_do_verify: function(const dgst: PByte; dgst_len: Integer; sig: PDSA_SIG; dsa: PDSA): Integer;
    dsa_mod_exp: function(dsa: PDSA; rr: PBIGNUM; const a1: PBIGNUM; const p1: PBIGNUM; const a2: PBIGNUM; const p2: PBIGNUM; const m: PBIGNUM; ctx: PBN_CTX; in_mont: PBN_MONT_CTX): Integer;
    bn_mod_exp: function(dsa: PDSA; r: PBIGNUM; const a: PBIGNUM; const p: PBIGNUM; const m: PBIGNUM; ctx: PBN_CTX; m_ctx: PBN_MONT_CTX): Integer;
    init: function(dsa: PDSA): Integer;
    finish: function(dsa: PDSA): Integer;
    flags: Integer;
    app_data: Pointer;
    dsa_paramgen: function(dsa: PDSA; bits: Integer; const seed: PByte; seed_len: Integer; counter_ret: PInteger; h_ret: PCardinal; cb: PBN_GENCB): Integer;
    dsa_keygen: function(dsa: PDSA): Integer;
  end;
  TDSA_METHOD = dsa_method ;


  ffc_params_st = record
    p: PBIGNUM;
    q: PBIGNUM;
    g: PBIGNUM;
    j: PBIGNUM;
    seed: PByte;
    seedlen: size_t;
    pcounter: Integer;
    nid: Integer;
    gindex: Integer;
    h: Integer;
    flags: size_t;
    mdname: PUTF8Char;
    mdprops: PUTF8Char;
  end;
  TFFC_PARAMS = ffc_params_st;
  PFFC_PARAMS = ^TFFC_PARAMS;
  PDSA_METHOD = ^TDSA_METHOD;

  dsa_st = record
    pad: Integer;
    version: Int32;
    params: TFFC_PARAMS;
    pub_key: PBIGNUM;
    priv_key: PBIGNUM;
    flags: Integer;
    method_mont_p: PBN_MONT_CTX;
    references: CRYPTO_REF_COUNT;
    ex_data: TCRYPTO_EX_DATA;
    meth: PDSA_METHOD;
    engine: PENGINE;
    lock: PCRYPTO_RWLOCK;
    libctx: POSSL_LIB_CTX;
    dirty_cnt: size_t;
  end;
  TDSA = dsa_st;

  PEC_METHOD = ^TEC_METHOD;
  ec_point_st = record
    meth: PEC_METHOD;
    curve_name: Integer;
    X: PBIGNUM;
    Y: PBIGNUM;
    Z: PBIGNUM;
    Z_is_one: Integer;
  end;
  TEC_POINT = ec_point_st;
  PEC_POINT = ^TEC_POINT;
  PPEC_POINT = ^PEC_POINT;
  PPPEC_POINT = ^PPEC_POINT;
  PDH_METHOD = ^TDH_METHOD;
  PEC_GROUP = ^TEC_GROUP;

  (** Enum for the point conversion form as defined in X9.62 (ECDSA)
   *  for the encoding of a elliptic curve point (x,y) *)
  point_conversion_form_t = (
    (** the point is encoded as z||x, where the octet z specifies
     *  which solution of the quadratic equation y is  *)
    POINT_CONVERSION_COMPRESSED = 2,
    (** the point is encoded as z||x||y, where z is the octet 0x04  *)
    POINT_CONVERSION_UNCOMPRESSED = 4,
    (** the point is encoded as z||x||y, where the octet z specifies
     *  which solution of the quadratic equation y is  *)
    POINT_CONVERSION_HYBRID = 6);
  Ppoint_conversion_form_t = ^point_conversion_form_t;
  PNISTP224_PRE_COMP = Pointer;
  PPNISTP224_PRE_COMP = ^PNISTP224_PRE_COMP;
  PNISTP256_PRE_COMP = Pointer;
  PPNISTP256_PRE_COMP = ^PNISTP256_PRE_COMP;
  PNISTP521_PRE_COMP = Pointer;
  PPNISTP521_PRE_COMP = ^PNISTP521_PRE_COMP;
  PNISTZ256_PRE_COMP = Pointer;
  PPNISTZ256_PRE_COMP = ^PNISTZ256_PRE_COMP;
  PEC_PRE_COMP = ^TEC_PRE_COMP;
  PPEC_PRE_COMP = ^PEC_PRE_COMP;

  Tpre_comp_type =(
        PCT_none,
        PCT_nistp224, PCT_nistp256, PCT_nistp521, PCT_nistz256,
        PCT_ec
    ) ;
  Tpre_comp = record
    case integer of
      0: (nistp224 : PNISTP224_PRE_COMP);
      1: (nistp256 : PNISTP256_PRE_COMP);
      2: (nistp521 : PNISTP521_PRE_COMP);
      3: (nistz256 : PNISTZ256_PRE_COMP);
      4: (ec       : PEC_PRE_COMP);
    //end;
  end;

  TEC_GROUP{ec_group_st} = record
    meth: PEC_METHOD;
    generator: PEC_POINT;
    order: PBIGNUM;
    cofactor: PBIGNUM;
    curve_name: Integer;
    asn1_flag: Integer;
    decoded_from_explicit_params: Integer;
    asn1_form: point_conversion_form_t;
    seed: PByte;
    seed_len: size_t;
    field: PBIGNUM;
    poly: array [0..5] of Integer;
    a: PBIGNUM;
    b: PBIGNUM;
    a_is_minus3: Integer;
    field_data1: Pointer;
    field_data2: Pointer;
    field_mod_func: function(p1: PBIGNUM; p2, p3: PBIGNUM; p4: PBN_CTX): Integer;
    mont_data: PBN_MONT_CTX;
    pre_comp_type: Tpre_comp_type;
    pre_comp: Tpre_comp;
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
  end;

  PPEC_GROUP = ^PEC_GROUP;
  PEC_KEY = ^TEC_KEY;

  PECDSA_SIG = ^TECDSA_SIG;
  PPECDSA_SIG = ^PECDSA_SIG;

  ec_key_method_st = record
    name: PUTF8Char;
    flags: Int32;
    init: function(key: PEC_KEY): Integer;
    finish: procedure(key: PEC_KEY);
    copy: function(dest: PEC_KEY; const src: PEC_KEY): Integer;
    set_group: function(key: PEC_KEY; const grp: PEC_GROUP): Integer;
    set_private: function(key: PEC_KEY; const priv_key: PBIGNUM): Integer;
    set_public: function(key: PEC_KEY; const pub_key: PEC_POINT): Integer;
    keygen: function(key: PEC_KEY): Integer;
    compute_key: function(pout: PPByte; poutlen: Psize_t; const pub_key: PEC_POINT; const ecdh: PEC_KEY): Integer;
    sign: function(&type: Integer; const dgst: PByte; dlen: Integer; sig: PByte; siglen: Puint32; const kinv: PBIGNUM; const r: PBIGNUM; eckey: PEC_KEY): Integer;
    sign_setup: function(eckey: PEC_KEY; ctx_in: PBN_CTX; kinvp: PPBIGNUM; rp: PPBIGNUM): Integer;
    sign_sig: function(const dgst: PByte; dgst_len: Integer; const in_kinv: PBIGNUM; const in_r: PBIGNUM; eckey: PEC_KEY): PECDSA_SIG;
    verify: function(&type: Integer; const dgst: PByte; dgst_len: Integer; const sigbuf: PByte; sig_len: Integer; eckey: PEC_KEY): Integer;
    verify_sig: function(const dgst: PByte; dgst_len: Integer; const sig: PECDSA_SIG; eckey: PEC_KEY): Integer;
  end;
  TEC_KEY_METHOD = ec_key_method_st;

  PPEC_KEY_METHOD = ^PEC_KEY_METHOD;
  PEC_KEY_METHOD = ^TEC_KEY_METHOD;

  rand_meth_st = record
    seed: function(const buf: Pointer; num: Integer): Integer;
    bytes: function(buf: PByte; num: Integer): Integer;
    cleanup: procedure();
    add: function(const buf: Pointer; num: Integer; randomness: Double): Integer;
    pseudorand: function(buf: PByte; num: Integer): Integer;
    status: function(): Integer;
  end;
  TRAND_METHOD = rand_meth_st;
  PRAND_METHOD = ^TRAND_METHOD;
  PEVP_KEYMGMT = ^evp_keymgmt_st ;
  PPEVP_KEYMGMT = ^PEVP_KEYMGMT;

  Tkeymgmt = record
    genctx: Pointer;
  end;

  TOSSL_FUNC_keyexch_newctx_fn = function(provctx: Pointer): Pointer;

  TOSSL_FUNC_keyexch_init_fn = function(ctx: Pointer; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_keyexch_derive_fn = function(ctx: Pointer; secret: PByte; secretlen: Psize_t; outlen: size_t): Integer;

  TOSSL_FUNC_keyexch_set_peer_fn = function(ctx: Pointer; provkey: Pointer): Integer;

  TOSSL_FUNC_keyexch_freectx_fn = procedure(ctx: Pointer);

  TOSSL_FUNC_keyexch_dupctx_fn = function(ctx: Pointer): Pointer;
  TOSSL_FUNC_keyexch_set_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_keyexch_settable_ctx_params_fn = function(ctx: Pointer; provctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_keyexch_get_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_keyexch_gettable_ctx_params_fn = function(ctx: Pointer; provctx: Pointer): POSSL_PARAM;

  evp_keyexch_st = record
    name_id: Integer;
    type_name: PUTF8Char;
    description: PUTF8Char;
    prov: POSSL_PROVIDER;
    refcnt: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
    newctx: TOSSL_FUNC_keyexch_newctx_fn;
    init: TOSSL_FUNC_keyexch_init_fn;
    set_peer: TOSSL_FUNC_keyexch_set_peer_fn;
    derive: TOSSL_FUNC_keyexch_derive_fn;
    freectx: TOSSL_FUNC_keyexch_freectx_fn;
    dupctx: TOSSL_FUNC_keyexch_dupctx_fn;
    set_ctx_params: TOSSL_FUNC_keyexch_set_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_keyexch_settable_ctx_params_fn;
    get_ctx_params: TOSSL_FUNC_keyexch_get_ctx_params_fn;
    gettable_ctx_params: TOSSL_FUNC_keyexch_gettable_ctx_params_fn;
  end;
  TEVP_KEYEXCH = evp_keyexch_st;
  PEVP_KEYEXCH = ^TEVP_KEYEXCH;

  TOSSL_FUNC_signature_newctx_fn = function(provctx: Pointer; const propq: PUTF8Char): Pointer;

  TOSSL_FUNC_signature_sign_init_fn = function(ctx: Pointer; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_signature_sign_fn = function(ctx: Pointer; sig: PByte; siglen: Psize_t; sigsize: size_t; const tbs: PByte; tbslen: size_t): Integer;

  TOSSL_FUNC_signature_verify_init_fn = function(ctx: Pointer; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_signature_verify_fn = function(ctx: Pointer; const sig: PByte; siglen: size_t; const tbs: PByte; tbslen: size_t): Integer;

  TOSSL_FUNC_signature_verify_recover_init_fn = function(ctx: Pointer; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_signature_verify_recover_fn = function(ctx: Pointer; rout: PByte; routlen: Psize_t; routsize: size_t; const sig: PByte; siglen: size_t): Integer;

  TOSSL_FUNC_signature_digest_sign_init_fn = function(ctx: Pointer; const mdname: PUTF8Char; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_signature_digest_sign_update_fn = function(ctx: Pointer; const data: PByte; datalen: size_t): Integer;

  TOSSL_FUNC_signature_digest_sign_final_fn = function(ctx: Pointer; sig: PByte; siglen: Psize_t; sigsize: size_t): Integer;

  TOSSL_FUNC_signature_digest_sign_fn = function(ctx: Pointer; sigret: PByte; siglen: Psize_t; sigsize: size_t; const tbs: PByte; tbslen: size_t): Integer;

  TOSSL_FUNC_signature_digest_verify_init_fn = function(ctx: Pointer; const mdname: PUTF8Char; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_signature_digest_verify_update_fn = function(ctx: Pointer; const data: PByte; datalen: size_t): Integer;

  TOSSL_FUNC_signature_digest_verify_final_fn = function(ctx: Pointer; const sig: PByte; siglen: size_t): Integer;

  TOSSL_FUNC_signature_digest_verify_fn = function(ctx: Pointer; const sig: PByte; siglen: size_t; const tbs: PByte; tbslen: size_t): Integer;

  TOSSL_FUNC_signature_freectx_fn = procedure(ctx: Pointer);

  TOSSL_FUNC_signature_dupctx_fn = function(ctx: Pointer): Pointer;

  TOSSL_FUNC_signature_get_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_signature_gettable_ctx_params_fn = function(ctx: Pointer; provctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_signature_set_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_signature_settable_ctx_params_fn = function(ctx: Pointer; provctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_signature_get_ctx_md_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_signature_gettable_ctx_md_params_fn = function(ctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_signature_set_ctx_md_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_signature_settable_ctx_md_params_fn = function(ctx: Pointer): POSSL_PARAM;
  evp_signature_st = record
    name_id: Integer;
    type_name: PUTF8Char;
    description: PUTF8Char;
    prov: POSSL_PROVIDER;
    refcnt: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
    newctx: TOSSL_FUNC_signature_newctx_fn;
    sign_init: TOSSL_FUNC_signature_sign_init_fn;
    sign: TOSSL_FUNC_signature_sign_fn;
    verify_init: TOSSL_FUNC_signature_verify_init_fn;
    verify: TOSSL_FUNC_signature_verify_fn;
    verify_recover_init: TOSSL_FUNC_signature_verify_recover_init_fn;
    verify_recover: TOSSL_FUNC_signature_verify_recover_fn;
    digest_sign_init: TOSSL_FUNC_signature_digest_sign_init_fn;
    digest_sign_update: TOSSL_FUNC_signature_digest_sign_update_fn;
    digest_sign_final: TOSSL_FUNC_signature_digest_sign_final_fn;
    digest_sign: TOSSL_FUNC_signature_digest_sign_fn;
    digest_verify_init: TOSSL_FUNC_signature_digest_verify_init_fn;
    digest_verify_update: TOSSL_FUNC_signature_digest_verify_update_fn;
    digest_verify_final: TOSSL_FUNC_signature_digest_verify_final_fn;
    digest_verify: TOSSL_FUNC_signature_digest_verify_fn;
    freectx: TOSSL_FUNC_signature_freectx_fn;
    dupctx: TOSSL_FUNC_signature_dupctx_fn;
    get_ctx_params: TOSSL_FUNC_signature_get_ctx_params_fn;
    gettable_ctx_params: TOSSL_FUNC_signature_gettable_ctx_params_fn;
    set_ctx_params: TOSSL_FUNC_signature_set_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_signature_settable_ctx_params_fn;
    get_ctx_md_params: TOSSL_FUNC_signature_get_ctx_md_params_fn;
    gettable_ctx_md_params: TOSSL_FUNC_signature_gettable_ctx_md_params_fn;
    set_ctx_md_params: TOSSL_FUNC_signature_set_ctx_md_params_fn;
    settable_ctx_md_params: TOSSL_FUNC_signature_settable_ctx_md_params_fn;
  end;
  TEVP_SIGNATURE = evp_signature_st;
  PEVP_SIGNATURE = ^TEVP_SIGNATURE;

  TOSSL_FUNC_asym_cipher_newctx_fn = function(provctx: Pointer): Pointer;

  TOSSL_FUNC_asym_cipher_encrypt_init_fn = function(ctx: Pointer; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_asym_cipher_encrypt_fn = function(ctx: Pointer; &out: PByte; outlen: Psize_t; outsize: size_t; const &in: PByte; inlen: size_t): Integer;

  TOSSL_FUNC_asym_cipher_decrypt_init_fn = function(ctx: Pointer; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_asym_cipher_decrypt_fn = function(ctx: Pointer; &out: PByte; outlen: Psize_t; outsize: size_t; const &in: PByte; inlen: size_t): Integer;

  TOSSL_FUNC_asym_cipher_freectx_fn = procedure(ctx: Pointer);

  TOSSL_FUNC_asym_cipher_dupctx_fn = function(ctx: Pointer): Pointer;

  TOSSL_FUNC_asym_cipher_get_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_asym_cipher_gettable_ctx_params_fn = function(ctx: Pointer; provctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_asym_cipher_set_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_asym_cipher_settable_ctx_params_fn = function(ctx: Pointer; provctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_kem_newctx_fn = function(provctx: Pointer): Pointer;

  TOSSL_FUNC_kem_encapsulate_init_fn = function(ctx: Pointer; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_kem_encapsulate_fn = function(ctx: Pointer; &out: PByte; outlen: Psize_t; secret: PByte; secretlen: Psize_t): Integer;

  TOSSL_FUNC_kem_decapsulate_init_fn = function(ctx: Pointer; provkey: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_kem_decapsulate_fn = function(ctx: Pointer; &out: PByte; outlen: Psize_t; const &in: PByte; inlen: size_t): Integer;

  TOSSL_FUNC_kem_freectx_fn = procedure(ctx: Pointer);

  TOSSL_FUNC_kem_dupctx_fn = function(ctx: Pointer): Pointer;

  TOSSL_FUNC_kem_get_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_kem_gettable_ctx_params_fn = function(ctx: Pointer; provctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_kem_set_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_kem_settable_ctx_params_fn = function(ctx: Pointer; provctx: Pointer): POSSL_PARAM;

  evp_asym_cipher_st = record
    name_id: Integer;
    type_name: PUTF8Char;
    description: PUTF8Char;
    prov: POSSL_PROVIDER;
    refcnt: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
    newctx: TOSSL_FUNC_asym_cipher_newctx_fn;
    encrypt_init: TOSSL_FUNC_asym_cipher_encrypt_init_fn;
    encrypt: TOSSL_FUNC_asym_cipher_encrypt_fn;
    decrypt_init: TOSSL_FUNC_asym_cipher_decrypt_init_fn;
    decrypt: TOSSL_FUNC_asym_cipher_decrypt_fn;
    freectx: TOSSL_FUNC_asym_cipher_freectx_fn;
    dupctx: TOSSL_FUNC_asym_cipher_dupctx_fn;
    get_ctx_params: TOSSL_FUNC_asym_cipher_get_ctx_params_fn;
    gettable_ctx_params: TOSSL_FUNC_asym_cipher_gettable_ctx_params_fn;
    set_ctx_params: TOSSL_FUNC_asym_cipher_set_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_asym_cipher_settable_ctx_params_fn;
  end;
  TEVP_ASYM_CIPHER = evp_asym_cipher_st;
  PEVP_ASYM_CIPHER = ^TEVP_ASYM_CIPHER;

  evp_kem_st = record
    name_id: Integer;
    type_name: PUTF8Char;
    description: PUTF8Char;
    prov: POSSL_PROVIDER;
    refcnt: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
    newctx: TOSSL_FUNC_kem_newctx_fn;
    encapsulate_init: TOSSL_FUNC_kem_encapsulate_init_fn;
    encapsulate: TOSSL_FUNC_kem_encapsulate_fn;
    decapsulate_init: TOSSL_FUNC_kem_decapsulate_init_fn;
    decapsulate: TOSSL_FUNC_kem_decapsulate_fn;
    freectx: TOSSL_FUNC_kem_freectx_fn;
    dupctx: TOSSL_FUNC_kem_dupctx_fn;
    get_ctx_params: TOSSL_FUNC_kem_get_ctx_params_fn;
    gettable_ctx_params: TOSSL_FUNC_kem_gettable_ctx_params_fn;
    set_ctx_params: TOSSL_FUNC_kem_set_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_kem_settable_ctx_params_fn;
  end;
  TEVP_KEM = evp_kem_st;
  PEVP_KEM = ^TEVP_KEM ;

  Tkex = record
    exchange: PEVP_KEYEXCH;
    algctx: Pointer;
  end;


  Tsig = record
    signature: PEVP_SIGNATURE;
    algctx: Pointer;
  end;

  Tciph = record
    cipher: PEVP_ASYM_CIPHER;
    algctx: Pointer;
  end;


  Tencap = record
    kem: PEVP_KEM;
    algctx: Pointer;
  end;


  Top = record
    case Integer of
      0: (keymgmt: Tkeymgmt);
      1: (kex: Tkex);
      2: (sig: Tsig);
      3: (ciph: Tciph);
      4: (encap: Tencap);
  end;

  Tcached_parameters = record
    dist_id_name: PUTF8Char;
    dist_id: Pointer;
    dist_id_len: size_t;
    dist_id_set: Cardinal;
  end;

  PEVP_PKEY_CTX = ^TEVP_PKEY_CTX;
  PPEVP_PKEY_CTX = ^PEVP_PKEY_CTX;
  PEVP_PKEY_METHOD = ^TEVP_PKEY_METHOD;
  PPEVP_PKEY_METHOD = ^PEVP_PKEY_METHOD;
  PEVP_PKEY = ^TEVP_PKEY;
  PPEVP_PKEY = ^PEVP_PKEY;
  TEVP_PKEY_gen_cb = function(ctx: PEVP_PKEY_CTX): Integer;

  evp_pkey_ctx_st = record
    operation: Integer;
    libctx: POSSL_LIB_CTX;
    propquery: PUTF8Char;
    keytype: PUTF8Char;
    keymgmt: PEVP_KEYMGMT;
    op: Top;
    cached_parameters: Tcached_parameters;
    app_data: Pointer;
    pkey_gencb: TEVP_PKEY_gen_cb;
    keygen_info: PInteger;
    keygen_info_count: Integer;
    legacy_keytype: Integer;
    pmeth: PEVP_PKEY_METHOD;
    engine: PENGINE;
    pkey: PEVP_PKEY;
    peerkey: PEVP_PKEY;
    data: Pointer;
    flag_call_digest_custom: Cardinal;
    rsa_pubexp: PBIGNUM;
  end;
  TEVP_PKEY_CTX = evp_pkey_ctx_st;
  PEVP_MD_CTX = ^TEVP_MD_CTX;

  evp_pkey_method_st = record
    pkey_id: Integer;
    flags: Integer;
    init: function(ctx: PEVP_PKEY_CTX): Integer;
    copy: function(dst: PEVP_PKEY_CTX; const src: PEVP_PKEY_CTX): Integer;
    cleanup: procedure(ctx: PEVP_PKEY_CTX);
    paramgen_init: function(ctx: PEVP_PKEY_CTX): Integer;
    paramgen: function(ctx: PEVP_PKEY_CTX; pkey: PEVP_PKEY): Integer;
    keygen_init: function(ctx: PEVP_PKEY_CTX): Integer;
    keygen: function(ctx: PEVP_PKEY_CTX; pkey: PEVP_PKEY): Integer;
    sign_init: function(ctx: PEVP_PKEY_CTX): Integer;
    sign: function(ctx: PEVP_PKEY_CTX; sig: PByte; siglen: Psize_t; const tbs: PByte; tbslen: size_t): Integer;
    verify_init: function(ctx: PEVP_PKEY_CTX): Integer;
    verify: function(ctx: PEVP_PKEY_CTX; const sig: PByte; siglen: size_t; const tbs: PByte; tbslen: size_t): Integer;
    verify_recover_init: function(ctx: PEVP_PKEY_CTX): Integer;
    verify_recover: function(ctx: PEVP_PKEY_CTX; rout: PByte; routlen: Psize_t; const sig: PByte; siglen: size_t): Integer;
    signctx_init: function(ctx: PEVP_PKEY_CTX; mctx: PEVP_MD_CTX): Integer;
    signctx: function(ctx: PEVP_PKEY_CTX; sig: PByte; siglen: Psize_t; mctx: PEVP_MD_CTX): Integer;
    verifyctx_init: function(ctx: PEVP_PKEY_CTX; mctx: PEVP_MD_CTX): Integer;
    verifyctx: function(ctx: PEVP_PKEY_CTX; const sig: PByte; siglen: Integer; mctx: PEVP_MD_CTX): Integer;
    encrypt_init: function(ctx: PEVP_PKEY_CTX): Integer;
    encrypt: function(ctx: PEVP_PKEY_CTX; &out: PByte; outlen: Psize_t; const &in: PByte; inlen: size_t): Integer;
    decrypt_init: function(ctx: PEVP_PKEY_CTX): Integer;
    decrypt: function(ctx: PEVP_PKEY_CTX; &out: PByte; outlen: Psize_t; const &in: PByte; inlen: size_t): Integer;
    derive_init: function(ctx: PEVP_PKEY_CTX): Integer;
    derive: function(ctx: PEVP_PKEY_CTX; key: PByte; keylen: Psize_t): Integer;
    ctrl: function(ctx: PEVP_PKEY_CTX; &type: Integer; p1: Integer; p2: Pointer): Integer;
    ctrl_str: function(ctx: PEVP_PKEY_CTX; const &type: PUTF8Char; const value: PUTF8Char): Integer;
    digestsign: function(ctx: PEVP_MD_CTX; sig: PByte; siglen: Psize_t; const tbs: PByte; tbslen: size_t): Integer;
    digestverify: function(ctx: PEVP_MD_CTX; const sig: PByte; siglen: size_t; const tbs: PByte; tbslen: size_t): Integer;
    check: function(pkey: PEVP_PKEY): Integer;
    public_check: function(pkey: PEVP_PKEY): Integer;
    param_check: function(pkey: PEVP_PKEY): Integer;
    digest_custom: function(ctx: PEVP_PKEY_CTX; mctx: PEVP_MD_CTX): Integer;
  end;
  TEVP_PKEY_METHOD = evp_pkey_method_st;

  PASN1_INTEGER = ^asn1_string_st;
  //PASN1_GENERALIZEDTIME = ^asn1_string_st;
  PX509_ALGOR = ^TX509_ALGOR;
  PASN1_BIT_STRING = PASN1_INTEGER;//^asn1_string_st;
  PPASN1_BIT_STRING = ^PASN1_BIT_STRING;
  X509_pubkey_st = record
    algor             : PX509_ALGOR;
    public_key        : PASN1_BIT_STRING;
    pkey              : PEVP_PKEY;
    libctx            : POSSL_LIB_CTX;
    propq             : PUTF8Char;
    flag_force_legacy : uint32;
  end;
  TX509_PUBKEY = X509_pubkey_st;
  PX509_PUBKEY = ^TX509_PUBKEY;
  PPX509_PUBKEY = ^PX509_PUBKEY;

  PASN1_PCTX = ^TASN1_PCTX;
  PPASN1_PCTX = ^PASN1_PCTX;
  PPKCS8_PRIV_KEY_INFO = ^TPKCS8_PRIV_KEY_INFO;
  PPPKCS8_PRIV_KEY_INFO = ^PPKCS8_PRIV_KEY_INFO;



  PASN1_STRING = PASN1_INTEGER;//^asn1_string_st;
  PPASN1_STRING = ^PASN1_STRING;
  PASN1_ITEM = ^TASN1_ITEM;

  x509_sig_info_st = record
    mdnid, pknid, secbits : integer;
    flags : uint32;
  end;
  TX509_SIG_INFO = x509_sig_info_st;
  PX509_SIG_INFO = ^TX509_SIG_INFO;
  PPX509_SIG_INFO = ^PX509_SIG_INFO;

  TOSSL_FUNC_keymgmt_import_fn = function(keydata: Pointer; selection: Integer; params: POSSL_PARAM): Integer;
  //typedef int (OSSL_CALLBACK)(const OSSL_PARAM params[], void *arg);
  POSSL_CALLBACK = function (const params: POSSL_PARAM ; arg: Pointer): integer;
//  /POSSL_CALLBACK = ^TOSSL_CALLBACK;
  PPOSSL_CALLBACK = ^POSSL_CALLBACK;
  evp_pkey_asn1_method_st = record
    pkey_id: Integer;
    pkey_base_id: Integer;
    pkey_flags: Cardinal;
    pem_str: PUTF8Char;
    info: PUTF8Char;
    pub_decode: function(pk: PEVP_PKEY; const pub: PX509_PUBKEY): Integer;
    pub_encode: function(pub: PX509_PUBKEY; const pk: PEVP_PKEY): Integer;
    pub_cmp: function(const a: PEVP_PKEY; const b: PEVP_PKEY): Integer;
    pub_print: function(&out: PBIO; const pkey: PEVP_PKEY; indent: Integer; pctx: PASN1_PCTX): Integer;
    priv_decode: function(pk: PEVP_PKEY; const p8inf: PPKCS8_PRIV_KEY_INFO): Integer;
    priv_encode: function(p8: PPKCS8_PRIV_KEY_INFO; const pk: PEVP_PKEY): Integer;
    priv_print: function(&out: PBIO; const pkey: PEVP_PKEY; indent: Integer; pctx: PASN1_PCTX): Integer;
    pkey_size: function(const pk: PEVP_PKEY): Integer;
    pkey_bits: function(const pk: PEVP_PKEY): Integer;
    pkey_security_bits: function(const pk: PEVP_PKEY): Integer;
    param_decode: function(pkey: PEVP_PKEY; const pder: PPByte; derlen: Integer): Integer;
    param_encode: function(const pkey: PEVP_PKEY; pder: PPByte): Integer;
    param_missing: function(const pk: PEVP_PKEY): Integer;
    param_copy: function(&to: PEVP_PKEY; const from: PEVP_PKEY): Integer;
    param_cmp: function(const a: PEVP_PKEY; const b: PEVP_PKEY): Integer;
    param_print: function(&out: PBIO; const pkey: PEVP_PKEY; indent: Integer; pctx: PASN1_PCTX): Integer;
    sig_print: function(&out: PBIO; const sigalg: PX509_ALGOR; const sig: PASN1_STRING; indent: Integer; pctx: PASN1_PCTX): Integer;
    pkey_free: procedure(pkey: PEVP_PKEY);
    pkey_ctrl: function(pkey: PEVP_PKEY; op: Integer; arg1: Integer; arg2: Pointer): Integer;
    old_priv_decode: function(pkey: PEVP_PKEY;const pder: PPByte; derlen: Integer): Integer;
    old_priv_encode: function(const pkey: PEVP_PKEY; pder: PPByte): Integer;
    item_verify: function(ctx: PEVP_MD_CTX; const it: PASN1_ITEM; const data: Pointer; const a: PX509_ALGOR; const sig: PASN1_BIT_STRING; pkey: PEVP_PKEY): Integer;
    item_sign: function(ctx: PEVP_MD_CTX; const it: PASN1_ITEM; const data: Pointer; alg1: PX509_ALGOR; alg2: PX509_ALGOR; sig: PASN1_BIT_STRING): Integer;
    siginf_set: function(siginf: PX509_SIG_INFO; const alg: PX509_ALGOR; const sig: PASN1_STRING): Integer;
    pkey_check: function(const pk: PEVP_PKEY): Integer;
    pkey_public_check: function(const pk: PEVP_PKEY): Integer;
    pkey_param_check: function(const pk: PEVP_PKEY): Integer;
    set_priv_key: function(pk: PEVP_PKEY; const priv: PByte; len: size_t): Integer;
    set_pub_key: function(pk: PEVP_PKEY; const pub: PByte; len: size_t): Integer;
    get_priv_key: function(const pk: PEVP_PKEY; priv: PByte; len: Psize_t): Integer;
    get_pub_key: function(const pk: PEVP_PKEY; pub: PByte; len: Psize_t): Integer;
    dirty_cnt: function(const pk: PEVP_PKEY): size_t;
    export_to: function(const pk: PEVP_PKEY; to_keydata: Pointer; importer: TOSSL_FUNC_keymgmt_import_fn; libctx: POSSL_LIB_CTX; const propq: PUTF8Char): Integer;
    import_from: POSSL_CALLBACK;
    copy: function(&to: PEVP_PKEY; from: PEVP_PKEY): Integer;
    priv_decode_ex: function(pk: PEVP_PKEY; const p8inf: PPKCS8_PRIV_KEY_INFO; libctx: POSSL_LIB_CTX; const propq: PUTF8Char): Integer;
  end;

  TEVP_PKEY_ASN1_METHOD = evp_pkey_asn1_method_st;
  PEVP_PKEY_ASN1_METHOD = ^TEVP_PKEY_ASN1_METHOD;
  PPEVP_PKEY_ASN1_METHOD = ^PEVP_PKEY_ASN1_METHOD;
  ENGINE_CTRL_FUNC_PTR_f = Pointer;

  PSSL = Pointer;
  PPSSL = ^PSSL;
  PX509  = ^TX509;
  PPX509 = ^PX509;

  PEVP_MD = ^TEVP_MD;
  PPEVP_MD = ^PEVP_MD;
  PUI_METHOD = ^TUI_METHOD;

  Teng_ctrl_fn = procedure;
  TENGINE_CIPHERS_PTR = function(p1: PENGINE; p2: PPEVP_CIPHER; p3: PPInteger; p4: Integer): Integer;
  TENGINE_PKEY_METHS_PTR = function(p1: PENGINE; p2: PPEVP_PKEY_METHOD; p3: PPInteger; p4: Integer): Integer;

  TENGINE_PKEY_ASN1_METHS_PTR = function(p1: PENGINE; p2: PPEVP_PKEY_ASN1_METHOD; p3: PPInteger; p4: Integer): Integer;
  TENGINE_GEN_INT_FUNC_PTR = function(p1: PENGINE): Integer;
  TENGINE_CTRL_FUNC_PTR = function(p1: PENGINE; p2: Integer; p3: Integer; p4: Pointer; f: Teng_ctrl_fn): Integer;
  ENGINE_LOAD_KEY_PTR = function(p1: PENGINE; p2: PUTF8Char; ui_method: PUI_METHOD; callback_data: Pointer): Pevp_pkey_st;
  ENGINE_SSL_CLIENT_CERT_PTR = function(p1: PENGINE; ssl: PSSL; ca_dn: Pstack_st_X509_NAME; pcert: PPX509; pkey: PPEVP_PKEY; pother: PPstack_st_X509; ui_method: PUI_METHOD; callback_data: Pointer): Integer;
  //ENGINE_CIPHERS_PTR = function(p1: PENGINE; p2: PPEVP_CIPHER; p3: PPInteger; p4: Integer): Integer;
  TENGINE_DIGESTS_PTR = function(p1: PENGINE; p2: PPEVP_MD; p3: PPInteger; p4: Integer): Integer;
  ENGINE_PKEY_METHS_PTR = function(p1: PENGINE; p2: PPEVP_PKEY_METHOD; p3: PPInteger; p4: Integer): Integer;
  //ENGINE_PKEY_ASN1_METHS_PTR = function(p1: PENGINE; p2: PPEVP_PKEY_ASN1_METHOD; p3: PPInteger; p4: Integer): Integer;
  PENGINE_CMD_DEFN = ^TENGINE_CMD_DEFN;
  TENGINE_DYNAMIC_ID = procedure();

  engine_st = record
    id: PUTF8Char;
    name: PUTF8Char;
    rsa_meth: PRSA_METHOD;
    dsa_meth: PDSA_METHOD;
    dh_meth: PDH_METHOD;
    ec_meth: PEC_KEY_METHOD;
    rand_meth: PRAND_METHOD;
    ciphers: TENGINE_CIPHERS_PTR;
    digests: TENGINE_DIGESTS_PTR;
    pkey_meths: TENGINE_PKEY_METHS_PTR;
    pkey_asn1_meths: TENGINE_PKEY_ASN1_METHS_PTR;
    destroy: TENGINE_GEN_INT_FUNC_PTR;
    init: TENGINE_GEN_INT_FUNC_PTR;
    finish: TENGINE_GEN_INT_FUNC_PTR;
    ctrl: TENGINE_CTRL_FUNC_PTR;
    load_privkey: ENGINE_LOAD_KEY_PTR;
    load_pubkey: ENGINE_LOAD_KEY_PTR;
    load_ssl_client_cert: ENGINE_SSL_CLIENT_CERT_PTR;
    cmd_defns: PENGINE_CMD_DEFN;
    flags: Integer;
    struct_ref: CRYPTO_REF_COUNT;
    funct_ref: Integer;
    ex_data: TCRYPTO_EX_DATA;
    prev: Pengine;
    next: Pengine;
    prev_dyn: Pengine;
    next_dyn: Pengine;
    dynamic_id: TENGINE_DYNAMIC_ID;
  end;
  TENGINE = engine_st;

  SHAstate_st = record
    h0: Cardinal;
    h1: Cardinal;
    h2: Cardinal;
    h3: Cardinal;
    h4: Cardinal;
    Nl: Cardinal;
    Nh: Cardinal;
    data: array [0..15] of Cardinal;
    num: Cardinal;
  end;
  TSHA_CTX = SHAstate_st;
  PSHA_CTX = ^TSHA_CTX;

  evp_md_ctx_st = record
    reqdigest: PEVP_MD;
    digest: PEVP_MD;
    engine: PENGINE;
    flags: Cardinal;
    md_data: Pointer;
    pctx: PEVP_PKEY_CTX;
    update: function(ctx: PEVP_MD_CTX; const data: Pointer; count: size_t): Integer;
    algctx: PSHA_CTX;
    fetched_digest: PEVP_MD;
  end;

  TEVP_MD_CTX = evp_md_ctx_st;

  PPEVP_MD_CTX = ^PEVP_MD_CTX;




  TOSSL_FUNC_digest_newctx_fn = function(provctx: Pointer): Pointer;
  TOSSL_FUNC_digest_init_fn = function(dctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_digest_update_fn = function(dctx: Pointer; const &in: PByte; inl: size_t): Integer;
  TOSSL_FUNC_digest_final_fn = function(dctx: Pointer; &out: PByte; outl: Psize_t; outsz: size_t): Integer;
  TOSSL_FUNC_digest_digest_fn = function(provctx: Pointer; const &in: PByte; inl: size_t; &out: PByte; outl: Psize_t; outsz: size_t): Integer;
  TOSSL_FUNC_digest_freectx_fn = procedure(dctx: Pointer);
  TOSSL_FUNC_digest_dupctx_fn = procedure(const sctx: PSHA_CTX;var dctx: PSHA_CTX);
  TOSSL_FUNC_digest_get_params_fn = function(params: POSSL_PARAM): Integer;
  TOSSL_FUNC_digest_set_ctx_params_fn = function(vctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_digest_get_ctx_params_fn = function(vctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_digest_gettable_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_digest_settable_ctx_params_fn = function(dctx: Pointer; provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_digest_gettable_ctx_params_fn = function(dctx: Pointer; provctx: Pointer): POSSL_PARAM;

  evp_md_st = record
    &type: Integer;
    pkey_type: Integer;
    md_size: Integer;
    flags: Cardinal;
    origin: Integer;
    init: function(ctx: PEVP_MD_CTX): Integer;
    update: function(ctx: PEVP_MD_CTX; const data: Pointer; count: size_t): Integer;
    &final: function(ctx: PEVP_MD_CTX; md: PByte): Integer;
    copy: function(&to: PEVP_MD_CTX; const from: PEVP_MD_CTX): Integer;
    cleanup: function(ctx: PEVP_MD_CTX): Integer;
    block_size: Integer;
    ctx_size: Integer;
    md_ctrl: function(ctx: PEVP_MD_CTX; cmd: Integer; p1: Integer; p2: Pointer): Integer;
    name_id: Integer;
    type_name: PUTF8Char;
    description: PUTF8Char;
    prov: POSSL_PROVIDER;
    refcnt: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
    newctx: TOSSL_FUNC_digest_newctx_fn;
    dinit: TOSSL_FUNC_digest_init_fn;
    dupdate: TOSSL_FUNC_digest_update_fn;
    dfinal: TOSSL_FUNC_digest_final_fn;
    digest: TOSSL_FUNC_digest_digest_fn;
    freectx: TOSSL_FUNC_digest_freectx_fn;
    dupctx: TOSSL_FUNC_digest_dupctx_fn;
    get_params: TOSSL_FUNC_digest_get_params_fn;
    set_ctx_params: TOSSL_FUNC_digest_set_ctx_params_fn;
    get_ctx_params: TOSSL_FUNC_digest_get_ctx_params_fn;
    gettable_params: TOSSL_FUNC_digest_gettable_params_fn;
    settable_ctx_params: TOSSL_FUNC_digest_settable_ctx_params_fn;
    gettable_ctx_params: TOSSL_FUNC_digest_gettable_ctx_params_fn;
  end;
  TEVP_MD = evp_md_st ;

  rsa_pss_params_30_st = record
    hash_algorithm_nid: Integer;
    mask_gen: record
      algorithm_nid,       // Currently always NID_mgf1
      hash_algorithm_nid: int;
    end;
    salt_len: Integer;
    trailer_field: Integer;
  end;
  TRSA_PSS_PARAMS_30 = rsa_pss_params_30_st;
  PRSA_PSS_PARAMS_30 = ^TRSA_PSS_PARAMS_30;



  rsa_prime_info_st = record
    r: PBIGNUM;
    d: PBIGNUM;
    t: PBIGNUM;
    pp: PBIGNUM;
    m: PBN_MONT_CTX;
  end;
  TRSA_PRIME_INFO = rsa_prime_info_st;
  PRSA_PRIME_INFO = ^TRSA_PRIME_INFO;
  PPRSA_PRIME_INFO = ^PRSA_PRIME_INFO;
  //DEFINE_STACK_OF(RSA_PRIME_INFO) rsa_local.h
  Pstack_st_RSA_PRIME_INFO = Pointer;
  PRSA_PSS_PARAMS = ^TRSA_PSS_PARAMS;
  PPRSA_PSS_PARAMS = ^PRSA_PSS_PARAMS;
  

  rsa_st = record
    dummy_zero: Integer;
    libctx: POSSL_LIB_CTX;
    version: Int32;
    meth: PRSA_METHOD;
    engine: PENGINE;
    n: PBIGNUM;
    e: PBIGNUM;
    d: PBIGNUM;
    p: PBIGNUM;
    q: PBIGNUM;
    dmp1: PBIGNUM;
    dmq1: PBIGNUM;
    iqmp: PBIGNUM;
    pss_params: TRSA_PSS_PARAMS_30;
{$ifndef FIPS_MODULE}
    pss: PRSA_PSS_PARAMS;
    prime_infos: Pstack_st_RSA_PRIME_INFO;
    ex_data: TCRYPTO_EX_DATA;
{$endif}
    references: CRYPTO_REF_COUNT;
    flags: Integer;
    _method_mod_n: PBN_MONT_CTX;
    _method_mod_p: PBN_MONT_CTX;
    _method_mod_q: PBN_MONT_CTX;
    blinding: PBN_BLINDING;
    mt_blinding: PBN_BLINDING;
    lock: PCRYPTO_RWLOCK;
    dirty_cnt: Integer;
  end;
  TRSA = rsa_st;
  Prsa_st = ^rsa_st;

  dh_st = record
    pad: Integer;
    version: Integer;
    params: TFFC_PARAMS;
    length: Int32;
    pub_key: PBIGNUM;
    priv_key: PBIGNUM;
    flags: Integer;
    method_mont_p: PBN_MONT_CTX;
    references: CRYPTO_REF_COUNT;
    ex_data: TCRYPTO_EX_DATA;
    engine: PENGINE;
    libctx: POSSL_LIB_CTX;
    meth: PDH_METHOD;
    lock: PCRYPTO_RWLOCK;
    dirty_cnt: size_t;
  end;
  TDH = dh_st;
  PDH = ^TDH;
  PPDH = ^PDH;

  dh_method = record
    name: PUTF8Char;
    generate_key: function(dh: PDH): Integer;
    compute_key: function(key: PByte; const pub_key: PBIGNUM; dh: PDH): Integer;
    bn_mod_exp: function(const dh: PDH; r: PBIGNUM; const a: PBIGNUM; const p: PBIGNUM; const m: PBIGNUM; ctx: PBN_CTX; m_ctx: PBN_MONT_CTX): Integer;
    init: function(dh: PDH): Integer;
    finish: function(dh: PDH): Integer;
    flags: Integer;
    app_data: PUTF8Char;
    generate_params: function(dh: PDH; prime_len: Integer; generator: Integer; cb: PBN_GENCB): Integer;
  end;
  TDH_METHOD = dh_method;

  PPDH_METHOD = ^PDH_METHOD;

  PPDSA_METHOD = ^PDSA_METHOD;



  
  ec_key_st = record
    meth: PEC_KEY_METHOD;
    engine: PENGINE;
    version: Integer;
    group: PEC_GROUP;
    pub_key: PEC_POINT;
    priv_key: PBIGNUM;
    enc_flag: Cardinal;
    conv_form: point_conversion_form_t;
    references: CRYPTO_REF_COUNT;
    flags: Integer;
    ex_data: TCRYPTO_EX_DATA;
    lock: PCRYPTO_RWLOCK;
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
    dirty_cnt: size_t;
  end;
  TEC_KEY = ec_key_st;

  PPEC_KEY = ^PEC_KEY;

  ec_method_st = record
    flags: Integer;
    field_type: Integer;
    group_init: function(p1: PEC_GROUP): Integer;
    group_finish: procedure(p1: PEC_GROUP);
    group_clear_finish: procedure(p1: PEC_GROUP);
    group_copy: function(p1: PEC_GROUP; const p2: PEC_GROUP): Integer;
    group_set_curve: function(p1: PEC_GROUP; const p: PBIGNUM; const a: PBIGNUM; const b: PBIGNUM; p5: PBN_CTX): Integer;
    group_get_curve: function(const p1: PEC_GROUP; p: PBIGNUM; a: PBIGNUM; b: PBIGNUM; p5: PBN_CTX): Integer;
    group_get_degree: function(const p1: PEC_GROUP): Integer;
    group_order_bits: function(const p1: PEC_GROUP): Integer;
    group_check_discriminant: function(const p1: PEC_GROUP; p2: PBN_CTX): Integer;
    point_init: function(p1: PEC_POINT): Integer;
    point_finish: procedure(p1: PEC_POINT);
    point_clear_finish: procedure(p1: PEC_POINT);
    point_copy: function(p1: PEC_POINT; const p2: PEC_POINT): Integer;
    point_set_to_infinity: function(const p1: PEC_GROUP; p2: PEC_POINT): Integer;
    point_set_affine_coordinates: function(const p1: PEC_GROUP; p2: PEC_POINT; const x: PBIGNUM; const y: PBIGNUM; p5: PBN_CTX): Integer;
    point_get_affine_coordinates: function(const p1: PEC_GROUP; const p2: PEC_POINT; x: PBIGNUM; y: PBIGNUM; p5: PBN_CTX): Integer;
    point_set_compressed_coordinates: function(const p1: PEC_GROUP; p2: PEC_POINT; const x: PBIGNUM; y_bit: Integer; p5: PBN_CTX): Integer;
    point2oct: function(const p1: PEC_GROUP; const p2: PEC_POINT; form: point_conversion_form_t; buf: PByte; len: size_t; p6: PBN_CTX): size_t;
    oct2point: function(const p1: PEC_GROUP; p2: PEC_POINT; const buf: PByte; len: size_t; p5: PBN_CTX): Integer;
    add: function(const p1: PEC_GROUP; r: PEC_POINT; const a: PEC_POINT; const b: PEC_POINT; p5: PBN_CTX): Integer;
    dbl: function(const p1: PEC_GROUP; r: PEC_POINT; const a: PEC_POINT; p4: PBN_CTX): Integer;
    invert: function(const p1: PEC_GROUP; p2: PEC_POINT; p3: PBN_CTX): Integer;
    is_at_infinity: function(const p1: PEC_GROUP; const p2: PEC_POINT): Integer;
    is_on_curve: function(const p1: PEC_GROUP; const p2: PEC_POINT; p3: PBN_CTX): Integer;
    point_cmp: function(const p1: PEC_GROUP; const a: PEC_POINT; const b: PEC_POINT; p4: PBN_CTX): Integer;
    make_affine: function(const p1: PEC_GROUP; p2: PEC_POINT; p3: PBN_CTX): Integer;
    points_make_affine: function(const p1: PEC_GROUP; num: size_t; p3: PPEC_POINT; p4: PBN_CTX): Integer;
    mul: function(const group: PEC_GROUP; r: PEC_POINT; const scalar: PBIGNUM; num: size_t;const points: PPEC_POINT;const scalars: PPBIGNUM; p7: PBN_CTX): Integer;
    precompute_mult: function(group: PEC_GROUP; p2: PBN_CTX): Integer;
    have_precompute_mult: function(const group: PEC_GROUP): Integer;
    field_mul: function(const p1: PEC_GROUP; r: PBIGNUM; const a: PBIGNUM; const b: PBIGNUM; p5: PBN_CTX): Integer;
    field_sqr: function(const p1: PEC_GROUP; r: PBIGNUM; const a: PBIGNUM; p4: PBN_CTX): Integer;
    field_div: function(const p1: PEC_GROUP; r: PBIGNUM; const a: PBIGNUM; const b: PBIGNUM; p5: PBN_CTX): Integer;
    field_inv: function(const p1: PEC_GROUP; r: PBIGNUM; const a: PBIGNUM; p4: PBN_CTX): Integer;
    field_encode: function(const p1: PEC_GROUP; r: PBIGNUM; const a: PBIGNUM; p4: PBN_CTX): Integer;
    field_decode: function(const p1: PEC_GROUP; r: PBIGNUM; const a: PBIGNUM; p4: PBN_CTX): Integer;
    field_set_to_one: function(const p1: PEC_GROUP; r: PBIGNUM; p3: PBN_CTX): Integer;
    priv2oct: function(const eckey: PEC_KEY; buf: PByte; len: size_t): size_t;
    oct2priv: function(eckey: PEC_KEY; const buf: PByte; len: size_t): Integer;
    set_private: function(eckey: PEC_KEY; const priv_key: PBIGNUM): Integer;
    keygen: function(eckey: PEC_KEY): Integer;
    keycheck: function(const eckey: PEC_KEY): Integer;
    keygenpub: function(eckey: PEC_KEY): Integer;
    keycopy: function(dst: PEC_KEY; const src: PEC_KEY): Integer;
    keyfinish: procedure(eckey: PEC_KEY);
    ecdh_compute_key: function(pout: PPByte; poutlen: Psize_t; const pub_key: PEC_POINT; const ecdh: PEC_KEY): Integer;
    ecdsa_sign_setup: function(eckey: PEC_KEY; ctx: PBN_CTX; kinvp: PPBIGNUM; rp: PPBIGNUM): Integer;
    ecdsa_sign_sig: function(const dgst: PByte; dgstlen: Integer; const kinv: PBIGNUM; const r: PBIGNUM; eckey: PEC_KEY): PECDSA_SIG;
    ecdsa_verify_sig: function(const dgst: PByte; dgstlen: Integer; const sig: PECDSA_SIG; eckey: PEC_KEY): Integer;
    field_inverse_mod_ord: function(const p1: PEC_GROUP; r: PBIGNUM; const x: PBIGNUM; p4: PBN_CTX): Integer;
    blind_coordinates: function(const group: PEC_GROUP; p: PEC_POINT; ctx: PBN_CTX): Integer;
    ladder_pre: function(const group: PEC_GROUP; r: PEC_POINT; s: PEC_POINT; p: PEC_POINT; ctx: PBN_CTX): Integer;
    ladder_step: function(const group: PEC_GROUP; r: PEC_POINT; s: PEC_POINT; p: PEC_POINT; ctx: PBN_CTX): Integer;
    ladder_post: function(const group: PEC_GROUP; r: PEC_POINT; s: PEC_POINT; p: PEC_POINT; ctx: PBN_CTX): Integer;
  end;
  TEC_METHOD = ec_method_st;
  //PEC_METHOD = ^TEC_METHOD;
  PPEC_METHOD = ^PEC_METHOD;





  TECX_KEY_TYPE = (
    ECX_KEY_TYPE_X25519,
    ECX_KEY_TYPE_X448,
    ECX_KEY_TYPE_ED25519,
    ECX_KEY_TYPE_ED448
  ) ;
  ecx_key_st = record
    libctx     : POSSL_LIB_CTX;
    propq      : PUTF8Char;
    haspubkey  : Cardinal;
    pubkey     : array[0..(MAX_KEYLEN)-1] of byte;
    privkey    : PByte;
    keylen     : size_t;
    &type      : TECX_KEY_TYPE;
    references : CRYPTO_REF_COUNT;
    lock       : PCRYPTO_RWLOCK;
  end;
  TECX_KEY = ecx_key_st;
  PECX_KEY = ^TECX_KEY;
  PPECX_KEY = ^PECX_KEY;

  legacy_pkey_st = record
    case integer of

    0: (ptr: Pointer);
    1: (rsa: PRSA);     (* RSA *)
  {$ifndef OPENSSL_NO_DSA}
    2: (dsa: Pdsa);     (* DSA *)
  {$endif}
  {$ifndef OPENSSL_NO_DH}
    3: (dh: PDH);       (* DH *)
  {$endif}
  {$ifndef OPENSSL_NO_EC}
    4: (ec: PEC_KEY);   (* ECC *)
    5: (ecx: PECX_KEY );           (* X25519, X448, Ed25519, Ed448 *)
  {$endif}
 end;

  ossl_param_st = record
    key         : PUTF8Char;
    data_type   : uint32;
    data        : Pointer;
    data_size,
    return_size : size_t;
  end;
  TOSSL_PARAM = ossl_param_st ;


  PDSO = ^TDSO;

  TOSSL_FUNC_keymgmt_new_fn = function(provctx: Pointer): Pointer;
  TOSSL_FUNC_keymgmt_free_fn = procedure(keydata: Pointer);
  TOSSL_FUNC_keymgmt_get_params_fn = function(keydata: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_keymgmt_gettable_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_keymgmt_set_params_fn = function(keydata: Pointer; const params: POSSL_PARAM): Integer;
  TOSSL_FUNC_keymgmt_settable_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_keymgmt_gen_init_fn = function (provctx: Pointer; selection: Integer; const params: POSSL_PARAM): Pointer;
  TOSSL_FUNC_keymgmt_gen_set_template_fn = function(genctx, templ: Pointer): Integer;
  TOSSL_FUNC_keymgmt_gen_set_params_fn =  function(genctx : Pointer;const params : POSSL_PARAM):integer;
  TOSSL_FUNC_keymgmt_gen_settable_params_fn = function( genctx, provctx : pointer):POSSL_PARAM;
  TOSSL_FUNC_keymgmt_gen_fn =  function ( genctx : Pointer; cb : POSSL_CALLBACK; cbarg : Pointer):Pointer;
  TOSSL_FUNC_keymgmt_gen_cleanup_fn = procedure(genctx: Pointer);
  TOSSL_FUNC_keymgmt_load_fn = function(const reference: Pointer; reference_sz: size_t): Pointer;
  TOSSL_FUNC_keymgmt_query_operation_name_fn = function(operation_id: integer): PUTF8Char ;
  TOSSL_FUNC_keymgmt_has_fn = function(const keydata: Pointer; selection: integer): Integer;
  TOSSL_FUNC_keymgmt_validate_fn = function (const keydata: Pointer; selection, checktype : integer):integer;
  TOSSL_FUNC_keymgmt_match_fn =  function(const keydata1, keydata2 : Pointer; selection : integer):integer;
  //TOSSL_FUNC_keymgmt_import_fn = function (keydata : Pointer; selection : integer;const params : POSSL_PARAM):integer;
  TOSSL_FUNC_keymgmt_import_types_fn = function(selection: integer) :POSSL_PARAM;
  TOSSL_FUNC_keymgmt_export_fn = function (keydata : Pointer; selection : integer; param_cb : POSSL_CALLBACK; cbarg : Pointer):integer;
  TOSSL_FUNC_keymgmt_export_types_fn =  function(selection: integer): POSSL_PARAM;
  TOSSL_FUNC_keymgmt_dup_fn = function(const keydata_from : Pointer; selection : integer):Pointer;
  TDSO_NAME_CONVERTER_FUNC = function(p1: PDSO ; const p2: PUTF8Char): PUTF8Char ;
  TDSO_MERGER_FUNC = function(p1: PDSO ; const p2, p3: PUTF8Char): PUTF8Char;


  PDSO_METHOD = ^TDSO_METHOD;
  dso_st = record
    meth            : PDSO_METHOD;
    meth_data       : PSTACK_st_void;
    references      : CRYPTO_REF_COUNT;
    flags           : integer;
    ex_data         : TCRYPTO_EX_DATA;
    name_converter  : TDSO_NAME_CONVERTER_FUNC;
    merger          : TDSO_MERGER_FUNC;
    filename,
    loaded_filename : PUTF8Char;
    lock            : PCRYPTO_RWLOCK;
  end;
  TDSO = dso_st;
  TDSO_FUNC_TYPE = procedure ();
  Tdso_load_fn = function ( dso : PDSO):integer;
  Tdso_unload_fn = function( dso : PDSO):integer;
  Tdso_bind_func = function( dso : PDSO; const symname : PUTF8Char): TDSO_FUNC_TYPE;
  Tdso_ctrl_fn = function( dso : PDSO; cmd : integer; larg : long; parg : Pointer):long;
  Tinit_fn = function( dso : PDSO):integer;
  Tfinish_fn = function( dso : PDSO):integer;
  Tpathbyaddr_fn = function( addr : Pointer; path : PUTF8Char; sz : integer):integer;
  Tgloballookup_fn = function(const symname : PUTF8Char):Pointer;

  dso_meth_st = record
      name               : PUTF8Char;
      dso_load: Tdso_load_fn;
      dso_unload: Tdso_unload_fn;
      dso_bind_func: Tdso_bind_func;
      dso_ctrl: Tdso_ctrl_fn;
      dso_name_converter : TDSO_NAME_CONVERTER_FUNC;

      dso_merger         : TDSO_MERGER_FUNC;
      init: Tinit_fn;
      finish: Tfinish_fn;
      pathbyaddr: Tpathbyaddr_fn;
      globallookup: Tgloballookup_fn;
  end;
  {
  ossl_core_handle_st = record
  end;
  TOSSL_CORE_HANDLE = ossl_core_handle_st;}
  POSSL_CORE_HANDLE = Pointer;
  TDSO_METHOD = dso_meth_st ;


  ossl_dispatch_st = record
    function_id: Integer;
    _function: procedure();
    method: TMethod;
  end;

  TOSSL_DISPATCH = ossl_dispatch_st ;
  POSSL_DISPATCH = ^TOSSL_DISPATCH;
  PPOSSL_DISPATCH = ^POSSL_DISPATCH;
  TOSSL_provider_init_fn = function(const handle: POSSL_CORE_HANDLE;
                                    {const} _in: POSSL_DISPATCH;
                                    var _out: POSSL_DISPATCH;
                                    provctx: PPointer): integer;
  POSSL_provider_init_fn = ^TOSSL_provider_init_fn;
  Pstack_st_OSSL_PROVIDER = Pointer;
  Pstack_st_OSSL_PROVIDER_CHILD_CB = Pointer;
  Pstack_st_INFOPAIR = Pointer;
  PPstack_st_INFOPAIR = ^Pstack_st_INFOPAIR;

  TOSSL_PROVIDER_INFO = record
    name,
    path       : PUTF8Char;
    init       : TOSSL_provider_init_fn;
    parameters : Pstack_st_INFOPAIR;
    is_fallback: uint;
  end;
  POSSL_PROVIDER_INFO = ^TOSSL_PROVIDER_INFO ;

  provider_store_st = record
    libctx: POSSL_LIB_CTX;
    providers: Pstack_st_OSSL_PROVIDER;
    child_cbs: Pstack_st_OSSL_PROVIDER_CHILD_CB;
    default_path_lock: PCRYPTO_RWLOCK;
    lock: PCRYPTO_RWLOCK;
    default_path: PUTF8Char;
    provinfo: POSSL_PROVIDER_INFO;
    numprovinfo: size_t;
    provinfosz: size_t;
    use_fallbacks: Cardinal;
    freeing: Cardinal;
  end;

  ERR_string_data_st = record
    error : Cardinal;
    _string : PUTF8Char;
  end;
  TERR_STRING_DATA = ERR_string_data_st;
  PERR_STRING_DATA = ^TERR_STRING_DATA;
  ossl_algorithm_st = record

    algorithm_names,
    property_definition   : PUTF8Char;
    _implementation       : POSSL_DISPATCH;
    algorithm_description : PUTF8Char;
  end;
  TOSSL_ALGORITHM = ossl_algorithm_st ;
  POSSL_ALGORITHM = ^TOSSL_ALGORITHM;
  TOSSL_FUNC_provider_teardown_fn = procedure(provctx: Pointer);
  TOSSL_FUNC_provider_gettable_params_fn = function( provctx : Pointer):POSSL_PARAM;
  TOSSL_FUNC_provider_get_params_fn =  function( provctx : Pointer; params : POSSL_PARAM):integer;
  TOSSL_FUNC_provider_get_capabilities_fn = function (provctx : Pointer;const capability : PUTF8Char; cb : POSSL_CALLBACK; arg : Pointer):integer;
  TOSSL_FUNC_provider_self_test_fn =  function ( provctx : Pointer):integer;
  TOSSL_FUNC_provider_unquery_operation_fn = procedure (provctx : Pointer; operation_id : integer;const alg : POSSL_ALGORITHM);
  TOSSL_FUNC_provider_query_operation_fn = function ( provctx : Pointer; operation_id : integer;var no_store : integer):POSSL_ALGORITHM;

  Pprovider_store_st = ^provider_store_st;
  ossl_provider_st = record
    flag_initialized,
    flag_activated      : UInt32;
    flag_lock           : PCRYPTO_RWLOCK;
    refcnt              : CRYPTO_REF_COUNT;
    refcnt_lock         : PCRYPTO_RWLOCK;
    activatecnt         : integer;
    name,Path           : PUTF8Char;
    module              : PDSO;
    init_function       : TOSSL_provider_init_fn;
    parameters          : PSTACK_st_INFOPAIR;
    libctx              : POSSL_LIB_CTX;
    store               : Pprovider_store_st;
{$ifndef FIPS_MODULE}
    error_lib           : integer;
  {$ifndef OPENSSL_NO_ERR}
    error_strings       : PERR_STRING_DATA;
  {$ENDIF}
{$ENDIF}
    teardown            : TOSSL_FUNC_provider_teardown_fn;

    gettable_params     : TOSSL_FUNC_provider_gettable_params_fn;
    get_params          : TOSSL_FUNC_provider_get_params_fn;
    get_capabilities    : TOSSL_FUNC_provider_get_capabilities_fn;
    self_test           : TOSSL_FUNC_provider_self_test_fn;
    query_operation     : TOSSL_FUNC_provider_query_operation_fn;
    unquery_operation   : TOSSL_FUNC_provider_unquery_operation_fn;
    operation_bits      : PByte;
    operation_bits_sz   : size_t;
    opbits_lock         : PCRYPTO_RWLOCK;

{$ifndef FIPS_MODULE }
    {* Whether this provider is the child of some other provider *}
    handle: POSSL_CORE_HANDLE;
    ischild: UInt32;
{$endif}
    provctx             : Pointer;
    dispatch            : POSSL_DISPATCH;
end;


  TOSSL_PROVIDER = ossl_provider_st;

  evp_keymgmt_st = record
    id,
    name_id              : integer;
    type_name, description            : PUTF8Char;
    prov                 : POSSL_PROVIDER;
    refcnt               : CRYPTO_REF_COUNT;
    lock                 : PCRYPTO_RWLOCK;
    new                  : TOSSL_FUNC_keymgmt_new_fn;
    free                 : TOSSL_FUNC_keymgmt_free_fn;
    get_params           : TOSSL_FUNC_keymgmt_get_params_fn;
    gettable_params      : TOSSL_FUNC_keymgmt_gettable_params_fn;
    set_params           : TOSSL_FUNC_keymgmt_set_params_fn;
    settable_params      : TOSSL_FUNC_keymgmt_settable_params_fn;
    gen_init             : TOSSL_FUNC_keymgmt_gen_init_fn;
    gen_set_template     : TOSSL_FUNC_keymgmt_gen_set_template_fn;
    gen_set_params       : TOSSL_FUNC_keymgmt_gen_set_params_fn;
    gen_settable_params  : TOSSL_FUNC_keymgmt_gen_settable_params_fn;
    gen                  : TOSSL_FUNC_keymgmt_gen_fn;
    gen_cleanup          : TOSSL_FUNC_keymgmt_gen_cleanup_fn;
    load                 : TOSSL_FUNC_keymgmt_load_fn;
    query_operation_name : TOSSL_FUNC_keymgmt_query_operation_name_fn;
    has                  : TOSSL_FUNC_keymgmt_has_fn;
    validate             : TOSSL_FUNC_keymgmt_validate_fn;
    match                : TOSSL_FUNC_keymgmt_match_fn;
    import               : TOSSL_FUNC_keymgmt_import_fn;
    import_types         : TOSSL_FUNC_keymgmt_import_types_fn;
    &export              : TOSSL_FUNC_keymgmt_export_fn;
    export_types         : TOSSL_FUNC_keymgmt_export_types_fn;
    dup                  : TOSSL_FUNC_keymgmt_dup_fn;
end;

  PSTACK_st_OP_CACHE_ELEM = Pointer;
  evp_pkey_st = record
    &type,
    save_type         : integer;
    ameth             : PEVP_PKEY_ASN1_METHOD;
    engine,
    pmeth_engine      : PENGINE;
    pkey,
    legacy_cache_pkey : legacy_pkey_st;
    references        : CRYPTO_REF_COUNT;
    lock              : PCRYPTO_RWLOCK;
    attributes        : PSTACK_st_X509_ATTRIBUTE;
    save_parameters   : integer;
    foreign           : uint32;
    ex_data           : TCRYPTO_EX_DATA;
    keymgmt           : PEVP_KEYMGMT;
    keydata           : Pointer;
    dirty_cnt         : size_t;
    operation_cache   : PSTACK_st_OP_CACHE_ELEM;
    dirty_cnt_copy    : size_t;

    cache: record
      bits,
      security_bits,
      size              : integer;
    end;
  end;
  TEVP_PKEY = evp_pkey_st;


  PEVP_ENCODE_CTX = ^TEVP_ENCODE_CTX;
  PPEVP_ENCODE_CTX = ^PEVP_ENCODE_CTX;

  hmac_ctx_st = record
    md : PEVP_MD;
    md_ctx, i_ctx, o_ctx : PEVP_MD_CTX;
  end;
  THMAC_CTX = hmac_ctx_st;
  PHMAC_CTX = ^THMAC_CTX;
  PPHMAC_CTX = ^PHMAC_CTX;

  danetls_record_st = record
    usage: UInt8;
    selector: UInt8;
    mtype: UInt8;
    data: PByte;
    dlen: size_t;
    spki: PEVP_PKEY;
  end;
  danetls_record = danetls_record_st;
  Pdanetls_record = ^danetls_record;
  PPdanetls_record = ^Pdanetls_record;

  Pstack_st_danetls_record = Pointer;
  PPstack_st_danetls_record = ^Pstack_st_danetls_record;

  dane_ctx_st = record
    mdevp: PPEVP_MD;
    mdord: PUInt8;
    mdmax: UInt8;
    flags: Cardinal;
  end;
  Pdane_ctx_st = ^dane_ctx_st;

  ssl_dane_st = record
    dctx: Pdane_ctx_st;
    trecs: Pstack_st_danetls_record;
    certs: Pstack_st_X509;
    mtlsa: Pdanetls_record;
    mcert: PX509;
    umask: UInt32;
    mdpth: Integer;
    pdpth: Integer;
    flags: Cardinal;
  end;
  TSSL_DANE = ssl_dane_st;
  PSSL_DANE = ^TSSL_DANE ;
  PPSSL_DANE = ^PSSL_DANE;

  PX509_CRL = ^TX509_CRL;
  PPX509_CRL = ^PX509_CRL;
  PX509_CRL_METHOD = ^TX509_CRL_METHOD;
  PPX509_CRL_METHOD = ^PX509_CRL_METHOD;


  PX509_REVOKED = ^TX509_REVOKED ;
  PPX509_REVOKED = ^PX509_REVOKED;
  PX509_NAME = ^TX509_NAME;
  PPX509_NAME = ^PX509_NAME;
 
  PX509_STORE = ^TX509_STORE;
  PPX509_STORE = ^PX509_STORE;
  PPX509_STORE_CTX = ^PX509_STORE_CTX;
  PX509_OBJECT = ^TX509_OBJECT;
  PPX509_OBJECT = ^PX509_OBJECT;
  PX509_LOOKUP = ^TX509_LOOKUP;
  PPX509_LOOKUP = ^PX509_LOOKUP;
  PX509_LOOKUP_METHOD = ^TX509_LOOKUP_METHOD;
  PPX509_LOOKUP_METHOD = ^PX509_LOOKUP_METHOD;
  PX509_VERIFY_PARAM = ^TX509_VERIFY_PARAM;
  PPX509_VERIFY_PARAM = ^PX509_VERIFY_PARAM;


  ossl_init_settings_st = record
    filename,
    appname  : PUTF8Char;
    flags    : Cardinal;
  end;
  TOPENSSL_INIT_SETTINGS = ossl_init_settings_st;
  PCONF = ^TCONF;
  POPENSSL_INIT_SETTINGS = ^TOPENSSL_INIT_SETTINGS;
  PPOPENSSL_INIT_SETTINGS = ^POPENSSL_INIT_SETTINGS;
 

  PSSL_CTX = Pointer;
  PPSSL_CTX = ^PSSL_CTX;
  PCOMP_CTX = Pointer;
  PPCOMP_CTX = ^PCOMP_CTX;
  PCOMP_METHOD = Pointer;
  PPCOMP_METHOD = ^PCOMP_METHOD;
  PX509_POLICY_NODE = ^TX509_POLICY_NODE;
  PPX509_POLICY_NODE = ^PX509_POLICY_NODE;
  PX509_POLICY_LEVEL = ^TX509_POLICY_LEVEL;
  PPX509_POLICY_LEVEL = ^PX509_POLICY_LEVEL;
  PX509_POLICY_TREE = ^TX509_POLICY_TREE ;
  PPX509_POLICY_TREE = ^PX509_POLICY_TREE;
  PX509_POLICY_CACHE = ^TX509_POLICY_CACHE;
  PPX509_POLICY_CACHE = ^PX509_POLICY_CACHE;
  PAUTHORITY_KEYID = ^AUTHORITY_KEYID;
  PPAUTHORITY_KEYID = ^PAUTHORITY_KEYID;
  PDIST_POINT = ^TDIST_POINT;
  PPDIST_POINT = ^PDIST_POINT;
  PISSUING_DIST_POINT = ^ISSUING_DIST_POINT;
  PPISSUING_DIST_POINT = ^PISSUING_DIST_POINT;
  POCSP_REQ_CTX = Pointer;
  PPOCSP_REQ_CTX = ^POCSP_REQ_CTX;
  POCSP_RESPONSE = Pointer;
  PPOCSP_RESPONSE = ^POCSP_RESPONSE;
  POCSP_RESPID = Pointer;
  PPOCSP_RESPID = ^POCSP_RESPID;
  PSCT = ^TSCT;
  PPSCT = ^PSCT;
  PSCT_CTX = Pointer;
  PPSCT_CTX = ^PSCT_CTX;
  PCTLOG = ^TCTLOG;
  PPCTLOG = ^PCTLOG;
  PCTLOG_STORE = ^TCTLOG_STORE;
  PPCTLOG_STORE = ^PCTLOG_STORE;
  PCT_POLICY_EVAL_CTX = Pointer;
  PPCT_POLICY_EVAL_CTX = ^PCT_POLICY_EVAL_CTX;
  POSSL_STORE_INFO = Pointer;
  PPOSSL_STORE_INFO = ^POSSL_STORE_INFO;
  POSSL_STORE_SEARCH = Pointer;
  PPOSSL_STORE_SEARCH = ^POSSL_STORE_SEARCH;
  ossl_intmax_t = Int64;
  ossl_uintmax_t = UInt64;
  CRYPTO_dynlock = record
    dummy: Integer;
  end;

  PPCRYPTO_RWLOCK = ^PCRYPTO_RWLOCK;
  sk_void_compfunc = function(a: PPointer; b: PPointer): Integer;
  sk_void_freefunc = procedure(a: Pointer);
  sk_void_copyfunc = function(a: Pointer): Pointer;

  crypto_threadid_st = record
    dummy: Integer;
  end;
  CRYPTO_THREADID = crypto_threadid_st;
  CRYPTO_ONCE = Cardinal;
  PCRYPTO_ONCE = ^CRYPTO_ONCE;
  CRYPTO_THREAD_LOCAL = Cardinal;
  PCRYPTO_THREAD_LOCAL = ^CRYPTO_THREAD_LOCAL;
  CRYPTO_THREAD_ID = Cardinal;
  PBIO_ADDR = Pointer;
  PPBIO_ADDR = ^PBIO_ADDR;
  PBIO_ADDRINFO = Pointer;
  PPBIO_ADDRINFO = ^PBIO_ADDRINFO;
  BIO_callback_fn = function(b: PBIO; oper: Integer;const argp: PUTF8Char; argi: Integer; argl: Integer; ret: Integer): Integer;
  BIO_callback_fn_ex = function(b: PBIO; oper: Integer; argp: PUTF8Char; len: size_t; argi: Integer; argl: Integer; ret: Integer; processed: Psize_t): Integer;
  PBIO_METHOD = ^TBIO_METHOD;
  PPBIO_METHOD = ^PBIO_METHOD;
  TBIO_info_cb = function(p1: PBIO; p2: Integer; p3: Integer): Integer;
  //bio_info_cb = BIO_info_cb;
  sk_BIO_compfunc = function(a: PPBIO; b: PPBIO): Integer;
  sk_BIO_freefunc = procedure(a: PBIO);
  sk_BIO_copyfunc = function(a: PBIO): Pbio_st;
  Pasn1_ps_func = function(b: PBIO; pbuf: PPByte; plen: PInteger; parg: Pointer): Integer;
  BIO_hostserv_priorities = (
    BIO_PARSE_PRIO_HOST = 0,
    BIO_PARSE_PRIO_SERV = 1);
  PBIO_hostserv_priorities = ^BIO_hostserv_priorities;
  BIO_lookup_type = (
    BIO_LOOKUP_CLIENT = 0,
    BIO_LOOKUP_SERVER = 1);
  PBIO_lookup_type = ^BIO_lookup_type;
  BIO_sock_info_u = record
    case Integer of
      0: (addr: PBIO_ADDR);
  end;
  BIO_sock_info_type = (
    BIO_SOCK_INFO_ADDRESS = 0);
  PBIO_sock_info_type = ^BIO_sock_info_type;
  asn1_string_st = record
    length: Integer;
    &type: Integer;
    data: PByte;
    flags: Integer;
  end;
  TASN1_BIT_STRING = asn1_string_st;

  TASN1_INTEGER = asn1_string_st;
  PPASN1_INTEGER = ^PASN1_INTEGER;

  ASN1_ENUMERATED = asn1_string_st;
  PASN1_ENUMERATED = PASN1_INTEGER;//^ASN1_ENUMERATED;
  PPASN1_ENUMERATED = ^PASN1_ENUMERATED;

  TASN1_OCTET_STRING = asn1_string_st;
  PASN1_OCTET_STRING = PASN1_STRING; //^TASN1_OCTET_STRING;
  PPASN1_OCTET_STRING = ^PASN1_OCTET_STRING;
  ASN1_PRINTABLESTRING = asn1_string_st;
  PASN1_PRINTABLESTRING = PASN1_STRING;
  PPASN1_PRINTABLESTRING = ^PASN1_PRINTABLESTRING;
  ASN1_T61STRING = asn1_string_st;
  PASN1_T61STRING = ^ASN1_T61STRING;
  PPASN1_T61STRING = ^PASN1_T61STRING;
  TASN1_IA5STRING = asn1_string_st;
  PASN1_IA5STRING = PASN1_STRING;
  PPASN1_IA5STRING = ^PASN1_IA5STRING;
  ASN1_GENERALSTRING = asn1_string_st;
  PASN1_GENERALSTRING = ^ASN1_GENERALSTRING;
  PPASN1_GENERALSTRING = ^PASN1_GENERALSTRING;
  ASN1_UNIVERSALSTRING = asn1_string_st;
  PASN1_UNIVERSALSTRING = ^ASN1_UNIVERSALSTRING;
  PPASN1_UNIVERSALSTRING = ^PASN1_UNIVERSALSTRING;
  ASN1_BMPSTRING = asn1_string_st;
  PASN1_BMPSTRING = ^ASN1_BMPSTRING;
  PPASN1_BMPSTRING = ^PASN1_BMPSTRING;
  TASN1_UTCTIME = asn1_string_st;

  TASN1_TIME = asn1_string_st;
  PASN1_TIME = PASN1_STRING;//^TASN1_TIME;
  PPASN1_TIME = ^PASN1_TIME;
  PASN1_UTCTIME = PASN1_TIME;
  PPASN1_UTCTIME = ^PASN1_UTCTIME;

  ASN1_GENERALIZEDTIME = TASN1_TIME;//asn1_string_st;
  PASN1_GENERALIZEDTIME = PASN1_TIME;
  PPASN1_GENERALIZEDTIME = ^PASN1_GENERALIZEDTIME;
  ASN1_VISIBLESTRING = asn1_string_st;
  PASN1_VISIBLESTRING = ^ASN1_VISIBLESTRING;
  PPASN1_VISIBLESTRING = ^PASN1_VISIBLESTRING;
  TASN1_UTF8STRING = asn1_string_st;
  PASN1_UTF8STRING = PASN1_STRING;
  PPASN1_UTF8STRING = ^PASN1_UTF8STRING;
  TASN1_STRING = asn1_string_st;

  ASN1_BOOLEAN = Integer;
  PASN1_BOOLEAN = ^ASN1_BOOLEAN;
  ASN1_NULL = Integer;
  PASN1_NULL = ^ASN1_NULL;
  PPASN1_NULL = ^PASN1_NULL;

  asn1_object_st = record
    sn: PUTF8Char;
    ln: PUTF8Char;
    nid: Integer;
    length: Integer;
    data: PByte;
    flags: Integer;
  end;
  TASN1_OBJECT = asn1_object_st;
  PASN1_OBJECT = ^TASN1_OBJECT ;
  PPASN1_OBJECT = ^PASN1_OBJECT;

  PASN1_SCTX = Pointer;
  PPASN1_SCTX = ^PASN1_SCTX;
  ASN1_ENCODING_st = record
    enc: PByte;
    len: Integer;
    modified: Integer;
  end;
  TASN1_ENCODING = ASN1_ENCODING_st;
  PASN1_ENCODING = ^TASN1_ENCODING;

  asn1_string_table_st = record
    nid: Integer;
    minsize: Integer;
    maxsize: Integer;
    mask: Cardinal;
    flags: Cardinal;
  end;
  Pasn1_string_table_st = ^asn1_string_table_st;
  Pasn1_string_st = ^asn1_string_st;

  TASN1_STRING_TABLE = asn1_string_table_st;
  PASN1_STRING_TABLE = ^TASN1_STRING_TABLE;
  PPASN1_STRING_TABLE = ^PASN1_STRING_TABLE;
  sk_ASN1_STRING_TABLE_compfunc = function(const a, b: PPASN1_STRING_TABLE): Integer;
  sk_ASN1_STRING_TABLE_freefunc = procedure(a: PASN1_STRING_TABLE);
  sk_ASN1_STRING_TABLE_copyfunc = function(a: PASN1_STRING_TABLE): Pasn1_string_table_st;
  PASN1_VALUE = Pointer;
  PPASN1_VALUE = ^PASN1_VALUE;
  //typedef void *d2i_of_void(void **, const unsigned char **, long);
  Td2i_of_void = function(p1: PPointer; const p2: PPByte; p3: long): Pointer;
  Ti2d_of_void = function(const p1: Pointer; p2: PPByte): Integer;


  sk_ASN1_INTEGER_compfunc = function(a: PPASN1_INTEGER; b: PPASN1_INTEGER): Integer;
  sk_ASN1_INTEGER_freefunc = procedure(a: PASN1_INTEGER);
  sk_ASN1_INTEGER_copyfunc = function(a: PASN1_INTEGER): Pasn1_string_st;
  sk_ASN1_GENERALSTRING_compfunc = function(a: PPASN1_GENERALSTRING; b: PPASN1_GENERALSTRING): Integer;
  sk_ASN1_GENERALSTRING_freefunc = procedure(a: PASN1_GENERALSTRING);
  sk_ASN1_GENERALSTRING_copyfunc = function(a: PASN1_GENERALSTRING): Pasn1_string_st;
  sk_ASN1_UTF8STRING_compfunc = function(a: PPASN1_UTF8STRING; b: PPASN1_UTF8STRING): Integer;
  sk_ASN1_UTF8STRING_freefunc = procedure(a: PASN1_UTF8STRING);
  sk_ASN1_UTF8STRING_copyfunc = function(a: PASN1_UTF8STRING): Pasn1_string_st;

  asn1_type_st = record
    _type: Integer;
    value: record
      case Integer of
      0: (ptr: PUTF8Char);
      1: (_boolean: ASN1_BOOLEAN);
      2: (asn1_string: PASN1_STRING);
      3: (_object: PASN1_OBJECT);
      4: (_integer: PASN1_INTEGER);
      5: (enumerated: PASN1_ENUMERATED);
      6: (bit_string: PASN1_BIT_STRING);
      7: (octet_string: PASN1_OCTET_STRING);
      8: (printablestring: PASN1_PRINTABLESTRING);
      9: (t61string: PASN1_T61STRING);
      10: (ia5string: PASN1_IA5STRING);
      11: (generalstring: PASN1_GENERALSTRING);
      12: (bmpstring: PASN1_BMPSTRING);
      13: (universalstring: PASN1_UNIVERSALSTRING);
      14: (utctime: PASN1_UTCTIME);
      15: (generalizedtime: PASN1_GENERALIZEDTIME);
      16: (visiblestring: PASN1_VISIBLESTRING);
      17: (utf8string: PASN1_UTF8STRING);
      18: (_set: PASN1_STRING);
      19: (sequence: PASN1_STRING);
      20: (asn1_value: PASN1_VALUE);
    end;
  end;

  TASN1_TYPE = asn1_type_st;
  Pasn1_type_st = ^asn1_type_st;


  sk_ASN1_TYPE_compfunc = function(a: PPASN1_TYPE; b: PPASN1_TYPE): Integer;
  sk_ASN1_TYPE_freefunc = procedure(a: PASN1_TYPE);
  sk_ASN1_TYPE_copyfunc = function(a: PASN1_TYPE): Pasn1_type_st;
  PASN1_SEQUENCE_ANY = Pointer;
  PPASN1_SEQUENCE_ANY = ^PASN1_SEQUENCE_ANY;
  BIT_STRING_BITNAME_st = record
    bitnum: Integer;
    lname: PUTF8Char;
    sname: PUTF8Char;
  end;
  TBIT_STRING_BITNAME = BIT_STRING_BITNAME_st;
  PBIT_STRING_BITNAME = ^TBIT_STRING_BITNAME;
  TENUMERATED_NAMES = TBIT_STRING_BITNAME ;
  PENUMERATED_NAMES = ^TENUMERATED_NAMES;

  sk_ASN1_OBJECT_compfunc = function(a: PPASN1_OBJECT; b: PPASN1_OBJECT): Integer;
  sk_ASN1_OBJECT_freefunc = procedure(a: PASN1_OBJECT);
  sk_ASN1_OBJECT_copyfunc = function(a: PASN1_OBJECT): Pasn1_object_st;

  TASN1_ITEM_EXP = function(): PASN1_ITEM;
  ASN1_TEMPLATE_st = record
    flags: Cardinal;
    tag: Integer;
    offset: Cardinal;
    field_name: PUTF8Char;
    item: TASN1_ITEM_EXP;
  end;
  TASN1_TEMPLATE = ASN1_TEMPLATE_st;
  PASN1_TEMPLATE = ^TASN1_TEMPLATE;

  ASN1_ITEM_st = record
    itype: Byte;
    utype: long;
    templates: PASN1_TEMPLATE;
    tcount: long;
    funcs: Pointer;
    size: long;
    sname: PUTF8Char;
  end;
  TASN1_ITEM = ASN1_ITEM_st;

  ASN1_ADB_TABLE_st = record
    value: Integer;
    tt: TASN1_TEMPLATE;
  end;
  TASN1_ADB_TABLE = ASN1_ADB_TABLE_st;
  PASN1_ADB_TABLE = ^TASN1_ADB_TABLE;

  ASN1_ADB_st = record
    flags: Cardinal;
    offset: Cardinal;
    adb_cb: function(psel: PInteger): Integer;
    tbl: PASN1_ADB_TABLE;
    tblcount: Integer;
    default_tt: PASN1_TEMPLATE;
    null_tt: PASN1_TEMPLATE;
  end;
  TASN1_ADB = ASN1_ADB_st;
  PASN1_ADB = ^TASN1_ADB;

  ASN1_TLC_st = record
    valid: Byte;
    ret: Integer;
    plen: Integer;
    ptag: Integer;
    pclass: Integer;
    hdrlen: Integer;
  end;
  TASN1_TLC = ASN1_TLC_st;
  PASN1_TLC = ^TASN1_TLC;

  TASN1_ex_d2i = function(pval: PPASN1_VALUE;const _in: PPByte; len: Integer; const it: PASN1_ITEM; tag: Integer; aclass: Integer; opt: UTF8Char; ctx: PASN1_TLC): Integer;

  TASN1_ex_d2i_ex = function(pval: PPASN1_VALUE;const _in: PPByte; len: Integer; const it: PASN1_ITEM; tag: Integer; aclass: Integer; opt: UTF8Char; ctx: PASN1_TLC; libctx: POSSL_LIB_CTX; const propq: PUTF8Char): Integer;

  TASN1_ex_i2d = function(const pval: PPASN1_VALUE; _out: PPByte; const it: PASN1_ITEM; tag: Integer; aclass: Integer): Integer;

  TASN1_ex_new_func = function(pval: PPASN1_VALUE; const it: PASN1_ITEM): Integer;

  TASN1_ex_new_ex_func = function(pval: PPASN1_VALUE; const it: PASN1_ITEM; libctx: POSSL_LIB_CTX; const propq: PUTF8Char): Integer;

  TASN1_ex_free_func = procedure(pval: PPASN1_VALUE; const it: PASN1_ITEM);

  TASN1_ex_print_func = function(_out: PBIO;const pval: PPASN1_VALUE; indent: Integer; const fname: PUTF8Char; const pctx: PASN1_PCTX): Integer;

  TASN1_primitive_i2c = function(const pval: PPASN1_VALUE; cont: PByte; putype: PInteger; const it: PASN1_ITEM): Integer;

  TASN1_primitive_c2i = function(pval: PPASN1_VALUE; const cont: PByte; len: Integer; utype: Integer; free_cont: PUTF8Char; const it: PASN1_ITEM): Integer;

  TASN1_primitive_print = function(&out: PBIO;const pval: PPASN1_VALUE; const it: PASN1_ITEM; indent: Integer; const pctx: PASN1_PCTX): Integer;

  ASN1_EXTERN_FUNCS_st = record
    app_data: Pointer;
    asn1_ex_new: TASN1_ex_new_func;
    asn1_ex_free: TASN1_ex_free_func;
    asn1_ex_clear: TASN1_ex_free_func;
    asn1_ex_d2i: TASN1_ex_d2i;
    asn1_ex_i2d: TASN1_ex_i2d;
    asn1_ex_print: TASN1_ex_print_func;
    asn1_ex_new_ex: TASN1_ex_new_ex_func;
    asn1_ex_d2i_ex: TASN1_ex_d2i_ex;
  end;
  TASN1_EXTERN_FUNCS = ASN1_EXTERN_FUNCS_st;
  PASN1_EXTERN_FUNCS = ^TASN1_EXTERN_FUNCS;

  ASN1_PRIMITIVE_FUNCS_st = record
    app_data: Pointer;
    flags: Cardinal;
    prim_new: TASN1_ex_new_func;
    prim_free: TASN1_ex_free_func;
    prim_clear: TASN1_ex_free_func;
    prim_c2i: TASN1_primitive_c2i;
    prim_i2c: TASN1_primitive_i2c;
    prim_print: TASN1_primitive_print;
  end;
  TASN1_PRIMITIVE_FUNCS = ASN1_PRIMITIVE_FUNCS_st;
  PASN1_PRIMITIVE_FUNCS  = ^TASN1_PRIMITIVE_FUNCS ;

  TASN1_aux_cb = function(operation: Integer; &in: PPASN1_VALUE; const it: PASN1_ITEM; exarg: Pointer): Integer;
  TASN1_aux_const_cb = function(operation: Integer; &in: PPASN1_VALUE; const it: PASN1_ITEM; exarg: Pointer): Integer;

  ASN1_AUX_st = record
    app_data: Pointer;
    flags: Integer;
    ref_offset: Integer;
    ref_lock: Integer;
    asn1_cb: TASN1_aux_cb;
    enc_offset: Integer;
    asn1_const_cb: TASN1_aux_const_cb;
  end;
  TASN1_AUX = ASN1_AUX_st;
  PASN1_AUX = ^TASN1_AUX;

  ASN1_PRINT_ARG_st = record
    &out: PBIO;
    indent: Integer;
    pctx: PASN1_PCTX;
  end;
  ASN1_PRINT_ARG = ASN1_PRINT_ARG_st;
  ASN1_STREAM_ARG_st = record
    &out: PBIO;
    ndef_bio: PBIO;
    boundary: PPByte;
  end;
  ASN1_STREAM_ARG = ASN1_STREAM_ARG_st;
  sk_ASN1_VALUE_compfunc = function(a: PPASN1_VALUE; b: PPASN1_VALUE): Integer;
  sk_ASN1_VALUE_freefunc = procedure(a: PASN1_VALUE);
  sk_ASN1_VALUE_copyfunc = function(a: PASN1_VALUE): PASN1_VALUE_st;
  PASYNC_JOB = Pointer;
  PPASYNC_JOB = ^PASYNC_JOB;
  PASYNC_WAIT_CTX = Pointer;
  PPASYNC_WAIT_CTX = ^PASYNC_WAIT_CTX;
  bf_key_st = record
    P: array [0..17] of Cardinal;
    S: array [0..4 * 256-1] of Cardinal;
  end;
  TBF_KEY = bf_key_st;
  PBF_KEY = ^TBF_KEY;
  buf_mem_st = record
    length: size_t;
    data: PUTF8Char;
    max: size_t;
    flags: Cardinal;
    buffer: TArray<UTF8Char>;
  end;
  TBUF_MEM = buf_mem_st;
  PBUF_MEM = ^TBUF_MEM;
  PPBUF_MEM = ^PBUF_MEM;
  //TKEY_TABLE_TYPE = array [0..67] of Cardinal;
  TKEY_TABLE_TYPE = array[0..CAMELLIA_TABLE_WORD_LEN-1] of uint;

  camellia_key_st = record
    u: record
       case Integer of
       0: (d: double);               (* ensures 64-bit align *)
       1: (rd_key: TKEY_TABLE_TYPE);
    end;
    grand_rounds: Integer;
  end;
  TCAMELLIA_KEY = camellia_key_st;
  PCAMELLIA_KEY = ^TCAMELLIA_KEY;

  cast_key_st = record
    data: array [0..31] of Cardinal;
    short_key: Integer;
  end;
  TCAST_KEY = cast_key_st;
  PCAST_KEY = ^TCAST_KEY;
  obj_name_st = record
    &type: Integer;
    alias: Integer;
    name: PUTF8Char;
    data: Pointer;//PUTF8Char;
  end;
  TOBJ_NAME = obj_name_st;
  POBJ_NAME = ^TOBJ_NAME;
  EVP_CTRL_TLS1_1_MULTIBLOCK_PARAM = record
    &out: PByte;
    inp: PByte;
    len: size_t;
    interleave: Cardinal;
  end;
  evp_cipher_info_st = record
    cipher: PEVP_CIPHER;
    iv: array [0..15] of Byte;
  end;
  TEVP_CIPHER_INFO = evp_cipher_info_st;
  PEVP_CIPHER_INFO = ^TEVP_CIPHER_INFO;

  PEVP_PKEY_gen_cb = function(ctx: PEVP_PKEY_CTX): Integer;
  PCMAC_CTX = ^TCMAC_CTX;
  PPCMAC_CTX = ^PCMAC_CTX;



  PECPKPARAMETERS = ^TECPKPARAMETERS;
  PPECPKPARAMETERS = ^PECPKPARAMETERS;
  PECPARAMETERS = ^TECPARAMETERS;
  PPECPARAMETERS = ^PECPARAMETERS;
  (********************************************************************)
  EC_builtin_curve = record
    nid: Integer;
    comment: PUTF8Char;
  end;

  
  HASH_LONG = SHA_LONG;
  THASH_CTX = SHAstate_st;
  PHASH_CTX = PSHA_CTX;

  SHA256state_st = record
    h: array [0..7] of Cardinal;
    Nl: Cardinal;
    Nh: Cardinal;
    data: array [0..15] of Cardinal;
    num: Cardinal;
    md_len: Cardinal;
  end;
  TSHA256_CTX = SHA256state_st;

  PSHA256_CTX = ^TSHA256_CTX;
  u_st = record
    case Integer of
      0: (d: array [0..15] of UInt64);
      1: (p: array [0..127] of Byte);
  end;

  SHA512state_st = record
    h: array [0..7] of UInt64;
    Nl: UInt64;
    Nh: UInt64;
    u: u_st;
    num: Cardinal;
    md_len: Cardinal;
  end;
  TSHA512_CTX = SHA512state_st;
  PSHA512_CTX = ^TSHA512_CTX;

  X509_algor_st = record
    algorithm: PASN1_OBJECT;
    parameter: PASN1_TYPE;
  end;
  PX509_ALGORS = Pointer;
  PPX509_ALGORS = ^PX509_ALGORS;
  TX509_ALGOR = X509_algor_st;
  PX509_algor_st = ^X509_algor_st;

  PPX509_ALGOR = ^PX509_ALGOR;
  sk_X509_ALGOR_compfunc = function(a: PPX509_ALGOR; b: PPX509_ALGOR): Integer;
  sk_X509_ALGOR_freefunc = procedure(a: PX509_ALGOR);
  sk_X509_ALGOR_copyfunc = function(a: PX509_ALGOR): PX509_algor_st;

  rsa_pss_params_st = record
    hashAlgorithm: PX509_ALGOR;
    maskGenAlgorithm: PX509_ALGOR;
    saltLength: PASN1_INTEGER;
    trailerField: PASN1_INTEGER;
    maskHash: PX509_ALGOR;
  end;
  TRSA_PSS_PARAMS = rsa_pss_params_st;
 
  rsa_oaep_params_st = record
    hashFunc: PX509_ALGOR;
    maskGenFunc: PX509_ALGOR;
    pSourceFunc: PX509_ALGOR;
    maskHash: PX509_ALGOR;
  end;
  RSA_OAEP_PARAMS = rsa_oaep_params_st;
  PRSA_OAEP_PARAMS = ^RSA_OAEP_PARAMS;
  PPRSA_OAEP_PARAMS = ^PRSA_OAEP_PARAMS;
 
  X509_val_st = record
    notBefore: PASN1_TIME;
    notAfter: PASN1_TIME;
  end;
  X509_VAL = X509_val_st;
  PX509_VAL = ^X509_VAL;
  PPX509_VAL = ^PX509_VAL;
  PX509_SIG = ^TX509_SIG;
  PPX509_SIG = ^PX509_SIG;
  PX509_NAME_ENTRY = ^TX509_NAME_ENTRY;
  PPX509_NAME_ENTRY = ^PX509_NAME_ENTRY;
  sk_X509_NAME_ENTRY_compfunc = function(a: PPX509_NAME_ENTRY; b: PPX509_NAME_ENTRY): Integer;
  sk_X509_NAME_ENTRY_freefunc = procedure(a: PX509_NAME_ENTRY);
  sk_X509_NAME_ENTRY_copyfunc = function(a: PX509_NAME_ENTRY): PX509_name_entry_st;
  sk_X509_NAME_compfunc = function(a: PPX509_NAME; b: PPX509_NAME): Integer;
  sk_X509_NAME_freefunc = procedure(a: PX509_NAME);
  sk_X509_NAME_copyfunc = function(a: PX509_NAME): PX509_name_st;
  PX509_EXTENSION = ^TX509_EXTENSION;
  PPX509_EXTENSION = ^PX509_EXTENSION;
  PX509_EXTENSIONS = Pointer;
  PPX509_EXTENSIONS = ^PX509_EXTENSIONS;
  sk_X509_EXTENSION_compfunc = function(a: PPX509_EXTENSION; b: PPX509_EXTENSION): Integer;
  sk_X509_EXTENSION_freefunc = procedure(a: PX509_EXTENSION);
  sk_X509_EXTENSION_copyfunc = function(a: PX509_EXTENSION): PX509_extension_st;
  PX509_ATTRIBUTE = ^TX509_ATTRIBUTE;
  PPX509_ATTRIBUTE = ^PX509_ATTRIBUTE;
  sk_X509_ATTRIBUTE_compfunc = function(a: PPX509_ATTRIBUTE; b: PPX509_ATTRIBUTE): Integer;
  sk_X509_ATTRIBUTE_freefunc = procedure(a: PX509_ATTRIBUTE);
  sk_X509_ATTRIBUTE_copyfunc = function(a: PX509_ATTRIBUTE): Px509_attributes_st;
  PX509_REQ_INFO = Pointer;
  PPX509_REQ_INFO = ^PX509_REQ_INFO;
  PX509_REQ = ^TX509_REQ;
  PPX509_REQ = ^PX509_REQ;
  PX509_CERT_AUX = ^TX509_CERT_AUX;
  PPX509_CERT_AUX = ^PX509_CERT_AUX;
  { Certinfo }
  x509_cinf_st = record
    version: PASN1_INTEGER;
    serialNumber: PASN1_INTEGER;
    signature: PX509_ALGOR;
    issuer: PX509_NAME;
    validity: PX509_VAL;
    subject: PX509_NAME;
    key: PX509_PUBKEY;
    issuerUID: PASN1_BIT_STRING; // [ 1 ] optional in v2 */
    subjectUID: PASN1_BIT_STRING; // [ 2 ] optional in v2 */
    extensions: Pstack_st_X509_EXTENSION; // [ 3 ] optional in v3 */
    enc: TASN1_ENCODING ;

  end;
  TX509_CINF = x509_cinf_st;
  PX509_CINF = ^TX509_CINF;
  PPX509_CINF = ^PX509_CINF;

  
  stack_st_GENERAL_SUBTREE = record
  end;

  NAME_CONSTRAINTS_st = record
    permittedSubtrees: Pstack_st_GENERAL_SUBTREE;
    excludedSubtrees: Pstack_st_GENERAL_SUBTREE;
  end;
  NAME_CONSTRAINTS = NAME_CONSTRAINTS_st;
  PNAME_CONSTRAINTS = ^NAME_CONSTRAINTS;

  PASIdentifiers = ^TASIdentifiers;
  TX509 = record
    cert_info         : TX509_CINF;
    sig_alg           : TX509_ALGOR;
    signature         : TASN1_BIT_STRING;
    siginf            : TX509_SIG_INFO;
    references        : CRYPTO_REF_COUNT;
    ex_data           : TCRYPTO_EX_DATA;
    ex_pathlen,
    ex_pcpathlen      : long;
    ex_flags,
    ex_kusage,
    ex_xkusage,
    ex_nscert         : uint32;
    skid              : PASN1_OCTET_STRING;
    akid              : PAUTHORITY_KEYID;
    policy_cache      : PX509_POLICY_CACHE;
    crldp             : PSTACK_st_DIST_POINT ;
    altname           : PSTACK_st_GENERAL_NAME ;
    nc                : PNAME_CONSTRAINTS;
{$ifndef OPENSSL_NO_RFC3779}
    rfc3779_addr       :PSTACK_st_IPAddressFamily ;
    rfc3779_asid      : PASIdentifiers;
{$endif}

    sha1_hash         : array[0..(SHA_DIGEST_LENGTH)-1] of byte;
    aux               : PX509_CERT_AUX;
    lock              : PCRYPTO_RWLOCK;
    {$IFNDEF FPC}[volatile]{$ENDIF} ex_cached: Int;
    distinguishing_id : PASN1_OCTET_STRING;
    libctx            : POSSL_LIB_CTX;
    propq             : PUTF8Char;
  end;

  PSTACK_OF_X509_INFO = PSTACK_st;
  PSTACK_OF_X509_ALGOR = PSTACK_st;
  PSTACK_OF_X509 = PSTACK_st;
  PPSTACK_OF_X509 = ^PSTACK_OF_X509;
  PSTACK_OF_X509_CRL = PSTACK_st;
  PSTACK_OF_PKCS7_SIGNER_INFO = PSTACK_st;
  PSTACK_OF_X509_ATTRIBUTE = PSTACK_st;
  PSTACK = PSTACK_st;
  sk_X509_compfunc = function(a: PPX509; b: PPX509): Integer;
  sk_X509_freefunc = procedure(a: PX509);
  sk_X509_copyfunc = function(a: PX509): Px509_st;

  Px509_trust_st = ^x509_trust_st;
  PX509_TRUST = ^TX509_TRUST;
  PPX509_TRUST = ^PX509_TRUST;
  Tcheck_trust_func = function(p1: PX509_TRUST; p2: PX509; p3: Integer): Integer;
  x509_trust_st = record
    trust: Integer;
    flags: Integer;
    check_trust: Tcheck_trust_func;
    name: PUTF8Char;
    arg1: Integer;
    arg2: Pointer;
  end;
  TX509_TRUST = x509_trust_st;

  sk_X509_TRUST_compfunc = function(a: PPX509_TRUST; b: PPX509_TRUST): Integer;
  sk_X509_TRUST_freefunc = procedure(a: PX509_TRUST);
  sk_X509_TRUST_copyfunc = function(a: PX509_TRUST): Px509_trust_st;
  sk_X509_REVOKED_compfunc = function(const a, b: PPX509_REVOKED): Integer;
  sk_X509_REVOKED_freefunc = procedure(a: PX509_REVOKED);
  sk_X509_REVOKED_copyfunc = function(a: PX509_REVOKED): Px509_revoked_st;
  PX509_CRL_INFO = ^TX509_CRL_INFO;
  PPX509_CRL_INFO = ^PX509_CRL_INFO;
  sk_X509_CRL_compfunc = function(a: PPX509_CRL; b: PPX509_CRL): Integer;
  sk_X509_CRL_freefunc = procedure(a: PX509_CRL);
  sk_X509_CRL_copyfunc = function(a: PX509_CRL): PX509_crl_st;
  private_key_st = record
    version: Integer;
    enc_algor: PX509_ALGOR;
    enc_pkey: PASN1_OCTET_STRING;
    dec_pkey: PEVP_PKEY;
    key_length: Integer;
    key_data: PUTF8Char;
    key_free: Integer;
    cipher: TEVP_CIPHER_INFO;
  end;
  X509_PKEY = private_key_st;
  PX509_PKEY = ^X509_PKEY;
  X509_info_st = record
    x509: PX509;
    crl: PX509_CRL;
    x_pkey: PX509_PKEY;
    enc_cipher: TEVP_CIPHER_INFO;
    enc_len: Integer;
    enc_data: PUTF8Char;
  end;

  X509_crl_info_st = record
    version: PASN1_INTEGER;
    sig_alg: TX509_ALGOR;
    issuer: PX509_NAME;
    lastUpdate: PASN1_TIME;
    nextUpdate: PASN1_TIME;
    revoked: Pstack_st_X509_REVOKED;
    extensions: Pstack_st_X509_EXTENSION;
    enc: TASN1_ENCODING;
  end;
  TX509_CRL_INFO = X509_crl_info_st;

  X509_crl_st = record
    crl             : TX509_CRL_INFO;
    sig_alg         : TX509_ALGOR;
    signature       : TASN1_BIT_STRING;
    references      : CRYPTO_REF_COUNT;
    flags           : integer;
    akid            : PAUTHORITY_KEYID;
    idp             : PISSUING_DIST_POINT;
    idp_flags,
    idp_reasons     : integer;
    crl_number,
    base_crl_number : PASN1_INTEGER;
    issuers         : Pstack_st_GENERAL_NAMES ;

    sha1_hash       : array[0..(SHA_DIGEST_LENGTH)-1] of byte;
    meth            : PX509_CRL_METHOD;
    meth_data       : Pointer;
    lock            : PCRYPTO_RWLOCK;
    libctx          : POSSL_LIB_CTX;
    propq           : PUTF8Char;
 end;
  TX509_CRL = X509_crl_st;
  PX509_STORE_CTX = ^TX509_STORE_CTX;
  Tverify_func = function (ctx: PX509_STORE_CTX): Integer;
  Tverify_cb_func =  function(ok: Integer; ctx: PX509_STORE_CTX): Integer;
  Tget_issuer_func = function( issuer: PPX509; ctx: PX509_STORE_CTX; x: PX509): Integer;
  Tcheck_issued_func = function ( ctx : PX509_STORE_CTX; var x, issuer : TX509):integer;
  Tcheck_revocation_func = function (ctx : PX509_STORE_CTX):integer;
  Tget_crl_func = function (ctx : PX509_STORE_CTX; crl : PPX509_CRL; x : TX509):integer;
  Tcheck_crl_func = function (ctx : PX509_STORE_CTX; crl : TX509_CRL):integer;
  Tcert_crl_func = function (ctx : PX509_STORE_CTX; crl : TX509_CRL; x : TX509):integer;
  Tcheck_policy_func = function (ctx : PX509_STORE_CTX):integer;
  Tlookup_certs_func = function (ctx: PX509_STORE_CTX ; const nm: PX509_NAME): Pstack_st_X509;
  Tlookup_crls_func = function (const ctx: PX509_STORE_CTX ; const nm: PX509_NAME): Pstack_st_X509_CRL;
  Tcleanup_func = function (var TX509_STORE_CTX): integer;

  //
  X509_VERIFY_PARAM_st = record
    name: PUTF8Char;
    check_time: Longint;
    inh_flags: UInt32;
    flags: Cardinal;
    purpose: Integer;
    trust: Integer;
    depth: Integer;
    auth_level: Integer;
    policies: Pstack_st_ASN1_OBJECT;
    hosts: Pstack_st_OPENSSL_STRING;
    hostflags: Cardinal;
    peername: PUTF8Char;
    email: PUTF8Char;
    emaillen: size_t;
    ip: PByte;
    iplen: size_t;
  end;
  TX509_VERIFY_PARAM = X509_VERIFY_PARAM_st;
  
  X509_INFO = X509_info_st;
  PX509_info_st = ^X509_info_st;
  PX509_INFO = ^X509_INFO;
  PPX509_INFO = ^PX509_INFO;
  sk_X509_INFO_compfunc = function(a: PPX509_INFO; b: PPX509_INFO): Integer;
  sk_X509_INFO_freefunc = procedure(a: PX509_INFO);
  sk_X509_INFO_copyfunc = function(a: PX509_INFO): PX509_info_st;
  Netscape_spkac_st = record
    pubkey: PX509_PUBKEY;
    challenge: PASN1_IA5STRING;
  end;
  NETSCAPE_SPKAC = Netscape_spkac_st;
  PNETSCAPE_SPKAC = ^NETSCAPE_SPKAC;
  PPNETSCAPE_SPKAC = ^PNETSCAPE_SPKAC;
  Netscape_spki_st = record
    spkac: PNETSCAPE_SPKAC;
    sig_algor: TX509_ALGOR;
    signature: PASN1_BIT_STRING;
  end;
  NETSCAPE_SPKI = Netscape_spki_st;
  PNETSCAPE_SPKI = ^NETSCAPE_SPKI;
  PPNETSCAPE_SPKI = ^PNETSCAPE_SPKI;
  Netscape_certificate_sequence = record
    &type: PASN1_OBJECT;
    certs: Pstack_st_X509;
  end;
  NETSCAPE_CERT_SEQUENCE = Netscape_certificate_sequence;
  PNETSCAPE_CERT_SEQUENCE = ^NETSCAPE_CERT_SEQUENCE;
  PPNETSCAPE_CERT_SEQUENCE = ^PNETSCAPE_CERT_SEQUENCE;
  PBEPARAM_st = record
    salt: PASN1_OCTET_STRING;
    iter: PASN1_INTEGER;
  end;
  PBEPARAM = PBEPARAM_st;
  PPBEPARAM = ^PBEPARAM;
  PPPBEPARAM = ^PPBEPARAM;
  PBE2PARAM_st = record
    keyfunc: PX509_ALGOR;
    encryption: PX509_ALGOR;
  end;
  PBE2PARAM = PBE2PARAM_st;
  PPBE2PARAM = ^PBE2PARAM;
  PPPBE2PARAM = ^PPBE2PARAM;

  PBKDF2PARAM_st = record
    salt: PASN1_TYPE;
    iter: PASN1_INTEGER;
    keylength: PASN1_INTEGER;
    prf: PX509_ALGOR;
  end;
  TPBKDF2PARAM = PBKDF2PARAM_st;
  PPBKDF2PARAM = ^TPBKDF2PARAM;
  PPPBKDF2PARAM = ^PPBKDF2PARAM;
  SCRYPT_PARAMS_st = record
    salt: PASN1_OCTET_STRING;
    costParameter: PASN1_INTEGER;
    blockSize: PASN1_INTEGER;
    parallelizationParameter: PASN1_INTEGER;
    keyLength: PASN1_INTEGER;
  end;
  SCRYPT_PARAMS = SCRYPT_PARAMS_st;
  PSCRYPT_PARAMS = ^SCRYPT_PARAMS;
  PPSCRYPT_PARAMS = ^PSCRYPT_PARAMS;




  PPOPENSSL_LH_NODE = ^POPENSSL_LH_NODE;
  TOPENSSL_LH_COMPFUNC = function(const p1, p2: Pointer): Integer;
  TOPENSSL_LH_HASHFUNC = function(const p1: Pointer): Uint32;
  TOPENSSL_LH_DOALL_FUNC = procedure(p1: Pointer);
  TOPENSSL_LH_DOALL_FUNCARG = procedure(p1, p2: Pointer);

  PPOPENSSL_LHASH = ^POPENSSL_LHASH;
  lh_OPENSSL_STRING_dummy = record
    case Integer of
      0: (d1: Pointer);
      1: (d2: Cardinal);
      2: (d3: Integer);
  end;
  lhash_st_OPENSSL_STRING = record
    dummy: lh_OPENSSL_STRING_dummy;
  end;
  lh_OPENSSL_CSTRING_dummy = record
    case Integer of
      0: (d1: Pointer);
      1: (d2: Cardinal);
      2: (d3: Integer);
  end;
  lhash_st_OPENSSL_CSTRING = record
    dummy: lh_OPENSSL_CSTRING_dummy;
  end;
  X509_LOOKUP_TYPE = (
    X509_LU_NONE = 0,
    X509_LU_X509 = 1,
    X509_LU_CRL = 2);
  PX509_LOOKUP_TYPE = ^X509_LOOKUP_TYPE;
  sk_X509_LOOKUP_compfunc = function(a: PPX509_LOOKUP; b: PPX509_LOOKUP): Integer;
  sk_X509_LOOKUP_freefunc = procedure(a: PX509_LOOKUP);
  sk_X509_LOOKUP_copyfunc = function(a: PX509_LOOKUP): Px509_lookup_st;
  sk_X509_OBJECT_compfunc = function(a: PPX509_OBJECT; b: PPX509_OBJECT): Integer;
  sk_X509_OBJECT_freefunc = procedure(a: PX509_OBJECT);
  sk_X509_OBJECT_copyfunc = function(a: PX509_OBJECT): Px509_object_st;
  sk_X509_VERIFY_PARAM_compfunc = function(a: PPX509_VERIFY_PARAM; b: PPX509_VERIFY_PARAM): Integer;
  sk_X509_VERIFY_PARAM_freefunc = procedure(a: PX509_VERIFY_PARAM);
  sk_X509_VERIFY_PARAM_copyfunc = function(a: PX509_VERIFY_PARAM): PX509_VERIFY_PARAM_st;
  X509_STORE_CTX_verify_cb = function(p1: Integer; p2: PX509_STORE_CTX): Integer;
  X509_STORE_CTX_verify_fn = function(p1: PX509_STORE_CTX): Integer;
  X509_STORE_CTX_get_issuer_fn = function(issuer: PPX509; ctx: PX509_STORE_CTX; x: PX509): Integer;
  X509_STORE_CTX_check_issued_fn = function(ctx: PX509_STORE_CTX; x: PX509; issuer: PX509): Integer;
  X509_STORE_CTX_check_revocation_fn = function(ctx: PX509_STORE_CTX): Integer;
  X509_STORE_CTX_get_crl_fn = function(ctx: PX509_STORE_CTX; crl: PPX509_CRL; x: PX509): Integer;
  X509_STORE_CTX_check_crl_fn = function(ctx: PX509_STORE_CTX; crl: PX509_CRL): Integer;
  X509_STORE_CTX_cert_crl_fn = function(ctx: PX509_STORE_CTX; crl: PX509_CRL; x: PX509): Integer;
  X509_STORE_CTX_check_policy_fn = function(ctx: PX509_STORE_CTX): Integer;
  X509_STORE_CTX_lookup_certs_fn = function(ctx: PX509_STORE_CTX; const nm: PX509_NAME): Pstack_st_X509;
  X509_STORE_CTX_lookup_crls_fn = function(const ctx: PX509_STORE_CTX; const nm: PX509_NAME): Pstack_st_X509_CRL;
  X509_STORE_CTX_cleanup_fn = function(ctx: PX509_STORE_CTX): Integer;
  X509_LOOKUP_ctrl_fn = function(ctx: PX509_LOOKUP; cmd: Integer; argc: PUTF8Char; argl: Integer; ret: PPUTF8Char): Integer;
  X509_LOOKUP_get_by_subject_fn = function(ctx: PX509_LOOKUP; &type: X509_LOOKUP_TYPE; name: PX509_NAME; ret: PX509_OBJECT): Integer;
  X509_LOOKUP_get_by_issuer_serial_fn = function(ctx: PX509_LOOKUP; &type: X509_LOOKUP_TYPE; name: PX509_NAME; serial: PASN1_INTEGER; ret: PX509_OBJECT): Integer;
  X509_LOOKUP_get_by_fingerprint_fn = function(ctx: PX509_LOOKUP; &type: X509_LOOKUP_TYPE; bytes: PByte; len: Integer; ret: PX509_OBJECT): Integer;
  X509_LOOKUP_get_by_alias_fn = function(ctx: PX509_LOOKUP; &type: X509_LOOKUP_TYPE; str: PUTF8Char; len: Integer; ret: PX509_OBJECT): Integer;
  pkcs7_issuer_and_serial_st = record
    issuer: PX509_NAME;
    serial: PASN1_INTEGER;
  end;
  PKCS7_ISSUER_AND_SERIAL = pkcs7_issuer_and_serial_st;
  PPKCS7_ISSUER_AND_SERIAL = ^PKCS7_ISSUER_AND_SERIAL;
  PPPKCS7_ISSUER_AND_SERIAL = ^PPKCS7_ISSUER_AND_SERIAL;
  pkcs7_signer_info_st = record
    version: PASN1_INTEGER;
    issuer_and_serial: PPKCS7_ISSUER_AND_SERIAL;
    digest_alg: PX509_ALGOR;
    auth_attr: Pstack_st_X509_ATTRIBUTE;
    digest_enc_alg: PX509_ALGOR;
    enc_digest: PASN1_OCTET_STRING;
    unauth_attr: Pstack_st_X509_ATTRIBUTE;
    pkey: PEVP_PKEY;
  end;
  PKCS7_SIGNER_INFO = pkcs7_signer_info_st;
  Ppkcs7_signer_info_st = ^pkcs7_signer_info_st;
  PPKCS7_SIGNER_INFO = ^PKCS7_SIGNER_INFO;
  PPPKCS7_SIGNER_INFO = ^PPKCS7_SIGNER_INFO;
  sk_PKCS7_SIGNER_INFO_compfunc = function(a: PPPKCS7_SIGNER_INFO; b: PPPKCS7_SIGNER_INFO): Integer;
  sk_PKCS7_SIGNER_INFO_freefunc = procedure(a: PPKCS7_SIGNER_INFO);
  sk_PKCS7_SIGNER_INFO_copyfunc = function(a: PPKCS7_SIGNER_INFO): Ppkcs7_signer_info_st;
  pkcs7_recip_info_st = record
    version: PASN1_INTEGER;
    issuer_and_serial: PPKCS7_ISSUER_AND_SERIAL;
    key_enc_algor: PX509_ALGOR;
    enc_key: PASN1_OCTET_STRING;
    cert: PX509;
  end;
  PKCS7_RECIP_INFO = pkcs7_recip_info_st;
  Ppkcs7_recip_info_st = ^pkcs7_recip_info_st;
  PPKCS7_RECIP_INFO = ^PKCS7_RECIP_INFO;
  PPPKCS7_RECIP_INFO = ^PPKCS7_RECIP_INFO;
  sk_PKCS7_RECIP_INFO_compfunc = function(a: PPPKCS7_RECIP_INFO; b: PPPKCS7_RECIP_INFO): Integer;
  sk_PKCS7_RECIP_INFO_freefunc = procedure(a: PPKCS7_RECIP_INFO);
  sk_PKCS7_RECIP_INFO_copyfunc = function(a: PPKCS7_RECIP_INFO): Ppkcs7_recip_info_st;

  Ppkcs7_st = ^pkcs7_st;
  pkcs7_signed_st = record
    version: PASN1_INTEGER;
    md_algs: Pstack_st_X509_ALGOR;
    cert: Pstack_st_X509;
    crl: Pstack_st_X509_CRL;
    signer_info: Pstack_st_PKCS7_SIGNER_INFO;
    contents: Ppkcs7_st;
  end;
  PKCS7_SIGNED = pkcs7_signed_st;
  PPKCS7_SIGNED = ^PKCS7_SIGNED;
  PPPKCS7_SIGNED = ^PPKCS7_SIGNED;
  pkcs7_enc_content_st = record
    content_type: PASN1_OBJECT;
    algorithm: PX509_ALGOR;
    enc_data: PASN1_OCTET_STRING;
    cipher: PEVP_CIPHER;
  end;
  PKCS7_ENC_CONTENT = pkcs7_enc_content_st;
  PPKCS7_ENC_CONTENT = ^PKCS7_ENC_CONTENT;
  PPPKCS7_ENC_CONTENT = ^PPKCS7_ENC_CONTENT;
  pkcs7_enveloped_st = record
    version: PASN1_INTEGER;
    recipientinfo: Pstack_st_PKCS7_RECIP_INFO;
    enc_data: PPKCS7_ENC_CONTENT;
  end;
  PKCS7_ENVELOPE = pkcs7_enveloped_st;
  PPKCS7_ENVELOPE = ^PKCS7_ENVELOPE;
  PPPKCS7_ENVELOPE = ^PPKCS7_ENVELOPE;
  pkcs7_signedandenveloped_st = record
    version: PASN1_INTEGER;
    md_algs: Pstack_st_X509_ALGOR;
    cert: Pstack_st_X509;
    crl: Pstack_st_X509_CRL;
    signer_info: Pstack_st_PKCS7_SIGNER_INFO;
    enc_data: PPKCS7_ENC_CONTENT;
    recipientinfo: Pstack_st_PKCS7_RECIP_INFO;
  end;
  PKCS7_SIGN_ENVELOPE = pkcs7_signedandenveloped_st;
  PPKCS7_SIGN_ENVELOPE = ^PKCS7_SIGN_ENVELOPE;
  PPPKCS7_SIGN_ENVELOPE = ^PPKCS7_SIGN_ENVELOPE;
  pkcs7_digest_st = record
    version: PASN1_INTEGER;
    md: PX509_ALGOR;
    contents: Ppkcs7_st;
    digest: PASN1_OCTET_STRING;
  end;
  PKCS7_DIGEST = pkcs7_digest_st;
  PPKCS7_DIGEST = ^PKCS7_DIGEST;
  PPPKCS7_DIGEST = ^PPKCS7_DIGEST;
  pkcs7_encrypted_st = record
    version: PASN1_INTEGER;
    enc_data: PPKCS7_ENC_CONTENT;
  end;
  _PKCS7_ENCRYPT = pkcs7_encrypted_st;
  PPKCS7_ENCRYPT = ^_PKCS7_ENCRYPT;
  PPPKCS7_ENCRYPT = ^PPKCS7_ENCRYPT;
  _anonymous_type_4 = record
    case Integer of
      0: (ptr: PUTF8Char);
      1: (data: PASN1_OCTET_STRING);
      2: (sign: PPKCS7_SIGNED);
      3: (enveloped: PPKCS7_ENVELOPE);
      4: (signed_and_enveloped: PPKCS7_SIGN_ENVELOPE);
      5: (digest: PPKCS7_DIGEST);
      6: (encrypted: PPKCS7_ENCRYPT);
      7: (other: PASN1_TYPE);
  end;
  P_anonymous_type_4 = ^_anonymous_type_4;
  pkcs7_st = record
    asn1: PByte;
    length: Integer;
    state: Integer;
    detached: Integer;
    &type: PASN1_OBJECT;
    d: _anonymous_type_4;
  end;
  PKCS7 = pkcs7_st;
  PPKCS7 = ^PKCS7;
  PPPKCS7 = ^PPKCS7;
  sk_PKCS7_compfunc = function(a: PPPKCS7; b: PPPKCS7): Integer;
  sk_PKCS7_freefunc = procedure(a: PPKCS7);
  sk_PKCS7_copyfunc = function(a: PPKCS7): Ppkcs7_st;
  TCONF_VALUE = record
    section: PUTF8Char;
    name: PUTF8Char;
    value: PUTF8Char;
  end;
  PCONF_VALUE = ^TCONF_VALUE;
  PPCONF_VALUE = ^PCONF_VALUE;
  sk_CONF_VALUE_compfunc = function(a: PPCONF_VALUE; b: PPCONF_VALUE): Integer;
  sk_CONF_VALUE_freefunc = procedure(a: Pointer); //PCONF_VALUE);
  sk_CONF_VALUE_copyfunc = function(a: PCONF_VALUE): PCONF_VALUE;
  lh_CONF_VALUE_dummy = record
    case Integer of
      0: (d1: Pointer);
      1: (d2: Cardinal);
      2: (d3: Integer);
  end;
  lhash_st_CONF_VALUE = record
    dummy: lh_CONF_VALUE_dummy;
  end;

  Pconf_st = ^conf_st;
  PCONF_METHOD = ^TCONF_METHOD;
  conf_method_st = record
    name: PUTF8Char;
    create: function(meth: PCONF_METHOD): Pconf;
    init: function(conf: PCONF): Integer;
    destroy: function(conf: PCONF): Integer;
    destroy_data: function(conf: PCONF): Integer;
    load_bio: function(conf: PCONF; bp: PBIO; eline: PLong): Integer;
    dump: function(const conf: PCONF; bp: PBIO): Integer;
    is_number: function(const conf: PCONF; c: UTF8Char): Integer;
    to_int: function(const conf: PCONF; c: UTF8Char): Integer;
    load: function(conf: PCONF;const name: PUTF8Char; eline: PLong): Integer;
  end;
  TCONF_METHOD = conf_method_st;

  PCONF_IMODULE = ^TCONF_IMODULE;
  PPCONF_IMODULE = ^PCONF_IMODULE;
  PCONF_MODULE = ^TCONF_MODULE;
  PPCONF_MODULE = ^PCONF_MODULE;
  sk_CONF_MODULE_compfunc = function(a: PPCONF_MODULE; b: PPCONF_MODULE): Integer;
  sk_CONF_MODULE_freefunc = procedure(a: PCONF_MODULE);
  sk_CONF_MODULE_copyfunc = function(a: PCONF_MODULE): Pconf_module_st;
  sk_CONF_IMODULE_compfunc = function(a: PPCONF_IMODULE; b: PPCONF_IMODULE): Integer;
  sk_CONF_IMODULE_freefunc = procedure(a: PCONF_IMODULE);
  sk_CONF_IMODULE_copyfunc = function(a: PCONF_IMODULE): Pconf_imodule_st;
  Tconf_init_func = function(md: PCONF_IMODULE; const cnf: PCONF): Integer;
  Tconf_finish_func = procedure(md: PCONF_IMODULE);
  Plhash_st_CONF_VALUE = ^lhash_st_CONF_VALUE;

  conf_st = record
    meth          : PCONF_METHOD;
    meth_data     : Pointer;
    data          : Plhash_st_CONF_VALUE;
    flag_dollarid,
    flag_abspath  : integer;
    includedir    : PUTF8Char;
    libctx        : POSSL_LIB_CTX;
    class function Empty: conf_st; static;
  end;

  TCONF = conf_st;
  Pv3_ext_method = ^v3_ext_method;
  Pv3_ext_ctx = ^v3_ext_ctx;
  PX509V3_CTX = Pv3_ext_ctx;// ^TX509V3_CTX;

  TX509V3_EXT_NEW = function(): Pointer;
  TX509V3_EXT_FREE = procedure(p1: Pointer);
  TX509V3_EXT_D2I = function(p1: Pointer; p2: PPByte; p3: Integer): Pointer;
  TX509V3_EXT_I2D = function(const p1: Pointer; p2: PPByte): Integer;
  TX509V3_EXT_I2V = function(const method: Pv3_ext_method; ext: Pointer; extlist: Pstack_st_CONF_VALUE): Pstack_st_CONF_VALUE;
  TX509V3_EXT_V2I = function(const method: Pv3_ext_method; ctx: Pv3_ext_ctx; values: Pstack_st_CONF_VALUE): Pointer;
  TX509V3_EXT_I2S = function(const method: Pv3_ext_method; ext: Pointer): PUTF8Char;
  TX509V3_EXT_S2I = function(const method: Pv3_ext_method; ctx: Pv3_ext_ctx;const str: PUTF8Char): Pointer;
  TX509V3_EXT_I2R = function(const method: Pv3_ext_method; ext: Pointer; _out: PBIO; indent: Integer): Integer;
  TX509V3_EXT_R2I = function(method: Pv3_ext_method; ctx: Pv3_ext_ctx; str: PUTF8Char): Pointer;

  PX509V3_EXT_S2I = ^TX509V3_EXT_S2I;
  PX509V3_EXT_I2S = ^TX509V3_EXT_I2S;
  PX509V3_EXT_I2R = ^TX509V3_EXT_I2R;
  PX509V3_EXT_R2I = ^TX509V3_EXT_R2I;
  PX509V3_EXT_I2V = ^TX509V3_EXT_I2V;
  PX509V3_EXT_V2I = ^TX509V3_EXT_V2I;
  PX509V3_EXT_FREE = ^TX509V3_EXT_FREE;
  PX509V3_EXT_D2I = ^TX509V3_EXT_D2I;
  PX509V3_EXT_I2D = ^TX509V3_EXT_I2D;

  v3_ext_method = record
    ext_nid: Integer;
    ext_flags: Integer;
    it: TASN1_ITEM_EXP;
    ext_new: TX509V3_EXT_NEW;
    ext_free: TX509V3_EXT_FREE;
    d2i: TX509V3_EXT_D2I;
    i2d: TX509V3_EXT_I2D;
    i2s: TX509V3_EXT_I2S;
    s2i: TX509V3_EXT_S2I;
    i2v: TX509V3_EXT_I2V;
    v2i: TX509V3_EXT_V2I;
    i2r: TX509V3_EXT_I2R;
    r2i: TX509V3_EXT_R2I;
    usr_data: Pointer;
  end;

  X509V3_CONF_METHOD_st = record
    get_string: function(db: Pointer; section: PUTF8Char; value: PUTF8Char): PUTF8Char;
    get_section: function(db: Pointer; section: PUTF8Char): Pstack_st_CONF_VALUE;
    free_string: procedure(db: Pointer; &string: PUTF8Char);
    free_section: procedure(db: Pointer; section: Pstack_st_CONF_VALUE);
  end;
  X509V3_CONF_METHOD = X509V3_CONF_METHOD_st;
  PX509V3_CONF_METHOD = ^X509V3_CONF_METHOD;

  v3_ext_ctx = record
    flags: Integer;
    issuer_cert: PX509;
    subject_cert: PX509;
    subject_req: PX509_REQ;
    crl: PX509_CRL;
    db_meth: PX509V3_CONF_METHOD;
    db: Pointer;
    issuer_pkey: PEVP_PKEY;
  end;
  TX509V3_CTX = v3_ext_ctx;
  TX509V3_EXT_METHOD = v3_ext_method;
  PX509V3_EXT_METHOD = Pv3_ext_method;//^TX509V3_EXT_METHOD;

  PPX509V3_EXT_METHOD = ^PX509V3_EXT_METHOD;
  sk_X509V3_EXT_METHOD_compfunc = function(a: PPX509V3_EXT_METHOD; b: PPX509V3_EXT_METHOD): Integer;
  sk_X509V3_EXT_METHOD_freefunc = procedure(a: PX509V3_EXT_METHOD);
  sk_X509V3_EXT_METHOD_copyfunc = function(a: PX509V3_EXT_METHOD): Pv3_ext_method;
  ENUMERATED_NAMES = TBIT_STRING_BITNAME;
  BASIC_CONSTRAINTS_st = record
    ca: Integer;
    pathlen: PASN1_INTEGER;
  end;
  BASIC_CONSTRAINTS = BASIC_CONSTRAINTS_st;
  PBASIC_CONSTRAINTS = ^BASIC_CONSTRAINTS;
  PPBASIC_CONSTRAINTS = ^PBASIC_CONSTRAINTS;
  PKEY_USAGE_PERIOD_st = record
    notBefore: PASN1_GENERALIZEDTIME;
    notAfter: PASN1_GENERALIZEDTIME;
  end;
  PKEY_USAGE_PERIOD = PKEY_USAGE_PERIOD_st;
  PPKEY_USAGE_PERIOD = ^PKEY_USAGE_PERIOD;
  PPPKEY_USAGE_PERIOD = ^PPKEY_USAGE_PERIOD;
  otherName_st = record
    type_id: PASN1_OBJECT;
    value: PASN1_TYPE;
  end;
  OTHERNAME = otherName_st;
  POTHERNAME = ^OTHERNAME;
  PPOTHERNAME = ^POTHERNAME;
  EDIPartyName_st = record
    nameAssigner: PASN1_STRING;
    partyName: PASN1_STRING;
  end;
  TEDIPARTYNAME = EDIPartyName_st;
  PEDIPARTYNAME = ^TEDIPARTYNAME;
  PPEDIPARTYNAME = ^PEDIPARTYNAME;

  GENERAL_NAME_st = record
    &type: Integer;
    d: record
    case Integer of
      0: (ptr: PUTF8Char);
      1: (otherName: POTHERNAME);
      2: (rfc822Name: PASN1_IA5STRING);
      3: (dNSName: PASN1_IA5STRING);
      4: (x400Address: PASN1_TYPE);
      5: (directoryName: PX509_NAME);
      6: (ediPartyName: PEDIPARTYNAME);
      7: (uniformResourceIdentifier: PASN1_IA5STRING);
      8: (iPAddress: PASN1_OCTET_STRING);
      9: (registeredID: PASN1_OBJECT);
      10: (ip: PASN1_OCTET_STRING);
      11: (dirn: PX509_NAME);
      12: (ia5: PASN1_IA5STRING);
      13: (rid: PASN1_OBJECT);
      14: (other: PASN1_TYPE);
    end;
  end;
  TGENERAL_NAME = GENERAL_NAME_st;
  PGENERAL_NAME = ^TGENERAL_NAME;
  PPGENERAL_NAME = ^PGENERAL_NAME;
  ACCESS_DESCRIPTION_st = record
    method: PASN1_OBJECT;
    location: PGENERAL_NAME;
  end;
  ACCESS_DESCRIPTION = ACCESS_DESCRIPTION_st;
  PACCESS_DESCRIPTION = ^ACCESS_DESCRIPTION;
  PPACCESS_DESCRIPTION = ^PACCESS_DESCRIPTION;
  PAUTHORITY_INFO_ACCESS = Pointer;
  PPAUTHORITY_INFO_ACCESS = ^PAUTHORITY_INFO_ACCESS;
  PEXTENDED_KEY_USAGE = Pointer;
  PPEXTENDED_KEY_USAGE = ^PEXTENDED_KEY_USAGE;
  PTLS_FEATURE = Pointer;
  PPTLS_FEATURE = ^PTLS_FEATURE;
  Pconf_method_st = ^conf_method_st;


  PX509V3_CONF_METHOD_st = ^X509V3_CONF_METHOD_st;

  PBASIC_CONSTRAINTS_st = ^BASIC_CONSTRAINTS_st;
  PPKEY_USAGE_PERIOD_st = ^PKEY_USAGE_PERIOD_st;
  PotherName_st = ^otherName_st;
  PEDIPartyName_st = ^EDIPartyName_st;
  PGENERAL_NAME_st = ^GENERAL_NAME_st;
  PACCESS_DESCRIPTION_st = ^ACCESS_DESCRIPTION_st;
  PDIST_POINT_NAME_st = ^DIST_POINT_NAME_st;
  PDIST_POINT_st = ^DIST_POINT_st;
  PAUTHORITY_KEYID_st = ^AUTHORITY_KEYID_st;
  PSXNET_ID_st = ^SXNET_ID_st;
  PSXNET_st = ^SXNET_st;
  PNOTICEREF_st = ^NOTICEREF_st;
  PUSERNOTICE_st = ^USERNOTICE_st;
  PPOLICYQUALINFO_st = ^POLICYQUALINFO_st;
  PPOLICYINFO_st = ^POLICYINFO_st;
  PPOLICY_MAPPING_st = ^POLICY_MAPPING_st;
  PGENERAL_SUBTREE_st = ^GENERAL_SUBTREE_st;
  PNAME_CONSTRAINTS_st = ^NAME_CONSTRAINTS_st;
  PPOLICY_CONSTRAINTS_st = ^POLICY_CONSTRAINTS_st;
  PPROXY_POLICY_st = ^PROXY_POLICY_st;
  PPROXY_CERT_INFO_EXTENSION_st = ^PROXY_CERT_INFO_EXTENSION_st;
  PISSUING_DIST_POINT_st = ^ISSUING_DIST_POINT_st;
  Px509_purpose_st = ^x509_purpose_st;
  PASRange_st = ^ASRange_st;
  PASIdOrRange_st = ^ASIdOrRange_st;
  PASIdentifierChoice_st = ^ASIdentifierChoice_st;

  PIPAddressRange_st = ^IPAddressRange_st;
  PIPAddressOrRange_st = ^IPAddressOrRange_st;
  PIPAddressChoice_st = ^IPAddressChoice_st;
  PIPAddressFamily_st = ^IPAddressFamily_st;
  PDES_ks = ^DES_ks;
  Prand_meth_st = ^rand_meth_st;
  Perr_state_st = ^err_state_st;
  PERR_string_data_st = ^ERR_string_data_st;
  Plhash_st_ERR_STRING_DATA = ^lhash_st_ERR_STRING_DATA;
  PENGINE_CMD_DEFN_st = ^ENGINE_CMD_DEFN_st;
  Pdynamic_fns = ^dynamic_fns;

  dyn_MEM_malloc_fn = function(p1: size_t; p2: PUTF8Char; p3: Integer): Pointer;
  dyn_MEM_realloc_fn = function(p1: Pointer; p2: size_t; p3: PUTF8Char; p4: Integer): Pointer;
  dyn_MEM_free_fn = procedure(p1: Pointer; p2: PUTF8Char; p3: Integer);

  dynamic_v_check_fn = function(ossl_version: Cardinal): Cardinal;
  dynamic_bind_engine = function(e: PENGINE; id: PUTF8Char; fns: Pdynamic_fns): Integer;
  //IDEA_INT = Cardinal;
  idea_key_st = record
    data: array [0..8, 0..5] of IDEA_INT;
  end;
  st_dynamic_MEM_fns = record
    malloc_fn: dyn_MEM_malloc_fn;
    realloc_fn: dyn_MEM_realloc_fn;
    free_fn: dyn_MEM_free_fn;
  end;
  dynamic_MEM_fns = st_dynamic_MEM_fns;
  st_dynamic_fns = record
    static_state: Pointer;
    mem_fns: dynamic_MEM_fns;
  end;
  dynamic_fns = st_dynamic_fns;


  Pst_dynamic_MEM_fns = ^st_dynamic_MEM_fns;
  Pst_dynamic_fns = ^st_dynamic_fns;
  Pidea_key_st = ^idea_key_st;
  PMD4state_st = ^MD4state_st;

  Prc2_key_st = ^rc2_key_st;
  Prc4_key_st = ^rc4_key_st;
  PRIPEMD160state_st = ^RIPEMD160state_st;
  Pseed_key_st = ^seed_key_st;
  PSRP_gN_cache_st = ^SRP_gN_cache_st;
  PSRP_user_pwd_st = ^SRP_user_pwd_st;
  PSRP_VBASE_st = ^SRP_VBASE_st;
  PSRP_gN_st = ^SRP_gN_st;
  Psrtp_protection_profile_st = ^srtp_protection_profile_st;
  Ptls_session_ticket_ext_st = ^tls_session_ticket_ext_st;
  Ptxt_db_st = ^txt_db_st;
  PWHIRLPOOL_CTX = ^WHIRLPOOL_CTX;
  TDES_cblock = array [0..7] of Byte;
  PDES_cblock = ^TDES_cblock;

  mdc2_ctx_st = record
    num: Cardinal;
    data: array [0..7] of Byte;
    h: TDES_cblock;
    hh: TDES_cblock;
    pad_type: Integer;
  end;
  TMDC2_CTX = mdc2_ctx_st;
  PMDC2_CTX = ^TMDC2_CTX;
  Pmdc2_ctx_st = ^mdc2_ctx_st;

  sk_GENERAL_NAME_compfunc = function(const a, b: PPGENERAL_NAME): Integer;
  sk_GENERAL_NAME_freefunc = procedure(a: PGENERAL_NAME);
  sk_GENERAL_NAME_copyfunc = function(a: PGENERAL_NAME): PGENERAL_NAME_st;
  PGENERAL_NAMES = Pointer;
  PPGENERAL_NAMES = ^PGENERAL_NAMES;
  sk_GENERAL_NAMES_compfunc = function(a: PPGENERAL_NAMES; b: PPGENERAL_NAMES): Integer;
  sk_GENERAL_NAMES_freefunc = procedure(a: PGENERAL_NAMES);
  sk_GENERAL_NAMES_copyfunc = function(a: PGENERAL_NAMES): Pstack_st_GENERAL_NAME;
  sk_ACCESS_DESCRIPTION_compfunc = function(a: PPACCESS_DESCRIPTION; b: PPACCESS_DESCRIPTION): Integer;
  sk_ACCESS_DESCRIPTION_freefunc = procedure(a: PACCESS_DESCRIPTION);
  sk_ACCESS_DESCRIPTION_copyfunc = function(a: PACCESS_DESCRIPTION): PACCESS_DESCRIPTION_st;
  _anonymous_type_6 = record
    case Integer of
      0: (fullname: PGENERAL_NAMES);
      1: (relativename: Pstack_st_X509_NAME_ENTRY);
  end;
  P_anonymous_type_6 = ^_anonymous_type_6;
  DIST_POINT_NAME_st = record
    &type: Integer;
    name: _anonymous_type_6;
    dpname: PX509_NAME;
  end;
  DIST_POINT_NAME = DIST_POINT_NAME_st;
  PDIST_POINT_NAME = ^DIST_POINT_NAME;
  PPDIST_POINT_NAME = ^PDIST_POINT_NAME;

  DIST_POINT_st = record
    distpoint: PDIST_POINT_NAME;
    reasons: PASN1_BIT_STRING;
    CRLissuer: PGENERAL_NAMES;
    dp_reasons: Integer;
  end;
  TDIST_POINT = DIST_POINT_st;

  PCRL_DIST_POINTS = Pointer;
  PPCRL_DIST_POINTS = ^PCRL_DIST_POINTS;
  sk_DIST_POINT_compfunc = function(a: PPDIST_POINT; b: PPDIST_POINT): Integer;
  sk_DIST_POINT_freefunc = procedure(a: PDIST_POINT);
  sk_DIST_POINT_copyfunc = function(a: PDIST_POINT): PDIST_POINT_st;
  AUTHORITY_KEYID_st = record
    keyid: PASN1_OCTET_STRING;
    issuer: PGENERAL_NAMES;
    serial: PASN1_INTEGER;
  end;
  AUTHORITY_KEYID = AUTHORITY_KEYID_st;
  SXNET_ID_st = record
    zone: PASN1_INTEGER;
    user: PASN1_OCTET_STRING;
  end;
  SXNETID = SXNET_ID_st;
  PSXNETID = ^SXNETID;
  PPSXNETID = ^PSXNETID;
  sk_SXNETID_compfunc = function(a: PPSXNETID; b: PPSXNETID): Integer;
  sk_SXNETID_freefunc = procedure(a: PSXNETID);
  sk_SXNETID_copyfunc = function(a: PSXNETID): PSXNET_ID_st;
  SXNET_st = record
    version: PASN1_INTEGER;
    ids: Pstack_st_SXNETID;
  end;
  SXNET = SXNET_st;
  PSXNET = ^SXNET;
  PPSXNET = ^PSXNET;
  NOTICEREF_st = record
    organization: PASN1_STRING;
    noticenos: Pstack_st_ASN1_INTEGER;
  end;
  NOTICEREF = NOTICEREF_st;
  PNOTICEREF = ^NOTICEREF;
  PPNOTICEREF = ^PNOTICEREF;
  USERNOTICE_st = record
    noticeref: PNOTICEREF;
    exptext: PASN1_STRING;
  end;
  TUSERNOTICE = USERNOTICE_st;
  PUSERNOTICE = ^TUSERNOTICE;
  PPUSERNOTICE = ^PUSERNOTICE;
  _anonymous_type_7 = record
    case Integer of
      0: (cpsuri: PASN1_IA5STRING);
      1: (usernotice: PUSERNOTICE);
      2: (other: PASN1_TYPE);
  end;
  P_anonymous_type_7 = ^_anonymous_type_7;
  POLICYQUALINFO_st = record
    pqualid: PASN1_OBJECT;
    d: _anonymous_type_7;
  end;
  POLICYQUALINFO = POLICYQUALINFO_st;
  PPOLICYQUALINFO = ^POLICYQUALINFO;
  PPPOLICYQUALINFO = ^PPOLICYQUALINFO;
  sk_POLICYQUALINFO_compfunc = function(a: PPPOLICYQUALINFO; b: PPPOLICYQUALINFO): Integer;
  sk_POLICYQUALINFO_freefunc = procedure(a: PPOLICYQUALINFO);
  sk_POLICYQUALINFO_copyfunc = function(a: PPOLICYQUALINFO): PPOLICYQUALINFO_st;
  POLICYINFO_st = record
    policyid: PASN1_OBJECT;
    qualifiers: Pstack_st_POLICYQUALINFO;
  end;
  POLICYINFO = POLICYINFO_st;
  PPOLICYINFO = ^POLICYINFO;
  PPPOLICYINFO = ^PPOLICYINFO;
  PCERTIFICATEPOLICIES = Pointer;
  PPCERTIFICATEPOLICIES = ^PCERTIFICATEPOLICIES;
  sk_POLICYINFO_compfunc = function(a: PPPOLICYINFO; b: PPPOLICYINFO): Integer;
  sk_POLICYINFO_freefunc = procedure(a: PPOLICYINFO);
  sk_POLICYINFO_copyfunc = function(a: PPOLICYINFO): PPOLICYINFO_st;
  POLICY_MAPPING_st = record
    issuerDomainPolicy: PASN1_OBJECT;
    subjectDomainPolicy: PASN1_OBJECT;
  end;
  POLICY_MAPPING = POLICY_MAPPING_st;
  PPOLICY_MAPPING = ^POLICY_MAPPING;
  PPPOLICY_MAPPING = ^PPOLICY_MAPPING;
  sk_POLICY_MAPPING_compfunc = function(a: PPPOLICY_MAPPING; b: PPPOLICY_MAPPING): Integer;
  sk_POLICY_MAPPING_freefunc = procedure(a: PPOLICY_MAPPING);
  sk_POLICY_MAPPING_copyfunc = function(a: PPOLICY_MAPPING): PPOLICY_MAPPING_st;
  PPOLICY_MAPPINGS = Pointer;
  PPPOLICY_MAPPINGS = ^PPOLICY_MAPPINGS;
  GENERAL_SUBTREE_st = record
    base: PGENERAL_NAME;
    minimum: PASN1_INTEGER;
    maximum: PASN1_INTEGER;
  end;
  GENERAL_SUBTREE = GENERAL_SUBTREE_st;
  PGENERAL_SUBTREE = ^GENERAL_SUBTREE;
  PPGENERAL_SUBTREE = ^PGENERAL_SUBTREE;
  sk_GENERAL_SUBTREE_compfunc = function(a: PPGENERAL_SUBTREE; b: PPGENERAL_SUBTREE): Integer;
  sk_GENERAL_SUBTREE_freefunc = procedure(a: PGENERAL_SUBTREE);
  sk_GENERAL_SUBTREE_copyfunc = function(a: PGENERAL_SUBTREE): PGENERAL_SUBTREE_st;
  
  POLICY_CONSTRAINTS_st = record
    requireExplicitPolicy: PASN1_INTEGER;
    inhibitPolicyMapping: PASN1_INTEGER;
  end;
  POLICY_CONSTRAINTS = POLICY_CONSTRAINTS_st;
  PPOLICY_CONSTRAINTS = ^POLICY_CONSTRAINTS;
  PROXY_POLICY_st = record
    policyLanguage: PASN1_OBJECT;
    policy: PASN1_OCTET_STRING;
  end;
  PROXY_POLICY = PROXY_POLICY_st;
  PPROXY_POLICY = ^PROXY_POLICY;
  PPPROXY_POLICY = ^PPROXY_POLICY;
  PROXY_CERT_INFO_EXTENSION_st = record
    pcPathLengthConstraint: PASN1_INTEGER;
    proxyPolicy: PPROXY_POLICY;
  end;
  PROXY_CERT_INFO_EXTENSION = PROXY_CERT_INFO_EXTENSION_st;
  PPROXY_CERT_INFO_EXTENSION = ^PROXY_CERT_INFO_EXTENSION;
  PPPROXY_CERT_INFO_EXTENSION = ^PPROXY_CERT_INFO_EXTENSION;
  ISSUING_DIST_POINT_st = record
    distpoint: PDIST_POINT_NAME;
    onlyuser: Integer;
    onlyCA: Integer;
    onlysomereasons: PASN1_BIT_STRING;
    indirectCRL: Integer;
    onlyattr: Integer;
  end;
  ISSUING_DIST_POINT = ISSUING_DIST_POINT_st;

  PX509_PURPOSE = ^TX509_PURPOSE;
  PPX509_PURPOSE = ^PX509_PURPOSE;
  Tcheck_purpose_func = function(const p1: PX509_PURPOSE; const p2: PX509; p3: Integer): Integer;
  x509_purpose_st = record
    purpose: Integer;
    trust: Integer;
    flags: Integer;
    check_purpose: Tcheck_purpose_func;
    name: PUTF8Char;
    sname: PUTF8Char;
    usr_data: Pointer;
  end;
  TX509_PURPOSE = x509_purpose_st;

  sk_X509_PURPOSE_compfunc = function(a: PPX509_PURPOSE; b: PPX509_PURPOSE): Integer;
  sk_X509_PURPOSE_freefunc = procedure(a: PX509_PURPOSE);
  sk_X509_PURPOSE_copyfunc = function(a: PX509_PURPOSE): Px509_purpose_st;
  sk_X509_POLICY_NODE_compfunc = function(const a, b: PPX509_POLICY_NODE): Integer;
  sk_X509_POLICY_NODE_freefunc = procedure(a: PX509_POLICY_NODE);
  sk_X509_POLICY_NODE_copyfunc = function(a: PX509_POLICY_NODE): PX509_POLICY_NODE_st;
  ASRange_st = record
    min: PASN1_INTEGER;
    max: PASN1_INTEGER;
  end;
  ASRange = ASRange_st;
  PASRange = ^ASRange;
  PPASRange = ^PASRange;
  _anonymous_type_8 = record
    case Integer of
      0: (id: PASN1_INTEGER);
      1: (range: PASRange);
  end;
  P_anonymous_type_8 = ^_anonymous_type_8;
  ASIdOrRange_st = record
    &type: Integer;
    u: _anonymous_type_8;
  end;
  ASIdOrRange = ASIdOrRange_st;
  PASIdOrRange = ^ASIdOrRange;
  PPASIdOrRange = ^PASIdOrRange;
  PASIdOrRanges = Pointer;
  PPASIdOrRanges = ^PASIdOrRanges;
  sk_ASIdOrRange_compfunc = function(a: PPASIdOrRange; b: PPASIdOrRange): Integer;
  sk_ASIdOrRange_freefunc = procedure(a: PASIdOrRange);
  sk_ASIdOrRange_copyfunc = function(a: PASIdOrRange): PASIdOrRange_st;
  _anonymous_type_9 = record
    case Integer of
      0: (inherit: PASN1_NULL);
      1: (asIdsOrRanges: PASIdOrRanges);
  end;
  P_anonymous_type_9 = ^_anonymous_type_9;
  ASIdentifierChoice_st = record
    &type: Integer;
    u: _anonymous_type_9;
  end;
  ASIdentifierChoice = ASIdentifierChoice_st;
  PASIdentifierChoice = ^ASIdentifierChoice;
  PPASIdentifierChoice = ^PASIdentifierChoice;
  ASIdentifiers_st = record
    asnum: PASIdentifierChoice;
    rdi: PASIdentifierChoice;
  end;

  TASIdentifiers = ASIdentifiers_st;

  PPASIdentifiers = ^PASIdentifiers;
  IPAddressRange_st = record
    min: PASN1_BIT_STRING;
    max: PASN1_BIT_STRING;
  end;
  IPAddressRange = IPAddressRange_st;
  PIPAddressRange = ^IPAddressRange;
  PPIPAddressRange = ^PIPAddressRange;
  _anonymous_type_10 = record
    case Integer of
      0: (addressPrefix: PASN1_BIT_STRING);
      1: (addressRange: PIPAddressRange);
  end;
  P_anonymous_type_10 = ^_anonymous_type_10;

  IPAddressOrRange_st = record
    &type: Integer;
    u: _anonymous_type_10;
  end;

  TIPAddressOrRange = IPAddressOrRange_st;
  PIPAddressOrRange = ^TIPAddressOrRange;
  PPIPAddressOrRange = ^PIPAddressOrRange;

  //复数
  PIPAddressOrRanges = Pointer;
  PPIPAddressOrRanges = ^PIPAddressOrRanges;
  sk_IPAddressOrRange_compfunc = function(const a, b: PPIPAddressOrRange): Integer;
  sk_IPAddressOrRange_freefunc = procedure(a: PIPAddressOrRange);
  sk_IPAddressOrRange_copyfunc = function(a: PIPAddressOrRange): PIPAddressOrRange_st;
  _anonymous_type_11 = record
    case Integer of
      0: (inherit: PASN1_NULL);
      1: (addressesOrRanges: PIPAddressOrRanges);
  end;
  P_anonymous_type_11 = ^_anonymous_type_11;
  IPAddressChoice_st = record
    &type: Integer;
    u: _anonymous_type_11;
  end;
  IPAddressChoice = IPAddressChoice_st;
  PIPAddressChoice = ^IPAddressChoice;
  PPIPAddressChoice = ^PIPAddressChoice;
  IPAddressFamily_st = record
    addressFamily: PASN1_OCTET_STRING;
    ipAddressChoice: PIPAddressChoice;
  end;
  IPAddressFamily = IPAddressFamily_st;
  PIPAddressFamily = ^IPAddressFamily;
  PPIPAddressFamily = ^PIPAddressFamily;
  PIPAddrBlocks = Pointer;
  PPIPAddrBlocks = ^PIPAddrBlocks;
  sk_IPAddressFamily_compfunc = function(const a, b: PPIPAddressFamily): Integer;
  sk_IPAddressFamily_freefunc = procedure(a: PIPAddressFamily);
  sk_IPAddressFamily_copyfunc = function(a: PIPAddressFamily): PIPAddressFamily_st;
  sk_ASN1_STRING_compfunc = function(a: PPASN1_STRING; b: PPASN1_STRING): Integer;
  sk_ASN1_STRING_freefunc = procedure(a: PASN1_STRING);
  sk_ASN1_STRING_copyfunc = function(a: PASN1_STRING): Pasn1_string_st;
  PNAMING_AUTHORITY = ^TNAMING_AUTHORITY;
  PPNAMING_AUTHORITY = ^PNAMING_AUTHORITY;
  PPROFESSION_INFO = ^TPROFESSION_INFO;
  PPPROFESSION_INFO = ^PPROFESSION_INFO;
  PADMISSIONS = ^TADMISSIONS;
  PPADMISSIONS = ^PADMISSIONS;
  PADMISSION_SYNTAX = ^TADMISSION_SYNTAX;
  PPADMISSION_SYNTAX = ^PADMISSION_SYNTAX;
  sk_ADMISSIONS_compfunc = function(a: PPADMISSIONS; b: PPADMISSIONS): Integer;
  sk_ADMISSIONS_freefunc = procedure(a: PADMISSIONS);
  sk_ADMISSIONS_copyfunc = function(a: PADMISSIONS): PAdmissions_st;
  sk_PROFESSION_INFO_compfunc = function(a: PPPROFESSION_INFO; b: PPPROFESSION_INFO): Integer;
  sk_PROFESSION_INFO_freefunc = procedure(a: PPROFESSION_INFO);
  sk_PROFESSION_INFO_copyfunc = function(a: PPROFESSION_INFO): PProfessionInfo_st;
  PPROFESSION_INFOS = Pointer;
  PPPROFESSION_INFOS = ^PPROFESSION_INFOS;
  PCMS_ContentInfo = Pointer;
  PPCMS_ContentInfo = ^PCMS_ContentInfo;
  PCMS_SignerInfo = Pointer;
  PPCMS_SignerInfo = ^PCMS_SignerInfo;
  PCMS_CertificateChoices = Pointer;
  PPCMS_CertificateChoices = ^PCMS_CertificateChoices;
  PCMS_RevocationInfoChoice = Pointer;
  PPCMS_RevocationInfoChoice = ^PCMS_RevocationInfoChoice;
  PCMS_RecipientInfo = Pointer;
  PPCMS_RecipientInfo = ^PCMS_RecipientInfo;
  PCMS_ReceiptRequest = Pointer;
  PPCMS_ReceiptRequest = ^PCMS_ReceiptRequest;
  PCMS_Receipt = Pointer;
  PPCMS_Receipt = ^PCMS_Receipt;
  PCMS_RecipientEncryptedKey = Pointer;
  PPCMS_RecipientEncryptedKey = ^PCMS_RecipientEncryptedKey;
  PCMS_OtherKeyAttribute = Pointer;
  PPCMS_OtherKeyAttribute = ^PCMS_OtherKeyAttribute;
  sk_CMS_SignerInfo_compfunc = function(a: PPCMS_SignerInfo; b: PPCMS_SignerInfo): Integer;
  sk_CMS_SignerInfo_freefunc = procedure(a: PCMS_SignerInfo);
  sk_CMS_SignerInfo_copyfunc = function(a: PCMS_SignerInfo): PCMS_SignerInfo_st;
  sk_CMS_RecipientEncryptedKey_compfunc = function(a: PPCMS_RecipientEncryptedKey; b: PPCMS_RecipientEncryptedKey): Integer;
  sk_CMS_RecipientEncryptedKey_freefunc = procedure(a: PCMS_RecipientEncryptedKey);
  sk_CMS_RecipientEncryptedKey_copyfunc = function(a: PCMS_RecipientEncryptedKey): PCMS_RecipientEncryptedKey_st;
  sk_CMS_RecipientInfo_compfunc = function(a: PPCMS_RecipientInfo; b: PPCMS_RecipientInfo): Integer;
  sk_CMS_RecipientInfo_freefunc = procedure(a: PCMS_RecipientInfo);
  sk_CMS_RecipientInfo_copyfunc = function(a: PCMS_RecipientInfo): PCMS_RecipientInfo_st;
  sk_CMS_RevocationInfoChoice_compfunc = function(a: PPCMS_RevocationInfoChoice; b: PPCMS_RevocationInfoChoice): Integer;
  sk_CMS_RevocationInfoChoice_freefunc = procedure(a: PCMS_RevocationInfoChoice);
  sk_CMS_RevocationInfoChoice_copyfunc = function(a: PCMS_RevocationInfoChoice): PCMS_RevocationInfoChoice_st;
  ct_log_entry_type_t = (
    CT_LOG_ENTRY_TYPE_NOT_SET = -1,
    CT_LOG_ENTRY_TYPE_X509 = 0,
    CT_LOG_ENTRY_TYPE_PRECERT = 1);
  Pct_log_entry_type_t = ^ct_log_entry_type_t;
  sct_version_t = (
    SCT_VERSION_NOT_SET = -1,
    SCT_VERSION_V1 = 0);
  Psct_version_t = ^sct_version_t;
  sct_source_t = (
    SCT_SOURCE_UNKNOWN = 0,
    SCT_SOURCE_TLS_EXTENSION = 1,
    SCT_SOURCE_X509V3_EXTENSION = 2,
    SCT_SOURCE_OCSP_STAPLED_RESPONSE = 3);
  Psct_source_t = ^sct_source_t;
  sct_validation_status_t = (
    SCT_VALIDATION_STATUS_NOT_SET = 0,
    SCT_VALIDATION_STATUS_UNKNOWN_LOG = 1,
    SCT_VALIDATION_STATUS_VALID = 2,
    SCT_VALIDATION_STATUS_INVALID = 3,
    SCT_VALIDATION_STATUS_UNVERIFIED = 4,
    SCT_VALIDATION_STATUS_UNKNOWN_VERSION = 5);
  Psct_validation_status_t = ^sct_validation_status_t;
  sk_SCT_compfunc = function(a: PPSCT; b: PPSCT): Integer;
  sk_SCT_freefunc = procedure(a: PSCT);
  sk_SCT_copyfunc = function(a: PSCT): Psct_st;
  sk_CTLOG_compfunc = function(a: PPCTLOG; b: PPCTLOG): Integer;
  sk_CTLOG_freefunc = procedure(a: PCTLOG);
  sk_CTLOG_copyfunc = function(a: PCTLOG): Pctlog_st;
  DES_LONG = Cardinal;
  PDES_LONG = ^DES_LONG;

  const_DES_cblock = array [0..7] of Byte;
  Pconst_DES_cblock = PDES_cblock;//^const_DES_cblock;
  des_st = record
    case Integer of
      0: (cblock: TDES_cblock);
      1: (deslong: array [0..1] of DES_LONG);
  end;
  Pdes_st = ^des_st;

  DES_ks = record
    ks: array [0..15] of des_st;
  end;
  TDES_key_schedule = DES_ks;
  PDES_key_schedule = ^TDES_key_schedule;
 
  RAND_METHOD = rand_meth_st;

  PRAND_DRBG = Pointer;
  PPRAND_DRBG = ^PRAND_DRBG;
  Tpem_password_cb = function(buf: PUTF8Char; size: Integer; rwflag: Integer; userdata: Pointer): Integer;
  PUI_STRING = ^TUI_STRING;
  PPUI_STRING = ^PUI_STRING;
  {
  sk_UI_STRING_compfunc = function(a: PPUI_STRING; b: PPUI_STRING): Integer;
  sk_UI_STRING_freefunc = procedure(a: PUI_STRING);
  sk_UI_STRING_copyfunc = function(a: PUI_STRING): Pui_string_st;
  }
  TUI_string_types = (
    UIT_NONE = 0,
    UIT_PROMPT = 1,
    UIT_VERIFY = 2,
    UIT_BOOLEAN = 3,
    UIT_INFO = 4,
    UIT_ERROR = 5);
  PUI_string_types = ^TUI_string_types;

  err_state_st = record
    err_flags: array [0..ERR_NUM_ERRORS-1] of Integer;
    err_marks: array [0..ERR_NUM_ERRORS-1] of Integer;
    err_buffer: array [0..ERR_NUM_ERRORS-1] of Cardinal;
    err_data: array [0..ERR_NUM_ERRORS-1] of PUTF8Char;
    err_data_size: array[0..ERR_NUM_ERRORS-1] of size_t;
    err_data_flags: array [0..ERR_NUM_ERRORS-1] of Integer;
    err_file: array [0..ERR_NUM_ERRORS-1] of PUTF8Char;
    err_line: array [0..ERR_NUM_ERRORS-1] of Integer;
    err_func: array [0..ERR_NUM_ERRORS-1] of PUTF8Char;
    top: Integer;
    bottom: Integer;
  end;
  ERR_STATE = err_state_st;
  PERR_STATE = ^ERR_STATE;
  lh_ERR_STRING_DATA_dummy = record
    case Integer of
      0: (d1: Pointer);
      1: (d2: Cardinal);
      2: (d3: Integer);
  end;
  lhash_st_ERR_STRING_DATA = record
    dummy: lh_ERR_STRING_DATA_dummy;
  end;
  ENGINE_CMD_DEFN_st = record
    cmd_num: Cardinal;
    cmd_name: PUTF8Char;
    cmd_desc: PUTF8Char;
    cmd_flags: Cardinal;
  end;
  TENGINE_CMD_DEFN = ENGINE_CMD_DEFN_st;

  ENGINE_GEN_FUNC_PTR = function(): Integer;




  TIDEA_KEY_SCHEDULE = idea_key_st;
  PIDEA_KEY_SCHEDULE = ^TIDEA_KEY_SCHEDULE;
  MD4state_st = record
    A: Cardinal;
    B: Cardinal;
    C: Cardinal;
    D: Cardinal;
    Nl: Cardinal;
    Nh: Cardinal;
    data: array [0..15] of Cardinal;
    num: Cardinal;
  end;
  MD4_CTX = MD4state_st;
  PMD4_CTX = ^MD4_CTX;


  block128_f = procedure(const _in: PByte; _out: PByte; const key: Pointer);
  Pblock128_f = ^block128_f;
  cbc128_f = procedure(const &in: PByte; &out: PByte; len: size_t; const key: Pointer; ivec: PByte; enc: Integer);
  Pcbc128_f = ^cbc128_f;
  ctr128_f = procedure(&in: PByte; &out: PByte; blocks: size_t; key: Pointer; ivec: PByte);
  ccm128_f = procedure(&in: PByte; &out: PByte; blocks: size_t; key: Pointer; ivec: PByte; cmac: PByte);
  ecb128_f = procedure(const &in: PByte; &out: PByte; len: size_t; const key: Pointer; enc: Integer);
  PGCM128_CONTEXT = ^TGCM128_CONTEXT;
  PPGCM128_CONTEXT = ^PGCM128_CONTEXT;
  PCCM128_CONTEXT = ^TCCM128_CONTEXT;
  PPCCM128_CONTEXT = ^PCCM128_CONTEXT;
  PXTS128_CONTEXT = ^TXTS128_CONTEXT;
  PPXTS128_CONTEXT = ^PXTS128_CONTEXT;
  POCB128_CONTEXT = ^Tocb128_context;
  PPOCB128_CONTEXT = ^POCB128_CONTEXT;
  PArray = Pointer;
  ocb128_f = procedure(_in: PByte; _out: PByte; blocks: size_t; key: Pointer; start_block_num: size_t; offset_i: PByte;const L_: PPByte; checksum: PByte);
  POCSP_CERTID = Pointer;
  PPOCSP_CERTID = ^POCSP_CERTID;
  sk_OCSP_CERTID_compfunc = function(a: PPOCSP_CERTID; b: PPOCSP_CERTID): Integer;
  sk_OCSP_CERTID_freefunc = procedure(a: POCSP_CERTID);
  sk_OCSP_CERTID_copyfunc = function(a: POCSP_CERTID): Pocsp_cert_id_st;
  POCSP_ONEREQ = Pointer;
  PPOCSP_ONEREQ = ^POCSP_ONEREQ;
  sk_OCSP_ONEREQ_compfunc = function(a: PPOCSP_ONEREQ; b: PPOCSP_ONEREQ): Integer;
  sk_OCSP_ONEREQ_freefunc = procedure(a: POCSP_ONEREQ);
  sk_OCSP_ONEREQ_copyfunc = function(a: POCSP_ONEREQ): Pocsp_one_request_st;
  POCSP_REQINFO = Pointer;
  PPOCSP_REQINFO = ^POCSP_REQINFO;
  POCSP_SIGNATURE = Pointer;
  PPOCSP_SIGNATURE = ^POCSP_SIGNATURE;
  POCSP_REQUEST = Pointer;
  PPOCSP_REQUEST = ^POCSP_REQUEST;
  POCSP_RESPBYTES = Pointer;
  PPOCSP_RESPBYTES = ^POCSP_RESPBYTES;
  sk_OCSP_RESPID_compfunc = function(a: PPOCSP_RESPID; b: PPOCSP_RESPID): Integer;
  sk_OCSP_RESPID_freefunc = procedure(a: POCSP_RESPID);
  sk_OCSP_RESPID_copyfunc = function(a: POCSP_RESPID): Pocsp_responder_id_st;
  POCSP_REVOKEDINFO = Pointer;
  PPOCSP_REVOKEDINFO = ^POCSP_REVOKEDINFO;
  POCSP_CERTSTATUS = Pointer;
  PPOCSP_CERTSTATUS = ^POCSP_CERTSTATUS;
  POCSP_SINGLERESP = Pointer;
  PPOCSP_SINGLERESP = ^POCSP_SINGLERESP;
  sk_OCSP_SINGLERESP_compfunc = function(a: PPOCSP_SINGLERESP; b: PPOCSP_SINGLERESP): Integer;
  sk_OCSP_SINGLERESP_freefunc = procedure(a: POCSP_SINGLERESP);
  sk_OCSP_SINGLERESP_copyfunc = function(a: POCSP_SINGLERESP): Pocsp_single_response_st;
  POCSP_RESPDATA = Pointer;
  PPOCSP_RESPDATA = ^POCSP_RESPDATA;
  POCSP_BASICRESP = Pointer;
  PPOCSP_BASICRESP = ^POCSP_BASICRESP;
  POCSP_CRLID = ^TOCSP_CRLID;
  PPOCSP_CRLID = ^POCSP_CRLID;
  POCSP_SERVICELOC = ^TOCSP_SERVICELOC;
  PPOCSP_SERVICELOC = ^POCSP_SERVICELOC;
  PPKCS12_MAC_DATA = Pointer;
  PPPKCS12_MAC_DATA = ^PPKCS12_MAC_DATA;
  PPKCS12 = Pointer;
  PPPKCS12 = ^PPKCS12;
  PPKCS12_SAFEBAG = Pointer;
  PPPKCS12_SAFEBAG = ^PPKCS12_SAFEBAG;
  sk_PKCS12_SAFEBAG_compfunc = function(a: PPPKCS12_SAFEBAG; b: PPPKCS12_SAFEBAG): Integer;
  sk_PKCS12_SAFEBAG_freefunc = procedure(a: PPKCS12_SAFEBAG);
  sk_PKCS12_SAFEBAG_copyfunc = function(a: PPKCS12_SAFEBAG): PPKCS12_SAFEBAG_st;
  PPKCS12_BAGS = Pointer;
  PPPKCS12_BAGS = ^PPKCS12_BAGS;
  RAND_DRBG_get_entropy_fn = function(drbg: PRAND_DRBG; pout: PPByte; entropy: Integer; min_len: size_t; max_len: size_t; prediction_resistance: Integer): UInt64;
  RAND_DRBG_cleanup_entropy_fn = procedure(ctx: PRAND_DRBG; &out: PByte; outlen: size_t);
  RAND_DRBG_get_nonce_fn = function(drbg: PRAND_DRBG; pout: PPByte; entropy: Integer; min_len: size_t; max_len: size_t): UInt64;
  RAND_DRBG_cleanup_nonce_fn = procedure(drbg: PRAND_DRBG; &out: PByte; outlen: size_t);
  //RC2_INT = Cardinal;
  rc2_key_st = record
    data: array [0..63] of RC2_INT;
  end;
  TRC2_KEY = rc2_key_st;
  PRC2_KEY = ^TRC2_KEY;
  rc4_key_st = record
    x,
    y: RC4_INT;
    data: array [0..255] of RC4_INT;
  end;
  TRC4_KEY = rc4_key_st;
  PRC4_KEY = ^TRC4_KEY;

  
  seed_key_st = record
    data: array [0..31] of Cardinal;
  end;
  SEED_KEY_SCHEDULE = seed_key_st;
  PSEED_KEY_SCHEDULE = ^SEED_KEY_SCHEDULE;
  SRP_gN_cache_st = record
    b64_bn: PUTF8Char;
    bn: PBIGNUM;
  end;
  SRP_gN_cache = SRP_gN_cache_st;
  PSRP_gN_cache = ^SRP_gN_cache;
  PPSRP_gN_cache = ^PSRP_gN_cache;
  sk_SRP_gN_cache_compfunc = function(a: PPSRP_gN_cache; b: PPSRP_gN_cache): Integer;
  sk_SRP_gN_cache_freefunc = procedure(a: PSRP_gN_cache);
  sk_SRP_gN_cache_copyfunc = function(a: PSRP_gN_cache): PSRP_gN_cache_st;
  SRP_user_pwd_st = record
    id: PUTF8Char;
    s: PBIGNUM;
    v: PBIGNUM;
    g: PBIGNUM;
    N: PBIGNUM;
    info: PUTF8Char;
  end;
  SRP_user_pwd = SRP_user_pwd_st;
  PSRP_user_pwd = ^SRP_user_pwd;
  PPSRP_user_pwd = ^PSRP_user_pwd;
  sk_SRP_user_pwd_compfunc = function(a: PPSRP_user_pwd; b: PPSRP_user_pwd): Integer;
  sk_SRP_user_pwd_freefunc = procedure(a: PSRP_user_pwd);
  sk_SRP_user_pwd_copyfunc = function(a: PSRP_user_pwd): PSRP_user_pwd_st;
  SRP_VBASE_st = record
    users_pwd: Pstack_st_SRP_user_pwd;
    gN_cache: Pstack_st_SRP_gN_cache;
    seed_key: PUTF8Char;
    default_g: PBIGNUM;
    default_N: PBIGNUM;
  end;
  SRP_VBASE = SRP_VBASE_st;
  PSRP_VBASE = ^SRP_VBASE;
  SRP_gN_st = record
    id: PUTF8Char;
    g: PBIGNUM;
    N: PBIGNUM;
  end;
  SRP_gN = SRP_gN_st;
  PSRP_gN = ^SRP_gN;
  PPSRP_gN = ^PSRP_gN;
  sk_SRP_gN_compfunc = function(a: PPSRP_gN; b: PPSRP_gN): Integer;
  sk_SRP_gN_freefunc = procedure(a: PSRP_gN);
  sk_SRP_gN_copyfunc = function(a: PSRP_gN): PSRP_gN_st;
  ssl_crock_st = Pointer;
  Pssl_crock_st = ^ssl_crock_st;
  PSSL_METHOD = Pointer;
  PPSSL_METHOD = ^PSSL_METHOD;
  PSSL_CIPHER = Pointer;
  PPSSL_CIPHER = ^PSSL_CIPHER;
  PSSL_SESSION = Pointer;
  PPSSL_SESSION = ^PSSL_SESSION;
  PTLS_SIGALGS = Pointer;
  PPTLS_SIGALGS = ^PTLS_SIGALGS;
  PSSL_CONF_CTX = Pointer;
  PPSSL_CONF_CTX = ^PSSL_CONF_CTX;
  PSSL_COMP = Pointer;
  PPSSL_COMP = ^PSSL_COMP;
  srtp_protection_profile_st = record
    name: PUTF8Char;
    id: Cardinal;
  end;
  SRTP_PROTECTION_PROFILE = srtp_protection_profile_st;
  PSRTP_PROTECTION_PROFILE = ^SRTP_PROTECTION_PROFILE;
  PPSRTP_PROTECTION_PROFILE = ^PSRTP_PROTECTION_PROFILE;
  sk_SRTP_PROTECTION_PROFILE_compfunc = function(a: PPSRTP_PROTECTION_PROFILE; b: PPSRTP_PROTECTION_PROFILE): Integer;
  sk_SRTP_PROTECTION_PROFILE_freefunc = procedure(a: PSRTP_PROTECTION_PROFILE);
  sk_SRTP_PROTECTION_PROFILE_copyfunc = function(a: PSRTP_PROTECTION_PROFILE): Psrtp_protection_profile_st;
  tls_session_ticket_ext_cb_fn = function(s: PSSL; data: PByte; len: Integer; arg: Pointer): Integer;
  tls_session_secret_cb_fn = function(s: PSSL; secret: Pointer; secret_len: PInteger; peer_ciphers: Pstack_st_SSL_CIPHER; cipher: PPSSL_CIPHER; arg: Pointer): Integer;
  custom_ext_add_cb = function(s: PSSL; ext_type: Cardinal; &out: PPByte; outlen: Psize_t; al: PInteger; add_arg: Pointer): Integer;
  custom_ext_free_cb = procedure(s: PSSL; ext_type: Cardinal; &out: PByte; add_arg: Pointer);
  custom_ext_parse_cb = function(s: PSSL; ext_type: Cardinal; &in: PByte; inlen: size_t; al: PInteger; parse_arg: Pointer): Integer;
  SSL_custom_ext_add_cb_ex = function(s: PSSL; ext_type: Cardinal; context: Cardinal; &out: PPByte; outlen: Psize_t; x: PX509; chainidx: size_t; al: PInteger; add_arg: Pointer): Integer;
  SSL_custom_ext_free_cb_ex = procedure(s: PSSL; ext_type: Cardinal; context: Cardinal; &out: PByte; add_arg: Pointer);
  SSL_custom_ext_parse_cb_ex = function(s: PSSL; ext_type: Cardinal; context: Cardinal; &in: PByte; inlen: size_t; x: PX509; chainidx: size_t; al: PInteger; parse_arg: Pointer): Integer;
  SSL_verify_cb = function(preverify_ok: Integer; x509_ctx: PX509_STORE_CTX): Integer;
  GEN_SESSION_CB = function(ssl: PSSL; id: PByte; id_len: PCardinal): Integer;
  SSL_CTX_npn_advertised_cb_func = function(ssl: PSSL; &out: PPByte; outlen: PCardinal; arg: Pointer): Integer;
  SSL_CTX_npn_select_cb_func = function(s: PSSL; &out: PPByte; outlen: PByte; &in: PByte; inlen: Cardinal; arg: Pointer): Integer;
  SSL_CTX_alpn_select_cb_func = function(ssl: PSSL; &out: PPByte; outlen: PByte; &in: PByte; inlen: Cardinal; arg: Pointer): Integer;
  SSL_psk_client_cb_func = function(ssl: PSSL; hint: PUTF8Char; identity: PUTF8Char; max_identity_len: Cardinal; psk: PByte; max_psk_len: Cardinal): Cardinal;
  SSL_psk_server_cb_func = function(ssl: PSSL; identity: PUTF8Char; psk: PByte; max_psk_len: Cardinal): Cardinal;
  SSL_psk_find_session_cb_func = function(ssl: PSSL; identity: PByte; identity_len: size_t; sess: PPSSL_SESSION): Integer;
  SSL_psk_use_session_cb_func = function(ssl: PSSL; md: PEVP_MD; id: PPByte; idlen: Psize_t; sess: PPSSL_SESSION): Integer;
  SSL_CTX_keylog_cb_func = procedure(ssl: PSSL; line: PUTF8Char);
  tls_session_ticket_ext_st = record
    length: Word;
    data: Pointer;
  end;
  TLS_SESSION_TICKET_EXT = tls_session_ticket_ext_st;
  sk_SSL_CIPHER_compfunc = function(a: PPSSL_CIPHER; b: PPSSL_CIPHER): Integer;
  sk_SSL_CIPHER_freefunc = procedure(a: PSSL_CIPHER);
  sk_SSL_CIPHER_copyfunc = function(a: PSSL_CIPHER): Pssl_cipher_st;
  sk_SSL_COMP_compfunc = function(a: PPSSL_COMP; b: PPSSL_COMP): Integer;
  sk_SSL_COMP_freefunc = procedure(a: PSSL_COMP);
  sk_SSL_COMP_copyfunc = function(a: PSSL_COMP): Pssl_comp_st;
  OSSL_HANDSHAKE_STATE = (
    TLS_ST_BEFORE = 0,
    TLS_ST_OK = 1,
    DTLS_ST_CR_HELLO_VERIFY_REQUEST = 2,
    TLS_ST_CR_SRVR_HELLO = 3,
    TLS_ST_CR_CERT = 4,
    TLS_ST_CR_CERT_STATUS = 5,
    TLS_ST_CR_KEY_EXCH = 6,
    TLS_ST_CR_CERT_REQ = 7,
    TLS_ST_CR_SRVR_DONE = 8,
    TLS_ST_CR_SESSION_TICKET = 9,
    TLS_ST_CR_CHANGE = 10,
    TLS_ST_CR_FINISHED = 11,
    TLS_ST_CW_CLNT_HELLO = 12,
    TLS_ST_CW_CERT = 13,
    TLS_ST_CW_KEY_EXCH = 14,
    TLS_ST_CW_CERT_VRFY = 15,
    TLS_ST_CW_CHANGE = 16,
    TLS_ST_CW_NEXT_PROTO = 17,
    TLS_ST_CW_FINISHED = 18,
    TLS_ST_SW_HELLO_REQ = 19,
    TLS_ST_SR_CLNT_HELLO = 20,
    DTLS_ST_SW_HELLO_VERIFY_REQUEST = 21,
    TLS_ST_SW_SRVR_HELLO = 22,
    TLS_ST_SW_CERT = 23,
    TLS_ST_SW_KEY_EXCH = 24,
    TLS_ST_SW_CERT_REQ = 25,
    TLS_ST_SW_SRVR_DONE = 26,
    TLS_ST_SR_CERT = 27,
    TLS_ST_SR_KEY_EXCH = 28,
    TLS_ST_SR_CERT_VRFY = 29,
    TLS_ST_SR_NEXT_PROTO = 30,
    TLS_ST_SR_CHANGE = 31,
    TLS_ST_SR_FINISHED = 32,
    TLS_ST_SW_SESSION_TICKET = 33,
    TLS_ST_SW_CERT_STATUS = 34,
    TLS_ST_SW_CHANGE = 35,
    TLS_ST_SW_FINISHED = 36,
    TLS_ST_SW_ENCRYPTED_EXTENSIONS = 37,
    TLS_ST_CR_ENCRYPTED_EXTENSIONS = 38,
    TLS_ST_CR_CERT_VRFY = 39,
    TLS_ST_SW_CERT_VRFY = 40,
    TLS_ST_CR_HELLO_REQ = 41,
    TLS_ST_SW_KEY_UPDATE = 42,
    TLS_ST_CW_KEY_UPDATE = 43,
    TLS_ST_SR_KEY_UPDATE = 44,
    TLS_ST_CR_KEY_UPDATE = 45,
    TLS_ST_EARLY_DATA = 46,
    TLS_ST_PENDING_EARLY_DATA_END = 47,
    TLS_ST_CW_END_OF_EARLY_DATA = 48,
    TLS_ST_SR_END_OF_EARLY_DATA = 49);
  POSSL_HANDSHAKE_STATE = ^OSSL_HANDSHAKE_STATE;
  SSL_client_hello_cb_fn = function(s: PSSL; al: PInteger; arg: Pointer): Integer;
  ssl_ct_validation_cb = function(ctx: PCT_POLICY_EVAL_CTX; scts: Pstack_st_SCT; arg: Pointer): Integer;
  _anonymous_type_13 = (
    SSL_CT_VALIDATION_PERMISSIVE = 0,
    SSL_CT_VALIDATION_STRICT = 1);
  P_anonymous_type_13 = ^_anonymous_type_13;
  SSL_TICKET_STATUS = Integer;
  SSL_TICKET_RETURN = Integer;
  SSL_CTX_generate_session_ticket_fn = function(s: PSSL; arg: Pointer): Integer;
  SSL_CTX_decrypt_session_ticket_fn = function(s: PSSL; ss: PSSL_SESSION; keyname: PByte; keyname_length: size_t; status: SSL_TICKET_STATUS; arg: Pointer): Integer;
  DTLS_timer_cb = function(s: PSSL; timer_us: Cardinal): Cardinal;
  SSL_allow_early_data_cb_fn = function(s: PSSL; arg: Pointer): Integer;
  POSSL_STORE_CTX = Pointer;
  PPOSSL_STORE_CTX = ^POSSL_STORE_CTX;
  OSSL_STORE_post_process_info_fn = function(p1: POSSL_STORE_INFO; p2: Pointer): Possl_store_info_st;
  POSSL_STORE_LOADER = Pointer;
  PPOSSL_STORE_LOADER = ^POSSL_STORE_LOADER;
  POSSL_STORE_LOADER_CTX = Pointer;
  PPOSSL_STORE_LOADER_CTX = ^POSSL_STORE_LOADER_CTX;
  OSSL_STORE_open_fn = function(loader: POSSL_STORE_LOADER; uri: PUTF8Char; ui_method: PUI_METHOD; ui_data: Pointer): Possl_store_loader_ctx_st;
  OSSL_STORE_ctrl_fn = function(ctx: POSSL_STORE_LOADER_CTX; cmd: Integer; args: Pointer): Integer;
  OSSL_STORE_expect_fn = function(ctx: POSSL_STORE_LOADER_CTX; expected: Integer): Integer;
  OSSL_STORE_find_fn = function(ctx: POSSL_STORE_LOADER_CTX; criteria: POSSL_STORE_SEARCH): Integer;
  OSSL_STORE_load_fn = function(ctx: POSSL_STORE_LOADER_CTX; ui_method: PUI_METHOD; ui_data: Pointer): Possl_store_info_st;
  OSSL_STORE_eof_fn = function(ctx: POSSL_STORE_LOADER_CTX): Integer;
  OSSL_STORE_error_fn = function(ctx: POSSL_STORE_LOADER_CTX): Integer;
  OSSL_STORE_close_fn = function(ctx: POSSL_STORE_LOADER_CTX): Integer;
  PTS_MSG_IMPRINT = Pointer;
  PPTS_MSG_IMPRINT = ^PTS_MSG_IMPRINT;
  PTS_REQ = Pointer;
  PPTS_REQ = ^PTS_REQ;
  PTS_ACCURACY = Pointer;
  PPTS_ACCURACY = ^PTS_ACCURACY;
  PTS_TST_INFO = Pointer;
  PPTS_TST_INFO = ^PTS_TST_INFO;
  PTS_STATUS_INFO = Pointer;
  PPTS_STATUS_INFO = ^PTS_STATUS_INFO;
  PESS_ISSUER_SERIAL = Pointer;
  PPESS_ISSUER_SERIAL = ^PESS_ISSUER_SERIAL;
  PESS_CERT_ID = Pointer;
  PPESS_CERT_ID = ^PESS_CERT_ID;
  PESS_SIGNING_CERT = Pointer;
  PPESS_SIGNING_CERT = ^PESS_SIGNING_CERT;
  sk_ESS_CERT_ID_compfunc = function(a: PPESS_CERT_ID; b: PPESS_CERT_ID): Integer;
  sk_ESS_CERT_ID_freefunc = procedure(a: PESS_CERT_ID);
  sk_ESS_CERT_ID_copyfunc = function(a: PESS_CERT_ID): PESS_cert_id;
  PESS_CERT_ID_V2 = Pointer;
  PPESS_CERT_ID_V2 = ^PESS_CERT_ID_V2;
  PESS_SIGNING_CERT_V2 = Pointer;
  PPESS_SIGNING_CERT_V2 = ^PESS_SIGNING_CERT_V2;
  sk_ESS_CERT_ID_V2_compfunc = function(a: PPESS_CERT_ID_V2; b: PPESS_CERT_ID_V2): Integer;
  sk_ESS_CERT_ID_V2_freefunc = procedure(a: PESS_CERT_ID_V2);
  sk_ESS_CERT_ID_V2_copyfunc = function(a: PESS_CERT_ID_V2): PESS_cert_id_v2_st;
  PTS_RESP = Pointer;
  PPTS_RESP = ^PTS_RESP;
  PTS_RESP_CTX = Pointer;
  PPTS_RESP_CTX = ^PTS_RESP_CTX;
  TS_serial_cb = function(p1: PTS_resp_ctx; p2: Pointer): Pasn1_string_st;
  TS_time_cb = function(p1: PTS_resp_ctx; p2: Pointer; sec: PInteger; usec: PInteger): Integer;
  TS_extension_cb = function(p1: PTS_resp_ctx; p2: PX509_EXTENSION; p3: Pointer): Integer;
  sk_EVP_MD_compfunc = function(a: PPEVP_MD; b: PPEVP_MD): Integer;
  sk_EVP_MD_freefunc = procedure(a: PEVP_MD);
  sk_EVP_MD_copyfunc = function(a: PEVP_MD): Pevp_md_st;
  PTS_VERIFY_CTX = Pointer;
  PPTS_VERIFY_CTX = ^PTS_VERIFY_CTX;
  OPENSSL_PSTRING = POPENSSL_STRING;
  Plhash_st_OPENSSL_STRING = ^lhash_st_OPENSSL_STRING;
  PPlhash_st_OPENSSL_STRING = ^Plhash_st_OPENSSL_STRING;

  sk_OPENSSL_PSTRING_compfunc = function(a: PPOPENSSL_STRING; b: PPOPENSSL_STRING): Integer;
  sk_OPENSSL_PSTRING_freefunc = procedure(a: POPENSSL_STRING);
  sk_OPENSSL_PSTRING_copyfunc = function(a: POPENSSL_STRING): PPUTF8Char;
  txt_db_st = record
    num_fields: Integer;
    data: Pstack_st_OPENSSL_PSTRING;
    index: PPlhash_st_OPENSSL_STRING;
    qual: Integer { TODO : Cannot convert original type "int (**)(OPENSSL_STRING *)" };
    error: Integer;
    arg1: Integer;
    arg2: Integer;
    arg_row: POPENSSL_STRING;
  end;
  TXT_DB = txt_db_st;
  PTXT_DB = ^TXT_DB;
  _anonymous_type_14 = record
    case Integer of
      0: (c: array [0..63] of Byte);
      1: (q: array [0..7] of Double);
  end;
  P_anonymous_type_14 = ^_anonymous_type_14;
  WHIRLPOOL_CTX = record
    H: _anonymous_type_14;
    data: array [0..63] of Byte;
    bitoff: Cardinal;
    bitlen: array [0..3] of size_t;
  end;

  PCRYPTO_dynlock = ^CRYPTO_dynlock;
  Pcrypto_ex_data_st = ^crypto_ex_data_st;
  Pcrypto_threadid_st = ^crypto_threadid_st;

  PASN1_ENCODING_st = ^ASN1_ENCODING_st;


  PBIT_STRING_BITNAME_st = ^BIT_STRING_BITNAME_st;
  PASN1_TEMPLATE_st = ^ASN1_TEMPLATE_st;
  PASN1_ADB_st = ^ASN1_ADB_st;
  PASN1_ADB_TABLE_st = ^ASN1_ADB_TABLE_st;
  PASN1_ITEM_st = ^ASN1_ITEM_st;
  PASN1_TLC_st = ^ASN1_TLC_st;
  PASN1_EXTERN_FUNCS_st = ^ASN1_EXTERN_FUNCS_st;
  PASN1_PRIMITIVE_FUNCS_st = ^ASN1_PRIMITIVE_FUNCS_st;
  PASN1_AUX_st = ^ASN1_AUX_st;
  PASN1_PRINT_ARG_st = ^ASN1_PRINT_ARG_st;
  PASN1_STREAM_ARG_st = ^ASN1_STREAM_ARG_st;
  Pbf_key_st = ^bf_key_st;
  Pbuf_mem_st = ^buf_mem_st;
  Pcamellia_key_st = ^camellia_key_st;
  Pcast_key_st = ^cast_key_st;
  Pobj_name_st = ^obj_name_st;
  PEVP_CTRL_TLS1_1_MULTIBLOCK_PARAM = ^EVP_CTRL_TLS1_1_MULTIBLOCK_PARAM;
  Pevp_cipher_info_st = ^evp_cipher_info_st;
  PEC_builtin_curve = ^EC_builtin_curve;
  Prsa_pss_params_st = ^rsa_pss_params_st;
  Prsa_oaep_params_st = ^rsa_oaep_params_st;
  PSHAstate_st = ^SHAstate_st;
  PSHA256state_st = ^SHA256state_st;
  PSHA512state_st = ^SHA512state_st;

  PX509_val_st = ^X509_val_st;

  Pprivate_key_st = ^private_key_st;

  PNetscape_spkac_st = ^Netscape_spkac_st;
  PNetscape_spki_st = ^Netscape_spki_st;
  PNetscape_certificate_sequence = ^Netscape_certificate_sequence;
  PPBEPARAM_st = ^PBEPARAM_st;
  PPBE2PARAM_st = ^PBE2PARAM_st;
  PPBKDF2PARAM_st = ^PBKDF2PARAM_st;
  PSCRYPT_PARAMS_st = ^SCRYPT_PARAMS_st;

  Plhash_st_OPENSSL_CSTRING = ^lhash_st_OPENSSL_CSTRING;
  Ppkcs7_issuer_and_serial_st = ^pkcs7_issuer_and_serial_st;
  
  Ppkcs7_signed_st = ^pkcs7_signed_st;
  Ppkcs7_enc_content_st = ^pkcs7_enc_content_st;
  Ppkcs7_enveloped_st = ^pkcs7_enveloped_st;
  Ppkcs7_signedandenveloped_st = ^pkcs7_signedandenveloped_st;
  Ppkcs7_digest_st = ^pkcs7_digest_st;
  Ppkcs7_encrypted_st = ^pkcs7_encrypted_st;

   x509_store_ctx_st = record
    store: PX509_STORE;
    cert: PX509;
    untrusted: Pstack_st_X509;
    crls: Pstack_st_X509_CRL;
    param: PX509_VERIFY_PARAM;
    other_ctx: Pointer;
    verify: function(ctx: PX509_STORE_CTX): Integer;
    verify_cb: function(ok: Integer; ctx: PX509_STORE_CTX): Integer;
    get_issuer: function(issuer: PPX509; ctx: PX509_STORE_CTX; x: PX509): Integer;
    check_issued: function(ctx: PX509_STORE_CTX; x, issuer: PX509): Integer;
    check_revocation: function(ctx: PX509_STORE_CTX): Integer;
    get_crl: function(ctx: PX509_STORE_CTX; crl: PPX509_CRL; x: PX509): Integer;
    check_crl: function(ctx: PX509_STORE_CTX; crl: PX509_CRL): Integer;
    cert_crl: function(ctx: PX509_STORE_CTX; crl: PX509_CRL; x: PX509): Integer;
    check_policy: function(ctx: PX509_STORE_CTX): Integer;
    lookup_certs: function(ctx: PX509_STORE_CTX; const nm: PX509_NAME): Pstack_st_X509;
    lookup_crls: function(const ctx: PX509_STORE_CTX; const nm: PX509_NAME): Pstack_st_X509_CRL;
    cleanup: function(ctx: PX509_STORE_CTX): Integer;
    valid: Integer;
    num_untrusted: Integer;
    chain: Pstack_st_X509;
    tree: PX509_POLICY_TREE;
    explicit_policy: Integer;
    error_depth: Integer;
    error: Integer;
    current_cert: PX509;
    current_issuer: PX509;
    current_crl: PX509_CRL;
    current_crl_score: Integer;
    current_reasons: Cardinal;
    parent: PX509_STORE_CTX;
    ex_data: TCRYPTO_EX_DATA;
    dane: PSSL_DANE;
    bare_ta_signed: Integer;
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
  end;

  TX509_STORE_CTX = x509_store_ctx_st;

  x509_revoked_st = record
    serialNumber: TASN1_INTEGER;
    revocationDate: PASN1_TIME;
    extensions: Pstack_st_X509_EXTENSION;
    issuer: Pstack_st_GENERAL_NAME;
    reason: Integer;
    sequence: Integer;
  end;
  TX509_REVOKED = x509_revoked_st;

  x509_store_st = record
    cache: Integer;
    objs: Pstack_st_X509_OBJECT;
    get_cert_methods: Pstack_st_X509_LOOKUP;
    param: PX509_VERIFY_PARAM;
    verify: function(ctx: PX509_STORE_CTX): Integer;
    verify_cb: function(ok: Integer; ctx: PX509_STORE_CTX): Integer;
    get_issuer: function(issuer: PPX509; ctx: PX509_STORE_CTX; x: PX509): Integer;
    check_issued: function(ctx: PX509_STORE_CTX; x, issuer: PX509): Integer;
    check_revocation: function(ctx: PX509_STORE_CTX): Integer;
    get_crl: function(ctx: PX509_STORE_CTX; crl: PPX509_CRL; x: PX509): Integer;
    check_crl: function(ctx: PX509_STORE_CTX; crl: PX509_CRL): Integer;
    cert_crl: function(ctx: PX509_STORE_CTX; crl: PX509_CRL; x: PX509): Integer;
    check_policy: function(ctx: PX509_STORE_CTX): Integer;
    lookup_certs: function(ctx: PX509_STORE_CTX; const nm: PX509_NAME): Pstack_st_X509;
    lookup_crls: function(const ctx: PX509_STORE_CTX; const nm: PX509_NAME): Pstack_st_X509_CRL;
    cleanup: function(ctx: PX509_STORE_CTX): Integer;
    ex_data: TCRYPTO_EX_DATA;
    references: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
  end;
  TX509_STORE = x509_store_st;

  TBN_ULONGs = TArray<BN_ULONG>;
  bignum_st = record
    d: PBN_ULONG;
    top: Integer;
    dmax: Integer;
    neg: Integer;
    flags: Integer;
    //nums: TBN_ULONGs;
  end;
  TBIGNUM = bignum_st;

  endian_st = record
      case Integer  of
      0: ( one: long);
      1: (little: Byte) ;
  end;

  bignum_ctx_stack = record
    indexes: Puint;
    depth: uint;
    size: uint;
  end;
  TBN_STACK = bignum_ctx_stack;
  PBN_STACK = ^TBN_STACK;

  PBN_POOL_ITEM = ^TBN_POOL_ITEM;
  bignum_pool_item = record
    vals: array [0..15] of TBIGNUM;
    prev: PBN_POOL_ITEM;
    next: PBN_POOL_ITEM;
  end;

  TBN_POOL_ITEM = bignum_pool_item;

  bignum_pool = record
    head: PBN_POOL_ITEM;
    current: PBN_POOL_ITEM;
    tail: PBN_POOL_ITEM;
    used: uint32;
    size: uint32;
  end;

  TBN_POOL = bignum_pool;
  PBN_POOL = ^TBN_POOL;

  bignum_ctx = record
    pool: TBN_POOL;
    stack: TBN_STACK;
    used: uint;
    err_stack: Integer;
    too_many: Integer;
    flags: Integer;
    libctx: POSSL_LIB_CTX;
  end;
  TBN_CTX = bignum_ctx;


  PDH_NAMED_GROUP = ^TDH_NAMED_GROUP;

  dh_named_group_st = record
    name: PUTF8Char;
    uid: Integer;
    nbits: Int32;
  {$ifndef OPENSSL_NO_DH}
    p: PBIGNUM;
    q: PBIGNUM;
    g: PBIGNUM;
  {$ENDIF}
  end;
  TDH_NAMED_GROUP = dh_named_group_st;

  bio_st = record
    libctx: POSSL_LIB_CTX;
    method: PBIO_METHOD;
    callback: BIO_callback_fn;
    callback_ex: BIO_callback_fn_ex;
    cb_arg: PUTF8Char;
    init: Integer;
    shutdown: Integer;
    flags: Integer;
    retry_reason: Integer;
    num: Integer;
    ptr: Pointer;
    next_bio: PBIO;
    prev_bio: PBIO;
    references: CRYPTO_REF_COUNT;
    num_read: UInt64;
    num_write: UInt64;
    ex_data: TCRYPTO_EX_DATA;
    lock: PCRYPTO_RWLOCK;
    ptrinfo: PTypeInfo;
  end;
  TBIO = bio_st;

  bio_method_st = record
    &type: Integer;
    name: PUTF8Char;
    bwrite: function(p1: PBIO; {const} p2: PByte; p3: size_t; p4: Psize_t): Integer;
    bwrite_old: function(p1: PBIO; {const} p2: PByte; p3: Integer): Integer;
    bread: function(p1: PBIO; p2: PUTF8Char; p3: size_t; p4: Psize_t): Integer;
    bread_old: function(p1: PBIO; p2: PUTF8Char; p3: Integer): Integer;
    bputs: function(p1: PBIO; const p2: PUTF8Char): Integer;
    bgets: function(p1: PBIO; p2: PUTF8Char; p3: Integer): Integer;
    ctrl: function(p1: PBIO; p2: Integer; p3: Integer; p4: Pointer): Integer;
    create: function(p1: PBIO): Integer;
    destroy: function(p1: PBIO): Integer;
    callback_ctrl: function(p1: PBIO; p2: Integer; p3: TBIO_info_cb): Integer;
  end;

  Psparse_array_st_ALGORITHM = Pointer;
  TBIO_METHOD = bio_method_st ;
  ossl_method_store_st = record
    ctx: POSSL_LIB_CTX;
    nelem: size_t;
    algs: Psparse_array_st_ALGORITHM;
    need_flush: Integer;
    lock: PCRYPTO_RWLOCK;
  end;

  TOSSL_METHOD_STORE = ossl_method_store_st;
  Possl_method_store_st = ^ossl_method_store_st;
  POSSL_METHOD_STORE = ^TOSSL_METHOD_STORE;

  evp_method_data_st = record
    libctx: POSSL_LIB_CTX;
    operation_id: Integer;
    name_id: Integer;
    names: PUTF8Char;
    propquery: PUTF8Char;
    tmp_store: POSSL_METHOD_STORE;
    flag_construct_error_occurred: Cardinal;
    method_from_algorithm: function(name_id: Integer; const p2: POSSL_ALGORITHM; p3: POSSL_PROVIDER): Pointer;
    refcnt_up_method: function(method: Pointer): Integer;
    destruct_method: procedure(method: Pointer);
  end;
  Pevp_method_data_st = ^evp_method_data_st;

  ossl_method_construct_method_st = record
    get_tmp_store: function(data: Pointer): Pointer;
    get: function(store: Pointer;const prov: PPOSSL_PROVIDER; data: Pointer): Pointer;
    put: function(store: Pointer; method: Pointer; const prov: POSSL_PROVIDER; name, propdef: PUTF8Char; data: Pointer): Integer;
    construct: function(const algodef: POSSL_ALGORITHM; prov: POSSL_PROVIDER; data: Pointer): Pointer;
    destruct: procedure(method: Pointer; data: Pointer);
  end;

  TOSSL_METHOD_CONSTRUCT_METHOD = ossl_method_construct_method_st;
  POSSL_METHOD_CONSTRUCT_METHOD = ^TOSSL_METHOD_CONSTRUCT_METHOD;

  Pstack_st_IMPLEMENTATION = Pointer;
  Plhash_st_QUERY = Pointer;
  TALGORITHM = record
    nid: Integer;
    impls: POPENSSL_STACK;//Pstack_st_IMPLEMENTATION;
    cache: Plhash_st_QUERY;
  end;
  PALGORITHM = ^TALGORITHM;



  sparse_array_st = record
    levels: Integer;
    top: ossl_uintmax_t;
    nelem: size_t;
    nodes: PPointer;

  end;
  TOPENSSL_SA = sparse_array_st;
  POPENSSL_SA = ^TOPENSSL_SA;

  TOSSL_PROPERTY_TYPE = (
    OSSL_PROPERTY_TYPE_STRING, OSSL_PROPERTY_TYPE_NUMBER,
    OSSL_PROPERTY_TYPE_VALUE_UNDEFINED
   ) ;

   TOSSL_PROPERTY_OPER = (
    OSSL_PROPERTY_OPER_EQ, OSSL_PROPERTY_OPER_NE, OSSL_PROPERTY_OVERRIDE
   ) ;

   {
   TMETHOD = record
      method: Pointer;
      up_ref: function(p1: Pointer): Integer;
      free: procedure(p1: Pointer);
   end;
  PMETHOD = ^TMETHOD;
  }


  ossl_property_definition_st = record
    name_idx: OSSL_PROPERTY_IDX;
    &type: TOSSL_PROPERTY_TYPE;
    oper: TOSSL_PROPERTY_OPER;
    optional: Cardinal;
    v: record
    case Integer of
      0: (int_val: Int64);
      1: (str_val: OSSL_PROPERTY_IDX);
    end;
  end;
  TOSSL_PROPERTY_DEFINITION = ossl_property_definition_st ;
  POSSL_PROPERTY_DEFINITION = ^TOSSL_PROPERTY_DEFINITION;
  PPOSSL_PROPERTY_DEFINITION = ^POSSL_PROPERTY_DEFINITION;
  Pstack_st_OSSL_PROPERTY_DEFINITION = Pointer;

  T_METHOD = record
    method: Pointer;
    up_ref: function(p1: Pointer): int;
    free: procedure(p1: Pointer);
  end ;
  P_METHOD = ^T_METHOD;

  POSSL_PROPERTY_LIST = ^TOSSL_PROPERTY_LIST;
  PPOSSL_PROPERTY_LIST = ^POSSL_PROPERTY_LIST;
  TIMPLEMENTATION = record
    provider: POSSL_PROVIDER;
    properties: POSSL_PROPERTY_LIST;
    method: T_METHOD;
  end;
  PIMPLEMENTATION = ^TIMPLEMENTATION;
  PPIMPLEMENTATION = ^PIMPLEMENTATION;

  TQUERY = record
    provider: POSSL_PROVIDER;
    query: PUTF8Char;
    method: T_METHOD;
    body: array [0..100] of UTF8Char;
  end;
  PQUERY = ^TQUERY;

  TOSSL_PROPERTY_DEFINITIONS = TArray<TOSSL_PROPERTY_DEFINITION>;
  ossl_property_list_st = record
    num_properties: Integer;
    has_optional: Cardinal;
    properties: TArray<TOSSL_PROPERTY_DEFINITION>;
  end;
  TOSSL_PROPERTY_LIST = ossl_property_list_st;

  ossl_global_properties_st = record
    list: POSSL_PROPERTY_LIST;
    no_mirrored: Cardinal;
  end;

  TOSSL_GLOBAL_PROPERTIES = ossl_global_properties_st;
  POSSL_GLOBAL_PROPERTIES = ^TOSSL_GLOBAL_PROPERTIES;
  PPOSSL_GLOBAL_PROPERTIES = ^POSSL_GLOBAL_PROPERTIES;

  TOSSL_PROVIDER_CHILD_CB = record
    prov: POSSL_PROVIDER;
    create_cb: function(const provider: POSSL_CORE_HANDLE; cbdata: Pointer): Integer;
    remove_cb: function(const provider: POSSL_CORE_HANDLE; cbdata: Pointer): Integer;
    global_props_cb: function(const props: PUTF8Char; cbdata: Pointer): Integer;
    cbdata: Pointer;
  end;
  POSSL_PROVIDER_CHILD_CB = ^TOSSL_PROVIDER_CHILD_CB;
  POPENSSL_CORE_CTX = Pointer;
  Tcreate_cb_func = function(const provider: POSSL_CORE_HANDLE ; cbdata: Pointer): int;
  Tremove_cb_func = function(const provider: POSSL_CORE_HANDLE ; cbdata: Pointer): int;
  Tglobal_props_cb_func = function(const props: PUTF8Char ; cbdata: Pointer): int;
  TOSSL_FUNC_provider_deregister_child_cb_fn = procedure(const handle: POSSL_CORE_HANDLE);
  TOSSL_FUNC_provider_register_child_cb_fn = function(const handle: POSSL_CORE_HANDLE;
                       create_cb: Tcreate_cb_func;
                       remove_cb: Tremove_cb_func;
                       global_props_cb: Tglobal_props_cb_func;
                       cbdata: Pointer): Integer;
  TOSSL_FUNC_core_get_libctx_fn = function(const prov: POSSL_CORE_HANDLE): POPENSSL_CORE_CTX;
  TOSSL_FUNC_provider_name_fn = function(const prov: POSSL_CORE_HANDLE): PUTF8Char;
  TOSSL_FUNC_provider_get0_provider_ctx_fn = function(const prov: POSSL_CORE_HANDLE): Pointer;
  TOSSL_FUNC_provider_get0_dispatch_fn = function(const prov: POSSL_CORE_HANDLE): POSSL_DISPATCH;
  TOSSL_FUNC_provider_up_ref_fn = function(const prov: POSSL_CORE_HANDLE; activate: Integer): Integer;
  TOSSL_FUNC_provider_free_fn = function(const prov: POSSL_CORE_HANDLE; deactivate: Integer): Integer;

  child_prov_globals = record
    handle: POSSL_CORE_HANDLE;
    curr_prov: POSSL_CORE_HANDLE;
    lock: PCRYPTO_RWLOCK;
    c_get_libctx: TOSSL_FUNC_core_get_libctx_fn;
    c_provider_register_child_cb: TOSSL_FUNC_provider_register_child_cb_fn;
    c_provider_deregister_child_cb: TOSSL_FUNC_provider_deregister_child_cb_fn;
    c_prov_name: TOSSL_FUNC_provider_name_fn;
    c_prov_get0_provider_ctx: TOSSL_FUNC_provider_get0_provider_ctx_fn;
    c_prov_get0_dispatch: TOSSL_FUNC_provider_get0_dispatch_fn;
    c_prov_up_ref: TOSSL_FUNC_provider_up_ref_fn;
    c_prov_free: TOSSL_FUNC_provider_free_fn;
  end;
  Pchild_prov_globals = ^child_prov_globals;

  TINFOPAIR = record
    name: PUTF8Char;
    value: PUTF8Char;
  end;
  PINFOPAIR =^TINFOPAIR;

  TPROPERTY_DEFN_ELEM = record
    prop: PUTF8Char;
    defn: POSSL_PROPERTY_LIST;
    body: Array[0..100] of UTF8Char;

  end;
  PPROPERTY_DEFN_ELEM = ^TPROPERTY_DEFN_ELEM;

  lh_PROPERTY_DEFN_ELEM_dummy = record
    case Integer of
      0: (d1: Pointer);
      1: (d2: Cardinal);
      2: (d3: Integer);
  end;
  lhash_st_PROPERTY_DEFN_ELEM = record
    dummy: lh_PROPERTY_DEFN_ELEM_dummy;
  end;
  Plhash_st_PROPERTY_DEFN_ELEM = ^lhash_st_PROPERTY_DEFN_ELEM;
  construct_data_st = record
    libctx: POSSL_LIB_CTX;
    store: POSSL_METHOD_STORE;
    operation_id: Integer;
    force_store: Integer;
    mcm: POSSL_METHOD_CONSTRUCT_METHOD;
    mcm_data: Pointer;
  end;

  algorithm_data_st = record
    libctx: POSSL_LIB_CTX;
    operation_id: Integer;
    pre: function(p1: POSSL_PROVIDER; operation_id: Integer; data: Pointer; _result: PInteger): Integer;
    fn: procedure(p1: POSSL_PROVIDER; const p2: POSSL_ALGORITHM; no_store: Integer; data: Pointer);
    post: function(p1: POSSL_PROVIDER; operation_id: Integer; no_store: Integer; data: Pointer; _result: PInteger): Integer;
    data: Pointer;
  end;
  Palgorithm_data_st = ^algorithm_data_st;

  ossl_core_bio_st = record
    ref_cnt: CRYPTO_REF_COUNT;
    ref_lock: PCRYPTO_RWLOCK;
    bio: PBIO;
  end;
  TOSSL_CORE_BIO = ossl_core_bio_st;
  POSSL_CORE_BIO = ^TOSSL_CORE_BIO;

  TOSSL_FUNC_BIO_new_file_fn = function(const filename: PUTF8Char; const mode: PUTF8Char): POSSL_CORE_BIO;
  TOSSL_FUNC_BIO_ctrl_fn = function(bio: POSSL_CORE_BIO; cmd: Integer; num: Integer; ptr: Pointer): Integer;
  TOSSL_FUNC_BIO_new_membuf_fn = function(const buf: Pointer; len: Integer): POSSL_CORE_BIO;

  TOSSL_FUNC_BIO_read_ex_fn = function(bio: POSSL_CORE_BIO; data: Pointer; data_len: size_t; bytes_read: psize_t): Integer;

  TOSSL_FUNC_BIO_write_ex_fn = function(bio: POSSL_CORE_BIO; const data: Pointer; data_len: size_t; written: Psize_t): Integer;

  TOSSL_FUNC_BIO_gets_fn = function(bio: POSSL_CORE_BIO; buf: PUTF8Char; size: Integer): Integer;

  TOSSL_FUNC_BIO_puts_fn = function(bio: POSSL_CORE_BIO; const str: PUTF8Char): Integer;

  TOSSL_FUNC_BIO_up_ref_fn = function(bio: POSSL_CORE_BIO): Integer;

  TOSSL_FUNC_BIO_free_fn = function(bio: POSSL_CORE_BIO): Integer;

  TOSSL_FUNC_BIO_vprintf_fn = function(bio: POSSL_CORE_BIO; const format: PUTF8Char; args: Pointer): Integer;

  TOSSL_FUNC_BIO_vsnprintf_fn = function(buf: PUTF8Char; n: size_t; const fmt: PUTF8Char; args: Pointer): Integer;
  TOSSL_FUNC_get_entropy_fn = function(const handle: POSSL_CORE_HANDLE;out pout: PByte; entropy: Integer; min_len: size_t; max_len: size_t): size_t;
  TOSSL_FUNC_cleanup_entropy_fn = procedure(const handle: POSSL_CORE_HANDLE; buf: PByte; len: size_t);
  TOSSL_FUNC_get_nonce_fn = function(const handle: POSSL_CORE_HANDLE; pout: PPByte; min_len: size_t; max_len: size_t; const salt: Pointer; salt_len: size_t): size_t;
  TOSSL_FUNC_cleanup_nonce_fn = procedure(const handle: POSSL_CORE_HANDLE; buf: PByte; len: size_t);
  TOSSL_FUNC_core_gettable_params_fn = function(const prov: POSSL_CORE_HANDLE): POSSL_PARAM;
  TOSSL_FUNC_core_get_params_fn = function(const prov: POSSL_CORE_HANDLE; params: POSSL_PARAM): Integer;

  prov_ctx_st = record
    handle: POSSL_CORE_HANDLE;
    libctx: POSSL_LIB_CTX;
    corebiometh: PBIO_METHOD;
  end;

  TPROV_CTX = prov_ctx_st;
  PPROV_CTX = ^TPROV_CTX;

  tls_group_constants_st = record
    group_id: Cardinal;
    secbits: Cardinal;
    mintls: Integer;
    maxtls: Integer;
    mindtls: Integer;
    maxdtls: Integer;
  end;

  TLS_GROUP_CONSTANTS = tls_group_constants_st;
  PTLS_GROUP_CONSTANTS = ^TLS_GROUP_CONSTANTS;

  Tcapable_func = function(): Integer;
  ag_capable_st = record
    alg: TOSSL_ALGORITHM;
    capable: Tcapable_func;
  end;

  TOSSL_ALGORITHM_CAPABLE = ag_capable_st;
  POSSL_ALGORITHM_CAPABLE = ^TOSSL_ALGORITHM_CAPABLE;

  TPROV_DIGEST = record
    md: PEVP_MD;
    alloc_md: PEVP_MD;
    engine: PENGINE;
  end;
  PPROV_DIGEST = ^TPROV_DIGEST;

  TKDF_HKDF = record
    provctx: Pointer;
    mode: Integer;
    digest: TPROV_DIGEST;
    salt: PByte;
    salt_len: size_t;
    key: PByte;
    key_len: size_t;
    prefix: PByte;
    prefix_len: size_t;
    &label: PByte;
    label_len: size_t;
    data: PByte;
    data_len: size_t;
    info: array [0..2047] of Byte;
    info_len: size_t;
  end;
  PKDF_HKDF = ^TKDF_HKDF;

  TOSSL_FUNC_mac_newctx_fn = function(provctx: Pointer): Pointer;

  TOSSL_FUNC_mac_dupctx_fn = function(src: Pointer): Pointer;

  TOSSL_FUNC_mac_freectx_fn = procedure(mctx: Pointer);

  TOSSL_FUNC_mac_init_fn = function(mctx: Pointer; const key: PByte; keylen: size_t; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_mac_update_fn = function(mctx: Pointer; const &in: PByte; inl: size_t): Integer;

  TOSSL_FUNC_mac_final_fn = function(mctx: Pointer; &out: PByte; outl: Psize_t; outsize: size_t): Integer;

  TOSSL_FUNC_mac_gettable_params_fn = function(provctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_mac_gettable_ctx_params_fn = function(mctx: Pointer; provctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_mac_settable_ctx_params_fn = function(mctx: Pointer; provctx: Pointer): POSSL_PARAM;

  TOSSL_FUNC_mac_get_params_fn = function(params: POSSL_PARAM): Integer;

  TOSSL_FUNC_mac_get_ctx_params_fn = function(mctx: Pointer; params: POSSL_PARAM): Integer;

  TOSSL_FUNC_mac_set_ctx_params_fn = function(mctx: Pointer; params: POSSL_PARAM): Integer;

  evp_mac_st = record
    prov: POSSL_PROVIDER;
    name_id: Integer;
    type_name: PUTF8Char;
    description: PUTF8Char;
    refcnt: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
    newctx: TOSSL_FUNC_mac_newctx_fn;
    dupctx: TOSSL_FUNC_mac_dupctx_fn;
    freectx: TOSSL_FUNC_mac_freectx_fn;
    init: TOSSL_FUNC_mac_init_fn;
    update: TOSSL_FUNC_mac_update_fn;
    &final: TOSSL_FUNC_mac_final_fn;
    gettable_params: TOSSL_FUNC_mac_gettable_params_fn;
    gettable_ctx_params: TOSSL_FUNC_mac_gettable_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_mac_settable_ctx_params_fn;
    get_params: TOSSL_FUNC_mac_get_params_fn;
    get_ctx_params: TOSSL_FUNC_mac_get_ctx_params_fn;
    set_ctx_params: TOSSL_FUNC_mac_set_ctx_params_fn;
  end;
  TEVP_MAC = evp_mac_st;
  PEVP_MAC = ^TEVP_MAC;

  evp_mac_ctx_st = record
    meth: PEVP_MAC;
    algctx: Pointer;
  end;
  TEVP_MAC_CTX = evp_mac_ctx_st;
  PEVP_MAC_CTX = ^TEVP_MAC_CTX;
  PPEVP_MAC_CTX = ^PEVP_MAC_CTX;

  PWPACKET_SUB = ^TWPACKET_SUB;
  wpacket_sub = record
    parent: PWPACKET_SUB;
    packet_len: size_t;
    lenbytes: size_t;
    pwritten: size_t;
    flags: Cardinal;
  end;
  TWPACKET_SUB = wpacket_sub;


  wpacket_st = record
    buf: PBUF_MEM;
    staticbuf: PByte;
    curr: size_t;
    written: size_t;
    maxsize: size_t;
    subs: PWPACKET_SUB;
    endfirst: Cardinal;
  end;
  TWPACKET = wpacket_st;
  PWPACKET = ^TWPACKET;

  TKDF_SSKDF = record
    provctx: Pointer;
    macctx: PEVP_MAC_CTX;
    digest: TPROV_DIGEST;
    secret: PByte;
    secret_len: size_t;
    info: PByte;
    info_len: size_t;
    salt: PByte;
    salt_len: size_t;
    out_len: size_t;
  end;
  PKDF_SSKDF = ^TKDF_SSKDF;

  TKDF_PBKDF2 = record
    provctx: Pointer;
    pass: PByte;
    pass_len: size_t;
    salt: PByte;
    salt_len: size_t;
    iter: UInt64;
    digest: TPROV_DIGEST;
    lower_bound_checks: Integer;
  end;
  PKDF_PBKDF2 = ^TKDF_PBKDF2;

  PKDF_PKCS12 = ^TKDF_PKCS12;
  TKDF_PKCS12 = record
    provctx: Pointer;
    digest: TPROV_DIGEST;
    pass: PByte;
    pass_len: size_t;
    salt: PByte;
    salt_len: size_t;
    iter: UInt64;
    id: Integer;
  end;

  TKDF_SSHKDF = record
    provctx: Pointer;
    digest: TPROV_DIGEST;
    key: PByte;
    key_len: size_t;
    xcghash: PByte;
    xcghash_len: size_t;
    &type: UTF8Char;
    session_id: PByte;
    session_id_len: size_t;
  end;
  PKDF_SSHKDF = ^TKDF_SSHKDF;

  TTLS1_PRF = record
    provctx: Pointer;
    P_hash: PEVP_MAC_CTX;
    P_sha1: PEVP_MAC_CTX;
    sec: PByte;
    seclen: size_t;
    seed: array [0..1023] of Byte;
    seedlen: size_t;
  end;
  PTLS1_PRF = ^TTLS1_PRF;

  kbkdf_mode = (
    COUNTER = 0,
    FEEDBACK = 1);

  TKBKDF = record
    provctx: Pointer;
    mode: kbkdf_mode;
    ctx_init: PEVP_MAC_CTX;
    r: Integer;
    ki: PByte;
    ki_len: size_t;
    &label: PByte;
    label_len: size_t;
    context: PByte;
    context_len: size_t;
    iv: PByte;
    iv_len: size_t;
    use_l: Integer;
    use_separator: Integer;
  end;
  PKBKDF = ^TKBKDF;

  TKDF_X942 = record
    provctx: Pointer;
    digest: TPROV_DIGEST;
    secret: PByte;
    secret_len: size_t;
    acvpinfo: PByte;
    acvpinfo_len: size_t;
    partyuinfo: PByte;
    partyvinfo: PByte;
    supp_pubinfo: PByte;
    supp_privinfo: PByte;
    partyuinfo_len: size_t;
    partyvinfo_len: size_t;
    supp_pubinfo_len: size_t;
    supp_privinfo_len: size_t;
    dkm_len: size_t;
    cek_oid: PByte;
    cek_oid_len: size_t;
    use_keybits: Integer;
  end;
  PKDF_X942 = ^TKDF_X942;

  TKDF_SCRYPT = record
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
    pass: PByte;
    pass_len:size_t;
    salt: PByte;
    salt_len:size_t;
    N: UInt64;
    r: UInt64;
    p: UInt64;
    maxmem_bytes: UInt64;
    sha256: PEVP_MD;
  end;
  PKDF_SCRYPT = ^TKDF_SCRYPT;

  TOSSL_FUNC_kdf_newctx_fn = function(provctx: Pointer): Pointer;
  TOSSL_FUNC_kdf_dupctx_fn = function(src: Pointer): Pointer;
  TOSSL_FUNC_kdf_freectx_fn = procedure(kctx: Pointer);
  TOSSL_FUNC_kdf_reset_fn = procedure(kctx: Pointer);
  TOSSL_FUNC_kdf_derive_fn = function(kctx: Pointer; key: PByte; keylen:size_t; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_kdf_gettable_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_kdf_gettable_ctx_params_fn = function(kctx: Pointer; provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_kdf_settable_ctx_params_fn = function(kctx: Pointer; provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_kdf_get_params_fn = function(params: POSSL_PARAM): Integer;
  TOSSL_FUNC_kdf_get_ctx_params_fn = function(kctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_kdf_set_ctx_params_fn = function(kctx: Pointer; params: POSSL_PARAM): Integer;
  evp_kdf_st = record
    prov: POSSL_PROVIDER;
    name_id: Integer;
    type_name: PUTF8Char;
    description: PUTF8Char;
    refcnt: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
    newctx: TOSSL_FUNC_kdf_newctx_fn;
    dupctx: TOSSL_FUNC_kdf_dupctx_fn;
    freectx: TOSSL_FUNC_kdf_freectx_fn;
    reset: TOSSL_FUNC_kdf_reset_fn;
    derive: TOSSL_FUNC_kdf_derive_fn;
    gettable_params: TOSSL_FUNC_kdf_gettable_params_fn;
    gettable_ctx_params: TOSSL_FUNC_kdf_gettable_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_kdf_settable_ctx_params_fn;
    get_params: TOSSL_FUNC_kdf_get_params_fn;
    get_ctx_params: TOSSL_FUNC_kdf_get_ctx_params_fn;
    set_ctx_params: TOSSL_FUNC_kdf_set_ctx_params_fn;
  end;
  TEVP_KDF = evp_kdf_st;
  PEVP_KDF = ^TEVP_KDF;

  evp_kdf_ctx_st = record
    meth: PEVP_KDF;
    algctx: Pointer;
  end;
  TEVP_KDF_CTX = evp_kdf_ctx_st;
  PEVP_KDF_CTX = ^TEVP_KDF_CTX;

  TPROV_CIPHER = record
    cipher: PEVP_CIPHER;
    alloc_cipher: PEVP_CIPHER;
    engine: PENGINE;
  end;
  PPROV_CIPHER = ^TPROV_CIPHER;

  TKRB5KDF_CTX = record
    provctx: Pointer;
    cipher: TPROV_CIPHER;
    key: PByte;
    key_len:size_t;
    constant: PByte;
    constant_len:size_t;
  end;
  PKRB5KDF_CTX = ^TKRB5KDF_CTX;

 
  TOSSL_INOUT_CALLBACK = function(in_params: TOSSL_PARAM; out_params: TOSSL_PARAM; arg: Pointer): Integer;
  TOSSL_PASSPHRASE_CALLBACK = function(pass: PUTF8Char; pass_size:size_t; pass_len: Psize_t; const params: POSSL_PARAM; arg: Pointer): Integer;
  TOSSL_FUNC_rand_newctx_fn = function(provctx: Pointer; parent: Pointer; const parent_calls: POSSL_DISPATCH): Pointer;
  TOSSL_FUNC_rand_freectx_fn = procedure(vctx: Pointer);
  TOSSL_FUNC_rand_instantiate_fn = function(vdrbg: Pointer; strength: Cardinal; prediction_resistance: Integer; const pstr: PByte; pstr_len: size_t; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_rand_uninstantiate_fn = function(vdrbg: Pointer): Integer;
  TOSSL_FUNC_rand_generate_fn = function(vctx: Pointer; _out: PByte; outlen: size_t; strength: Cardinal; prediction_resistance: Integer; const addin: PByte; addin_len: size_t): Integer;
  TOSSL_FUNC_rand_reseed_fn = function(vctx: Pointer; prediction_resistance: Integer; const ent: PByte; ent_len: size_t; const addin: PByte; addin_len: size_t): Integer;
  TOSSL_FUNC_rand_nonce_fn = function(vctx: Pointer; &out: PByte; strength: Cardinal; min_noncelen: size_t; max_noncelen: size_t): size_t;
  TOSSL_FUNC_rand_enable_locking_fn = function(vctx: Pointer): Integer;
  TOSSL_FUNC_rand_lock_fn = function(vctx: Pointer): Integer;
  TOSSL_FUNC_rand_unlock_fn = procedure(vctx: Pointer);
  TOSSL_FUNC_rand_gettable_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_rand_gettable_ctx_params_fn = function(vctx: Pointer; provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_rand_settable_ctx_params_fn = function(vctx: Pointer; provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_rand_get_params_fn = function(params: POSSL_PARAM): Integer;
  TOSSL_FUNC_rand_get_ctx_params_fn = function(vctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_rand_set_ctx_params_fn = function(vctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_rand_set_callbacks_fn = procedure(vctx: Pointer; get_entropy: TOSSL_INOUT_CALLBACK; cleanup_entropy: POSSL_CALLBACK; get_nonce: TOSSL_INOUT_CALLBACK; cleanup_nonce: POSSL_CALLBACK; arg: Pointer);
  TOSSL_FUNC_rand_verify_zeroization_fn = function(vctx: Pointer): Integer;
  TOSSL_FUNC_rand_get_seed_fn = function(vctx: Pointer;out buffer: PByte; entropy: Integer; min_len: size_t; max_len: size_t; prediction_resistance: Integer; const adin: PByte; adin_len: size_t): size_t;
  TOSSL_FUNC_rand_clear_seed_fn = procedure(vctx: Pointer; buffer: PByte; b_len: size_t);

  drbg_status_e = (
    DRBG_UNINITIALISED = 0,
    DRBG_READY = 1,
    DRBG_ERROR = 2);
  Pdrbg_status_e = ^drbg_status_e;
  TDRBG_STATUS = drbg_status_e;

  PPROV_DRBG = ^TPROV_DRBG;
  prov_drbg_st = record
    lock: PCRYPTO_RWLOCK;
    provctx: PPROV_CTX;
    instantiate: function(drbg: PPROV_DRBG; const entropy: PByte; entropylen: size_t; const nonce: PByte; noncelen: size_t; const pers: PByte; perslen: size_t): Integer;
    uninstantiate: function(ctx: PPROV_DRBG): Integer;
    reseed: function(drbg: PPROV_DRBG; const ent: PByte; ent_len: size_t; const adin: PByte; adin_len: size_t): Integer;
    generate: function(p1: PPROV_DRBG; &out: PByte; outlen: size_t; const adin: PByte; adin_len: size_t): Integer;
    parent: Pointer;
    parent_enable_locking: TOSSL_FUNC_rand_enable_locking_fn;
    parent_lock: TOSSL_FUNC_rand_lock_fn;
    parent_unlock: TOSSL_FUNC_rand_unlock_fn;
    parent_get_ctx_params: TOSSL_FUNC_rand_get_ctx_params_fn;
    parent_nonce: TOSSL_FUNC_rand_nonce_fn;
    parent_get_seed: TOSSL_FUNC_rand_get_seed_fn;
    parent_clear_seed: TOSSL_FUNC_rand_clear_seed_fn;
    parent_dispatch: POSSL_DISPATCH;
    fork_id: Integer;
    flags: Word;
    strength: Cardinal;
    max_request: size_t;
    min_entropylen: size_t;
    max_entropylen: size_t;
    min_noncelen: size_t;
    max_noncelen: size_t;
    max_perslen: size_t;
    max_adinlen: size_t;
    generate_counter: Cardinal;
    reseed_interval: Cardinal;
    reseed_time: time_t;
    reseed_time_interval: time_t;
    reseed_counter: Cardinal;
    reseed_next_counter: Cardinal;
    parent_reseed_counter: Cardinal;
    seedlen: size_t;
    state: TDRBG_STATUS;
    data: Pointer;
    callback_arg: Pointer;
    get_entropy_fn: TOSSL_INOUT_CALLBACK;
    cleanup_entropy_fn: POSSL_CALLBACK;
    get_nonce_fn: TOSSL_INOUT_CALLBACK;
    cleanup_nonce_fn: POSSL_CALLBACK;
  end;
  TPROV_DRBG = prov_drbg_st;

  prov_drbg_nonce_global_st = record
    rand_nonce_lock: PCRYPTO_RWLOCK;
    rand_nonce_count: Integer;
  end;

  TPROV_DRBG_NONCE_GLOBAL = prov_drbg_nonce_global_st;
  PPROV_DRBG_NONCE_GLOBAL = ^TPROV_DRBG_NONCE_GLOBAL;

  crng_test_global_st = record
    crngt_prev: array [0..63] of Byte;
    md: PEVP_MD;
    preloaded: Integer;
    lock: PCRYPTO_RWLOCK;
  end;

  TCRNG_TEST_GLOBAL = crng_test_global_st;
  PCRNG_TEST_GLOBAL = ^TCRNG_TEST_GLOBAL;

  ossl_self_test_st = record
    phase: PUTF8Char;
    &type: PUTF8Char;
    desc: PUTF8Char;
    cb: POSSL_CALLBACK;
    params: array [0..3] of TOSSL_PARAM;
    cb_arg: Pointer;
  end;
  TOSSL_SELF_TEST = ossl_self_test_st;
  POSSL_SELF_TEST = ^TOSSL_SELF_TEST;

  self_test_cb_st = record
    cb: POSSL_CALLBACK;
    cbarg: Pointer;
  end;

  TSELF_TEST_CB = self_test_cb_st;
  PSELF_TEST_CB = ^TSELF_TEST_CB;

  rand_drbg_ctr_st = record
    ctx_ecb: PEVP_CIPHER_CTX;
    ctx_ctr: PEVP_CIPHER_CTX;
    ctx_df: PEVP_CIPHER_CTX;
    cipher_ecb: PEVP_CIPHER;
    cipher_ctr: PEVP_CIPHER;
    keylen: size_t;
    use_df: Integer;
    K: array [0..31] of Byte;
    V: array [0..15] of Byte;
    bltmp: array [0..15] of Byte;
    bltmp_pos: size_t;
    KX: array [0..47] of Byte;
  end;

  TPROV_DRBG_CTR = rand_drbg_ctr_st;
  PPROV_DRBG_CTR = ^TPROV_DRBG_CTR;

  rand_drbg_hash_st = record
    digest: TPROV_DIGEST;
    ctx: PEVP_MD_CTX;
    blocklen: size_t;
    V: array [0..110] of Byte;
    C: array [0..110] of Byte;
    vtmp: array [0..110] of Byte;
  end;

  TPROV_DRBG_HASH = rand_drbg_hash_st;
  PPROV_DRBG_HASH = ^TPROV_DRBG_HASH;

  rand_drbg_hmac_st = record
    ctx: PEVP_MAC_CTX;
    digest: TPROV_DIGEST;
    blocklen: size_t;
    K: array [0..63] of Byte;
    V: array [0..63] of Byte;
  end;

  TPROV_DRBG_HMAC = rand_drbg_hmac_st;
  PPROV_DRBG_HMAC = ^TPROV_DRBG_HMAC;

  TPROV_SEED_SRC = record
    provctx: Pointer;
    state: Integer;
  end;
  PPROV_SEED_SRC = ^TPROV_SEED_SRC;

  rand_pool_st = record
    buffer: PByte;
    len: size_t;
    attached: Integer;
    secure: Integer;
    min_len:size_t;
    max_len:size_t;
    alloc_len:size_t;
    entropy:size_t;
    entropy_requested:size_t;
  end;

  TRAND_POOL = rand_pool_st;
  PRAND_POOL = ^TRAND_POOL;

  TPROV_TEST_RNG = record
    provctx: Pointer;
    state: Integer;
    strength: Cardinal;
    max_request:size_t;
    entropy: PByte;
    nonce: PByte;
    entropy_len:size_t;
    entropy_pos:size_t;
    nonce_len:size_t;
    lock: PCRYPTO_RWLOCK;
  end;
  PPROV_TEST_RNG = ^TPROV_TEST_RNG;
  Pstack_st_OSSL_PARAM_BLD_DEF = Pointer;
  ossl_param_bld_st = record
    total_blocks: size_t;
    secure_blocks: size_t;
    params: Pstack_st_OSSL_PARAM_BLD_DEF;
  end;
  TOSSL_PARAM_BLD = ossl_param_bld_st;
  POSSL_PARAM_BLD = ^TOSSL_PARAM_BLD;

  num_st = record
    case Integer of
      0: (i: ossl_intmax_t);
      1: (u: ossl_uintmax_t);
      2: (d: Double);
  end;
  
  TOSSL_PARAM_BLD_DEF = record
    key: PUTF8Char;
    &type: Integer;
    secure: Integer;
    size: size_t;
    alloc_blocks: size_t;
    bn: PBIGNUM;
    &string: Pointer;
    num: num_st;
  end;
  POSSL_PARAM_BLD_DEF = ^TOSSL_PARAM_BLD_DEF;

  TOSSL_PARAM_ALIGNED_BLOCK = record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
  end;
  POSSL_PARAM_ALIGNED_BLOCK = ^TOSSL_PARAM_ALIGNED_BLOCK;

  dh_gen_ctx = record
    libctx: POSSL_LIB_CTX;
    ffc_params: PFFC_PARAMS;
    selection: Integer;
    group_nid: Integer;
    pbits:size_t;
    qbits:size_t;
    seed: PByte;
    seedlen:size_t;
    gindex: Integer;
    gen_type: Integer;
    generator: Integer;
    pcounter: Integer;
    hindex: Integer;
    priv_len: Integer;
    mdname: PUTF8Char;
    mdprops: PUTF8Char;
    cb: POSSL_CALLBACK;
    cbarg: Pointer;
    dh_type: Integer;
  end;
  Pdh_gen_ctx = ^dh_gen_ctx;

  PEVP_RAND_CTX = ^TEVP_RAND_CTX;
  PEVP_RAND = ^TEVP_RAND;
  evp_rand_ctx_st = record
    meth: PEVP_RAND;
    algctx: Pointer;
    parent: PEVP_RAND_CTX;
    refcnt: CRYPTO_REF_COUNT;
    refcnt_lock: PCRYPTO_RWLOCK;
  end;
  TEVP_RAND_CTX = evp_rand_ctx_st;

  evp_rand_st = record
    prov: POSSL_PROVIDER;
    name_id: Integer;
    type_name: PUTF8Char;
    description: PUTF8Char;
    refcnt: CRYPTO_REF_COUNT;
    refcnt_lock: PCRYPTO_RWLOCK;
    dispatch: POSSL_DISPATCH;
    newctx: TOSSL_FUNC_rand_newctx_fn;
    freectx: TOSSL_FUNC_rand_freectx_fn;
    instantiate: TOSSL_FUNC_rand_instantiate_fn;
    uninstantiate: TOSSL_FUNC_rand_uninstantiate_fn;
    generate: TOSSL_FUNC_rand_generate_fn;
    reseed: TOSSL_FUNC_rand_reseed_fn;
    nonce: TOSSL_FUNC_rand_nonce_fn;
    enable_locking: TOSSL_FUNC_rand_enable_locking_fn;
    lock: TOSSL_FUNC_rand_lock_fn;
    unlock: TOSSL_FUNC_rand_unlock_fn;
    gettable_params: TOSSL_FUNC_rand_gettable_params_fn;
    gettable_ctx_params: TOSSL_FUNC_rand_gettable_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_rand_settable_ctx_params_fn;
    get_params: TOSSL_FUNC_rand_get_params_fn;
    get_ctx_params: TOSSL_FUNC_rand_get_ctx_params_fn;
    set_ctx_params: TOSSL_FUNC_rand_set_ctx_params_fn;
    verify_zeroization: TOSSL_FUNC_rand_verify_zeroization_fn;
  end;

  TEVP_RAND = evp_rand_st;

  rand_global_st = record
    lock: PCRYPTO_RWLOCK;
    seed: PEVP_RAND_CTX;
    primary: PEVP_RAND_CTX;
    &public: CRYPTO_THREAD_LOCAL;
    &private: CRYPTO_THREAD_LOCAL;
    rng_name: PUTF8Char;
    rng_cipher: PUTF8Char;
    rng_digest: PUTF8Char;
    rng_propq: PUTF8Char;
    seed_name: PUTF8Char;
    seed_propq: PUTF8Char;
  end;

  TRAND_GLOBAL = rand_global_st;
  PRAND_GLOBAL = ^TRAND_GLOBAL;

  dh_name2id_st = record
    name: PUTF8Char;
    id, &type: int ;
  end;
  TDH_GENTYPE_NAME2ID = dh_name2id_st;

  dsa_gen_ctx = record
    libctx: POSSL_LIB_CTX;
    ffc_params: PFFC_PARAMS;
    selection: Integer;
    pbits: size_t;
    qbits: size_t;
    seed: PByte;
    seedlen: size_t;
    gindex: Integer;
    gen_type: Integer;
    pcounter: Integer;
    hindex: Integer;
    mdname: PUTF8Char;
    mdprops: PUTF8Char;
    cb: POSSL_CALLBACK;
    cbarg: Pointer;
  end;
  Pdsa_gen_ctx = ^dsa_gen_ctx;

  cb_st = record
    case Integer of
      0: (cb_1: procedure(p1: Integer; p2: Integer; p3: Pointer); );
      1: (cb_2: function(p1: Integer; p2: Integer; p3: PBN_GENCB): Integer; );
  end;

  bn_gencb_st = record
    ver: uint;
    arg: Pointer;
    cb: cb_st;
  end;
  TBN_GENCB = bn_gencb_st;
  TDSA_GENTYPE_NAME2ID = dh_name2id_st;
  Pstack_st_BIGNUM_const = Pointer;
  PBIGNUM_const = Pointer;
  Pstack_st_BIGNUM = Pointer;

  rsa_gen_ctx = record
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
    rsa_type: Integer;
    nbits: size_t;
    pub_exp: PBIGNUM;
    primes: size_t;
    pss_params: TRSA_PSS_PARAMS_30;
    pss_defaults_set: Integer;
    cb: POSSL_CALLBACK;
    cbarg: Pointer;
  end;

  Prsa_gen_ctx = ^rsa_gen_ctx;

  TEC_CURVE_DATA = record
    field_type: Integer;
    seed_len: Integer;
    param_len: Integer;
    cofactor: Cardinal;
  end;
  PEC_CURVE_DATA = ^TEC_CURVE_DATA;

  _ec_list_element_st = record
    nid: Integer;
    data: PEC_CURVE_DATA;
    meth: function(): PEC_METHOD;
    comment: PUTF8Char;
  end;

  Tec_list_element = _ec_list_element_st;
  Pec_list_element = ^Tec_list_element;

  Tec_gen_ctx = record
    libctx: POSSL_LIB_CTX;
    group_name: PUTF8Char;
    encoding: PUTF8Char;
    pt_format: PUTF8Char;
    group_check: PUTF8Char;
    field_type: PUTF8Char;
    p: PBIGNUM;
    a: PBIGNUM;
    b: PBIGNUM;
    order: PBIGNUM;
    cofactor: PBIGNUM;
    gen: PByte;
    seed: PByte;
    gen_len: size_t;
    seed_len: size_t;
    selection: Integer;
    ecdh_mode: Integer;
    gen_group: PEC_GROUP;
  end;
  Pec_gen_ctx = ^Tec_gen_ctx;

  kdf_data_st = record
    libctx: POSSL_LIB_CTX ;
     refcnt: CRYPTO_REF_COUNT;
   lock: PCRYPTO_RWLOCK ;
  end;
  TKDF_DATA = kdf_data_st ;
  PKDF_DATA = ^TKDF_DATA;

  mac_key_st = record
    lock: PCRYPTO_RWLOCK;
    libctx: POSSL_LIB_CTX;
    refcnt: CRYPTO_REF_COUNT;
    priv_key: PByte;
    priv_key_len: size_t;
    cipher: TPROV_CIPHER;
    properties: PUTF8Char;
    cmac: Integer;
  end;

  TMAC_KEY = mac_key_st;
  PMAC_KEY = ^TMAC_KEY;

  Tmac_gen_ctx = record
    libctx       : POSSL_LIB_CTX;
    selection    : integer;
    priv_key     : Pbyte;
    priv_key_len : size_t;
    cipher       : TPROV_CIPHER;
  end;
 Pmac_gen_ctx = ^Tmac_gen_ctx;

 Tkdf_type = (
    PROV_DH_KDF_NONE = 0,
    PROV_DH_KDF_X9_42_ASN1
);
 PROV_DH_CTX = record
    libctx: POSSL_LIB_CTX;
    dh: PDH;
    dhpeer: PDH;
    pad: Cardinal;
    kdf_type: Tkdf_type;
    kdf_md: PEVP_MD;
    kdf_ukm: PByte;
    kdf_ukmlen: size_t;
    kdf_outlen: size_t;
    kdf_cekalg: PUTF8Char;
  end;
  PPROV_DH_CTX = ^PROV_DH_CTX;

  Tkdf_type2 = (
    PROV_ECDH_KDF_NONE = 0,
    PROV_ECDH_KDF_X9_63
);
  TPROV_ECDH_CTX = record
    libctx: POSSL_LIB_CTX;
    k: PEC_KEY;
    peerk: PEC_KEY;
    cofactor_mode: Integer;
    (************
     * ECDH KDF *
     ************)
    kdf_type: Tkdf_type2;
    kdf_md: PEVP_MD;
    kdf_ukm: PByte;
    kdf_ukmlen: size_t;
    kdf_outlen: size_t;
  end;
  PPROV_ECDH_CTX = ^TPROV_ECDH_CTX;

  TPROV_ECX_CTX = record
     keylen : size_t;
     key, peerkey : PECX_KEY;
  end;
  PPROV_ECX_CTX = ^TPROV_ECX_CTX;

  //TKeyArray = TArray<Byte>;

   c448_error_t = (
    C448_SUCCESS = -1, //< The operation succeeded.
    C448_FAILURE = 0   //< The operation failed.
   ) ;

  gf_s = record
    limb: array [0..NLIMBS-1] of word_t;
  end;
  Tgf = array[0..0] of gf_s;
  Pgf_s = ^gf_s;

  TPROV_DSA_CTX = record
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
    dsa: PDSA;
    flag_allow_md: Cardinal;
    mdname: array [0..49] of UTF8Char;
    aid_buf: array [0..255] of Byte;
    aid: PByte;
    aid_len: size_t;
    md: PEVP_MD;
    mdctx: PEVP_MD_CTX;
    operation: Integer;
  end;
  PPROV_DSA_CTX = ^TPROV_DSA_CTX;

  //rsa_sig.c
  TPROV_RSA_CTX = record
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
    rsa: PRSA;
    operation: Integer;
    oaep_md: PEVP_MD ;
    flag_allow_md: Cardinal;
    mgf1_md_set: Cardinal;
    md: PEVP_MD;
    mdctx: PEVP_MD_CTX;
    mdnid: Integer;
    mdname: array [0..49] of UTF8Char;
    pad_mode: Integer;
    mgf1_md: PEVP_MD;
    mgf1_mdnid: Integer;
    mgf1_mdname: array [0..49] of UTF8Char;
    saltlen: Integer;
    min_saltlen: Integer;
    tbuf: PByte;
  end;
  PPROV_RSA_CTX = ^TPROV_RSA_CTX;

  //rsa.enc.c
  TPROV_RSA_CTX2 = record
    libctx: POSSL_LIB_CTX;
    rsa: PRSA;
    pad_mode: Integer;
    operation: Integer;
    oaep_md: PEVP_MD;
    mgf1_md: PEVP_MD;
    oaep_label: PByte;
    oaep_labellen: size_t;
    client_version: Cardinal;
    alt_version: Cardinal;
  end;

  PPROV_RSA_CTX2 = ^TPROV_RSA_CTX2;

  TPROV_EDDSA_CTX = record
    libctx: POSSL_LIB_CTX;
    key: PECX_KEY;
    aid_buf: array [0..255] of Byte;
    aid: PByte;
    aid_len: size_t;
  end;
  PPROV_EDDSA_CTX = ^TPROV_EDDSA_CTX;

  ed25519_st = record
    sig: array [0..63] of Byte;
    priv: array [0..31] of Byte;
  end;

  ed448_st = record
    sig: array [0..127] of Byte;
    priv: array [0..63] of Byte;
  end;

  niels_st = record
    a: Tgf;
    b: Tgf;
    c: Tgf;
  end;
  Pniels_s = ^niels_st;

  niels_t = array [0..0] of niels_st;
  Pniels_t = ^niels_t;

  curve448_precomputed_s = record
    table: array [0..79] of niels_t;
  end;
  Pcurve448_precomputed_s = ^curve448_precomputed_s;

  curve448_point_s = record
    x: Tgf;
    y: Tgf;
    z: Tgf;
    t: Tgf;
  end;

  curve448_point_t = array [0..0] of curve448_point_s;
  Pcurve448_point_t = ^curve448_point_t;

  curve448_scalar_s = record
    limb: array [0..13] of c448_word_t;
  end;

  curve448_scalar_t = array [0..0] of curve448_scalar_s;
  Pcurve448_scalar_t = ^curve448_scalar_t;
  Tsmvt_control = record
     power, addend: int;
  end;
  Psmvt_control = ^Tsmvt_control;

  pniels_st = record
    n: niels_t;
    z: Tgf;
  end;
  {0..0 (with range checks disabled!!!) is the best solution.
  Delphi has no facilities for unbounded arrays. }

  Ppniels = ^Tpniels;
  Tpniels = array [0..0] of pniels_st;

  TPROV_ECDSA_CTX = record
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
    ec: PEC_KEY;
    mdname: array [0..49] of UTF8Char;
    flag_allow_md: Cardinal;
    aid_buf: array [0..255] of Byte;
    aid: PByte;
    aid_len: size_t;
    mdsize: size_t;
    operation: Integer;
    md: PEVP_MD;
    mdctx: PEVP_MD_CTX;
    kinv: PBIGNUM;
    r: PBIGNUM;
  end;
  PPROV_ECDSA_CTX = ^TPROV_ECDSA_CTX;

  TPROV_SM2_CTX = record
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
    ec: PEC_KEY;
    flag_compute_z_digest: Cardinal;
    mdname: array [0..49] of UTF8Char;
    aid_buf: array [0..255] of Byte;
    aid: PByte;
    aid_len: size_t;
    md: PEVP_MD;
    mdctx: PEVP_MD_CTX;
    mdsize: size_t;
    id: PByte;
    id_len: size_t;
  end;
  PPROV_SM2_CTX = ^TPROV_SM2_CTX;

  lhash_st = record
    b                     : TArray<POPENSSL_LH_NODE>;
    comp                  : TOPENSSL_LH_COMPFUNC;
    hash                  : TOPENSSL_LH_HASHFUNC;
    num_nodes,
    num_alloc_nodes,
    p, pmax               : uint32;
    up_load,
    down_load,
    num_items,
    num_expands,
    num_expand_reallocs,
    num_contracts,
    num_contract_reallocs: ulong;
    {$IFNDEF FPC}[volatile]{$ENDIF} num_hash_calls,
     num_comp_calls: ulong;
    num_insert,
    num_replace,
    num_delete,
    num_no_delete: ulong;
    {$IFNDEF FPC}[volatile]{$ENDIF} num_retrieve: ulong;
    {$IFNDEF FPC}[volatile]{$ENDIF} num_retrieve_miss: ulong;
    {$IFNDEF FPC}[volatile]{$ENDIF} num_hash_comps: ulong;
    error                 : integer;
    tsan_lock             : PCRYPTO_RWLOCK;
  end;
  TOPENSSL_LHASH = lhash_st;
  POPENSSL_LHASH  = ^TOPENSSL_LHASH;

  TPROV_SM2_CTX2 = record
    libctx : POSSL_LIB_CTX;
    key : PEC_KEY;
    md : TPROV_DIGEST;
 end;
 PPROV_SM2_CTX2 = ^TPROV_SM2_CTX2;

 TPROV_RSA_CTX3 = record
    libctx : POSSL_LIB_CTX;
    rsa : PRSA;
   op : integer;
 end;
 PPROV_RSA_CTX3 = ^TPROV_RSA_CTX3;

 SM2_Ciphertext_st = record
    C1x, C1y : PBIGNUM;
    C3, C2 : PASN1_OCTET_STRING;
 end;
 TSM2_Ciphertext = SM2_Ciphertext_st;
 PSM2_Ciphertext = ^TSM2_Ciphertext;
 PPSM2_Ciphertext = ^PSM2_Ciphertext;

 stream_st = record
    case Integer of
      0: (cbc: cbc128_f);
      1: (ctr: ctr128_f);
      2: (ecb: ecb128_f);
  end;

  PPROV_CIPHER_CTX = ^TPROV_CIPHER_CTX;
  PPROV_CIPHER_HW = ^TPROV_CIPHER_HW;
  TPROV_CIPHER_HW_FN = function(dat: PPROV_CIPHER_CTX; _out: PByte;_in: PByte; len: size_t): Integer;

  prov_cipher_hw_st = record
    init: function(dat: PPROV_CIPHER_CTX; const key: PByte; keylen: size_t): Integer;
    cipher: TPROV_CIPHER_HW_FN;
    copyctx: procedure(dst: PPROV_CIPHER_CTX; const src: PPROV_CIPHER_CTX);
  end;
  TPROV_CIPHER_HW = prov_cipher_hw_st;

 prov_cipher_ctx_st = record
    block: block128_f;
    stream: stream_st ;
    mode: Cardinal;
    keylen: size_t;
    ivlen: size_t;
    blocksize: size_t;
    bufsz: size_t;
    cts_mode: Cardinal;
    pad: Cardinal;
    enc: Cardinal;
    iv_set: Cardinal;
    updated: Cardinal;
    variable_keylength: Cardinal;
    inverse_cipher: Cardinal;
    use_bits: Cardinal;
    tlsversion: Cardinal;
    tlsmac: PByte;
    alloced: Integer;
    tlsmacsize: size_t;
    removetlspad: Integer;
    removetlsfixed: size_t;
    num: Cardinal;
    oiv: array [0..15] of Byte;
    buf: array [0..15] of Byte;
    iv: array [0..15] of Byte;
    hw: PPROV_CIPHER_HW;
    ks: Pointer;
    libctx: POSSL_LIB_CTX;
  end;
 TPROV_CIPHER_CTX = prov_cipher_ctx_st;


 ks_st = record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: TAES_KEY);
  end;


  plat_st = record
    case Integer of
      0: (dummy: Integer);
  end;


  prov_aes_ctx_st = record
    base: TPROV_CIPHER_CTX;
    ks: ks_st;
    plat: plat_st;
  end;

  TPROV_AES_CTX = prov_aes_ctx_st;
  PPROV_AES_CTX = ^TPROV_AES_CTX;

  TOCB_BLOCK = record
    case Integer of
      0: (a: array [0..1] of uint64);
      1: (c: array [0..15] of Byte);
  end;
  POCB_BLOCK = ^TOCB_BLOCK;

  sess_st = record
    blocks_hashed: uint64;
    blocks_processed: uint64;
    offset_aad: TOCB_BLOCK;
    sum: TOCB_BLOCK;
    offset: TOCB_BLOCK;
    checksum: TOCB_BLOCK;
  end;

  Tocb128_context = record
    encrypt: block128_f;
    decrypt: block128_f;
    keyenc: Pointer;
    keydec: Pointer;
    stream: ocb128_f;
    l_index: size_t;
    max_l_index: size_t;
    l_star: TOCB_BLOCK;
    l_dollar: TOCB_BLOCK;
    l: POCB_BLOCK;
    sess: sess_st;
  end;

  TAES_key_schedule = record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: TAES_KEY);
  end;

  prov_aes_ocb_ctx_st = record
    base: TPROV_CIPHER_CTX;
    ksenc: TAES_key_schedule;
    ksdec: TAES_key_schedule;
    ocb: TOCB128_CONTEXT;
    iv_state: Cardinal;
    key_set: Cardinal;
    taglen: size_t;
    data_buf_len: size_t;
    aad_buf_len: size_t;
    tag: array [0..15] of Byte;
    data_buf: array [0..15] of Byte;
    aad_buf: array [0..15] of Byte;
  end;

  TPROV_AES_OCB_CTX = prov_aes_ocb_ctx_st;
  PPROV_AES_OCB_CTX = ^TPROV_AES_OCB_CTX;
  TOSSL_ocb_cipher_fn = function (ctx : PPROV_AES_OCB_CTX;const _in : PByte; _out : PByte; nextblock : size_t):integer;

  Tfn_set_enc_key = function (const userKey : PByte; bits : integer; key : PAES_KEY):integer;
  Tfn_set_dec_key = function (const userKey : PByte; bits : integer; key : PAES_KEY):integer;
  Tfn_block_enc  = procedure (const _in : PByte; _out : PByte;const key : Pointer);
  Tfn_block_dec  = procedure(const _in : PByte; _out : PByte;const key : Pointer);
  Tfn_stream_enc = ocb128_f;
  Tfn_stream_dec = ocb128_f;

  siv_block_u = record
    case Integer of
      0: (&word: array [0..1] of UInt64);
      1: (&byte: array [0..15] of Byte);
  end;

  TSIV_BLOCK = siv_block_u;
  PSIV_BLOCK = ^TSIV_BLOCK;

  siv128_context_st = record
    d: TSIV_BLOCK;
    tag: TSIV_BLOCK;
    cipher_ctx: PEVP_CIPHER_CTX;
    mac: PEVP_MAC;
    mac_ctx_init: PEVP_MAC_CTX;
    final_ret: Integer;
    crypto_ok: Integer;
  end;
  TSIV128_CONTEXT = siv128_context_st;
  PSIV128_CONTEXT = ^TSIV128_CONTEXT;

  prov_cipher_hw_aes_siv_st = record
    initkey: function(ctx: Pointer; const key: PByte; keylen: size_t): Integer;
    cipher: function(ctx: Pointer; &out: PByte; const &in: PByte; len: size_t): Integer;
    setspeed: procedure(ctx: Pointer; speed: Integer);
    settag: function(ctx: Pointer; const tag: PByte; tagl: size_t): Integer;
    cleanup: procedure(ctx: Pointer);
    dupctx: function(src: Pointer; dst: Pointer): Integer;
  end;

  TPROV_CIPHER_HW_AES_SIV = prov_cipher_hw_aes_siv_st;
  PPROV_CIPHER_HW_AES_SIV = ^TPROV_CIPHER_HW_AES_SIV;
  prov_siv_ctx_st = record
    mode: Cardinal;
    enc: Cardinal;
    keylen: size_t;
    taglen: size_t;
    siv: TSIV128_CONTEXT;
    ctr: PEVP_CIPHER;
    cbc: PEVP_CIPHER;
    hw: PPROV_CIPHER_HW_AES_SIV;
    libctx: POSSL_LIB_CTX;
  end;

  TPROV_AES_SIV_CTX = prov_siv_ctx_st;
  PPROV_AES_SIV_CTX = ^TPROV_AES_SIV_CTX;

  Tsha3_absorb_fn = function(vctx: Pointer; const inp: Pointer; len: size_t): size_t;
  Tsha3_final_fn = function(md: PByte; vctx: Pointer): Integer;

  prov_sha3_meth_st = record
    absorb: Tsha3_absorb_fn;
    &final: Tsha3_final_fn;
  end;

  TPROV_SHA3_METHOD = prov_sha3_meth_st;

  keccak_st = record
    A: array [0..4] of array [0..4] of UInt64;
    block_size: size_t;
    md_size: size_t;
    bufsz: size_t;
    buf: array [0..167] of Byte;
    pad: Byte;
    meth: TPROV_SHA3_METHOD;
  end;


  TKECCAK1600_CTX = keccak_st;
  PKECCAK1600_CTX = ^TKECCAK1600_CTX;

  SM3state_st = record
    A: Cardinal;
    B: Cardinal;
    C: Cardinal;
    D: Cardinal;
    E: Cardinal;
    F: Cardinal;
    G: Cardinal;
    H: Cardinal;
    Nl: Cardinal;
    Nh: Cardinal;
    data: array [0..15] of Cardinal;
    num: Cardinal;
  end;

  TSM3_CTX = SM3state_st;
  PSM3_CTX = ^TSM3_CTX;

  md5_sha1_st = record
    md5: TMD5_CTX ;
    sha1: TSHA_CTX ;
  end;
  TMD5_SHA1_CTX = md5_sha1_st;
  PMD5_SHA1_CTX = ^TMD5_SHA1_CTX;

  TNULLMD_CTX = record
     nothing:Byte;
  end ;
  PNULLMD_CTX = ^TNULLMD_CTX;

  blake2b_param_st = record
    digest_length: UInt8;
    key_length: UInt8;
    fanout: UInt8;
    depth: UInt8;
    leaf_length: array [0..3] of UInt8;
    node_offset: array [0..7] of UInt8;
    node_depth: UInt8;
    inner_length: UInt8;
    reserved: array [0..13] of UInt8;
    salt: array [0..15] of UInt8;
    personal: array [0..15] of UInt8;
  end;

  TBLAKE2B_PARAM = blake2b_param_st;
  PBLAKE2B_PARAM = ^TBLAKE2B_PARAM;

  blake2b_ctx_st = record
    h: array [0..7] of UInt64;
    t: array [0..1] of UInt64;
    f: array [0..1] of Int64;
    buf: array [0..127] of UInt8;
    buflen: size_t;
    outlen: size_t;
  end;

  blake2s_ctx_st = record
    h: array [0..7] of UInt32;
    t: array [0..1] of UInt32;
    f: array [0..1] of Int32;
    buf: array [0..63] of UInt8;
    buflen: size_t;
    outlen: size_t;
  end;

  TBLAKE2S_CTX = blake2s_ctx_st;
  PBLAKE2S_CTX = ^TBLAKE2S_CTX;
  TBLAKE2B_CTX = blake2b_ctx_st;
  PBLAKE2B_CTX = ^TBLAKE2B_CTX;
 

  blake2_mac_data_st = record
    ctx: TBLAKE2B_CTX ;
    params: TBLAKE2B_PARAM ;
    key: array[0..64-1] of Byte;
  end;
  Pblake2_mac_data_st = ^blake2_mac_data_st;

  blake2s_param_st = record
    digest_length: UInt8;
    key_length: UInt8;
    fanout: UInt8;
    depth: UInt8;
    leaf_length: array [0..3] of UInt8;
    node_offset: array [0..5] of UInt8;
    node_depth: UInt8;
    inner_length: UInt8;
    salt: array [0..7] of UInt8;
    personal: array [0..7] of UInt8;
  end;

  TBLAKE2S_PARAM = blake2s_param_st;
  PBLAKE2S_PARAM = ^TBLAKE2S_PARAM;

  TBLAKE2_PARAM_INIT_FUNC = procedure(P : Pointer);
  TBLAKE2_PARAM_SET_KEY_LENGTH_FUNC = procedure(P : Pointer; keylen: Byte);
  TBLAKE2_INIT_KEY_FUNC = function(c: Pointer; const P: Pointer; const key: Pointer): int;
  TBLAKE2_UPDATE_FUNC = function(c: Pointer; const data:Pointer; datalen: size_t):Int;
  TBLAKE2_FINAL_FUNC = function(md: PByte; c: Pointer):Int;
  TBLAKE2_PARAM_SET_DIGEST_LENGTH_FUNC = procedure(P: Pointer; outlen: Byte);
  TBLAKE2_PARAM_SET_PERSONAL_FUNC = procedure(P: Pointer; const personal: PByte; len: size_t);
  TBLAKE2_PARAM_SET_SALT_FUNC = procedure(P: Pointer; const salt: PByte; len: size_t);

  cmac_data_st = record
    provctx : Pointer;
    ctx : PCMAC_CTX;
    cipher : TPROV_CIPHER;
  end;
  Pcmac_data_st = ^cmac_data_st;

  CMAC_CTX_st = record
    cctx        : PEVP_CIPHER_CTX;
    k1,
    k2,
    tbl,
    last_block  : array[0..(EVP_MAX_BLOCK_LENGTH)-1] of byte;
    nlast_block : integer;
  end;
  TCMAC_CTX = CMAC_CTX_st;

  gmac_data_st = record

    provctx : Pointer;
    ctx : PEVP_CIPHER_CTX;
    cipher : TPROV_CIPHER;
  end;
  Pgmac_data_st = ^gmac_data_st;

  hmac_data_st = record
      provctx          : Pointer;
      ctx              : PHMAC_CTX;
      digest           : TPROV_DIGEST;
      key              : Pbyte;
      keylen,
      tls_data_size    : size_t;
      tls_header       : array[0..12] of byte;
      tls_header_set   : integer;
      tls_mac_out      : array[0..(EVP_MAX_MD_SIZE)-1] of byte;
      tls_mac_out_size : size_t;
  end;
  Phmac_data_st = ^hmac_data_st;

  kmac_data_st = record
      provctx    : Pointer;
      ctx        : PEVP_MD_CTX;
      digest     : TPROV_DIGEST;
      out_len,
      key_len,
      custom_len : size_t;
      xof_mode   : integer;
      key        : array[0..(KMAC_MAX_KEY_ENCODED)-1] of Byte;
      custom     : array[0..(KMAC_MAX_CUSTOM_ENCODED)-1] of Byte;
  end;
  Pkmac_data_st = ^kmac_data_st;

  siphash_st = record
    total_inlen: UInt64;
    v0: UInt64;
    v1: UInt64;
    v2: UInt64;
    v3: UInt64;
    len: Cardinal;
    hash_size: Cardinal;
    crounds: Cardinal;
    drounds: Cardinal;
    leavings: array [0..7] of Byte;
  end;
  TSIPHASH = siphash_st;
  PSIPHASH = ^TSIPHASH;

  siphash_data_st = record
      provctx : Pointer;
      siphash : TSIPHASH;
      crounds, drounds : uint32;
  end;
  Psiphash_data_st = ^siphash_data_st;



  poly1305_blocks_f = procedure(ctx: Pointer; const inp: PByte; len: size_t; padbit: uint32);

  poly1305_emit_f = procedure(ctx: Pointer; mac: PByte; nonce: Puint32);

  func_st = record
    blocks: poly1305_blocks_f;
    emit: poly1305_emit_f;
  end;


  poly1305_context = record
    opaque: array [0..23] of Double;
    nonce: array [0..3] of Cardinal;
    data: array [0..15] of Byte;
    num: size_t;
    func: func_st;
  end;
  TPOLY1305 = poly1305_context;
  PPOLY1305 = ^TPOLY1305;

  poly1305_data_st = record
    provctx: Pointer;
    poly1305: TPOLY1305 ;
  end;
  Ppoly1305_data_st = ^poly1305_data_st;

  ecx_gen_ctx = record

    libctx    : POSSL_LIB_CTX;
    propq     : PUTF8Char;
    &type     : TECX_KEY_TYPE;
    selection : integer;
  end;
  Pecx_gen_ctx = ^ecx_gen_ctx;

  type_st = (
    is_expl_passphrase = 1,
    is_pem_password = 2,
    is_ossl_passphrase = 3,
    is_ui_method = 4);


  expl_passphrase_st = record
    passphrase_copy: PUTF8Char;
    passphrase_len: size_t;
  end;


  pem_password_st = record
    password_cb: Tpem_password_cb;
    password_cbarg: Pointer;
  end;


  ossl_passphrase_st = record
    passphrase_cb: TOSSL_PASSPHRASE_CALLBACK;
    passphrase_cbarg: Pointer;
  end;

  ui_st = record
    meth: PUI_METHOD;
    strings: Pstack_st_UI_STRING;
    user_data: Pointer;
    ex_data: TCRYPTO_EX_DATA;
    flags: Integer;
    lock: PCRYPTO_RWLOCK;
  end;
  TUI = ui_st;
  PUI = ^TUI;

   ui_method_st = record
    name: PUTF8Char;
    ui_open_session: function(ui: PUI): Integer;
    ui_write_string: function(ui: PUI; uis: PUI_STRING): Integer;
    ui_flush: function(ui: PUI): Integer;
    ui_read_string: function(ui: PUI; uis: PUI_STRING): Integer;
    ui_close_session: function(ui: PUI): Integer;
    ui_duplicate_data: function(ui: PUI; ui_data: Pointer): Pointer;
    ui_destroy_data: procedure(ui: PUI; ui_data: Pointer);
    ui_construct_prompt: function(ui: PUI; const object_desc: PUTF8Char; const object_name: PUTF8Char): PUTF8Char;
    ex_data: TCRYPTO_EX_DATA;
  end;
  TUI_METHOD = ui_method_st;

  ui_method_t = record
    ui_method: PUI_METHOD;
    ui_method_data: Pointer;
  end;


  ossl_passphrase_data_st = record
      &type: type_st;
      _:  record
      case Integer of
        0: (expl_passphrase: expl_passphrase_st);
        1: (pem_password: pem_password_st);
        2: (ossl_passphrase: ossl_passphrase_st);
        3: (ui_method: ui_method_t);
      end;
      flag_cache_passphrase: Cardinal;
      cached_passphrase: PUTF8Char;
      cached_passphrase_len: size_t;
  end;
  Possl_passphrase_data_st = ^ossl_passphrase_data_st;

  key2any_ctx_st = record
    provctx: PPROV_CTX;
    save_parameters: Integer;
    cipher_intent: Integer;
    cipher: PEVP_CIPHER;
    pwdata: ossl_passphrase_data_st;
  end;
  Pkey2any_ctx_st = ^key2any_ctx_st;

  Tcheck_key_type_fn = function(const key: Pointer; nid: Integer): Integer;

  Tkey_to_paramstring_fn = function(const key: Pointer; nid, save: Integer; str: PPointer; strtype: PInteger): Integer;

  Tkey_to_der_fn = function(_out: PBIO; const key: Pointer; key_nid: Integer; const pemname: PUTF8Char; p2s: Tkey_to_paramstring_fn; k2d: Ti2d_of_void; ctx: Pkey2any_ctx_st): Integer;

  Twrite_bio_of_void_fn = function(bp: PBIO; const x: Pointer): Integer;

  Pstack_st_const_ASN1_VALUE = Pointer;

  TDER_ENC = record
    data : Pbyte;
    length : integer;
    field : PASN1_VALUE;
  end;
  PDER_ENC = ^TDER_ENC;

  ec_privatekey_st = record
    version: Int32;
    privateKey: PASN1_OCTET_STRING;
    parameters: PECPKPARAMETERS;
    publicKey: PASN1_BIT_STRING;
  end;

  TEC_PRIVATEKEY = ec_privatekey_st;
  PEC_PRIVATEKEY = ^TEC_PRIVATEKEY;
  PPEC_PRIVATEKEY = ^PEC_PRIVATEKEY;


  ecpk_parameters_st = record
    &type: Integer;
    value:  record
      case Integer of
        0: (named_curve: PASN1_OBJECT);
        1: (parameters: PECPARAMETERS);
        2: (implicitlyCA: PASN1_NULL);
    end;
  end;

  x9_62_pentanomial_st = record
    k1: Int32;
    k2: Int32;
    k3: Int32;
  end;

  TX9_62_PENTANOMIAL = x9_62_pentanomial_st;
  PX9_62_PENTANOMIAL = ^TX9_62_PENTANOMIAL;

  x9_62_characteristic_two_st = record
    m: Int32;
    &type: PASN1_OBJECT;
    p: record
      case Integer of
      0: (ptr: PUTF8Char);
      1: (onBasis: PASN1_NULL);
      2: (tpBasis: PASN1_INTEGER);
      3: (ppBasis: PX9_62_PENTANOMIAL);
      4: (other: PASN1_TYPE);
    end;
  end;

  TX9_62_CHARACTERISTIC_TWO = x9_62_characteristic_two_st;
  PX9_62_CHARACTERISTIC_TWO = ^TX9_62_CHARACTERISTIC_TWO;

  x9_62_fieldid_st = record
    fieldType: PASN1_OBJECT;
    p: record
    case Integer of
      0: (ptr: PUTF8Char);
      1: (prime: PASN1_INTEGER);
      2: (char_two: PX9_62_CHARACTERISTIC_TWO);
      3: (other: PASN1_TYPE);
    end;
  end;
  X9_62_FIELDID = x9_62_fieldid_st;
  PX9_62_FIELDID = ^X9_62_FIELDID;

  x9_62_curve_st = record
    a: PASN1_OCTET_STRING;
    b: PASN1_OCTET_STRING;
    seed: PASN1_BIT_STRING;
  end;
  TX9_62_CURVE = x9_62_curve_st;
  PX9_62_CURVE = ^TX9_62_CURVE;

  ec_parameters_st = record
    version: Int32;
    fieldID: PX9_62_FIELDID;
    curve: PX9_62_CURVE;
    base: PASN1_OCTET_STRING;
    order: PASN1_INTEGER;
    cofactor: PASN1_INTEGER;
  end;

  TECPARAMETERS = ec_parameters_st;
  TECPKPARAMETERS = ecpk_parameters_st;

  key2ms_ctx_st = record
    provctx        : PPROV_CTX;
    pvk_encr_level : integer;
    pwdata         : ossl_passphrase_data_st;
  end;
  Pkey2ms_ctx_st = ^key2ms_ctx_st;

  TEVP_PBE_KEYGEN_EX = function(ctx: PEVP_CIPHER_CTX; const pass: PUTF8Char; passlen: Integer; param: PASN1_TYPE; const cipher: PEVP_CIPHER; const md: PEVP_MD; en_de: Integer; libctx: POSSL_LIB_CTX; const propq: PUTF8Char): Integer;
  PEVP_PBE_KEYGEN_EX = ^TEVP_PBE_KEYGEN_EX;

  TEVP_PBE_KEYGEN = function(ctx: PEVP_CIPHER_CTX; const pass: PUTF8Char; passlen: Integer; param: PASN1_TYPE; const cipher: PEVP_CIPHER; const md: PEVP_MD; en_de: Integer): Integer;
  PEVP_PBE_KEYGEN = ^TEVP_PBE_KEYGEN;

  evp_pbe_st = record
     pbe_type,
     pbe_nid,
     cipher_nid,
     md_nid     : integer;
     keygen     : TEVP_PBE_KEYGEN;
     keygen_ex  : TEVP_PBE_KEYGEN_EX;
  end;
  TEVP_PBE_CTL = evp_pbe_st ;
  PEVP_PBE_CTL = ^TEVP_PBE_CTL;
  PSTACK_st_EVP_PBE_CTL = Pointer;

  Tcmp_func = function(const p1, p2: Pointer): Integer;

  X509_sig_st = record
    algor: PX509_ALGOR;
    digest: PASN1_OCTET_STRING;
  end;
  TX509_SIG = X509_sig_st;

   FILE_st = record

    curp : PByte;
    buffer : PByte;
    level, bsize : integer;
    istemp, flags : uint16;
    hold : WideChar;
    fd : byte;
    token : Byte;
  end;

  PFILE = Pointer;
  PPFILE = ^PFILE;
  PTextFile = ^Text;

  sk_EX_CALLBACK_compfunc = function (const a, b : PEX_CALLBACK):integer;
  sk_EX_CALLBACK_freefunc = procedure ( a : PEX_CALLBACK);
  sk_EX_CALLBACK_copyfunc = function (const a : PEX_CALLBACK):PEX_CALLBACK;

  lhash_st_OBJ_NAME = record
    dummy: record
      case Integer of
        0: (d1: Pointer);
        1: (d2: Cardinal);
        2: (d3: Integer);
    end;
  end;
  Plhash_st_OBJ_NAME = ^lhash_st_OBJ_NAME;

 
  Pstack_st_NAME_FUNCS = Pointer;

  name_funcs_st = record
    hash_func: function(const name: PUTF8Char): Cardinal;
    cmp_func: function(const a: PUTF8Char; const b: PUTF8Char): Integer;
    free_func: procedure(const p1: PUTF8Char; p2: Integer; const p3: PUTF8Char);
  end;
  TNAME_FUNCS = name_funcs_st;
  PNAME_FUNCS = ^TNAME_FUNCS;

  added_obj_st = record
    &type : integer;
    obj : PASN1_OBJECT;
  end;
  TADDED_OBJ = added_obj_st;
  PADDED_OBJ = ^TADDED_OBJ;

  lh_ADDED_OBJ_dummy = record
    case Integer of
      0: (d1: Pointer);
      1: (d2: Cardinal);
      2: (d3: Integer);
  end;

  lhash_st_ADDED_OBJ = record
    dummy: lh_ADDED_OBJ_dummy;
  end;

  Plhash_st_ADDED_OBJ = ^lhash_st_ADDED_OBJ;

  TOBJ_DOALL = record
    &type: Integer;
    fn: procedure(const p1: POBJ_NAME; arg: Pointer);
    arg: Pointer;
  end;
  POBJ_DOALL = ^TOBJ_DOALL;

  bn_blinding_st = record
    A: PBIGNUM;
    Ai: PBIGNUM;
    e: PBIGNUM;
    &mod: PBIGNUM;
    tid: CRYPTO_THREAD_ID;
    counter: Integer;
    flags: Cardinal;
    m_ctx: PBN_MONT_CTX;
    bn_mod_exp: function(r: PBIGNUM; const a: PBIGNUM; const p: PBIGNUM; const m: PBIGNUM; ctx: PBN_CTX; m_ctx: PBN_MONT_CTX): Integer;
    lock: PCRYPTO_RWLOCK;
  end;
  TBN_BLINDING = bn_blinding_st;

  bn_mont_ctx_st = record
    ri: Integer;
    RR: TBIGNUM;
    N:  TBIGNUM;
    Ni: TBIGNUM;
    n0: array [0..1] of UInt64;
    flags: Integer;
  end;
  TBN_MONT_CTX = bn_mont_ctx_st;

  bn_recp_ctx_st = record
    N: TBIGNUM;
    Nr: TBIGNUM;
    num_bits: Integer;
    shift: Integer;
    flags: Integer;
  end;

  TBN_RECP_CTX = bn_recp_ctx_st;

  lh_ENGINE_PILE_dummy = record
    case Integer of
      0: (d1: Pointer);
      1: (d2: Cardinal);
      2: (d3: Integer);
  end;

  lhash_st_ENGINE_PILE = record
    dummy: record
          case Integer of
            0: (d1: Pointer);
            1: (d2: Cardinal);
            2: (d3: Integer);
    end;
  end;
  Plhash_st_ENGINE_PILE = ^lhash_st_ENGINE_PILE;

  st_engine_table = record
    piles: lhash_st_ENGINE_PILE;
  end;
  TENGINE_TABLE = st_engine_table;
  PENGINE_TABLE = ^TENGINE_TABLE;
  PPENGINE_TABLE = ^PENGINE_TABLE;

  Pstack_st_ENGINE = Pointer;
  st_engine_pile = record
    nid: Integer;
    sk: Pstack_st_ENGINE;
    funct: PENGINE;
    uptodate: Integer;
  end;

  TENGINE_PILE = st_engine_pile;
  PENGINE_PILE = ^TENGINE_PILE;

  TPACKET = record
      curr      : Pbyte;
      remaining : size_t;
  end;
  PPACKET = ^TPACKET;

  TRSA_PKEY_CTX = record
    nbits         : integer;
    pub_exp       : PBIGNUM;
    primes        : integer;
    gentmp        : array[0..1] of integer;
    pad_mode      : integer;
    md,
    mgf1md        : PEVP_MD;
    saltlen,
    min_saltlen   : integer;
    tbuf,
    oaep_label    : PByte;
    oaep_labellen : size_t;
  end;
  PRSA_PKEY_CTX = ^TRSA_PKEY_CTX;
  PRSA_ACVP_TEST = Pointer;

  TDH_PKEY_CTX = record

    prime_len,
    generator,
    paramgen_type,
    subprime_len,
    pad           : integer;
    md            : PEVP_MD;
    param_nid     : integer;
    gentmp        : array[0..1] of integer;
    kdf_type      : byte;
    kdf_oid       : PASN1_OBJECT;
    kdf_md        : PEVP_MD;
    kdf_ukm       : PByte;
    kdf_ukmlen,
    kdf_outlen    : size_t;
  end;
  PDH_PKEY_CTX = ^TDH_PKEY_CTX;

  TDSA_PKEY_CTX = record
     nbits, qbits : integer;
     pmd : PEVP_MD;
     gentmp : array[0..1] of integer;
     md : PEVP_MD;
  end;
  PDSA_PKEY_CTX = ^TDSA_PKEY_CTX;

  ECDSA_SIG_st = record
    r: PBIGNUM;
    s: PBIGNUM;
  end;
  TECDSA_SIG = ECDSA_SIG_st;

  ec_pre_comp_st = record
    group      : PEC_GROUP;
    blocksize,
    numblocks,
    w          : size_t;
    points     : PPEC_POINT;
    num        : size_t;
    references : CRYPTO_REF_COUNT;
    lock       : PCRYPTO_RWLOCK;
  end;
  TEC_PRE_COMP = ec_pre_comp_st;

  TEC_PKEY_CTX = record
    gen_group     : PEC_GROUP;
    md            : PEVP_MD;
    co_key        : PEC_KEY;
    cofactor_mode : int8;
    kdf_type      : byte;
    kdf_md        : PEVP_MD;
    kdf_ukm       : PByte;
    kdf_ukmlen,
    kdf_outlen    : size_t;
  end;
  PEC_PKEY_CTX = ^TEC_PKEY_CTX;

  ecx_key_op_t = (
    KEY_OP_PUBLIC = 0,
    KEY_OP_PRIVATE = 1,
    KEY_OP_KEYGEN = 2);

  TOP_CACHE_ELEM = record
    keymgmt: PEVP_KEYMGMT;
    keydata: Pointer;
  end;
  POP_CACHE_ELEM = ^TOP_CACHE_ELEM;

  evp_keymgmt_util_try_import_data_st = record
    keymgmt: PEVP_KEYMGMT;
    keydata: Pointer;
    selection: Integer;
  end;
  Pevp_keymgmt_util_try_import_data_st = ^evp_keymgmt_util_try_import_data_st;


   Tuser_fn            = procedure(method: Pointer; arg : Pointer);
   {Tnew_method_func    = function (const name_id : integer;const algodef : POSSL_ALGORITHM; prov : POSSL_PROVIDER):Pointer;
   Tup_ref_method_func = function ( p1 : Pointer):integer;
   Tfree_method_func   = procedure ( p1 : Pointer);
   }
   pkcs8_priv_key_info_st = record
    version: PASN1_INTEGER;
    pkeyalg: PX509_ALGOR;
    pkey: PASN1_OCTET_STRING;
    attributes: Pstack_st_X509_ATTRIBUTE;
  end;
  TPKCS8_PRIV_KEY_INFO = pkcs8_priv_key_info_st;

  x509_attributes_st = record
    _object: PASN1_OBJECT;
    _set: Pstack_st_ASN1_TYPE;
  end;
  TX509_ATTRIBUTE = x509_attributes_st;

  Pstack_st_PASN1_STRING_TABLE = Pointer;

  x509_cert_aux_st = record
    trust: Pstack_st_ASN1_OBJECT;
    reject: Pstack_st_ASN1_OBJECT;
    alias: PASN1_UTF8STRING;
    keyid: PASN1_OCTET_STRING;
    other: Pstack_st_X509_ALGOR;
  end;
  TX509_CERT_AUX = x509_cert_aux_st;
  Pstack_st_nid_triple = Pointer;

  Ttm = record
    tm_sec: int ;                   {* Seconds.     [0-60] (1 leap second) *}
    tm_min: int ;                   {* Minutes.     [0-59] *}
    tm_hour: int ;                  {* Hours.       [0-23] *}
    tm_mday: int ;                  {* Day.         [1-31] *}
    tm_mon: int ;                   {* Month.       [0-11] *}
    tm_year: int;                  {* Year - 1900.  *}
    tm_wday: int;                  {* Day of week. [0-6] *}
    tm_yday: int;                  {* Days in year.[0-365] *}
    tm_isdst: int ;                 {* DST.         [-1/0/1]*}

    {$ifdef  __USE_BSD}
      long int tm_gmtoff;           {* Seconds east of UTC.  *}
      __const char *tm_zone;        {* Timezone abbreviation.  *}
    {$else}
       __tm_gmtoff: longint;         {* Seconds east of UTC.  *}
      __tm_zone: PUTF8Char;      {* Timezone abbreviation.  *}
    {$endif}
  end;
  Ptm = ^Ttm;

  X509_name_entry_st = record
    _object: PASN1_OBJECT;
    value: PASN1_STRING;
    _set: Integer;
    size: Integer;
  end;
  TX509_NAME_ENTRY = X509_name_entry_st;

  X509_name_st = record
    entries: Pstack_st_X509_NAME_ENTRY;
    modified: Integer;
    bytes: PBUF_MEM;
    canon_enc: PByte;
    canon_enclen: Integer;
  end;
  TX509_NAME = X509_name_st;
  PSTACK_OF_X509_NAME_ENTRY = Pointer;

  asn1_pctx_st = record
    flags: Cardinal;
    nm_flags: Cardinal;
    cert_flags: Cardinal;
    oid_flags: Cardinal;
    str_flags: Cardinal;
  end;
  TASN1_PCTX = asn1_pctx_st;

  X509_extension_st = record
    _object: PASN1_OBJECT;
    critical: ASN1_BOOLEAN;
    value: TASN1_OCTET_STRING;
  end;
  TX509_EXTENSION = X509_extension_st ;

  ossl_endecode_base_st = record
    prov: POSSL_PROVIDER;
    id: Integer;
    name: PUTF8Char;
    algodef: POSSL_ALGORITHM;
    parsed_propdef: POSSL_PROPERTY_LIST;
    refcnt: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
  end;


  TOSSL_FUNC_decoder_newctx_fn = function(provctx: Pointer): Pointer;
  TOSSL_FUNC_decoder_freectx_fn = procedure(ctx: Pointer);
  TOSSL_FUNC_decoder_get_params_fn = function(params: POSSL_PARAM): Integer;
  TOSSL_FUNC_decoder_gettable_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_decoder_set_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_decoder_settable_ctx_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_decoder_does_selection_fn = function(provctx: Pointer; selection: Integer): Integer;
  TOSSL_FUNC_decoder_decode_fn = function(ctx: Pointer; &in: POSSL_CORE_BIO; selection: Integer; data_cb: POSSL_CALLBACK; data_cbarg: Pointer; pw_cb: TOSSL_PASSPHRASE_CALLBACK; pw_cbarg: Pointer): Integer;
  TOSSL_FUNC_decoder_export_object_fn = function(ctx: Pointer; const objref: Pointer; objref_sz: size_t; export_cb: POSSL_CALLBACK; export_cbarg: Pointer): Integer;

  ossl_decoder_st = record
    base: ossl_endecode_base_st;
    newctx: TOSSL_FUNC_decoder_newctx_fn;
    freectx: TOSSL_FUNC_decoder_freectx_fn;
    get_params: TOSSL_FUNC_decoder_get_params_fn;
    gettable_params: TOSSL_FUNC_decoder_gettable_params_fn;
    set_ctx_params: TOSSL_FUNC_decoder_set_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_decoder_settable_ctx_params_fn;
    does_selection: TOSSL_FUNC_decoder_does_selection_fn;
    decode: TOSSL_FUNC_decoder_decode_fn;
    export_object: TOSSL_FUNC_decoder_export_object_fn;
  end;

  TOSSL_DECODER = ossl_decoder_st;
  POSSL_DECODER = ^TOSSL_DECODER;

  ossl_decoder_instance_st = record
    decoder: POSSL_DECODER;
    decoderctx: Pointer;
    input_type: PUTF8Char;
    input_structure: PUTF8Char;
    flag_input_structure_was_set: Cardinal;
  end;
  TOSSL_DECODER_INSTANCE = ossl_decoder_instance_st;
  POSSL_DECODER_INSTANCE = ^TOSSL_DECODER_INSTANCE;

  TOSSL_DECODER_CLEANUP = procedure(construct_data: Pointer);
  TOSSL_DECODER_CONSTRUCT = function(decoder_inst: POSSL_DECODER_INSTANCE; const params: POSSL_PARAM; construct_data: Pointer): Integer;
  Pstack_st_OSSL_DECODER_INSTANCE = Pointer;

  ossl_decoder_ctx_st = record
    start_input_type: PUTF8Char;
    input_structure: PUTF8Char;
    selection: Integer;
    decoder_insts: Pstack_st_OSSL_DECODER_INSTANCE;
    construct: TOSSL_DECODER_CONSTRUCT;
    cleanup: TOSSL_DECODER_CLEANUP;
    construct_data: Pointer;
    pwdata: ossl_passphrase_data_st;
  end;
  TOSSL_DECODER_CTX = ossl_decoder_ctx_st;
  POSSL_DECODER_CTX = ^TOSSL_DECODER_CTX;

  string_data_st = record
    result_minsize: Integer;
    result_maxsize: Integer;
    test_buf: PUTF8Char;
  end;


  boolean_data_st = record
    action_desc: PUTF8Char;
    ok_chars: PUTF8Char;
    cancel_chars: PUTF8Char;
  end;

  ui_string_st = record
    &type: TUI_string_types;
    out_string: PUTF8Char;
    input_flags: Integer;
    result_buf: PUTF8Char;
    result_len: size_t;
    _: record
    case Integer of
      0: (string_data: string_data_st);
      1: (boolean_data: boolean_data_st);
    end;
    flags: Integer;
  end;
  TUI_STRING = ui_string_st;

  sk_UI_STRING_compfunc = function(const a, b : PPUI_STRING):integer;
  sk_UI_STRING_freefunc = procedure ( a : PUI_STRING);
  sk_UI_STRING_copyfunc = function (const a : PUI_STRING):PUI_STRING;



  evp_Encode_Ctx_st = record
    num: Integer;
    length: Integer;
    enc_data: array [0..79] of UTF8Char;
    line_num: Integer;
    flags: Cardinal;
  end;
  TEVP_ENCODE_CTX = evp_Encode_Ctx_st;


  Tpem_password_cb_data = record
    cb : Tpem_password_cb;
    rwflag : integer;
  end;
  Ppem_password_cb_data = ^Tpem_password_cb_data;

  Pstack_st_EVP_KEYMGMT = Pointer;
  decoder_pkey_data_st = record
    libctx      : POSSL_LIB_CTX;
    propq       : PUTF8Char;
    selection   : integer;
    keymgmts    : Pstack_st_EVP_KEYMGMT;
    object_type : PUTF8Char;
    _object     : PPointer;
  end;
  Pdecoder_pkey_data_st = ^decoder_pkey_data_st;

  sk_EVP_KEYMGMT_freefunc = procedure ( a : Pointer);//PEVP_KEYMGMT);
  Tnode_func = procedure(p: PPointer);
   //Tleaf_func2 = procedure(p1: ossl_uintmax_t; p2: PALGORITHM; p3: Pointer);
   //Tleaf_func1 = procedure(p1: ossl_uintmax_t; p2: Pointer);

  Pstack_st_OSSL_DECODER = Pointer;
  sk_OSSL_DECODER_freefunc = procedure ( a : POSSL_DECODER);
  sk_OSSL_DECODER_INSTANCE_freefunc = procedure( a : POSSL_DECODER_INSTANCE);

  bio_f_buffer_ctx_struct = record
    ibuf_size: Integer;
    obuf_size: Integer;
    ibuf: PUTF8Char;
    ibuf_len: Integer;
    ibuf_off: Integer;
    obuf: PUTF8Char;
    obuf_len: Integer;
    obuf_off: Integer;
  end;

  TBIO_F_BUFFER_CTX = bio_f_buffer_ctx_struct;
  PBIO_F_BUFFER_CTX = ^TBIO_F_BUFFER_CTX;

  X509_req_info_st = record
    enc: TASN1_ENCODING;
    version: PASN1_INTEGER;
    subject: PX509_NAME;
    pubkey: PX509_PUBKEY;
    attributes: Pstack_st_X509_ATTRIBUTE;
  end;
  TX509_REQ_INFO = X509_req_info_st;

  X509_req_st = record
    req_info: TX509_REQ_INFO;
    sig_alg: TX509_ALGOR;
    signature: PASN1_BIT_STRING;
    references: CRYPTO_REF_COUNT;
    lock: PCRYPTO_RWLOCK;
    distinguishing_id: PASN1_OCTET_STRING;
    libctx: POSSL_LIB_CTX;
    propq: PUTF8Char;
  end;
  TX509_REQ = X509_req_st;

  TOSSL_FUNC_encoder_newctx_fn = function(provctx: Pointer): Pointer;
  TOSSL_FUNC_encoder_freectx_fn = procedure(ctx: Pointer);
  TOSSL_FUNC_encoder_get_params_fn = function(params: POSSL_PARAM): Integer;
  TOSSL_FUNC_encoder_gettable_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_encoder_set_ctx_params_fn = function(ctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_encoder_settable_ctx_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_encoder_does_selection_fn = function(provctx: Pointer; selection: Integer): Integer;
  TOSSL_FUNC_encoder_encode_fn = function(ctx: Pointer; &out: POSSL_CORE_BIO; const obj_raw: Pointer; obj_abstract: POSSL_PARAM; selection: Integer; cb: TOSSL_PASSPHRASE_CALLBACK; cbarg: Pointer): Integer;
  TOSSL_FUNC_encoder_import_object_fn = function(ctx: Pointer; selection: Integer; params: POSSL_PARAM): Pointer;
  TOSSL_FUNC_encoder_free_object_fn = procedure(obj: Pointer);

  ossl_encoder_st = record
    base: ossl_endecode_base_st;
    newctx: TOSSL_FUNC_encoder_newctx_fn;
    freectx: TOSSL_FUNC_encoder_freectx_fn;
    get_params: TOSSL_FUNC_encoder_get_params_fn;
    gettable_params: TOSSL_FUNC_encoder_gettable_params_fn;
    set_ctx_params: TOSSL_FUNC_encoder_set_ctx_params_fn;
    settable_ctx_params: TOSSL_FUNC_encoder_settable_ctx_params_fn;
    does_selection: TOSSL_FUNC_encoder_does_selection_fn;
    encode: TOSSL_FUNC_encoder_encode_fn;
    import_object: TOSSL_FUNC_encoder_import_object_fn;
    free_object: TOSSL_FUNC_encoder_free_object_fn;
  end;

  TOSSL_ENCODER = ossl_encoder_st;
  POSSL_ENCODER = ^TOSSL_ENCODER;

  ossl_encoder_instance_st = record
    encoder: POSSL_ENCODER;
    encoderctx: Pointer;
    output_type: PUTF8Char;
    output_structure: PUTF8Char;
  end;
  Pstack_st_OSSL_ENCODER_INSTANCE = Pointer;
  TOSSL_ENCODER_INSTANCE = ossl_encoder_instance_st;
  POSSL_ENCODER_INSTANCE = ^TOSSL_ENCODER_INSTANCE;
  PPOSSL_ENCODER_INSTANCE = ^POSSL_ENCODER_INSTANCE;
  TOSSL_ENCODER_CONSTRUCT = function(encoder_inst: POSSL_ENCODER_INSTANCE; construct_data: Pointer): Pointer;
  TOSSL_ENCODER_CLEANUP = procedure(construct_data: Pointer);

  ossl_encoder_ctx_st = record
    selection: Integer;
    output_type: PUTF8Char;
    output_structure: PUTF8Char;
    encoder_insts: Pstack_st_OSSL_ENCODER_INSTANCE;
    construct: TOSSL_ENCODER_CONSTRUCT;
    cleanup: TOSSL_ENCODER_CLEANUP;
    construct_data: Pointer;
    pwdata: ossl_passphrase_data_st;
  end;
  TOSSL_ENCODER_CTX = ossl_encoder_ctx_st;
  POSSL_ENCODER_CTX = ^TOSSL_ENCODER_CTX;

  sk_OSSL_ENCODER_INSTANCE_compfunc = function(const a: PPOSSL_ENCODER_INSTANCE; const b: PPOSSL_ENCODER_INSTANCE): Integer;
  sk_OSSL_ENCODER_INSTANCE_freefunc = procedure(a: POSSL_ENCODER_INSTANCE);
  sk_OSSL_ENCODER_INSTANCE_copyfunc = function(const a: POSSL_ENCODER_INSTANCE): POSSL_ENCODER_INSTANCE;

  ocsp_crl_id_st = record
    crlUrl: PASN1_IA5STRING;
    crlNum: PASN1_INTEGER;
    crlTime: PASN1_GENERALIZEDTIME;
  end;
  TOCSP_CRLID = ocsp_crl_id_st;

  sct_st = record
    version: sct_version_t;
    sct: PByte;
    sct_len: size_t;
    log_id: PByte;
    log_id_len: size_t;
    timestamp: UInt64;
    ext: PByte;
    ext_len: size_t;
    hash_alg: Byte;
    sig_alg: Byte;
    sig: PByte;
    sig_len: size_t;
    entry_type: ct_log_entry_type_t;
    source: sct_source_t;
    validation_status: sct_validation_status_t;
  end;
  TSCT = sct_st;


  ctlog_st = record
    libctx     : POSSL_LIB_CTX;
    propq,
    name       : PUTF8Char;
    log_id     : array[0..(CT_V1_HASHLEN)-1] of byte;
    public_key : PEVP_PKEY;
  end;
  TCTLOG = ctlog_st;

  ctlog_store_st = record
    libctx : POSSL_LIB_CTX;
    propq : PUTF8Char;
    logs: Pstack_st_CTLOG;

  end;
  TCTLOG_STORE = ctlog_store_st;

  ctlog_store_load_ctx_st = record
      log_store           : PCTLOG_STORE;
      conf                : PCONF;
      invalid_log_entries : size_t;
  end;
  TCTLOG_STORE_LOAD_CTX = ctlog_store_load_ctx_st;
  PCTLOG_STORE_LOAD_CTX = ^TCTLOG_STORE_LOAD_CTX;

  lh_CONF_VALUE_compfunc = function(const a, b : PCONF_VALUE):integer;
  lh_CONF_VALUE_hashfunc = function(const a : PCONF_VALUE):Cardinal;
  lh_CONF_VALUE_doallfunc = procedure ( a : PCONF_VALUE);


  OPENSSL_dir_context_st = record
      ctx        : WIN32_FIND_DATA;
      handle     : THANDLE;
      entry_name : array[0..(NAME_MAX + 1)-1] of UTF8Char;
  end;
  TOPENSSL_DIR_CTX = OPENSSL_dir_context_st ;
  POPENSSL_DIR_CTX = ^TOPENSSL_DIR_CTX;
  PPOPENSSL_DIR_CTX = ^POPENSSL_DIR_CTX;


  ISSUER_SIGN_TOOL_st = record
    signTool,
    cATool,
    signToolCert,
    cAToolCert   : PASN1_UTF8STRING;
  end;
  TISSUER_SIGN_TOOL = ISSUER_SIGN_TOOL_st;
  PISSUER_SIGN_TOOL = ^TISSUER_SIGN_TOOL;
  PPISSUER_SIGN_TOOL = ^PISSUER_SIGN_TOOL;

  AdmissionSyntax_st = record
      admissionAuthority   : PGENERAL_NAME;
      contentsOfAdmissions : Pstack_st_ADMISSIONS;
  end;
  TADMISSION_SYNTAX = AdmissionSyntax_st;

  ProfessionInfo_st = record
      namingAuthority    : PNAMING_AUTHORITY;
      professionItems    : Pstack_st_ASN1_STRING;
      professionOIDs     : Pstack_st_ASN1_OBJECT;
      registrationNumber : PASN1_PRINTABLESTRING;
      addProfessionInfo  : PASN1_OCTET_STRING;
  end;
  TPROFESSION_INFO = ProfessionInfo_st ;

  Admissions_st = record
    admissionAuthority : PGENERAL_NAME;
    namingAuthority    : PNAMING_AUTHORITY;
    professionInfos    : Pstack_st_PROFESSION_INFO;
  end;
  TADMISSIONS = Admissions_st;


  NamingAuthority_st = record
      namingAuthorityId   : PASN1_OBJECT;
      namingAuthorityUrl  : PASN1_IA5STRING;
      namingAuthorityText : PASN1_STRING;
  end;
  TNAMING_AUTHORITY = NamingAuthority_st ;

  x509_crl_method_st = record
    flags: Integer;
    crl_init: function(crl: PX509_CRL): Integer;
    crl_free: function(crl: PX509_CRL): Integer;
    crl_lookup: function(crl: PX509_CRL; ret: PPX509_REVOKED; const ser: PASN1_INTEGER; const issuer: PX509_NAME): Integer;
    crl_verify: function(crl: PX509_CRL; pk: PEVP_PKEY): Integer;
  end;
  TX509_CRL_METHOD = x509_crl_method_st ;

  X509_POLICY_DATA_st = record
    flags: Cardinal;
    valid_policy: PASN1_OBJECT;
    qualifier_set: Pstack_st_POLICYQUALINFO;
    expected_policy_set: Pstack_st_ASN1_OBJECT;
  end;
  TX509_POLICY_DATA = X509_POLICY_DATA_st;
  PX509_POLICY_DATA = ^TX509_POLICY_DATA;
  PPX509_POLICY_DATA = ^PX509_POLICY_DATA;

  Pstack_st_X509_POLICY_DATA = Pointer;
  X509_POLICY_CACHE_st = record
    anyPolicy: PX509_POLICY_DATA;
    data: Pstack_st_X509_POLICY_DATA;
    any_skip: Integer;
    explicit_skip: Integer;
    map_skip: Integer;
  end;
  TX509_POLICY_CACHE = X509_POLICY_CACHE_st;

  sk_X509_POLICY_DATA_compfunc = function(const a: PPX509_POLICY_DATA; const b: PPX509_POLICY_DATA): Integer;
  sk_X509_POLICY_DATA_freefunc = procedure(a: PX509_POLICY_DATA);
  sk_X509_POLICY_DATA_copyfunc = function(const a: PX509_POLICY_DATA): PX509_POLICY_DATA;

  X509_POLICY_TREE_st = record
    levels: PX509_POLICY_LEVEL;
    nlevel: Integer;
    extra_data: Pstack_st_X509_POLICY_DATA;
    auth_policies: Pstack_st_X509_POLICY_NODE;
    user_policies: Pstack_st_X509_POLICY_NODE;
    flags: Cardinal;
  end;
  TX509_POLICY_TREE = X509_POLICY_TREE_st;

  X509_POLICY_NODE_st = record
    data: PX509_POLICY_DATA;
    parent: PX509_POLICY_NODE;
    nchild: Integer;
  end;
  TX509_POLICY_NODE = X509_POLICY_NODE_st;

   X509_POLICY_LEVEL_st = record
    cert: PX509;
    nodes: Pstack_st_X509_POLICY_NODE;
    anyPolicy: PX509_POLICY_NODE;
    flags: Cardinal;
  end;
  TX509_POLICY_LEVEL = X509_POLICY_LEVEL_st;



  x509_object_st = record
    &type: X509_LOOKUP_TYPE;
    data: record
    case Integer of
      0: (ptr: PUTF8Char);
      1: (x509: PX509);
      2: (crl: PX509_CRL);
      3: (pkey: PEVP_PKEY);
    end;
  end;
  TX509_OBJECT = x509_object_st;

  x509_lookup_method_st = record
    name: PUTF8Char;
    new_item: function(ctx: PX509_LOOKUP): Integer;
    free: procedure(ctx: PX509_LOOKUP);
    init: function(ctx: PX509_LOOKUP): Integer;
    shutdown: function(ctx: PX509_LOOKUP): Integer;
    ctrl: function(ctx: PX509_LOOKUP; cmd: Integer; const argc: PUTF8Char; argl: Integer; ret: PPUTF8Char): Integer;
    get_by_subject: function(ctx: PX509_LOOKUP; &type: X509_LOOKUP_TYPE; const name: PX509_NAME; ret: PX509_OBJECT): Integer;
    get_by_issuer_serial: function(ctx: PX509_LOOKUP; &type: X509_LOOKUP_TYPE; const name: PX509_NAME; const serial: PASN1_INTEGER; ret: PX509_OBJECT): Integer;
    get_by_fingerprint: function(ctx: PX509_LOOKUP; &type: X509_LOOKUP_TYPE; const bytes: PByte; len: Integer; ret: PX509_OBJECT): Integer;
    get_by_alias: function(ctx: PX509_LOOKUP; &type: X509_LOOKUP_TYPE; const str: PUTF8Char; len: Integer; ret: PX509_OBJECT): Integer;
    get_by_subject_ex: function(ctx: PX509_LOOKUP; &type: X509_LOOKUP_TYPE; const name: PX509_NAME; ret: PX509_OBJECT; libctx: POSSL_LIB_CTX; const propq: PUTF8Char): Integer;
    ctrl_ex: function(ctx: PX509_LOOKUP; cmd: Integer; const argc: PUTF8Char; argl: Integer; ret: PPUTF8Char; libctx: POSSL_LIB_CTX; const propq: PUTF8Char): Integer;
  end;
  TX509_LOOKUP_METHOD = x509_lookup_method_st;

  x509_lookup_st = record
    init: Integer;
    skip: Integer;
    method: PX509_LOOKUP_METHOD;
    method_data: Pointer;
    store_ctx: PX509_STORE;
  end;
  TX509_LOOKUP = x509_lookup_st;

  sk_ENGINE_compfunc = function (const a, b : PPENGINE):integer;
  sk_ENGINE_freefunc = procedure ( a : PENGINE);
  sk_ENGINE_copyfunc = function (const a : PENGINE):PENGINE;
  Pstack_st_EVP_PKEY_ASN1_METHOD = Pointer;
  sk_EVP_PKEY_ASN1_METHOD_compfunc =  function(const a, b : PEVP_PKEY_ASN1_METHOD):integer;
  sk_EVP_PKEY_ASN1_METHOD_freefunc = procedure ( a : PEVP_PKEY_ASN1_METHOD);
  sk_EVP_PKEY_ASN1_METHOD_copyfunc =  function (const a : PEVP_PKEY_ASN1_METHOD):PEVP_PKEY_ASN1_METHOD;

  TENGINE_CLEANUP_CB = procedure();

  st_engine_cleanup_item = record
    cb : TENGINE_CLEANUP_CB;
  end;
  TENGINE_CLEANUP_ITEM = st_engine_cleanup_item;
  PENGINE_CLEANUP_ITEM = ^TENGINE_CLEANUP_ITEM;
  PPENGINE_CLEANUP_ITEM = ^PENGINE_CLEANUP_ITEM;

  Pstack_st_ENGINE_CLEANUP_ITEM = Pointer;
  sk_ENGINE_CLEANUP_ITEM_compfunc = function (const a, b : PPENGINE_CLEANUP_ITEM):integer;
  sk_ENGINE_CLEANUP_ITEM_freefunc = procedure ( a : PENGINE_CLEANUP_ITEM);
  sk_ENGINE_CLEANUP_ITEM_copyfunc = function (const a : PENGINE_CLEANUP_ITEM):PENGINE_CLEANUP_ITEM;

  evp_cipher_aead_asn1_params = record
    iv: array [0..15] of Byte;
    iv_len: Cardinal;
    tag_len: Cardinal;
  end;
  Pevp_cipher_aead_asn1_params = ^evp_cipher_aead_asn1_params;

  xts128_context = record
    key1: Pointer;
    key2: Pointer;
    block1: block128_f;
    block2: block128_f;
  end;
  TXTS128_CONTEXT = xts128_context;

  TOSSL_xts_stream_fn = procedure(const &in: PByte; &out: PByte; len: size_t; const key1: PAES_KEY; const key2: PAES_KEY; iv: PByte);

  prov_aes_xts_ctx_st = record
    base: TPROV_CIPHER_CTX;
    ks1: ks_st;
    ks2: ks_st;
    xts: TXTS128_CONTEXT;
    stream: TOSSL_xts_stream_fn;
  end;
  TPROV_AES_XTS_CTX = prov_aes_xts_ctx_st;
  PPROV_AES_XTS_CTX = ^TPROV_AES_XTS_CTX ;

  u128 = record
    hi: uint64;
    lo: uint64;
  end;
  Pu128 = ^u128;

  gcm128_st = record
    case Integer of
      0: (u: array [0..1] of uint64);
      1: (d: array [0..3] of uint32);
      2: (c: array [0..15] of uint8);
      3: (t: array [0..1] of size_t);
  end;

  Tghash_func = procedure(Xi: Puint64; Htable: Pu128; const inp: Puint8; len: size_t);
  gcm128_context = record
    Yi,
    EKi,
    EK0,
    len,
    Xi,
    H: gcm128_st;
    Htable: array [0..15] of u128;
    gmult: procedure(Xi: Puint64; Htable: Pu128);
    ghash: procedure(Xi: Puint64; Htable: Pu128; const inp: Puint8; len: size_t);
    mres: Cardinal;
    ares: Cardinal;
    block: block128_f;
    key: Pointer;
    Xn: array [0..47] of Byte;
  end;
  TGCM128_CONTEXT = gcm128_context;
  PPROV_GCM_CTX = ^TPROV_GCM_CTX;

  TOSSL_GCM_setkey_fn = function(ctx: PPROV_GCM_CTX; const key: PByte; keylen: size_t): Integer;
  TOSSL_GCM_setiv_fn = function(dat: PPROV_GCM_CTX; const iv: PByte; ivlen: size_t): Integer;
  TOSSL_GCM_aadupdate_fn = function(ctx: PPROV_GCM_CTX; const aad: PByte; aadlen: size_t): Integer;
  TOSSL_GCM_cipherupdate_fn = function(ctx: PPROV_GCM_CTX; const _in: PByte; len: size_t; _out: PByte): Integer;
  TOSSL_GCM_cipherfinal_fn = function(ctx: PPROV_GCM_CTX; tag: PByte): Integer;
  TOSSL_GCM_oneshot_fn = function(ctx: PPROV_GCM_CTX; aad: PByte; aad_len: size_t; const _in: PByte; in_len: size_t; _out: PByte; tag: PByte; taglen: size_t): Integer;

  prov_gcm_hw_st = record
    setkey: TOSSL_GCM_setkey_fn;
    setiv: TOSSL_GCM_setiv_fn;
    aadupdate: TOSSL_GCM_aadupdate_fn;
    cipherupdate: TOSSL_GCM_cipherupdate_fn;
    cipherfinal: TOSSL_GCM_cipherfinal_fn;
    oneshot: TOSSL_GCM_oneshot_fn;
  end;
  TPROV_GCM_HW = prov_gcm_hw_st;
  PPROV_GCM_HW = ^TPROV_GCM_HW;

  prov_gcm_ctx_st = record
    mode: Cardinal;
    keylen: size_t;
    ivlen: size_t;
    taglen: size_t;
    tls_aad_pad_sz: size_t;
    tls_aad_len: size_t;
    tls_enc_records: UInt64;
    num: size_t;
    bufsz: size_t;
    flags: UInt64;
    iv_state: Cardinal;
    enc: Cardinal;
    pad: Cardinal;
    key_set: Cardinal;
    iv_gen_rand: Cardinal;
    iv_gen: Cardinal;
    iv: array [0..127] of Byte;
    buf: array [0..15] of Byte;
    libctx: POSSL_LIB_CTX;
    hw: PPROV_GCM_HW;
    gcm: TGCM128_CONTEXT;
    ctr: ctr128_f;
    ks: Pointer;
  end;
  TPROV_GCM_CTX = prov_gcm_ctx_st;

  Taeswrap_fn = function(key : Pointer;{const} iv : PByte;var _out : PByte;const _in : PByte; inlen : size_t; block : block128_f):size_t;

  prov_aes_wrap_ctx_st = record
    base: TPROV_CIPHER_CTX;
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TAES_KEY);
    end;
    wrapfn: Taeswrap_fn ;
 end ;
 TPROV_AES_WRAP_CTX = prov_aes_wrap_ctx_st;
 PPROV_AES_WRAP_CTX = ^TPROV_AES_WRAP_CTX;


  prov_aes_gcm_ctx_st = record
    base: TPROV_GCM_CTX;
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TAES_KEY);
    end;
    plat: record
      case Integer of
        0: (dummy: Integer);
{$if defined(OPENSSL_CPUID_OBJ) and defined(__s390__) }
        struct {
            union {
                OSSL_UNION_ALIGN;
                S390X_KMA_PARAMS kma;
            } param;
            unsigned int fc;
            unsigned int hsflag;    /* hash subkey set flag */
            unsigned char ares[16];
            unsigned char mres[16];
            unsigned char kres[16];
            int areslen;
            int mreslen;
            int kreslen;
            int res;
        } s390x;
{$ifend} (* defined(OPENSSL_CPUID_OBJ) && defined(__s390__) *)
    end;
  end;
  TPROV_AES_GCM_CTX = prov_aes_gcm_ctx_st;
  PPROV_AES_GCM_CTX = ^TPROV_AES_GCM_CTX;

  ccm128_st = record
    case Integer of
      0: (u: array [0..1] of uint64);
      1: (c: array [0..15] of uint8);
  end;

  ccm128_context = record
    nonce,
    cmac: ccm128_st;
    blocks: uint64;
    block: block128_f;
    key: Pointer;
  end;
  TCCM128_CONTEXT = ccm128_context;

  PPROV_CCM_CTX = ^TPROV_CCM_CTX;

  TOSSL_CCM_cipher_fn = function(ctx: PPROV_CCM_CTX; &out: PByte; padlen: PNativeUInt; const &in: PByte; len: NativeUInt): Integer;
  TOSSL_CCM_setkey_fn = function(ctx: PPROV_CCM_CTX; const key: PByte; keylen: NativeUInt): Integer;
  TOSSL_CCM_setiv_fn = function(dat: PPROV_CCM_CTX; const iv: PByte; ivlen: NativeUInt; mlen: NativeUInt): Integer;
  TOSSL_CCM_setaad_fn = function(ctx: PPROV_CCM_CTX; const aad: PByte; aadlen: NativeUInt): Integer;
  TOSSL_CCM_auth_encrypt_fn = function(ctx: PPROV_CCM_CTX; const &in: PByte; &out: PByte; len: NativeUInt; tag: PByte; taglen: NativeUInt): Integer;
  TOSSL_CCM_auth_decrypt_fn = function(ctx: PPROV_CCM_CTX; const &in: PByte; &out: PByte; len: NativeUInt; tag: PByte; taglen: NativeUInt): Integer;
  TOSSL_CCM_gettag_fn = function(ctx: PPROV_CCM_CTX; tag: PByte; taglen: NativeUInt): Integer;

  prov_ccm_hw_st = record
    setkey: TOSSL_CCM_setkey_fn;
    setiv: TOSSL_CCM_setiv_fn;
    setaad: TOSSL_CCM_setaad_fn;
    auth_encrypt: TOSSL_CCM_auth_encrypt_fn;
    auth_decrypt: TOSSL_CCM_auth_decrypt_fn;
    gettag: TOSSL_CCM_gettag_fn;
  end;
  TPROV_CCM_HW = prov_ccm_hw_st;
  PPROV_CCM_HW = ^TPROV_CCM_HW;

  prov_ccm_st = record
    enc: Cardinal;
    key_set: Cardinal;
    iv_set: Cardinal;
    tag_set: Cardinal;
    len_set: Cardinal;
    l: size_t;
    m: size_t;
    keylen: size_t;
    tls_aad_len: size_t;
    tls_aad_pad_sz: size_t;
    iv: array [0..15] of Byte;
    buf: array [0..15] of Byte;
    ccm_ctx: TCCM128_CONTEXT;
    str: ccm128_f;
    hw: PPROV_CCM_HW;
  end;
  TPROV_CCM_CTX = prov_ccm_st;

  prov_aes_ccm_ctx_st = record
    base: TPROV_CCM_CTX;
    ccm: record
          case Integer of
            0: (align: Double);
            1: (align_int: ossl_uintmax_t);
            2: (align_ptr: Pointer);
            3: (ks: record
                  pad: array [0..15] of Byte;
                  ks: TAES_KEY;
                end);
        end;
  end;
  TPROV_AES_CCM_CTX = prov_aes_ccm_ctx_st;
  PPROV_AES_CCM_CTX = ^TPROV_AES_CCM_CTX;

  TARIA_u128 = record
    case Integer of
      0: (c: array [0..15] of Byte);
      1: (u: array [0..3] of Cardinal);
  end;
  PARIA_u128 = ^TARIA_u128 ;

  ARIA_c128 = array [0..15] of Byte;

  aria_key_st = record
    rd_key: array [0..16] of TARIA_u128;
    rounds: Cardinal;
  end;
  TARIA_KEY = aria_key_st;
  PARIA_KEY = ^TARIA_KEY;

  prov_aria_ccm_ctx_st = record
    base: TPROV_CCM_CTX; (* Must be first *)
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TARIA_KEY);
    end;                    (* ARIA key schedule to use *)
 end;
 TPROV_ARIA_CCM_CTX = prov_aria_ccm_ctx_st;
 PPROV_ARIA_CCM_CTX = ^TPROV_ARIA_CCM_CTX;



  prov_aria_gcm_ctx_st = record
    base: TPROV_GCM_CTX;              (* must be first entry in struct *)
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TARIA_KEY);
    end;
end;
 TPROV_ARIA_GCM_CTX = prov_aria_gcm_ctx_st;
 PPROV_ARIA_GCM_CTX = ^TPROV_ARIA_GCM_CTX;

  prov_aria_ctx_st = record
    base: TPROV_CIPHER_CTX;
    ks: record
          case Integer of
            0: (align: Double);
            1: (align_int: ossl_uintmax_t);
            2: (align_ptr: Pointer);
            3: (ks: TARIA_KEY);
        end;
  end;
  TPROV_ARIA_CTX = prov_aria_ctx_st;
  PPROV_ARIA_CTX = ^TPROV_ARIA_CTX;

  prov_camellia_ctx_st = record
    base: TPROV_CIPHER_CTX;              (* must be first entry in struct *)
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TCAMELLIA_KEY);
    end;
end;
 TPROV_CAMELLIA_CTX = prov_camellia_ctx_st;
 PPROV_CAMELLIA_CTX = ^TPROV_CAMELLIA_CTX;

 Ttstream_func = procedure(const p1: Pointer; p2: Pointer; p3: size_t; const p4: PDES_key_schedule; p5: PByte);
  prov_tdes_ctx_st = record
    base: TPROV_CIPHER_CTX;
    tks: record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: array [0..2] of TDES_key_schedule);
    end;
    tstream: record
    case Integer of
      0: (cbc: Ttstream_func);
    end;
  end;

  TPROV_TDES_CTX = prov_tdes_ctx_st;
  PPROV_TDES_CTX = ^TPROV_TDES_CTX;

  SM4_KEY_st = record
    rk: array[0..SM4_KEY_SCHEDULE-1] of uint32;
  end;
  TSM4_KEY = SM4_KEY_st;
  PSM4_KEY = ^TSM4_KEY;

  prov_sm4_gcm_ctx_st = record
    base: TPROV_GCM_CTX ;              (* must be first entry in struct *)
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TSM4_KEY);
    end;
 end;
 TPROV_SM4_GCM_CTX = prov_sm4_gcm_ctx_st;
 PPROV_SM4_GCM_CTX = ^TPROV_SM4_GCM_CTX;

 prov_sm4_ccm_ctx_st = record
    base: TPROV_CCM_CTX ;              (* must be first entry in struct *)
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TSM4_KEY);
    end;
 end;
 TPROV_SM4_CCM_CTX = prov_sm4_ccm_ctx_st;
 PPROV_SM4_CCM_CTX = ^TPROV_SM4_GCM_CTX;

 prov_cast_ctx_st = record
    base: TPROV_CIPHER_CTX;              (* must be first entry in struct *)
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TSM4_KEY);
    end;
 end;
 TPROV_SM4_CTX = prov_cast_ctx_st;
 PPROV_SM4_CTX = ^TPROV_SM4_CTX;

 TOSSL_FUNC_provider_get_reason_strings_fn = function(provctx: Pointer): POSSL_ITEM;

 conf_imodule_st = record
    pmod: PCONF_MODULE;
    name: PUTF8Char;
    value: PUTF8Char;
    flags: Cardinal;
    usr_data: Pointer;
  end;
  TCONF_IMODULE = conf_imodule_st;

  conf_module_st = record
    dso: PDSO;
    name: PUTF8Char;
    init: Tconf_init_func;
    finish: Tconf_finish_func;
    links: Integer;
    usr_data: Pointer;
  end;
  TCONF_MODULE = conf_module_st;

  lh_OSSL_STORE_LOADER_dummy = record
    case Integer of
      0: (d1: Pointer);
      1: (d2: Cardinal);
      2: (d3: Integer);
  end;
  lhash_st_OSSL_STORE_LOADER = record
    dummy: lh_OSSL_STORE_LOADER_dummy;
  end;
  Plhash_st_OSSL_STORE_LOADER = ^lhash_st_OSSL_STORE_LOADER;

  Pstack_st_NAME_FUNC = Pointer;

  TEVP_DES_KEY = record
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TDES_key_schedule)
    end;
    stream: record
      case Integer of
        0: (cbc: procedure(const p1: Pointer; p2: Pointer; p3: size_t; const p4: PDES_key_schedule; p5: PByte); );
    end;
  end;
  PEVP_DES_KEY = ^TEVP_DES_KEY;

  TDES_EDE_KEY = record
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: array[0..2] of TDES_key_schedule)
    end;
    stream: record
      case Integer of
        0: (cbc: procedure(const p1: Pointer; p2: Pointer; p3: size_t; const p4: PDES_key_schedule; p5: PByte); );
    end;
  end;
  PDES_EDE_KEY = ^TDES_EDE_KEY;

  TEVP_SM4_KEY = record
    ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TSM4_KEY);
    end;
    block: block128_f ;
    stream: record
      case Integer of
        0: (ecb: ecb128_f);
        1: (cbc: cbc128_f);
        2: (ctr: ctr128_f);
    end;
  end;
  PEVP_SM4_KEY = ^TEVP_SM4_KEY;

  TEVP_AES_KEY = record
    ks: record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: TAES_KEY);
    end;
    block: block128_f;
    stream: record
    case Integer of
      0: (cbc: cbc128_f);
      1: (ctr: ctr128_f);
    end;
  end;
  PEVP_AES_KEY = ^TEVP_AES_KEY;


  TEVP_AES_GCM_CTX = record
    ks: record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: TAES_KEY);
    end;
    key_set: Integer;
    iv_set: Integer;
    gcm: GCM128_CONTEXT;
    iv: PByte;
    ivlen: Integer;
    taglen: Integer;
    iv_gen: Integer;
    iv_gen_rand: Integer;
    tls_aad_len: Integer;
    tls_enc_records: UInt64;
    ctr: ctr128_f;
  end;
  PEVP_AES_GCM_CTX = ^TEVP_AES_GCM_CTX;


  TEVP_AES_OCB_CTX = record
    ksenc: record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: TAES_KEY);
    end;
    ksdec: record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: TAES_KEY);
    end;
    key_set: Integer;
    iv_set: Integer;
    ocb: TOCB128_CONTEXT;
    iv: PByte;
    tag: array [0..15] of Byte;
    data_buf: array [0..15] of Byte;
    aad_buf: array [0..15] of Byte;
    data_buf_len: Integer;
    aad_buf_len: Integer;
    ivlen: Integer;
    taglen: Integer;
  end;
  PEVP_AES_OCB_CTX = ^TEVP_AES_OCB_CTX;


  TEVP_AES_XTS_CTX = record
    ks1: record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: TAES_KEY);
    end;
    ks2: record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: TAES_KEY);
    end;
    xts: XTS128_CONTEXT;
    stream: procedure(const &in: PByte; &out: PByte; length: NativeUInt; const key1: PAES_KEY; const key2: PAES_KEY; iv: PByte);
  end;
  PEVP_AES_XTS_CTX = ^TEVP_AES_XTS_CTX;


  TEVP_AES_CCM_CTX = record
      ks: record
      case Integer of
        0: (align: Double);
        1: (align_int: ossl_uintmax_t);
        2: (align_ptr: Pointer);
        3: (ks: TAES_KEY);
      end;
      key_set: Integer;
      iv_set: Integer;
      tag_set: Integer;
      len_set: Integer;
      L: Integer;
      M: Integer;
      tls_aad_len: Integer;
      ccm: CCM128_CONTEXT;
      str: ccm128_f;
  end;
  PEVP_AES_CCM_CTX = ^TEVP_AES_CCM_CTX;

  TEVP_AES_WRAP_CTX = record
    ks: record
    case Integer of
      0: (align: Double);
      1: (align_int: ossl_uintmax_t);
      2: (align_ptr: Pointer);
      3: (ks: TAES_KEY);
    end;
    iv: PByte;
  end;
  PEVP_AES_WRAP_CTX = ^TEVP_AES_WRAP_CTX;


  RIPEMD160state_st = record
  var
    A, B, C, D, E, Nl, Nh : RIPEMD160_LONG;
    data : array[0..(RIPEMD160_LBLOCK)-1] of RIPEMD160_LONG;
    num : uint32;
  end;
  TRIPEMD160_CTX = RIPEMD160state_st;
  PRIPEMD160_CTX = ^TRIPEMD160_CTX;

  ocsp_service_locator_st = record
    issuer: PX509_NAME;
    locator: Pstack_st_ACCESS_DESCRIPTION;
  end;
  TOCSP_SERVICELOC = ocsp_service_locator_st;


  self_test_post_params_st = record
      module_filename,
      module_checksum_data,
      indicator_version,
      indicator_data,
      indicator_checksum_data,
      conditional_error_check : PUTF8Char;
      bio_new_file_cb         : TOSSL_FUNC_BIO_new_file_fn;
      bio_new_buffer_cb       : TOSSL_FUNC_BIO_new_membuf_fn;
      bio_read_ex_cb          : TOSSL_FUNC_BIO_read_ex_fn;
      bio_free_cb             : TOSSL_FUNC_BIO_free_fn;
      cb                      : POSSL_CALLBACK;
      cb_arg                  : Pointer;
      libctx                  : POSSL_LIB_CTX;
  end;
  TSELF_TEST_POST_PARAMS = self_test_post_params_st;
  PSELF_TEST_POST_PARAMS = ^TSELF_TEST_POST_PARAMS;

  TOSSL_FUNC_core_new_error_fn = procedure(const  prov: POSSL_CORE_HANDLE);
   TOSSL_FUNC_core_set_error_debug_fn = procedure(const  prov: POSSL_CORE_HANDLE; const func:PUTF8Char );
   TOSSL_FUNC_core_vset_error_fn = procedure (const prov : POSSL_CORE_HANDLE; reason : uint32;const fmt : string);
   TOSSL_FUNC_core_set_error_mark_fn = function(const prov: POSSL_CORE_HANDLE): Integer;
   TOSSL_FUNC_core_pop_error_to_mark_fn = function(const prov: POSSL_CORE_HANDLE): Integer;
   TOSSL_FUNC_core_clear_last_error_mark_fn = function(const prov: POSSL_CORE_HANDLE): Integer;


  TOSSL_FUNC_core_obj_add_sigid_fn = function(const prov: POSSL_CORE_HANDLE; const sign_name: PUTF8Char; const digest_name: PUTF8Char; const pkey_name: PUTF8Char): Integer;
  TOSSL_FUNC_core_obj_create_fn = function(const prov: POSSL_CORE_HANDLE; const oid: PUTF8Char; const sn: PUTF8Char; const ln: PUTF8Char): Integer;
  TOSSL_FUNC_CRYPTO_malloc_fn = function(num: NativeUInt; const &file: PUTF8Char; line: Integer): Pointer;
  TOSSL_FUNC_CRYPTO_zalloc_fn = function(num: NativeUInt; const &file: PUTF8Char; line: Integer): Pointer;
  TOSSL_FUNC_CRYPTO_free_fn = procedure(ptr: Pointer; const &file: PUTF8Char; line: Integer);
  TOSSL_FUNC_CRYPTO_clear_free_fn = procedure(ptr: Pointer; num: NativeUInt; const &file: PUTF8Char; line: Integer);
  TOSSL_FUNC_CRYPTO_realloc_fn = function(addr: Pointer; num: NativeUInt; const &file: PUTF8Char; line: Integer): Pointer;
  TOSSL_FUNC_CRYPTO_clear_realloc_fn = function(addr: Pointer; old_num: NativeUInt; num: NativeUInt; const &file: PUTF8Char; line: Integer): Pointer;
  TOSSL_FUNC_CRYPTO_secure_malloc_fn = function(num: NativeUInt; const &file: PUTF8Char; line: Integer): Pointer;
  TOSSL_FUNC_CRYPTO_secure_zalloc_fn = function(num: NativeUInt; const &file: PUTF8Char; line: Integer): Pointer;
  TOSSL_FUNC_CRYPTO_secure_free_fn = procedure(ptr: Pointer; const &file: PUTF8Char; line: Integer);
  TOSSL_FUNC_CRYPTO_secure_clear_free_fn = procedure(ptr: Pointer; num: NativeUInt; const &file: PUTF8Char; line: Integer);
  TOSSL_FUNC_CRYPTO_secure_allocated_fn = function(const ptr: Pointer): Integer;
  TOSSL_FUNC_OPENSSL_cleanse_fn = procedure(ptr: Pointer; len: NativeUInt);
  TOSSL_FUNC_store_open_fn = function(provctx: Pointer; const uri: PUTF8Char): Pointer;
  TOSSL_FUNC_store_attach_fn = function(provctx: Pointer; &in: POSSL_CORE_BIO): Pointer;
  TOSSL_FUNC_store_settable_ctx_params_fn = function(provctx: Pointer): POSSL_PARAM;
  TOSSL_FUNC_store_set_ctx_params_fn = function(loaderctx: Pointer; params: POSSL_PARAM): Integer;
  TOSSL_FUNC_store_load_fn = function(loaderctx: Pointer; object_cb: POSSL_CALLBACK; object_cbarg: Pointer; pw_cb: TOSSL_PASSPHRASE_CALLBACK; pw_cbarg: Pointer): Integer;
  TOSSL_FUNC_store_eof_fn = function(loaderctx: Pointer): Integer;
  TOSSL_FUNC_store_close_fn = function(loaderctx: Pointer): Integer;
  TOSSL_FUNC_store_export_object_fn = function(loaderctx: Pointer; const objref: Pointer; objref_sz: NativeUInt; export_cb: POSSL_CALLBACK; export_cbarg: Pointer): Integer;
  TOSSL_FUNC_core_thread_start_fn = function(const prov: POSSL_CORE_HANDLE; handfn: TOSSL_thread_stop_handler_fn; arg: Pointer): Integer;
  TOSSL_FUNC_self_test_cb_fn = procedure(ctx: POPENSSL_CORE_CTX; cb: PPOSSL_CALLBACK; cbarg: PPointer);

  lh_PROPERTY_STRING_dummy = record
    case Integer of
      0: (d1: Pointer);
      1: (d2: uint32);
      2: (d3: int );
  end;
  lhash_st_PROPERTY_STRING = record
     dummy: lh_PROPERTY_STRING_dummy;
  end;
  Plhash_st_PROPERTY_STRING = ^lhash_st_PROPERTY_STRING;

  TType_Info = class
    class procedure Empty<T>(param: T);
    class function GetTypeKind<T>(const param: T): TTypeKind;
  end;

  CAST_LONG = Uint32;
  PCAST_LONG = ^CAST_LONG;

  TNAMENUM_ENTRY = record
    name : PUTF8Char;
    number : integer;
  end;
  PNAMENUM_ENTRY = ^TNAMENUM_ENTRY;

  TPROPERTY_STRING = record
    s : PUTF8Char;
    idx : OSSL_PROPERTY_IDX;
    body :PUTF8Char;
  end;
  PPROPERTY_STRING = ^TPROPERTY_STRING;

  TPROP_TABLE = lhash_st_PROPERTY_STRING;

  //P_PROP_TABLE与Plhash_st_PROPERTY_STRING为同结构异名
  PPROP_TABLE = ^TPROP_TABLE;
  PPPROP_TABLE = ^PPROP_TABLE;
  TPROPERTY_STRING_DATA = record
    lock           : PCRYPTO_RWLOCK;
    prop_names,
    prop_values    : PPROP_TABLE;
    prop_name_idx,
    prop_value_idx : OSSL_PROPERTY_IDX;
    prop_namelist,
    prop_valuelist : PSTACK_st_OPENSSL_CSTRING;
  end;
  PPROPERTY_STRING_DATA = ^TPROPERTY_STRING_DATA;

  Tdoall_func = procedure(p1: Pointer);
  Tdoallarg_func = procedure(p1: PPROPERTY_STRING; p2: Pointer);

  OPTION_CHOICE_DEFAULT = (
    OPT_ERR = -1,
    OPT_EOF = 0,
    OPT_TEST_HELP = 500,
    OPT_TEST_LIST,
    OPT_TEST_SINGLE,
    OPT_TEST_ITERATION,
    OPT_TEST_INDENT,
    OPT_TEST_SEED
  );

  

  var

  ossl_bignum_const_2,
  ossl_bignum_ffdhe2048_p,
  ossl_bignum_ffdhe3072_p,
  ossl_bignum_ffdhe4096_p,
  ossl_bignum_ffdhe6144_p,
  ossl_bignum_ffdhe8192_p,
  ossl_bignum_ffdhe2048_q,
  ossl_bignum_ffdhe3072_q,
  ossl_bignum_ffdhe4096_q,
  ossl_bignum_ffdhe6144_q,
  ossl_bignum_ffdhe8192_q,
  ossl_bignum_modp_1536_p,
  ossl_bignum_modp_2048_p,
  ossl_bignum_modp_3072_p,
  ossl_bignum_modp_4096_p,
  ossl_bignum_modp_6144_p,
  ossl_bignum_modp_8192_p,
  ossl_bignum_modp_1536_q,
  ossl_bignum_modp_2048_q,
  ossl_bignum_modp_3072_q,
  ossl_bignum_modp_4096_q,
  ossl_bignum_modp_6144_q,
  ossl_bignum_modp_8192_q,
  ossl_bignum_dh1024_160_p,
  ossl_bignum_dh1024_160_q,
  ossl_bignum_dh1024_160_g,
  ossl_bignum_dh2048_224_p,
  ossl_bignum_dh2048_224_q,
  ossl_bignum_dh2048_224_g,
  ossl_bignum_dh2048_256_p,
  ossl_bignum_dh2048_256_q,
  ossl_bignum_dh2048_256_g : TBIGNUM;



type
  OPENSSL_sk_pop_free_func = procedure(p1: Pointer);
  OPENSSL_atexit_handler = procedure();
  CRYPTO_THREAD_init_local_cleanup = procedure(p1: Pointer);

  PTimeVal = ^TTimeVal;
  timeval = record
    tv_sec: Longint;
    tv_usec: Longint;
  end;
  TTimeVal = timeval;



function strcasecmp(const s1_arg, s2_arg : PUTF8Char):integer;

function malloc(Size: NativeInt): Pointer;
procedure Free(P: Pointer);

function get_result(condition: Boolean;result1, result2: integer): Integer;overload;
function get_result(condition: Boolean;result1, result2: size_t): size_t; overload;
function get_result(condition: Boolean;result1, result2: uint32): uint32; overload;
function get_result(condition: Boolean;result1, result2: uint64): uint64; overload;
function get_result(condition: Boolean;result1, result2: PUTF8Char): PUTF8Char; overload;
function get_result(condition: Boolean;result1, result2: UTF8char): UTF8char; overload;
function get_result(condition: Boolean;result1, result2: PByte): PByte;overload;
function get_result(condition: Boolean;result1, result2: PBIGNUM): PBIGNUM; overload;
function get_result(condition: Boolean;result1, result2: PBN_ULONG): PBN_ULONG;overload;
function ossl_ascii_isdigit(const inchar :Byte):integer;

function PostDec(var n: size_t): size_t;overload;
function PostDec(var n: UInt32): UInt32;overload;
function PostDec(var n: Byte): Byte; overload;
function PostDec(var n: integer): Integer;overload;
function PostDec(Var n: PByte): PByte; overload;
function PostDec(var n: PRC2_INT): PRC2_INT; overload;

function PostInc(var n: BN_ULONG): BN_ULONG; overload;
function PostInc(var n: PBN_ULONG): PBN_ULONG; overload;
function PostInc(var n: uint32): uint32;overload;
function PostInc(var n: Integer): Integer;overload;
function PostInc(var n: PAnsiChar): PAnsiChar;overload;
function PostInc(var n: PWideChar): PWideChar; overload;
function PostInc(var n: size_t): size_t;overload;
function PostInc(var n: PIDEA_INT): PIDEA_INT;overload;
function PostInc(var n: PRC2_INT): PRC2_INT;overload;
function PostInc(var p: POSSL_PARAM): POSSL_PARAM;overload;
function PostInc(var p: PByte): PByte;overload;

function PreInc(var s: PUTF8Char): PUTF8Char; overload;
function PreInc(var s: int): int; overload;
function PreInc(var s: size_t): size_t; overload;
function PreDec(var n: size_t): size_t;overload;
function PreDec(var n: Integer): Integer;overload;
function PreDec(var n: PByte): PByte;overload;
function PreDec(var n: PUTF8Char): PUTF8Char; overload;
function PreDec(var n: PBN_ULONG): PBN_ULONG; overload;

function memcmp(a, b: Pointer; c: SizeInt):integer;
function strncmp(s1, s2 : PUTF8Char; n : size_t):integer;
function strcmp(const s1, s2 : PUTF8Char):integer;
function strncpy(dst : PUTF8Char;const src : PUTF8Char; n : size_t):PUTF8Char; overload;
function strncpy(dst : PWideChar;const src : PWideChar; n : size_t):PWideChar; overload;
function strtoul(const nptr : PUTF8Char; endptr : PPUTF8Char; base : integer):uint32;
function IsSpace(const Ch: UTF8Char): Boolean;
function IsAlpha(const AChar: UTF8Char): Boolean;
function strspn(const s1, s2 : PUTF8Char):size_t;
function va_arg(ArgsList: array of const; tp: Pointer): Pointer;
function strchr(const src : PAnsiChar; c : AnsiChar):PAnsiChar; overload;
function strchr(s : PWideChar;const c : WideChar):PWideChar;overload;
function sscanf(str, format : PUTF8Char; args: array of const):integer;
function strncasecmp(s1, s2:PUTF8Char; len: UInt32): Integer;

function strcpy(s1 : PUTF8Char; const s2 : PUTF8Char):PUTF8Char;
 function GETU32( p : PByte):uint32;
function RAND_POOL_MIN_ALLOCATION(secure: int): int;
function PByte2ArrayByte(p1: PByte; len: Byte): TArray<Byte>;
function SC_LIMB1(x: Uint64): uint32;
function SC_LIMB2(x: Uint64): uint32;
function U64(C: Int64): uint64;
function Rotr64( Shift: integer; x: uint64): uint64;
function get_ASN1_TEMPLATE(flags: Cardinal; tag: Integer; offset: Cardinal; field_name: PUTF8Char; item: TASN1_ITEM_EXP): TASN1_TEMPLATE;
function get_ASN1_ITEM(itype: Byte; utype: long; templates: PASN1_TEMPLATE;tcount: long; funcs: Pointer; size: long; sname: PUTF8Char):TASN1_ITEM;
function get_ASN1_ADB_TABLE(value: Integer; tt: TASN1_TEMPLATE): TASN1_ADB_TABLE;
function strcspn(const s1, s2 : PUTF8Char):size_t;

var
  gIntVal, gIndex: Integer;
  errno:longint;

type
  TMyFunc<T> = function(const param: T; _out : PPByte):integer of object;
  TMyCastMethod = class
    class function Cast<TFrom, TTo>(AFrom: TMyFunc<TFrom>): TMyFunc<TTo>;static;

  end;

  Tadb_cb_func = function(psel: PInteger): Integer;
  function get_ASN1_ADB(flags: Cardinal; offset: Cardinal; adb_cb: Tadb_cb_func; tbl: PASN1_ADB_TABLE; tblcount: Integer; default_tt: PASN1_TEMPLATE; null_tt: PASN1_TEMPLATE): TASN1_ADB;
  function get_EVP_PBE_CTL(pbe_type, pbe_nid, cipher_nid, md_nid: integer; keygen: TEVP_PBE_KEYGEN; keygen_ex  : TEVP_PBE_KEYGEN_EX): TEVP_PBE_CTL;
  function get_ASN1_OBJECT(sn: PUTF8Char; ln: PUTF8Char; nid: Integer; length: Integer; data: PByte; flags: Integer): TASN1_OBJECT;
  function memchr(const bigptr: PUTF8Char; ch : UTF8Char; len : size_t): Pointer; overload;
  function memchr(const bigptr: PByte; ch : Byte; len : size_t): Pointer; overload;
  function Create_ASN1_OBJECTS(objs: array of TASN1_OBJECT): TArray<TASN1_OBJECT>;
  function get_BIGNUM(d: PBN_ULONG; top: Integer; dmax: Integer; neg: Integer; flags: Integer): TBIGNUM;
  function get_ENUMERATED_NAMES(bitnum: Integer; lname: PUTF8Char; sname: PUTF8Char ): TENUMERATED_NAMES;
  function get_last_sys_error: int;
  function strstr(s1, s2 : PUTF8Char):PUTF8Char;
  //function strlen(const s : PUTF8Char):size_t;
  procedure PUTU32(p: PByte; v: UInt32);
  procedure ocb_block16_xor(in1,in2,_out: POCB_BLOCK);
  function get_V3_EXT_METHOD(ext_nid: Integer; ext_flags: Integer;it: TASN1_ITEM_EXP;
                             ext_new: TX509V3_EXT_NEW; ext_free: TX509V3_EXT_FREE;
                             d2i: TX509V3_EXT_D2I;i2d: TX509V3_EXT_I2D;
                             i2s: TX509V3_EXT_I2S; s2i: TX509V3_EXT_S2I;
                             i2v: TX509V3_EXT_I2V; v2i: TX509V3_EXT_V2I;
                             i2r: TX509V3_EXT_I2R; r2i: TX509V3_EXT_R2I;
                             usr_data: Pointer): V3_EXT_METHOD;

   function strtol(const nptr : PUTF8Char; endptr : PPUTF8Char; base : integer):long;
   function get_ASN1_AUX(
    app_data: Pointer;
    flags: Integer;
    ref_offset: Integer;
    ref_lock: Integer;
    asn1_cb: TASN1_aux_cb;
    enc_offset: Integer;
    asn1_const_cb: TASN1_aux_const_cb): TASN1_AUX;

    function get_x509_purpose(
    purpose: Integer;
    trust: Integer;
    flags: Integer;
    check_purpose: Tcheck_purpose_func;
    name: PUTF8Char;
    sname: PUTF8Char;
    usr_data: Pointer): TX509_PURPOSE;

    function get_X509_TRUST(
    trust: Integer;
    flags: Integer;
    check_trust: Tcheck_trust_func;
    name: PUTF8Char;
    arg1: Integer;
    arg2: Pointer):  TX509_TRUST;

    function get_X509_VERIFY_PARAM(
    name: PUTF8Char;
    check_time: Longint;
    inh_flags: UInt32;
    flags: Cardinal;
    purpose: Integer;
    trust: Integer;
    depth: Integer;
    auth_level: Integer;
    policies: Pstack_st_ASN1_OBJECT;
    hosts: Pstack_st_OPENSSL_STRING;
    hostflags: Cardinal;
    peername: PUTF8Char;
    email: PUTF8Char;
    emaillen: size_t;
    ip: PByte;
    iplen: size_t): TX509_VERIFY_PARAM;

    function get_ALGORITHM(
    algorithm_names,
    property_definition   : PUTF8Char;
    _implementation       : POSSL_DISPATCH
    {algorithm_description : PUTF8Char}):  TOSSL_ALGORITHM; overload;

    function get_ALGORITHM(
    algorithm_names,
    property_definition   : PUTF8Char;
    _implementation       : POSSL_DISPATCH;
    algorithm_description : PUTF8Char):  TOSSL_ALGORITHM;overload;

    function get_ERR_STRING_DATA(error : Cardinal; _string : PUTF8Char): TERR_STRING_DATA ;
    function get_EVP_CIPHER(
        nid: Integer;
        block_size: Integer;
        key_len: Integer;
        iv_len: Integer;
        flags: Cardinal;
        origin: Integer;
        init: Tinit_func;
        do_cipher: Tdo_cipher_func;
        cleanup: Tevp_cipher_cleanup_func;
        ctx_size: Integer;
        set_asn1_parameters: Tset_asn1_parameters_func;
        get_asn1_parameters: Tget_asn1_parameters_func;
        ctrl: Tctrl_func;
        app_data: Pointer): TEVP_CIPHER;

function strrchr( s : PUTF8Char; c : UTF8Char):PUTF8Char;
function get_ENGINE_CMD_DEFN(
    cmd_num: Cardinal;
    cmd_name: PUTF8Char;
    cmd_desc: PUTF8Char;
    cmd_flags: Cardinal
  ): TENGINE_CMD_DEFN;

function strndup(const s : PUTF8Char; n : size_t):PUTF8Char;
function strnlen(const str : PUTF8Char; maxlen : size_t):size_t;

{$IFNDEF FPC}
function InterlockedExchangeAdd64(var Addend: Int64; Value: Int64): Int64; stdcall; {$IFDEF Win64}{$ENDIF Win64}
{$EXTERNALSYM InterlockedExchangeAdd64}
{$ENDIF}

//function memset(dst: Pointer; c : integer; n : size_t):Pointer;
function isprint( c : integer):integer;  overload;
Function isprint(ch : AnsiChar) : Boolean; overload;
function strdup(const s : PUTF8Char):PUTF8Char;
function memcpy(Dest: Pointer; const source: Pointer; count: Integer): Pointer;
function StrSize(str: PUTF8Char): int;
function StrToBytes(const Val: UnicodeString): TBytes; overload;
function StrToBytes(const Val: AnsiString): TBytes; overload;
function BytesToStr(const Value: TBytes): String;
Function Is_Digit( ch: UTF8Char ): Boolean;
function memset(_para1:pointer; _para2:longint; _para3:size_t):pointer;cdecl;external 'msvcrt.dll' name 'memset';
Function tolower(ch : AnsiChar) : AnsiChar;
Function isdigit(ch : AnsiChar) : Boolean;
Function isupper(ch : AnsiChar) : Boolean;
procedure print_bn_ctx(ctx : PBN_CTX);
function _time( tm : Ptime_t):time_t;
function BoolToInt(condition: boolean): int;

implementation

function _time(tm : Ptime_t):time_t;
var
  t: time_t;
begin
   t := DateTimeToUnix(Now);
   if tm <> nil then
      tm^ :=  t;
   Exit(t);
end;

procedure print_bn_ctx(ctx : PBN_CTX);
var
  i: int;
begin
   for I := 0 to High(ctx.pool.current.vals) do
   begin
       Writeln(Format('current.vals[%d]:  top: %d dmax: %d neg: %d',
               [I, ctx.pool.current.vals[i].top, ctx.pool.current.vals[i].dmax,
                ctx.pool.current.vals[i].neg] ));
       if ctx.pool.current.vals[i].neg < 0 then
          raise Exception.Create('Error Message');
   end;
   Writeln('=================================================================');
   Writeln('');
end;

Function isalnum(ch : AnsiChar) : Boolean;
Begin
  Result := isalpha(ch) or isdigit(ch);
End;

Function iscntrl(ch : AnsiChar) : Boolean;
Begin
  Result := ch in [#$00..#$1f,#$7f];
End;

Function isdigit(ch : AnsiChar) : Boolean;
Begin
  Result := ch in ['0'..'9'];
End;

Function isgraph(ch : AnsiChar) : Boolean;

Begin
  Result := ch in [#$21..#$7e];
End;

Function islower(ch : AnsiChar) : Boolean;

Begin
  Result := ch in ['a'..'z'];
End;

Function isprint(ch : AnsiChar) : Boolean;
Begin
  Result := ch in [#$20..#$7e];
End;

Function ispunct(ch : AnsiChar) : Boolean;

Begin
  Result := isprint(ch) And (not (isspace(ch) or isalnum(ch)));
End;

Function isupper(ch : AnsiChar) : Boolean;
Begin
  Result := ch in ['A'..'Z'];
End;

Function isxdigit(ch : AnsiChar) : Boolean;

Begin
  Result := ch in ['0'..'9','a'..'f','A'..'F'];
End;

Function toupper(ch : AnsiChar) : AnsiChar;

Begin
  Result := upcase(ch);
End;

Function tolower(ch : AnsiChar) : AnsiChar;

Begin
  Result := ch;
  If isAlpha(ch) Then
  Begin
    Result := AnsiChar(Byte(Upcase(ch))+(Byte('a')-Byte('A')));
  End;
End;


Function Is_Digit( ch: UTF8Char ): Boolean;
Begin
  Result := Cardinal(Ord(Ch) - ord('0')) < 10;
End;

//https://stackoverflow.com/questions/30371464/how-to-convert-unicode-strings-to-bytes-array-and-vice-versa-on-delphi-2007
{Since a WideString is UTF-16 encoded, and you want a UTF-16 encoded byte array,
no conversion is needed. You can perform a direct memory copy like this:}
function StrToBytes(const Val: AnsiString): TBytes;
var
  len: int;
begin

  len := Length(Val) + 1;
  SetLength(Result, len);
  if Length(Result) > 0 then
     Move(Val[1], Result[0], Length(Result));
  //Result := BytesOf(Val);
end;

function StrToBytes(const Val: UnicodeString): TBytes;
var
  len: int;
begin
  len := (Length(Val) + 1) * SizeOf(WideChar);
  SetLength(Result, len);
  if Length(Result) > 0 then
     Move(Val[1], Result[0], Length(Result));
  //Result := BytesOf(Val);

end;

function BytesToStr(const Value: TBytes): String;
begin
  SetLength(Result, Length(Value) div Char_Size);
  if Length(Result) > 0 then
    Move(Value[0], Result[1], Length(Value));
end;

function StrSize(str: PUTF8Char): int;
begin
  Result := (StrLen(str) + 1) * Char_Size;
end;

function memcpy(Dest: Pointer; const source: Pointer; count: Integer): Pointer;
begin
   move(Source^,Dest^, Count);
   Result := Dest;
end;

function strdup(const s : PUTF8Char):PUTF8Char;
begin
  { allocate a copy of a string }
  Result := malloc(StrSize(s));
  if (s = nil) or  (Result = nil) then
    Result := nil
  else
    Result := strcpy(Result, s);
end;


function strnlen(const str : PUTF8Char; maxlen : size_t):size_t;
var
  p: PUTF8Char;
begin
    p := str;
    while (PostDec(maxlen) <> 0)  and  (p^ <> #0) do
       Inc(p) ;
    Result := p - str;
end;


function strndup(const s : PUTF8Char; n : size_t):PUTF8Char;
var
  len : size_t;
  new : PUTF8Char;
begin
  len := strnlen (s, n);
  new := PUTF8Char(malloc (len* Char_Size + Char_Size));
  if new = nil then
     Exit(nil);
  new[len] := #0;
  Result := PUTF8Char(memcpy (new, s, len));
end;

{ TTypeInfo }
class procedure TType_Info.Empty<T>(param: T);
var
  Info: PTypeInfo;
begin
  Info := TypeInfo(T);
  if Info.Kind = tkPointer then
  begin
     param := default(T);
  end;
end;

class function TType_Info.GetTypeKind<T>(const param: T): TTypeKind;
var
  Info: PTypeInfo;
begin
  Info := TypeInfo(T);
  Result := info.Kind;
end;

function isprint( c : integer):integer;
begin
  {
   * Depends on ASCII character values.
   }
  Result := get_result( (c >= Ord(' '))  and  (c <= Ord('~'))  , 1 , 0);
end;

class function conf_st.Empty: conf_st;
begin
  Result := Default(conf_st);
end;

{$IFNDEF FPC}
function InterlockedExchangeAdd64;
begin
  Result := AtomicIncrement(Addend, Value) - Value;
end;
{$ENDIF}

function get_ENGINE_CMD_DEFN(
    cmd_num: Cardinal;
    cmd_name: PUTF8Char;
    cmd_desc: PUTF8Char;
    cmd_flags: Cardinal
  ): TENGINE_CMD_DEFN;
begin
   Result.cmd_num:= cmd_num;
    Result.cmd_name:=cmd_name;
    Result.cmd_desc:= cmd_desc;
    Result.cmd_flags:= cmd_flags;
end;


function strrchr( s : PUTF8Char; c : UTF8Char):PUTF8Char;
var
  ch : UTF8Char;
  sc : PUTF8Char;
begin
  { find last occurrence of c in char s[] }
   ch := (c);
  sc := nil;//0;
  while true do
  begin   { check another PUTF8Char }
    if s^ = ch then
       sc := s;
    if s^ = #0 then
       Exit(sc);
    Inc(s);
  end;
end;

function get_EVP_CIPHER(
    nid: Integer;
    block_size: Integer;
    key_len: Integer;
    iv_len: Integer;
    flags: Cardinal;
    origin: Integer;
    init: Tinit_func;
    do_cipher: Tdo_cipher_func;
    cleanup: Tevp_cipher_cleanup_func;
    ctx_size: Integer;
    set_asn1_parameters: Tset_asn1_parameters_func;
    get_asn1_parameters: Tget_asn1_parameters_func;
    ctrl: Tctrl_func;
    app_data: Pointer): TEVP_CIPHER;
begin
    Result := default(TEVP_CIPHER);
    Result.nid :=  nid;
    Result.block_size :=  block_size;
    Result.key_len :=  key_len;
    Result.iv_len :=  iv_len;
    Result.flags :=  flags;
    Result.origin :=  origin;
    Result.init :=  init;
    Result.do_cipher :=  do_cipher;
    Result.cleanup :=  cleanup;
    Result.ctx_size :=  ctx_size;
    Result.set_asn1_parameters :=  set_asn1_parameters;
    Result.get_asn1_parameters :=  get_asn1_parameters;
    Result.ctrl :=  ctrl;
    Result.app_data := app_data;
end;

function get_ERR_STRING_DATA(error : Cardinal; _string : PUTF8Char): TERR_STRING_DATA ;
begin
   Result.error := error;
   Result._string := _string;
end;

function get_ALGORITHM(
    algorithm_names,
    property_definition   : PUTF8Char;
    _implementation       : POSSL_DISPATCH;
    algorithm_description : PUTF8Char):  TOSSL_ALGORITHM;
begin
    Result.algorithm_names       := algorithm_names;
    Result.property_definition   := property_definition;
    Result._implementation       := _implementation;
    Result.algorithm_description := algorithm_description;
end;

function get_ALGORITHM(
    algorithm_names,
    property_definition   : PUTF8Char;
    _implementation       : POSSL_DISPATCH
    {algorithm_description : PUTF8Char}):  TOSSL_ALGORITHM;
begin
    Result.algorithm_names       := algorithm_names;
    Result.property_definition   := property_definition;
    Result._implementation       := _implementation;
    //Result.algorithm_description
end;

procedure ocb_block16_xor(in1,in2,_out: POCB_BLOCK);
begin
    _out.a[0] := (in1).a[0] xor (in2).a[0];
    _out.a[1] := (in1).a[1] xor (in2).a[1];
end;

function get_X509_VERIFY_PARAM(
    name: PUTF8Char;
    check_time: Longint;
    inh_flags: UInt32;
    flags: Cardinal;
    purpose: Integer;
    trust: Integer;
    depth: Integer;
    auth_level: Integer;
    policies: Pstack_st_ASN1_OBJECT;
    hosts: Pstack_st_OPENSSL_STRING;
    hostflags: Cardinal;
    peername: PUTF8Char;
    email: PUTF8Char;
    emaillen: size_t;
    ip: PByte;
    iplen: size_t): TX509_VERIFY_PARAM;
begin
    Result.name :=name;
    Result.check_time := check_time;
    Result.inh_flags := inh_flags;
    Result.flags := flags;
    Result.purpose := purpose;
    Result.trust := trust;
    Result.depth := depth;
    Result.auth_level := auth_level;
    Result.policies := policies;
    Result.hosts := hosts;
    Result.hostflags := hostflags;
    Result.peername := peername;
    Result.email := email;
    Result.emaillen := emaillen;
    Result.ip := ip;
    Result.iplen := iplen;
end;

function get_X509_TRUST(
    trust: Integer;
    flags: Integer;
    check_trust: Tcheck_trust_func;
    name: PUTF8Char;
    arg1: Integer;
    arg2: Pointer):  TX509_TRUST;
begin
   Result.trust        := trust;
    Result.flags       := flags;
    Result.check_trust := check_trust;
    Result.name        := name;
    Result.arg1        := arg1;
    Result.arg2        := arg2;
end;


function get_x509_purpose(
    purpose: Integer;
    trust: Integer;
    flags: Integer;
    check_purpose: Tcheck_purpose_func;
    name: PUTF8Char;
    sname: PUTF8Char;
    usr_data: Pointer): TX509_PURPOSE;
begin
   Result.purpose        := purpose;
    Result.trust         := trust;
    Result.flags         := flags;
    Result.check_purpose := check_purpose;
    Result.name          := name;
    Result.sname         := sname;
    Result.usr_data      := usr_data;
end;

function get_ASN1_AUX(
    app_data: Pointer;
    flags: Integer;
    ref_offset: Integer;
    ref_lock: Integer;
    asn1_cb: TASN1_aux_cb;
    enc_offset: Integer;
    asn1_const_cb: TASN1_aux_const_cb): TASN1_AUX;
begin
    Result.app_data      := app_data;
    Result.flags         := flags;
    Result.ref_offset    := ref_offset;
    Result.ref_lock      := ref_lock;
    Result.asn1_cb       := asn1_cb;
    Result.enc_offset    := enc_offset;
    Result.asn1_const_cb := asn1_const_cb;
end;
//https://code.woboq.org/gcc/libiberty/strtol.c.html
function strtol(const nptr : PUTF8Char; endptr : PPUTF8Char; base : integer):long;
var
  s : PUTF8Char;
  acc : Cardinal;
  c : int;
  cutoff : Cardinal; //4294967295
  neg, any, cutlim : integer;
begin
         s := nptr;
         neg := 0;
        {
         * Skip white space and pick up leading +/- sign if any.
         * If base is 0, allow $ for hex and 0 for octal, else
         }

        repeat
           c := Ord(PostInc(s)^);
        until not ISSPACE(UTF8Char(c));

        if c = Ord('-') then
        begin
            neg := 1;
            c := Ord(PostInc(s)^);
        end
        else
        if c = Ord('+') then
           c := Ord(PostInc(s)^);
        if ( (base = 0)  or  (base = 16) )  and
           (c = Ord('0'))  and  ( (s^ = 'x')  or  (s^ = 'X') ) then
        begin
                c := Ord(s[1]);
                s  := s + 2;
                base := 16;
        end;
        if base = 0 then
           base := get_result(c = Ord('0') , 8 , 10);
        {
         * Compute the cutoff value between legal numbers and illegal
         * numbers.  That is the largest legal value, divided by the
         * base.  An input number that is greater than this value, if
         * followed by a legal input character, is too big.  One that
         * between valid and invalid numbers is then based on the last
         * digit.  For instance, if the range for longs is
         * [-2147483648..2147483647] and the input base is 10,
         * cutoff will be set to 214748364 and cutlim to either
         * 7 (neg=0) or 8 (neg=1), meaning that if we have accumulated
         * a value > 214748364, or equal but the next digit is > 7 (or 8),
         * the number is too big, and we will return a range error.
         *
         * Set any if any `digits' consumed; make it negative to indicate
         * overflow.
         }
        if neg > 0 then
           cutoff := 2147483648 {-1*LONG_MIN}
        else
           cutoff :=  $7FFFFFFF{LONG_MAX};
        cutlim := cutoff mod ulong(base);
        cutoff  := cutoff  div (ulong(base));
        acc := 0; any := 0;

        while true do
        begin
            c := Ord(PostInc(s)^);
            if ISDIGIT(AnsiChar(c)) then
               c  := c - Ord('0')
            else
            if ISALPHA(UTF8Char(c)) then
               c  := c - get_result(ISUPPER(AnsiChar(c)) , Ord('A') - 10 , Ord('a') - 10)
            else
               break;
            if c >= base then
               break;
            if (any < 0)  or  (acc > cutoff)  or ( (acc = cutoff)  and  (c > cutlim) ) then
                    any := -1
            else
            begin
                    any := 1;
                    acc  := acc  * base;
                    acc  := acc + c;
            end;

        end;
        if any < 0 then
        begin
           if neg > 0 then
              acc :=  $80000000 {LONG_MIN}
           else
              acc := $7FFFFFFF{LONG_MAX};
                //errno := ERANGE;
        end
        else
        if (neg>0) then
           acc := -acc;
        if endptr <> nil then
        begin
           if any > 0 then
              endptr^ := {PUTF8Char}( s - 1)
           else
              endptr^ := nptr;
        end;
        Result := acc;
end;




function get_ENUMERATED_NAMES(bitnum: Integer; lname: PUTF8Char; sname: PUTF8Char ): TENUMERATED_NAMES;
begin
    Result.bitnum := bitnum;
    Result.lname  := lname;
    Result.sname  := sname;
end;

{
function strlen(const s : PUTF8Char):size_t;
var
  sc : PUTF8Char;
begin
  // find length of s[]
  sc := s;
  while sc^ <> #0 do
      Inc(sc);

  Exit(sc - s);
end;
}
function strstr(s1, s2 : PUTF8Char):PUTF8Char;
var
  sc1, sc2: PUTF8Char ;
begin
  { find first occurrence of s2[] in s1[] }
  if s2^ = #0 then
     Exit(PUTF8Char(s1));
  s1 := strchr(s1, s2^);
  while s1 <> nil do
  begin   { match rest of prefix }

    while True do
    begin
      sc1 := s1; sc2 := s2;
      if PreInc(sc2)^ = #0  then
         Exit(PUTF8Char(s1))
      else
      if (PreInc(sc1)^ <> sc2^) then
          break;
    end;

    Inc(s1);
  end;
  Exit((0));
end;

function get_V3_EXT_METHOD(
    ext_nid: Integer;
    ext_flags: Integer;
    it: TASN1_ITEM_EXP;
    ext_new: TX509V3_EXT_NEW;
    ext_free: TX509V3_EXT_FREE;
    d2i: TX509V3_EXT_D2I;
    i2d: TX509V3_EXT_I2D;
    i2s: TX509V3_EXT_I2S;
    s2i: TX509V3_EXT_S2I;
    i2v: TX509V3_EXT_I2V;
    v2i: TX509V3_EXT_V2I;
    i2r: TX509V3_EXT_I2R;
    r2i: TX509V3_EXT_R2I;
    usr_data: Pointer): V3_EXT_METHOD;
begin
    Result.ext_nid  := ext_nid;
    Result.ext_flags:= ext_flags;
    Result.it       := it;
    Result.ext_new  := EXT_NEW;
    Result.ext_free := EXT_FREE;
    Result.d2i      := D2I;
    Result.i2d      := I2D;
    Result.i2s      := I2S;
    Result.s2i      := S2I;
    Result.i2v      := I2V;
    Result.v2i      := V2I;
    Result.i2r      := I2R;
    Result.r2i      := R2I;
    Result.usr_data := usr_data;
end;

function IsTextFile(const sFile: TFileName): boolean;
//Created By Marcelo Castro - from Brazil

var
 oIn: TFileStream;
 iRead: Integer;
 iMaxRead: Integer;
 iData: Byte;
 dummy:string;
begin
   result:=true;
   dummy :='';
   oIn := TFileStream.Create(sFile, fmOpenRead or fmShareDenyNone);
   try
     iMaxRead := 1000;  //only text the first 1000 bytes
     if iMaxRead > oIn.Size then
       iMaxRead := oIn.Size;
     for iRead := 1 to iMaxRead do
     begin
       oIn.Read(iData, 1);
       if (idata) > 127 then result:=false;
     end;
   finally
     FreeAndNil(oIn);
   end;
end;

function get_last_sys_error: int;
begin
    GetLastError()
end;
(*
function _wfopen(const AFileName: string; Mode: Word): PFile;
begin
   Result := TFileStream.Create(AFileName, mode);
end;


function fileno(_file: PFILE): THandle;
begin
   if _file <> nil then
   begin
     if _file.Handle <> INVALID_HANDLE_VALUE then
        Result := _file.Handle
     else
        Result := 0;   
   end;  
      
end;

function ftell(_file: PFILE): int64;
begin
   Result := _file.Position;
end;

function feof(_file: PFILE): int;
begin
   Result := int(_file.Position >= _file.Size);
end;
  
function fseek(_file: PFILE; const Offset: Int64; Origin: TSeekOrigin): Longint;
begin
  Result := _file.Seek(Offset, Origin)
end;  

function fwrite(Buffer: PUTF8Char; ElementSize, ElementCount: Longint; _file: PFILE): Longint;
begin
   Result := _file.Write(Buffer, ElementSize * ElementCount);
end;

function ferror(_file: PFILE): int;
begin
   Result := int(_file.Handle = INVALID_HANDLE_VALUE);
end;

function fread(Buffer: PUTF8Char; ElementSize, ElementCount: Longint; _file: PFILE): Longint;
begin
   Result := _file.Read(Buffer, ElementSize * ElementCount);
end;



procedure fclose(_file: PFILE);
begin
   if _file <> nil then
   begin
      _file.Free;
   end;
end;

function fopen(const AFileName: string; Mode: Word): PFile;
begin
   Result := TFileStream.Create(AFileName, mode);
end;

*)

function get_BIGNUM(
    d: PBN_ULONG;
    top: Integer;
    dmax: Integer;
    neg: Integer;
    flags: Integer): TBIGNUM;
begin
   Result.d := d;
   Result.top := top;
   Result.dmax := dmax;
   Result.neg := neg;
   Result.flags := flags;
end;

function Create_ASN1_OBJECTS(objs: array of TASN1_OBJECT): TArray<TASN1_OBJECT>;
var
  i: Integer;
begin
   SetLength(Result, Length(objs));
   for i:=Low(objs) to High(objs) do
      Result[i] := objs[i];
end;

function get_ASN1_OBJECT(
    sn: PUTF8Char;
    ln: PUTF8Char;
    nid: Integer;
    length: Integer;
    data: PByte;
    flags: Integer): TASN1_OBJECT;
begin
    Result.sn :=  sn;
    Result.ln :=  ln;
    Result.nid :=  nid;
    Result.length :=  length;
    Result.data :=  data;
    Result.flags :=  flags;
end;

//https://opensource.apple.com/source/xnu/xnu-2782.30.5/bsd/libkern/memchr.c.auto.html
function memchr(const bigptr: PUTF8Char; ch : UTF8Char; len : size_t): Pointer;
var
  n : size_t;
  big: PUTF8Char;
begin
  big := PUTF8Char(bigptr);
  for n := 0 to len-1 do
    if big[n] = ch then
	   Exit(Pointer(@big[n]));
  Result := nil;
end;

function memchr(const bigptr: PByte; ch : Byte; len : size_t): Pointer;
var
  n : size_t;
  big: PByte;
begin
  big := (bigptr);
  for n := 0 to len-1 do
    if big[n] = ch then
	   Exit(Pointer(@big[n]));
  Result := nil;
end;

function get_EVP_PBE_CTL(
     pbe_type,
     pbe_nid,
     cipher_nid,
     md_nid     : integer;
     keygen     : TEVP_PBE_KEYGEN;
     keygen_ex  : TEVP_PBE_KEYGEN_EX
  ):  TEVP_PBE_CTL;
begin
   Result.pbe_type := pbe_type;
   Result.pbe_nid    := pbe_nid;
   Result.cipher_nid := cipher_nid;
   Result.md_nid     := md_nid;
   Result.keygen     := keygen;
   Result.keygen_ex  := keygen_ex;
end;

function get_ASN1_ADB_TABLE(value: Integer; tt: TASN1_TEMPLATE): TASN1_ADB_TABLE;
begin
   Result.value := value;
   Result.tt := tt;
end;

function get_ASN1_ADB(
    flags: Cardinal;
    offset: Cardinal;
    adb_cb: Tadb_cb_func;
    tbl: PASN1_ADB_TABLE;
    tblcount: Integer;
    default_tt: PASN1_TEMPLATE;
    null_tt: PASN1_TEMPLATE): TASN1_ADB;
begin
   Result.flags := flags;
   Result.offset := offset;
   Result.adb_cb := adb_cb;
   Result.tbl := tbl;
   Result.tblcount := tblcount;
   Result.default_tt := default_tt;
   result.null_tt := null_tt;
end;

function get_ASN1_TEMPLATE(
    flags: Cardinal;
    tag: Integer;
    offset: Cardinal;
    field_name: PUTF8Char;
    item: TASN1_ITEM_EXP
  ): TASN1_TEMPLATE;
begin
  Result.flags      := flags;
  Result.tag        := tag;
  Result.offset     := offset;
  Result.field_name := field_name;
  Result.item       := item;
end;

function get_ASN1_ITEM(
    itype: Byte;
    utype: long;
    templates: PASN1_TEMPLATE;
    tcount: long;
    funcs: Pointer;
    size: long;
    sname: PUTF8Char):TASN1_ITEM;
begin
    Result.itype     := itype;
    Result.utype     := utype;
    Result.templates := templates;
    Result.tcount    := tcount;
    Result.funcs     := funcs;
    Result.size      := size;
    Result.sname     := sname;
end;

class function TMyCastMethod.Cast<TFrom, TTo>(AFrom: TMyFunc<TFrom>): TMyFunc<TTo>;
var
  vMethod: TMethod;
begin
  vMethod := TMethod(AFrom);
  Result := TMyFunc<TTo>(vMethod);
end;

function Rotr64( Shift: integer; x: uint64): uint64;
//{$IF CompilerVersion >= 17.0}  {$ENDIF}
begin
   result := (x shr Shift) or (x shl (64 - Shift))
end;

function Rotr32( Shift: integer; x: uint32): uint32;
//{$IF CompilerVersion >= 17.0}  {$ENDIF}
begin
   result := (x shr Shift) or (x shl (32 - Shift))
end;



function U64(C: Int64): uint64;
begin
  Result := UInt64(C);
end;

function SC_LIMB1(x: Uint64): uint32;
begin
   Result := uint32_t(x);
end;

function SC_LIMB2(x: Uint64): uint32;
begin
   Result := (x) shr 32;
end;

function PByte2ArrayByte(p1: PByte; len: Byte): TArray<Byte>;
var
  I: Byte;
begin
   SetLength(Result, len);
   for I := 0 to len -1 do
   begin
     Result[I] := p1^;
     Inc(p1);
   end;
end;

function PostInc(var p: POSSL_PARAM): POSSL_PARAM;
begin
   Result := p;
   Inc(p);
end;

function PostInc(var p: PByte): PByte;
begin
   Result := p;
   Inc(p);
end;

function get_result(condition: Boolean;result1, result2: PUTF8Char): PUTF8Char;
begin
   if condition then
      Result := result1
   else
      Result := result2;
end;

function get_result(condition: Boolean;result1, result2: UTF8char): UTF8char;
begin
   if condition then
      Result := result1
   else
      Result := result2;
end;

function get_result(condition: Boolean;result1, result2: PByte): PByte;
begin
   if condition then
      Result := result1
   else
      Result := result2;
end;

function RAND_POOL_MIN_ALLOCATION(secure: int): int;
begin
   Result := get_result((secure>0) , 16 , 48)
end;

procedure PUTU32(p: PByte; v: UInt32);
begin
    (p)[0] := uint8((v) shr 24);
    (p)[1] := uint8((v) shr 16);
    (p)[2] := uint8((v) shr 8);
    (p)[3] := uint8(v);
end;

function GETU32( p : PByte):uint32;
begin
   Result := uint32(p[0]) shl 24 or uint32(p[1]) shl 16 or uint32(p[2]) shl 8 or uint32(p[3]);
end;

function strcpy(s1 : PUTF8Char; const s2 : PUTF8Char):PUTF8Char;
begin
  Result := StrCopy(s1, s2);
  {
  while s2^ <> #0 do
  begin
     s1^ := s2^;
     inc (s1);
     Inc(s2);
  end;
  Exit((s1));}
end;


function PreInc(var s: PUTF8Char): PUTF8Char;
begin
   Inc(s);
   Result := s;
end;

function PreInc(var s: int): int;
begin
   Inc(s);
   Result := s;
end;

function PreInc(var s: size_t): size_t;
begin
   Inc(s);
   Result := s;
end;

function strncasecmp(s1, s2:PUTF8Char; len: UInt32): Integer;
var
  str1, str2: string;
begin
  str1 := LowerCase(Copy(s1, 0, len));
  str2 := LowerCase(Copy(s2, 0, len));
  if str1 = str2 then
     Result := 0
  else
     Result := 1;

end;

//https://opensource.apple.com/source/xnu/xnu-201/osfmk/kern/sscanf.c.auto.html
function sscanf(str, format : PUTF8Char; args: array of const):integer;
var
    start    : PUTF8Char;
    positive,
    value    : integer;
    valp     : PInteger;
begin
  start := str;

  while format^ <> #0 do
  begin
    if (format^ = '%')  and  (format[1] = 'd') then
    begin
      if str^ = '-' then
      begin
        positive := 0;
        Inc(str);
      end
      else
        positive := 1;
      if  not isdigit(str^) then
          break;
      value := 0;
      repeat
        value := (value * 10) - ( Ord(str^) - Ord('0') );
        Inc(str);
      until not isdigit(str^);
      if positive > 0 then
         value := -value;
      valp := va_arg(args, TypeInfo(PInteger) );
      valp^ := value;
      Inc(format);
    end
    else
    if ( format^ = str^) then
    begin
      Inc(str);
    end
    else
      break;
    Inc(format) ;
  end;

  Result := str - start;
end;

function strchr(const src : PAnsiChar; c : AnsiChar):PAnsiChar;
var
  ch : AnsiChar;
  s: PansiChar;
begin
  { find first occurrence of c in Char  s[] }
  s := src;
  ch := c;
  While s^ <> ch do
  begin
    if s^ = #0 then Exit((nil));
    Inc(s);
  end;
  Exit(PAnsiChar(s));
end;

function strchr(s : PWideChar;const c : WideChar):PWideChar;
var
  ch : WideChar;
begin
  { find first occurrence of c in AnsiChar  s[] }
  ch := c;
  While s^ <> ch do
  begin
    if s^ = #0 then Exit((nil));
    Inc(s);
  end;
  Exit(s);
end;

function va_arg(ArgsList: array of const; tp: Pointer): Pointer;
var
{$IFNDEF FPC}
 ArgsListTyped : array [0..$fff0 div sizeof(TVarRec)] of TVarRec absolute ArgsList;
{$ENDIF}
 n : integer;
 Info: PTypeInfo;

  //Data: PTypeData;
  //KindName: String;

begin
   Info:= tp;
   //KindName := GetEnumName(System.TypeInfo(TTypeKind), Ord(Info^.Kind));
   for n := gIndex to High( ArgsList ) do
  begin
    with {$IFNDEF FPC} ArgsListTyped[n] {$ELSE} TVarRec(ArgsList[n]) {$ENDIF} do
    begin
      case VType of
        vtInt64     :
        begin
          {handle VInt64 here}
           //if tkInt64 = Info^.Kind then
           begin
              Result := VInt64;
              Inc(gIndex);
              Break;

           end;
        end;
        
        vtInteger   :
        begin
           {handle VInteger here}
           if tkInteger = Info^.Kind then// TypeNames[VType] then
           begin
              {$IFNDEF FPC}
              Result := @VInteger;
              {$ELSE}
              gIntVal := VInteger;
              Result := @gIntVal;
              {$ENDIF}
              Inc(gIndex);
              Break;

           end;

        end;
        vtBoolean   :
        begin
          {handle VBoolean here}
          Result := @VBoolean;
          Inc(gIndex);
          Break;
        end;
        vtChar      :
        begin
          {handle VChar here}
          if (tkChar = Info^.kind) then
          begin
             PAnsiChar(Result)^ := VChar;
             Inc(gIndex);
             Break;
          end;
        end;
        vtExtended  :
        begin
          {handle VExtended here}
          if ('Extended' = Info^.Name) or
             ('Double' = Info^.Name) or
             ('Single' = Info^.Name) then
          begin
            Result := VExtended;
            Inc(gIndex);
            Break;
          end;

        end;
        vtString    :
        begin
          {handle VString here}
        end;
        vtPointer   :
        begin
          {handle VPointer here}
          Result := VPointer;
          Inc(gIndex);
          Break;
        end;
        vtPChar     :
        begin
          {handle PAnsiChar here}
          if tkPointer = Info^.kind  then
           begin
              Result := VPChar;
              Inc(gIndex);
              Break;
           end;

        end;
        vtObject    :
        begin
          {handle VObject here}
        end;
        vtClass     :
        begin
          {handle VClass here}
        end;
        vtWideChar  :
        begin
          {handle VWideChar here}
          if tkWChar = Info^.Kind then
          begin
            PWideChar(Result)^ := VWideChar;
            Inc(gIndex);
            Break;
          end;
        end;
        vtPWideChar :
        begin
          {handle VPWideChar here}
          if ('PWideChar' = Info^.Name)  then
           begin
              Result := VPWideChar;
              Inc(gIndex);
              Break;
           end;
        end;
        vtAnsiString:
        begin
          {handle VAnsiString here}
        end;
        vtCurrency  :
        begin
          {handle VCurrency here}
        end;
        vtVariant   :
        begin
          {handle VVariant here}
        end;
        else
        begin
          {handle unknown type here}
        end;
      end;
    end;
  end;
  //if gIndex {$IFDEF FPC} >= {$ELSE} > {$ENDIF} High( ArgsList ) then
   if gIndex > High( ArgsList ) then
     gIndex := 0;
end;

function strcspn(const s1, s2 : PUTF8Char):size_t;
var
  sc1, sc2 : PUTF8Char;
begin
  { find index of first s1[i] that matches any s2[] }
  sc1 := s1;
  while sc1^ <> #0 do
  begin

    sc2 := s2;
    while sc2^ <> #0 do
    begin
      if sc1^ = sc2^ then
         Exit((sc1 - s1));
      PreInc(sc2);
    end;

    PreInc(sc1);
  end;
  Result := (sc1 - s1);  { terminating nulls match }
end;

function strspn(const s1, s2 : PUTF8Char):size_t;
var
  p, spanp : PUTF8Char;
  c, sc : UTF8Char;
  label cont;
begin
  p := s1;
  {
   * Skip any characters in s2, excluding the terminating \0.
   }
cont:
  c := p^;
  Inc(p);
  spanp := s2;
  sc := spanp^;
  while sc <> #0 do
  begin
    if sc = c then
       Result := (p - 1 - s1);

    Inc(spanp);
    sc := spanp^;
  end;
end;


function IsSpace(const Ch: UTF8Char): Boolean;
begin
  Result := (Ch = #32) or (Ch = #$00A0); // Unicode non-breaking space
end;

function IsAlpha(const AChar: UTF8Char): Boolean;
begin



  // Do not use IsCharAlpha or IsCharAlphaNumeric - they are Win32 routines
  Result := ((AChar >= 'a') and (AChar <= 'z')) or ((AChar >= 'A') and (AChar <= 'Z')); {Do not Localize}
end;

function strtoul(const nptr : PUTF8Char; endptr : PPUTF8Char; base : integer):uint32;
var
  s : PUTF8Char;
  acc, cutoff : uint32;

  c, neg, any, cutlim : integer;
begin
  {
   * See strtol for comments as to the logic used.
   }
  s := nptr;
  repeat
    c := Ord(s^);
    Inc(s);
  until not isspace(UTF8Char(c));

  if c = Ord('-') then
  begin
    neg := 1;
    c := Ord(s^);
    Inc(s);
  end
  else
  begin
    neg := 0;
    if c = Ord('+') then
    begin
       c := Ord(s^);
       Inc(s);
    end;
  end;

  if ( (base = 0)  or  (base = 16) )   and
     ( c = Ord('0') ) and
     ( (s^ = 'x')  or  (s^ = 'X') )then
  begin
    c := Ord(s[1]);
    s  := s + 2;
    base := 16;
  end;
  if base = 0 then
     base := get_result( c = Ord('0') , 8 , 10);

  cutoff := ULONG_MAX div uint32(base);
  cutlim := ULONG_MAX mod uint32(base);
  acc := 0; any := 0;
  while True do
  begin
    c := Ord(s^);
    if isdigit(UTF8Char(c)) then
      c  := c - Ord('0')
    else
    if isalpha(UTF8Char(c)) then
      c  := c - get_result(isupper(UTF8Char(c)) , Ord('A') - 10 , Ord('a') - 10)
    else
      break;
    if c >= base then break;
    if any < 0 then continue;
    if (acc > cutoff)  or  ( (acc = cutoff)  and  (c > cutlim) ) then
    begin
      any := -1;
      acc := ULONG_MAX;
      //errno := ERANGE;
    end
    else
    begin
      any := 1;
      acc  := acc  * uint32(base);
      acc  := acc + c;
    end;
    Inc(s);
  end;
  if (neg  and  any) > 0 then
     acc := -acc;
  if endptr <> nil then
  begin
     if any > 0 then
       endptr^ := PUTF8Char(s - 1)
     else
       endptr^ := nptr;
  end;
  Result := (acc);
end;

function PostInc(var n: PBN_ULONG): PBN_ULONG;
begin
   Result := n;
   Inc(n);
end;

function PostInc(var n: BN_ULONG): BN_ULONG;
begin
   Result := n;
   Inc(n);
end;

function PostInc(var n: uint32): uint32;
begin
   Result := n;
   Inc(n);
end;

function PostInc(var n: PRC2_INT): PRC2_INT;
begin
   Result := n;
   Inc(n);
end;

function PostInc(var n: PIDEA_INT): PIDEA_INT;
begin
   Result := n;
   Inc(n);
end;


function PostInc(var n: Integer): Integer;
begin
   Result := n;
   Inc(n);
end;

function PostInc(var n: PAnsiChar): PAnsiChar;
begin
   Result := n;
   Inc(n);
end;

function PostInc(var n: PWideChar): PWideChar;
begin
   Result := n;
   Inc(n);
end;

function PostInc(var n: size_t): size_t;
begin
   Result := n;
   Inc(n);
end;

function strncpy(dst : PWideChar;const src : PWideChar; n : size_t):PWideChar;
var
  d, s : PWideChar;
  function IsZero: Boolean;
  begin
     d^ := s^;
     if d^ = #0 then
        Result := True
     else
        Result := False;
      Inc(d);
      Inc(s);
  end;
begin

  if n <> 0 then
  begin
    d := dst;
    s := src;

    repeat
      if IsZero then
      begin

        while PreDec(n) <> 0 do
        begin
          d^ := #0;
          Inc(d);

        end;
        break;

      end;
    until PreDec(n) = 0;

  end;
  Result := (dst);
end;

//bionic\libc\upstream-openbsd\lib\libc\string
function strncpy(dst : PUTF8Char;const src : PUTF8Char; n : size_t):PUTF8Char;
var
  d, s : PUTF8Char;
  function IsZero: Boolean;
  begin
     d^ := s^;
     if d^ = #0 then
        Result := True
     else
        Result := False;
      Inc(d);
      Inc(s);
  end;
begin

  if n <> 0 then
  begin
    d := dst;
    s := src;

    repeat
      if IsZero then
      begin

        while PreDec(n) <> 0 do
        begin
          d^ := #0;
          Inc(d);

        end;
        break;

      end;
    until PreDec(n) = 0;

  end;
  Result := (dst);
end;

function strcmp(const s1, s2 : PUTF8Char):integer;
begin
    Result := StrComp(s1, s2);
end;

//https://code.woboq.org/gcc/libiberty/strncmp.c.html
function strncmp(s1, s2 : PUTF8Char; n : size_t):integer;
var
  u1, u2 : byte;
begin
  while PostDec(n) > 0 do
    begin
      u1 := byte(s1^);
      Inc(s1);
      u2 := byte(s2^);
      Inc(s2);
      if u1 <> u2 then
        Exit(u1 - u2);
      if UTF8Char(u1) = #0 then
        Exit(0);
    end;
  Result := 0;
end;

function PreDec(var n: PByte): PByte;
begin
  Dec(n);
  Result := n;
end;

function PreDec(var n: PUTF8Char): PUTF8Char;
begin
  Dec(n);
  Result := n;
end;

function PreDec(var n: size_t): size_t;
begin
  Dec(n);
  Result := n;
end;

function PreDec(var n: PBN_ULONG): PBN_ULONG;
begin
  Dec(n);
  Result := n;
end;

function PreDec(var n: Integer): Integer;
begin
  Dec(n);
  Result := n;
end;

function PostDec(var n: UInt32): UInt32;
begin
  Result := n;
  if n > 0 then
     Dec(n);

end;

function PostDec(var n: PByte): PByte;
begin
  Result := n;
  Dec(n);
end;

function PostDec(var n: Byte): Byte;
begin
  Result := n;
  Dec(n);
end;

function PostDec(var n: PRC2_INT): PRC2_INT;
begin
  Result := n;
  Dec(n);
end;

function PostDec(var n: size_t): size_t;
begin
  Result := n;
  if n > 0 then
     Dec(n);

end;

function PostDec(var n: integer): Integer;
begin
  Result := n;
  Dec(n);

end;
//https://android.googlesource.com/toolchain/gcc/+/master/gcc-4.9/libgcc/memcmp.c
function memcmp(a, b: Pointer; c: SizeInt):integer;
{$ifndef FPC}
var
  ma,mb: PByte;
  n: Integer;
begin
  ma:=a;
  mb:=b;
  n:=0;
  while Cardinal(n)<c do
  begin
    if ma^<>mb^ then
    begin
      if ma^<mb^ then
        Result:=-1
      else
        Result:=1;
      exit;
    end;
    Inc(ma);
    Inc(mb);
    Inc(n);
  end;
  Result:=0;
{$else}
begin
  Result:=CompareMemRange(a,b,c);
{$endif}
end;

function ossl_ascii_isdigit(const inchar :Byte):integer;
begin
    if (inchar > $2F)  and  (inchar < $3A) then
       Exit(1);
    Result := 0;
end;

function get_result(condition: Boolean;result1, result2: size_t): size_t;
begin
  if condition  then
     Result := Result1
  else
     Result := Result2;
end;

function get_result(condition: Boolean;result1, result2: uint64): uint64;
begin
  if condition  then
     Result := Result1
  else
     Result := Result2;
end;


function get_result(condition: Boolean;result1, result2: uint32): uint32;
begin
  if condition  then
     Result := Result1
  else
     Result := Result2;
end;

function get_result(condition: Boolean;result1, result2: integer): integer;
begin
  if condition  then
     Result := Result1
  else
     Result := Result2;
end;

function get_result(condition: Boolean;result1, result2: PBN_ULONG): PBN_ULONG;
begin
  if condition  then
     Result := Result1
  else
     Result := Result2;
end;

function get_result(condition: Boolean;result1, result2: PBIGNUM): PBIGNUM;
begin
  if condition  then
     Result := Result1
  else
     Result := Result2;
end;


procedure Free(P: Pointer);
begin
   FreeMem(P);
end;

function malloc(Size: NativeInt): Pointer;
begin
   Result := AllocMem(Size);
end;


function strcasecmp(const s1_arg, s2_arg : PUTF8Char):integer;
var
  s1, s2 : PUTF8Char;
begin
  if (s1_arg = nil) or (s2_arg = nil) then
     exit(-1);
  s1 := (s1_arg);
  s2 := (s2_arg);
  while tolower( s1^) = tolower( s2^) do
  begin
    if (s1^ = #0) then
		  	exit (0);
    Inc(s1);Inc(s2);
  end;
  Result := get_result(Uint32(tolower(s1^)) < Uint32(tolower(s2^)), -1 , +1);

end;


initialization
  gIndex := 0;
{
!!(400) = 1  非400为0，非0为1

    !!(-200) = 1  非-200为0，非0为1

    !!(0) = 0 非0为1，非1为0

    !!(1) = 1 非1为0，非0为1
type
  PIntegerArray = ^TIntegerArray;
  TIntegerArray = array[0..65535] of Integer;
var
  Buffer: array of Integer;
  PInt: PInteger;
  PArr: PIntegerArray;
  ...
  // Using pointer arithmetic:
  PInt := @Buffer[0];
  for I := 0 to Count - 1 do
  begin
    Writeln(PInt^);
    Inc(PInt);
  end;

  // Using array pointer and indexing:
  PArr := PIntegerArray(@Buffer[0]);
  for I := 0 to Count - 1 do
    Writeln(PArr^[I]);
  ...
end;}
end.
